
SET QUOTED_IDENTIFIER ON

print 'Creating table PFOLIOUSER'

--METADATA NAME:PFOLIOUSER TYPE:TABLE CHANGE:CREATE
CREATE TABLE PFOLIOUSER(
  "pfolio_id"  integer NOT NULL,
  "user_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_pfoliouser PRIMARY KEY (pfolio_id,user_id)  )


go
--METADATA NAME:image_extension TYPE:FIELD TABLE_NAME:IMAGEDATA CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('IMAGEDATA') and column_name=upper('image_extension');
if @col_exist = 0
ALTER TABLE IMAGEDATA 
  add   "image_extension"  varchar(20) DEFAULT 'png' with values  NOT NULL
go

print 'Creating constraint fk_pfoliouser_pfolio on table PFOLIOUSER'


--METADATA NAME:fk_pfoliouser_pfolio TYPE:CONSTRAINT TABLE_NAME:PFOLIOUSER CHANGE:CREATE
ALTER TABLE PFOLIOUSER
ADD CONSTRAINT fk_pfoliouser_pfolio FOREIGN KEY (pfolio_id)
REFERENCES PFOLIO (pfolio_id) 
go

print 'Creating constraint fk_pfoliouser_users on table PFOLIOUSER'


--METADATA NAME:fk_pfoliouser_users TYPE:CONSTRAINT TABLE_NAME:PFOLIOUSER CHANGE:CREATE
ALTER TABLE PFOLIOUSER
ADD CONSTRAINT fk_pfoliouser_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go
 
--METADATA NAME:proj_catg_type TYPE:FIELD TABLE_NAME:PCATTYPE CHANGE:ALTER
ALTER TABLE PCATTYPE ALTER COLUMN proj_catg_type varchar(60) NOT NULL 
go
 
--METADATA NAME:proj_catg_type TYPE:FIELD TABLE_NAME:PCATTYPE CHANGE:ALTER 
--METADATA NAME:proj_catg_short_name TYPE:FIELD TABLE_NAME:PCATVAL CHANGE:ALTER
ALTER TABLE PCATVAL ALTER COLUMN proj_catg_short_name varchar(60) NOT NULL 
go
 
--METADATA NAME:proj_catg_short_name TYPE:FIELD TABLE_NAME:PCATVAL CHANGE:ALTER 
--METADATA NAME:intg_type TYPE:FIELD TABLE_NAME:PROJWBS CHANGE:ALTER
ALTER TABLE PROJWBS ALTER COLUMN intg_type varchar(100)
go
 
--METADATA NAME:intg_type TYPE:FIELD TABLE_NAME:PROJWBS CHANGE:ALTER 
--METADATA NAME:intg_type TYPE:FIELD TABLE_NAME:RSRC CHANGE:ALTER
ALTER TABLE RSRC ALTER COLUMN intg_type varchar(100)
go
 
--METADATA NAME:intg_type TYPE:FIELD TABLE_NAME:RSRC CHANGE:ALTER


--METADATA TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES 
---METADATA TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F12057_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go
go 
--END TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES 
---METADATA TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F12059_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go
go 
--END TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE PCATTYPE SET PROJ_CATG_SHORT_LEN=60 WHERE PROJ_CATG_TYPE='Prime Workspace'
go

--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE PCATTYPE SET PROJ_CATG_TYPE='Primavera Workspace' WHERE PROJ_CATG_TYPE='Prime Workspace'
go

--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE RSRC SET INTG_TYPE='PrimaveraCloudScope' WHERE INTG_TYPE='PrimeScope'
go

--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE PROJWBS SET INTG_TYPE='PrimaveraCloudScope' WHERE INTG_TYPE='PrimeScope'
go

go 
--END TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
delete from profpriv 
where prof_id in
(select pp.prof_id from profile p , profpriv pp
 where p.prof_id = pp.prof_id and pp.priv_num=177
and p.scope_type = 'ST_Project'
)
and priv_num in
(select pp.priv_num from profile p , profpriv pp
 where p.prof_id = pp.prof_id and pp.priv_num=177
and p.scope_type = 'ST_Project'
)
go

--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
DECLARE
  @col_exists integer,
  @image_name varchar(100),
  @image_id varchar(100)
DECLARE @cur as CURSOR
 SET @cur = CURSOR FOR
 SELECT image_id,image_name
 FROM imagedata;
 OPEN @cur;
 FETCH NEXT FROM @cur INTO @image_id,@image_name;
WHILE @@FETCH_STATUS = 0
 BEGIN
 begin try
   if NULLIF(@image_name, '') IS NOT NULL and charindex('.',@image_name)>0
	begin
    update imagedata
      set image_name =left(@image_name,len(@image_name)- charindex('.', reverse(@image_name))),
          image_extension = reverse(left(reverse(@image_name), charindex('.', reverse(@image_name)) -1))
    where image_id=@image_id;
	end;
  FETCH NEXT FROM @cur INTO @image_id,@image_name;
  end try
  begin catch
  select null
  end catch
 END 
CLOSE @cur;
DEALLOCATE @cur;
go
go 
--END TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1912to19121 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1912to19121 NAME:MISC_UPDATES
DECLARE
  @issue_notes varchar(MAX),
  @issue_id integer,
  @v_len integer
DECLARE @cur as CURSOR
 SET @cur = CURSOR FOR
 SELECT issue_id,issue_notes
 FROM projissu where issue_notes is NOT NULL;
 OPEN @cur;
 FETCH NEXT FROM @cur INTO @issue_id,@issue_notes;
WHILE @@FETCH_STATUS = 0
 BEGIN
 begin try
  set @v_len=DATALENGTH(@issue_notes);
   if @v_len IS NOT NULL  and @v_len > 0
	begin
	if (PATINDEX('%DOCTYPE%',@issue_notes)=0 or PATINDEX('%DOCTYPE%',@issue_notes) is NULL) 
	begin
    update projissu
      set issue_notes ='<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN"><HTML><HEAD><META content="text/html; charset=unicode" http-equiv=Content-Type><META name=GENERATOR content="MSHTML 11.00.10570.1001"></HEAD><BODY><SPAN style="FONT-SIZE: medium; FONT-FAMILY: serif; WHITE-SPACE: normal; WORD-SPACING: 0px; TEXT-TRANSFORM: none; FLOAT: none; FONT-WEIGHT: 400; COLOR: rgb(0,0,0); FONT-STYLE: normal; ORPHANS: 2; WIDOWS: 2; DISPLAY: inline !important; LETTER-SPACING: normal; TEXT-INDENT: 0px; font-variant-ligatures: normal; font-variant-caps: normal; -webkit-text-stroke-width: 0px; text-decoration-style: initial; text-decoration-color: initial">'+
	  @issue_notes+'</SPAN></BODY></HTML>'
    where issue_id=@issue_id;
	end;
	end;
  FETCH NEXT FROM @cur INTO @issue_id,@issue_notes;
  end try
  begin catch
  select null
  end catch
 END 
CLOSE @cur;
DEALLOCATE @cur;
go
go 
--END TYPE:UP2 GROUP:1912to19121 NAME:MISC_UPDATES
update prefer set database_version='PPMDB,1912.0006.0000.0000'
go

