
--Run Script as     
SET DEFINE OFF

prompt Creating table PFOLIOUSER

--METADATA NAME:PFOLIOUSER TYPE:TABLE CHANGE:CREATE
CREATE TABLE PFOLIOUSER(
  pfolio_id  number(10) NOT NULL,
  user_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_pfoliouser PRIMARY KEY (pfolio_id,user_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating constraint fk_pfoliouser_pfolio on table PFOLIOUSER


--METADATA NAME:fk_pfoliouser_pfolio TYPE:CONSTRAINT TABLE_NAME:PFOLIOUSER CHANGE:CREATE
ALTER TABLE PFOLIOUSER
ADD CONSTRAINT fk_pfoliouser_pfolio FOREIGN KEY (pfolio_id)
REFERENCES PFOLIO (pfolio_id) 
/

prompt Creating constraint fk_pfoliouser_users on table PFOLIOUSER


--METADATA NAME:fk_pfoliouser_users TYPE:CONSTRAINT TABLE_NAME:PFOLIOUSER CHANGE:CREATE
ALTER TABLE PFOLIOUSER
ADD CONSTRAINT fk_pfoliouser_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/



--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
DECLARE
  col_exists integer;
  cursor cur is select IMAGE_NAME ,image_id from IMAGEDATA;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('IMAGEDATA') and column_name=upper('Image_Extension');
  if col_exists > 0 then
   for i in cur loop 
    begin
      if instr(i.image_name,'.')>0 then
      execute immediate 'update imagedata
        set image_name = :1,
            image_extension = :2
      where image_id=:3' using SUBSTR(i.image_name,1,INSTR(i.image_name,'.',-1,1)-1),SUBSTR(i.image_name,INSTR(i.image_name,'.',-1,1)+1),i.image_id;  
      end if;
    exception when others then
      null;
    end;
   end loop;
  end if;
 END;
 /
 
--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
delete from profpriv pp
where exists
(select p.prof_id from profile p 
where p.prof_id = pp.prof_id and pp.priv_num=177
and p.scope_type = 'ST_Project')
/




/ 
--END TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1912to19121 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1912to19121 NAME:MISC_UPDATES
DECLARE
v_len number;
v_start_point number;
v_final blob;
cursor c is select issue_id,issue_notes 
from projissu where issue_notes is NOT NULL ;
begin
for rec in c loop
v_len := dbms_lob.getlength(rec.issue_notes);
if(v_len is not null and v_len > 0) then
v_start_point:=dbms_lob.instr(rec.issue_notes, utl_raw.cast_to_raw('DOCTYPE'));
if (v_start_point=0 or v_start_point is null) then
  dbms_lob.createtemporary(v_final, true);
  dbms_lob.append(v_final,utl_raw.cast_to_raw('<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN"><HTML><HEAD><META content="text/html; charset=unicode" http-equiv=Content-Type><META name=GENERATOR content="MSHTML 11.00.10570.1001"></HEAD><BODY><SPAN style="FONT-SIZE: medium; FONT-FAMILY: serif; WHITE-SPACE: normal; WORD-SPACING: 0px; TEXT-TRANSFORM: none; FLOAT: none; FONT-WEIGHT: 400; COLOR: rgb(0,0,0); FONT-STYLE: normal; ORPHANS: 2; WIDOWS: 2; DISPLAY: inline !important; LETTER-SPACING: normal; TEXT-INDENT: 0px; font-variant-ligatures: normal; font-variant-caps: normal; -webkit-text-stroke-width: 0px; text-decoration-style: initial; text-decoration-color: initial">'));
  dbms_lob.append(v_final, rec.issue_notes);
  dbms_lob.append(v_final,utl_raw.cast_to_raw('</SPAN></BODY></HTML>'));
  execute immediate 'update projissu set issue_notes = :1 where issue_id= :2' using v_final,rec.issue_id;
commit;
end if;
end if;
end loop;
dbms_lob.freetemporary(v_final);
dbms_lob.close(v_final);
EXCEPTION
 WHEN OTHERS THEN
  NULL;
end;
/
/ 
--END TYPE:UP2 GROUP:1912to19121 NAME:MISC_UPDATES
update prefer set database_version='PPMDB,1912.0006.0000.0000'
/
commit
/