--METADATA NAME:ss_disable_truncate_schema TYPE:EXEC

Set NoCount ON

Declare @tName varchar(200)
Declare @tOwner varchar(200)
Declare @skipident varchar(3)
Declare @identInitValue int

set @tName = ''
set @tOwner = ''
set @skipident = 'NO'
set @identInitValue=1


exec sp_MSforeachtable 'ALTER TABLE ? NOCHECK CONSTRAINT ALL'
exec sp_MSforeachtable 'ALTER TABLE ? DISABLE TRIGGER ALL'

Declare foreign_key_cursor CURSOR
	FOR SELECT T.table_schema, T.table_name from INFORMATION_SCHEMA.TABLES T
		left outer join INFORMATION_SCHEMA.TABLE_CONSTRAINTS TC
		on T.table_name=TC.table_name where (TC.constraint_Type ='Foreign Key'
		or TC.constraint_Type is NULL) and
		T.table_name not in ('dtproperties','sysconstraints','syssegments')
		and Table_type='BASE TABLE' and T.table_name > @tName
		order by t.table_name
OPEN foreign_key_cursor 

	
FETCH NEXT FROM foreign_key_cursor 
INTO @tOwner, @tName
	
WHILE @@FETCH_STATUS = 0 
BEGIN

	Exec('DELETE FROM ' + @tOwner + '.' + @tName)
		
	FETCH NEXT FROM foreign_key_cursor 
	INTO @tOwner, @tName	
END
CLOSE foreign_key_cursor
DEALLOCATE foreign_key_cursor

-----

set @tName=''
set @tOwner=''

Declare primary_key_cursor CURSOR
	FOR Select T.table_schema, T.table_name 
		FROM INFORMATION_SCHEMA.TABLES T left outer join INFORMATION_SCHEMA.TABLE_CONSTRAINTS TC
			on T.table_name=TC.table_name 
		WHERE TC.constraint_Type ='Primary Key'
			and T.table_name <>'dtproperties'and Table_type='BASE TABLE'
			and T.table_name > @tName
		order by t.table_name
OPEN primary_key_cursor 


FETCH NEXT FROM primary_key_cursor 
	INTO @tOwner, @tName 	
	
WHILE @@FETCH_STATUS = 0 
BEGIN
	
	Exec('DELETE FROM ' + @tOwner + '.' + @tName)
	
	FETCH NEXT FROM primary_key_cursor 
	INTO @tOwner, @tName 	
END
CLOSE primary_key_cursor
DEALLOCATE primary_key_cursor
GO
