--METADATA NAME:dbtk_or_set_currency TYPE:EXEC
Declare
v_curr_rate CURRTYPE.base_exch_rate%TYPE;
v_old_curr_id CURRTYPE.curr_id%TYPE;
v_new_curr_id CURRTYPE.curr_id%TYPE;
v_existing_base_currency varchar2(25);
v_new_base_currency varchar2(25);
begin
v_existing_base_currency := 'USD';
v_new_base_currency := 'USD';
if (v_existing_base_currency <> v_new_base_currency) then
    select base_exch_rate, curr_id
      into v_curr_rate, v_new_curr_id
      from currtype
     where curr_short_name = v_new_base_currency;
    select curr_id
      into v_old_curr_id
      from currtype
     where curr_short_name = v_existing_base_currency;
    update currtype
       set curr_id = v_new_curr_id
     where curr_id = v_old_curr_id;
    update currtype
       set curr_id = v_old_curr_id
     where curr_short_name = v_new_base_currency;
    update currtype set base_exch_rate = base_exch_rate / v_curr_rate;
  end if;
exception 
 when NO_DATA_FOUND then
      dbms_output.put_line('Specified currency does not exist');
 when OTHERS then 
      dbms_output.put_line(SQLERRM);
end;
/
