<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml" encoding="iso-8859-1" indent="yes"></xsl:output>

  <xsl:param name="sprefix"/>
  
  <xsl:variable name="jr_tables">:PRIMACRBINVAL:PRIMACRBUNDLE:PRIMACRFSENTRY:PRIMACRGLOBAL_REVISION:PRIMACRJOURNAL:PRIMACRNAMES:PRIMACRREFS:PRIMAREPFSENTRY:VERSION_BINVAL:VERSION_BUNDLE:VERSION_FSENTRY:VERSION_NAMES:VERSION_REFS</xsl:variable>

  <xsl:variable name="ignorefields">:start_ts:end_ts:pc_process_stat_id:doc_data:audit_ts</xsl:variable>
  <xsl:variable name="ignoregrants">:SETTINGS_READ_STRING:SETTINGS_WRITE_STRING:ADD_DATABASE_JOB:INITIALIZE_BACKGROUND_PROCS:SYSTEM_MONITOR:DATA_MONITOR</xsl:variable>
  <xsl:template match="changes">
    <xsl:element name="results">
      <xsl:attribute name="DBTYPE"><xsl:value-of select="@DBTYPE"/></xsl:attribute>
      <xsl:attribute name="RUNDATE"><xsl:value-of select="@RUNDATE"/></xsl:attribute>
      <xsl:apply-templates select="change"><xsl:sort select="chgtype" order="ascending"/></xsl:apply-templates>
    </xsl:element>
  </xsl:template>

  <xsl:template match="change">

    <xsl:variable name="safe_objname">:<xsl:value-of select="objname"/></xsl:variable>
    <xsl:variable name="safe_tablename">:<xsl:value-of select="tablename"/></xsl:variable>
    <xsl:variable name="safe_sourceval">:<xsl:value-of select="sourceval"/></xsl:variable>

<!--
  <debug><xsl:value-of select="objname"/> TARGET=<xsl:value-of select="target"/></debug>
 <debug>TARGET_LENGTH=<xsl:value-of select="string-length(target)"/> SPREFIX=<xsl:value-of select="$sprefix"/> </debug> 
-->
    <xsl:variable name="rules_process">

      <xsl:if test="objtype='FIELD' and contains(objname,'geo_location') and $sprefix='SS'">:IGNORE:SPATIALCOLUMN</xsl:if>	  
      <xsl:if test="objtype='INDEX' and contains(objname,'ndx_erdb_')">:IGNORE</xsl:if>
      <xsl:if test="objtype='INDEX' and contains(objname,'ndx_location_geo_location')">:IGNORE</xsl:if>
      <xsl:if test="objtype='INDEX' and contains(objname,'ndx_rsrcloc_geo_location')">:IGNORE</xsl:if>
      <xsl:if test="objtype='INDEX' and contains(objname,'docver_docdata_qsi')">:IGNORE</xsl:if>
	  <xsl:if test="objtype='FIELD' and $sprefix='SS' and contains(objname,'job_data_x_id')">:IGNORE</xsl:if>
	  <xsl:if test="objtype='FIELD' and $sprefix='SS' and contains(objname,'job_data_x')">:IGNORE</xsl:if>
	  <xsl:if test="objtype='INDEX' and $sprefix='SS' and starts-with(objname,'uq_')">:IGNORE</xsl:if>
	  <xsl:if test="objtype='FIELD' and $sprefix='OR' and contains(objname,'image_data')">:IGNORE</xsl:if>
	  <xsl:if test="objtype='FIELD' and $sprefix='OR' and contains(objname,'image_thumbnail')">:IGNORE</xsl:if>
	  <xsl:if test="objtype='FIELD' and $sprefix='SS' and contains(objname,'image_data')">:IGNORE</xsl:if>
	  <xsl:if test="objtype='FIELD' and $sprefix='SS' and contains(objname,'image_thumbnail')">:IGNORE</xsl:if>
	  <xsl:if test="objtype='FIELD' and $sprefix='OR' and contains(objname,'arb_id')">:IGNORE</xsl:if>
	  <xsl:if test="objtype='FIELD' and $sprefix='SS' and contains(objname,'arb_id')">:IGNORE</xsl:if>
	  <xsl:if test="objtype='FIELD' and $sprefix='SS' and contains(objname,'enable_prime_sync_flag')">:IGNORE</xsl:if>
	  <xsl:if test="objtype='FIELD' and $sprefix='SS' and contains(objname,'systemuser')">:IGNORE</xsl:if>
      <xsl:if test="objtype='GRANTS' and $sprefix='SS' and contains(objname,'SAFETYDATE')">:IGNORE</xsl:if>
	 

      <xsl:if test="string-length(tablename)>0 and contains($jr_tables,$safe_tablename)">:IGNORE:JRTABLE</xsl:if>      

      <xsl:if test="starts-with(tablename,'JBPM_')">:IGNORE:JBPMTABLE</xsl:if>      
      <xsl:if test="starts-with(tablename,'MDRT_')">:IGNORE:SDOINDEXTABLE</xsl:if>      

      <xsl:if test="string-length(target) > 0 and not(contains(target,$sprefix))">:IGNORE:NOT_TARGET</xsl:if>
      
      <xsl:if test="objtype='SYNONYM' and type='SYNONYM' and contains('SS',$sprefix)" >:IGNORE:SYNONYM_FOR_SQL_SERVER</xsl:if>
      
      <xsl:if test="objtype='GRANTS' and chgtype='ALTER' and type='VIEW' and targetval='SELECT' and contains(sourceval,'SELECT')">:IGNORE:VIEW HAS MORE PRIVS</xsl:if>
      
      <xsl:if test="objtype='GRANTS' and contains($ignoregrants,$safe_objname) ">:IGNORE:SS_GRANTS</xsl:if>	  
      <xsl:if test="objtype='FIELD' and contains($ignorefields,$safe_objname) ">:IGNORE:FIELDS</xsl:if>	  
	  <xsl:if test="objtype='TRIGGER' and contains(objname,'ANNOUNCEMENTUSER') ">:IGNORE</xsl:if>
    </xsl:variable>  
<!--  <debug>RULES=<xsl:value-of select="$rules_process"/> </debug> -->

    <xsl:if test="not(contains($rules_process,'IGNORE'))" >
      <xsl:variable name="action_display"><xsl:call-template name="action_display"><xsl:with-param name="chgtype" select="chgtype"/></xsl:call-template></xsl:variable>
      <xsl:variable name="type_display"><xsl:call-template name="obj_type_display"><xsl:with-param name="objtype" select="objtype"/><xsl:with-param name="type" select="type"/></xsl:call-template></xsl:variable>

      <xsl:variable name="objname_display">
        <xsl:choose>
          <xsl:when test="tablename=objname or string-length(tablename)=0"><xsl:value-of select="objname"/></xsl:when>
          <xsl:when test="string-length(tablename)>0 and string-length(objname)=0"><xsl:value-of select="tablename"/></xsl:when>
          <xsl:otherwise><xsl:value-of select="tablename"/>.<xsl:value-of select="objname"/></xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      
      <xsl:element name="result">
        <xsl:element name="chgtype"><xsl:value-of select="chgtype"/></xsl:element>
        <xsl:element name="objtype">
          <xsl:call-template name="obj_type_value">
            <xsl:with-param name="objtype" select="objtype"/>
            <xsl:with-param name="type" select="type"/>
          </xsl:call-template>
        </xsl:element>
        <xsl:element name="tablename"><xsl:value-of select="tablename"/></xsl:element>

        <xsl:element name="objname">
          <xsl:if test="string-length(objname)>0">
            <xsl:value-of select="objname"/>
          </xsl:if>
          <xsl:if test="string-length(objname)=0">
            <xsl:value-of select="tablename"/>
          </xsl:if>
        </xsl:element>


        <xsl:element name="level">
          <xsl:if test="chgtype='CREATE'">1</xsl:if>
          <xsl:if test="chgtype='ALTER'">1</xsl:if>
          <xsl:if test="chgtype='DROP'">
            <xsl:choose>
              <xsl:when test="objtype='FIELD'">2</xsl:when>
              <xsl:when test="objtype='CONSTRAINT'">2</xsl:when>
              <xsl:otherwise>3</xsl:otherwise>
            </xsl:choose>
          </xsl:if>
        </xsl:element>

        <xsl:element name="action"><xsl:value-of select="$action_display"/></xsl:element>
        <xsl:element name="fieldchange"><xsl:value-of select="fieldchange"/></xsl:element>

        <xsl:element name="message">
          <xsl:value-of select="$action_display"/>
          <xsl:text> </xsl:text>
          <xsl:value-of select="$type_display"/>
          <xsl:text> </xsl:text>
          <xsl:value-of select="$objname_display"/>
        </xsl:element>

        <xsl:if test="string-length(sourceval)>0 and string-length(targetval)>0">
          <xsl:element name="diff_message">
            <xsl:text>Source values is </xsl:text><xsl:value-of select="sourceval"/>
            <xsl:text> while target values is </xsl:text><xsl:value-of select="targetval"/>
          </xsl:element>
        </xsl:if>
        
        <xsl:element name="sourceval"><xsl:value-of select="sourceval"/></xsl:element>
        <xsl:element name="targetval"><xsl:value-of select="targetval"/></xsl:element>

      </xsl:element>
    </xsl:if>
  </xsl:template>


  <xsl:template  name="obj_type_display">
    <xsl:param name="objtype"/>
    <xsl:param name="type"/>
    <xsl:choose>
      <xsl:when test="$objtype='FIELD'">column</xsl:when>
      <xsl:when test="$objtype='INDEX'">index</xsl:when>
      <xsl:when test="$objtype='TABLE'">table</xsl:when>
      <xsl:when test="$objtype='CONSTRAINT'">constraint</xsl:when>
      <xsl:when test="$objtype='PROCEDURE'">
        <xsl:choose>
          <xsl:when test="$type='FUNCTION'">function</xsl:when>
          <xsl:when test="$type='PROCEDURE'">procedure</xsl:when>
          <xsl:when test="$type='PACKAGE'">package</xsl:when>
          <xsl:otherwise><xsl:value-of select="$type"/></xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:when test="$objtype='SYNONYM'">
        <xsl:choose>
          <xsl:when test="$type='LDV'">logical delete view</xsl:when>
          <xsl:when test="$type='SYNONYM'">synonym</xsl:when>
          <xsl:otherwise><xsl:value-of select="$type"/></xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:when test="$objtype='VIEW'">view</xsl:when>
      <xsl:when test="$objtype='TRIGGER'">trigger</xsl:when>
      <xsl:when test="$objtype='GRANTS'">grants</xsl:when>
      <xsl:otherwise><xsl:value-of select="$objtype"/></xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template  name="obj_type_value">
    <xsl:param name="objtype"/>
    <xsl:param name="type"/>
    <xsl:choose>
      <xsl:when test="$objtype='PROCEDURE'"><xsl:value-of select="$type"/></xsl:when>
      <xsl:when test="$objtype='SYNONYM' and $type='LDV'">LDV</xsl:when>
      <xsl:otherwise><xsl:value-of select="$objtype"/></xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="action_display">
    <xsl:param name="chgtype"/>
    <xsl:choose>
      <xsl:when test="$chgtype='CREATE'">Missing</xsl:when>
      <xsl:when test="$chgtype='ALTER'">Changed</xsl:when>
      <xsl:when test="$chgtype='DROP'">Extra</xsl:when>
    </xsl:choose>
  </xsl:template>
  
</xsl:stylesheet>
