<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml" encoding="iso-8859-1" indent="yes"></xsl:output>
  <xsl:param name="comparefile"/>
  <xsl:param name="target_schema"/>
  <xsl:param name="validate"/>
  <xsl:param name="privuser"/>
  <xsl:param name="pubuser"/>
  <xsl:param name="pxrptuser"/>
  <xsl:param name="bgjobuser"/>
  <xsl:param name="targetdb"/>
  <xsl:param name="process_type"/>
  <xsl:variable name="internal_target_schema">
    <xsl:choose>
      <xsl:when test="string-length($target_schema)=0">pmSchema.xml</xsl:when>
      <xsl:otherwise><xsl:value-of select="$target_schema"/></xsl:otherwise>
    </xsl:choose>  
  </xsl:variable>
  <xsl:variable name="internal_privuser">
    <xsl:choose>
      <xsl:when test="string-length($privuser)=0">PRIVUSER</xsl:when>
      <xsl:otherwise><xsl:value-of select="$privuser"/></xsl:otherwise>
    </xsl:choose>  
  </xsl:variable>
  <xsl:variable name="internal_pubuser">
    <xsl:choose>
      <xsl:when test="string-length($pubuser)=0">PUBUSER</xsl:when>
      <xsl:otherwise><xsl:value-of select="$pubuser"/></xsl:otherwise>
    </xsl:choose>  
  </xsl:variable>
  <xsl:variable name="internal_pxrptuser">
     <xsl:choose>
      <xsl:when test="string-length($pxrptuser)=0">PXRPTUSER</xsl:when>
      <xsl:otherwise><xsl:value-of select="$pxrptuser"/></xsl:otherwise>
     </xsl:choose>  
  </xsl:variable>
  <xsl:variable name="internal_bgjobuser">
     <xsl:choose>
      <xsl:when test="string-length($bgjobuser)=0">BGJOBUSER</xsl:when>
      <xsl:otherwise><xsl:value-of select="$bgjobuser"/></xsl:otherwise>
     </xsl:choose>  
  </xsl:variable>
  <xsl:variable name="internal_targetdbtype">
     <xsl:choose>
      <xsl:when test="string-length($targetdb)=0">OR</xsl:when>
      <xsl:otherwise><xsl:value-of select="$targetdb"/></xsl:otherwise>
     </xsl:choose>  
  </xsl:variable>
  <xsl:variable name="lowercase" select="'abcdefghijklmnopqrstuvwxyz'" />
  <xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'" />
  
	<xsl:variable name="newline">
		<xsl:text>
</xsl:text>
	</xsl:variable>
  <xsl:variable name="excluded_tables"><xsl:if test="string-length($validate)=0">:UACCESS:</xsl:if></xsl:variable>
  <xsl:variable name="excluded_columns"><xsl:if test="string-length($validate)=0">:pobs_id:guid:source_proj_id:</xsl:if></xsl:variable>
  <xsl:variable name="charcompare">:string:character:ocharacter:</xsl:variable>
    <xsl:template match="PrimaveraDatabaseSchema">
    <changes>
      <xsl:attribute name="TARGET_VERSION"><xsl:value-of select="@VERSION"/></xsl:attribute>
      <xsl:attribute name="SOURCE_VERSION"><xsl:value-of select="document($comparefile)/PrimaveraDatabaseSchema/@VERSION"/></xsl:attribute>
      <xsl:attribute name="DBTYPE"><xsl:value-of select="@DBTYPE"/></xsl:attribute>
      <xsl:attribute name="RUNDATE"><xsl:value-of select="document($comparefile)/PrimaveraDatabaseSchema/@RUNDATE"/></xsl:attribute>
      
      <xsl:apply-templates select="TABLE" mode="forward"/>  
      <xsl:apply-templates select="PROCEDURE" mode="forward"/>  
      <xsl:apply-templates select="VIEW" mode="forward"/>  
      <xsl:apply-templates select="TRIGGER" mode="forward"/>  
      
      <!--Reverse Validations-->
      <xsl:apply-templates select="document($comparefile)/PrimaveraDatabaseSchema/TABLE" mode="reverse"/>
      <xsl:apply-templates select="document($comparefile)/PrimaveraDatabaseSchema/PROCEDURE" mode="reverse"/>
      <xsl:apply-templates select="document($comparefile)/PrimaveraDatabaseSchema/VIEW" mode="reverse"/>
      <xsl:apply-templates select="document($comparefile)/PrimaveraDatabaseSchema/TRIGGER" mode="reverse"/>
    </changes>
    </xsl:template>
  
  <xsl:template match="TABLE" mode="forward">
    <xsl:apply-templates select="INDEX" mode="forward"/>
    <xsl:apply-templates select="CONSTRAINT" mode="forward"/>
    <xsl:apply-templates select="TRIGGER" mode="forward"/>  
   	

    
    <xsl:variable name="table_name" select="@NAME"/>
    
<xsl:variable name="prev_table"><xsl:value-of select="document($comparefile)/PrimaveraDatabaseSchema/TABLE[@NAME=$table_name]/@NAME"/></xsl:variable>
    <xsl:if test="string-length($prev_table)=0"> 
    
    <change>
      <objtype>TABLE</objtype>
      <chgtype>CREATE</chgtype>
      <tablename><xsl:value-of select="$table_name"/></tablename>
    </change>
    </xsl:if>
    
    <xsl:if test="string-length($prev_table)>0">
      <xsl:apply-templates select="FIELD" mode="compare_field"/>
      <xsl:apply-templates select="SYNONYM" mode="compare"><xsl:with-param name="parent_name" select="$table_name"/></xsl:apply-templates>
      <xsl:apply-templates select="GRANTS" mode="compare"><xsl:with-param name="parent_name" select="$table_name"/></xsl:apply-templates>
      <xsl:apply-templates select="document($comparefile)/PrimaveraDatabaseSchema/TABLE[@NAME=$table_name]/INDEX" mode="reverse"/>
      <xsl:apply-templates select="document($comparefile)/PrimaveraDatabaseSchema/TABLE[@NAME=$table_name]/TRIGGER" mode="reverse"/>
      <xsl:apply-templates select="document($comparefile)/PrimaveraDatabaseSchema/TRIGGER[@NAME=$table_name]" mode="reverse"/>
      <xsl:apply-templates select="document($comparefile)/PrimaveraDatabaseSchema/TABLE[@NAME=$table_name]/CONSTRAINT" mode="reverse"/>
      <xsl:apply-templates select="document($comparefile)/PrimaveraDatabaseSchema/TABLE[@NAME=$table_name]/FIELD" mode="reverse"/>
   </xsl:if>
  </xsl:template>

  <xsl:template match="FIELD" mode="compare_field">
    <xsl:variable name="table_name" select="@TABLE"/>
    <xsl:variable name="field_name" select="@NAME"/>
   
    <xsl:variable name="prev_field"><xsl:value-of select="document($comparefile)/PrimaveraDatabaseSchema/TABLE[@NAME=$table_name]/FIELD[@NAME=$field_name]/@NAME"/></xsl:variable>
    
    <xsl:if test="string-length($prev_field)=0">
    <change>
      <objtype>FIELD</objtype>
      <chgtype>CREATE</chgtype>
      <tablename><xsl:value-of select="$table_name"/></tablename>
      <objname><xsl:value-of select="$field_name"/></objname>
    </change>
    </xsl:if>
     
    <xsl:if test="string-length($prev_field)>0">
      <xsl:variable name="datatype">
          <xsl:choose>
             <xsl:when test="@DATATYPE='int'">integer</xsl:when>
             <xsl:when test="@DATATYPE='clob' and translate($internal_targetdbtype,$uppercase,$lowercase)!='or'">blob</xsl:when>
			 <xsl:otherwise><xsl:value-of select="@DATATYPE"/></xsl:otherwise>
           </xsl:choose>
      </xsl:variable>
      
      <xsl:variable name="charlength" select="@CHARLENGTH"/>
      <xsl:variable name="dataprecision" select="@DATAPRECISION"/>
      <xsl:variable name="datascale" select="@DATASCALE"/>
      <xsl:variable name="notnull">
           <xsl:choose>
              <xsl:when test="@NOTNULL=''">N</xsl:when>
              <xsl:otherwise><xsl:value-of select="@NOTNULL"/></xsl:otherwise>
            </xsl:choose>
      </xsl:variable>
      <xsl:variable name="default" select="@DEFAULT"/>

      <xsl:for-each select="document($comparefile)/PrimaveraDatabaseSchema/TABLE[@NAME=$table_name]/FIELD[@NAME=$field_name]"> 
        <xsl:variable name="prev_datatype" select="@DATATYPE"/>
        <xsl:variable name="prev_charlength" select="@CHARLENGTH"/>
        <xsl:variable name="prev_dataprecision" select="@DATAPRECISION"/>
        <xsl:variable name="prev_datascale" select="@DATASCALE"/>
        <xsl:variable name="prev_notnull">
	    <xsl:choose>
	        <xsl:when test="@NOTNULL=''">N</xsl:when>
	        <xsl:otherwise><xsl:value-of select="@NOTNULL"/></xsl:otherwise>
	     </xsl:choose>
        </xsl:variable>
        <xsl:variable name="prev_default" select="@DEFAULT"/>
        <!-- Begin Field Level Tests -->


        <xsl:variable name="datatype_pass">
           <xsl:if test="$datatype='ocharacter' and $prev_datatype='character'">OK</xsl:if>
           <xsl:if test="$datatype='number' and $prev_datatype='double'">OK</xsl:if>
           <xsl:if test="$datatype='integer' and $prev_datatype='int'">OK</xsl:if>
        </xsl:variable>
    <!--    <xsl:if test="string-length($datatype_pass)>0">
  DATATYPE PASS: <xsl:value-of select="$datatype_pass"/>
        </xsl:if> -->
        <xsl:if test="$datatype!=$prev_datatype and string-length($datatype_pass)=0">  
	           <xsl:call-template name="processdiff">
		      <xsl:with-param name="objtype">FIELD</xsl:with-param>
		      <xsl:with-param name="chgtype">ALTER</xsl:with-param>
		      <xsl:with-param name="tablename"><xsl:value-of select="$table_name"/></xsl:with-param>
		      <xsl:with-param name="objname"><xsl:value-of select="$field_name"/></xsl:with-param>
		      <xsl:with-param name="fieldchange">DATATYPE</xsl:with-param>
		      <xsl:with-param name="sourceval" select="$prev_datatype"></xsl:with-param>
		      <xsl:with-param name="targetval" select="$datatype"></xsl:with-param>
                   </xsl:call-template>
         </xsl:if>
        
        <xsl:if test="$notnull!=$prev_notnull">  
	           <xsl:call-template name="processdiff">
		      <xsl:with-param name="objtype">FIELD</xsl:with-param>
		      <xsl:with-param name="chgtype">ALTER</xsl:with-param>
		      <xsl:with-param name="tablename"><xsl:value-of select="$table_name"/></xsl:with-param>
		      <xsl:with-param name="objname"><xsl:value-of select="$field_name"/></xsl:with-param>
		      <xsl:with-param name="fieldchange">NULLABLE</xsl:with-param>
		      <xsl:with-param name="sourceval" select="$prev_notnull"></xsl:with-param>
		      <xsl:with-param name="targetval" select="$notnull"></xsl:with-param>
                   </xsl:call-template>
         </xsl:if>
         <xsl:if test="$charlength!=$prev_charlength and contains($charcompare,$datatype)">
                  <xsl:variable name="pkfield">
                    <xsl:value-of select="document($internal_target_schema)/PrimaveraDatabaseSchema/TABLE[@NAME=$table_name]/CONSTRAINT[@TYPE='PRIMARY']/@FIELDS" />
                  </xsl:variable>  
        	    <xsl:call-template name="processdiff">
		      <xsl:with-param name="objtype">FIELD</xsl:with-param>
		      <xsl:with-param name="chgtype">ALTER</xsl:with-param>
		      <xsl:with-param name="tablename"><xsl:value-of select="$table_name"/></xsl:with-param>
		      <xsl:with-param name="objname"><xsl:value-of select="$field_name"/></xsl:with-param>
		      <xsl:with-param name="fieldchange">charlength change</xsl:with-param>
		      <xsl:with-param name="sourceval" select="$prev_charlength"></xsl:with-param>
		      <xsl:with-param name="targetval" select="$charlength"></xsl:with-param>
		      <xsl:with-param name="pkfields"> <xsl:value-of select="$pkfield"/> </xsl:with-param> 
	 	        </xsl:call-template>
	       </xsl:if> 	   
         <xsl:if test="$default!=$prev_default">
            <xsl:variable name="pkfield">
              <xsl:value-of select="document($internal_target_schema)/PrimaveraDatabaseSchema/TABLE[@NAME=$table_name]/CONSTRAINT[@TYPE='PRIMARY']/@FIELDS" />
            </xsl:variable>  
        	<xsl:call-template name="processdiff">
		        <xsl:with-param name="objtype">FIELD</xsl:with-param>
		        <xsl:with-param name="chgtype">ALTER</xsl:with-param>
		        <xsl:with-param name="tablename"><xsl:value-of select="$table_name"/></xsl:with-param>
		        <xsl:with-param name="objname"><xsl:value-of select="$field_name"/></xsl:with-param>
		        <xsl:with-param name="fieldchange">defaultvalue change</xsl:with-param>
		        <xsl:with-param name="sourceval" select="$prev_default"></xsl:with-param>
		        <xsl:with-param name="targetval" select="$default"></xsl:with-param>
		        <xsl:with-param name="pkfields"> <xsl:value-of select="$pkfield"/> </xsl:with-param> 
	 	      </xsl:call-template>
	       </xsl:if> 	   
        <!-- End Field Level Tests -->
      </xsl:for-each>
<!--    
      Existing Field:<xsl:value-of select="$table_name"/>.<xsl:value-of select="$field_name"/>=<xsl:value-of select="$datatype"/>,<xsl:value-of select="$charlength"/>
      Prev Field:<xsl:value-of select="$table_name"/>.<xsl:value-of select="$field_name"/>=<xsl:value-of select="$prev_datatype"/>,<xsl:value-of select="$prev_charlength"/>
-->
    </xsl:if>
  </xsl:template>

  <xsl:template name="processdiff">
   <xsl:param name="objtype"/>
   <xsl:param name="chgtype"/>
   <xsl:param name="tablename"/>
   <xsl:param name="objname"/>
   <xsl:param name="fieldchange"/>
   <xsl:param name="sourceval"/>
   <xsl:param name="targetval"/>
   <xsl:param name="pkfields"/>
   <change>
      <objtype><xsl:value-of select="$objtype"/></objtype>
      <chgtype><xsl:value-of select="$chgtype"/></chgtype>
      <tablename><xsl:value-of select="$tablename"/></tablename>
      <objname><xsl:value-of select="$objname"/></objname>
      <fieldchange><xsl:value-of select="$fieldchange"/></fieldchange>
      <sourceval><xsl:value-of select="$sourceval"/></sourceval>
      <targetval><xsl:value-of select="$targetval"/></targetval>
      <xsl:if test="$objname=$pkfields">
      <isprimarykey>true</isprimarykey>
      <constraint><xsl:value-of select="document($internal_target_schema)/PrimaveraDatabaseSchema/TABLE[@NAME=$tablename]/CONSTRAINT[@TYPE='PRIMARY']/@NAME" /></constraint>
      </xsl:if>
    </change>
  </xsl:template>

  <xsl:template match="TABLE" mode="reverse">
    <xsl:variable name="table_name" select="@NAME"/>  
    <xsl:variable name="curr_table"><xsl:value-of select="document($internal_target_schema)/PrimaveraDatabaseSchema/TABLE[@NAME=$table_name]/@NAME"/></xsl:variable>
    
    <xsl:if test="string-length($curr_table)=0">
    <change>
      <objtype>TABLE</objtype>
      <chgtype>DROP</chgtype>
      <tablename><xsl:value-of select="$table_name"/></tablename>
    </change>
    <xsl:apply-templates select="document($comparefile)/PrimaveraDatabaseSchema/TABLE[@NAME=$table_name]/CONSTRAINT" mode="foreign"/>
    </xsl:if>
  </xsl:template>
  <xsl:template match="TRIGGER" mode="reverse">
    <xsl:variable name="table_name" select="@TABLE"/>
    <xsl:variable name="trigger_name" select="@NAME"/>
    <xsl:variable name="curr_trigger">
      <xsl:value-of select="document($internal_target_schema)/PrimaveraDatabaseSchema/TABLE[@NAME=$table_name]/TRIGGER[@NAME=$trigger_name]/@NAME"/>
      <xsl:value-of select="document($internal_target_schema)/PrimaveraDatabaseSchema/TRIGGER[@NAME=$trigger_name and @TABLE=$table_name]/@NAME"/>
    </xsl:variable>
    <xsl:if test="string-length($curr_trigger)=0">
    <change>
      <objtype>TRIGGER</objtype>
      <chgtype>DROP</chgtype>
      <tablename><xsl:value-of select="$table_name"/></tablename>
      <objname><xsl:value-of select="$trigger_name"/></objname>
      <xsl:element name="target"><xsl:value-of select="@TARGET"/></xsl:element>
    </change>
    </xsl:if>
  </xsl:template>

  <xsl:template match="TRIGGER" mode="forward">
    <xsl:variable name="table_name" select="@TABLE"/>
    <xsl:variable name="trigger_name" select="@NAME"/>
    <xsl:variable name="prev_trigger">
      <xsl:value-of select="document($comparefile)/PrimaveraDatabaseSchema/TABLE[@NAME=$table_name]/TRIGGER[@NAME=$trigger_name]/@NAME"/>
      <xsl:value-of select="document($comparefile)/PrimaveraDatabaseSchema/TRIGGER[@NAME=$trigger_name and @TABLE=$table_name]/@NAME"/>
    </xsl:variable>
     <xsl:variable name="target"><xsl:value-of select="document($internal_target_schema)/PrimaveraDatabaseSchema/TRIGGER[@NAME=$trigger_name and @TABLE=$table_name]/@TARGET"/></xsl:variable>	
   
    
    <xsl:if test="string-length($prev_trigger)=0">
    <change>
      <objtype>TRIGGER</objtype>
      <chgtype>CREATE</chgtype>
      <tablename><xsl:value-of select="$table_name"/></tablename>
      <objname><xsl:value-of select="$trigger_name"/></objname>
      <xsl:element name="target"><xsl:value-of select="@TARGET"/></xsl:element>
    </change>
    </xsl:if>
  </xsl:template>

  <xsl:template match="SYNONYM" mode="compare">
    <xsl:param name="parent_name"/>
    <xsl:variable name="owner" select="@OWNER"/>
    <xsl:variable name="type" select="@TYPE"/>
    <xsl:variable name="parent" select="local-name(parent::*)"/>

    <xsl:variable name="compare_owner">
      <xsl:choose>
        <xsl:when test="$owner='PRIVUSER'"><xsl:value-of select="$internal_privuser"/></xsl:when>
        <xsl:otherwise>
          <xsl:choose>
            <xsl:when test="$owner='PUBUSER'"><xsl:value-of select="$internal_pubuser"/></xsl:when>
            <xsl:otherwise>
                <xsl:choose>
                   <xsl:when test="$owner='PXRPTUSER'"><xsl:value-of select="$internal_pxrptuser"/></xsl:when>
                    <xsl:otherwise>
                       <xsl:choose>
                        <xsl:when test="$owner='BGJOBUSER'"><xsl:value-of select="$internal_bgjobuser"/></xsl:when>
                         <xsl:otherwise>
                           <xsl:value-of select="$owner"/>
                          </xsl:otherwise>
                         </xsl:choose>   
                   </xsl:otherwise>
                  </xsl:choose>   
                </xsl:otherwise>  
           </xsl:choose>  
         </xsl:otherwise>
       </xsl:choose>  
    </xsl:variable>

    <xsl:variable name="curr_synonym">
      <xsl:if test="$parent='TABLE'">
        <xsl:value-of select="document($comparefile)/PrimaveraDatabaseSchema/TABLE[@NAME=$parent_name]/SYNONYM[translate(@OWNER,$uppercase,$lowercase)=translate($compare_owner,$uppercase,$lowercase)]/@OWNER"/>
      </xsl:if>
      <xsl:if test="$parent='PROCEDURE'">
        <xsl:value-of select="document($comparefile)/PrimaveraDatabaseSchema/PROCEDURE[@NAME=$parent_name]/SYNONYM[translate(@OWNER,$uppercase,$lowercase)=translate($compare_owner,$uppercase,$lowercase)]/@OWNER"/>
      </xsl:if>
      <xsl:if test="$parent='VIEW'">
        <xsl:value-of select="document($comparefile)/PrimaveraDatabaseSchema/VIEW[@NAME=$parent_name]/SYNONYM[translate(@OWNER,$uppercase,$lowercase)=translate($compare_owner,$uppercase,$lowercase)]/@OWNER"/>
      </xsl:if>
    </xsl:variable>
<!--curr_synonym=<xsl:value-of select="$curr_synonym"/> for parent=<xsl:value-of select="$parent_name"/> owned by <xsl:value-of select="$owner"/>-->
    <xsl:if test="string-length($curr_synonym)=0">
    <change>
      <objtype>SYNONYM</objtype>
      <chgtype>CREATE</chgtype>
      <objname><xsl:value-of select="$parent_name"/></objname>
      <xsl:element name="type"><xsl:value-of select="$type"/></xsl:element>
    </change>
    </xsl:if>
  </xsl:template>

  <xsl:template match="GRANTS" mode="compare">
    <xsl:param name="parent_name"/>
    <xsl:variable name="grantee" select="@GRANTEE"/>
    <xsl:variable name="privs" select="@PRIVILEGES"/>
    <xsl:variable name="parent" select="local-name(parent::*)"/>

    <xsl:variable name="compare_grantee">
      <xsl:choose>
        <xsl:when test="$grantee='PRIVUSER'"><xsl:value-of select="$internal_privuser"/></xsl:when>
        <xsl:otherwise>
          <xsl:choose>
            <xsl:when test="$grantee='PUBUSER'"><xsl:value-of select="$internal_pubuser"/></xsl:when>
              <xsl:otherwise>
	           <xsl:choose>
		    <xsl:when test="$grantee='PXRPTUSER'"><xsl:value-of select="$internal_pxrptuser"/></xsl:when>
		     <xsl:otherwise>
	                <xsl:choose>
		          <xsl:when test="$grantee='BGJOBUSER' and $internal_targetdbtype='or'"><xsl:value-of select="PM_BG_JOB_ROLE"/></xsl:when>
		            <xsl:otherwise>
		              <xsl:value-of select="$grantee"/>
		            </xsl:otherwise>
                          </xsl:choose>
		     </xsl:otherwise>
                   </xsl:choose>
	         </xsl:otherwise>
             </xsl:choose>  
        </xsl:otherwise>
      </xsl:choose>  
    </xsl:variable>

<!--parent type: <xsl:value-of select="$parent"/> for compare grantee: <xsl:value-of select="$compare_grantee"/>-->
    <xsl:variable name="curr_privs">
      <xsl:if test="$parent='TABLE'">
        <xsl:value-of select="document($comparefile)/PrimaveraDatabaseSchema/TABLE[@NAME=$parent_name]/GRANTS[translate(@GRANTEE,$uppercase,$lowercase)=translate($compare_grantee,$uppercase,$lowercase)]/@PRIVILEGES"/>
      </xsl:if>
      <xsl:if test="$parent='PROCEDURE'">
        <xsl:value-of select="document($comparefile)/PrimaveraDatabaseSchema/PROCEDURE[@NAME=$parent_name]/GRANTS[translate(@GRANTEE,$uppercase,$lowercase)=translate($compare_grantee,$uppercase,$lowercase)]/@PRIVILEGES"/>
      </xsl:if>
      <xsl:if test="$parent='VIEW'">
        <xsl:value-of select="document($comparefile)/PrimaveraDatabaseSchema/VIEW[@NAME=$parent_name]/GRANTS[translate(@GRANTEE,$uppercase,$lowercase)=translate($compare_grantee,$uppercase,$lowercase)]/@PRIVILEGES"/>
      </xsl:if>
    </xsl:variable>
<!--curr_privs=<xsl:value-of select="$curr_privs"/> for parent=<xsl:value-of select="$parent_name"/> privs: <xsl:value-of select="$privs"/>-->
    <xsl:if test="string-length($curr_privs)=0 ">
    <change>
      <objtype>GRANTS</objtype>
      <chgtype>CREATE</chgtype>
      <objname><xsl:value-of select="$parent_name"/></objname>
      <xsl:element name="type"><xsl:value-of select="$privs"/></xsl:element>
    </change>
    </xsl:if>
    <xsl:if test="string-length($curr_privs)>0 and $curr_privs!=$privs and $internal_targetdbtype!=$targetdb">
    <change>
      <objtype>GRANTS</objtype>
      <chgtype>ALTER</chgtype>
      <objname><xsl:value-of select="$parent_name"/></objname>
      <type><xsl:value-of select="$parent"/></type>
      <xsl:element name="sourceval"><xsl:value-of select="$curr_privs"/></xsl:element>
      <xsl:element name="targetval"><xsl:value-of select="$privs"/></xsl:element>
    </change>
    </xsl:if>
  </xsl:template>

  <xsl:template match="FIELD" mode="reverse">
    <xsl:variable name="table_name" select="@TABLE"/>
    <xsl:variable name="field_name" select="@NAME"/>
    <xsl:variable name="curr_field"><xsl:value-of select="document($internal_target_schema)/PrimaveraDatabaseSchema/TABLE[@NAME=$table_name]/FIELD[@NAME=$field_name]/@NAME"/></xsl:variable>
    <xsl:if test="string-length($curr_field)=0">
      <xsl:element name="change">
        <xsl:element name="objtype">FIELD</xsl:element>
        <xsl:element name="chgtype">DROP</xsl:element>
        <xsl:element name="tablename"><xsl:value-of select="$table_name"/></xsl:element>
        <xsl:element name="objname"><xsl:value-of select="$field_name"/></xsl:element>
      </xsl:element>
    </xsl:if>
  </xsl:template>

  <xsl:template match="CONSTRAINT" mode="reverse">
    <xsl:variable name="table_name" select="@TABLE"/>
    <xsl:variable name="constraint_name" select="@NAME"/>
    <xsl:variable name="curr_constraint"><xsl:value-of select="document($internal_target_schema)/PrimaveraDatabaseSchema/TABLE[@NAME=$table_name]/CONSTRAINT[@NAME=$constraint_name]/@NAME"/></xsl:variable>
    <xsl:if test="string-length($curr_constraint)=0">
      <xsl:element name="change">
        <xsl:element name="objtype">CONSTRAINT</xsl:element>
        <xsl:element name="chgtype">DROP</xsl:element>
        <xsl:element name="tablename"><xsl:value-of select="$table_name"/></xsl:element>
        <xsl:element name="objname"><xsl:value-of select="$constraint_name"/></xsl:element>
        <xsl:element name="type"><xsl:value-of select="@TYPE"/></xsl:element>      
      </xsl:element>
    </xsl:if>
  </xsl:template>

  <xsl:template match="PROCEDURE" mode="reverse">
    <xsl:variable name="procedure_name" select="@NAME"/>
    <xsl:variable name="curr_procedure"><xsl:value-of select="document($internal_target_schema)/PrimaveraDatabaseSchema/PROCEDURE[@NAME=$procedure_name]/@NAME"/></xsl:variable>
    <xsl:if test="string-length($curr_procedure)=0">
    <change>
      <objtype>PROCEDURE</objtype>
      <chgtype>DROP</chgtype>
      <objname><xsl:value-of select="$procedure_name"/></objname>
      <type><xsl:value-of select="document(($comparefile))/PrimaveraDatabaseSchema/PROCEDURE[@NAME=$procedure_name]/@TYPE" /></type>	
      <xsl:element name="target"><xsl:value-of select="@TARGET"/></xsl:element>
    </change>
    </xsl:if>
  </xsl:template>

  <xsl:template match="PROCEDURE" mode="forward">
    <xsl:variable name="procedure_name" select="@NAME"/>
    <xsl:variable name="prev_proc"><xsl:value-of select="document($comparefile)/PrimaveraDatabaseSchema/PROCEDURE[@NAME=$procedure_name]/@NAME"/></xsl:variable>
    <xsl:variable name="target"><xsl:value-of select="document($internal_target_schema)/PrimaveraDatabaseSchema/PROCEDURE[@NAME=$procedure_name]/@TARGET"/></xsl:variable>	
       <xsl:if test="string-length($prev_proc)=0"> 
      <change>
        <objtype>PROCEDURE</objtype>
        <chgtype>CREATE</chgtype>
        <tablename><xsl:value-of select="$procedure_name"/></tablename>
        <type><xsl:value-of select="@TYPE"/></type>
        <xsl:element name="target"><xsl:value-of select="@TARGET"/></xsl:element>
      </change>
    </xsl:if>
    <xsl:if test="string-length($prev_proc)>0"> 
      <xsl:apply-templates select="SYNONYM" mode="compare"><xsl:with-param name="parent_name" select="$procedure_name"/></xsl:apply-templates>
      <xsl:apply-templates select="GRANTS" mode="compare"><xsl:with-param name="parent_name" select="$procedure_name"/></xsl:apply-templates>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="VIEW" mode="forward">
    <xsl:variable name="view_name" select="@NAME"/>
    <xsl:variable name="prev_view"><xsl:value-of select="document($comparefile)/PrimaveraDatabaseSchema/VIEW[@NAME=$view_name]/@NAME"/></xsl:variable>
    <xsl:if test="string-length($prev_view)=0"> 
      <change>
        <objtype>VIEW</objtype>
        <chgtype>CREATE</chgtype>
        <tablename><xsl:value-of select="$view_name"/></tablename>
        <xsl:element name="target"><xsl:value-of select="@TARGET"/></xsl:element>
      </change>
    </xsl:if>
    <xsl:if test="string-length($prev_view)>0"> 
      <xsl:apply-templates select="SYNONYM" mode="compare"><xsl:with-param name="parent_name" select="$view_name"/></xsl:apply-templates>
      <xsl:apply-templates select="GRANTS" mode="compare"><xsl:with-param name="parent_name" select="$view_name"/></xsl:apply-templates>
    </xsl:if>
  </xsl:template>
  
    <xsl:template match="VIEW" mode="reverse">
    <xsl:variable name="view_name" select="@NAME"/>
    <xsl:variable name="curr_view"><xsl:value-of select="document($internal_target_schema)/PrimaveraDatabaseSchema/VIEW[@NAME=$view_name]/@NAME"/></xsl:variable>
    <xsl:if test="string-length($curr_view)=0">
    <change>
      <objtype>VIEW</objtype>
      <chgtype>DROP</chgtype>
      <objname><xsl:value-of select="$view_name"/></objname>
      <xsl:element name="target"><xsl:value-of select="@TARGET"/></xsl:element>
    </change>
    </xsl:if>
  </xsl:template>

  <xsl:template match="INDEX" mode="reverse">
    <xsl:variable name="index_name" select="@NAME"/>
    <xsl:variable name="table_name" select="@TABLE"/>
    <xsl:variable name="curr_index"><xsl:value-of select="document($internal_target_schema)/PrimaveraDatabaseSchema/TABLE[@NAME=$table_name]/INDEX[translate(@NAME,$uppercase,$lowercase)=translate($index_name,$uppercase,$lowercase)]/@NAME"/></xsl:variable>
    <xsl:if test="string-length($curr_index)=0">
    <change>
      <objtype>INDEX</objtype>
      <chgtype>DROP</chgtype>
      <xsl:element name="tablename"><xsl:value-of select="$table_name"/></xsl:element>
      <objname><xsl:value-of select="$index_name"/></objname>
      <xsl:element name="target"><xsl:value-of select="@TARGET"/></xsl:element>
    </change>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="INDEX" mode="forward">
    <xsl:variable name="index_name" select="@NAME"/>
    <xsl:variable name="table_name" select="@TABLE"/>
    <xsl:variable name="prev_index"><xsl:value-of select="document($comparefile)/PrimaveraDatabaseSchema/TABLE[@NAME=$table_name]/INDEX[translate(@NAME,$uppercase,$lowercase)=translate($index_name,$uppercase,$lowercase)]/@NAME"/></xsl:variable>
    <xsl:variable name="target"><xsl:value-of select="document($internal_target_schema)/PrimaveraDatabaseSchema/TABLE[@NAME=$table_name]/INDEX[translate(@NAME,$uppercase,$lowercase)=translate($index_name,$uppercase,$lowercase)]/@TARGET"/></xsl:variable>	
    <xsl:variable name="prev_target"><xsl:value-of select="document($comparefile)/PrimaveraDatabaseSchema/TABLE[@NAME=$table_name]/INDEX[translate(@NAME,$uppercase,$lowercase)=translate($index_name,$uppercase,$lowercase)]/@TARGET"/></xsl:variable>
 
    <xsl:if test="string-length($prev_index)=0">
      <xsl:element name="change">
        <xsl:element name="objtype">INDEX</xsl:element>
        <xsl:element name="chgtype">CREATE</xsl:element>
        <xsl:element name="tablename"><xsl:value-of select="$table_name"/></xsl:element>
        <xsl:element name="objname"><xsl:value-of select="$index_name"/></xsl:element>
        <xsl:element name="target"><xsl:value-of select="@TARGET"/></xsl:element>
      </xsl:element>
    </xsl:if>   
    <xsl:if test="string-length($prev_index)>0">
     <xsl:variable name="prev_index_field"><xsl:value-of select="document($comparefile)/PrimaveraDatabaseSchema/TABLE[@NAME=$table_name]/INDEX[@NAME=translate(@NAME,$uppercase,$lowercase)]/@FIELD"/></xsl:variable>
     <xsl:variable name="curr_index_field"><xsl:value-of select="document($internal_target_schema)/PrimaveraDatabaseSchema/TABLE[@NAME=$table_name]/INDEX[@NAME=translate(@NAME,$uppercase,$lowercase)]/@FIELD"/></xsl:variable>	
      <xsl:if test="$curr_index_field!=prev_index_field"> 	
     <xsl:element name="change">
        <xsl:element name="objtype">INDEX</xsl:element>
        <xsl:element name="chgtype">ALTER</xsl:element>
        <xsl:element name="tablename"><xsl:value-of select="$table_name"/></xsl:element>
        <xsl:element name="objname"><xsl:value-of select="$index_name"/></xsl:element>
        <xsl:element name="sourceval"><xsl:value-of select="$prev_index_field"/></xsl:element>
        <xsl:element name="targetval"><xsl:value-of select="$curr_index_field"/></xsl:element>
        <xsl:element name="target"><xsl:value-of select="@TARGET"/></xsl:element>
      </xsl:element>
     </xsl:if>   	
    </xsl:if>   
    <xsl:if test="$process_type='upgrade'">
      <xsl:if test="(string-length($target) - string-length($prev_target)>0) and string-length($prev_index)!=0">
        <xsl:variable name="curr_target">
        <xsl:choose>
	       <xsl:when test="$prev_target='OR'">SS</xsl:when>
		   <xsl:when test="$prev_target='SS'">OR</xsl:when>
           <xsl:otherwise><xsl:value-of select="$target"/></xsl:otherwise>
         </xsl:choose>
	    </xsl:variable>
        <xsl:element name="change">
          <xsl:element name="objtype">INDEX</xsl:element>
          <xsl:element name="chgtype">CREATE</xsl:element>
          <xsl:element name="tablename"><xsl:value-of select="$table_name"/></xsl:element>
          <xsl:element name="objname"><xsl:value-of select="$index_name"/></xsl:element>
          <xsl:element name="target"><xsl:value-of select="$curr_target"/></xsl:element>
        </xsl:element>
       </xsl:if>   
	 </xsl:if>
  </xsl:template>

  <xsl:template match="CONSTRAINT" mode="forward">
    <xsl:variable name="table_name" select="@TABLE"/>
    <xsl:variable name="constraint_name" select="@NAME"/>
    <xsl:variable name="prev_constraint"><xsl:value-of select="document($comparefile)/PrimaveraDatabaseSchema/TABLE[@NAME=$table_name]/CONSTRAINT[@NAME=$constraint_name]/@NAME"/></xsl:variable>
    <xsl:if test="string-length($prev_constraint)=0">
      <xsl:element name="change">
        <xsl:element name="objtype">CONSTRAINT</xsl:element>
        <xsl:element name="chgtype">CREATE</xsl:element>
        <xsl:element name="tablename"><xsl:value-of select="$table_name"/></xsl:element>
        <xsl:element name="objname"><xsl:value-of select="$constraint_name"/></xsl:element>
        <xsl:element name="type"><xsl:value-of select="@TYPE"/></xsl:element>      
        <xsl:element name="target"><xsl:value-of select="@TARGET"/></xsl:element>
      </xsl:element>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="CONSTRAINT" mode="foreign">
      <xsl:variable name="table_name" select="@TABLE"/>
      <xsl:variable name="constraint_name" select="@NAME"/>
      <xsl:variable name="constraint_type" select="@TYPE"/>
      <xsl:variable name="curr_constraint"><xsl:value-of select="document($internal_target_schema)/PrimaveraDatabaseSchema/TABLE[@NAME=$table_name]/CONSTRAINT[@NAME=$constraint_name]/@NAME"/></xsl:variable>
      <xsl:if test="string-length($curr_constraint)=0 and $constraint_type='FOREIGN' ">
        <xsl:element name="change">
          <xsl:element name="objtype">CONSTRAINT</xsl:element>
          <xsl:element name="chgtype">DROP</xsl:element>
          <xsl:element name="tablename"><xsl:value-of select="$table_name"/></xsl:element>
          <xsl:element name="objname"><xsl:value-of select="$constraint_name"/></xsl:element>
          <xsl:element name="type"><xsl:value-of select="@TYPE"/></xsl:element>      
        </xsl:element>
      </xsl:if>
  </xsl:template>

</xsl:stylesheet>
