set serveroutput on size 1000000
--METADATA NAME:dbtk_manage_triggers TYPE:PROCEDURE CHANGE:CREATE
CREATE OR REPLACE PROCEDURE DBTK_MANAGE_TRIGGERS(action varchar2) AUTHID CURRENT_USER
AS
Cursor trigcur is select trigger_name from user_triggers where trigger_name not like 'BIN$%' and status<>action;
vsql varchar2(255);
Begin
  FOR trig IN trigcur LOOP
    vsql := 'ALTER  TRIGGER ' || trig.trigger_name || ' ' || action;
    dbms_output.put_line(vsql);
    execute immediate vsql;
  END LOOP; 
 EXCEPTION WHEN OTHERS THEN NULL;
end;
/
show err
--METADATA NAME:dbtk_manage_triggers TYPE:EXEC
BEGIN
  dbtk_manage_triggers('ENABLE');
END;
/

--METADATA NAME:dbtk_manage_triggers TYPE:PROCEDURE CHANGE:DROP
DROP PROCEDURE dbtk_manage_triggers
/


