set serveroutput on size 1000000
--METADATA NAME:dbtk_clear_database_objects TYPE:PROCEDURE CHANGE:CREATE
CREATE OR REPLACE PROCEDURE dbtk_clear_database_objects
AUTHID CURRENT_USER
AS
  CURSOR objects IS
  SELECT object_name, object_type
  FROM user_objects
  WHERe object_type in ('PROCEDURE','PACKAGE','FUNCTION','VIEW','SEQUENCE')
  and object_name not like 'DBTK%';

  CURSOR priv_objects (ppriv_name varchar2)
  IS  
  select object_name, object_type
  from all_objects
  where owner = ppriv_name;
  
  CURSOR tables 
  IS
  select table_name from user_tables;
  
  CURSOR constraints
  IS
  select constraint_name, table_name
  from user_constraints
  where constraint_type = 'R';
  
  vsql varchar2(4000);
  v${.or.privileged_user} varchar2(30);
  vcnt pls_integer;
BEGIN

  begin
    select DISTINCT GRANTEE 
    into v${.or.privileged_user}
    from user_tab_privs 
    where table_name in ('PREFER','CVRT')
    and rownum = 1;
  exception
    when no_data_found then
      v${.or.privileged_user} := '';
  end;
  
  FOR obj IN objects LOOP
    vsql := 'DROP ' || obj.object_type || ' ' || obj.object_name;
    dbms_output.put_line(vsql);
    execute immediate vsql;
  END LOOP;

  dbms_output.put_line('Privileged User: ' || v${.or.privileged_user});

  FOR privobj IN priv_objects(v${.or.privileged_user}) LOOP
    vsql := 'DROP ' || privobj.object_type || ' ' || v${.or.privileged_user} || '.' || privobj.object_name;
    dbms_output.put_line(vsql);
    execute immediate vsql;
  END LOOP;
  
  FOR con IN constraints LOOP
    vsql := 'ALTER TABLE ' || con.table_name || ' DROP CONSTRAINT ' ||  con.constraint_name;
    execute immediate vsql;
    dbms_output.put_line(vsql);
  END LOOP;
  
  FOR tab IN tables LOOP
    vsql := 'DROP TABLE ' || tab.table_name;
    dbms_output.put_line(vsql);
    execute immediate vsql;
  END LOOP;

  execute immediate 'purge recyclebin';  
END;
/
show err
--METADATA NAME:dbtk_clear_database_objects TYPE:EXEC
BEGIN
  dbtk_clear_database_objects;
END;
/

--METADATA NAME:dbtk_clear_database_objects TYPE:PROCEDURE CHANGE:DROP
DROP PROCEDURE dbtk_clear_database_objects
/
