<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="text" encoding="iso-8859-1"></xsl:output>
  <xsl:param name="sprefix"/>
  <xsl:param name="schema_file"/>
  <xsl:param name="script_name"/>
  <xsl:param name="include_storage"/>
  <xsl:param name="use_display_name"/>
  <xsl:param name="use_display_column_name"/>
  <xsl:param name="options"/>
  <xsl:param name="use_inline_schema"/>
  <xsl:param name="fail_on_error" select="'Y'"/>
  <xsl:param name="object_owner" />
  <xsl:param name="partitioned" />
  <xsl:param name="ssmigtables" />

  <xsl:variable name="lowercase" select="'abcdefghijklmnopqrstuvwxyz'" />
  <xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'" />

  <xsl:variable name="inline_schema">
    <xsl:choose>
      <xsl:when test="$use_inline_schema='true'">true</xsl:when>
      <xsl:otherwise>false</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="local_options">
    <xsl:choose>
      <xsl:when test="string-length($options)=0">YYYYYYY</xsl:when>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="option_tables" select="substring($options,1,1)"/>
  <xsl:variable name="option_indexes" select="substring($options,2,1)"/>
  <xsl:variable name="option_pkeys" select="substring($options,3,1)"/>
  <xsl:variable name="option_fkeys" select="substring($options,4,1)"/>
  <xsl:variable name="option_grants" select="substring($options,5,1)"/>
  <xsl:variable name="option_synonyms" select="substring($options,6,1)"/>
  <xsl:variable name="option_sequences" select="substring($options,7,1)"/>
  <xsl:variable name="option_ukeys" select="substring($options,8,1)"/>
  <xsl:variable name="option_ckeys" select="substring($options,9,1)"/>
  <xsl:variable name="option_procedures" select="substring($options,10,1)"/>
  <xsl:variable name="option_views" select="substring($options,11,1)"/>
   <xsl:variable name="option_pk_in_table">
    <xsl:choose>
      <xsl:when test="string-length(substring($options,12,1))=0">Y</xsl:when>
      <xsl:otherwise><xsl:value-of select="substring($options,12,1)"/></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>   
  <xsl:variable name="option_spatial" select="substring($options,13,1)"/>
  <xsl:variable name="option_ctx" select="substring($options,14,1)"/>
  
  <xsl:variable name="prefix">
    <xsl:choose>
      <xsl:when test="string-length($sprefix)=0">OR</xsl:when>
      <xsl:otherwise><xsl:value-of select="$sprefix"/></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="internal_schema_name">
    <xsl:choose>
      <xsl:when test="string-length($schema_file)=0">pmSchema.xml</xsl:when>
      <xsl:otherwise><xsl:value-of select="$schema_file"/></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="dat_ts">
    <xsl:choose>
      <xsl:when test="$inline_schema='false'"><xsl:apply-templates select="document($internal_schema_name)/PrimaveraDatabaseSchema" mode="dat_ts"/></xsl:when>
      <xsl:otherwise></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="ndx_ts">
    <xsl:choose>
      <xsl:when test="$inline_schema='false'"><xsl:apply-templates select="document($internal_schema_name)/PrimaveraDatabaseSchema" mode="ndx_ts"/></xsl:when>
      <xsl:otherwise></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="lob_ts">
    <xsl:choose>
      <xsl:when test="$inline_schema='false'"><xsl:apply-templates select="document($internal_schema_name)/PrimaveraDatabaseSchema" mode="lob_ts"/></xsl:when>
      <xsl:otherwise></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="char_semantics"> CHAR</xsl:variable>

  <xsl:variable name="dbtype">
    <xsl:choose>
      <xsl:when test="$inline_schema='false'"><xsl:apply-templates select="document($internal_schema_name)/PrimaveraDatabaseSchema" mode="dbtype"/></xsl:when>
      <xsl:otherwise></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="suite">
    <xsl:choose>
      <xsl:when test="$dbtype='P6PLUS' or $dbtype='PX'">PX</xsl:when>
      <xsl:when test="$dbtype='EXP' or $dbtype='EXPADM'">EXP</xsl:when>
      <xsl:when test="$dbtype='PMODS' or $dbtype='PMSTAGE' or $dbtype='PMSTAR'">PMER</xsl:when>
      <xsl:otherwise>PM</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="admuser">
    <xsl:choose>
      <xsl:when test="$prefix='SS' and string-length(worklist/ss_owner)>0"><xsl:value-of select="worklist/ss_owner"/>.</xsl:when>
      <xsl:when test="$suite='PX'">PXDMUSER.</xsl:when>
      <xsl:when test="$prefix='OR' and $suite='PM'">ADMUSER.</xsl:when>
      <xsl:when test="($prefix='OR' or $prefix='ASA') and $dbtype='EXP'">EXP.</xsl:when>
      <xsl:when test="($prefix='OR' or $prefix='ASA') and $dbtype='EXPADM'">EXPADM.</xsl:when>
      <xsl:when test="$prefix='SS'">DBO.</xsl:when>
    </xsl:choose>
  </xsl:variable>

	<xsl:variable name="newline">
		<xsl:text>
</xsl:text>
	</xsl:variable>

  <xsl:template match="PrimaveraDatabaseSchema" mode="dbtype"><xsl:value-of select="@DBTYPE"/></xsl:template>
  <xsl:template match="PrimaveraDatabaseSchema" mode="dat_ts"><xsl:value-of select="@DATA_TABLESPACE"/></xsl:template>
  <xsl:template match="PrimaveraDatabaseSchema" mode="ndx_ts"><xsl:value-of select="@INDEX_TABLESPACE"/></xsl:template>
  <xsl:template match="PrimaveraDatabaseSchema" mode="lob_ts"><xsl:value-of select="@LOB_TABLESPACE"/></xsl:template>
  
	<xsl:template match="worklist">
    <xsl:if test="$prefix='SS'">
SET QUOTED_IDENTIFIER ON
</xsl:if>
    <xsl:if test="$prefix='OR'">
--Run Script as <xsl:value-of select="$object_owner"/>    
SET DEFINE OFF
</xsl:if>
    <xsl:if test="$inline_schema='false'">    	
      <xsl:for-each select="document('script_header_text.xml')/headers/header[@target=$prefix and @script_name=$script_name]">
        <xsl:value-of select="text"/>
      </xsl:for-each>
    </xsl:if>
    <xsl:apply-templates select="item">
      <xsl:sort select="sortorder"/>
    </xsl:apply-templates>
  </xsl:template>
  
  <xsl:template match="item">
      <xsl:variable name="object_name" select="objname"/>
      <xsl:variable name="item_target">
        <xsl:if test="string-length(target)=0">OR,SS,ASA</xsl:if>
        <xsl:if test="string-length(target)>0"><xsl:value-of select="target"/></xsl:if>
      </xsl:variable>

      <xsl:if test="contains($item_target,$prefix)">
        <xsl:apply-templates select="sql[@PREPOST='PRE']/statement[@prefix=$prefix]"/>
      <xsl:choose>
        <xsl:when test="objtype='TABLE' and contains($item_target,$prefix) and $option_tables='Y'">
           <xsl:apply-templates select="document($internal_schema_name)/PrimaveraDatabaseSchema/TABLE[@NAME=$object_name]" mode="table">
             <xsl:with-param name="type" select="objtype"/><xsl:with-param name="name" select="objname"/><xsl:with-param name="change" select="chgtype"/>
           </xsl:apply-templates>
           <xsl:if test="chgtype='DROP'">
            <xsl:apply-templates select="." mode="drop"/>
           </xsl:if> 
        </xsl:when>
        <xsl:when test="objtype='INDEX' and contains($item_target,$prefix) and $option_indexes='Y'"><xsl:apply-templates select="." mode="index"/></xsl:when>
	<xsl:when test="objtype='CTXINDEX'"><xsl:apply-templates select="." mode="ctxindex"/></xsl:when>
        <xsl:when test="objtype='SYNONYM'"><xsl:apply-templates select="." mode="synonym"/></xsl:when>
        <xsl:when test="objtype='LDV'"><xsl:apply-templates select="." mode="synonym"/></xsl:when>
        <xsl:when test="objtype='GRANT'"><xsl:apply-templates select="." mode="grant"/></xsl:when>
        <xsl:when test="objtype='FIELD' or objtype='COLUMN'"><xsl:apply-templates select="." mode="field"/></xsl:when>
        <xsl:when test="objtype='CONSTRAINT'"><xsl:apply-templates select="." mode="constraint"/></xsl:when>
        <xsl:when test="objtype='SEQUENCE' and $option_sequences='Y' and $prefix='OR'"><xsl:apply-templates select="." mode="sequence"/></xsl:when>
	<xsl:when test="objtype='PROCEDURE'or objtype='FUNCTION'"><xsl:apply-templates select="." mode="procedure"/></xsl:when>
	<xsl:when test="objtype='VIEW' and chgtype='DROP'"><xsl:apply-templates select="." mode="dropview"/></xsl:when>
	<xsl:when test="objtype='VIEW' and $option_views='Y' and ($dbtype='EXP' or $dbtype='EXPADM')"><xsl:apply-templates select="." mode="viewgrants"/></xsl:when>
	<xsl:when test="objtype='TRIGGER' and chgtype='DROP'"><xsl:apply-templates select="." mode="trigger"/></xsl:when>
	<xsl:when test="objtype='NEXTKEY'"> <xsl:apply-templates select="." mode="nextkey"><xsl:with-param name="tabname" select="tabname"/><xsl:with-param name="name" select="objname"/><xsl:with-param name="change" select="chgtype"/> 
	</xsl:apply-templates></xsl:when>
      </xsl:choose>
        <xsl:apply-templates select="sql[@PREPOST='POST']/statement[@prefix=$prefix]"/>
      </xsl:if>

    <xsl:if test="$sprefix='OR' and $option_spatial='Y' and objtype='TABLE' and chgtype='CREATE'">
      <xsl:apply-templates select="document($internal_schema_name)/PrimaveraDatabaseSchema/TABLE[@NAME=$object_name]/FIELD[@DATATYPE='geometry']" mode="column_spatial"/>  
    </xsl:if>
  </xsl:template>
  
    <xsl:template match="TABLE" mode="table">
    <xsl:param name="type"/>
    <xsl:param name="name"/>
    <xsl:param name="change"/>
    <xsl:call-template name="print_output">
      <xsl:with-param name="output">table <xsl:value-of select="$name"/></xsl:with-param>
      <xsl:with-param name="operation" select="$change"/>
    </xsl:call-template>
--METADATA NAME:<xsl:value-of select="@NAME"/> TYPE:TABLE CHANGE:<xsl:value-of select="$change"/>
    <xsl:variable name="display_table_name" select="@DISPLAY_TABLE_NAME"/>
    <xsl:variable name="table_name">
      <xsl:choose>
        <xsl:when test="$use_display_name='Y'"><xsl:value-of select="$display_table_name"/></xsl:when>
        <xsl:otherwise><xsl:value-of select="$name"/></xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:if test="$change='CREATE'">

CREATE <xsl:if test="(@TABLETYPE='SESSION' or @TABLETYPE='TRANSACTION') and $prefix='OR'">GLOBAL TEMPORARY </xsl:if>TABLE <xsl:value-of select="$table_name"/>(
<xsl:apply-templates select="document($internal_schema_name)/PrimaveraDatabaseSchema/TABLE[@NAME=$name]/FIELD" mode="column_creator"/>
<xsl:if  test="$option_pk_in_table='Y'"><xsl:apply-templates select="document($internal_schema_name)/PrimaveraDatabaseSchema/TABLE[@NAME=$name]/CONSTRAINT[@TYPE='PRIMARY']" mode="table_primary_key"/></xsl:if>  )
<xsl:apply-templates select="document($internal_schema_name)/PrimaveraDatabaseSchema/TABLE[@NAME=$name]" mode="table_options"/>
<xsl:apply-templates select="document($internal_schema_name)/PrimaveraDatabaseSchema/TABLE[@NAME=$name]" mode="nologging"/>
<xsl:apply-templates select="document($internal_schema_name)/PrimaveraDatabaseSchema/TABLE[@NAME=$name]" mode="partition"><xsl:with-param name="tablename" select="$name"/></xsl:apply-templates>
<xsl:apply-templates select="document($internal_schema_name)/PrimaveraDatabaseSchema/TABLE[@NAME=$name]" mode="inmemory"/><xsl:value-of select="$newline"/>
<xsl:if test="$prefix='OR'">/</xsl:if><xsl:if test="$prefix='SS' or $prefix='ASA'">go</xsl:if>
<xsl:if test="position() = last()"><xsl:value-of select="$newline"/></xsl:if>
    </xsl:if>
  </xsl:template>
  
 <xsl:template match="item" mode="drop">
--METADATA NAME:<xsl:value-of select="objname"/> TYPE:TABLE CHANGE:<xsl:value-of select="chgtype"/>  
<xsl:if test="$prefix='OR'">
DECLARE
  tbl_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO tbl_exists FROM user_tables WHERE table_name = UPPER('<xsl:value-of select="objname"/>');
  IF tbl_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP TABLE <xsl:value-of select="objname"/> CASCADE CONSTRAINTS PURGE';
  END IF;
END;
</xsl:if>
<xsl:if test="$prefix='SS' or $prefix='ASA'">
declare @tblexists int
SELECT @tblexists=count(*) FROM sys.objects where type ='U' and name ='<xsl:value-of select="objname"/>'
IF @tblexists > 0   
DROP TABLE <xsl:value-of select="objname"/><xsl:value-of select="$newline"/> 
</xsl:if>
<xsl:if test="$prefix='OR'">/</xsl:if><xsl:if test="$prefix='SS' or $prefix='ASA'">go</xsl:if>
<xsl:if test="position() = last()"><xsl:value-of select="$newline"/></xsl:if>
  </xsl:template>
 
 <xsl:template match="item" mode="dropview">
<xsl:if test="@OBJECTTYPE='VIEW'">
--METADATA NAME:<xsl:value-of select="objname"/> TYPE:VIEW CHANGE:<xsl:value-of select="chgtype"/> 
DROP VIEW <xsl:value-of select="objname"/><xsl:value-of select="$newline"/> 
  <xsl:if test="$prefix='OR'">/</xsl:if><xsl:if test="$prefix='SS' or $prefix='ASA'">go</xsl:if>
 <xsl:if test="position() = last()"><xsl:value-of select="$newline"/></xsl:if>
</xsl:if>

   </xsl:template>
 
  <xsl:template match="FIELD" mode="column_creator">
  <xsl:param name="setdefault"/>
   <xsl:value-of select="'  '"/>
    <xsl:variable name="column_name">
      <xsl:choose>
        <xsl:when test="$use_display_column_name='Y' and string-length(@DISPLAY_COLUMN_NAME)>0"><xsl:value-of select="@DISPLAY_COLUMN_NAME"/></xsl:when>
        <xsl:otherwise><xsl:value-of select="@NAME"/></xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:if test="$prefix='SS'">"</xsl:if><xsl:value-of select="$column_name"/><xsl:if test="$prefix='SS'">"</xsl:if><xsl:value-of select="'  '"/>
      <xsl:apply-templates select="." mode="dbdatatype"/>
    <xsl:if test="string-length(normalize-space(@DEFAULT))>0"> DEFAULT <xsl:comment/>
      <xsl:choose>
        <xsl:when test="@DEFAULT='user' and not($prefix='OR')">
          <xsl:if test="$prefix='SS'">CURRENT_USER</xsl:if>
          <xsl:if test="$prefix='ASA'">CURRENT USER</xsl:if> <!--NOT SURE ABOUT THIS!!-->
        </xsl:when>
        <xsl:when test="@DEFAULT='sysdate' and not($prefix='OR')">
          <xsl:if test="$prefix='SS'">getDate()</xsl:if>
          <xsl:if test="$prefix='ASA'">
            <xsl:if test="@DATATYPE='date'">CURRENT DATE</xsl:if>
            <xsl:if test="@DATATYPE='timestamp'">CURRENT TIMESTAMP</xsl:if>
          </xsl:if>
        </xsl:when>
        <xsl:otherwise><xsl:value-of select="@DEFAULT"/></xsl:otherwise>
      </xsl:choose>
      <xsl:if test="$prefix='SS' and $setdefault='setdefault'"> with values </xsl:if>
    </xsl:if>
    <xsl:if test="$prefix='SS' and string-length(@IDENTITY)>0"> identity(<xsl:value-of select="@IDENTITY"/>,1)</xsl:if>
    
    <xsl:choose>
      <xsl:when test="@NOTNULL='Y'"> NOT NULL</xsl:when>
      <xsl:otherwise> NULL</xsl:otherwise>
    </xsl:choose>
    <xsl:if test="position()!=last()">,</xsl:if><xsl:value-of select="$newline"/>
  </xsl:template>

<xsl:template match="FIELD" mode="alter_column_creator">
  <xsl:param name="setdefault"/>
   <xsl:value-of select="'  '"/>
    <xsl:variable name="column_name">
      <xsl:choose>
        <xsl:when test="$use_display_column_name='Y' and string-length(@DISPLAY_COLUMN_NAME)>0"><xsl:value-of select="@DISPLAY_COLUMN_NAME"/></xsl:when>
        <xsl:otherwise><xsl:value-of select="@NAME"/></xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:if test="$prefix='SS'">"</xsl:if><xsl:value-of select="$column_name"/><xsl:if test="$prefix='SS'">"</xsl:if><xsl:value-of select="'  '"/>
      <xsl:apply-templates select="." mode="dbdatatype"/>
    <xsl:if test="string-length(normalize-space(@DEFAULT))>0"> DEFAULT <xsl:comment/>
      <xsl:choose>
        <xsl:when test="@DEFAULT='user' and not($prefix='OR')">
          <xsl:if test="$prefix='SS'">CURRENT_USER</xsl:if>
          <xsl:if test="$prefix='ASA'">CURRENT USER</xsl:if> <!--NOT SURE ABOUT THIS!!-->
        </xsl:when>
        <xsl:when test="@DEFAULT='sysdate' and not($prefix='OR')">
          <xsl:if test="$prefix='SS'">getDate()</xsl:if>
          <xsl:if test="$prefix='ASA'">
            <xsl:if test="@DATATYPE='date'">CURRENT DATE</xsl:if>
            <xsl:if test="@DATATYPE='timestamp'">CURRENT TIMESTAMP</xsl:if>
          </xsl:if>
        </xsl:when>
        <xsl:otherwise><xsl:value-of select="@DEFAULT"/></xsl:otherwise>
      </xsl:choose>
      <xsl:if test="$prefix='SS' and $setdefault='setdefault'"> with values </xsl:if>
    </xsl:if>
    <xsl:if test="$prefix='SS' and string-length(@IDENTITY)>0"> identity(<xsl:value-of select="@IDENTITY"/>,1)</xsl:if>
	
	<xsl:choose>
	  <xsl:when test="not ($column_name='auditdata_id')">
		<xsl:if test="@NOTNULL='Y'"> NOT NULL</xsl:if>
		<xsl:if test="@NOTNULL='N'"> NULL</xsl:if>
	  </xsl:when>
    </xsl:choose>
    <xsl:if test="position()!=last()">,</xsl:if><xsl:value-of select="$newline"/>
  </xsl:template>

  <xsl:template match="schema" mode="inline_column_creator">
  <xsl:param name="setdefault"/>
   <xsl:value-of select="'  '"/>
    <xsl:variable name="column_name">
      <xsl:choose>
        <xsl:when test="$use_display_column_name='Y' and string-length(@DISPLAY_COLUMN_NAME)>0"><xsl:value-of select="@DISPLAY_COLUMN_NAME"/></xsl:when>
        <xsl:otherwise><xsl:value-of select="@NAME"/></xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:if test="$prefix='SS'">"</xsl:if><xsl:value-of select="$column_name"/><xsl:if test="$prefix='SS'">"</xsl:if><xsl:value-of select="'  '"/>
      <xsl:apply-templates select="." mode="dbdatatype"/>
    <xsl:if test="string-length(normalize-space(@DEFAULT))>0"> DEFAULT <xsl:comment/>
      <xsl:choose>
        <xsl:when test="@DEFAULT='user' and not($prefix='OR')">
          <xsl:if test="$prefix='SS'">CURRENT_USER</xsl:if>
          <xsl:if test="$prefix='ASA'">CURRENT USER</xsl:if> <!--NOT SURE ABOUT THIS!!-->
        </xsl:when>
        <xsl:when test="@DEFAULT='sysdate' and not($prefix='OR')">
          <xsl:if test="$prefix='SS'">getDate()</xsl:if>
          <xsl:if test="$prefix='ASA'">
            <xsl:if test="@DATATYPE='date'">CURRENT DATE</xsl:if>
            <xsl:if test="@DATATYPE='timestamp'">CURRENT TIMESTAMP</xsl:if>
          </xsl:if>
        </xsl:when>
        <xsl:otherwise><xsl:value-of select="@DEFAULT"/></xsl:otherwise>
      </xsl:choose>
      <xsl:if test="$prefix='SS' and $setdefault='setdefault'"> with values </xsl:if>
    </xsl:if>

    <xsl:if test="$prefix='SS' and string-length(@IDENTITY)>0"> identity(<xsl:value-of select="@IDENTITY"/>,1)</xsl:if>
    
    <xsl:choose>
      <xsl:when test="@NOTNULL='Y'"> NOT NULL</xsl:when>
      <xsl:otherwise> NULL</xsl:otherwise>
    </xsl:choose>
    <xsl:if test="position()!=last()">,</xsl:if><xsl:value-of select="$newline"/>
  </xsl:template>

 <xsl:template match="FIELD|schema" mode="dbdatatype">
  <xsl:if test="$prefix='SS' and $ssmigtables='Y'">
      <xsl:choose>
        <xsl:when test="@DATATYPE='integer' or @DATATYPE='int'">integer</xsl:when>
        <xsl:when test="@DATATYPE='identity'">integer identity(1,1)</xsl:when>
        <xsl:when test="@DATATYPE='smallint'">smallint</xsl:when>
        <xsl:when test="@DATATYPE='tinyint'">tinyint</xsl:when>
        <xsl:when test="@DATATYPE='bigint'">bigint</xsl:when>
        <xsl:when test="@DATATYPE='date' or @DATATYPE='timestamp' or @DATATYPE='ortimestamp'">datetime</xsl:when>
        <xsl:when test="@DATATYPE='blob' or @DATATYPE='blob_sf'">TEXT</xsl:when>
        <xsl:when test="@DATATYPE='clob' or @DATATYPE='memo'">TEXT</xsl:when>
        <xsl:when test="@DATATYPE='image'">IMAGE</xsl:when>
        <xsl:when test="@DATATYPE='long string'">VARCHAR(4000)</xsl:when>
        <xsl:when test="@DATATYPE='number'">DECIMAL(28,10)</xsl:when>
        <xsl:when test="@DATATYPE='string'">nvarchar(<xsl:value-of select="@CHARLENGTH"/>)</xsl:when>
		<xsl:when test="@DATATYPE='varbinary'">varbinary(<xsl:value-of select="@CHARLENGTH"/>)</xsl:when>
        <xsl:when test="@DATATYPE='character' or @DATATYPE='ocharacter'">char(<xsl:value-of select="@CHARLENGTH"/>)</xsl:when>
        <xsl:when test="@DATATYPE='double'">numeric(<xsl:value-of select="@DATAPRECISION"/>,<xsl:value-of select="@DATASCALE"/>)</xsl:when>
        <xsl:when test="@DATATYPE='binary'">binary(<xsl:value-of select="@CHARLENGTH"/>)</xsl:when>
        <xsl:when test="@DATATYPE='float'">FLOAT</xsl:when>
        <xsl:when test="@DATATYPE='xml'">xml</xsl:when>
        <xsl:when test="@DATATYPE='geometry'">TEXT</xsl:when>
        <xsl:otherwise>NO VALID DATA TYPE</xsl:otherwise>
      </xsl:choose>
    </xsl:if>
  <xsl:if test="$prefix='OR'">
      <xsl:choose>
        <xsl:when test="@DATATYPE='integer' or @DATATYPE='int'">number(10)</xsl:when>
        <xsl:when test="@DATATYPE='identity'">number(<xsl:value-of select="@DATAPRECISION"/>)</xsl:when>
        <xsl:when test="@DATATYPE='smallint'">number(4)</xsl:when>
        <xsl:when test="@DATATYPE='tinyint'">number(2)</xsl:when>
        <xsl:when test="@DATATYPE='bigint'">number(19)</xsl:when>
        <xsl:when test="@DATATYPE='date' or @DATATYPE='timestamp'">DATE</xsl:when>
        <xsl:when test="@DATATYPE='ortimestamp'">TIMESTAMP(<xsl:value-of select="@DATASCALE"/>)</xsl:when>
        <xsl:when test="@DATATYPE='blob' or @DATATYPE='blob_sf'">BLOB</xsl:when>
        <xsl:when test="@DATATYPE='clob' or @DATATYPE='memo'">CLOB</xsl:when>
        <xsl:when test="@DATATYPE='image'">BLOB</xsl:when>
		<xsl:when test="@DATATYPE='varbinary'">BLOB</xsl:when>
        <xsl:when test="@DATATYPE='long string'">VARCHAR2(4000:value-of select="$char_semantics"/>)</xsl:when>
        <xsl:when test="@DATATYPE='number'">NUMBER</xsl:when>
        <xsl:when test="@DATATYPE='string'">varchar2(<xsl:value-of select="@CHARLENGTH"/><xsl:value-of select="$char_semantics"/>)</xsl:when>
        <xsl:when test="@DATATYPE='character' or @DATATYPE='ocharacter'">char(<xsl:value-of select="@CHARLENGTH"/><xsl:value-of select="$char_semantics"/>)</xsl:when>
        <xsl:when test="@DATATYPE='double'">number(<xsl:value-of select="@DATAPRECISION"/>,<xsl:value-of select="@DATASCALE"/>)</xsl:when>
        <xsl:when test="@DATATYPE='raw'">raw(<xsl:value-of select="@CHARLENGTH"/></xsl:when>
        <xsl:when test="@DATATYPE='float'">FLOAT</xsl:when>
        <xsl:when test="@DATATYPE='binary'">raw(<xsl:value-of select="@CHARLENGTH"/>)</xsl:when>
        <xsl:when test="@DATATYPE='xml'">xmltype</xsl:when>
        <xsl:when test="@DATATYPE='geometry'">SDO_GEOMETRY</xsl:when>
        <xsl:otherwise>NO VALID DATA TYPE</xsl:otherwise>
      </xsl:choose>
    </xsl:if>
    <xsl:if test="$prefix='SS' and $ssmigtables ='N'">
      <xsl:choose>
        <xsl:when test="@DATATYPE='integer' or @DATATYPE='int'">integer</xsl:when>
        <xsl:when test="@DATATYPE='identity'">integer identity(1,1)</xsl:when>
        <xsl:when test="@DATATYPE='smallint'">smallint</xsl:when>
        <xsl:when test="@DATATYPE='tinyint'">tinyint</xsl:when>
        <xsl:when test="@DATATYPE='bigint'">bigint</xsl:when>
        <xsl:when test="@DATATYPE='date' or @DATATYPE='timestamp' or @DATATYPE='ortimestamp'">datetime</xsl:when>
        <xsl:when test="@DATATYPE='blob' or @DATATYPE='blob_sf'">TEXT</xsl:when>
        <xsl:when test="@DATATYPE='clob' or @DATATYPE='memo'">TEXT</xsl:when>
        <xsl:when test="@DATATYPE='image'">IMAGE</xsl:when>
        <xsl:when test="@DATATYPE='long string'">VARCHAR(4000)</xsl:when>
        <xsl:when test="@DATATYPE='number'">DECIMAL(28,10)</xsl:when>
        <xsl:when test="@DATATYPE='string'">varchar(<xsl:value-of select="@CHARLENGTH"/>)</xsl:when>
		<xsl:when test="@DATATYPE='varbinary'">varbinary(<xsl:value-of select="@CHARLENGTH"/>)</xsl:when>
        <xsl:when test="@DATATYPE='character' or @DATATYPE='ocharacter'">char(<xsl:value-of select="@CHARLENGTH"/>)</xsl:when>
        <xsl:when test="@DATATYPE='double'">numeric(<xsl:value-of select="@DATAPRECISION"/>,<xsl:value-of select="@DATASCALE"/>)</xsl:when>
        <xsl:when test="@DATATYPE='binary'">binary(<xsl:value-of select="@CHARLENGTH"/>)</xsl:when>
        <xsl:when test="@DATATYPE='float'">FLOAT</xsl:when>
        <xsl:when test="@DATATYPE='xml'">xml</xsl:when>
        <xsl:when test="@DATATYPE='geometry'">TEXT</xsl:when>
        <xsl:otherwise>NO VALID DATA TYPE</xsl:otherwise>
      </xsl:choose>
    </xsl:if>
    <xsl:if test="$prefix='ASA'">
      <xsl:choose>
        <xsl:when test="@DATATYPE='integer' or @DATATYPE='int'">integer</xsl:when>
        <xsl:when test="@DATATYPE='identity'">integer</xsl:when>
        <xsl:when test="@DATATYPE='smallint'">smallint</xsl:when>
        <xsl:when test="@DATATYPE='tinyint'">tinyint</xsl:when>
        <xsl:when test="@DATATYPE='bigint'">bigint</xsl:when>
        <xsl:when test="@DATATYPE='date' or @DATATYPE='timestamp' or @DATATYPE='ortimestamp'">datetime</xsl:when>
        <xsl:when test="@DATATYPE='blob'">TEXT</xsl:when>
        <xsl:when test="@DATATYPE='clob' or @DATATYPE='memo'">long binary</xsl:when>
        <xsl:when test="@DATATYPE='image'">long binary</xsl:when>
        <xsl:when test="@DATATYPE='long string'">long varchar</xsl:when>
        <xsl:when test="@DATATYPE='number'">DECIMAL(28,10)</xsl:when>
        <xsl:when test="@DATATYPE='string'">varchar(<xsl:value-of select="@CHARLENGTH"/>)</xsl:when>
        <xsl:when test="@DATATYPE='character' or @DATATYPE='ocharacter'">varchar(<xsl:value-of select="@CHARLENGTH"/>)</xsl:when>
        <xsl:when test="@DATATYPE='double'">numeric(<xsl:value-of select="@DATAPRECISION"/>,<xsl:value-of select="@DATASCALE"/>)</xsl:when>
        <xsl:when test="@DATATYPE='binary'">binary(<xsl:value-of select="@CHARLENGTH"/>)</xsl:when>
        <xsl:when test="@DATATYPE='float'">FLOAT</xsl:when>
        <xsl:when test="@DATATYPE='xml'">long varchar</xsl:when>
        <xsl:otherwise>NO VALID DATA TYPE</xsl:otherwise>
      </xsl:choose>
    </xsl:if>
   </xsl:template>

  <xsl:template match="TABLE" mode="table_options">

    <xsl:variable name="tabletype">
      <xsl:choose>
        <xsl:when test="string-length(@TABLETYPE)>0"><xsl:value-of select="@TABLETYPE"/></xsl:when>
        <xsl:otherwise>NORMAL</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:if test="$include_storage='Y' and $tabletype != 'SESSION' and $tabletype != 'TRANSACTION'">
      <xsl:variable name="tablespace">
        <xsl:choose>
          <xsl:when test="string-length(@TABLESPACE)>0"><xsl:value-of select="@TABLESPACE"/></xsl:when>
          <xsl:otherwise><xsl:value-of select="$dat_ts"/></xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:choose>
        <xsl:when test="string-length(@STORAGESTRING)>0">
          <xsl:if test="$prefix='OR'">TABLESPACE <xsl:value-of select="$tablespace"/>
      PCTFREE <xsl:value-of select="@PCTFREE"/> PCTUSED <xsl:value-of select="@PCTUSED"/>
      STORAGE <xsl:value-of select="@STORAGESTRING"/>

          </xsl:if>
        </xsl:when>
        <xsl:otherwise>
          <xsl:if test="$prefix='OR'"><xsl:apply-templates select="STORAGE" mode="storage_clause"/></xsl:if>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:if test="$prefix='OR'">
        <xsl:for-each select="FIELD[(@DATATYPE='blob' or @DATATYPE='clob') and string-length($lob_ts)>0]">
,LOB(<xsl:value-of select="@NAME"/>) store as (TABLESPACE <xsl:value-of select="$lob_ts"/> storage(minextents 1 maxextents UNLIMITED) NOCACHE)<xsl:comment/>
        </xsl:for-each>
      </xsl:if>
	<xsl:if test="$prefix='OR'">
        <xsl:for-each select="FIELD[(@DATATYPE='blob_sf' or @DATATYPE='clob_sf') and string-length($lob_ts)>0]">
,LOB(<xsl:value-of select="@NAME"/>) store as SECUREFILE (TABLESPACE <xsl:value-of select="$lob_ts"/> DISABLE STORAGE IN ROW NOCACHE)<xsl:comment/>
        </xsl:for-each>
    </xsl:if>
    </xsl:if>
    <xsl:if test="$include_storage='Y' and @TABLETYPE = 'SESSION' and $prefix='OR'">ON COMMIT PRESERVE ROWS</xsl:if>
    <xsl:if test="$include_storage='Y' and @TABLETYPE = 'TRANSACTION' and $prefix='OR'">ON COMMIT DELETE ROWS</xsl:if>
  </xsl:template>

  <xsl:template match="TABLE" mode="partition">
  <xsl:param name="tablename"/>
    <xsl:variable name="ispartitioned" select="@ISPARTITIONED"/>
    <xsl:variable name="partitiontype" select="@PARTITIONTYPE"/>
    <xsl:variable name="partitionkey" select="@PARTITIONKEY"/>

<xsl:if test="$prefix='OR' and $ispartitioned='Y' and $partitioned='Y'">
PARTITION BY <xsl:value-of select="$partitiontype"/>(<xsl:value-of select="$partitionkey"/>)<xsl:choose><xsl:when test="$partitiontype='LIST'">
(<xsl:for-each select="document($internal_schema_name)/PrimaveraDatabaseSchema/TABLE/PARTITION[@TABLE=$tablename]">
PARTITION <xsl:value-of select="@NAME"/> VALUES (<xsl:value-of select="@VALUE"/>)<xsl:if test="position()!=last()">,</xsl:if></xsl:for-each>)
</xsl:when>
<xsl:when test="$partitiontype='RANGE'">
   <xsl:variable name="partitioninterval" select="@PARTITIONINTERVAL"/>
INTERVAL(<xsl:value-of select="$partitioninterval"/>)<xsl:for-each select="document($internal_schema_name)/PrimaveraDatabaseSchema/TABLE/PARTITION[@TABLE=$tablename]">
(PARTITION <xsl:value-of select="@NAME"/> VALUES LESS THAN(TO_DATE(<xsl:value-of select="@VALUE"/>,'DD-MM-YYYY'))<xsl:if test="position()!=last()">,</xsl:if></xsl:for-each>)
</xsl:when></xsl:choose>
ENABLE ROW MOVEMENT
</xsl:if>
  </xsl:template>
  
  <xsl:template match="TABLE" mode="nologging">
    <xsl:variable name="isnologging" select="@ISNOLOGGING"/>
<xsl:if test="$prefix='OR' and $isnologging='Y'">
NOLOGGING
</xsl:if>
  </xsl:template>
  
  <xsl:template match="TABLE" mode="inmemory">
    <xsl:variable name="isinmemory" select="@ISINMEMORY"/>
<xsl:if test="$prefix='OR' and $isinmemory='Y'">
INMEMORY
</xsl:if>
  </xsl:template>

  <xsl:template match="STORAGE" mode="storage_clause">
    <xsl:param name="type"/>TABLESPACE <xsl:choose>
      <xsl:when test="string-length(@TABLESPACE)"><xsl:value-of select="@TABLESPACE"/></xsl:when>
      <xsl:when test="$type='index' and string-length($ndx_ts)>0"><xsl:value-of select="$ndx_ts"/></xsl:when>
      <xsl:otherwise><xsl:value-of select="$dat_ts"/></xsl:otherwise>
    </xsl:choose>
    
    <xsl:if test="string-length(@PCTFREE)>0"> PCTFREE <xsl:value-of select="@PCTFREE"/></xsl:if>
    <xsl:if test="string-length(@INITIAL)>0">
    STORAGE (INITIAL <xsl:value-of select="@INITIAL"/>
      <xsl:if test="string-length(@NEXT)>0"> NEXT <xsl:value-of select="@NEXT"/></xsl:if>
      <xsl:if test="string-length(@MAXEXTENTS)>0"> MAXEXTENTS <xsl:value-of select="@MAXEXTENTS"/></xsl:if>
      <xsl:if test="string-length(@MINEXTENTS)>0"> MINEXTENTS <xsl:value-of select="@MINEXTENTS"/></xsl:if>
      <xsl:if test="string-length(@PCTINCREASE)>0"> PCTINCREASE <xsl:value-of select="@PCTINCREASE"/></xsl:if>)<xsl:comment/>
    </xsl:if>
  </xsl:template>


  <xsl:template match="item" mode="synonym">
      <xsl:variable name="table_name" select="tabname"/>
      <xsl:variable name="owner">
      	<xsl:choose>
      		<xsl:when test="$prefix='SS' and owner='ADMUSER'">dbo</xsl:when>
      		<xsl:otherwise><xsl:value-of select="owner"/></xsl:otherwise>
      	</xsl:choose>
      </xsl:variable>
      <xsl:variable name="update_date" select="document($internal_schema_name)/PrimaveraDatabaseSchema/TABLE[@NAME=$table_name]/FIELD[@NAME='update_date']/@NAME"/>
      <xsl:choose>
        <xsl:when test="chgtype='CREATE' and type='LDV' and string-length($update_date)>0 and $option_synonyms='Y'and $object_owner=$owner">
          <xsl:call-template name="SSCR">
            <xsl:with-param name="object_name"><xsl:value-of select="$owner"/>.<xsl:value-of select="objname"/></xsl:with-param>
            <xsl:with-param name="type">VIEW</xsl:with-param>
          </xsl:call-template>
--METADATA NAME:<xsl:value-of select="objname"/> TYPE:VIEW TARGET_OBJECT:<xsl:value-of select="tabname"/> CHANGE:<xsl:value-of select="chgtype"/>
CREATE<xsl:if test="$sprefix='OR'"> OR REPLACE</xsl:if> VIEW <xsl:if test="$sprefix='SS'">PRIVUSER.</xsl:if><xsl:value-of select="objname"/> as select * from <xsl:value-of select="$admuser"/><xsl:value-of select="objname"/> where delete_session_id is null
<xsl:if test="$prefix='OR'">/</xsl:if><xsl:if test="$prefix='SS' or $prefix='ASA'">go</xsl:if>
 <xsl:if test="position() = last()"><xsl:value-of select="$newline"/></xsl:if>
        </xsl:when>
        <xsl:when test="chgtype='CREATE' and contains(target,$prefix) and $option_synonyms='Y' and $object_owner=$owner">
--METADATA NAME:<xsl:value-of select="objname"/> TYPE:SYNONYM TARGET_OBJECT:<xsl:value-of select="tabname"/> CHANGE:<xsl:value-of select="chgtype"/>
CREATE<xsl:if test="$sprefix='OR'"> OR REPLACE</xsl:if> SYNONYM <xsl:value-of select="objname"/> FOR <xsl:value-of select="$admuser"/><xsl:value-of select="objname"/><xsl:value-of select="$newline"/> 
<xsl:if test="$prefix='OR'">/</xsl:if><xsl:if test="$prefix='SS' or $prefix='ASA'">go</xsl:if><xsl:value-of select="$newline"/> 
</xsl:when>
     <xsl:when test="chgtype='DROP' and contains(target,$prefix) and type!='LDV' and $option_synonyms='Y'">
 <xsl:if test="$prefix='OR'">   
--METADATA NAME:<xsl:value-of select="objname"/> TYPE:SYNONYM TARGET_OBJECT:<xsl:value-of select="tabname"/> CHANGE:<xsl:value-of select="chgtype"/>
DROP SYNONYM <xsl:value-of select="$owner"/>.<xsl:value-of select="objname"/><xsl:value-of select="$newline"/> 
  <xsl:if test="$prefix='OR'">/</xsl:if><xsl:if test="$prefix='SS' or $prefix='ASA'">go</xsl:if><xsl:value-of select="$newline"/> 
   <xsl:variable name="stype"> <xsl:value-of select="type"/></xsl:variable>
   <xsl:if test="$stype='VIEW'">
--METADATA NAME:<xsl:value-of select="objname"/> TYPE:VIEW TARGET_OBJECT:<xsl:value-of select="tabname"/> CHANGE:<xsl:value-of select="chgtype"/>
DROP VIEW <xsl:value-of select="objname"/><xsl:value-of select="$newline"/> 
  <xsl:if test="$prefix='OR'">/</xsl:if><xsl:if test="$prefix='SS' or $prefix='ASA'">go</xsl:if>
  </xsl:if>
</xsl:if>  
<xsl:variable name="stype"> <xsl:value-of select="type"/></xsl:variable>
<xsl:variable name="subtype"> <xsl:value-of select="subtype"/></xsl:variable>
 <xsl:if test="$prefix='SS'and $subtype !='PROCEDURE'">  
  <xsl:if test="$stype='VIEW'">
--METADATA NAME:<xsl:value-of select="objname"/> TYPE:VIEW TARGET_OBJECT:<xsl:value-of select="tabname"/> CHANGE:<xsl:value-of select="chgtype"/>
DROP VIEW <xsl:value-of select="objname"/> 
go
 </xsl:if>
</xsl:if>
  <xsl:if test="position() = last()"><xsl:value-of select="$newline"/></xsl:if>
  </xsl:when>
    <xsl:when test="chgtype='DROP' and type='LDV' and $option_synonyms='Y'">
--METADATA NAME:<xsl:value-of select="objname"/> TYPE:VIEW TARGET_OBJECT:<xsl:value-of select="tabname"/> CHANGE:<xsl:value-of select="chgtype"/>
DROP VIEW <xsl:value-of select="$owner"/>.<xsl:value-of select="objname"/><xsl:value-of select="$newline"/> 
  <xsl:if test="$prefix='OR'">/</xsl:if><xsl:if test="$prefix='SS' or $prefix='ASA'">go</xsl:if>
  <xsl:if test="position() = last()"><xsl:value-of select="$newline"/></xsl:if>
  </xsl:when>
    <xsl:when test="chgtype='DROP' and objtype='LDV' and $option_synonyms='Y'">
--METADATA NAME:<xsl:value-of select="objname"/> TYPE:VIEW TARGET_OBJECT:<xsl:value-of select="tabname"/> CHANGE:<xsl:value-of select="chgtype"/>
DROP VIEW <xsl:value-of select="$owner"/>.<xsl:value-of select="objname"/><xsl:value-of select="$newline"/> 
  <xsl:if test="$prefix='OR'">/</xsl:if><xsl:if test="$prefix='SS' or $prefix='ASA'">go</xsl:if>
  <xsl:if test="position() = last()"><xsl:value-of select="$newline"/></xsl:if>
  </xsl:when>
  </xsl:choose> 
  </xsl:template>

   <xsl:template match="item" mode="procedure">
       <xsl:if test="$option_procedures='Y'">
         <xsl:variable name="sql2kfunc">
           <xsl:if test="sql2kfunc='Y' and $prefix='SS'">Y</xsl:if>
         </xsl:variable>
       <xsl:choose>
         <xsl:when test="chgtype='DROP'and ( type='PROCEDURE' or $sql2kfunc='Y')">
--METADATA NAME:<xsl:value-of select="objname"/> TYPE:PROCEDURE TARGET_OBJECT:<xsl:value-of select="objname"/> CHANGE:<xsl:value-of select="chgtype"/>
DROP PROCEDURE  <xsl:value-of select="objname"/></xsl:when>
   <xsl:when test="chgtype='DROP'and type='FUNCTION' and $sql2kfunc!='Y'">
--METADATA NAME:<xsl:value-of select="objname"/> TYPE:FUNCTION TARGET_OBJECT:<xsl:value-of select="objname"/> CHANGE:<xsl:value-of select="chgtype"/>
DROP FUNCTION  <xsl:value-of select="objname"/></xsl:when>
   <xsl:when test="chgtype='DROP'and type='PACKAGE'">
--METADATA NAME:<xsl:value-of select="objname"/> TYPE:PACKAGE TARGET_OBJECT:<xsl:value-of select="objname"/> CHANGE:<xsl:value-of select="chgtype"/>
DECLARE
  obj_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO obj_exists FROM user_objects WHERE object_name = UPPER('<xsl:value-of select="objname"/>');
  IF obj_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP PACKAGE <xsl:value-of select="objname"/>';
  END IF;
END;
</xsl:when>
	<xsl:when test="chgtype='DROP'and type='TYPE'">
--METADATA NAME:<xsl:value-of select="objname"/> TYPE:TYPE TARGET_OBJECT:<xsl:value-of select="objname"/> CHANGE:<xsl:value-of select="chgtype"/>
DROP TYPE  <xsl:value-of select="objname"/></xsl:when>
       </xsl:choose>
 	<xsl:if test="chgtype='DROP'">       
<xsl:value-of select="$newline"/>    
<xsl:if test="$prefix='OR'">/</xsl:if><xsl:if test="$prefix='SS' or $prefix='ASA'">go</xsl:if>
 	</xsl:if>  
      </xsl:if>  
  </xsl:template>

  <xsl:template match="item" mode="grant">
      <xsl:variable name="grantee">
      	<xsl:choose>
      		<xsl:when test="$prefix='SS' and grantee='ADMUSER'">dbo</xsl:when>
      		<xsl:otherwise><xsl:value-of select="grantee"/></xsl:otherwise>
      	</xsl:choose>
      </xsl:variable>

    <xsl:if test="chgtype='CREATE' and contains(target,$prefix) and $option_grants='Y'">
--METADATA NAME:<xsl:value-of select="objname"/> TYPE:GRANT TABLE_NAME:<xsl:value-of select="tabname"/> CHANGE:<xsl:value-of select="chgtype"/>
GRANT <xsl:choose>
  <xsl:when test="subtype='TABLE' and $grantee!='PUBUSER' and $grantee!='PXDMUSER' and $grantee!='PXRPTUSER'">SELECT,INSERT,UPDATE,DELETE</xsl:when>
  <xsl:otherwise>SELECT</xsl:otherwise>
</xsl:choose> ON <xsl:value-of select="objname"/> TO <xsl:choose><xsl:when test="($prefix='SS' or $prefix='ASA') and $grantee='EXPADMIN'">EXP</xsl:when><xsl:otherwise><xsl:value-of select="$grantee"/></xsl:otherwise></xsl:choose><xsl:value-of select="$newline"/>
      <xsl:if test="$prefix='OR'">/</xsl:if><xsl:if test="$prefix='SS' or $prefix='ASA'">go</xsl:if>
<xsl:if test="position() = last()"><xsl:value-of select="$newline"/></xsl:if>
    </xsl:if>

<xsl:if test="$prefix='OR' and syntype='SYNONYM' and pxtable='N' and $grantee='PRIVUSER' and $object_owner='ADMUSER'">
--METADATA NAME:<xsl:value-of select="objname"/> TYPE:GRANT TABLE_NAME:<xsl:value-of select="tabname"/> CHANGE:<xsl:value-of select="chgtype"/>
GRANT FLASHBACK ON <xsl:value-of select="objname"/> TO <xsl:value-of select="$grantee"/>
/
</xsl:if>
    <xsl:if test="chgtype='DROP' and contains(target,$prefix) and $option_grants='Y'">
--METADATA NAME:<xsl:value-of select="objname"/> TYPE:REVOKE TABLE_NAME:<xsl:value-of select="tabname"/> CHANGE:<xsl:value-of select="chgtype"/>
REVOKE <xsl:choose>
   <xsl:when test="subtype='TABLE'and $grantee='PRIVUSER'">SELECT,INSERT,UPDATE,DELETE</xsl:when>
   <xsl:otherwise>SELECT</xsl:otherwise>
   </xsl:choose> ON <xsl:value-of select="objname"/> FROM <xsl:value-of select="$grantee"/><xsl:value-of select="$newline"/>
   <xsl:if test="$prefix='OR'">/</xsl:if><xsl:if test="$prefix='SS' or $prefix='ASA'">go</xsl:if> 
   <xsl:if test="position() = last()"><xsl:value-of select="$newline"/></xsl:if>
</xsl:if>
  </xsl:template>
  
  <xsl:template match="item" mode="viewgrants">
   <xsl:variable name="grantee"><xsl:value-of select="grantee"/></xsl:variable>
  <xsl:if test="chgtype='CREATE' and contains(target,$prefix) and $option_views='Y'">
--METADATA NAME:<xsl:value-of select="objname"/> TYPE:GRANT VIEW_NAME:<xsl:value-of select="objname"/> CHANGE:<xsl:value-of select="chgtype"/>
GRANT <xsl:choose>
    <xsl:when test="objtype='VIEW' and $grantee!='PUBUSER'">SELECT,INSERT,UPDATE,DELETE</xsl:when>
    <xsl:otherwise>SELECT</xsl:otherwise>
  </xsl:choose> ON <xsl:value-of select="objname"/> TO <xsl:choose><xsl:when test="($prefix='SS' or $prefix='ASA') and $grantee='EXPADMIN'">EXP</xsl:when><xsl:otherwise><xsl:value-of select="grantee"/></xsl:otherwise></xsl:choose><xsl:value-of select="$newline"/>
        <xsl:if test="$prefix='OR'">/</xsl:if><xsl:if test="$prefix='SS' or $prefix='ASA'">go</xsl:if>
  <xsl:if test="position() = last()"><xsl:value-of select="$newline"/></xsl:if>
      </xsl:if>
  </xsl:template>

  <xsl:template match="item" mode="field">
    <xsl:variable name="table_name" select="tabname"/>
    <xsl:variable name="column_name" select="objname"/>
    <xsl:variable name="field_change" select="fieldchange"/>
    <xsl:variable name="source_val" select="sourceval"/>
<xsl:if test="chgtype='DROP' and $prefix='OR'"> 
--METADATA NAME:<xsl:value-of select="objname"/> TYPE:FIELD TABLE_NAME:<xsl:value-of select="tabname"/> CHANGE:<xsl:value-of select="chgtype"/>
ALTER TABLE <xsl:value-of select="tabname"/> drop column  <xsl:value-of select="objname" /> CASCADE CONSTRAINTS
<xsl:call-template name="prefix"/>
    </xsl:if>    
    <xsl:if test="chgtype='ALTER' and  $field_change='NULLABLE' and $prefix='OR'"> 
--METADATA NAME:<xsl:value-of select="objname"/> TYPE:FIELD TABLE_NAME:<xsl:value-of select="tabname"/> CHANGE:<xsl:value-of select="chgtype"/>
ALTER TABLE <xsl:value-of select="tabname"/> modify <xsl:value-of select="objname" /> NULL
<xsl:call-template name="prefix"/>
    </xsl:if>
 <xsl:if test="chgtype='ALTER' and  $field_change!='NULLABLE' and $prefix='OR'"> 
<xsl:if test="contains($field_change,'charlength change')">
--METADATA NAME:<xsl:value-of select="objname"/> TYPE:FIELD TABLE_NAME:<xsl:value-of select="tabname"/> CHANGE:<xsl:value-of select="chgtype"/>
ALTER TABLE <xsl:value-of select="tabname"/> modify <xsl:value-of select="objname" /> varchar2(<xsl:value-of select="targetval"/> CHAR)
<xsl:call-template name="prefix"/>
    </xsl:if>	    
  </xsl:if>  
 <xsl:if test="chgtype='ALTER' and  $field_change!='NULLABLE' and $prefix='OR'"> 
<xsl:if test="contains($field_change,'defaultvalue change')">
--METADATA NAME:<xsl:value-of select="objname"/> TYPE:FIELD TABLE_NAME:<xsl:value-of select="tabname"/> CHANGE:<xsl:value-of select="chgtype"/>
ALTER TABLE <xsl:value-of select="tabname"/> modify <xsl:value-of select="objname" /> DEFAULT <xsl:value-of select="targetval"/> <xsl:value-of select="$newline"/>
<xsl:call-template name="prefix"/>
    </xsl:if>	    
  </xsl:if>  
 <xsl:if test="chgtype='DROP' and $prefix='SS'"> 
--METADATA NAME:<xsl:value-of select="objname"/> TYPE:EXEC
 declare @default_name varchar(255)
 declare @col_name varchar(255)
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('<xsl:value-of select="tabname"/>') and col_name(parent_object_id,parent_column_id)='<xsl:value-of select="objname" />'
 if @default_name is not null
  exec ('alter table dbo.<xsl:value-of select="tabname"/> drop constraint '+@default_name)
--METADATA NAME:<xsl:value-of select="objname"/> TYPE:FIELD TABLE_NAME:<xsl:value-of select="tabname"/> CHANGE:<xsl:value-of select="chgtype"/>
ALTER TABLE <xsl:value-of select="tabname"/> drop column  <xsl:value-of select="objname" /><xsl:value-of select="$newline"/>
<xsl:call-template name="prefix"/>
    </xsl:if> 
<xsl:if test="chgtype='ALTER' and  $field_change='NULLABLE' and $prefix='SS'"> 
--METADATA NAME:<xsl:value-of select="objname"/> TYPE:FIELD TABLE_NAME:<xsl:value-of select="tabname"/> CHANGE:<xsl:value-of select="chgtype"/>
<xsl:variable name="datatype">
<xsl:apply-templates select="document($internal_schema_name)/PrimaveraDatabaseSchema/TABLE[@NAME=$table_name]/FIELD[@NAME=$column_name]" mode="dbdatatype" />
</xsl:variable>
ALTER TABLE <xsl:value-of select="tabname"/> ALTER COLUMN <xsl:value-of select="objname" /><xsl:value-of select="' '"/> <xsl:value-of select="$datatype" /> NULL
<xsl:call-template name="prefix"/>
   </xsl:if>	    
 <xsl:if test="chgtype='ALTER' and  $field_change!='NULLABLE' and $prefix='SS'"> 
--METADATA NAME:<xsl:value-of select="objname"/> TYPE:FIELD TABLE_NAME:<xsl:value-of select="tabname"/> CHANGE:<xsl:value-of select="chgtype"/>
<xsl:variable name="datatype">
<xsl:apply-templates select="document($internal_schema_name)/PrimaveraDatabaseSchema/TABLE[@NAME=$table_name]/FIELD[@NAME=$column_name]" mode="dbdatatype" />
</xsl:variable>
<xsl:variable name="notnull">
<xsl:value-of select="document($internal_schema_name)/PrimaveraDatabaseSchema/TABLE[@NAME=$table_name]/FIELD[@NAME=$column_name]/@NOTNULL" />
</xsl:variable>
<xsl:if test="contains($field_change,'charlength change')">
ALTER TABLE <xsl:value-of select="tabname"/> ALTER COLUMN <xsl:value-of select="objname" /><xsl:value-of select="' '"/> <xsl:value-of select="$datatype" /> <xsl:if test="$notnull='Y'"> NOT NULL </xsl:if> <xsl:value-of select="$newline"/>

<xsl:call-template name="prefix"/>
 </xsl:if>
   </xsl:if>
 <xsl:if test="chgtype='ALTER' and  $field_change!='NULLABLE' and $prefix='SS'"> 
--METADATA NAME:<xsl:value-of select="objname"/> TYPE:FIELD TABLE_NAME:<xsl:value-of select="tabname"/> CHANGE:<xsl:value-of select="chgtype"/>
<xsl:variable name="datatype">
<xsl:apply-templates select="document($internal_schema_name)/PrimaveraDatabaseSchema/TABLE[@NAME=$table_name]/FIELD[@NAME=$column_name]" mode="dbdatatype" />
</xsl:variable>
<xsl:if test="contains($field_change,'defaultvalue change')">
 <!--<xsl:if test="$source_val!=''"> -->
declare @default sysname, @sql nvarchar(max)

select @default = name
from sys.default_constraints
where parent_object_id = object_id('<xsl:value-of select="tabname"/>')
AND type = 'D'
AND parent_column_id = (
    select column_id
    from sys.columns
    where object_id = object_id('<xsl:value-of select="tabname"/>')
    and name = '<xsl:value-of select="objname" />'
    )

set @sql = N'alter table <xsl:value-of select="tabname"/> drop constraint ' + @default
print @sql
exec sp_executesql @sql
 <!--</xsl:if>-->
ALTER TABLE <xsl:value-of select="tabname"/> ADD DEFAULT (<xsl:value-of select="targetval"/>) FOR [<xsl:value-of select="objname" />] <xsl:value-of select="$newline"/>
<xsl:call-template name="prefix"/>
 </xsl:if>
   </xsl:if>
     <!-- Most of the time we will be running by refering to the schema document, using this choice -->
   <xsl:if test="chgtype='CREATE'">
     <xsl:variable name="setdef">setdefault</xsl:variable>
     <xsl:choose>
     <xsl:when test="$inline_schema='false'">
--METADATA NAME:<xsl:value-of select="objname"/> TYPE:FIELD TABLE_NAME:<xsl:value-of select="tabname"/> CHANGE:<xsl:value-of select="chgtype"/>
<xsl:if test="$prefix='OR'">
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('<xsl:value-of select="tabname"/>') and column_name=upper('<xsl:value-of select="objname" />');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE <xsl:value-of select="tabname"/> add <xsl:apply-templates select="document($internal_schema_name)/PrimaveraDatabaseSchema/TABLE[@NAME=$table_name]/FIELD[@NAME=$column_name]" mode="alter_column_creator"><xsl:with-param name="setdefault" select="$setdef"/></xsl:apply-templates>';
  end if;
END;         
</xsl:if> 
<xsl:if test="$prefix='SS'">
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('<xsl:value-of select="tabname"/>') and column_name=upper('<xsl:value-of select="objname" />');
if @col_exist = 0
ALTER TABLE <xsl:value-of select="tabname"/> 
  add <xsl:apply-templates select="document($internal_schema_name)/PrimaveraDatabaseSchema/TABLE[@NAME=$table_name]/FIELD[@NAME=$column_name]" mode="alter_column_creator"><xsl:with-param name="setdefault" select="$setdef"/> </xsl:apply-templates>         
</xsl:if>     
	 </xsl:when>
     
     <!-- When running in the CM Custom Column Adder type mode, however,we'll be using this branch. -->
     <xsl:otherwise>
--METADATA NAME:<xsl:value-of select="objname"/> TYPE:FIELD TABLE_NAME:<xsl:value-of select="tabname"/> CHANGE:<xsl:value-of select="chgtype"/>
ALTER TABLE <xsl:value-of select="tabname"/> add <xsl:apply-templates select="schema" mode="inline_column_creator"><xsl:with-param name="setdefault" select="$setdef"/> </xsl:apply-templates>
     </xsl:otherwise>	
     </xsl:choose>
     <xsl:call-template name="prefix"/>
   </xsl:if>		
</xsl:template>

<xsl:template match="item" mode="index">
    <xsl:variable name="table_name" select="tabname"/>
    <xsl:variable name="index_name" select="objname"/>
    <xsl:variable name="ispartitioned" select="document($internal_schema_name)/PrimaveraDatabaseSchema/TABLE[@NAME=$table_name]/@ISPARTITIONED"/>
  
    <xsl:call-template name="print_output">
      <xsl:with-param name="output">index <xsl:value-of select="objname"/> on table <xsl:value-of select="tabname"/></xsl:with-param>
      <xsl:with-param name="operation" select="chgtype"/>
    </xsl:call-template>

    <xsl:variable name="changetype" select="chgtype"/>
	<xsl:variable name="excluded_indexes" select="':NDX_PREFER_CURRTYPE:NDX_FILTPROP_RPT:NDX_TASKRSRC_CBS:NDX_GATEWAYSYNC_GATEWAYDEPL:NDX_TASK_CBS:NDX_ALERT_USERS:NDX_PROJCOST_CBS:NDX_CBS_PROJECT:NDX_PROJDEPLMENT_GATEWAYDEPL:NDX_DOC_RECENT_DOC:NDX_CHGTASKACTV_ACTVCODE:NDX_ADDTASKPROC_CHGHEAD:NDX_DOC_RECENT_DOC_FOLDER:NDX_PROJDEPLMENT_PROJECT:NDX_DEPLMNT_GATEWAYPROV:NDX_DISCUSSION_READ_USERS:'"/>
    

      <xsl:if test="$changetype='DROP' or $changetype='ALTER'">
--METADATA NAME:<xsl:value-of select="$index_name"/> TYPE:INDEX TABLE_NAME:<xsl:value-of select="$table_name"/> CHANGE:<xsl:value-of select="chgtype"/>
      <xsl:if test="$prefix='OR'">
DECLARE
  index_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO index_exists FROM user_indexes WHERE index_name = UPPER('<xsl:value-of select="$index_name"/>');

  IF index_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP INDEX <xsl:value-of select="$index_name"/>';
  END IF;
END;
      </xsl:if>
      <xsl:if test="$prefix='SS' or $prefix='ASA'">
DROP INDEX <xsl:value-of select="$table_name"/>.<xsl:value-of select="$index_name"/>;
      </xsl:if>
<xsl:if test="$prefix='OR'">/</xsl:if><xsl:if test="$prefix='SS' or $prefix='ASA'">go</xsl:if>
<xsl:if test="position() = last()"><xsl:value-of select="$newline"/></xsl:if>
      </xsl:if>

    <xsl:for-each select="document($internal_schema_name)/PrimaveraDatabaseSchema/TABLE[@NAME=$table_name]/INDEX[@NAME=$index_name]">

      <xsl:variable name="tablespace">
        <xsl:choose>
          <xsl:when test="string-length(@TABLESPACE)>0"><xsl:choose><xsl:when test="$dbtype='EXP' or $dbtype='EXPADM'"><xsl:value-of select="$ndx_ts"/></xsl:when><xsl:otherwise><xsl:value-of select="@TABLESPACE"/></xsl:otherwise></xsl:choose></xsl:when>
          <xsl:otherwise><xsl:value-of select="$dat_ts"/></xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
 
<xsl:if test="$changetype='CREATE' or $changetype='ALTER'">
--METADATA NAME:<xsl:value-of select="$index_name"/> TYPE:INDEX TABLE_NAME:<xsl:value-of select="$table_name"/> CHANGE:<xsl:value-of select="$changetype"/>  
<xsl:if test="$prefix='OR'">
<xsl:choose>
<xsl:when test="contains($excluded_indexes,concat(':',translate($index_name,$lowercase,$uppercase),':'))">
declare 
v_ind_exists number;
v_spl_ind number;
begin
<xsl:choose>
<xsl:when test="@TABLE='DISCUSSION_READ' and contains($excluded_indexes,concat(':',translate($index_name,$lowercase,$uppercase),':')) and translate(@FIELD,$lowercase,$uppercase)='USER_ID'">
select count(*)  into v_spl_ind from user_ind_columns where index_name= 'NDX_DISCUSSIONREAD_USERS' and table_name = 'DISCUSSION_READ' and 
column_name = 'USER_ID' ; 
if v_spl_ind > 0 then
execute immediate 'ALTER INDEX NDX_DISCUSSIONREAD_USERS rename to NDX_DISCUSSION_READ_USERS';
return;
end if;
</xsl:when>
<xsl:when test="@TABLE='DOC_RECENT' and contains($excluded_indexes,concat(':',translate($index_name,$lowercase,$uppercase),':')) and translate(@FIELD,$lowercase,$uppercase)='DOC_FOLDER_ID'">
select count(*) into v_spl_ind  from user_ind_columns where index_name= 'NDX_DOCRECENT_DOCFOLDER' and table_name = 'DOC_RECENT' and 
column_name = 'DOC_FOLDER_ID' ; 
if v_spl_ind > 0 then
execute immediate 'ALTER INDEX NDX_DOCRECENT_DOCFOLDER rename to NDX_DOC_RECENT_DOC_FOLDER';
return;
end if;
</xsl:when>
<xsl:when test="@TABLE='DOC_RECENT' and contains($excluded_indexes,concat(':',translate($index_name,$lowercase,$uppercase),':')) and translate(@FIELD,$lowercase,$uppercase)='DOC_ID'">
select count(*) into v_spl_ind  from user_ind_columns where index_name= 'NDX_DOCRECENT_DOC' and table_name = 'DOC_RECENT' and 
column_name = 'DOC_ID' ; 
if v_spl_ind > 0 then
execute immediate 'ALTER INDEX  NDX_DOCRECENT_DOC rename to NDX_DOC_RECENT_DOC';
return;
end if;
</xsl:when>
<xsl:when test="@TABLE='GATEWAYSYNCACTION' and contains($excluded_indexes,concat(':',translate($index_name,$lowercase,$uppercase),':')) and translate(@FIELD,$lowercase,$uppercase)='DEPLMNT_ID'">
select count(*)  into v_spl_ind from user_ind_columns where index_name= 'NDX_GS_GDEPLOYMENT' and table_name = 'GATEWAYSYNCACTION' and 
column_name = 'DEPLMNT_ID' ; 
if v_spl_ind > 0 then
execute immediate 'ALTER INDEX NDX_GS_GDEPLOYMENT rename to NDX_GATEWAYSYNC_GATEWAYDEPL';
return;
end if;
</xsl:when>
<xsl:when test="@TABLE='GATEWAYDEPLOYMENT' and contains($excluded_indexes,concat(':',translate($index_name,$lowercase,$uppercase),':')) and translate(@FIELD,$lowercase,$uppercase)='PROVIDER_ID'">
select count(*)  into v_spl_ind from user_ind_columns where index_name= 'NDX_GDEPLOYMENT_GPROVIDER' and table_name = 'GATEWAYDEPLOYMENT' and 
column_name = 'PROVIDER_ID' ; 
if v_spl_ind > 0 then
execute immediate 'ALTER INDEX NDX_GDEPLOYMENT_GPROVIDER rename to NDX_DEPLMNT_GATEWAYPROV';
return;
end if;
</xsl:when>
<xsl:when test="@TABLE='PROJDEPLMENT' and contains($excluded_indexes,concat(':',translate($index_name,$lowercase,$uppercase),':')) and translate(@FIELD,$lowercase,$uppercase)='DEPLMNT_ID'">
select count(*)  into v_spl_ind from user_ind_columns where index_name= 'NDX_PROJDEPLMENT_GDEPLOYMENT' and table_name = 'PROJDEPLMENT' and 
column_name = 'DEPLMNT_ID' ; 
if v_spl_ind > 0 then
execute immediate 'ALTER INDEX NDX_PROJDEPLMENT_GDEPLOYMENT rename to NDX_PROJDEPLMENT_GATEWAYDEPL';
return;
end if;
</xsl:when>
</xsl:choose>
select count(*) into v_ind_exists from user_ind_columns 
where index_name= '<xsl:value-of select="translate(@NAME,$lowercase,$uppercase)"/>' 
and table_name = '<xsl:value-of select="translate(@TABLE,$lowercase,$uppercase)"/>' 
and column_name = '<xsl:value-of select="translate(@FIELD,$lowercase,$uppercase)"/>' ; 
if v_ind_exists = 0 then
execute immediate 'CREATE <xsl:if test="@UNIQUENESS='UNIQUE'">UNIQUE </xsl:if>INDEX <xsl:value-of select="@NAME"/>
ON <xsl:value-of select="@TABLE"/><xsl:choose><xsl:when test="string-length(@ISFUNCTION)>0">(<xsl:value-of select="@ISFUNCTION"/>)</xsl:when><xsl:otherwise> (<xsl:value-of select="@FIELD"/>)</xsl:otherwise></xsl:choose><xsl:value-of select="$newline"/>
      <xsl:choose>
        <xsl:when test="string-length(@STORAGESTRING)>0">
          <xsl:if test="$prefix='OR'">TABLESPACE <xsl:value-of select="$tablespace"/>
    PCTFREE <xsl:value-of select="@PCTFREE"/> <xsl:if test="string-length(@PCTUSED)>0"> PCTUSED <xsl:value-of select="@PCTUSED"/></xsl:if>
    STORAGE <xsl:value-of select="@STORAGESTRING"/>
          </xsl:if>
	</xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates select="STORAGE" mode="storage_clause"/>
        </xsl:otherwise>
      </xsl:choose><xsl:if test="$ispartitioned='Y' and $prefix='OR' and $partitioned='Y'">LOCAL</xsl:if>' ;<xsl:value-of select="$newline"/>
	end if;
end;
</xsl:when>
<xsl:otherwise>
CREATE <xsl:if test="@UNIQUENESS='UNIQUE'">UNIQUE </xsl:if>INDEX <xsl:value-of select="@NAME"/>
ON <xsl:value-of select="@TABLE"/><xsl:choose><xsl:when test="string-length(@ISFUNCTION)>0">(<xsl:value-of select="@ISFUNCTION"/>)</xsl:when><xsl:otherwise> (<xsl:value-of select="@FIELD"/>)</xsl:otherwise></xsl:choose><xsl:value-of select="$newline"/>
      <xsl:choose>
        <xsl:when test="string-length(@STORAGESTRING)>0">
          <xsl:if test="$prefix='OR'">TABLESPACE <xsl:value-of select="$tablespace"/>
    PCTFREE <xsl:value-of select="@PCTFREE"/> <xsl:if test="string-length(@PCTUSED)>0"> PCTUSED <xsl:value-of select="@PCTUSED"/></xsl:if>
    STORAGE <xsl:value-of select="@STORAGESTRING"/>
          </xsl:if>
	</xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates select="STORAGE" mode="storage_clause"/>
        </xsl:otherwise>
      </xsl:choose><xsl:if test="$ispartitioned='Y' and $prefix='OR' and $partitioned='Y'">LOCAL</xsl:if><xsl:value-of select="$newline"/>
</xsl:otherwise>
</xsl:choose>
</xsl:if>  

<xsl:if test="$prefix='SS' or $prefix='ASA'">
CREATE <xsl:if test="@UNIQUENESS='UNIQUE'">UNIQUE </xsl:if> <xsl:if test="@ISCLUSTERED='Y'">CLUSTERED </xsl:if> INDEX <xsl:value-of select="@NAME"/>
ON <xsl:value-of select="@TABLE"/><xsl:choose><xsl:when test="string-length(@ISFUNCTION)>0">(<xsl:value-of select="@ISFUNCTION"/>)</xsl:when><xsl:otherwise> (<xsl:value-of select="@FIELD"/>)</xsl:otherwise></xsl:choose><xsl:value-of select="$newline"/>
      <xsl:choose>
        <xsl:when test="string-length(@STORAGESTRING)>0">
          <xsl:if test="$prefix='OR'">TABLESPACE <xsl:value-of select="$tablespace"/>
    PCTFREE <xsl:value-of select="@PCTFREE"/> <xsl:if test="string-length(@PCTUSED)>0"> PCTUSED <xsl:value-of select="@PCTUSED"/></xsl:if>
    STORAGE <xsl:value-of select="@STORAGESTRING"/>
          </xsl:if>
	</xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates select="STORAGE" mode="storage_clause"/>
        </xsl:otherwise>
      </xsl:choose><xsl:if test="$ispartitioned='Y' and $prefix='OR' and $partitioned='Y'">LOCAL</xsl:if><xsl:value-of select="$newline"/>
</xsl:if>

      <xsl:if test="$prefix='OR'">/</xsl:if><xsl:if test="$prefix='SS' or $prefix='ASA'">go</xsl:if>
<xsl:if test="position() = last()"><xsl:value-of select="$newline"/></xsl:if>
    </xsl:if>
    </xsl:for-each>
  </xsl:template>

  <xsl:template name="prefix">
<xsl:if test="$prefix='OR'">/</xsl:if><xsl:if test="$prefix='SS' or $prefix='ASA'">go</xsl:if>
<xsl:if test="position() = last()"><xsl:value-of select="$newline"/></xsl:if>
  </xsl:template>
  
  <xsl:template match="CONSTRAINT" mode="table_primary_key">,CONSTRAINT <xsl:value-of select="@NAME"/> PRIMARY KEY (<xsl:value-of select="@FIELDS"/>)</xsl:template>

<xsl:template match="item" mode="nextkey">
    <xsl:param name="tabname"/>
    <xsl:param name="name"/>
    <xsl:param name="change"/>

  <xsl:variable name="fields"><xsl:value-of select="document($internal_schema_name)/PrimaveraDatabaseSchema/TABLE[@NAME=$tabname]/CONSTRAINT[@NAME=$name]/@FIELDS"/> </xsl:variable>
  <xsl:variable name="table_name"><xsl:value-of select="$tabname"/> </xsl:variable>
    
   <xsl:if  test="not(contains($fields,','))">
  <xsl:variable name="datatype">
   <xsl:value-of select="document($internal_schema_name)/PrimaveraDatabaseSchema/TABLE[@NAME=$table_name]/FIELD[@NAME=$fields]/@DATATYPE" />
  </xsl:variable>
 <xsl:if test="$datatype='integer'">
--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('<xsl:value-of select="$table_name"/>_<xsl:value-of select="$fields"/>'),1 from prefer where not exists (select * from nextkey where key_name=lower('<xsl:value-of select="$table_name"/>_<xsl:value-of select="$fields"/>')) 
<xsl:if test="$prefix='OR'">/</xsl:if><xsl:if test="$prefix='SS' or $prefix='ASA'">go</xsl:if><xsl:value-of select="$newline"/>
 </xsl:if>
  </xsl:if>
 </xsl:template>

<xsl:template match="item" mode="trigger">
<xsl:if test="@OBJECTTYPE='TRIGGER'">
 --METADATA NAME:<xsl:value-of select="objname"/> TYPE:TRIGGER CHANGE:<xsl:value-of select="chgtype"/> 
DROP TRIGGER <xsl:value-of select="objname"/><xsl:value-of select="$newline"/> 
  <xsl:if test="$prefix='OR'">/</xsl:if><xsl:if test="$prefix='SS' or $prefix='ASA'">go</xsl:if>
 <xsl:if test="position() = last()"><xsl:value-of select="$newline"/></xsl:if>
</xsl:if>
 </xsl:template>
  



  <xsl:template match="item" mode="constraint">
    <xsl:variable name="table_name" select="tabname"/>
    <xsl:variable name="constraint_name" select="objname"/>
    <xsl:variable name="change_type" select="chgtype"/>
    <xsl:variable name="process_flag">
      <xsl:choose>
        <xsl:when test="type='PRIMARY' and $option_pkeys='N'">N</xsl:when>
        <xsl:when test="type='PRIMARY' and $option_pk_in_table='Y' and $change_type = 'CREATE'">N</xsl:when>
        <xsl:when test="type='FOREIGN' and $option_fkeys='N'">N</xsl:when>
        <xsl:when test="type='UNIQUE' and $option_ukeys='N'">N</xsl:when>
        <xsl:when test="type='CHECK' and $option_ckeys='N'">N</xsl:when>
        <xsl:otherwise>Y</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:if test="$process_flag = 'Y'">
        <xsl:call-template name="print_output">
          <xsl:with-param name="output">constraint <xsl:value-of select="$constraint_name"/> on table <xsl:value-of select="$table_name"/></xsl:with-param>
          <xsl:with-param name="operation" select="$change_type"/>
        </xsl:call-template>

--METADATA NAME:<xsl:value-of select="$constraint_name"/> TYPE:CONSTRAINT TABLE_NAME:<xsl:value-of select="$table_name"/> CHANGE:<xsl:value-of select="$change_type"/>
	<xsl:if test="$change_type='DROP' or $change_type='ALTER'">
  <xsl:if test="$prefix='OR'">
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('<xsl:value-of select="$constraint_name"/>');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE <xsl:value-of select="$table_name"/> DROP CONSTRAINT <xsl:value-of select="$constraint_name"/>';
  END IF;
END;
  </xsl:if>
  <xsl:if test="$prefix='SS' or $prefix='ASA'">
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='<xsl:value-of select="$constraint_name"/>';
if @cons_cnt > 0  
ALTER TABLE <xsl:value-of select="$table_name"/> DROP CONSTRAINT <xsl:value-of select="$constraint_name"/>;
</xsl:if>
<xsl:if test="$prefix='OR'">/</xsl:if><xsl:if test="$prefix='SS' or $prefix='ASA'">go</xsl:if>
	  <xsl:if test="position() = last()"><xsl:value-of select="$newline"/></xsl:if>
        </xsl:if>

        <xsl:for-each select="document($internal_schema_name)/PrimaveraDatabaseSchema/TABLE[@NAME=$table_name]/CONSTRAINT[@NAME=$constraint_name]">
          <xsl:variable name="tablespace">
            <xsl:choose>
              <xsl:when test="string-length(@TABLESPACE)>0"><xsl:choose><xsl:when test="$dbtype='EXP' or $dbtype='EXPADM'"><xsl:value-of select="$ndx_ts"/></xsl:when><xsl:otherwise><xsl:value-of select="@TABLESPACE"/></xsl:otherwise></xsl:choose></xsl:when>
              <xsl:otherwise><xsl:value-of select="$ndx_ts"/></xsl:otherwise>
            </xsl:choose>
          </xsl:variable>
                    <xsl:if test="$change_type='CREATE' or $change_type='ALTER'">
ALTER TABLE <xsl:value-of select="@TABLE"/>
ADD CONSTRAINT <xsl:value-of select="@NAME"/>
	<xsl:variable name="deleterule"><xsl:value-of select="@DELETERULE"/></xsl:variable> 			
            <xsl:choose>
              <xsl:when test="@TYPE='FOREIGN'"> FOREIGN KEY (<xsl:value-of select="@FIELDS"/>)
REFERENCES <xsl:value-of select="@TARGETTABLE"/> (<xsl:value-of select="@TARGETFIELDS"/>) <xsl:if test="$deleterule='CASCADE'"> ON DELETE CASCADE </xsl:if> <xsl:value-of select="$newline"/>
		</xsl:when>              
              <xsl:when test="@TYPE='PRIMARY'"> PRIMARY KEY (<xsl:value-of select="@FIELDS"/>)<xsl:comment/>
                <xsl:if test="$prefix!='OR'"><xsl:value-of select="$newline"/></xsl:if>
                <xsl:if test="$prefix='OR'">
                  <xsl:choose>
                    <xsl:when test="string-length(@STORAGESTRING)>0">
USING INDEX
                      <xsl:if test="$prefix='OR'">TABLESPACE <xsl:value-of select="$tablespace"/>
                PCTFREE <xsl:value-of select="@PCTFREE"/>
                STORAGE <xsl:value-of select="@STORAGESTRING"/>
                      <xsl:value-of select="$newline"/>
                      </xsl:if>
                    </xsl:when>
                    <xsl:otherwise>
USING INDEX
                      <xsl:apply-templates select="STORAGE" mode="storage_clause"/><xsl:value-of select="$newline"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:if>


              </xsl:when>              
              <xsl:when test="@TYPE='CHECK'"> CHECK (<xsl:value-of select="@SEARCHCONDITION"/>)<xsl:value-of select="$newline"/>
              </xsl:when>
              <xsl:when test="@TYPE='UNIQUE'"> UNIQUE (<xsl:value-of select="@FIELDS"/>)<xsl:value-of select="$newline"/>
              </xsl:when>              
            </xsl:choose>          
<xsl:if test="$prefix='OR'">/</xsl:if><xsl:if test="$prefix='SS' or $prefix='ASA'">go</xsl:if>
<xsl:if test="position() = last()"><xsl:value-of select="$newline"/></xsl:if>
          </xsl:if>
        </xsl:for-each>
    </xsl:if>
    
  </xsl:template>
 <xsl:template match="item" mode="sequence">
     <xsl:variable name="sequence_name" select="objname"/>
     <xsl:variable name="change_type" select="chgtype"/>

      <xsl:if test="$change_type='CREATE'">
--METADATA NAME:<xsl:value-of select="$sequence_name"/> TYPE:SEQUENCE CHANGE:<xsl:value-of select="$change_type"/>
CREATE SEQUENCE <xsl:value-of select="$sequence_name"/> MINVALUE 1 MAXVALUE 9999999999999999999999999999 increment by 1 start with 1
<xsl:if test="$prefix='OR'">/</xsl:if><xsl:if test="$prefix='SS' or $prefix='ASA'">go</xsl:if>
--METADATA NAME:<xsl:value-of select="$sequence_name"/> TYPE:GRANT CHANGE:<xsl:value-of select="$change_type"/>
GRANT SELECT ON <xsl:value-of select="$sequence_name"/> TO PRIVUSER 
<xsl:if test="$prefix='OR'">/</xsl:if><xsl:if test="$prefix='SS' or $prefix='ASA'">go</xsl:if>
<xsl:if test="position() = last()"><xsl:value-of select="$newline"/></xsl:if>
      </xsl:if>
      <xsl:if test="$change_type='DROP'">
DROP SEQUENCE <xsl:value-of select="$sequence_name"/><xsl:value-of select="$newline"/>
<xsl:if test="$prefix='OR'">/</xsl:if><xsl:if test="$prefix='SS' or $prefix='ASA'">go</xsl:if>
<xsl:if test="position() = last()"><xsl:value-of select="$newline"/></xsl:if>
      </xsl:if>
  </xsl:template>

  <xsl:template name="print_output">
    <xsl:param name="output"/>
    <xsl:param name="operation"/>
    <xsl:variable name="oper_name">
      <xsl:choose>
        <xsl:when test="$operation='CREATE'">Creating </xsl:when>
        <xsl:when test="$operation='ALTER'">Changing </xsl:when>
        <xsl:when test="$operation='DROP'">Dropping </xsl:when>
      </xsl:choose>
    </xsl:variable>
    <xsl:if test="string-length($output)>0">
      <xsl:choose>
        <xsl:when test="$prefix='OR'">
prompt <xsl:value-of select="$oper_name"/><xsl:value-of select="$output"/><xsl:value-of select="$newline"/>      
        </xsl:when>
        <xsl:when test="$prefix='SS'">
print '<xsl:value-of select="$oper_name"/><xsl:value-of select="$output"/>'<xsl:value-of select="$newline"/>
        </xsl:when>
      </xsl:choose>
    </xsl:if>
  </xsl:template>
    
  <xsl:template match="statement">
  <xsl:variable name="sqlstmt" select="."/>
   <xsl:if test="string-length($sqlstmt)>0" >
--METADATA  TYPE:ADHOC_SQL<xsl:value-of select="$newline"/>
    <xsl:value-of select="."/><xsl:value-of select="$newline"/>
    <xsl:if test="$prefix='OR'">/</xsl:if><xsl:if test="$prefix='SS' or $prefix='ASA'">go</xsl:if>
<xsl:if test="position() = last()"><xsl:value-of select="$newline"/></xsl:if>
  </xsl:if>
  </xsl:template>

  <xsl:template name="SSCR">
    <xsl:param name="object_name"/>
    <xsl:param name="type"/>
    <xsl:if test="$sprefix='SS' or $sprefix='ASA'">
      <xsl:variable name="ss_type">
        <xsl:choose>
          <xsl:when test="$type='FUNCTION'">FN</xsl:when>
          <xsl:when test="$type='VIEW'">V</xsl:when>
          <xsl:when test="$type='PROCEDURE'">P</xsl:when>
          <xsl:when test="$type='TABLE'">U</xsl:when>
        </xsl:choose>
      </xsl:variable>
--METADATA  TYPE:SSCR NAME:<xsl:value-of select="$object_name"/> OBJECT_TYPE:<xsl:value-of select="$type"/> <xsl:value-of select="$newline"/>
IF OBJECT_ID (N'<xsl:value-of select="$object_name"/>', N'<xsl:value-of select="$type"/>') IS NOT NULL
  DROP <xsl:value-of select="$type"/><xsl:text> </xsl:text><xsl:value-of select="$object_name"/>
go
<xsl:if test="position() = last()"><xsl:value-of select="$newline"/></xsl:if>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="FIELD" mode="column_spatial">
--METADATA  TYPE:ADHOC_SQL
DECLARE
TABLE_MISSING exception;
pragma exception_init(TABLE_MISSING,-942);
BEGIN
execute immediate q'[INSERT INTO USER_SDO_GEOM_METADATA (TABLE_NAME, COLUMN_NAME, DIMINFO, SRID) 
VALUES ('<xsl:value-of select="@TABLE"/>', '<xsl:value-of select="translate(@NAME,$lowercase,$uppercase)"/>', 
   SDO_DIM_ARRAY 
     (SDO_DIM_ELEMENT('LONG', -180.0, 180.0, 0.5), 
     SDO_DIM_ELEMENT('LAT', -90.0, 90.0, 0.5)), 
   8307)]';
EXCEPTION WHEN TABLE_MISSING  THEN NULL;
END;   
/

--METADATA NAME:ndx_<xsl:value-of select="translate(@TABLE,$uppercase,$lowercase)"/>_<xsl:value-of select="@NAME"/> TYPE:INDEX TABLE_NAME:<xsl:value-of select="@TABLE"/> CHANGE:CREATE      
BEGIN
execute immediate 'CREATE INDEX ndx_<xsl:value-of select="translate(@TABLE,$uppercase,$lowercase)"/>_<xsl:value-of select="@NAME"/>
ON <xsl:value-of select="translate(@TABLE,$uppercase,$lowercase)"/> (<xsl:value-of select="@NAME"/>)
INDEXTYPE IS mdsys.spatial_index';
EXCEPTION WHEN OTHERS THEN NULL;
END;   
/
  
  </xsl:template>
  
  <xsl:template match="FIELD" mode="column_ctx">
--METADATA NAME:ndx_<xsl:value-of select="translate(@TABLE,$uppercase,$lowercase)"/>_<xsl:value-of select="@NAME"/> TYPE: CTX INDEX TABLE_NAME:<xsl:value-of select="@TABLE"/> CHANGE:CREATE      
CREATE INDEX ndx_<xsl:value-of select="@CTXINDEX"/>
ON <xsl:value-of select="translate(@TABLE,$uppercase,$lowercase)"/>(<xsl:value-of select="@NAME"/>)
INDEXTYPE IS ctxsys.context
/


  </xsl:template>

</xsl:stylesheet>
