
SET QUOTED_IDENTIFIER ON

print 'Creating table DISCUSSION'

--METADATA NAME:DISCUSSION TYPE:TABLE CHANGE:CREATE
CREATE TABLE DISCUSSION(
  "discussion_id"  integer NOT NULL,
  "task_id"  integer NOT NULL,
  "discussion_value"  varchar(4000) NULL,
  "discussion_date"  datetime NULL,
  "user_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_discussion PRIMARY KEY (discussion_id)  )


go
print 'Creating table DISCUSSION_READ'

--METADATA NAME:DISCUSSION_READ TYPE:TABLE CHANGE:CREATE
CREATE TABLE DISCUSSION_READ(
  "discussion_id"  integer NOT NULL,
  "user_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_discussion_read PRIMARY KEY (discussion_id,user_id)  )


go
print 'Creating table IMAGEDATA'

--METADATA NAME:IMAGEDATA TYPE:TABLE CHANGE:CREATE
CREATE TABLE IMAGEDATA(
  "image_id"  integer NOT NULL,
  "image_name"  varchar(120) NULL,
  "image_data"  varbinary(max) NOT NULL,
  "image_thumbnail"  varbinary(max) NOT NULL,
  "image_extension"  varchar(20) DEFAULT 'png' NOT NULL,
  "default_flag"  varchar(1) NOT NULL,
  "image_purpose"  varchar(50) NOT NULL,
  "image_description"  varchar(250) NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_imagedata PRIMARY KEY (image_id)  )


go
print 'Creating table PFOLIOUSER'

--METADATA NAME:PFOLIOUSER TYPE:TABLE CHANGE:CREATE
CREATE TABLE PFOLIOUSER(
  "pfolio_id"  integer NOT NULL,
  "user_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_pfoliouser PRIMARY KEY (pfolio_id,user_id)  )


go
print 'Creating table USER_ACCEPTANCE_CONSENT'

--METADATA NAME:USER_ACCEPTANCE_CONSENT TYPE:TABLE CHANGE:CREATE
CREATE TABLE USER_ACCEPTANCE_CONSENT(
  "user_id"  integer NOT NULL,
  "status"  integer NULL,
  "modified_date"  datetime DEFAULT getDate() NULL,
  "consent_type"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_user_acceptance_consent PRIMARY KEY (user_id,consent_type)  )


go
--METADATA NAME:parent_actv_code_id TYPE:FIELD TABLE_NAME:DLTACTV CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('DLTACTV') and column_name=upper('parent_actv_code_id');
if @col_exist = 0
ALTER TABLE DLTACTV 
  add   "parent_actv_code_id"  integer NULL
go

--METADATA NAME:rpt_id TYPE:FIELD TABLE_NAME:FILTPROP CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('FILTPROP') and column_name=upper('rpt_id');
if @col_exist = 0
ALTER TABLE FILTPROP 
  add   "rpt_id"  integer NULL
go

--METADATA NAME:ts_rsrc_def_asgn_out_actv_flag TYPE:FIELD TABLE_NAME:PREFER CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PREFER') and column_name=upper('ts_rsrc_def_asgn_out_actv_flag');
if @col_exist = 0
ALTER TABLE PREFER 
  add   "ts_rsrc_def_asgn_out_actv_flag"  varchar(1) DEFAULT 'Y' with values  NOT NULL
go

--METADATA NAME:user_id TYPE:FIELD TABLE_NAME:RPT CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('RPT') and column_name=upper('user_id');
if @col_exist = 0
ALTER TABLE RPT 
  add   "user_id"  integer NULL
go

--METADATA NAME:refrdel_project_bypass TYPE:FIELD TABLE_NAME:SPIDMAP CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('SPIDMAP') and column_name=upper('refrdel_project_bypass');
if @col_exist = 0
ALTER TABLE SPIDMAP 
  add   "refrdel_project_bypass"  integer NULL
go

print 'Creating constraint fk_discussion_task on table DISCUSSION'


--METADATA NAME:fk_discussion_task TYPE:CONSTRAINT TABLE_NAME:DISCUSSION CHANGE:CREATE
ALTER TABLE DISCUSSION
ADD CONSTRAINT fk_discussion_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_discussion_read_users on table DISCUSSION_READ'


--METADATA NAME:fk_discussion_read_users TYPE:CONSTRAINT TABLE_NAME:DISCUSSION_READ CHANGE:CREATE
ALTER TABLE DISCUSSION_READ
ADD CONSTRAINT fk_discussion_read_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_discussion_read_discussion on table DISCUSSION_READ'


--METADATA NAME:fk_discussion_read_discussion TYPE:CONSTRAINT TABLE_NAME:DISCUSSION_READ CHANGE:CREATE
ALTER TABLE DISCUSSION_READ
ADD CONSTRAINT fk_discussion_read_discussion FOREIGN KEY (discussion_id)
REFERENCES DISCUSSION (discussion_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_filtprop_rpt on table FILTPROP'


--METADATA NAME:fk_filtprop_rpt TYPE:CONSTRAINT TABLE_NAME:FILTPROP CHANGE:CREATE
ALTER TABLE FILTPROP
ADD CONSTRAINT fk_filtprop_rpt FOREIGN KEY (rpt_id)
REFERENCES RPT (rpt_id) 
go

print 'Creating constraint fk_pfoliouser_pfolio on table PFOLIOUSER'


--METADATA NAME:fk_pfoliouser_pfolio TYPE:CONSTRAINT TABLE_NAME:PFOLIOUSER CHANGE:CREATE
ALTER TABLE PFOLIOUSER
ADD CONSTRAINT fk_pfoliouser_pfolio FOREIGN KEY (pfolio_id)
REFERENCES PFOLIO (pfolio_id) 
go

print 'Creating constraint fk_pfoliouser_users on table PFOLIOUSER'


--METADATA NAME:fk_pfoliouser_users TYPE:CONSTRAINT TABLE_NAME:PFOLIOUSER CHANGE:CREATE
ALTER TABLE PFOLIOUSER
ADD CONSTRAINT fk_pfoliouser_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_rpt_users on table RPT'


--METADATA NAME:fk_rpt_users TYPE:CONSTRAINT TABLE_NAME:RPT CHANGE:CREATE
ALTER TABLE RPT
ADD CONSTRAINT fk_rpt_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_user_acpt_consent_users on table USER_ACCEPTANCE_CONSENT'


--METADATA NAME:fk_user_acpt_consent_users TYPE:CONSTRAINT TABLE_NAME:USER_ACCEPTANCE_CONSENT CHANGE:CREATE
ALTER TABLE USER_ACCEPTANCE_CONSENT
ADD CONSTRAINT fk_user_acpt_consent_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id)  ON DELETE CASCADE 
go
 
--METADATA NAME:job_name TYPE:FIELD TABLE_NAME:JOBSVC CHANGE:ALTER
ALTER TABLE JOBSVC ALTER COLUMN job_name varchar(255) NOT NULL 
go
 
--METADATA NAME:job_name TYPE:FIELD TABLE_NAME:JOBSVC CHANGE:ALTER 
--METADATA NAME:proj_catg_type TYPE:FIELD TABLE_NAME:PCATTYPE CHANGE:ALTER
ALTER TABLE PCATTYPE ALTER COLUMN proj_catg_type varchar(60) NOT NULL 
go
 
--METADATA NAME:proj_catg_type TYPE:FIELD TABLE_NAME:PCATTYPE CHANGE:ALTER 
--METADATA NAME:proj_catg_short_name TYPE:FIELD TABLE_NAME:PCATVAL CHANGE:ALTER
ALTER TABLE PCATVAL ALTER COLUMN proj_catg_short_name varchar(60) NOT NULL 
go
 
--METADATA NAME:proj_catg_short_name TYPE:FIELD TABLE_NAME:PCATVAL CHANGE:ALTER 
--METADATA NAME:intg_type TYPE:FIELD TABLE_NAME:PROJWBS CHANGE:ALTER
ALTER TABLE PROJWBS ALTER COLUMN intg_type varchar(100)
go
 
--METADATA NAME:intg_type TYPE:FIELD TABLE_NAME:PROJWBS CHANGE:ALTER 
--METADATA NAME:intg_type TYPE:FIELD TABLE_NAME:RSRC CHANGE:ALTER
ALTER TABLE RSRC ALTER COLUMN intg_type varchar(100)
go
 
--METADATA NAME:intg_type TYPE:FIELD TABLE_NAME:RSRC CHANGE:ALTER
print 'Creating index ndx_discussion_1 on table DISCUSSION'

--METADATA NAME:ndx_discussion_1 TYPE:INDEX TABLE_NAME:DISCUSSION CHANGE:CREATE
CREATE  INDEX ndx_discussion_1
ON DISCUSSION (task_id,discussion_date)

go

print 'Creating index ndx_discussion_2 on table DISCUSSION'

--METADATA NAME:ndx_discussion_2 TYPE:INDEX TABLE_NAME:DISCUSSION CHANGE:CREATE
CREATE  INDEX ndx_discussion_2
ON DISCUSSION (user_id,discussion_date)

go

print 'Creating index ndx_discussion_dsi on table DISCUSSION'

--METADATA NAME:ndx_discussion_dsi TYPE:INDEX TABLE_NAME:DISCUSSION CHANGE:CREATE
CREATE  INDEX ndx_discussion_dsi
ON DISCUSSION (delete_session_id,delete_date)

go

print 'Creating index ndx_discussion_read_dsi on table DISCUSSION_READ'

--METADATA NAME:ndx_discussion_read_dsi TYPE:INDEX TABLE_NAME:DISCUSSION_READ CHANGE:CREATE
CREATE  INDEX ndx_discussion_read_dsi
ON DISCUSSION_READ (delete_session_id,delete_date)

go

print 'Creating index ndx_imagedata_image_name on table IMAGEDATA'

--METADATA NAME:ndx_imagedata_image_name TYPE:INDEX TABLE_NAME:IMAGEDATA CHANGE:CREATE
CREATE UNIQUE  INDEX ndx_imagedata_image_name
ON IMAGEDATA (image_name)

go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('DISCUSSION_discussion_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('DISCUSSION_discussion_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('IMAGEDATA_image_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('IMAGEDATA_image_id')) 
go



--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES

INSERT INTO SETTINGS (namespace,setting_name,setting_value) VALUES('Administrator_Settings','OnlineHelpRootUrl','http://docs.oracle.com/cd/E35157_01/client_help/');
go

--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES
declare @vpropid integer
begin
  exec pc_get_next_key 'viewprop_view_id', @vpropid OUTPUT;
  insert into viewprop (VIEW_ID,VIEW_NAME,VIEW_TYPE)
  select @vpropid,'Default Import Template','VP_XML_IMP_DET_OPT'
  where not exists ( select view_id from viewprop where VIEW_NAME='Default Import Template' and VIEW_TYPE = 'VP_XML_IMP_DET_OPT') ; 
  end;
go


go 
--END TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:83to83 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:83to83 NAME:MISC_UPDATES
DECLARE RiskCursor CURSOR LOCAL FOR SELECT risk_id, risk_desc from PROJRISK
OPEN RiskCursor
DECLARE @riskID INT, @HTMLText VARCHAR(4000), @Start INT, @End INT, @Length INT
FETCH NEXT FROM RiskCursor INTO @riskID, @HTMLText
WHILE (@@FETCH_STATUS = 0)
BEGIN
	SET @Start = CHARINDEX('<',@HTMLText)
	SET @End = CHARINDEX('>',@HTMLText,CHARINDEX('<',@HTMLText))
	SET @Length = (@End - @Start) + 1
	WHILE @Start > 0 AND @End > 0 AND @Length > 0
    BEGIN
        SET @HTMLText = STUFF(@HTMLText,@Start,@Length,'')
        SET @Start = CHARINDEX('<',@HTMLText)
        SET @End = CHARINDEX('>',@HTMLText,CHARINDEX('<',@HTMLText))
        SET @Length = (@End - @Start) + 1
    END
    SET @HTMLText = REPLACE(@HTMLText, '&amp;', '&')
	SET @HTMLText = REPLACE(@HTMLText, '&nbsp;', ' ')
	SET @HTMLText = REPLACE(@HTMLText, '&nbsp', ' ')
	SET @HTMLText = REPLACE(@HTMLText, '&lt;', '<')
	SET @HTMLText = REPLACE(@HTMLText, '&gt;', '>')
	SET @HTMLText = REPLACE(@HTMLText, char(13) , ' ')
	SET @HTMLText = REPLACE(@HTMLText, char(10) , '')
	SET @HTMLText = LTRIM(RTRIM(@HTMLText))
	UPDATE PROJRISK SET risk_desc = @HTMLText where risk_id = @riskID 
	FETCH NEXT FROM RiskCursor INTO @riskID, @HTMLText 
END
CLOSE RiskCursor
DEALLOCATE RiskCursor
GO
go 
--END TYPE:UP2 GROUP:83to83 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
begin
insert into settings (namespace, setting_name, setting_value) select distinct 'Administrator_Settings', 'AlwaysLaunchOnlineHelp',
'Y' from settings where not exists ( select 1 from settings where namespace='Administrator_Settings' and setting_name =
'AlwaysLaunchOnlineHelp' )
end
go

--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
update settings set setting_value = 'Y' where setting_name = 'AlwaysLaunchOnlineHelp'
go


--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
update settings set  setting_value='http://docs.oracle.com/cd/E54700_01/client_help/' where setting_name='OnlineHelpRootUrl'
go

go 
--END TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:84to151 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:84to151 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E58732_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go

--METADATA TYPE:UP2 GROUP:84to151 NAME:MISC_UPDATES
declare @p3 int,
  @userid int
declare uid_cur cursor 
for 
select ue1.user_id from usereng ue1
where ue1.db_engine_type in ('PM','WEB_PM','WEB_RM')
OPEN uid_cur
FETCH NEXT FROM uid_cur INTO @userid
WHILE @@FETCH_STATUS = 0
BEGIN
    PRINT 'userid : ' + cast(@userid as varchar(10))
 exec getnextkeys 'usereng_user_eng_id',1,@p3 output
 INSERT INTO usereng (user_eng_id, user_id, db_engine_type) 
 values(@p3, @userid, 'VIS')
    FETCH NEXT FROM uid_cur INTO @userid
END 
CLOSE uid_cur
DEALLOCATE uid_cur
go
go 
--END TYPE:UP2 GROUP:84to151 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:151to151 NAME:TRIGGER_USESSION 
--METADATA NAME:RT_USESSION_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:DROP
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_USESSION_DEL' and type in ('TR'))
  DROP TRIGGER RT_USESSION_DEL
go

--METADATA  TYPE:SSCR NAME:RT_USESSION OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_USESSION' and type in ('TR'))
  DROP TRIGGER RT_USESSION
go

--METADATA NAME:RT_USESSION TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_USESSION
on USESSION
for update,insert
as     
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;

update USESSION
set update_date = getdate()    
, update_user = @user_name
, create_user =  case @del_cnt WHEN 0 then @user_name else USESSION.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else USESSION.create_date end
from inserted 
where USESSION.session_id = inserted.session_id
go
go 
--END TYPE:UP2 GROUP:151to151 NAME:TRIGGER_USESSION
--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES 
 --METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E63417_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go

--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
update task set est_wt=1 where est_wt is null
go
--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
update projwbs set est_wt=1 where est_wt is null
go
go 
--END TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E68202_01' where setting_name = 'OnlineHelpRootUrl'
go
go 
--END TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:161to162 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:161to162 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E75426_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go
go 
--END TYPE:UP2 GROUP:161to162 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1712to1801 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1712to1801 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E90748_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go
go 
--END TYPE:UP2 GROUP:1712to1801 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1802to1803 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1801to1802 NAME:MISC_UPDATES
update prefer set license_data=null
go
go 
--END TYPE:UP2 GROUP:1802to1803 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1803to1804 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1803to1804 NAME:MISC_UPDATES
insert into PROFPRIV (prof_id,priv_num,allow_flag)
select DISTINCT a.PROF_ID,177,'Y' from PROFPRIV a
where not exists ( select 1 from PROFPRIV b where b.PROF_ID=a.PROF_ID and b.priv_num=177 and b.allow_flag='Y') 
go

go 
--END TYPE:UP2 GROUP:1803to1804 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1804to1805 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1804to1805 NAME:MISC_UPDATES
declare @v_prof_id int,@v_prof_id_pv int
declare @profile_cur cursor 
SET @profile_cur = CURSOR FAST_FORWARD for select prof_id from profile;
open @profile_cur
FETCH NEXT FROM @profile_cur INTO @v_prof_id
WHILE @@FETCH_STATUS = 0
begin
select @v_prof_id_pv=prof_id from profpriv where prof_id= @v_prof_id and priv_num=177;
if @@rowcount > 0
  begin
   if @v_prof_id=12
    update profpriv set allow_flag ='Y' where prof_id= @v_prof_id and priv_num=177;
   else
    update profpriv set allow_flag ='N' where prof_id= @v_prof_id and priv_num=177;
  end
else
  begin
   if @v_prof_id=12
    insert into profpriv (prof_id,priv_num,allow_flag) values (@v_prof_id,177,'Y');
   else
    insert into profpriv (prof_id,priv_num,allow_flag) values (@v_prof_id,177,'N');
  end
FETCH NEXT FROM @profile_cur INTO @v_prof_id
END
CLOSE @profile_cur
DEALLOCATE @profile_cur
go

go 
--END TYPE:UP2 GROUP:1804to1805 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1805to1806 NAME:MISC_UPDATES 
---METADATA TYPE:UP2 GROUP:1805to1806 NAME:MISC_UPDATES
update  PROJECT set wbs_max_sum_level =0 where wbs_max_sum_level is NULL
go

go 
--END TYPE:UP2 GROUP:1805to1806 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES 
---METADATA TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F12057_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go
go 
--END TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES 
---METADATA TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F12059_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go
go 
--END TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE PCATTYPE SET PROJ_CATG_SHORT_LEN=60 WHERE PROJ_CATG_TYPE='Prime Workspace'
go

--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE PCATTYPE SET PROJ_CATG_TYPE='Primavera Workspace' WHERE PROJ_CATG_TYPE='Prime Workspace'
go

--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE RSRC SET INTG_TYPE='PrimaveraCloudScope' WHERE INTG_TYPE='PrimeScope'
go

--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE PROJWBS SET INTG_TYPE='PrimaveraCloudScope' WHERE INTG_TYPE='PrimeScope'
go

go 
--END TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
delete from profpriv 
where prof_id in
(select pp.prof_id from profile p , profpriv pp
 where p.prof_id = pp.prof_id and pp.priv_num=177
and p.scope_type = 'ST_Project'
)
and priv_num in
(select pp.priv_num from profile p , profpriv pp
 where p.prof_id = pp.prof_id and pp.priv_num=177
and p.scope_type = 'ST_Project'
)
go

--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
DECLARE
  @col_exists integer,
  @image_name varchar(100),
  @image_id varchar(100)
DECLARE @cur as CURSOR
 SET @cur = CURSOR FOR
 SELECT image_id,image_name
 FROM imagedata;
 OPEN @cur;
 FETCH NEXT FROM @cur INTO @image_id,@image_name;
WHILE @@FETCH_STATUS = 0
 BEGIN
 begin try
   if NULLIF(@image_name, '') IS NOT NULL and charindex('.',@image_name)>0
	begin
    update imagedata
      set image_name =left(@image_name,len(@image_name)- charindex('.', reverse(@image_name))),
          image_extension = reverse(left(reverse(@image_name), charindex('.', reverse(@image_name)) -1))
    where image_id=@image_id;
	end;
  FETCH NEXT FROM @cur INTO @image_id,@image_name;
  end try
  begin catch
  select null
  end catch
 END 
CLOSE @cur;
DEALLOCATE @cur;
go
go 
--END TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1912to19121 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1912to19121 NAME:MISC_UPDATES
DECLARE
  @issue_notes varchar(MAX),
  @issue_id integer,
  @v_len integer
DECLARE @cur as CURSOR
 SET @cur = CURSOR FOR
 SELECT issue_id,issue_notes
 FROM projissu where issue_notes is NOT NULL;
 OPEN @cur;
 FETCH NEXT FROM @cur INTO @issue_id,@issue_notes;
WHILE @@FETCH_STATUS = 0
 BEGIN
 begin try
  set @v_len=DATALENGTH(@issue_notes);
   if @v_len IS NOT NULL  and @v_len > 0
	begin
	if (PATINDEX('%DOCTYPE%',@issue_notes)=0 or PATINDEX('%DOCTYPE%',@issue_notes) is NULL) 
	begin
    update projissu
      set issue_notes ='<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN"><HTML><HEAD><META content="text/html; charset=unicode" http-equiv=Content-Type><META name=GENERATOR content="MSHTML 11.00.10570.1001"></HEAD><BODY><SPAN style="FONT-SIZE: medium; FONT-FAMILY: serif; WHITE-SPACE: normal; WORD-SPACING: 0px; TEXT-TRANSFORM: none; FLOAT: none; FONT-WEIGHT: 400; COLOR: rgb(0,0,0); FONT-STYLE: normal; ORPHANS: 2; WIDOWS: 2; DISPLAY: inline !important; LETTER-SPACING: normal; TEXT-INDENT: 0px; font-variant-ligatures: normal; font-variant-caps: normal; -webkit-text-stroke-width: 0px; text-decoration-style: initial; text-decoration-color: initial">'+
	  @issue_notes+'</SPAN></BODY></HTML>'
    where issue_id=@issue_id;
	end;
	end;
  FETCH NEXT FROM @cur INTO @issue_id,@issue_notes;
  end try
  begin catch
  select null
  end catch
 END 
CLOSE @cur;
DEALLOCATE @cur;
go
go 
--END TYPE:UP2 GROUP:1912to19121 NAME:MISC_UPDATES
update prefer set database_version='PPMDB,1912.0006.0000.0000'
go

