
--Run Script as     
SET DEFINE OFF

prompt Creating table DISCUSSION

--METADATA NAME:DISCUSSION TYPE:TABLE CHANGE:CREATE
CREATE TABLE DISCUSSION(
  discussion_id  number(10) NOT NULL,
  task_id  number(10) NOT NULL,
  discussion_value  varchar2(4000 CHAR) NULL,
  discussion_date  DATE NULL,
  user_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_discussion PRIMARY KEY (discussion_id)  )
TABLESPACE ${ppm.data_tablespace}
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table DISCUSSION_READ

--METADATA NAME:DISCUSSION_READ TYPE:TABLE CHANGE:CREATE
CREATE TABLE DISCUSSION_READ(
  discussion_id  number(10) NOT NULL,
  user_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_discussion_read PRIMARY KEY (discussion_id,user_id)  )
TABLESPACE ${ppm.data_tablespace}
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table IMAGEDATA

--METADATA NAME:IMAGEDATA TYPE:TABLE CHANGE:CREATE
CREATE TABLE IMAGEDATA(
  image_id  number(10) NOT NULL,
  image_name  varchar2(120 CHAR) NULL,
  image_data  BLOB NOT NULL,
  image_thumbnail  BLOB NOT NULL,
  image_extension  varchar2(20 CHAR) DEFAULT 'png' NOT NULL,
  default_flag  varchar2(1 CHAR) NOT NULL,
  image_purpose  varchar2(50 CHAR) NOT NULL,
  image_description  varchar2(250 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_imagedata PRIMARY KEY (image_id)  )
TABLESPACE ${ppm.data_tablespace}
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table LOCATION

--METADATA NAME:LOCATION TYPE:TABLE CHANGE:CREATE
CREATE TABLE LOCATION(
  location_id  number(10) NOT NULL,
  location_name  varchar2(255 CHAR) NOT NULL,
  location_type  varchar2(24 CHAR) NULL,
  address_line1  varchar2(200 CHAR) NULL,
  address_line2  varchar2(200 CHAR) NULL,
  address_line3  varchar2(200 CHAR) NULL,
  city_name  varchar2(200 CHAR) NULL,
  municipality_name  varchar2(200 CHAR) NULL,
  state_name  varchar2(200 CHAR) NULL,
  state_code  varchar2(2 CHAR) NULL,
  country_name  varchar2(200 CHAR) NULL,
  country_code  varchar2(3 CHAR) NULL,
  postal_code  varchar2(20 CHAR) NULL,
  longitude  NUMBER NULL,
  latitude  NUMBER NULL,
  geo_location  SDO_GEOMETRY NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_location PRIMARY KEY (location_id)  )
TABLESPACE ${ppm.data_tablespace}
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
--METADATA  TYPE:ADHOC_SQL
DECLARE
TABLE_MISSING exception;
pragma exception_init(TABLE_MISSING,-942);
BEGIN
execute immediate q'[INSERT INTO USER_SDO_GEOM_METADATA (TABLE_NAME, COLUMN_NAME, DIMINFO, SRID) 
VALUES ('LOCATION', 'GEO_LOCATION', 
   SDO_DIM_ARRAY 
     (SDO_DIM_ELEMENT('LONG', -180.0, 180.0, 0.5), 
     SDO_DIM_ELEMENT('LAT', -90.0, 90.0, 0.5)), 
   8307)]';
EXCEPTION WHEN TABLE_MISSING  THEN NULL;
END;   
/

--METADATA NAME:ndx_location_geo_location TYPE:INDEX TABLE_NAME:LOCATION CHANGE:CREATE      
BEGIN
execute immediate 'CREATE INDEX ndx_location_geo_location
ON location (geo_location)
INDEXTYPE IS mdsys.spatial_index';
EXCEPTION WHEN OTHERS THEN NULL;
END;   
/
  
  
prompt Creating table PFOLIOUSER

--METADATA NAME:PFOLIOUSER TYPE:TABLE CHANGE:CREATE
CREATE TABLE PFOLIOUSER(
  pfolio_id  number(10) NOT NULL,
  user_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_pfoliouser PRIMARY KEY (pfolio_id,user_id)  )
TABLESPACE ${ppm.data_tablespace}
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table USER_ACCEPTANCE_CONSENT

--METADATA NAME:USER_ACCEPTANCE_CONSENT TYPE:TABLE CHANGE:CREATE
CREATE TABLE USER_ACCEPTANCE_CONSENT(
  user_id  number(10) NOT NULL,
  status  number(10) NULL,
  modified_date  DATE DEFAULT sysdate NULL,
  consent_type  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_user_acceptance_consent PRIMARY KEY (user_id,consent_type)  )
TABLESPACE ${ppm.data_tablespace}
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
--METADATA NAME:parent_actv_code_id TYPE:FIELD TABLE_NAME:DLTACTV CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('DLTACTV') and column_name=upper('parent_actv_code_id');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE DLTACTV add   parent_actv_code_id  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:rpt_id TYPE:FIELD TABLE_NAME:FILTPROP CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('FILTPROP') and column_name=upper('rpt_id');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE FILTPROP add   rpt_id  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:ts_rsrc_def_asgn_out_actv_flag TYPE:FIELD TABLE_NAME:PREFER CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PREFER') and column_name=upper('ts_rsrc_def_asgn_out_actv_flag');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PREFER add   ts_rsrc_def_asgn_out_actv_flag  varchar2(1 CHAR) DEFAULT ''Y'' NOT NULL
';
  end if;
END;         
/

--METADATA NAME:location_id TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJECT') and column_name=upper('location_id');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJECT add   location_id  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:control_updates_flag TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJECT') and column_name=upper('control_updates_flag');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJECT add   control_updates_flag  varchar2(1 CHAR) DEFAULT ''N'' NOT NULL
';
  end if;
END;         
/

--METADATA  TYPE:ADHOC_SQL
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,169,'N', sysdate, sys_context('USERENV','CURRENT_SCHEMA') from profpriv p,profile pf  where scope_type='ST_Global' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=169)
/

--METADATA NAME:hist_interval TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJECT') and column_name=upper('hist_interval');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJECT add   hist_interval  varchar2(25 CHAR) DEFAULT ''Month'' NOT NULL
';
  end if;
END;         
/

--METADATA NAME:hist_level TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJECT') and column_name=upper('hist_level');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJECT add   hist_level  varchar2(10 CHAR) DEFAULT ''HL_None'' NOT NULL
';
  end if;
END;         
/

--METADATA NAME:status_reviewer TYPE:FIELD TABLE_NAME:PROJWBS CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJWBS') and column_name=upper('status_reviewer');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJWBS add   status_reviewer  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:user_id TYPE:FIELD TABLE_NAME:RPT CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('RPT') and column_name=upper('user_id');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE RPT add   user_id  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:location_id TYPE:FIELD TABLE_NAME:RSRC CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('RSRC') and column_name=upper('location_id');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE RSRC add   location_id  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:refrdel_project_bypass TYPE:FIELD TABLE_NAME:SPIDMAP CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('SPIDMAP') and column_name=upper('refrdel_project_bypass');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE SPIDMAP add   refrdel_project_bypass  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:location_id TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('TASK') and column_name=upper('location_id');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE TASK add   location_id  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:control_updates_flag TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('TASK') and column_name=upper('control_updates_flag');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE TASK add   control_updates_flag  varchar2(1 CHAR) DEFAULT ''N'' NULL
';
  end if;
END;         
/

prompt Creating constraint fk_discussion_task on table DISCUSSION


--METADATA NAME:fk_discussion_task TYPE:CONSTRAINT TABLE_NAME:DISCUSSION CHANGE:CREATE
ALTER TABLE DISCUSSION
ADD CONSTRAINT fk_discussion_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_discussion_read_users on table DISCUSSION_READ


--METADATA NAME:fk_discussion_read_users TYPE:CONSTRAINT TABLE_NAME:DISCUSSION_READ CHANGE:CREATE
ALTER TABLE DISCUSSION_READ
ADD CONSTRAINT fk_discussion_read_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_discussion_read_discussion on table DISCUSSION_READ


--METADATA NAME:fk_discussion_read_discussion TYPE:CONSTRAINT TABLE_NAME:DISCUSSION_READ CHANGE:CREATE
ALTER TABLE DISCUSSION_READ
ADD CONSTRAINT fk_discussion_read_discussion FOREIGN KEY (discussion_id)
REFERENCES DISCUSSION (discussion_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_filtprop_rpt on table FILTPROP


--METADATA NAME:fk_filtprop_rpt TYPE:CONSTRAINT TABLE_NAME:FILTPROP CHANGE:CREATE
ALTER TABLE FILTPROP
ADD CONSTRAINT fk_filtprop_rpt FOREIGN KEY (rpt_id)
REFERENCES RPT (rpt_id) 
/

prompt Creating constraint fk_pfoliouser_pfolio on table PFOLIOUSER


--METADATA NAME:fk_pfoliouser_pfolio TYPE:CONSTRAINT TABLE_NAME:PFOLIOUSER CHANGE:CREATE
ALTER TABLE PFOLIOUSER
ADD CONSTRAINT fk_pfoliouser_pfolio FOREIGN KEY (pfolio_id)
REFERENCES PFOLIO (pfolio_id) 
/

prompt Creating constraint fk_pfoliouser_users on table PFOLIOUSER


--METADATA NAME:fk_pfoliouser_users TYPE:CONSTRAINT TABLE_NAME:PFOLIOUSER CHANGE:CREATE
ALTER TABLE PFOLIOUSER
ADD CONSTRAINT fk_pfoliouser_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_rpt_users on table RPT


--METADATA NAME:fk_rpt_users TYPE:CONSTRAINT TABLE_NAME:RPT CHANGE:CREATE
ALTER TABLE RPT
ADD CONSTRAINT fk_rpt_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_user_acpt_consent_users on table USER_ACCEPTANCE_CONSENT


--METADATA NAME:fk_user_acpt_consent_users TYPE:CONSTRAINT TABLE_NAME:USER_ACCEPTANCE_CONSENT CHANGE:CREATE
ALTER TABLE USER_ACCEPTANCE_CONSENT
ADD CONSTRAINT fk_user_acpt_consent_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id)  ON DELETE CASCADE 
/

--METADATA NAME:chng_by_name TYPE:FIELD TABLE_NAME:BUDGCHNG CHANGE:ALTER
ALTER TABLE BUDGCHNG modify chng_by_name varchar2(255 CHAR)
/

--METADATA NAME:clndr_name TYPE:FIELD TABLE_NAME:CALENDAR CHANGE:ALTER
ALTER TABLE CALENDAR modify clndr_name varchar2(255 CHAR)
/

--METADATA NAME:author_name TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER
ALTER TABLE DOCUMENT modify author_name varchar2(255 CHAR)
/

--METADATA NAME:job_name TYPE:FIELD TABLE_NAME:JOBSVC CHANGE:ALTER
ALTER TABLE JOBSVC modify job_name varchar2(255 CHAR)
/

--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:NOTE CHANGE:ALTER
ALTER TABLE NOTE modify user_name varchar2(255 CHAR)
/

--METADATA NAME:proj_catg_type TYPE:FIELD TABLE_NAME:PCATTYPE CHANGE:ALTER
ALTER TABLE PCATTYPE modify proj_catg_type varchar2(60 CHAR)
/

--METADATA NAME:proj_catg_short_name TYPE:FIELD TABLE_NAME:PCATVAL CHANGE:ALTER
ALTER TABLE PCATVAL modify proj_catg_short_name varchar2(60 CHAR)
/

--METADATA NAME:prm_user_name TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:ALTER
ALTER TABLE PRMAUDIT modify prm_user_name varchar2(255 CHAR)
/

--METADATA NAME:netaddress TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:ALTER
ALTER TABLE PRMAUDIT modify netaddress varchar2(64 CHAR)
/

--METADATA NAME:enqueue_user TYPE:FIELD TABLE_NAME:PRMQUEUE CHANGE:ALTER
ALTER TABLE PRMQUEUE modify enqueue_user varchar2(255 CHAR)
/

--METADATA NAME:sender_name TYPE:FIELD TABLE_NAME:PRMQUEUE CHANGE:ALTER
ALTER TABLE PRMQUEUE modify sender_name varchar2(255 CHAR)
/

--METADATA NAME:dequeue_user TYPE:FIELD TABLE_NAME:PRMQUEUE CHANGE:ALTER
ALTER TABLE PRMQUEUE modify dequeue_user varchar2(255 CHAR)
/

--METADATA NAME:add_by_name TYPE:FIELD TABLE_NAME:PROJECT CHANGE:ALTER
ALTER TABLE PROJECT modify add_by_name varchar2(255 CHAR)
/

--METADATA NAME:add_by_name TYPE:FIELD TABLE_NAME:PROJISSU CHANGE:ALTER
ALTER TABLE PROJISSU modify add_by_name varchar2(255 CHAR)
/

--METADATA NAME:intg_type TYPE:FIELD TABLE_NAME:PROJWBS CHANGE:ALTER
ALTER TABLE PROJWBS modify intg_type varchar2(100 CHAR)
/

--METADATA NAME:private_db_user_name TYPE:FIELD TABLE_NAME:PUBUSER CHANGE:ALTER
ALTER TABLE PUBUSER modify private_db_user_name varchar2(255 CHAR)
/

--METADATA NAME:rsrc_short_name TYPE:FIELD TABLE_NAME:RSRC CHANGE:ALTER
ALTER TABLE RSRC modify rsrc_short_name varchar2(255 CHAR)
/

--METADATA NAME:rsrc_name TYPE:FIELD TABLE_NAME:RSRC CHANGE:ALTER
ALTER TABLE RSRC modify rsrc_name varchar2(255 CHAR)
/

--METADATA NAME:intg_type TYPE:FIELD TABLE_NAME:RSRC CHANGE:ALTER
ALTER TABLE RSRC modify intg_type varchar2(100 CHAR)
/

--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:SPIDMAP CHANGE:ALTER
ALTER TABLE SPIDMAP modify user_name varchar2(255 CHAR)
/

--METADATA NAME:rsrc_short_name TYPE:FIELD TABLE_NAME:TSAUDIT CHANGE:ALTER
ALTER TABLE TSAUDIT modify rsrc_short_name varchar2(255 CHAR)
/

--METADATA NAME:rsrc_name TYPE:FIELD TABLE_NAME:TSAUDIT CHANGE:ALTER
ALTER TABLE TSAUDIT modify rsrc_name varchar2(255 CHAR)
/

--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:TSAUDIT CHANGE:ALTER
ALTER TABLE TSAUDIT modify user_name varchar2(255 CHAR)
/

--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:UEVNTREG CHANGE:ALTER
ALTER TABLE UEVNTREG modify user_name varchar2(255 CHAR)
/

--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:USERS CHANGE:ALTER
ALTER TABLE USERS modify user_name varchar2(255 CHAR)
/

--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:USESSAUD CHANGE:ALTER
ALTER TABLE USESSAUD modify user_name varchar2(255 CHAR)
/

--METADATA NAME:os_user_name TYPE:FIELD TABLE_NAME:USESSAUD CHANGE:ALTER
ALTER TABLE USESSAUD modify os_user_name varchar2(255 CHAR)
/

--METADATA NAME:os_user_name TYPE:FIELD TABLE_NAME:USESSION CHANGE:ALTER
ALTER TABLE USESSION modify os_user_name varchar2(255 CHAR)
/

prompt Creating index ndx_discussion_1 on table DISCUSSION

--METADATA NAME:ndx_discussion_1 TYPE:INDEX TABLE_NAME:DISCUSSION CHANGE:CREATE
CREATE INDEX ndx_discussion_1
ON DISCUSSION (task_id,discussion_date)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_discussion_2 on table DISCUSSION

--METADATA NAME:ndx_discussion_2 TYPE:INDEX TABLE_NAME:DISCUSSION CHANGE:CREATE
CREATE INDEX ndx_discussion_2
ON DISCUSSION (user_id,discussion_date)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_discussion_dsi on table DISCUSSION

--METADATA NAME:ndx_discussion_dsi TYPE:INDEX TABLE_NAME:DISCUSSION CHANGE:CREATE
CREATE INDEX ndx_discussion_dsi
ON DISCUSSION (delete_session_id,delete_date)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_discussion_read_dsi on table DISCUSSION_READ

--METADATA NAME:ndx_discussion_read_dsi TYPE:INDEX TABLE_NAME:DISCUSSION_READ CHANGE:CREATE
CREATE INDEX ndx_discussion_read_dsi
ON DISCUSSION_READ (delete_session_id,delete_date)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_imagedata_image_name on table IMAGEDATA

--METADATA NAME:ndx_imagedata_image_name TYPE:INDEX TABLE_NAME:IMAGEDATA CHANGE:CREATE
CREATE UNIQUE INDEX ndx_imagedata_image_name
ON IMAGEDATA (image_name)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sumtrsrc_projrsrcrole_id on table SUMTRSRC

--METADATA NAME:ndx_sumtrsrc_projrsrcrole_id TYPE:INDEX TABLE_NAME:SUMTRSRC CHANGE:CREATE
CREATE INDEX ndx_sumtrsrc_projrsrcrole_id
ON SUMTRSRC (proj_id,rsrc_id,role_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('DISCUSSION_discussion_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('DISCUSSION_discussion_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('IMAGEDATA_image_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('IMAGEDATA_image_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('LOCATION_location_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('LOCATION_location_id')) 
/



--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES

INSERT INTO SETTINGS (namespace,setting_name,setting_value) VALUES('Administrator_Settings','OnlineHelpRootUrl','http://docs.oracle.com/cd/E35157_01/client_help/')
/

update udfvalue uv set TABLE_NAME = (select TABLE_NAME from udftype ut where ut.udf_type_id = uv.udf_type_id)
/

merge into settings ss using dual
on ( namespace='Table_Settings' and setting_name='udfvalue_denorm')
when matched then
update set setting_value='N'
When not matched then
insert (namespace,setting_name,setting_value)
values('Table_Settings','udfvalue_denorm','N')
/


--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES

  declare
  vpropid pls_integer;
  BEGIN
      vpropid:= copy_utils.Get_Next_Key('viewprop_view_id');
      insert into viewprop(VIEW_ID,VIEW_NAME,VIEW_TYPE) select vpropid,'Default Import Template','VP_XML_IMP_DET_OPT'
      from dual
      where not exists ( select view_id from viewprop where VIEW_NAME = 'Default Import Template' and VIEW_TYPE = 'VP_XML_IMP_DET_OPT') ;
      
        commit;
  END;
/


/ 
--END TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:83to83 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:83to83 NAME:MISC_UPDATES
UPDATE PROJRISK p
SET p.risk_desc =LTRIM(RTRIM(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE((REGEXP_REPLACE(p.risk_desc,'<[^>]*>','')), '&' || 'nbsp;', ''), '&' || 'nbsp', ' '), 'amp;', '&' ), '&' || 'lt;', '<'), '&' || 'gt;', '>'), chr(13), ' '), chr(10), '')))






/ 
--END TYPE:UP2 GROUP:83to83 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
merge into settings ss using dual
on ( namespace='Administrator_Settings' and setting_name='AlwaysLaunchOnlineHelp')
when matched then
update set setting_value='Y'
When not matched then
insert (namespace,setting_name,setting_value)
values('Administrator_Settings','AlwaysLaunchOnlineHelp','Y')
/


--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
update settings set setting_value = 'Y' where setting_name = 'AlwaysLaunchOnlineHelp'
/

--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
update settings set  setting_value='http://docs.oracle.com/cd/E54700_01/client_help/' where setting_name='OnlineHelpRootUrl'
/

/ 
--END TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:84to151 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:84to151 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E58732_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/

--METADATA TYPE:UP2 GROUP:84to151 NAME:MISC_UPDATES
declare 
cursor uid_cur is 
 select ue1.user_id from usereng ue1
   where ue1.db_engine_type in ('PM','WEB_PM','WEB_RM');
v_user_eng_id number;
begin
  for r_uid_cur in uid_cur loop
    dbms_output.put_line('userid : ' || r_uid_cur.user_id);
    getnextkeys ('usereng_user_eng_id', 1, v_user_eng_id);
    dbms_output.put_line('usereng_user_eng_id : ' || v_user_eng_id);
    INSERT INTO usereng (user_eng_id, user_id, db_engine_type) 
    values(v_user_eng_id, r_uid_cur.user_id,'VIS');
  end loop;
  commit; 
end;
/
/ 
--END TYPE:UP2 GROUP:84to151 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:151to151 NAME:TRIGGER_USESSION 
--METADATA NAME:RT_USESSION_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:DROP
DECLARE trigger_exist pls_integer;
BEGIN 
SELECT count(*) INTO trigger_exist FROM user_triggers WHERE trigger_name = 'RT_USESSION_DEL';
IF trigger_exist=1
THEN EXECUTE IMMEDIATE 'DROP TRIGGER RT_USESSION_DEL' ;
END IF;
EXCEPTION WHEN no_data_found THEN NULL;
END;
/

--METADATA NAME:RT_USESSION TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_USESSION
BEFORE UPDATE OR INSERT ON USESSION
FOR EACH ROW
BEGIN
  if dbms_reputil.from_remote = true then   return; end if;
  
  :NEW.update_date := SYSDATE;
  
  :NEW.update_user := prm_audit.g_prm_user_name;

  IF INSERTING THEN
	:NEW.create_user := prm_audit.g_prm_user_name;
	:NEW.create_date := SYSDATE;
  END IF;		
end; 
/
/ 
--END TYPE:UP2 GROUP:151to151 NAME:TRIGGER_USESSION
--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES 
 --METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E63417_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
update projwbs set est_wt=1 where est_wt is null
/
--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
update task set est_wt=1 where est_wt is null
/
/ 
--END TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E68202_01' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:161to162 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:161to162 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E75426_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:161to162 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1712to1801 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1712to1801 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E90748_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:1712to1801 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1802to1803 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1802to1803 NAME:MISC_UPDATES
update prefer set license_data=null
/
/ 
--END TYPE:UP2 GROUP:1802to1803 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1803to1804 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1803to1804 NAME:MISC_UPDATES
insert into PROFPRIV (prof_id,priv_num,allow_flag)
select DISTINCT a.PROF_ID,177,'Y' from PROFPRIV a
where not exists ( select 1 from PROFPRIV b where b.PROF_ID=a.PROF_ID and b.priv_num=177 and b.allow_flag='Y') 
/

/ 
--END TYPE:UP2 GROUP:1803to1804 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1804to1805 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1804to1805 NAME:MISC_UPDATES
declare
cursor profile_cur is select prof_id,default_flag,superuser_flag,scope_type,prof_name from profile;
v_prof_id profpriv.prof_id%type;
v_priv_num profpriv.priv_num%type;
v_allow_flag profpriv.allow_flag%type;
begin
for v_cur in profile_cur loop
begin
select prof_id,priv_num,allow_flag into v_prof_id,v_priv_num,v_allow_flag from profpriv where prof_id= v_cur.prof_id and priv_num=177;
if v_prof_id=12 then
update profpriv set allow_flag ='Y' where prof_id= v_cur.prof_id and priv_num=177;
else
update profpriv set allow_flag ='N' where prof_id= v_cur.prof_id and priv_num=177;
end if;
exception when no_data_found then
if v_cur.prof_id=12 then
insert into profpriv (prof_id,priv_num,allow_flag) values (v_cur.prof_id,177,'Y');
else
insert into profpriv (prof_id,priv_num,allow_flag) values (v_cur.prof_id,177,'N');
end if;
end;
end loop;
end;
/

/ 
--END TYPE:UP2 GROUP:1804to1805 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1805to1806 NAME:MISC_UPDATES 
---METADATA TYPE:UP2 GROUP:1805to1806 NAME:MISC_UPDATES
update  PROJECT set wbs_max_sum_level =0 where wbs_max_sum_level is NULL
/
/ 
--END TYPE:UP2 GROUP:1805to1806 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES 
---METADATA TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F12057_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES 
---METADATA TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F12059_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE PCATTYPE SET PROJ_CATG_SHORT_LEN=60 WHERE PROJ_CATG_TYPE='Prime Workspace'
/
--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE PCATTYPE SET PROJ_CATG_TYPE='Primavera Workspace' WHERE PROJ_CATG_TYPE='Prime Workspace'
/

--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE RSRC SET INTG_TYPE='PrimaveraCloudScope' WHERE INTG_TYPE='PrimeScope'
/

--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE PROJWBS SET INTG_TYPE='PrimaveraCloudScope' WHERE INTG_TYPE='PrimeScope'
/


/ 
--END TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
DECLARE
  col_exists integer;
  cursor cur is select IMAGE_NAME ,image_id from IMAGEDATA;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('IMAGEDATA') and column_name=upper('Image_Extension');
  if col_exists > 0 then
   for i in cur loop 
    begin
      if instr(i.image_name,'.')>0 then
      execute immediate 'update imagedata
        set image_name = :1,
            image_extension = :2
      where image_id=:3' using SUBSTR(i.image_name,1,INSTR(i.image_name,'.',-1,1)-1),SUBSTR(i.image_name,INSTR(i.image_name,'.',-1,1)+1),i.image_id;  
      end if;
    exception when others then
      null;
    end;
   end loop;
  end if;
 END;
 /
 
--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
delete from profpriv pp
where exists
(select p.prof_id from profile p 
where p.prof_id = pp.prof_id and pp.priv_num=177
and p.scope_type = 'ST_Project')
/




/ 
--END TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1912to19121 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1912to19121 NAME:MISC_UPDATES
DECLARE
v_len number;
v_start_point number;
v_final blob;
cursor c is select issue_id,issue_notes 
from projissu where issue_notes is NOT NULL ;
begin
for rec in c loop
v_len := dbms_lob.getlength(rec.issue_notes);
if(v_len is not null and v_len > 0) then
v_start_point:=dbms_lob.instr(rec.issue_notes, utl_raw.cast_to_raw('DOCTYPE'));
if (v_start_point=0 or v_start_point is null) then
  dbms_lob.createtemporary(v_final, true);
  dbms_lob.append(v_final,utl_raw.cast_to_raw('<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN"><HTML><HEAD><META content="text/html; charset=unicode" http-equiv=Content-Type><META name=GENERATOR content="MSHTML 11.00.10570.1001"></HEAD><BODY><SPAN style="FONT-SIZE: medium; FONT-FAMILY: serif; WHITE-SPACE: normal; WORD-SPACING: 0px; TEXT-TRANSFORM: none; FLOAT: none; FONT-WEIGHT: 400; COLOR: rgb(0,0,0); FONT-STYLE: normal; ORPHANS: 2; WIDOWS: 2; DISPLAY: inline !important; LETTER-SPACING: normal; TEXT-INDENT: 0px; font-variant-ligatures: normal; font-variant-caps: normal; -webkit-text-stroke-width: 0px; text-decoration-style: initial; text-decoration-color: initial">'));
  dbms_lob.append(v_final, rec.issue_notes);
  dbms_lob.append(v_final,utl_raw.cast_to_raw('</SPAN></BODY></HTML>'));
  execute immediate 'update projissu set issue_notes = :1 where issue_id= :2' using v_final,rec.issue_id;
commit;
end if;
end if;
end loop;
dbms_lob.freetemporary(v_final);
dbms_lob.close(v_final);
EXCEPTION
 WHEN OTHERS THEN
  NULL;
end;
/
/ 
--END TYPE:UP2 GROUP:1912to19121 NAME:MISC_UPDATES
update prefer set database_version='PPMDB,1912.0006.0000.0000'
/
commit
/
