
--Run Script as     
SET DEFINE OFF

prompt Dropping constraint fk_prefer_users2 on table PREFER


--METADATA NAME:fk_prefer_users2 TYPE:CONSTRAINT TABLE_NAME:PREFER CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_prefer_users2');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PREFER DROP CONSTRAINT fk_prefer_users2';
  END IF;
END;
  /

prompt Dropping index ndx_projrisk_obs on table PROJRISK

--METADATA NAME:ndx_projrisk_obs TYPE:INDEX TABLE_NAME:PROJRISK CHANGE:DROP
DECLARE
  index_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO index_exists FROM user_indexes WHERE index_name = UPPER('ndx_projrisk_obs');

  IF index_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP INDEX ndx_projrisk_obs';
  END IF;
END;
      /

prompt Dropping index ndx_projrisk_projwbs on table PROJRISK

--METADATA NAME:ndx_projrisk_projwbs TYPE:INDEX TABLE_NAME:PROJRISK CHANGE:DROP
DECLARE
  index_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO index_exists FROM user_indexes WHERE index_name = UPPER('ndx_projrisk_projwbs');

  IF index_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP INDEX ndx_projrisk_projwbs';
  END IF;
END;
      /

prompt Dropping constraint fk_projrisk_obs on table PROJRISK


--METADATA NAME:fk_projrisk_obs TYPE:CONSTRAINT TABLE_NAME:PROJRISK CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_projrisk_obs');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PROJRISK DROP CONSTRAINT fk_projrisk_obs';
  END IF;
END;
  /

prompt Dropping constraint fk_projrisk_project on table PROJRISK


--METADATA NAME:fk_projrisk_project TYPE:CONSTRAINT TABLE_NAME:PROJRISK CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_projrisk_project');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PROJRISK DROP CONSTRAINT fk_projrisk_project';
  END IF;
END;
  /

prompt Dropping constraint fk_projrisk_risktype on table PROJRISK


--METADATA NAME:fk_projrisk_risktype TYPE:CONSTRAINT TABLE_NAME:PROJRISK CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_projrisk_risktype');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PROJRISK DROP CONSTRAINT fk_projrisk_risktype';
  END IF;
END;
  /

prompt Dropping constraint fk_projrisk_rsrc on table PROJRISK


--METADATA NAME:fk_projrisk_rsrc TYPE:CONSTRAINT TABLE_NAME:PROJRISK CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_projrisk_rsrc');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PROJRISK DROP CONSTRAINT fk_projrisk_rsrc';
  END IF;
END;
  /

prompt Dropping constraint fk_projrisk_projwbs on table PROJRISK


--METADATA NAME:fk_projrisk_projwbs TYPE:CONSTRAINT TABLE_NAME:PROJRISK CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_projrisk_projwbs');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PROJRISK DROP CONSTRAINT fk_projrisk_projwbs';
  END IF;
END;
  /

prompt Dropping constraint fk_riskctrl_project on table RISKCTRL


--METADATA NAME:fk_riskctrl_project TYPE:CONSTRAINT TABLE_NAME:RISKCTRL CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_riskctrl_project');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE RISKCTRL DROP CONSTRAINT fk_riskctrl_project';
  END IF;
END;
  /

prompt Dropping constraint fk_riskctrl_projrisk on table RISKCTRL


--METADATA NAME:fk_riskctrl_projrisk TYPE:CONSTRAINT TABLE_NAME:RISKCTRL CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_riskctrl_projrisk');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE RISKCTRL DROP CONSTRAINT fk_riskctrl_projrisk';
  END IF;
END;
  /

prompt Dropping index ndx_rsrchour_1 on table RSRCHOUR

--METADATA NAME:ndx_rsrchour_1 TYPE:INDEX TABLE_NAME:RSRCHOUR CHANGE:DROP
DECLARE
  index_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO index_exists FROM user_indexes WHERE index_name = UPPER('ndx_rsrchour_1');

  IF index_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP INDEX ndx_rsrchour_1';
  END IF;
END;
      /

prompt Dropping index ndx_taskpred_2 on table TASKPRED

--METADATA NAME:ndx_taskpred_2 TYPE:INDEX TABLE_NAME:TASKPRED CHANGE:DROP
DECLARE
  index_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO index_exists FROM user_indexes WHERE index_name = UPPER('ndx_taskpred_2');

  IF index_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP INDEX ndx_taskpred_2';
  END IF;
END;
      /

prompt Dropping constraint fk_tasksum_project on table TASKSUM


--METADATA NAME:fk_tasksum_project TYPE:CONSTRAINT TABLE_NAME:TASKSUM CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_tasksum_project');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE TASKSUM DROP CONSTRAINT fk_tasksum_project';
  END IF;
END;
  /

prompt Dropping constraint fk_tasksum_projwbs on table TASKSUM


--METADATA NAME:fk_tasksum_projwbs TYPE:CONSTRAINT TABLE_NAME:TASKSUM CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_tasksum_projwbs');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE TASKSUM DROP CONSTRAINT fk_tasksum_projwbs';
  END IF;
END;
  /

prompt Dropping constraint fk_timesht_rsrc on table TIMESHT


--METADATA NAME:fk_timesht_rsrc TYPE:CONSTRAINT TABLE_NAME:TIMESHT CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_timesht_rsrc');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE TIMESHT DROP CONSTRAINT fk_timesht_rsrc';
  END IF;
END;
  /

prompt Dropping constraint fk_timesht_tsdates on table TIMESHT


--METADATA NAME:fk_timesht_tsdates TYPE:CONSTRAINT TABLE_NAME:TIMESHT CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_timesht_tsdates');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE TIMESHT DROP CONSTRAINT fk_timesht_tsdates';
  END IF;
END;
  /

prompt Dropping constraint fk_trsrcsum_project on table TRSRCSUM


--METADATA NAME:fk_trsrcsum_project TYPE:CONSTRAINT TABLE_NAME:TRSRCSUM CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_trsrcsum_project');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE TRSRCSUM DROP CONSTRAINT fk_trsrcsum_project';
  END IF;
END;
  /

prompt Dropping constraint fk_trsrcsum_roles on table TRSRCSUM


--METADATA NAME:fk_trsrcsum_roles TYPE:CONSTRAINT TABLE_NAME:TRSRCSUM CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_trsrcsum_roles');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE TRSRCSUM DROP CONSTRAINT fk_trsrcsum_roles';
  END IF;
END;
  /

prompt Dropping constraint fk_trsrcsum_rsrc on table TRSRCSUM


--METADATA NAME:fk_trsrcsum_rsrc TYPE:CONSTRAINT TABLE_NAME:TRSRCSUM CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_trsrcsum_rsrc');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE TRSRCSUM DROP CONSTRAINT fk_trsrcsum_rsrc';
  END IF;
END;
  /

prompt Dropping constraint fk_uaccess_project on table UACCESS


--METADATA NAME:fk_uaccess_project TYPE:CONSTRAINT TABLE_NAME:UACCESS CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_uaccess_project');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE UACCESS DROP CONSTRAINT fk_uaccess_project';
  END IF;
END;
  /

prompt Dropping constraint ck_usereng_named_user_flag on table USERENG


--METADATA NAME:ck_usereng_named_user_flag TYPE:CONSTRAINT TABLE_NAME:USERENG CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('ck_usereng_named_user_flag');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE USERENG DROP CONSTRAINT ck_usereng_named_user_flag';
  END IF;
END;
  /

prompt Dropping constraint fk_navidash_dashboard on table NAVIDASH


--METADATA NAME:fk_navidash_dashboard TYPE:CONSTRAINT TABLE_NAME:NAVIDASH CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_navidash_dashboard');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE NAVIDASH DROP CONSTRAINT fk_navidash_dashboard';
  END IF;
END;
  /

prompt Dropping constraint fk_navidash_naviview on table NAVIDASH


--METADATA NAME:fk_navidash_naviview TYPE:CONSTRAINT TABLE_NAME:NAVIDASH CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_navidash_naviview');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE NAVIDASH DROP CONSTRAINT fk_navidash_naviview';
  END IF;
END;
  /

prompt Dropping constraint fk_naviview_users on table NAVIVIEW


--METADATA NAME:fk_naviview_users TYPE:CONSTRAINT TABLE_NAME:NAVIVIEW CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_naviview_users');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE NAVIVIEW DROP CONSTRAINT fk_naviview_users';
  END IF;
END;
  /

prompt Creating table DISCUSSION

--METADATA NAME:DISCUSSION TYPE:TABLE CHANGE:CREATE
CREATE TABLE DISCUSSION(
  discussion_id  number(10) NOT NULL,
  task_id  number(10) NOT NULL,
  discussion_value  varchar2(4000 CHAR) NULL,
  discussion_date  DATE NULL,
  user_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_discussion PRIMARY KEY (discussion_id)  )
TABLESPACE ${ppm.data_tablespace}
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table DISCUSSION_READ

--METADATA NAME:DISCUSSION_READ TYPE:TABLE CHANGE:CREATE
CREATE TABLE DISCUSSION_READ(
  discussion_id  number(10) NOT NULL,
  user_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_discussion_read PRIMARY KEY (discussion_id,user_id)  )
TABLESPACE ${ppm.data_tablespace}
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table DOCREVIEW

--METADATA NAME:DOCREVIEW TYPE:TABLE CHANGE:CREATE
CREATE TABLE DOCREVIEW(
  doc_review_id  number(10) NOT NULL,
  doc_id  number(10) NOT NULL,
  user_id  number(10) NULL,
  review_name  varchar2(255 CHAR) NULL,
  review_descr  varchar2(255 CHAR) NULL,
  review_type  varchar2(15 CHAR) NULL,
  due_date  DATE NULL,
  status  varchar2(15 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_docreview PRIMARY KEY (doc_review_id)  )
TABLESPACE ${ppm.data_tablespace}
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
--METADATA  TYPE:ADHOC_SQL
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,162,'N', sysdate, sys_context('USERENV','CURRENT_SCHEMA') from profpriv p,profile pf  where scope_type='ST_Global' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=162)
/
--METADATA  TYPE:ADHOC_SQL
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select prof_id,163,case p.allow_flag when 'Y' then 'Y' else 'N' END, sysdate, sys_context('USERENV','CURRENT_SCHEMA') from profpriv p where priv_num=22  and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=163) 
/

prompt Creating table DOCREVIEWTASK

--METADATA NAME:DOCREVIEWTASK TYPE:TABLE CHANGE:CREATE
CREATE TABLE DOCREVIEWTASK(
  review_task_id  number(10) NOT NULL,
  doc_review_id  number(10) NOT NULL,
  user_id  number(10) NULL,
  review_date  DATE NULL,
  comments  varchar2(4000 CHAR) NULL,
  priority  number(10) NULL,
  status  varchar2(15 CHAR) NULL,
  attachment_uuid  varchar2(4000 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_docreviewtask PRIMARY KEY (review_task_id)  )
TABLESPACE ${ppm.data_tablespace}
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table IMAGEDATA

--METADATA NAME:IMAGEDATA TYPE:TABLE CHANGE:CREATE
CREATE TABLE IMAGEDATA(
  image_id  number(10) NOT NULL,
  image_name  varchar2(120 CHAR) NULL,
  image_data  BLOB NOT NULL,
  image_thumbnail  BLOB NOT NULL,
  image_extension  varchar2(20 CHAR) DEFAULT 'png' NOT NULL,
  default_flag  varchar2(1 CHAR) NOT NULL,
  image_purpose  varchar2(50 CHAR) NOT NULL,
  image_description  varchar2(250 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_imagedata PRIMARY KEY (image_id)  )
TABLESPACE ${ppm.data_tablespace}
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table LOCATION

--METADATA NAME:LOCATION TYPE:TABLE CHANGE:CREATE
CREATE TABLE LOCATION(
  location_id  number(10) NOT NULL,
  location_name  varchar2(255 CHAR) NOT NULL,
  location_type  varchar2(24 CHAR) NULL,
  address_line1  varchar2(200 CHAR) NULL,
  address_line2  varchar2(200 CHAR) NULL,
  address_line3  varchar2(200 CHAR) NULL,
  city_name  varchar2(200 CHAR) NULL,
  municipality_name  varchar2(200 CHAR) NULL,
  state_name  varchar2(200 CHAR) NULL,
  state_code  varchar2(2 CHAR) NULL,
  country_name  varchar2(200 CHAR) NULL,
  country_code  varchar2(3 CHAR) NULL,
  postal_code  varchar2(20 CHAR) NULL,
  longitude  NUMBER NULL,
  latitude  NUMBER NULL,
  geo_location  SDO_GEOMETRY NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_location PRIMARY KEY (location_id)  )
TABLESPACE ${ppm.data_tablespace}
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
--METADATA  TYPE:ADHOC_SQL
DECLARE
TABLE_MISSING exception;
pragma exception_init(TABLE_MISSING,-942);
BEGIN
execute immediate q'[INSERT INTO USER_SDO_GEOM_METADATA (TABLE_NAME, COLUMN_NAME, DIMINFO, SRID) 
VALUES ('LOCATION', 'GEO_LOCATION', 
   SDO_DIM_ARRAY 
     (SDO_DIM_ELEMENT('LONG', -180.0, 180.0, 0.5), 
     SDO_DIM_ELEMENT('LAT', -90.0, 90.0, 0.5)), 
   8307)]';
EXCEPTION WHEN TABLE_MISSING  THEN NULL;
END;   
/

--METADATA NAME:ndx_location_geo_location TYPE:INDEX TABLE_NAME:LOCATION CHANGE:CREATE      
BEGIN
execute immediate 'CREATE INDEX ndx_location_geo_location
ON location (geo_location)
INDEXTYPE IS mdsys.spatial_index';
EXCEPTION WHEN OTHERS THEN NULL;
END;   
/
  
  
prompt Creating table PFOLIOUSER

--METADATA NAME:PFOLIOUSER TYPE:TABLE CHANGE:CREATE
CREATE TABLE PFOLIOUSER(
  pfolio_id  number(10) NOT NULL,
  user_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_pfoliouser PRIMARY KEY (pfolio_id,user_id)  )
TABLESPACE ${ppm.data_tablespace}
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table SUMPROJCOST

--METADATA NAME:SUMPROJCOST TYPE:TABLE CHANGE:CREATE
CREATE TABLE SUMPROJCOST(
  proj_id  number(10) NOT NULL,
  wbs_id  number(10) NOT NULL,
  cost_type_id  number(10) NOT NULL,
  start_date  DATE NULL,
  end_date  DATE NULL,
  spread_type  varchar2(20 CHAR) NULL,
  act_cost  number(23,6) NULL,
  remain_cost  number(23,6) NULL,
  target_cost  number(23,6) NULL,
  total_cost  number(23,6) NULL
  )
TABLESPACE ${ppm.data_tablespace}
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table SUMTASK

--METADATA NAME:SUMTASK TYPE:TABLE CHANGE:CREATE
CREATE TABLE SUMTASK(
  proj_id  number(10) NOT NULL,
  wbs_id  number(10) NOT NULL,
  bcwp  number(25,6) NULL,
  bcws  number(25,6) NULL,
  eac  number(25,6) NULL,
  eac_work_qty  number(22,6) NULL,
  etc  number(25,6) NULL,
  etc_work_qty  number(22,6) NULL,
  perfm_work_qty  number(22,6) NULL,
  sched_work_qty  number(22,6) NULL,
  complete_cnt  number(10) NULL,
  active_cnt  number(10) NULL,
  notstarted_cnt  number(10) NULL,
  base_complete_cnt  number(10) NULL,
  base_active_cnt  number(10) NULL,
  base_notstarted_cnt  number(10) NULL,
  act_drtn_hr_cnt  number(17,6) NULL,
  total_drtn_hr_cnt  number(17,6) NULL,
  base_drtn_hr_cnt  number(17,6) NULL,
  remain_drtn_hr_cnt  number(17,6) NULL,
  total_float_hr_cnt  number(17,6) NULL,
  act_end_date  DATE NULL,
  act_start_date  DATE NULL,
  base_end_date  DATE NULL,
  base_start_date  DATE NULL,
  reend_date  DATE NULL,
  restart_date  DATE NULL,
  act_this_per_work_cost  number(25,6) NULL,
  act_this_per_work_qty  number(22,6) NULL,
  act_this_per_equip_cost  number(25,6) NULL,
  act_this_per_equip_qty  number(22,6) NULL,
  act_this_per_mat_cost  number(25,6) NULL,
  act_cost  number(25,6) NULL,
  act_equip_cost  number(25,6) NULL,
  act_expense_cost  number(25,6) NULL,
  act_mat_cost  number(25,6) NULL,
  act_work_cost  number(25,6) NULL,
  act_equip_qty  number(22,6) NULL,
  act_work_qty  number(22,6) NULL,
  base_cost  number(25,6) NULL,
  base_equip_cost  number(25,6) NULL,
  base_expense_cost  number(25,6) NULL,
  base_mat_cost  number(25,6) NULL,
  base_work_cost  number(25,6) NULL,
  base_equip_qty  number(22,6) NULL,
  base_work_qty  number(22,6) NULL,
  remain_cost  number(25,6) NULL,
  remain_equip_cost  number(25,6) NULL,
  remain_expense_cost  number(25,6) NULL,
  remain_mat_cost  number(25,6) NULL,
  remain_work_cost  number(25,6) NULL,
  remain_equip_qty  number(22,6) NULL,
  remain_work_qty  number(22,6) NULL,
  target_cost  number(25,6) NULL,
  target_equip_cost  number(25,6) NULL,
  target_expense_cost  number(25,6) NULL,
  target_mat_cost  number(25,6) NULL,
  target_work_cost  number(25,6) NULL,
  target_equip_qty  number(22,6) NULL,
  target_work_qty  number(22,6) NULL,
  total_cost  number(25,6) NULL,
  total_equip_cost  number(25,6) NULL,
  total_expense_cost  number(25,6) NULL,
  total_mat_cost  number(25,6) NULL,
  total_work_cost  number(25,6) NULL,
  total_equip_qty  number(22,6) NULL,
  total_work_qty  number(22,6) NULL,
  target_start_date  DATE NULL,
  target_end_date  DATE NULL,
  target_drtn_hr_cnt  number(17,6) NULL
  )
TABLESPACE ${ppm.data_tablespace}
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
--METADATA  TYPE:ADHOC_SQL
UPDATE prefer SET phase_label='WBS Category',update_date=sysdate,update_user=sys_context('USERENV','CURRENT_SCHEMA')
/
--METADATA  TYPE:ADHOC_SQL
UPDATE projwbs SET sum_data_flag='N' where sum_data_flag != 'N'
/
--METADATA  TYPE:ADHOC_SQL
UPDATE project SET last_tasksum_date=null where last_tasksum_date is not null
/

prompt Creating table SUMTASKSPREAD

--METADATA NAME:SUMTASKSPREAD TYPE:TABLE CHANGE:CREATE
CREATE TABLE SUMTASKSPREAD(
  proj_id  number(10) NOT NULL,
  wbs_id  number(10) NOT NULL,
  start_date  DATE NOT NULL,
  end_date  DATE NOT NULL,
  spread_type  varchar2(20 CHAR) NOT NULL,
  act_cost  number(25,6) NULL,
  act_equip_cost  number(25,6) NULL,
  act_expense_cost  number(25,6) NULL,
  act_mat_cost  number(25,6) NULL,
  act_work_cost  number(25,6) NULL,
  act_equip_qty  number(22,6) NULL,
  act_work_qty  number(22,6) NULL,
  base_cost  number(25,6) NULL,
  base_equip_cost  number(25,6) NULL,
  base_expense_cost  number(25,6) NULL,
  base_mat_cost  number(25,6) NULL,
  base_work_cost  number(25,6) NULL,
  base_equip_qty  number(22,6) NULL,
  base_work_qty  number(22,6) NULL,
  late_remain_cost  number(25,6) NULL,
  late_remain_equip_cost  number(25,6) NULL,
  late_remain_expense_cost  number(25,6) NULL,
  late_remain_mat_cost  number(25,6) NULL,
  late_remain_work_cost  number(25,6) NULL,
  late_remain_equip_qty  number(22,6) NULL,
  late_remain_work_qty  number(22,6) NULL,
  remain_cost  number(25,6) NULL,
  remain_equip_cost  number(25,6) NULL,
  remain_expense_cost  number(25,6) NULL,
  remain_mat_cost  number(25,6) NULL,
  remain_work_cost  number(25,6) NULL,
  remain_equip_qty  number(22,6) NULL,
  remain_work_qty  number(22,6) NULL,
  target_cost  number(25,6) NULL,
  target_equip_cost  number(25,6) NULL,
  target_expense_cost  number(25,6) NULL,
  target_mat_cost  number(25,6) NULL,
  target_work_cost  number(25,6) NULL,
  target_equip_qty  number(22,6) NULL,
  target_work_qty  number(22,6) NULL,
  total_cost  number(25,6) NULL,
  total_equip_cost  number(25,6) NULL,
  total_expense_cost  number(25,6) NULL,
  total_mat_cost  number(25,6) NULL,
  total_work_cost  number(25,6) NULL,
  total_equip_qty  number(22,6) NULL,
  total_work_qty  number(22,6) NULL,
  bcwp  number(25,6) NULL,
  bcws  number(25,6) NULL,
  eac  number(25,6) NULL,
  eac_work_qty  number(22,6) NULL,
  etc  number(25,6) NULL,
  etc_work_qty  number(22,6) NULL,
  perfm_work_qty  number(22,6) NULL,
  sched_work_qty  number(22,6) NULL,
  fin_period_act_work_qty  number(22,6) NULL,
  fin_period_act_work_cost  number(25,6) NULL,
  fin_period_act_equip_qty  number(22,6) NULL,
  fin_period_act_equip_cost  number(25,6) NULL,
  fin_period_act_mat_cost  number(25,6) NULL,
  fin_period_act_expense_cost  number(25,6) NULL,
  fin_period_total_work_qty  number(22,6) NULL,
  fin_period_total_work_cost  number(25,6) NULL,
  fin_period_total_equip_qty  number(22,6) NULL,
  fin_period_total_equip_cost  number(25,6) NULL,
  fin_period_total_mat_cost  number(25,6) NULL,
  fin_period_total_expense_cost  number(25,6) NULL,
  fin_period_total_cost  number(25,6) NULL,
  fin_period_act_cost  number(25,6) NULL,
  fin_period_bcwp  number(25,6) NULL,
  fin_period_perfm_work_qty  number(22,6) NULL,
  fin_period_eac  number(25,6) NULL,
  fin_period_eac_work_qty  number(22,6) NULL,
  fin_period_bcws  number(25,6) NULL,
  fin_period_sched_work_qty  number(22,6) NULL
  )
TABLESPACE ${ppm.data_tablespace}
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table SUMTRSRC

--METADATA NAME:SUMTRSRC TYPE:TABLE CHANGE:CREATE
CREATE TABLE SUMTRSRC(
  sumtrsrc_id  number(10) NOT NULL,
  proj_id  number(10) NULL,
  wbs_id  number(10) NULL,
  start_date  DATE NULL,
  end_date  DATE NULL,
  spread_type  varchar2(20 CHAR) NULL,
  rsrc_id  number(10) NULL,
  role_id  number(10) NULL,
  act_start_date  DATE NULL,
  act_end_date  DATE NULL,
  remain_start_date  DATE NULL,
  remain_end_date  DATE NULL,
  overalloc_date  DATE NULL,
  staffed_act_qty  number(23,6) NULL,
  unstaffed_act_qty  number(23,6) NULL,
  staffed_act_cost  number(23,6) NULL,
  unstaffed_act_cost  number(23,6) NULL,
  staffed_act_ot_qty  number(23,6) NULL,
  unstaffed_act_ot_qty  number(23,6) NULL,
  staffed_act_ot_cost  number(23,6) NULL,
  unstaffed_act_ot_cost  number(23,6) NULL,
  staffed_act_reg_cost  number(23,6) NULL,
  unstaffed_act_reg_cost  number(23,6) NULL,
  staffed_act_reg_qty  number(23,6) NULL,
  unstaffed_act_reg_qty  number(23,6) NULL,
  staffed_late_remain_qty  number(23,6) NULL,
  unstaffed_late_remain_qty  number(23,6) NULL,
  staffed_late_remain_cost  number(23,6) NULL,
  unstaffed_late_remain_cost  number(23,6) NULL,
  staffed_remain_qty  number(23,6) NULL,
  unstaffed_remain_qty  number(23,6) NULL,
  staffed_remain_cost  number(23,6) NULL,
  unstaffed_remain_cost  number(23,6) NULL,
  staffed_target_qty  number(23,6) NULL,
  unstaffed_target_qty  number(23,6) NULL,
  staffed_target_cost  number(23,6) NULL,
  unstaffed_target_cost  number(23,6) NULL,
  staffed_total_qty  number(23,6) NULL,
  unstaffed_total_qty  number(23,6) NULL,
  staffed_total_cost  number(23,6) NULL,
  unstaffed_total_cost  number(23,6) NULL,
  fin_period_act_qty  number(23,6) NULL,
  fin_period_act_cost  number(23,6) NULL,
  fin_period_total_qty  number(23,6) NULL,
  fin_period_total_cost  number(23,6) NULL
,CONSTRAINT pk_sumtrsrc PRIMARY KEY (sumtrsrc_id)  )
TABLESPACE ${ppm.data_tablespace}
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table TASKRISK

--METADATA NAME:TASKRISK TYPE:TABLE CHANGE:CREATE
CREATE TABLE TASKRISK(
  task_id  number(10) NOT NULL,
  risk_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_risk_task PRIMARY KEY (risk_id,task_id)  )
TABLESPACE ${ppm.data_tablespace}
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table TASKSUMFIN

--METADATA NAME:TASKSUMFIN TYPE:TABLE CHANGE:CREATE
CREATE TABLE TASKSUMFIN(
  task_sum_fin_id  number(10) NOT NULL,
  fin_dates_id  number(10) NOT NULL,
  wbs_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  task_sum_id  number(10) NOT NULL,
  act_work_qty  number(22,6) NULL,
  act_work_cost  number(25,6) NULL,
  act_equip_qty  number(22,6) NULL,
  act_equip_cost  number(25,6) NULL,
  act_mat_cost  number(25,6) NULL,
  act_expense_cost  number(25,6) NULL,
  total_work_qty  number(22,6) NULL,
  total_work_cost  number(25,6) NULL,
  total_equip_qty  number(22,6) NULL,
  total_equip_cost  number(25,6) NULL,
  total_mat_cost  number(25,6) NULL,
  total_expense_cost  number(25,6) NULL,
  total_cost  number(23,6) NULL,
  act_cost  number(23,6) NULL,
  bcwp  number(25,6) NULL,
  perfm_work_qty  number(22,6) NULL,
  etc  number(25,6) NULL,
  etc_work_qty  number(22,6) NULL,
  eac  number(25,6) NULL,
  eac_work  number(22,6) NULL,
  bcws  number(25,6) NULL,
  acwp  number(25,6) NULL,
  sched_work_qty  number(22,6) NULL,
  base_cost  number(23,6) NULL,
  base_work_qty  number(22,6) NULL,
  base_work_cost  number(25,6) NULL,
  base_mat_cost  number(25,6) NULL,
  base_equip_cost  number(25,6) NULL,
  base_equip_qty  number(22,6) NULL,
  base_expense_cost  number(25,6) NULL,
  remain_cost  number(23,6) NULL,
  remain_work_qty  number(22,6) NULL,
  remain_work_cost  number(25,6) NULL,
  remain_mat_cost  number(25,6) NULL,
  remain_equip_cost  number(25,6) NULL,
  remain_equip_qty  number(22,6) NULL,
  remain_expense_cost  number(25,6) NULL,
  target_cost  number(23,6) NULL,
  target_equip_cost  number(25,6) NULL,
  target_equip_qty  number(22,6) NULL,
  target_expense_cost  number(25,6) NULL,
  target_mat_cost  number(25,6) NULL,
  target_work_cost  number(25,6) NULL,
  target_work_qty  number(22,6) NULL,
  late_remain_work_qty  number(22,6) NULL,
  late_remain_work_cost  number(25,6) NULL,
  late_remain_equip_cost  number(25,6) NULL,
  late_remain_equip_qty  number(22,6) NULL,
  late_remain_cost  number(23,6) NULL,
  late_remain_mat_cost  number(25,6) NULL,
  late_remain_expense_cost  number(25,6) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_tasksumfin PRIMARY KEY (task_sum_fin_id)  )
TABLESPACE ${ppm.data_tablespace}
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table TMPLCATG

--METADATA NAME:TMPLCATG TYPE:TABLE CHANGE:CREATE
CREATE TABLE TMPLCATG(
  tmplcatg_catg_id  number(10) NOT NULL,
  catg_name  varchar2(255 CHAR) NOT NULL,
  project_flag  varchar2(1 CHAR) NOT NULL,
  process_flag  varchar2(1 CHAR) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_tmplcatg PRIMARY KEY (tmplcatg_catg_id)  )
TABLESPACE ${ppm.data_tablespace}
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table TRSRCSUMFN

--METADATA NAME:TRSRCSUMFN TYPE:TABLE CHANGE:CREATE
CREATE TABLE TRSRCSUMFN(
  trsrc_sum_fin_id  number(10) NOT NULL,
  fin_dates_id  number(10) NOT NULL,
  proj_id  number(10) NULL,
  rsrc_id  number(10) NULL,
  role_id  number(10) NULL,
  taskrsrc_sum_id  number(10) NOT NULL,
  act_qty  number(17,6) NULL,
  act_cost  number(23,6) NULL,
  act_ot_qty  number(17,6) NULL,
  act_reg_qty  number(17,6) NULL,
  act_ot_cost  number(23,6) NULL,
  act_reg_cost  number(23,6) NULL,
  total_qty  number(22,6) NULL,
  total_cost  number(23,6) NULL,
  remain_qty  number(17,6) NULL,
  remain_cost  number(23,6) NULL,
  target_qty  number(19,6) NULL,
  target_cost  number(23,6) NULL,
  staffed_remain_qty  number(17,6) NULL,
  unstaffed_remain_qty  number(17,6) NULL,
  staffed_remain_cost  number(25,6) NULL,
  unstaffed_remain_cost  number(25,6) NULL,
  staffed_late_remain_qty  number(17,6) NULL,
  unstaffed_late_remain_qty  number(17,6) NULL,
  staffed_late_remain_cost  number(25,6) NULL,
  unstaffed_late_remain_cost  number(25,6) NULL,
  late_remain_qty  number(17,6) NULL,
  late_remain_cost  number(25,6) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_trsrcsumfn PRIMARY KEY (trsrc_sum_fin_id)  )
TABLESPACE ${ppm.data_tablespace}
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table TSAUDIT

--METADATA NAME:TSAUDIT TYPE:TABLE CHANGE:CREATE
CREATE TABLE TSAUDIT(
  ts_audit_id  number(10) NOT NULL,
  audit_date  DATE NULL,
  rsrc_id  number(10) NULL,
  rsrc_short_name  varchar2(255 CHAR) NULL,
  rsrc_name  varchar2(255 CHAR) NULL,
  ts_status_code  varchar2(20 CHAR) NULL,
  reg_hrs  number(17,6) NULL,
  reg_ot_hrs  number(17,6) NULL,
  pend_reg_hrs  number(17,6) NULL,
  pend_reg_ot_hrs  number(17,6) NULL,
  oh_hrs  number(17,6) NULL,
  oh_ot_hrs  number(17,6) NULL,
  pend_oh_hrs  number(17,6) NULL,
  pend_oh_ot_hrs  number(17,6) NULL,
  ts_id  number(10) NULL,
  ts_start_date  DATE NULL,
  ts_end_date  DATE NULL,
  proj_id  number(10) NULL,
  proj_short_name  varchar2(40 CHAR) NULL,
  ts_task_status  varchar2(20 CHAR) NULL,
  user_id  number(10) NULL,
  user_name  varchar2(255 CHAR) NULL,
  approving_as  varchar2(50 CHAR) NULL
,CONSTRAINT pk_tsaudit PRIMARY KEY (ts_audit_id)  )
TABLESPACE ${ppm.data_tablespace}
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
--METADATA  TYPE:ADHOC_SQL
truncate table refrdel
/

prompt Creating table TSDELEGATE

--METADATA NAME:TSDELEGATE TYPE:TABLE CHANGE:CREATE
CREATE TABLE TSDELEGATE(
  ts_delegate_id  number(10) NOT NULL,
  user_id  number(10) NOT NULL,
  ts_delegate_user_id  number(10) NOT NULL,
  proj_id  number(10) NULL,
  active_flag  varchar2(1 CHAR) DEFAULT 'N' NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_tsdelegate PRIMARY KEY (ts_delegate_id)  )
TABLESPACE ${ppm.data_tablespace}
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table USEROPEN

--METADATA NAME:USEROPEN TYPE:TABLE CHANGE:CREATE
CREATE TABLE USEROPEN(
  user_open_id  number(10) NOT NULL,
  user_open_name  varchar2(255 CHAR) NOT NULL,
  user_id  number(10) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_useropen PRIMARY KEY (user_open_id)  )
TABLESPACE ${ppm.data_tablespace}
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table USER_ACCEPTANCE_CONSENT

--METADATA NAME:USER_ACCEPTANCE_CONSENT TYPE:TABLE CHANGE:CREATE
CREATE TABLE USER_ACCEPTANCE_CONSENT(
  user_id  number(10) NOT NULL,
  status  number(10) NULL,
  modified_date  DATE DEFAULT sysdate NULL,
  consent_type  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_user_acceptance_consent PRIMARY KEY (user_id,consent_type)  )
TABLESPACE ${ppm.data_tablespace}
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table USROPNVAL

--METADATA NAME:USROPNVAL TYPE:TABLE CHANGE:CREATE
CREATE TABLE USROPNVAL(
  user_open_id  number(10) NOT NULL,
  pk_id  number(10) NOT NULL,
  usropn_type  varchar2(20 CHAR) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_usropnval PRIMARY KEY (user_open_id,pk_id,usropn_type)  )
TABLESPACE ${ppm.data_tablespace}
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table VWPREFDASH

--METADATA NAME:VWPREFDASH TYPE:TABLE CHANGE:CREATE
CREATE TABLE VWPREFDASH(
  dashboard_id  number(10) NOT NULL,
  view_pref_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_vwprefdash PRIMARY KEY (dashboard_id,view_pref_id)  )
TABLESPACE ${ppm.data_tablespace}
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
--METADATA  TYPE:ADHOC_SQL
DELETE from admin_config where config_name = 'myprimavera.bre.INTERNAL_PLUGINS' 
/

prompt Creating table WKFLTMPL

--METADATA NAME:WKFLTMPL TYPE:TABLE CHANGE:CREATE
CREATE TABLE WKFLTMPL(
  wkfl_tmpl_id  number(10) NOT NULL,
  template_name  varchar2(255 CHAR) NOT NULL,
  project_flag  varchar2(1 CHAR) NOT NULL,
  wk_external_key  varchar2(255 CHAR) NULL,
  tmplcatg_catg_id  number(10) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_wkfltmpl PRIMARY KEY (wkfl_tmpl_id)  )
TABLESPACE ${ppm.data_tablespace}
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
--METADATA NAME:color TYPE:FIELD TABLE_NAME:ACTVCODE CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('ACTVCODE') and column_name=upper('color');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE ACTVCODE add   color  varchar2(6 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:rsrc_private TYPE:FIELD TABLE_NAME:CALENDAR CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('CALENDAR') and column_name=upper('rsrc_private');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE CALENDAR add   rsrc_private  varchar2(1 CHAR) DEFAULT ''N'' NOT NULL
';
  end if;
END;         
/

--METADATA NAME:day_hr_cnt TYPE:FIELD TABLE_NAME:CALENDAR CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('CALENDAR') and column_name=upper('day_hr_cnt');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE CALENDAR add   day_hr_cnt  number(10,2) NULL
';
  end if;
END;         
/

--METADATA NAME:week_hr_cnt TYPE:FIELD TABLE_NAME:CALENDAR CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('CALENDAR') and column_name=upper('week_hr_cnt');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE CALENDAR add   week_hr_cnt  number(10,2) NULL
';
  end if;
END;         
/

--METADATA NAME:year_hr_cnt TYPE:FIELD TABLE_NAME:CALENDAR CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('CALENDAR') and column_name=upper('year_hr_cnt');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE CALENDAR add   year_hr_cnt  number(10,2) NULL
';
  end if;
END;         
/

--METADATA NAME:month_hr_cnt TYPE:FIELD TABLE_NAME:CALENDAR CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('CALENDAR') and column_name=upper('month_hr_cnt');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE CALENDAR add   month_hr_cnt  number(10,2) NULL
';
  end if;
END;         
/

--METADATA NAME:parent_actv_code_id TYPE:FIELD TABLE_NAME:DLTACTV CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('DLTACTV') and column_name=upper('parent_actv_code_id');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE DLTACTV add   parent_actv_code_id  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:cr_external_doc_key TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('DOCUMENT') and column_name=upper('cr_external_doc_key');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE DOCUMENT add   cr_external_doc_key  varchar2(4000 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:rpt_id TYPE:FIELD TABLE_NAME:FILTPROP CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('FILTPROP') and column_name=upper('rpt_id');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE FILTPROP add   rpt_id  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:parent_job_id TYPE:FIELD TABLE_NAME:JOBSVC CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('JOBSVC') and column_name=upper('parent_job_id');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE JOBSVC add   parent_job_id  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:old_str TYPE:FIELD TABLE_NAME:PKXREF CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PKXREF') and column_name=upper('old_str');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PKXREF add   old_str  varchar2(40 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:new_str TYPE:FIELD TABLE_NAME:PKXREF CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PKXREF') and column_name=upper('new_str');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PKXREF add   new_str  varchar2(40 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:ts_rsrc_def_asgn_out_actv_flag TYPE:FIELD TABLE_NAME:PREFER CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PREFER') and column_name=upper('ts_rsrc_def_asgn_out_actv_flag');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PREFER add   ts_rsrc_def_asgn_out_actv_flag  varchar2(1 CHAR) DEFAULT ''Y'' NOT NULL
';
  end if;
END;         
/

--METADATA NAME:prof_descr TYPE:FIELD TABLE_NAME:PROFILE CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROFILE') and column_name=upper('prof_descr');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROFILE add   prof_descr  varchar2(255 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:cr_external_key TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJECT') and column_name=upper('cr_external_key');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJECT add   cr_external_key  varchar2(4000 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:apply_actuals_date TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJECT') and column_name=upper('apply_actuals_date');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJECT add   apply_actuals_date  DATE NULL
';
  end if;
END;         
/

--METADATA  TYPE:ADHOC_SQL
update usereng set named_user_flag='Y',update_date=sysdate,update_user=sys_context('USERENV','CURRENT_SCHEMA') where named_user_flag='N'
/

--METADATA NAME:description TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJECT') and column_name=upper('description');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJECT add   description  varchar2(500 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:intg_proj_type TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJECT') and column_name=upper('intg_proj_type');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJECT add   intg_proj_type  varchar2(7 CHAR) NULL
';
  end if;
END;         
/

--METADATA  TYPE:ADHOC_SQL
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,157,'N', sysdate, sys_context('USERENV','CURRENT_SCHEMA') from profpriv p,profile pf  where scope_type='ST_Project' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=157) 
/

--METADATA NAME:matrix_id TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJECT') and column_name=upper('matrix_id');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJECT add   matrix_id  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:location_id TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJECT') and column_name=upper('location_id');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJECT add   location_id  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:control_updates_flag TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJECT') and column_name=upper('control_updates_flag');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJECT add   control_updates_flag  varchar2(1 CHAR) DEFAULT ''N'' NOT NULL
';
  end if;
END;         
/

--METADATA  TYPE:ADHOC_SQL
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,169,'N', sysdate, sys_context('USERENV','CURRENT_SCHEMA') from profpriv p,profile pf  where scope_type='ST_Global' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=169)
/

--METADATA NAME:hist_interval TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJECT') and column_name=upper('hist_interval');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJECT add   hist_interval  varchar2(25 CHAR) DEFAULT ''Month'' NOT NULL
';
  end if;
END;         
/

--METADATA NAME:hist_level TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJECT') and column_name=upper('hist_level');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJECT add   hist_level  varchar2(10 CHAR) DEFAULT ''HL_None'' NOT NULL
';
  end if;
END;         
/

--METADATA NAME:risk_to_type TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJRISK') and column_name=upper('risk_to_type');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJRISK add   risk_to_type  varchar2(12 CHAR) DEFAULT ''RT_Threat'' NOT NULL
';
  end if;
END;         
/

--METADATA NAME:identified_by_id TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJRISK') and column_name=upper('identified_by_id');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJRISK add   identified_by_id  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:response_type TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJRISK') and column_name=upper('response_type');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJRISK add   response_type  varchar2(12 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:response_text TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJRISK') and column_name=upper('response_text');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJRISK add   response_text  varchar2(255 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:pre_rsp_prblty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJRISK') and column_name=upper('pre_rsp_prblty');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJRISK add   pre_rsp_prblty  varchar2(2 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:pre_rsp_schd_prblty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJRISK') and column_name=upper('pre_rsp_schd_prblty');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJRISK add   pre_rsp_schd_prblty  varchar2(2 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:pre_rsp_cost_prblty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJRISK') and column_name=upper('pre_rsp_cost_prblty');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJRISK add   pre_rsp_cost_prblty  varchar2(2 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:post_rsp_prblty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJRISK') and column_name=upper('post_rsp_prblty');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJRISK add   post_rsp_prblty  varchar2(2 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:post_rsp_schd_prblty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJRISK') and column_name=upper('post_rsp_schd_prblty');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJRISK add   post_rsp_schd_prblty  varchar2(2 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:post_rsp_cost_prblty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJRISK') and column_name=upper('post_rsp_cost_prblty');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJRISK add   post_rsp_cost_prblty  varchar2(2 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:risk_cause TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJRISK') and column_name=upper('risk_cause');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJRISK add   risk_cause  varchar2(4000 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:risk_effect TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJRISK') and column_name=upper('risk_effect');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJRISK add   risk_effect  varchar2(4000 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:notes TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJRISK') and column_name=upper('notes');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJRISK add   notes  varchar2(4000 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:risk_code TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJRISK') and column_name=upper('risk_code');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJRISK add   risk_code  varchar2(40 CHAR) DEFAULT 0 NOT NULL
';
  end if;
END;         
/

--METADATA NAME:risk_desc TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJRISK') and column_name=upper('risk_desc');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJRISK add   risk_desc  varchar2(4000 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:intg_type TYPE:FIELD TABLE_NAME:PROJWBS CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJWBS') and column_name=upper('intg_type');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJWBS add   intg_type  varchar2(100 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:status_reviewer TYPE:FIELD TABLE_NAME:PROJWBS CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJWBS') and column_name=upper('status_reviewer');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJWBS add   status_reviewer  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:parent_risk_type_id TYPE:FIELD TABLE_NAME:RISKTYPE CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('RISKTYPE') and column_name=upper('parent_risk_type_id');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE RISKTYPE add   parent_risk_type_id  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:rpt_area TYPE:FIELD TABLE_NAME:RPT CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('RPT') and column_name=upper('rpt_area');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE RPT add   rpt_area  varchar2(32 CHAR) DEFAULT ''Unknown'' NOT NULL
';
  end if;
END;         
/

--METADATA NAME:user_id TYPE:FIELD TABLE_NAME:RPT CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('RPT') and column_name=upper('user_id');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE RPT add   user_id  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:intg_type TYPE:FIELD TABLE_NAME:RSRC CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('RSRC') and column_name=upper('intg_type');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE RSRC add   intg_type  varchar2(100 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:location_id TYPE:FIELD TABLE_NAME:RSRC CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('RSRC') and column_name=upper('location_id');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE RSRC add   location_id  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:refrdel_project_bypass TYPE:FIELD TABLE_NAME:SPIDMAP CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('SPIDMAP') and column_name=upper('refrdel_project_bypass');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE SPIDMAP add   refrdel_project_bypass  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:location_id TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('TASK') and column_name=upper('location_id');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE TASK add   location_id  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:control_updates_flag TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('TASK') and column_name=upper('control_updates_flag');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE TASK add   control_updates_flag  varchar2(1 CHAR) DEFAULT ''N'' NULL
';
  end if;
END;         
/

--METADATA NAME:prior_ts_act_reg_qty TYPE:FIELD TABLE_NAME:TASKRSRC CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('TASKRSRC') and column_name=upper('prior_ts_act_reg_qty');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE TASKRSRC add   prior_ts_act_reg_qty  number(17,6) NULL
';
  end if;
END;         
/

--METADATA  TYPE:ADHOC_SQL
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select prof_id,156,case p.allow_flag when 'Y' then 'Y' else 'N' END, sysdate, sys_context('USERENV','CURRENT_SCHEMA') from profpriv p where priv_num=29  and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=156)
/

--METADATA NAME:prior_ts_act_ot_qty TYPE:FIELD TABLE_NAME:TASKRSRC CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('TASKRSRC') and column_name=upper('prior_ts_act_ot_qty');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE TASKRSRC add   prior_ts_act_ot_qty  number(17,6) NULL
';
  end if;
END;         
/

--METADATA NAME:cr_external_key TYPE:FIELD TABLE_NAME:TASKWKSP CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('TASKWKSP') and column_name=upper('cr_external_key');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE TASKWKSP add   cr_external_key  varchar2(4000 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:table_name TYPE:FIELD TABLE_NAME:UDFVALUE CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('UDFVALUE') and column_name=upper('table_name');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE UDFVALUE add   table_name  varchar2(30 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:pk2_id TYPE:FIELD TABLE_NAME:UPKLIST CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('UPKLIST') and column_name=upper('pk2_id');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE UPKLIST add   pk2_id  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:ui_view_pref_id TYPE:FIELD TABLE_NAME:USERS CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('USERS') and column_name=upper('ui_view_pref_id');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE USERS add   ui_view_pref_id  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:cr_external_key TYPE:FIELD TABLE_NAME:USERS CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('USERS') and column_name=upper('cr_external_key');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE USERS add   cr_external_key  varchar2(4000 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:cr_user_name TYPE:FIELD TABLE_NAME:USERS CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('USERS') and column_name=upper('cr_user_name');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE USERS add   cr_user_name  varchar2(255 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:failed_login_attempts_cnt TYPE:FIELD TABLE_NAME:USERS CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('USERS') and column_name=upper('failed_login_attempts_cnt');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE USERS add   failed_login_attempts_cnt  number(10) DEFAULT 0 NULL
';
  end if;
END;         
/

--METADATA NAME:userset_blob TYPE:FIELD TABLE_NAME:USERSET CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('USERSET') and column_name=upper('userset_blob');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE USERSET add   userset_blob  BLOB NULL
';
  end if;
END;         
/

--METADATA NAME:view_pref_value_blob TYPE:FIELD TABLE_NAME:VWPREFDATA CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('VWPREFDATA') and column_name=upper('view_pref_value_blob');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE VWPREFDATA add   view_pref_value_blob  BLOB NULL
';
  end if;
END;         
/

--METADATA NAME:fin_dates_id1 TYPE:FIELD TABLE_NAME:WBSRSRC_QTY CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('WBSRSRC_QTY') and column_name=upper('fin_dates_id1');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE WBSRSRC_QTY add   fin_dates_id1  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:fin_qty1 TYPE:FIELD TABLE_NAME:WBSRSRC_QTY CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('WBSRSRC_QTY') and column_name=upper('fin_qty1');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE WBSRSRC_QTY add   fin_qty1  number(17,6) NULL
';
  end if;
END;         
/

--METADATA NAME:fin_dates_id2 TYPE:FIELD TABLE_NAME:WBSRSRC_QTY CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('WBSRSRC_QTY') and column_name=upper('fin_dates_id2');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE WBSRSRC_QTY add   fin_dates_id2  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:fin_qty2 TYPE:FIELD TABLE_NAME:WBSRSRC_QTY CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('WBSRSRC_QTY') and column_name=upper('fin_qty2');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE WBSRSRC_QTY add   fin_qty2  number(17,6) NULL
';
  end if;
END;         
/

--METADATA NAME:cr_external_key TYPE:FIELD TABLE_NAME:WORKSPACE CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('WORKSPACE') and column_name=upper('cr_external_key');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE WORKSPACE add   cr_external_key  varchar2(4000 CHAR) NULL
';
  end if;
END;         
/

prompt Creating constraint fk_discussion_task on table DISCUSSION


--METADATA NAME:fk_discussion_task TYPE:CONSTRAINT TABLE_NAME:DISCUSSION CHANGE:CREATE
ALTER TABLE DISCUSSION
ADD CONSTRAINT fk_discussion_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_discussion_read_users on table DISCUSSION_READ


--METADATA NAME:fk_discussion_read_users TYPE:CONSTRAINT TABLE_NAME:DISCUSSION_READ CHANGE:CREATE
ALTER TABLE DISCUSSION_READ
ADD CONSTRAINT fk_discussion_read_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_discussion_read_discussion on table DISCUSSION_READ


--METADATA NAME:fk_discussion_read_discussion TYPE:CONSTRAINT TABLE_NAME:DISCUSSION_READ CHANGE:CREATE
ALTER TABLE DISCUSSION_READ
ADD CONSTRAINT fk_discussion_read_discussion FOREIGN KEY (discussion_id)
REFERENCES DISCUSSION (discussion_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_docreview_document on table DOCREVIEW


--METADATA NAME:fk_docreview_document TYPE:CONSTRAINT TABLE_NAME:DOCREVIEW CHANGE:CREATE
ALTER TABLE DOCREVIEW
ADD CONSTRAINT fk_docreview_document FOREIGN KEY (doc_id)
REFERENCES DOCUMENT (doc_id) 
/

prompt Creating constraint fk_docreview_users on table DOCREVIEW


--METADATA NAME:fk_docreview_users TYPE:CONSTRAINT TABLE_NAME:DOCREVIEW CHANGE:CREATE
ALTER TABLE DOCREVIEW
ADD CONSTRAINT fk_docreview_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_docreviewtask_docreview on table DOCREVIEWTASK


--METADATA NAME:fk_docreviewtask_docreview TYPE:CONSTRAINT TABLE_NAME:DOCREVIEWTASK CHANGE:CREATE
ALTER TABLE DOCREVIEWTASK
ADD CONSTRAINT fk_docreviewtask_docreview FOREIGN KEY (doc_review_id)
REFERENCES DOCREVIEW (doc_review_id) 
/

prompt Creating constraint fk_docreviewtask_users on table DOCREVIEWTASK


--METADATA NAME:fk_docreviewtask_users TYPE:CONSTRAINT TABLE_NAME:DOCREVIEWTASK CHANGE:CREATE
ALTER TABLE DOCREVIEWTASK
ADD CONSTRAINT fk_docreviewtask_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_filtprop_rpt on table FILTPROP


--METADATA NAME:fk_filtprop_rpt TYPE:CONSTRAINT TABLE_NAME:FILTPROP CHANGE:CREATE
ALTER TABLE FILTPROP
ADD CONSTRAINT fk_filtprop_rpt FOREIGN KEY (rpt_id)
REFERENCES RPT (rpt_id) 
/

prompt Creating constraint fk_pfoliouser_pfolio on table PFOLIOUSER


--METADATA NAME:fk_pfoliouser_pfolio TYPE:CONSTRAINT TABLE_NAME:PFOLIOUSER CHANGE:CREATE
ALTER TABLE PFOLIOUSER
ADD CONSTRAINT fk_pfoliouser_pfolio FOREIGN KEY (pfolio_id)
REFERENCES PFOLIO (pfolio_id) 
/

prompt Creating constraint fk_pfoliouser_users on table PFOLIOUSER


--METADATA NAME:fk_pfoliouser_users TYPE:CONSTRAINT TABLE_NAME:PFOLIOUSER CHANGE:CREATE
ALTER TABLE PFOLIOUSER
ADD CONSTRAINT fk_pfoliouser_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_rpt_users on table RPT


--METADATA NAME:fk_rpt_users TYPE:CONSTRAINT TABLE_NAME:RPT CHANGE:CREATE
ALTER TABLE RPT
ADD CONSTRAINT fk_rpt_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_sumprojcost_project on table SUMPROJCOST


--METADATA NAME:fk_sumprojcost_project TYPE:CONSTRAINT TABLE_NAME:SUMPROJCOST CHANGE:CREATE
ALTER TABLE SUMPROJCOST
ADD CONSTRAINT fk_sumprojcost_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_sumprojcost_projwbs on table SUMPROJCOST


--METADATA NAME:fk_sumprojcost_projwbs TYPE:CONSTRAINT TABLE_NAME:SUMPROJCOST CHANGE:CREATE
ALTER TABLE SUMPROJCOST
ADD CONSTRAINT fk_sumprojcost_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_sumprojcost_costtype on table SUMPROJCOST


--METADATA NAME:fk_sumprojcost_costtype TYPE:CONSTRAINT TABLE_NAME:SUMPROJCOST CHANGE:CREATE
ALTER TABLE SUMPROJCOST
ADD CONSTRAINT fk_sumprojcost_costtype FOREIGN KEY (cost_type_id)
REFERENCES COSTTYPE (cost_type_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_sumtask_project on table SUMTASK


--METADATA NAME:fk_sumtask_project TYPE:CONSTRAINT TABLE_NAME:SUMTASK CHANGE:CREATE
ALTER TABLE SUMTASK
ADD CONSTRAINT fk_sumtask_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_sumtask_projwbs on table SUMTASK


--METADATA NAME:fk_sumtask_projwbs TYPE:CONSTRAINT TABLE_NAME:SUMTASK CHANGE:CREATE
ALTER TABLE SUMTASK
ADD CONSTRAINT fk_sumtask_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_sumtaskspread_project on table SUMTASKSPREAD


--METADATA NAME:fk_sumtaskspread_project TYPE:CONSTRAINT TABLE_NAME:SUMTASKSPREAD CHANGE:CREATE
ALTER TABLE SUMTASKSPREAD
ADD CONSTRAINT fk_sumtaskspread_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_sumtaskspread_projwbs on table SUMTASKSPREAD


--METADATA NAME:fk_sumtaskspread_projwbs TYPE:CONSTRAINT TABLE_NAME:SUMTASKSPREAD CHANGE:CREATE
ALTER TABLE SUMTASKSPREAD
ADD CONSTRAINT fk_sumtaskspread_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_sumtrsrc_project on table SUMTRSRC


--METADATA NAME:fk_sumtrsrc_project TYPE:CONSTRAINT TABLE_NAME:SUMTRSRC CHANGE:CREATE
ALTER TABLE SUMTRSRC
ADD CONSTRAINT fk_sumtrsrc_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_sumtrsrc_projwbs on table SUMTRSRC


--METADATA NAME:fk_sumtrsrc_projwbs TYPE:CONSTRAINT TABLE_NAME:SUMTRSRC CHANGE:CREATE
ALTER TABLE SUMTRSRC
ADD CONSTRAINT fk_sumtrsrc_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_risk_riskid on table TASKRISK


--METADATA NAME:fk_risk_riskid TYPE:CONSTRAINT TABLE_NAME:TASKRISK CHANGE:CREATE
ALTER TABLE TASKRISK
ADD CONSTRAINT fk_risk_riskid FOREIGN KEY (risk_id)
REFERENCES PROJRISK (risk_id) 
/

prompt Creating constraint fk_risk_task on table TASKRISK


--METADATA NAME:fk_risk_task TYPE:CONSTRAINT TABLE_NAME:TASKRISK CHANGE:CREATE
ALTER TABLE TASKRISK
ADD CONSTRAINT fk_risk_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
/

prompt Creating constraint fk_taskrisk_project on table TASKRISK


--METADATA NAME:fk_taskrisk_project TYPE:CONSTRAINT TABLE_NAME:TASKRISK CHANGE:CREATE
ALTER TABLE TASKRISK
ADD CONSTRAINT fk_taskrisk_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_tsdelegate_users on table TSDELEGATE


--METADATA NAME:fk_tsdelegate_users TYPE:CONSTRAINT TABLE_NAME:TSDELEGATE CHANGE:CREATE
ALTER TABLE TSDELEGATE
ADD CONSTRAINT fk_tsdelegate_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_tsdelegate_users2 on table TSDELEGATE


--METADATA NAME:fk_tsdelegate_users2 TYPE:CONSTRAINT TABLE_NAME:TSDELEGATE CHANGE:CREATE
ALTER TABLE TSDELEGATE
ADD CONSTRAINT fk_tsdelegate_users2 FOREIGN KEY (ts_delegate_user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_tsdelegate_project on table TSDELEGATE


--METADATA NAME:fk_tsdelegate_project TYPE:CONSTRAINT TABLE_NAME:TSDELEGATE CHANGE:CREATE
ALTER TABLE TSDELEGATE
ADD CONSTRAINT fk_tsdelegate_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_useropen_users on table USEROPEN


--METADATA NAME:fk_useropen_users TYPE:CONSTRAINT TABLE_NAME:USEROPEN CHANGE:CREATE
ALTER TABLE USEROPEN
ADD CONSTRAINT fk_useropen_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_user_acpt_consent_users on table USER_ACCEPTANCE_CONSENT


--METADATA NAME:fk_user_acpt_consent_users TYPE:CONSTRAINT TABLE_NAME:USER_ACCEPTANCE_CONSENT CHANGE:CREATE
ALTER TABLE USER_ACCEPTANCE_CONSENT
ADD CONSTRAINT fk_user_acpt_consent_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_usropnval_useropen on table USROPNVAL


--METADATA NAME:fk_usropnval_useropen TYPE:CONSTRAINT TABLE_NAME:USROPNVAL CHANGE:CREATE
ALTER TABLE USROPNVAL
ADD CONSTRAINT fk_usropnval_useropen FOREIGN KEY (user_open_id)
REFERENCES USEROPEN (user_open_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_vwprefdash_dashboard on table VWPREFDASH


--METADATA NAME:fk_vwprefdash_dashboard TYPE:CONSTRAINT TABLE_NAME:VWPREFDASH CHANGE:CREATE
ALTER TABLE VWPREFDASH
ADD CONSTRAINT fk_vwprefdash_dashboard FOREIGN KEY (dashboard_id)
REFERENCES DASHBOARD (dashboard_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_vwprefdash_viewpref on table VWPREFDASH


--METADATA NAME:fk_vwprefdash_viewpref TYPE:CONSTRAINT TABLE_NAME:VWPREFDASH CHANGE:CREATE
ALTER TABLE VWPREFDASH
ADD CONSTRAINT fk_vwprefdash_viewpref FOREIGN KEY (view_pref_id)
REFERENCES VIEWPREF (view_pref_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_wbsrsrc_qty_findates1 on table WBSRSRC_QTY


--METADATA NAME:fk_wbsrsrc_qty_findates1 TYPE:CONSTRAINT TABLE_NAME:WBSRSRC_QTY CHANGE:CREATE
ALTER TABLE WBSRSRC_QTY
ADD CONSTRAINT fk_wbsrsrc_qty_findates1 FOREIGN KEY (fin_dates_id1)
REFERENCES FINDATES (fin_dates_id) 
/

prompt Creating constraint fk_wbsrsrc_qty_findates2 on table WBSRSRC_QTY


--METADATA NAME:fk_wbsrsrc_qty_findates2 TYPE:CONSTRAINT TABLE_NAME:WBSRSRC_QTY CHANGE:CREATE
ALTER TABLE WBSRSRC_QTY
ADD CONSTRAINT fk_wbsrsrc_qty_findates2 FOREIGN KEY (fin_dates_id2)
REFERENCES FINDATES (fin_dates_id) 
/

prompt Creating constraint fk_wkfltmpl_tmplcatg on table WKFLTMPL


--METADATA NAME:fk_wkfltmpl_tmplcatg TYPE:CONSTRAINT TABLE_NAME:WKFLTMPL CHANGE:CREATE
ALTER TABLE WKFLTMPL
ADD CONSTRAINT fk_wkfltmpl_tmplcatg FOREIGN KEY (tmplcatg_catg_id)
REFERENCES TMPLCATG (tmplcatg_catg_id) 
/

--METADATA NAME:chng_by_name TYPE:FIELD TABLE_NAME:BUDGCHNG CHANGE:ALTER
ALTER TABLE BUDGCHNG modify chng_by_name varchar2(255 CHAR)
/

--METADATA NAME:clndr_name TYPE:FIELD TABLE_NAME:CALENDAR CHANGE:ALTER
ALTER TABLE CALENDAR modify clndr_name varchar2(255 CHAR)
/

--METADATA NAME:author_name TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER
ALTER TABLE DOCUMENT modify author_name varchar2(255 CHAR)
/

--METADATA NAME:job_name TYPE:FIELD TABLE_NAME:JOBSVC CHANGE:ALTER
ALTER TABLE JOBSVC modify job_name varchar2(255 CHAR)
/

--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:NOTE CHANGE:ALTER
ALTER TABLE NOTE modify user_name varchar2(255 CHAR)
/

--METADATA NAME:proj_catg_type TYPE:FIELD TABLE_NAME:PCATTYPE CHANGE:ALTER
ALTER TABLE PCATTYPE modify proj_catg_type varchar2(60 CHAR)
/

--METADATA NAME:proj_catg_short_name TYPE:FIELD TABLE_NAME:PCATVAL CHANGE:ALTER
ALTER TABLE PCATVAL modify proj_catg_short_name varchar2(60 CHAR)
/

--METADATA NAME:prm_user_name TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:ALTER
ALTER TABLE PRMAUDIT modify prm_user_name varchar2(255 CHAR)
/

--METADATA NAME:netaddress TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:ALTER
ALTER TABLE PRMAUDIT modify netaddress varchar2(64 CHAR)
/

--METADATA NAME:enqueue_user TYPE:FIELD TABLE_NAME:PRMQUEUE CHANGE:ALTER
ALTER TABLE PRMQUEUE modify enqueue_user varchar2(255 CHAR)
/

--METADATA NAME:sender_name TYPE:FIELD TABLE_NAME:PRMQUEUE CHANGE:ALTER
ALTER TABLE PRMQUEUE modify sender_name varchar2(255 CHAR)
/

--METADATA NAME:dequeue_user TYPE:FIELD TABLE_NAME:PRMQUEUE CHANGE:ALTER
ALTER TABLE PRMQUEUE modify dequeue_user varchar2(255 CHAR)
/

--METADATA NAME:add_by_name TYPE:FIELD TABLE_NAME:PROJECT CHANGE:ALTER
ALTER TABLE PROJECT modify add_by_name varchar2(255 CHAR)
/

--METADATA NAME:add_by_name TYPE:FIELD TABLE_NAME:PROJISSU CHANGE:ALTER
ALTER TABLE PROJISSU modify add_by_name varchar2(255 CHAR)
/
 
--METADATA NAME:add_date TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:ALTER
ALTER TABLE PROJRISK modify add_date NULL
/

--METADATA NAME:risk_name TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:ALTER
ALTER TABLE PROJRISK modify risk_name varchar2(200 CHAR)
/
 
--METADATA NAME:est_wt TYPE:FIELD TABLE_NAME:PROJWBS CHANGE:ALTER
ALTER TABLE PROJWBS modify est_wt NULL
/

--METADATA NAME:private_db_user_name TYPE:FIELD TABLE_NAME:PUBUSER CHANGE:ALTER
ALTER TABLE PUBUSER modify private_db_user_name varchar2(255 CHAR)
/

--METADATA NAME:rsrc_short_name TYPE:FIELD TABLE_NAME:RSRC CHANGE:ALTER
ALTER TABLE RSRC modify rsrc_short_name varchar2(255 CHAR)
/

--METADATA NAME:rsrc_name TYPE:FIELD TABLE_NAME:RSRC CHANGE:ALTER
ALTER TABLE RSRC modify rsrc_name varchar2(255 CHAR)
/

--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:SPIDMAP CHANGE:ALTER
ALTER TABLE SPIDMAP modify user_name varchar2(255 CHAR)
/
 
--METADATA NAME:est_wt TYPE:FIELD TABLE_NAME:TASK CHANGE:ALTER
ALTER TABLE TASK modify est_wt NULL
/

--METADATA NAME:review_type TYPE:FIELD TABLE_NAME:TASK CHANGE:ALTER
ALTER TABLE TASK modify review_type DEFAULT 'RV_OK'
/

--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:UEVNTREG CHANGE:ALTER
ALTER TABLE UEVNTREG modify user_name varchar2(255 CHAR)
/

--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:USERS CHANGE:ALTER
ALTER TABLE USERS modify user_name varchar2(255 CHAR)
/

--METADATA NAME:actual_name TYPE:FIELD TABLE_NAME:USERS CHANGE:ALTER
ALTER TABLE USERS modify actual_name varchar2(255 CHAR)
/

--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:USESSAUD CHANGE:ALTER
ALTER TABLE USESSAUD modify user_name varchar2(255 CHAR)
/

--METADATA NAME:os_user_name TYPE:FIELD TABLE_NAME:USESSAUD CHANGE:ALTER
ALTER TABLE USESSAUD modify os_user_name varchar2(255 CHAR)
/

--METADATA NAME:os_user_name TYPE:FIELD TABLE_NAME:USESSION CHANGE:ALTER
ALTER TABLE USESSION modify os_user_name varchar2(255 CHAR)
/

prompt Creating index ndx_discussion_1 on table DISCUSSION

--METADATA NAME:ndx_discussion_1 TYPE:INDEX TABLE_NAME:DISCUSSION CHANGE:CREATE
CREATE INDEX ndx_discussion_1
ON DISCUSSION (task_id,discussion_date)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_discussion_2 on table DISCUSSION

--METADATA NAME:ndx_discussion_2 TYPE:INDEX TABLE_NAME:DISCUSSION CHANGE:CREATE
CREATE INDEX ndx_discussion_2
ON DISCUSSION (user_id,discussion_date)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_discussion_dsi on table DISCUSSION

--METADATA NAME:ndx_discussion_dsi TYPE:INDEX TABLE_NAME:DISCUSSION CHANGE:CREATE
CREATE INDEX ndx_discussion_dsi
ON DISCUSSION (delete_session_id,delete_date)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_discussion_read_dsi on table DISCUSSION_READ

--METADATA NAME:ndx_discussion_read_dsi TYPE:INDEX TABLE_NAME:DISCUSSION_READ CHANGE:CREATE
CREATE INDEX ndx_discussion_read_dsi
ON DISCUSSION_READ (delete_session_id,delete_date)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_docreview_document on table DOCREVIEW

--METADATA NAME:ndx_docreview_document TYPE:INDEX TABLE_NAME:DOCREVIEW CHANGE:CREATE
CREATE INDEX ndx_docreview_document
ON DOCREVIEW (doc_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_docreview_users on table DOCREVIEW

--METADATA NAME:ndx_docreview_users TYPE:INDEX TABLE_NAME:DOCREVIEW CHANGE:CREATE
CREATE INDEX ndx_docreview_users
ON DOCREVIEW (user_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_docreviewtask_docreview on table DOCREVIEWTASK

--METADATA NAME:ndx_docreviewtask_docreview TYPE:INDEX TABLE_NAME:DOCREVIEWTASK CHANGE:CREATE
CREATE INDEX ndx_docreviewtask_docreview
ON DOCREVIEWTASK (doc_review_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_docreviewtask_users on table DOCREVIEWTASK

--METADATA NAME:ndx_docreviewtask_users TYPE:INDEX TABLE_NAME:DOCREVIEWTASK CHANGE:CREATE
CREATE INDEX ndx_docreviewtask_users
ON DOCREVIEWTASK (user_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_document_cr_external_key on table DOCUMENT

--METADATA NAME:ndx_document_cr_external_key TYPE:INDEX TABLE_NAME:DOCUMENT CHANGE:CREATE
CREATE INDEX ndx_document_cr_external_key
ON DOCUMENT (cr_external_doc_key)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_findates_1 on table FINDATES

--METADATA NAME:ndx_findates_1 TYPE:INDEX TABLE_NAME:FINDATES CHANGE:CREATE
CREATE INDEX ndx_findates_1
ON FINDATES (start_date,end_date)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_imagedata_image_name on table IMAGEDATA

--METADATA NAME:ndx_imagedata_image_name TYPE:INDEX TABLE_NAME:IMAGEDATA CHANGE:CREATE
CREATE UNIQUE INDEX ndx_imagedata_image_name
ON IMAGEDATA (image_name)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_project_calendar on table PROJECT

--METADATA NAME:ndx_project_calendar TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE INDEX ndx_project_calendar
ON PROJECT (clndr_id,delete_session_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_project_last_fin_dates on table PROJECT

--METADATA NAME:ndx_project_last_fin_dates TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE INDEX ndx_project_last_fin_dates
ON PROJECT (last_fin_dates_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_project_matrix on table PROJECT

--METADATA NAME:ndx_project_matrix TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE INDEX ndx_project_matrix
ON PROJECT (matrix_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrc_unit on table RSRC

--METADATA NAME:ndx_rsrc_unit TYPE:INDEX TABLE_NAME:RSRC CHANGE:CREATE
CREATE INDEX ndx_rsrc_unit
ON RSRC (unit_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrc_curr on table RSRC

--METADATA NAME:ndx_rsrc_curr TYPE:INDEX TABLE_NAME:RSRC CHANGE:CREATE
CREATE INDEX ndx_rsrc_curr
ON RSRC (curr_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrchour_project on table RSRCHOUR

--METADATA NAME:ndx_rsrchour_project TYPE:INDEX TABLE_NAME:RSRCHOUR CHANGE:CREATE
CREATE INDEX ndx_rsrchour_project
ON RSRCHOUR (proj_id,ts_id,task_ts_flag,rsrc_id,delete_session_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrchour_status_code on table RSRCHOUR

--METADATA NAME:ndx_rsrchour_status_code TYPE:INDEX TABLE_NAME:RSRCHOUR CHANGE:CREATE
CREATE INDEX ndx_rsrchour_status_code
ON RSRCHOUR (status_code,proj_id,ts_id,rsrc_id,delete_session_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrchour_ts_rsrc on table RSRCHOUR

--METADATA NAME:ndx_rsrchour_ts_rsrc TYPE:INDEX TABLE_NAME:RSRCHOUR CHANGE:CREATE
CREATE INDEX ndx_rsrchour_ts_rsrc
ON RSRCHOUR (ts_id,rsrc_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sumprojcost_wbs on table SUMPROJCOST

--METADATA NAME:ndx_sumprojcost_wbs TYPE:INDEX TABLE_NAME:SUMPROJCOST CHANGE:CREATE
CREATE INDEX ndx_sumprojcost_wbs
ON SUMPROJCOST (wbs_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sumprojcost_cost_type on table SUMPROJCOST

--METADATA NAME:ndx_sumprojcost_cost_type TYPE:INDEX TABLE_NAME:SUMPROJCOST CHANGE:CREATE
CREATE INDEX ndx_sumprojcost_cost_type
ON SUMPROJCOST (cost_type_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sumprojcost_proj on table SUMPROJCOST

--METADATA NAME:ndx_sumprojcost_proj TYPE:INDEX TABLE_NAME:SUMPROJCOST CHANGE:CREATE
CREATE INDEX ndx_sumprojcost_proj
ON SUMPROJCOST (proj_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sumtask_proj on table SUMTASK

--METADATA NAME:ndx_sumtask_proj TYPE:INDEX TABLE_NAME:SUMTASK CHANGE:CREATE
CREATE INDEX ndx_sumtask_proj
ON SUMTASK (proj_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sumtask_wbs on table SUMTASK

--METADATA NAME:ndx_sumtask_wbs TYPE:INDEX TABLE_NAME:SUMTASK CHANGE:CREATE
CREATE INDEX ndx_sumtask_wbs
ON SUMTASK (wbs_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sumtaskspread_proj on table SUMTASKSPREAD

--METADATA NAME:ndx_sumtaskspread_proj TYPE:INDEX TABLE_NAME:SUMTASKSPREAD CHANGE:CREATE
CREATE INDEX ndx_sumtaskspread_proj
ON SUMTASKSPREAD (proj_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sumtaskspread_wbs on table SUMTASKSPREAD

--METADATA NAME:ndx_sumtaskspread_wbs TYPE:INDEX TABLE_NAME:SUMTASKSPREAD CHANGE:CREATE
CREATE INDEX ndx_sumtaskspread_wbs
ON SUMTASKSPREAD (wbs_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sumtrsrc_project on table SUMTRSRC

--METADATA NAME:ndx_sumtrsrc_project TYPE:INDEX TABLE_NAME:SUMTRSRC CHANGE:CREATE
CREATE INDEX ndx_sumtrsrc_project
ON SUMTRSRC (proj_id,spread_type)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sumtrsrc_projwbs on table SUMTRSRC

--METADATA NAME:ndx_sumtrsrc_projwbs TYPE:INDEX TABLE_NAME:SUMTRSRC CHANGE:CREATE
CREATE INDEX ndx_sumtrsrc_projwbs
ON SUMTRSRC (wbs_id,spread_type)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sumtrsrc_rsrcrole on table SUMTRSRC

--METADATA NAME:ndx_sumtrsrc_rsrcrole TYPE:INDEX TABLE_NAME:SUMTRSRC CHANGE:CREATE
CREATE INDEX ndx_sumtrsrc_rsrcrole
ON SUMTRSRC (rsrc_id,role_id,spread_type)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sumtrsrc_projrsrcrole_id on table SUMTRSRC

--METADATA NAME:ndx_sumtrsrc_projrsrcrole_id TYPE:INDEX TABLE_NAME:SUMTRSRC CHANGE:CREATE
CREATE INDEX ndx_sumtrsrc_projrsrcrole_id
ON SUMTRSRC (proj_id,rsrc_id,role_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_task_proj_rsrc on table TASK

--METADATA NAME:ndx_task_proj_rsrc TYPE:INDEX TABLE_NAME:TASK CHANGE:CREATE
CREATE INDEX ndx_task_proj_rsrc
ON TASK (proj_id,rsrc_id,delete_session_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 500k next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_fn_task_code on table TASK

--METADATA NAME:ndx_fn_task_code TYPE:INDEX TABLE_NAME:TASK CHANGE:CREATE
CREATE INDEX ndx_fn_task_code
ON TASK (task_code)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskactv_proj_actv_code on table TASKACTV

--METADATA NAME:ndx_taskactv_proj_actv_code TYPE:INDEX TABLE_NAME:TASKACTV CHANGE:CREATE
CREATE INDEX ndx_taskactv_proj_actv_code
ON TASKACTV (proj_id,actv_code_id,delete_session_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskactv_proj_task_actv on table TASKACTV

--METADATA NAME:ndx_taskactv_proj_task_actv TYPE:INDEX TABLE_NAME:TASKACTV CHANGE:CREATE
CREATE INDEX ndx_taskactv_proj_task_actv
ON TASKACTV (proj_id,task_id,actv_code_type_id,actv_code_id,delete_session_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskpred_pred_proj on table TASKPRED

--METADATA NAME:ndx_taskpred_pred_proj TYPE:INDEX TABLE_NAME:TASKPRED CHANGE:CREATE
CREATE INDEX ndx_taskpred_pred_proj
ON TASKPRED (pred_proj_id,proj_id,delete_session_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskpred_perfc1 on table TASKPRED

--METADATA NAME:ndx_taskpred_perfc1 TYPE:INDEX TABLE_NAME:TASKPRED CHANGE:CREATE
CREATE INDEX ndx_taskpred_perfc1
ON TASKPRED (proj_id, pred_proj_id, task_pred_id, task_id, pred_task_id, pred_type, lag_hr_cnt, delete_session_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskpred_perfc2 on table TASKPRED

--METADATA NAME:ndx_taskpred_perfc2 TYPE:INDEX TABLE_NAME:TASKPRED CHANGE:CREATE
CREATE INDEX ndx_taskpred_perfc2
ON TASKPRED (pred_proj_id,proj_id, task_id, pred_task_id, task_pred_id, pred_type, lag_hr_cnt, delete_session_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskrisk_risk on table TASKRISK

--METADATA NAME:ndx_taskrisk_risk TYPE:INDEX TABLE_NAME:TASKRISK CHANGE:CREATE
CREATE INDEX ndx_taskrisk_risk
ON TASKRISK (risk_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskrisk_proj on table TASKRISK

--METADATA NAME:ndx_taskrisk_proj TYPE:INDEX TABLE_NAME:TASKRISK CHANGE:CREATE
CREATE INDEX ndx_taskrisk_proj
ON TASKRISK (proj_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskrisk_task on table TASKRISK

--METADATA NAME:ndx_taskrisk_task TYPE:INDEX TABLE_NAME:TASKRISK CHANGE:CREATE
CREATE INDEX ndx_taskrisk_task
ON TASKRISK (task_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskrsrc_proj_rsrc on table TASKRSRC

--METADATA NAME:ndx_taskrsrc_proj_rsrc TYPE:INDEX TABLE_NAME:TASKRSRC CHANGE:CREATE
CREATE INDEX ndx_taskrsrc_proj_rsrc
ON TASKRSRC (proj_id,rsrc_id, delete_session_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskrsrc_proj_role on table TASKRSRC

--METADATA NAME:ndx_taskrsrc_proj_role TYPE:INDEX TABLE_NAME:TASKRSRC CHANGE:CREATE
CREATE INDEX ndx_taskrsrc_proj_role
ON TASKRSRC (proj_id,role_id, delete_session_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskrsrc_proj_acct on table TASKRSRC

--METADATA NAME:ndx_taskrsrc_proj_acct TYPE:INDEX TABLE_NAME:TASKRSRC CHANGE:CREATE
CREATE INDEX ndx_taskrsrc_proj_acct
ON TASKRSRC (proj_id,acct_id, delete_session_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tasksum_m1 on table TASKSUM

--METADATA NAME:ndx_tasksum_m1 TYPE:INDEX TABLE_NAME:TASKSUM CHANGE:CREATE
CREATE INDEX ndx_tasksum_m1
ON TASKSUM (task_sum_id, wbs_id, proj_id, complete_cnt, active_cnt, notstarted_cnt, base_complete_cnt, base_active_cnt, base_notstarted_cnt, act_drtn_hr_cnt, act_equip_qty, act_work_qty, total_drtn_hr_cnt, base_drtn_hr_cnt, base_work_qty, base_equip_qty, remain_drtn_hr_cnt, remain_work_qty, remain_equip_qty, total_float_hr_cnt, act_expense_cost, act_work_cost, act_equip_cost, base_expense_cost, base_work_cost, base_equip_cost, delete_session_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tasksum_m2 on table TASKSUM

--METADATA NAME:ndx_tasksum_m2 TYPE:INDEX TABLE_NAME:TASKSUM CHANGE:CREATE
CREATE INDEX ndx_tasksum_m2
ON TASKSUM (task_sum_id, wbs_id, proj_id, bcwp, bcws, remain_expense_cost, remain_work_cost, remain_equip_cost, perfm_work_qty, sched_work_qty, act_end_date, act_start_date, base_end_date, base_start_date, reend_date, restart_date, etc_work_qty, etc, act_this_per_work_cost, act_this_per_work_qty, act_this_per_equip_cost, act_this_per_equip_qty, base_mat_cost, act_mat_cost, remain_mat_cost, act_this_per_mat_cost, delete_session_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tasksumfin_1 on table TASKSUMFIN

--METADATA NAME:ndx_tasksumfin_1 TYPE:INDEX TABLE_NAME:TASKSUMFIN CHANGE:CREATE
CREATE INDEX ndx_tasksumfin_1
ON TASKSUMFIN (proj_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tasksumfin_projwbs on table TASKSUMFIN

--METADATA NAME:ndx_tasksumfin_projwbs TYPE:INDEX TABLE_NAME:TASKSUMFIN CHANGE:CREATE
CREATE INDEX ndx_tasksumfin_projwbs
ON TASKSUMFIN (wbs_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tasksumfin_findates on table TASKSUMFIN

--METADATA NAME:ndx_tasksumfin_findates TYPE:INDEX TABLE_NAME:TASKSUMFIN CHANGE:CREATE
CREATE INDEX ndx_tasksumfin_findates
ON TASKSUMFIN (fin_dates_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tasksumfin_tasksum on table TASKSUMFIN

--METADATA NAME:ndx_tasksumfin_tasksum TYPE:INDEX TABLE_NAME:TASKSUMFIN CHANGE:CREATE
CREATE INDEX ndx_tasksumfin_tasksum
ON TASKSUMFIN (task_sum_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tasksumfin_dsi on table TASKSUMFIN

--METADATA NAME:ndx_tasksumfin_dsi TYPE:INDEX TABLE_NAME:TASKSUMFIN CHANGE:CREATE
CREATE INDEX ndx_tasksumfin_dsi
ON TASKSUMFIN (delete_session_id,delete_date)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tasksumfin_upd on table TASKSUMFIN

--METADATA NAME:ndx_tasksumfin_upd TYPE:INDEX TABLE_NAME:TASKSUMFIN CHANGE:CREATE
CREATE INDEX ndx_tasksumfin_upd
ON TASKSUMFIN (update_date,delete_session_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tmplcatg_dsi on table TMPLCATG

--METADATA NAME:ndx_tmplcatg_dsi TYPE:INDEX TABLE_NAME:TMPLCATG CHANGE:CREATE
CREATE INDEX ndx_tmplcatg_dsi
ON TMPLCATG (delete_session_id,delete_date)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trsrcsum_role_dialog on table TRSRCSUM

--METADATA NAME:ndx_trsrcsum_role_dialog TYPE:INDEX TABLE_NAME:TRSRCSUM CHANGE:CREATE
CREATE INDEX ndx_trsrcsum_role_dialog
ON TRSRCSUM (proj_id,taskrsrc_sum_id,rsrc_id,role_id,skill_level,overalloc_date,delete_session_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trsrcsumfn_1 on table TRSRCSUMFN

--METADATA NAME:ndx_trsrcsumfn_1 TYPE:INDEX TABLE_NAME:TRSRCSUMFN CHANGE:CREATE
CREATE INDEX ndx_trsrcsumfn_1
ON TRSRCSUMFN (fin_dates_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 80K next 80K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trsrcsumfn_project on table TRSRCSUMFN

--METADATA NAME:ndx_trsrcsumfn_project TYPE:INDEX TABLE_NAME:TRSRCSUMFN CHANGE:CREATE
CREATE INDEX ndx_trsrcsumfn_project
ON TRSRCSUMFN (proj_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 80K next 80K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trsrcsumfn_roles on table TRSRCSUMFN

--METADATA NAME:ndx_trsrcsumfn_roles TYPE:INDEX TABLE_NAME:TRSRCSUMFN CHANGE:CREATE
CREATE INDEX ndx_trsrcsumfn_roles
ON TRSRCSUMFN (role_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trsrcsumfn_rsrc on table TRSRCSUMFN

--METADATA NAME:ndx_trsrcsumfn_rsrc TYPE:INDEX TABLE_NAME:TRSRCSUMFN CHANGE:CREATE
CREATE INDEX ndx_trsrcsumfn_rsrc
ON TRSRCSUMFN (rsrc_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trsrcsumfn_trsrcsum on table TRSRCSUMFN

--METADATA NAME:ndx_trsrcsumfn_trsrcsum TYPE:INDEX TABLE_NAME:TRSRCSUMFN CHANGE:CREATE
CREATE INDEX ndx_trsrcsumfn_trsrcsum
ON TRSRCSUMFN (taskrsrc_sum_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trsrcsumfn_dsi on table TRSRCSUMFN

--METADATA NAME:ndx_trsrcsumfn_dsi TYPE:INDEX TABLE_NAME:TRSRCSUMFN CHANGE:CREATE
CREATE INDEX ndx_trsrcsumfn_dsi
ON TRSRCSUMFN (delete_session_id,delete_date)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trsrcsumfn_upd on table TRSRCSUMFN

--METADATA NAME:ndx_trsrcsumfn_upd TYPE:INDEX TABLE_NAME:TRSRCSUMFN CHANGE:CREATE
CREATE INDEX ndx_trsrcsumfn_upd
ON TRSRCSUMFN (update_date,delete_session_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tsaudit_audit_date on table TSAUDIT

--METADATA NAME:ndx_tsaudit_audit_date TYPE:INDEX TABLE_NAME:TSAUDIT CHANGE:CREATE
CREATE INDEX ndx_tsaudit_audit_date
ON TSAUDIT (audit_date)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 80K next 80K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tsdelegate_1 on table TSDELEGATE

--METADATA NAME:ndx_tsdelegate_1 TYPE:INDEX TABLE_NAME:TSDELEGATE CHANGE:CREATE
CREATE INDEX ndx_tsdelegate_1
ON TSDELEGATE (proj_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tsdelegate_users1 on table TSDELEGATE

--METADATA NAME:ndx_tsdelegate_users1 TYPE:INDEX TABLE_NAME:TSDELEGATE CHANGE:CREATE
CREATE INDEX ndx_tsdelegate_users1
ON TSDELEGATE (user_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tsdelegate_users2 on table TSDELEGATE

--METADATA NAME:ndx_tsdelegate_users2 TYPE:INDEX TABLE_NAME:TSDELEGATE CHANGE:CREATE
CREATE INDEX ndx_tsdelegate_users2
ON TSDELEGATE (ts_delegate_user_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_useropen_users on table USEROPEN

--METADATA NAME:ndx_useropen_users TYPE:INDEX TABLE_NAME:USEROPEN CHANGE:CREATE
CREATE UNIQUE INDEX ndx_useropen_users
ON USEROPEN (user_id,user_open_name,delete_session_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_useropen_dsi on table USEROPEN

--METADATA NAME:ndx_useropen_dsi TYPE:INDEX TABLE_NAME:USEROPEN CHANGE:CREATE
CREATE INDEX ndx_useropen_dsi
ON USEROPEN (delete_session_id,delete_date)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_useropen_upd on table USEROPEN

--METADATA NAME:ndx_useropen_upd TYPE:INDEX TABLE_NAME:USEROPEN CHANGE:CREATE
CREATE INDEX ndx_useropen_upd
ON USEROPEN (update_date,delete_session_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_users_curr on table USERS

--METADATA NAME:ndx_users_curr TYPE:INDEX TABLE_NAME:USERS CHANGE:CREATE
CREATE INDEX ndx_users_curr
ON USERS (curr_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_userset_user on table USERSET

--METADATA NAME:ndx_userset_user TYPE:INDEX TABLE_NAME:USERSET CHANGE:CREATE
CREATE INDEX ndx_userset_user
ON USERSET (user_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_usropnval_user_open_id on table USROPNVAL

--METADATA NAME:ndx_usropnval_user_open_id TYPE:INDEX TABLE_NAME:USROPNVAL CHANGE:CREATE
CREATE INDEX ndx_usropnval_user_open_id
ON USROPNVAL (user_open_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_usropnval_dsi on table USROPNVAL

--METADATA NAME:ndx_usropnval_dsi TYPE:INDEX TABLE_NAME:USROPNVAL CHANGE:CREATE
CREATE INDEX ndx_usropnval_dsi
ON USROPNVAL (delete_session_id,delete_date)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_usropnval_upd on table USROPNVAL

--METADATA NAME:ndx_usropnval_upd TYPE:INDEX TABLE_NAME:USROPNVAL CHANGE:CREATE
CREATE INDEX ndx_usropnval_upd
ON USROPNVAL (update_date,delete_session_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_vwprefdash_viewpref on table VWPREFDASH

--METADATA NAME:ndx_vwprefdash_viewpref TYPE:INDEX TABLE_NAME:VWPREFDASH CHANGE:CREATE
CREATE INDEX ndx_vwprefdash_viewpref
ON VWPREFDASH (view_pref_id,dashboard_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_vwprefdash_dsi on table VWPREFDASH

--METADATA NAME:ndx_vwprefdash_dsi TYPE:INDEX TABLE_NAME:VWPREFDASH CHANGE:CREATE
CREATE INDEX ndx_vwprefdash_dsi
ON VWPREFDASH (delete_session_id,delete_date)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_vwprefdash_upd on table VWPREFDASH

--METADATA NAME:ndx_vwprefdash_upd TYPE:INDEX TABLE_NAME:VWPREFDASH CHANGE:CREATE
CREATE INDEX ndx_vwprefdash_upd
ON VWPREFDASH (update_date,delete_session_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wbsrsrc_role on table WBSRSRC

--METADATA NAME:ndx_wbsrsrc_role TYPE:INDEX TABLE_NAME:WBSRSRC CHANGE:CREATE
CREATE INDEX ndx_wbsrsrc_role
ON WBSRSRC (role_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wbsrsrc_qty_fin_dates_id2 on table WBSRSRC_QTY

--METADATA NAME:ndx_wbsrsrc_qty_fin_dates_id2 TYPE:INDEX TABLE_NAME:WBSRSRC_QTY CHANGE:CREATE
CREATE INDEX ndx_wbsrsrc_qty_fin_dates_id2
ON WBSRSRC_QTY (fin_dates_id2)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wbsrsrc_qty_fin_dates_id1 on table WBSRSRC_QTY

--METADATA NAME:ndx_wbsrsrc_qty_fin_dates_id1 TYPE:INDEX TABLE_NAME:WBSRSRC_QTY CHANGE:CREATE
CREATE INDEX ndx_wbsrsrc_qty_fin_dates_id1
ON WBSRSRC_QTY (fin_dates_id1)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wkfltmpl_tmplcatg on table WKFLTMPL

--METADATA NAME:ndx_wkfltmpl_tmplcatg TYPE:INDEX TABLE_NAME:WKFLTMPL CHANGE:CREATE
CREATE INDEX ndx_wkfltmpl_tmplcatg
ON WKFLTMPL (tmplcatg_catg_id,delete_session_id)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wkfltmpl_dsi on table WKFLTMPL

--METADATA NAME:ndx_wkfltmpl_dsi TYPE:INDEX TABLE_NAME:WKFLTMPL CHANGE:CREATE
CREATE INDEX ndx_wkfltmpl_dsi
ON WKFLTMPL (delete_session_id,delete_date)
TABLESPACE ${ppm.index_tablespace}
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('DISCUSSION_discussion_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('DISCUSSION_discussion_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('DOCREVIEW_doc_review_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('DOCREVIEW_doc_review_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('DOCREVIEWTASK_review_task_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('DOCREVIEWTASK_review_task_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('IMAGEDATA_image_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('IMAGEDATA_image_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('LOCATION_location_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('LOCATION_location_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('SUMTRSRC_sumtrsrc_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('SUMTRSRC_sumtrsrc_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('TASKSUMFIN_task_sum_fin_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('TASKSUMFIN_task_sum_fin_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('TMPLCATG_tmplcatg_catg_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('TMPLCATG_tmplcatg_catg_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('TRSRCSUMFN_trsrc_sum_fin_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('TRSRCSUMFN_trsrc_sum_fin_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('TSAUDIT_ts_audit_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('TSAUDIT_ts_audit_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('TSDELEGATE_ts_delegate_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('TSDELEGATE_ts_delegate_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('USEROPEN_user_open_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('USEROPEN_user_open_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('WKFLTMPL_wkfl_tmpl_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('WKFLTMPL_wkfl_tmpl_id')) 
/



--METADATA TYPE:UP2 GROUP:60to61 NAME:UPDATERPTAREA 
declare
  pret_val number;
  pret_msg varchar2(255);
  lobd     BLOB;
  pattern1 VARCHAR2(30) := 'GroupByTableName';
  tabname  varchar2(32);
  position INTEGER := 1;
  buf      varchar2(32767);
  cursor rptcur is
    select rpt_id from rpt;
BEGIN
  -- get the LOB locator
  for rptrec in rptcur loop
    SELECT rpt_data INTO lobd FROM rpt WHERE rpt_id = rptrec.rpt_id;
    position := DBMS_LOB.INSTR(lobd, UTL_RAW.cast_to_raw(pattern1), 1, 1);
    IF position = 0 THEN
      update rpt set rpt_area = 'UNKNOWN' where rpt_id = rptrec.rpt_id;
    ELSE
      buf     := UTL_RAW.cast_to_varchar2(DBMS_LOB.SUBSTR(lobd,
                                                          2000,
                                                          position));
      tabname := substr(buf,
                        instr(buf, '''', 1, 1) + 1,
                        instr(buf, '''', 1, 2) - instr(buf, '''', 1, 1) - 1);
      if tabname is not null then
        update rpt set rpt_area = tabname where rpt_id = rptrec.rpt_id;
      else
        update rpt set rpt_area = 'UNKNOWN' where rpt_id = rptrec.rpt_id;
      end if;
    end if;
  end loop;
  commit;
    pret_val := 0;
    pret_msg := 'Update RPT_AREA in RPT table successful' ;
   dbms_output.put_line(pret_msg);  
exception
  when value_error then
    pret_val := -1;
    pret_msg := 'Error in Updating RPT_AREA in RPT table ' || SQLERRM;
    dbms_output.put_line(pret_msg); 
  when others then
    pret_val := -1;
    pret_msg := 'Error in Updating RPT_AREA in RPT table ' || SQLERRM;
    dbms_output.put_line(pret_msg);
END;



/ 
--END TYPE:UP2 GROUP:60to61 NAME:UPDATERPTAREA
--METADATA TYPE:UP2 GROUP:60to61 NAME:MIGRATE_NAVIVIEW 
declare

   TYPE nv_type IS REF CURSOR;
   TYPE nd_type IS REF CURSOR;
   nv nv_type; 
   nd nd_type;

  vkeys pls_integer; 
  vstartkey number(10);
  existing_naviview_name varchar2(255);
  existing_user_id pls_integer;
  existing_naviview_data varchar2(4000);
  existing_default_flag char(1);
  existing_naviview_id varchar2(4000);
  TimesheetApproval varchar2(4000);
  ProjectTimesheetApproval varchar2(4000);
  ApproveTimesheets varchar2(4000);
  start_pos pls_integer;
  end_pos pls_integer;
  tempstr varchar2(255);
  done pls_integer;
  vwprefkey varchar2(255);
  vwprefkey_val varchar2(40);
  vwprefkeyseq_val varchar2(40);
  dashboardid pls_integer;
  seqnum pls_integer;
  tableexist   pls_integer;
  dyn_sql_string varchar2(4000);

BEGIN
  SELECT COUNT(1)
  INTO tableexist
  FROM user_tables
  WHERE table_name = 'NAVIVIEW';

  IF tableexist = 1 THEN

    -- Get nextkeys for INSERTs
    dyn_sql_string := 'SELECT count(*) ' ||
                      'FROM naviview ';
    EXECUTE IMMEDIATE dyn_sql_string
                      INTO vkeys; 

    IF vkeys > 0 THEN
      getnextkeys('viewpref_view_pref_id', vkeys, vstartkey);
      COMMIT;
    END IF;

    --Process rows in naviview table
    OPEN nv FOR
      'SELECT navi_view_id ' || 
      'FROM naviview';

    LOOP
      FETCH nv INTO existing_naviview_id;
      EXIT WHEN nv%NOTFOUND;

      dyn_sql_string := 'SELECT navi_view_name, user_id, navi_view_data, default_flag ' ||
                        'FROM naviview ' ||
                        'WHERE navi_view_id = :1 ';
      EXECUTE IMMEDIATE dyn_sql_string
                        INTO existing_naviview_name, existing_user_id, existing_naviview_data, existing_default_flag  
                        USING existing_naviview_id;
   
      --Add row to ViewPref
      dyn_sql_string := 'INSERT INTO viewpref (view_pref_id, view_pref_name, view_pref_type, user_id ) ' ||
                        'VALUES (:1, :2, :3, :4) ';
      EXECUTE IMMEDIATE dyn_sql_string
                        USING vstartkey, existing_naviview_name, 'VT_UIVIEW', existing_user_id;

      --Add rows to VWPREFDATA for each value in NAVIVIEW.navi_view_data
      start_pos := INSTR(existing_naviview_data, '<NavigationViewContentData>');
      existing_naviview_data := SUBSTR(existing_naviview_data, start_pos + LENGTH('<NavigationViewContentData>') );
        
      LOOP
          start_pos := INSTR(existing_naviview_data, '<');
          end_pos := INSTR(existing_naviview_data, '/>');
          IF (end_pos = 0) or (start_pos = 0) THEN
		  EXIT;
          ELSE
            tempstr := SUBSTR(existing_naviview_data, start_pos+1, end_pos-start_pos-1);
            existing_naviview_data := SUBSTR(existing_naviview_data, end_pos + 2);
            vwprefkey := RTRIM(SUBSTR(tempstr, 1, INSTR(tempstr, ' ')));
            start_pos := INSTR(tempstr, 'value="') + 7;
            vwprefkey_val := SUBSTR(tempstr, start_pos, INSTR(tempstr, '"', start_pos)-start_pos); 
          

          
            dyn_sql_string := 'UPDATE users SET ui_view_pref_id =  :1' ||
                              'WHERE navi_view_id =  :2';
            EXECUTE IMMEDIATE dyn_sql_string
                              USING vstartkey, existing_naviview_id;
          

          IF vwprefkey = 'ProjectTimesheetApproval' THEN
            ProjectTimesheetApproval := vwprefkey_val;
          ELSIF vwprefkey = 'ApproveTimesheets' THEN
            ApproveTimesheets := vwprefkey_val;
          ELSE
            dyn_sql_string := 'INSERT INTO vwprefdata (view_pref_id, view_pref_key, view_pref_value) ' ||
                              'VALUES (:1, :2, :3) ';
            EXECUTE IMMEDIATE dyn_sql_string 
                              USING vstartkey, 'UIView.' || vwprefkey, vwprefkey_val;

            start_pos := INSTR(tempstr,'sequenceNum="');
            IF start_pos > 0 THEN
              start_pos := start_pos + 13;
              vwprefkeyseq_val := SUBSTR(tempstr, start_pos, INSTR(tempstr, '"', start_pos)-start_pos); 
	    dyn_sql_string := 'INSERT INTO vwprefdata (view_pref_id, view_pref_key, view_pref_value) ' ||
                              'VALUES (:1, :2, :3) ';
            EXECUTE IMMEDIATE dyn_sql_string 
                              USING vstartkey, 'UIView.' || vwprefkey || 'Seq', vwprefkeyseq_val;
            END IF;

          END IF;
        END IF;

        IF (TRIM(existing_naviview_data) = '</NavigationViewContentData>') THEN
	  EXIT;
        END IF;
      END LOOP; 

      --Create new combo key for ProjectTimesheetApproval and ApprovedTimesheets
      TimesheetApproval := 'true';
      IF (LOWER(ProjectTimesheetApproval)='false') AND (LOWER(ApproveTimesheets)='false') THEN
        TimesheetApproval := 'false';
      END IF;
      dyn_sql_string := 'INSERT INTO vwprefdata (view_pref_id, view_pref_key, view_pref_value) ' ||
                        'VALUES (:1, :2, :3) ';
      EXECUTE IMMEDIATE dyn_sql_string 
                        USING vstartkey, 'UIView.' || 'TimesheetApproval', TimesheetApproval;

      dyn_sql_string := 'INSERT INTO vwprefdata (view_pref_id, view_pref_key, view_pref_value) ' ||
                        'VALUES (:1, :2, :3) ';
      EXECUTE IMMEDIATE dyn_sql_string 
                        USING vstartkey, 'UIView.' || 'TimesheetApprovalSeq', '3';

      --Populate VWPREFDASH
      OPEN nd FOR
        'SELECT dashboard_id, seq_num ' ||
        'FROM navidash ' ||
        'WHERE navi_view_id = ' || existing_naviview_id;
      LOOP
        FETCH nd INTO dashboardid, seqnum;
        EXIT WHEN nd%NOTFOUND;
        dyn_sql_string := 'INSERT INTO vwprefdash (dashboard_id, seq_num, view_pref_id) ' ||
                          'VALUES (:1, :2, :3) ';
        EXECUTE IMMEDIATE dyn_sql_string 
                          USING dashboardid, seqnum, vstartkey;
      END LOOP;
      CLOSE nd;

      --Update Settings table with default view
      IF existing_default_flag = 'Y' THEN
        dyn_sql_string := 'INSERT INTO settings (namespace, setting_name, setting_value) ' ||
                          'VALUES (:1, :2, :3) ';
        EXECUTE IMMEDIATE dyn_sql_string 
                          USING 'VT_UIVIEW', 'UIView.DefaultViewId', vstartkey;
      END IF;

      vstartkey := vstartkey + 1;

    END LOOP;
    CLOSE nv;
  
  EXECUTE IMMEDIATE 'DROP TABLE navidash';
  EXECUTE IMMEDIATE 'DROP TABLE naviview';
  EXECUTE IMMEDIATE 'DROP VIEW ${pm.or.privileged_user}.navidash';
  EXECUTE IMMEDIATE 'DROP VIEW ${pm.or.privileged_user}.naviview';

  END IF; --NAVIVIEW exists
  COMMIT;
  
 
exception
  when others THEN
    dbms_output.put_line('Error: ' || SQLERRM);
    rollback;
END;



/ 
--END TYPE:UP2 GROUP:60to61 NAME:MIGRATE_NAVIVIEW
--METADATA TYPE:UP2 GROUP:61to62 NAME:UPDATE_VWPREFDATA 
declare
  cursor vwcur is select view_pref_id,view_pref_type from viewpref  where view_pref_type='VT_UIVIEW' ;
  dyn_sql_string varchar2(4000);
  TYPE varray_type IS VARRAY(10) OF VARCHAR2(32);
  vwkeys varray_type;  
  vwvalues varray_type; 
BEGIN
 vwkeys:=varray_type('UIView.DeleteProject','UIView.DeleteProjectSeq','UIView.ManagePortfoliosPort','UIView.ManagePortfoliosPortSeq','UIView.OpenPortfolios','UIView.OpenPortfoliosSeq','UIView.OpenProject','UIView.OpenProjectSeq');
 vwvalues:=varray_type('true','5','true','4','true','3','true','4');
--delete rows for VWPREFDATA
delete from VWPREFDATA where VIEW_PREF_KEY in ('UIView.ApproveTimesheets','UIView.ApproveTimesheetsSeq','UIView.CreatePortfolio','UIView.CreatePortfolioSeq','UIView.InitiateProjectProcess','UIView.InitiateProjectProcessSeq','UIView.ProjectTimesheetApproval','UIView.ProjectTimesheetApprovalSeq');  
for vwrec in vwcur loop
for i in vwkeys.FIRST..vwkeys.LAST
loop
dyn_sql_string :='insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)'|| 'values(:1,:2,:3)';
EXECUTE IMMEDIATE dyn_sql_string using vwrec.view_pref_id,vwkeys(i),vwvalues(i);
end loop;
end loop;
exception
  when others THEN
    dbms_output.put_line('Error: ' || SQLERRM);
    rollback;

END;


/ 
--END TYPE:UP2 GROUP:61to62 NAME:UPDATE_VWPREFDATA
--METADATA TYPE:UP2 GROUP:61to62 NAME:DELETE_ADMIN_CONFIG 
begin
UPDATE TASKRSRC set act_this_per_qty=0.0 where act_this_per_qty is null;
DELETE from admin_config where config_name = 'myprimavera.bre.INTERNAL_PLUGINS';
end;


/ 
--END TYPE:UP2 GROUP:61to62 NAME:DELETE_ADMIN_CONFIG
--METADATA TYPE:UP2 GROUP:61to62 NAME:UPDATE_SETTINGS 
begin
insert into settings (namespace, setting_name, setting_value) select distinct 'Table_Settings', 'udfvalue_denorm',
'N' from settings where not exists ( select 1 from settings where namespace='Table_Settings' and setting_name =
'udfvalue_denorm' );

insert into settings (namespace, setting_name, setting_value) select distinct 'Query_Settings',
'tasksum_query_split', 'N' from settings where not exists ( select 1 from settings where namespace='Query_Settings'
and setting_name = 'tasksum_query_split' );
end;


/ 
--END TYPE:UP2 GROUP:61to62 NAME:UPDATE_SETTINGS
--METADATA TYPE:UP2 GROUP:62to70 NAME:UPDATE_VWPREFDATA 
declare
  cursor cur_vpdata is
  select DISTINCT view_pref_id 
  from VWPREFDATA
  where upper(view_pref_key) like upper('VT_ACTIVITY.FirstBarDisplayType')
  or    upper(view_pref_key) like upper('VT_ACTIVITY.SecondBarDisplayType');
  v_firstbardisptype varchar2(255);
 v_secondbardisptype varchar2(255);
begin
  for r_vpdata in cur_vpdata loop
  
insert into VWPREFDATA (view_pref_id, view_pref_key, view_pref_value)
select r_vpdata.view_pref_id view_pref_id, 'VT_ACTIVITY.BarDisplayTypes' view_pref_key, 'NORMAL_BAR' view_pref_value
from VWPREFDATA 
where view_pref_id = r_vpdata.view_pref_id 
and not exists (select 1 from VWPREFDATA where upper(view_pref_key) = upper('VT_ACTIVITY.BarDisplayTypes') and view_pref_id = r_vpdata.view_pref_id)
and rownum < 2;

select upper(view_pref_value) into v_firstbardisptype
			from VWPREFDATA
			where view_pref_id = r_vpdata.view_pref_id
      and   upper(view_pref_key) = upper('VT_ACTIVITY.FirstBarDisplayType');
begin      
select upper(view_pref_value) into v_secondbardisptype
			from VWPREFDATA
			where view_pref_id = r_vpdata.view_pref_id
      and   upper(view_pref_key) = upper('VT_ACTIVITY.SecondBarDisplayType');
 
exception
 when no_data_found then  v_secondbardisptype:=null;
 end;
 
update VWPREFDATA
set view_pref_value = v_firstbardisptype || 
			decode(nvl(v_secondbardisptype, ''), 'NO_BAR', '', '', '', ',' ||case when v_secondbardisptype='BASELINE_BAR' then 'PRIMARY_BASELINE_BAR' else v_secondbardisptype end) 
where view_pref_id = r_vpdata.view_pref_id 
and   upper(view_pref_key) = upper('VT_ACTIVITY.BarDisplayTypes');


delete from VWPREFDATA 
where view_pref_id = r_vpdata.view_pref_id 
and (upper(view_pref_key) like upper('VT_ACTIVITY.FirstBarDisplayType')
      or    
      upper(view_pref_key) like upper('VT_ACTIVITY.SecondBarDisplayType')
    );

commit;

end loop;
insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value) select distinct(view_pref_id),'UIView.ImportExportProject','Y' from viewpref where view_pref_type='VT_UIVIEW'; 
insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value) select distinct(view_pref_id),'UIView.ImportExportProjectSeq','5' from viewpref where view_pref_type='VT_UIVIEW' ;
end; 


/ 
--END TYPE:UP2 GROUP:62to70 NAME:UPDATE_VWPREFDATA
--METADATA TYPE:UP2 GROUP:62to70 NAME:UPDATE_CALENDAR 
begin
update calendar set (DAY_HR_CNT, WEEK_HR_CNT, MONTH_HR_CNT, YEAR_HR_CNT)=(select DAY_HR_CNT, WEEK_HR_CNT, MONTH_HR_CNT, YEAR_HR_CNT from prefer);
update prefer set allow_user_time_period_flag = 'N';
end;


/ 
--END TYPE:UP2 GROUP:62to70 NAME:UPDATE_CALENDAR
--METADATA TYPE:UP2 GROUP:62to70 NAME:REMOVE_JOBS 
declare
db_version varchar2(255);
begin
select database_version into db_version from prefer;
if substr(db_version, length ('PMDB,') + 1, 4) >'0600' then
execute immediate('begin drop_background_procs;end;');
end if;
delete from settings where namespace='database.background.Damon';
delete from settings where namespace='database.background.Symon';
commit;
end;


/ 
--END TYPE:UP2 GROUP:62to70 NAME:REMOVE_JOBS
--METADATA TYPE:UP2 GROUP:62to70 NAME:UPDATE_USERENG 
declare 
cursor usercur is select user_id from users where prof_id=12;
vusereng_id  usereng.user_eng_id%TYPE;
TYPE varray_type IS VARRAY(10) OF VARCHAR2(32);
cnt pls_integer;
engtype varray_type;
dyn_sql_string varchar2(4000);
begin 
engtype:=varray_type('PM','TS','WEB_PM','WEB_RM','WU','TS_ONLY');
select key_seq_num into vusereng_id from nextkey where key_name='usereng_user_eng_id';
for userrec in usercur loop
for i in engtype.FIRST..engtype.LAST
loop
begin
cnt:=0;
select 1 into cnt from usereng where db_engine_type=engtype(i) and user_id=userrec.user_id and rownum < 2;
exception when no_data_found then 
 null;
end;
if cnt=0 then 
dyn_sql_string:='insert into usereng(user_eng_id,user_id,db_engine_type) values (:1,:2,:3)';
EXECUTE IMMEDIATE dyn_sql_string using vusereng_id,userrec.user_id,engtype(i);
vusereng_id:=vusereng_id+1; 
end if;
end loop;
end loop;
update nextkey set key_seq_num=vusereng_id where key_name='usereng_user_eng_id';  
exception
  when others THEN
    dbms_output.put_line('Error: ' || SQLERRM);
    rollback;
END;


/ 
--END TYPE:UP2 GROUP:62to70 NAME:UPDATE_USERENG
--METADATA TYPE:UP2 GROUP:70to71 NAME:MIGRATEFILTER_VWPREFDATA 
declare
vprefid viewpref.view_pref_id%TYPE;
max_view_pref_id viewpref.view_pref_id%TYPE;
CURSOR cur_vpdata IS
SELECT DISTINCT view_pref_id
FROM vwprefdata
WHERE UPPER(view_pref_key) LIKE UPPER('VT_ACTIVITY.Filter')
 AND UPPER(view_pref_value) LIKE UPPER('CustomFilter');
CURSOR cur_vpfilterdata IS
SELECT DISTINCT view_pref_id,
  view_pref_value
FROM vwprefdata
WHERE UPPER(view_pref_key) LIKE UPPER('VT_FILTER.FilterCriteria');
BEGIN
  SELECT key_seq_num
  INTO vprefid
  FROM nextkey
  WHERE key_name = 'viewpref_view_pref_id';
  SELECT MAX(view_pref_id)
  INTO max_view_pref_id
  FROM viewpref;

  IF(vprefid <= max_view_pref_id) THEN
    vprefid := max_view_pref_id + 1;
  END IF;

  FOR r_vpdata IN cur_vpdata
  LOOP
    INSERT
    INTO viewpref(view_pref_id,   view_pref_name,   view_pref_type,   user_id)
    SELECT vprefid,
      view_pref_name,
      'VT_FILTER',
      user_id
    FROM viewpref
    WHERE view_pref_id = r_vpdata.view_pref_id;
    INSERT
    INTO vwprefdata(view_pref_id,   view_pref_key,   view_pref_value)
    SELECT vprefid,
      'VT_FILTER.FilterCriteria',
      view_pref_value
    FROM vwprefdata
    WHERE view_pref_id = r_vpdata.view_pref_id
     AND UPPER(view_pref_key) = UPPER('VT_ACTIVITY.FilterCriteria')
     AND NOT EXISTS
      (SELECT 1
       FROM vwprefdata
       WHERE UPPER(view_pref_key) = UPPER('VT_FILTER.FilterCriteria')
       AND view_pref_id = vprefid)
    AND rownum < 2;
    INSERT
    INTO vwprefuser(view_pref_id,   user_id)
    SELECT vprefid,
      user_id
    FROM vwprefuser
    WHERE view_pref_id = r_vpdata.view_pref_id;

    UPDATE vwprefdata
    SET view_pref_value = 'TreeFilter'
    WHERE view_pref_key = 'VT_ACTIVITY.Filter'
     AND view_pref_id = r_vpdata.view_pref_id;
    INSERT
    INTO vwprefdata(view_pref_id,   view_pref_key,   view_pref_value)
    SELECT r_vpdata.view_pref_id,
      'VT_ACTIVITY.FiltersList',
      vprefid
    FROM dual
    WHERE NOT EXISTS
      (SELECT 1
       FROM vwprefdata
       WHERE UPPER(view_pref_key) = UPPER('VT_ACTIVITY.FiltersList')
       AND view_pref_id = r_vpdata.view_pref_id)
    AND rownum < 2;

    DELETE FROM vwprefdata
    WHERE view_pref_id = r_vpdata.view_pref_id
     AND UPPER(view_pref_key) = UPPER('VT_ACTIVITY.FilterCriteria');
    vprefid := vprefid + 1;
  END LOOP;

  UPDATE nextkey
  SET key_seq_num = vprefid
  WHERE key_name = 'viewpref_view_pref_id';
  COMMIT;
  FOR r_vpfilterdata IN cur_vpfilterdata
  LOOP
    IF instr(UPPER(r_vpfilterdata.view_pref_value),   'UDF:') > 0 THEN
        r_vpfilterdata.view_pref_value:=REPLACE(r_vpfilterdata.view_pref_value,   'UDF:',   'UDF_');
    END IF;
  
    IF instr(UPPER(r_vpfilterdata.view_pref_value),   UPPER('ActivityCodeTypeId:')) > 0 THEN
       r_vpfilterdata.view_pref_value:= REPLACE(r_vpfilterdata.view_pref_value,   'ActivityCodeTypeId:',   'ActivityCodeTypeId_');
    END IF;
    
    UPDATE vwprefdata
      SET view_pref_value = r_vpfilterdata.view_pref_value
      WHERE view_pref_id = r_vpfilterdata.view_pref_id;
  END LOOP;

EXCEPTION
WHEN others THEN
  DBMS_OUTPUT.PUT_LINE('Error while migrating filters');
END;

/ 
--END TYPE:UP2 GROUP:70to71 NAME:MIGRATEFILTER_VWPREFDATA
--METADATA TYPE:UP2 GROUP:70to71 NAME:UPDATE_VWPREFDATA 
declare
  cursor vwcur is select view_pref_id,view_pref_type from viewpref  where view_pref_type='VT_UIVIEW' ;
  dyn_sql_string varchar2(4000);
  TYPE varray_type IS VARRAY(2) OF VARCHAR2(32);
  vwkeys varray_type;  
  vwvalues varray_type; 
BEGIN
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,158,decode(p.prof_id,12,'Y','N'), sysdate, sys_context('USERENV','CURRENT_SCHEMA') from profpriv p,profile pf  where scope_type='ST_Global' and p.prof_id=pf.prof_id
and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=158);
 vwkeys:=varray_type('UIView.CreateTemplateProject','UIView.CreateTemplateProjectSeq');
 vwvalues:=varray_type('true','6');
for vwrec in vwcur loop
for i in vwkeys.FIRST..vwkeys.LAST
loop
dyn_sql_string :='insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)'|| 'values(:1,:2,:3)';
EXECUTE IMMEDIATE dyn_sql_string using vwrec.view_pref_id,vwkeys(i),vwvalues(i);
end loop;
end loop;
exception
  when others THEN
    dbms_output.put_line('Error: ' || SQLERRM);
    rollback;
END;



/ 
--END TYPE:UP2 GROUP:70to71 NAME:UPDATE_VWPREFDATA
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSRTADMCONFDATA 
declare
earnedValue INTEGER:=0;
blobField BLOB;
valuePatternAtCompl VARCHAR2(30) := 'EV_AtCompl';
valuePatternBudgCur VARCHAR2(30) := 'EV_Budg_With_Start_Dates';
valuePatternBudg VARCHAR2(30) := 'EV_Budg';
settingsName VARCHAR2(30):= 'EVCalculation';
insertValueAtCompl VARCHAR2(30):= 'EV_AtCompl';
insertValueBudgCur VARCHAR2(30):= 'EV_BudgCur';
insertValueBudg    VARCHAR2(30):= 'EV_Budg';
begin

  begin
    select 1 into earnedValue from settings where setting_name='EVCalculation';
    exception when no_data_found then
      null;
  end;

  if earnedValue=0 then
    
    begin
      select config_data into blobField from admin_config where config_name='CS_ADMIN' and config_type='SETTINGS' and factory_version='1.0.0';
        exception when no_data_found then
      null;
      return;
    end;
    
    if DBMS_LOB.INSTR(blobField, UTL_RAW.cast_to_raw(valuePatternAtCompl), 1, 1) != 0 then
      insert into settings(namespace, setting_name, setting_value) 
      values('Administrator_Settings', settingsName, insertValueAtCompl);
    elsif DBMS_LOB.INSTR(blobField, UTL_RAW.cast_to_raw(valuePatternBudgCur), 1, 1) != 0 then
      insert into settings(namespace, setting_name, setting_value) 
      values('Administrator_Settings', settingsName, insertValueBudgCur);
    elsif DBMS_LOB.INSTR(blobField, UTL_RAW.cast_to_raw(valuePatternBudg), 1, 1) != 0 then
      insert into settings(namespace, setting_name, setting_value) 
      values('Administrator_Settings', settingsName, insertValueBudg);
    end if;
  end if;
end;

/ 
--END TYPE:UP2 GROUP:70to71 NAME:INSRTADMCONFDATA
--METADATA TYPE:UP2 GROUP:70to71 NAME:UPDATE_INSERT_SETTINGS_PROJECT 
declare
blobField BLOB;
valuePattern VARCHAR2(30) := 'pvurl';
begin
  begin

    UPDATE settings SET namespace='Administrator_Settings', setting_name='MaxBaselinesCopiedWithProject' WHERE namespace='projectmanager.copyproject.baselines';

    begin
      select config_data into blobField from admin_config where config_name='CS_ADMIN';
        exception when no_data_found then
      null;
      return;
    end;
    
    if DBMS_LOB.INSTR(blobField, UTL_RAW.cast_to_raw(valuePattern), 1, 1) != 0 then
      insert into settings(namespace, setting_name) 
      values('Administrator_Settings', 'WebAccessURL');
    end if;
  end;

  UPDATE project set batch_sum_flag = 'N' where sum_only_flag = 'Y';
  UPDATE project set sum_only_flag = 'N', msp_managed_flag = 'N' where sum_only_flag != 'N' or msp_managed_flag != 'N';

end;

/ 
--END TYPE:UP2 GROUP:70to71 NAME:UPDATE_INSERT_SETTINGS_PROJECT
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSERT_NEW_PRIVILEDGES 
begin
  insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,160, case p.prof_id when 12 then 'Y' else 'N' END, sysdate, sys_context('USERENV','CURRENT_SCHEMA') from profpriv p,profile pf  where scope_type='ST_Global' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=160);

insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user)
select distinct p.prof_id,161,case p.allow_flag when 'Y' then 'Y' else 'N'  end , sysdate, sys_context('USERENV','CURRENT_SCHEMA') from profpriv p,profile pf  where scope_type='ST_Project' and p.prof_id=pf.prof_id  and p.priv_num = 18 and not exists(select * from profpriv where prof_id=p.prof_id and priv_num=161);


end;


/ 
--END TYPE:UP2 GROUP:70to71 NAME:INSERT_NEW_PRIVILEDGES
--METADATA TYPE:UP2 GROUP:70to71 NAME:DROP_BACKGROUND_JOBS 
begin
 drop_background_procs();
 begin
  DBMS_SCHEDULER.disable(name=>'SYMON', force => TRUE);
  exception when others then null;
  end;
 begin
  DBMS_SCHEDULER.disable(name=>'DAMON', force => TRUE);
   exception when others then null;
  end;
 begin 
 DBMS_SCHEDULER.drop_job(job_name => 'SYMON', force => TRUE);
 exception when others then null;
  end;
 begin 
 DBMS_SCHEDULER.drop_job(job_name => 'DAMON', force => TRUE); 
 exception when others then null;
 end;
end;

/ 
--END TYPE:UP2 GROUP:70to71 NAME:DROP_BACKGROUND_JOBS
--METADATA TYPE:UP2 GROUP:70to71 NAME:CLEAN_JOBSVC_TASKRSRC 
begin
  DELETE FROM jobsvc WHERE job_type='JT_Batch' OR job_type='JT_XERExport' OR recur_type='RT_ASAP';
  UPDATE jobsvc SET recur_type='RT_WebEnabled' WHERE recur_type='RT_RecurEnabled';
  UPDATE taskrsrc SET ot_factor=0,update_date=sysdate,update_user=sys_context('USERENV','CURRENT_SCHEMA') WHERE rsrc_id IS NULL and (ot_factor is null or ot_factor!=0);
  commit;
end;

/ 
--END TYPE:UP2 GROUP:70to71 NAME:CLEAN_JOBSVC_TASKRSRC
--METADATA TYPE:UP2 GROUP:70to71 NAME:USERENG_VIEWPREF 
--METADATA TYPE:UP2 GROUP:70to71 NAME:USERENG_VIEWPREF
declare
vprefid pls_integer;
BEGIN
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'AssignINoWhatIf','VT_ASSGN_FILT_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignINoWhatIf' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ;

    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'AssignHActive','VT_ASSGN_FILT_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignHActive' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ;
  
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'AssignCInProgress','VT_ASSGN_FILT_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignCInProgress' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ;

    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'AssignFFinDays','VT_ASSGN_FILT_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignFFinDays' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ;

    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'AssignAMyAssign','VT_ASSGN_FILT_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignAMyAssign' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'AssignGUnStaffed','VT_ASSGN_FILT_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignGUnStaffed' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'AssignEOccurDays','VT_ASSGN_FILT_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignEOccurDays' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'AssignBNotStarted','VT_ASSGN_FILT_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignBNotStarted' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'AssignDCompleted','VT_ASSGN_FILT_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignDCompleted' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'InProgressActivitiesOnly','VT_FILTER_STANDARD'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='InProgressActivitiesOnly' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'ActivitiesFinishingSoon','VT_FILTER_STANDARD'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ActivitiesFinishingSoon' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'CompletedActivitiesOnly','VT_FILTER_STANDARD'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='CompletedActivitiesOnly' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'NotStartedActivitiesOnly','VT_FILTER_STANDARD'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='NotStartedActivitiesOnly' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'MilestoneOnly','VT_FILTER_STANDARD'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='MilestoneOnly' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'MyActivities','VT_FILTER_STANDARD'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='MyActivities' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'ActivitiesProgressing','VT_FILTER_STANDARD'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ActivitiesProgressing' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'ProjectBEPS','VT_PROJ_FILTER_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectBEPS' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'ProjectGWhatIf','VT_PROJ_FILTER_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectGWhatIf' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'ProjectCActive','VT_PROJ_FILTER_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectCActive' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'ProjectAOpenOnly','VT_PROJ_FILTER_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectAOpenOnly' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'ProjectFTemplate','VT_PROJ_FILTER_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectFTemplate' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'ProjectDInactive','VT_PROJ_FILTER_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectDInactive' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'ProjectEPlanned','VT_PROJ_FILTER_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectEPlanned' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ;

  commit;
END;
/

--METADATA TYPE:UP2 GROUP:70to71 NAME:USERENG_VIEWPREF 
DELETE FROM profpriv where priv_num=143
/

--METADATA TYPE:UP2 GROUP:70to71 NAME:COMMIT
commit
/

/ 
--END TYPE:UP2 GROUP:70to71 NAME:USERENG_VIEWPREF
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSERT_VWPREFDATA 
--METADATA TYPE:UP2 GROUP:70to71 NAME:DELETE_VWPREFDATA
delete from vwprefdata where view_pref_key in ('UIView.ProjectDetailsSeq','UIView.ProjectToolsSeq','UIView.ProjectInvitedUsersSeq','UIView.ProjectIssueFormsSeq','UIView.ProjectDetails','UIView.ProjectTools','UIView.ProjectInvitedUsers','UIView.ProjectIssueForms')
/
--METADATA TYPE:UP2 GROUP:70to71 NAME:UPDATE_VWPREFDATA 
update vwprefdata set view_pref_value=to_number(view_pref_value)+1,update_date=sysdate where view_pref_id in (select view_pref_id from viewpref where  view_pref_type='VT_UIVIEW') and view_pref_key<>'UIView.ProjectEPSSeq' and view_pref_key like 'UIView.Pr%Seq' and to_number(view_pref_value)>=1
/
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSERT_VWPREFDATA 
insert into vwprefdata(view_pref_id,View_pref_key,view_pref_value,create_date) select distinct vwp.view_pref_id,'UIView.ProjectEPSSeq','1',sysdate from vwprefdata vwp,viewpref vp where vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW'   and  not exists(select * from vwprefdata vw where   vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.ProjectEPSSeq' and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW')
/
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSERT_VWPREFDATA
insert into vwprefdata(view_pref_id,View_pref_key,view_pref_value,create_date) select distinct vwp.view_pref_id,'UIView.ProjectEPS','true',sysdate from vwprefdata vwp,viewpref vp where vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW'   and  not exists(select * from vwprefdata vw where   vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.ProjectEPS' and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW')
/
--METADATA TYPE:UP2 GROUP:70to71 NAME:COMMIT
commit
/

/ 
--END TYPE:UP2 GROUP:70to71 NAME:INSERT_VWPREFDATA
--METADATA TYPE:UP2 GROUP:70to71 NAME:VWPREFDATA_UPDATES 
DECLARE
  v_id_list VWPREFDATA.VIEW_PREF_VALUE%TYPE;
begin
  insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
  select distinct vwp.view_pref_id,'UIView.ResourceManagement','false' 
  from vwprefdata vwp,viewpref vp
  where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
    and not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.ResourceManagement' 
    and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW')
    and vwp.view_pref_id not in (
      select distinct view_pref_id
      from vwprefdata 
      where view_pref_key in ('UIView.AddResource','UIView.ManageRoleTeams','UIView.CreateResourceTeam','UIView.ResourceDetails') and view_pref_value = 'true'
      ) ;
  insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
  select distinct vwp.view_pref_id,'UIView.ResourceManagement','true' 
  from vwprefdata vwp,viewpref vp
  where vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
    and not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.ResourceManagement' 
    and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW')
    and vwp.view_pref_id in (
      select distinct view_pref_id
      from vwprefdata 
      where view_pref_key in ('UIView.AddResource','UIView.ManageRoleTeams','UIView.CreateResourceTeam','UIView.ResourceDetails') 
        and view_pref_value = 'true'
      ) ;
 insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
 select  distinct  vwp.view_pref_id,'UIView.ResourceRoleUsageAnalysis','false' 
 from vwprefdata vwp,viewpref vp 
 where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
    and not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.ResourceRoleUsageAnalysis' 
    and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW') 
    and vwp.view_pref_id not in (select distinct view_pref_id
                                 from vwprefdata  
                                 where view_pref_key in ('UIView.ResourceAnalysis','UIView.ResourceUsage','UIView.ViewRoleUsage') 
      and view_pref_value = 'true');
 insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
 select  distinct  vwp.view_pref_id,'UIView.ResourceRoleUsageAnalysis','true' 
 from vwprefdata vwp,viewpref vp 
 where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
    and not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.ResourceRoleUsageAnalysis' 
    and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW') 
    and vwp.view_pref_id in (select distinct view_pref_id from vwprefdata  where view_pref_key in ('UIView.ResourceAnalysis','UIView.ResourceUsage','UIView.ViewRoleUsage') 
      and view_pref_value = 'true');
 insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
 select  distinct  vwp.view_pref_id,'UIView.HighLevelPlanning','true' 
 from vwprefdata vwp,viewpref vp 
 where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
    and not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.HighLevelPlanning' 
    and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW')
    and vwp.view_pref_id in (select distinct view_pref_id from vwprefdata  where view_pref_key='UIView.PlanResources' and view_pref_value = 'true');
 insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
 select  distinct  vwp.view_pref_id,'UIView.HighLevelPlanning','false' 
 from vwprefdata vwp,viewpref vp 
 where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
    and not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.HighLevelPlanning' 
    and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW')
    and vwp.view_pref_id not in (select distinct view_pref_id from vwprefdata  where view_pref_key='UIView.PlanResources' and view_pref_value = 'true');
 insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
 select  distinct  vwp.view_pref_id,'UIView.DetailedPlanning','true' 
 from vwprefdata vwp,viewpref vp 
 where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
    and not exists(select *
                   from vwprefdata vw
                   where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.DetailedPlanning'
                     and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW');
 insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value) 
 select  distinct  vwp.view_pref_id,'UIView.EnterpriseResourceData','true' 
 from vwprefdata vwp,viewpref vp 
 where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
    and  not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.EnterpriseResourceData' 
    and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW');
    
 SELECT MIN(view_pref_id)||','|| MAX(view_pref_id)  INTO v_id_list
 FROM VIEWPREF 
 WHERE view_pref_name IN ('InProgressActivitiesOnly','NotStartedActivitiesOnly') ;
    
 FOR cur_id IN (select view_pref_id from vwprefdata where view_pref_key='VT_ACTIVITY.Filter' and view_pref_value='NotFinishedActivitiesOnly')
 LOOP
   UPDATE VWPREFDATA SET view_pref_value='TreeFilter' WHERE view_pref_key='VT_ACTIVITY.Filter' AND view_pref_id=cur_id.view_pref_id; 
   INSERT INTO VWPREFDATA (view_pref_id,view_pref_key, view_pref_value) values(cur_id.view_pref_id, 'VT_ACTIVITY.FiltersList', v_id_list); 
   INSERT INTO VWPREFDATA (view_pref_id,view_pref_key, view_pref_value) values(cur_id.view_pref_id, 'VT_ACTIVITY.FiltersOperator', 'OR'); 
 END LOOP;
    
end;

/ 
--END TYPE:UP2 GROUP:70to71 NAME:VWPREFDATA_UPDATES
--METADATA TYPE:UP2 GROUP:70to71 NAME:USERENG_PROFPRIV 
--METADATA TYPE:UP2 GROUP:70to71 NAME:USERENG_PROFPRIV
DELETE from usereng
where db_engine_type ='TS' 
  and user_id in (select user_id from usereng where db_engine_type != 'PM' and db_engine_type != 'TS')
/

--METADATA TYPE:UP2 GROUP:70to71 NAME:USERENG_PROFPRIV 
DELETE FROM profpriv where priv_num=151
/

--METADATA TYPE:UP2 GROUP:70to71 NAME:COMMIT
commit
/

/ 
--END TYPE:UP2 GROUP:70to71 NAME:USERENG_PROFPRIV
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSERT_EDIT_CURRENTCIES 
--METADATA  TYPE:ADHOC_SQL
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select prof_id,159,case p.allow_flag when 'Y' then 'Y' else 'N' END, sysdate, sys_context('USERENV','CURRENT_SCHEMA') from profpriv p where priv_num=22  and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=159)
/


/ 
--END TYPE:UP2 GROUP:70to71 NAME:INSERT_EDIT_CURRENTCIES
--METADATA TYPE:UP2 GROUP:70to71 NAME:UPDATE_RISK 
Declare
  CURSOR Priskcur
  IS
    SELECT
      P.Risk_id,
      P.Proj_id,
      Pw.Wbs_name,
      P.Add_date,
      P.Priority_type,
      DECODE(P.Status_code, 'RS_Closed', 'RS_Manage', P.Status_code) status_code,
      P.Risk_name,
      P.Risk_type_id,
      P.Rsrc_id,
      P.Prbly_pct,
      P.Impact_work_qty,
      P.Impact_equip_qty,
      P.Impact_expense_cost,
      P.Impact_date,
      P.Impact_mat_qty,
      p.risk_descr,
      rc.risk_control,
      O.Obs_name,
      R.Rsrc_name
    FROM
      Projrisk P
    LEFT OUTER JOIN Riskctrl rc
    ON
      p.risk_id=rc.risk_id
    LEFT OUTER JOIN projwbs pw
    ON
      p.wbs_id=pw.wbs_id
    LEFT OUTER JOIN Obs O
    ON
      P.Obs_id=O.Obs_id
    LEFT OUTER JOIN Rsrc R
    ON
      P.Rsrc_id=R.Rsrc_id ;
BEGIN
  FOR priskrec IN Priskcur
  LOOP
    UPDATE
      projrisk
    SET
      notes=SUBSTR('Applies to WBS-'
      || priskrec.WBS_name
      || chr(13)
      || 'Responsible Manager-'
      || priskrec.obs_name
      || chr(13)
      ||'Priority-'
      || priskrec.priority_type
      || chr(13)
      || 'Date Identified-'
      || TO_CHAR(priskrec.add_date,'mon-dd-yyyy hh:mi:ss')
      || chr(13)
      || 'Impact Date-'
      || TO_CHAR(priskrec.impact_date,'mon-dd-yyyy hh:mi:ss')
      || chr(13)
      ||'Probability-'
      ||priskrec.prbly_pct
      || chr(13)
      ||'Impact - Labor Units-'
      ||priskrec.impact_work_qty
      || chr(13)
      ||'Impact - Nonlabor Units-'
      ||priskrec.impact_equip_qty
      || chr(13)
      ||'Impact - Material Units-'
      ||priskrec.impact_mat_qty
      || chr(13)
      || 'Impact - Expenses-'
      || priskrec.impact_expense_cost
      || chr(13)
      || utl_raw.cast_to_varchar2(dbms_lob.substr(priskrec.risk_control,2000,1)
      ),1,4000),
      risk_code='PROJRISK-'
      ||risk_id,risk_desc=utl_raw.cast_to_varchar2(dbms_lob.substr(priskrec.risk_descr,4000,1)),status_code=priskrec.status_code
    WHERE
      risk_id=priskrec.risk_id;
  END LOOP;
  COMMIT;
END;


/ 
--END TYPE:UP2 GROUP:70to71 NAME:UPDATE_RISK
--METADATA TYPE:UP2 GROUP:70to71 NAME:ALTER_PROJRISK 
--METADATA NAME:wbs_id TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
ALTER TABLE PROJRISK drop column  wbs_id CASCADE CONSTRAINTS
/
 
--METADATA NAME:priority_type TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
ALTER TABLE PROJRISK drop column  priority_type CASCADE CONSTRAINTS
/
 
--METADATA NAME:obs_id TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
ALTER TABLE PROJRISK drop column  obs_id CASCADE CONSTRAINTS
/
 
--METADATA NAME:prbly_pct TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
ALTER TABLE PROJRISK drop column  prbly_pct CASCADE CONSTRAINTS
/
 
--METADATA NAME:impact_work_qty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
ALTER TABLE PROJRISK drop column  impact_work_qty CASCADE CONSTRAINTS
/
 
--METADATA NAME:impact_equip_qty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
ALTER TABLE PROJRISK drop column  impact_equip_qty CASCADE CONSTRAINTS
/
 
--METADATA NAME:impact_expense_cost TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
ALTER TABLE PROJRISK drop column  impact_expense_cost CASCADE CONSTRAINTS
/
 
--METADATA NAME:impact_date TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
ALTER TABLE PROJRISK drop column  impact_date CASCADE CONSTRAINTS
/
 
--METADATA NAME:impact_mat_qty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
ALTER TABLE PROJRISK drop column  impact_mat_qty CASCADE CONSTRAINTS


/ 
--END TYPE:UP2 GROUP:70to71 NAME:ALTER_PROJRISK
--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES

INSERT INTO SETTINGS (namespace,setting_name,setting_value) VALUES('Administrator_Settings','OnlineHelpRootUrl','http://docs.oracle.com/cd/E35157_01/client_help/')
/

update udfvalue uv set TABLE_NAME = (select TABLE_NAME from udftype ut where ut.udf_type_id = uv.udf_type_id)
/

merge into settings ss using dual
on ( namespace='Table_Settings' and setting_name='udfvalue_denorm')
when matched then
update set setting_value='N'
When not matched then
insert (namespace,setting_name,setting_value)
values('Table_Settings','udfvalue_denorm','N')
/


--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES

  declare
  vpropid pls_integer;
  BEGIN
      vpropid:= copy_utils.Get_Next_Key('viewprop_view_id');
      insert into viewprop(VIEW_ID,VIEW_NAME,VIEW_TYPE) select vpropid,'Default Import Template','VP_XML_IMP_DET_OPT'
      from dual
      where not exists ( select view_id from viewprop where VIEW_NAME = 'Default Import Template' and VIEW_TYPE = 'VP_XML_IMP_DET_OPT') ;
      
        commit;
  END;
/


/ 
--END TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:83to83 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:83to83 NAME:MISC_UPDATES
UPDATE PROJRISK p
SET p.risk_desc =LTRIM(RTRIM(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE((REGEXP_REPLACE(p.risk_desc,'<[^>]*>','')), '&' || 'nbsp;', ''), '&' || 'nbsp', ' '), 'amp;', '&' ), '&' || 'lt;', '<'), '&' || 'gt;', '>'), chr(13), ' '), chr(10), '')))






/ 
--END TYPE:UP2 GROUP:83to83 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
merge into settings ss using dual
on ( namespace='Administrator_Settings' and setting_name='AlwaysLaunchOnlineHelp')
when matched then
update set setting_value='Y'
When not matched then
insert (namespace,setting_name,setting_value)
values('Administrator_Settings','AlwaysLaunchOnlineHelp','Y')
/


--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
update settings set setting_value = 'Y' where setting_name = 'AlwaysLaunchOnlineHelp'
/

--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
update settings set  setting_value='http://docs.oracle.com/cd/E54700_01/client_help/' where setting_name='OnlineHelpRootUrl'
/

/ 
--END TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:84to151 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:84to151 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E58732_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/

--METADATA TYPE:UP2 GROUP:84to151 NAME:MISC_UPDATES
declare 
cursor uid_cur is 
 select ue1.user_id from usereng ue1
   where ue1.db_engine_type in ('PM','WEB_PM','WEB_RM');
v_user_eng_id number;
begin
  for r_uid_cur in uid_cur loop
    dbms_output.put_line('userid : ' || r_uid_cur.user_id);
    getnextkeys ('usereng_user_eng_id', 1, v_user_eng_id);
    dbms_output.put_line('usereng_user_eng_id : ' || v_user_eng_id);
    INSERT INTO usereng (user_eng_id, user_id, db_engine_type) 
    values(v_user_eng_id, r_uid_cur.user_id,'VIS');
  end loop;
  commit; 
end;
/
/ 
--END TYPE:UP2 GROUP:84to151 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:151to151 NAME:TRIGGER_USESSION 
--METADATA NAME:RT_USESSION_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:DROP
DECLARE trigger_exist pls_integer;
BEGIN 
SELECT count(*) INTO trigger_exist FROM user_triggers WHERE trigger_name = 'RT_USESSION_DEL';
IF trigger_exist=1
THEN EXECUTE IMMEDIATE 'DROP TRIGGER RT_USESSION_DEL' ;
END IF;
EXCEPTION WHEN no_data_found THEN NULL;
END;
/

--METADATA NAME:RT_USESSION TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_USESSION
BEFORE UPDATE OR INSERT ON USESSION
FOR EACH ROW
BEGIN
  if dbms_reputil.from_remote = true then   return; end if;
  
  :NEW.update_date := SYSDATE;
  
  :NEW.update_user := prm_audit.g_prm_user_name;

  IF INSERTING THEN
	:NEW.create_user := prm_audit.g_prm_user_name;
	:NEW.create_date := SYSDATE;
  END IF;		
end; 
/
/ 
--END TYPE:UP2 GROUP:151to151 NAME:TRIGGER_USESSION
--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES 
 --METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E63417_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
update projwbs set est_wt=1 where est_wt is null
/
--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
update task set est_wt=1 where est_wt is null
/
/ 
--END TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E68202_01' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:161to162 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:161to162 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E75426_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:161to162 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1712to1801 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1712to1801 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E90748_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:1712to1801 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1802to1803 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1802to1803 NAME:MISC_UPDATES
update prefer set license_data=null
/
/ 
--END TYPE:UP2 GROUP:1802to1803 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1803to1804 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1803to1804 NAME:MISC_UPDATES
insert into PROFPRIV (prof_id,priv_num,allow_flag)
select DISTINCT a.PROF_ID,177,'Y' from PROFPRIV a
where not exists ( select 1 from PROFPRIV b where b.PROF_ID=a.PROF_ID and b.priv_num=177 and b.allow_flag='Y') 
/

/ 
--END TYPE:UP2 GROUP:1803to1804 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1804to1805 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1804to1805 NAME:MISC_UPDATES
declare
cursor profile_cur is select prof_id,default_flag,superuser_flag,scope_type,prof_name from profile;
v_prof_id profpriv.prof_id%type;
v_priv_num profpriv.priv_num%type;
v_allow_flag profpriv.allow_flag%type;
begin
for v_cur in profile_cur loop
begin
select prof_id,priv_num,allow_flag into v_prof_id,v_priv_num,v_allow_flag from profpriv where prof_id= v_cur.prof_id and priv_num=177;
if v_prof_id=12 then
update profpriv set allow_flag ='Y' where prof_id= v_cur.prof_id and priv_num=177;
else
update profpriv set allow_flag ='N' where prof_id= v_cur.prof_id and priv_num=177;
end if;
exception when no_data_found then
if v_cur.prof_id=12 then
insert into profpriv (prof_id,priv_num,allow_flag) values (v_cur.prof_id,177,'Y');
else
insert into profpriv (prof_id,priv_num,allow_flag) values (v_cur.prof_id,177,'N');
end if;
end;
end loop;
end;
/

/ 
--END TYPE:UP2 GROUP:1804to1805 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1805to1806 NAME:MISC_UPDATES 
---METADATA TYPE:UP2 GROUP:1805to1806 NAME:MISC_UPDATES
update  PROJECT set wbs_max_sum_level =0 where wbs_max_sum_level is NULL
/
/ 
--END TYPE:UP2 GROUP:1805to1806 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES 
---METADATA TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F12057_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES 
---METADATA TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F12059_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE PCATTYPE SET PROJ_CATG_SHORT_LEN=60 WHERE PROJ_CATG_TYPE='Prime Workspace'
/
--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE PCATTYPE SET PROJ_CATG_TYPE='Primavera Workspace' WHERE PROJ_CATG_TYPE='Prime Workspace'
/

--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE RSRC SET INTG_TYPE='PrimaveraCloudScope' WHERE INTG_TYPE='PrimeScope'
/

--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE PROJWBS SET INTG_TYPE='PrimaveraCloudScope' WHERE INTG_TYPE='PrimeScope'
/


/ 
--END TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
DECLARE
  col_exists integer;
  cursor cur is select IMAGE_NAME ,image_id from IMAGEDATA;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('IMAGEDATA') and column_name=upper('Image_Extension');
  if col_exists > 0 then
   for i in cur loop 
    begin
      if instr(i.image_name,'.')>0 then
      execute immediate 'update imagedata
        set image_name = :1,
            image_extension = :2
      where image_id=:3' using SUBSTR(i.image_name,1,INSTR(i.image_name,'.',-1,1)-1),SUBSTR(i.image_name,INSTR(i.image_name,'.',-1,1)+1),i.image_id;  
      end if;
    exception when others then
      null;
    end;
   end loop;
  end if;
 END;
 /
 
--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
delete from profpriv pp
where exists
(select p.prof_id from profile p 
where p.prof_id = pp.prof_id and pp.priv_num=177
and p.scope_type = 'ST_Project')
/




/ 
--END TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1912to19121 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1912to19121 NAME:MISC_UPDATES
DECLARE
v_len number;
v_start_point number;
v_final blob;
cursor c is select issue_id,issue_notes 
from projissu where issue_notes is NOT NULL ;
begin
for rec in c loop
v_len := dbms_lob.getlength(rec.issue_notes);
if(v_len is not null and v_len > 0) then
v_start_point:=dbms_lob.instr(rec.issue_notes, utl_raw.cast_to_raw('DOCTYPE'));
if (v_start_point=0 or v_start_point is null) then
  dbms_lob.createtemporary(v_final, true);
  dbms_lob.append(v_final,utl_raw.cast_to_raw('<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN"><HTML><HEAD><META content="text/html; charset=unicode" http-equiv=Content-Type><META name=GENERATOR content="MSHTML 11.00.10570.1001"></HEAD><BODY><SPAN style="FONT-SIZE: medium; FONT-FAMILY: serif; WHITE-SPACE: normal; WORD-SPACING: 0px; TEXT-TRANSFORM: none; FLOAT: none; FONT-WEIGHT: 400; COLOR: rgb(0,0,0); FONT-STYLE: normal; ORPHANS: 2; WIDOWS: 2; DISPLAY: inline !important; LETTER-SPACING: normal; TEXT-INDENT: 0px; font-variant-ligatures: normal; font-variant-caps: normal; -webkit-text-stroke-width: 0px; text-decoration-style: initial; text-decoration-color: initial">'));
  dbms_lob.append(v_final, rec.issue_notes);
  dbms_lob.append(v_final,utl_raw.cast_to_raw('</SPAN></BODY></HTML>'));
  execute immediate 'update projissu set issue_notes = :1 where issue_id= :2' using v_final,rec.issue_id;
commit;
end if;
end if;
end loop;
dbms_lob.freetemporary(v_final);
dbms_lob.close(v_final);
EXCEPTION
 WHEN OTHERS THEN
  NULL;
end;
/
/ 
--END TYPE:UP2 GROUP:1912to19121 NAME:MISC_UPDATES
update prefer set database_version='PPMDB,1912.0006.0000.0000'
/
commit
/
