
--Run Script as PXRPTUSER    
SET DEFINE OFF

--METADATA NAME:GATEWAYDEPLOYMENT TYPE:SYNONYM TARGET_OBJECT:GATEWAYDEPLOYMENT CHANGE:CREATE
CREATE OR REPLACE SYNONYM GATEWAYDEPLOYMENT FOR ${pm.or.administrative_user}.GATEWAYDEPLOYMENT
/

--METADATA NAME:GATEWAYPROVIDER TYPE:SYNONYM TARGET_OBJECT:GATEWAYPROVIDER CHANGE:CREATE
CREATE OR REPLACE SYNONYM GATEWAYPROVIDER FOR ${pm.or.administrative_user}.GATEWAYPROVIDER
/

--METADATA NAME:GATEWAYSYNCACTION TYPE:SYNONYM TARGET_OBJECT:GATEWAYSYNCACTION CHANGE:CREATE
CREATE OR REPLACE SYNONYM GATEWAYSYNCACTION FOR ${pm.or.administrative_user}.GATEWAYSYNCACTION
/

--METADATA NAME:PREFER TYPE:SYNONYM TARGET_OBJECT:PREFER CHANGE:CREATE
CREATE OR REPLACE SYNONYM PREFER FOR ${pm.or.administrative_user}.PREFER
/

--METADATA NAME:PROJDEPLMENT TYPE:SYNONYM TARGET_OBJECT:PROJDEPLMENT CHANGE:CREATE
CREATE OR REPLACE SYNONYM PROJDEPLMENT FOR ${pm.or.administrative_user}.PROJDEPLMENT
/

--METADATA NAME:PKG_ARBITER_COUNTER TYPE:SYNONYM TARGET_OBJECT: CHANGE:CREATE
CREATE OR REPLACE SYNONYM PKG_ARBITER_COUNTER FOR ${pm.or.administrative_user}.PKG_ARBITER_COUNTER
/

--METADATA NAME:SECPAC TYPE:SYNONYM TARGET_OBJECT: CHANGE:CREATE
CREATE OR REPLACE SYNONYM SECPAC FOR ${pm.or.administrative_user}.SECPAC
/
--CONNECT USERNAME:pxrptuser
     
set scan off
     
prompt creating view RESOURCELIMIT

--METADATA NAME:RESOURCELIMIT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCELIMIT
AS SELECT a.rsrc_id resourceobjectid
,a.startdate startdate
,a.enddate enddate
,a.limit limit
,a.update_date lastupdatedate
 FROM ${pm.or.administrative_user}.RESOURCELIMIT A
/
     
prompt creating view ACTIVITY

--METADATA NAME:ACTIVITY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITY
AS SELECT a.task_id objectid
,a.proj_id projectobjectid
,a.wbs_id wbsobjectid
,a.clndr_id calendarobjectid
,a.rev_fdbk_flag isnewfeedback
,a.auto_compute_act_flag autocomputeactuals
,CASE a.complete_pct_type WHEN 'CP_Phys' THEN 'Physical' WHEN 'CP_Drtn' THEN 'Duration' WHEN 'CP_Units' THEN 'Units' WHEN 'CP_Scope' THEN 'Scope' ELSE a.complete_pct_type END percentcompletetype
,CASE a.task_type WHEN 'TT_Task' THEN 'Task Dependent' WHEN 'TT_Rsrc' THEN 'Resource Dependent' WHEN 'TT_LOE' THEN 'Level Of Effort' WHEN 'TT_Mile' THEN 'Start Milestone' WHEN 'TT_FinMile' THEN 'Finish Milestone' WHEN 'TT_WBS' THEN 'WBS Summary' ELSE a.task_type END type
,CASE a.duration_type WHEN 'DT_FixedRate' THEN 'Fixed Units/Time' WHEN 'DT_FixedDrtn' THEN 'Fixed Duration & Units/Time' WHEN 'DT_FixedQty' THEN 'Fixed Units' WHEN 'DT_FixedDUR2' THEN 'Fixed Duration & Units' ELSE a.duration_type END durationtype
,CASE a.review_type WHEN 'RV_OK' THEN 'OK' WHEN 'RV_Review' THEN 'For Review' WHEN 'RV_Reject' THEN 'Reject' ELSE a.review_type END reviewstatus
,CASE a.status_code WHEN 'TK_NotStart' THEN 'Not Started' WHEN 'TK_Active' THEN 'In Progress' WHEN 'TK_Complete' THEN 'Completed' ELSE a.status_code END status
,a.task_code id
,a.task_name name
,a.rsrc_id primaryresourceobjectid
,a.total_float_hr_cnt totalfloat
,a.free_float_hr_cnt freefloat
,a.remain_drtn_hr_cnt remainingduration
,a.act_work_qty actuallaborunits
,a.remain_work_qty remaininglaborunits
,a.target_work_qty plannedlaborunits
,a.target_drtn_hr_cnt plannedduration
,a.target_equip_qty plannednonlaborunits
,a.act_equip_qty actualnonlaborunits
,a.remain_equip_qty remainingnonlaborunits
,a.cstr_date primaryconstraintdate
,a.act_start_date actualstartdate
,a.act_end_date actualfinishdate
,a.late_start_date latestartdate
,a.late_end_date latefinishdate
,a.expect_end_date expectedfinishdate
,a.early_start_date earlystartdate
,a.early_end_date earlyfinishdate
,a.restart_date remainingearlystartdate
,a.reend_date remainingearlyfinishdate
,a.target_start_date plannedstartdate
,a.target_end_date plannedfinishdate
,a.review_end_date reviewfinishdate
,a.rem_late_start_date remaininglatestartdate
,a.rem_late_end_date remaininglatefinishdate
,CASE a.cstr_type WHEN 'CS_MSO' THEN 'Start On' WHEN 'CS_MSOB' THEN 'Start On or Before' WHEN 'CS_MSOA' THEN 'Start On or After' WHEN 'CS_MEO' THEN 'Finish On' WHEN 'CS_MEOB' THEN 'Finish On or Before' WHEN 'CS_MEOA' THEN 'Finish On or After' WHEN 'CS_ALAP' THEN 'As Late As Possible' WHEN 'CS_MANDSTART' THEN 'Mandatory Start' WHEN 'CS_MANDFIN' THEN 'Mandatory Finish' ELSE a.cstr_type END primaryconstrainttype
,CASE a.priority_type WHEN 'PT_Top' THEN 'Top' WHEN 'PT_High' THEN 'High' WHEN 'PT_Normal' THEN 'Normal' WHEN 'PT_Low' THEN 'Low' WHEN 'PT_Lowest' THEN 'Lowest' ELSE a.priority_type END levelingpriority
,a.cstr_date2 secondaryconstraintdate
,CASE a.cstr_type2 WHEN 'CS_MSO' THEN 'Start On' WHEN 'CS_MSOB' THEN 'Start On or Before' WHEN 'CS_MSOA' THEN 'Start On or After' WHEN 'CS_MEO' THEN 'Finish On' WHEN 'CS_MEOB' THEN 'Finish On or Before' WHEN 'CS_MEOA' THEN 'Finish On or After' WHEN 'CS_ALAP' THEN 'As Late As Possible' WHEN 'CS_MANDSTART' THEN 'Mandatory Start' WHEN 'CS_MANDFIN' THEN 'Mandatory Finish' ELSE a.cstr_type2 END secondaryconstrainttype
,a.float_path floatpath
,a.float_path_order floatpathorder
,a.act_this_per_work_qty actualthisperiodlaborunits
,a.act_this_per_equip_qty actualthisperiodnonlaborunits
,a.driving_path_flag islongestpath
,a.suspend_date suspenddate
,a.resume_date resumedate
,a.external_early_start_date externalearlystartdate
,a.external_late_end_date externallatefinishdate
,P.accountingvariance accountingvariance
,P.accountingvariancelaborunits accountingvariancelaborunits
,P.actualduration actualduration
,P.actualexpensecost actualexpensecost
,P.actuallaborcost actuallaborcost
,P.actualmaterialcost actualmaterialcost
,P.actualnonlaborcost actualnonlaborcost
,P.actualthisperiodlaborcost actualthisperiodlaborcost
,P.actualthisperiodmaterialcost actualthisperiodmaterialcost
,P.actualthisperiodnonlaborcost actualthisperiodnonlaborcost
,P.actualtotalcost actualtotalcost
,P.actualtotalunits actualtotalunits
,P.atcompletionduration atcompletionduration
,P.atcompletionexpensecost atcompletionexpensecost
,P.atcompletionlaborcost atcompletionlaborcost
,P.atcompletionlaborunits atcompletionlaborunits
,P.atcompletionlaborunitsvariance atcompletionlaborunitsvariance
,P.atcompletionmaterialcost atcompletionmaterialcost
,P.atcompletionnonlaborcost atcompletionnonlaborcost
,P.atcompletionnonlaborunits atcompletionnonlaborunits
,P.atcompletiontotalcost atcompletiontotalcost
,P.atcompletiontotalunits atcompletiontotalunits
,P.atcompletionvariance atcompletionvariance
,P.baselineduration baselineduration
,P.baselinefinishdate baselinefinishdate
,P.baselineplannedduration baselineplannedduration
,P.baselineplannedexpensecost baselineplannedexpensecost
,P.baselineplannedlaborcost baselineplannedlaborcost
,P.baselineplannedlaborunits baselineplannedlaborunits
,P.baselineplannedmaterialcost baselineplannedmaterialcost
,P.baselineplannednonlaborcost baselineplannednonlaborcost
,P.baselineplannednonlaborunits baselineplannednonlaborunits
,P.baselineplannedtotalcost baselineplannedtotalcost
,P.baselinestartdate baselinestartdate
,P.baselinelatestartdate baselinelatestartdate
,P.baseline1latestartdate baseline1latestartdate
,P.baselinelatefinishdate baselinelatefinishdate
,P.baseline1latefinishdate baseline1latefinishdate
,P.budgetatcompletion budgetatcompletion
,P.calendarname calendarname
,P.costpercentcomplete costpercentcomplete
,P.costpercentofplanned costpercentofplanned
,P.costperformanceindex costperformanceindex
,P.costperformanceindexlaborunits costperformanceindexlaborunits
,P.costvariance costvariance
,P.costvarianceindex costvarianceindex
,P.costvarianceindexlaborunits costvarianceindexlaborunits
,P.costvariancelaborunits costvariancelaborunits
,(select datadate  FROM ${pm.or.administrative_user}.projectx px where px.proj_id=a.proj_id) as  datadate
,P.duration1variance duration1variance
,P.durationpercentcomplete durationpercentcomplete
,P.durationpercentofplanned durationpercentofplanned
,P.durationvariance durationvariance
,P.earnedvaluecost earnedvaluecost
,P.earnedvaluelaborunits earnedvaluelaborunits
,P.estimateatcompletioncost estimateatcompletioncost
,P.estimateatcompletionlaborunits estimateatcompletionlaborunits
,P.estimatetocomplete estimatetocomplete
,P.estimatetocompletelaborunits estimatetocompletelaborunits
,P.expensecost1variance expensecost1variance
,P.expensecostpercentcomplete expensecostpercentcomplete
,P.expensecostvariance expensecostvariance
,P.finishdate finishdate
,P.finishdate1variance finishdate1variance
,P.finishdatevariance finishdatevariance
,P.iscritical iscritical
,P.laborcost1variance laborcost1variance
,P.laborcostpercentcomplete laborcostpercentcomplete
,P.laborcostvariance laborcostvariance
,P.laborunits1variance laborunits1variance
,P.laborunitspercentcomplete laborunitspercentcomplete
,P.laborunitsvariance laborunitsvariance
,P.materialcost1variance materialcost1variance
,P.materialcostpercentcomplete materialcostpercentcomplete
,P.materialcostvariance materialcostvariance
,P.nonlaborcost1variance nonlaborcost1variance
,P.nonlaborcostpercentcomplete nonlaborcostpercentcomplete
,P.nonlaborcostvariance nonlaborcostvariance
,P.nonlaborunits1variance nonlaborunits1variance
,P.nonlaborunitspercentcomplete nonlaborunitspercentcomplete
,P.nonlaborunitsvariance nonlaborunitsvariance
,P.percentcomplete percentcomplete
,P.performancepercentcomplete performancepercentcomplete
,P.physicalpercentcomplete physicalpercentcomplete
,P.plannedexpensecost plannedexpensecost
,P.plannedlaborcost plannedlaborcost
,P.plannedmaterialcost plannedmaterialcost
,P.plannednonlaborcost plannednonlaborcost
,P.plannedtotalcost plannedtotalcost
,P.plannedtotalunits plannedtotalunits
,P.plannedvaluecost plannedvaluecost
,P.plannedvaluelaborunits plannedvaluelaborunits
,P.primaryresourceid primaryresourceid
,P.primaryresourcename primaryresourcename
,P.remainingexpensecost remainingexpensecost
,P.remainingfloat remainingfloat
,P.remaininglaborcost remaininglaborcost
,P.remainingmaterialcost remainingmaterialcost
,P.remainingnonlaborcost remainingnonlaborcost
,P.remainingtotalcost remainingtotalcost
,P.remainingtotalunits remainingtotalunits
,P.schedulepercentcomplete schedulepercentcomplete
,P.scheduleperfindexlaborunits scheduleperfindexlaborunits
,P.scheduleperformanceindex scheduleperformanceindex
,P.schedulevariance schedulevariance
,P.schedulevarianceindex schedulevarianceindex
,P.schedulevariancelaborunits schedulevariancelaborunits
,P.schedulevarindexlaborunits schedulevarindexlaborunits
,P.startdate startdate
,P.startdate1variance startdate1variance
,P.startdatevariance startdatevariance
,P.tocompleteperformanceindex tocompleteperformanceindex
,P.totalcost1variance totalcost1variance
,P.totalcostvariance totalcostvariance
,P.unitspercentcomplete unitspercentcomplete
,P.wbscode wbscode
,P.wbsname wbsname
,a.location_id locationobjectid
,P.locationname locationname
,a.control_updates_flag reviewrequired
,a.starred_flag isstarred
,a.cbs_code cbscode
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
,P.update_date lastupdatedatex
,P.activityownerobjectid activityownerobjectid
,P.activityowner activityowner 
,case when a.update_date>P.update_date then 'N' ELSE 'Y' END rpt_current_flag
 FROM ${pm.or.administrative_user}.TASK A 
   INNER JOIN ${pm.or.administrative_user}.TASKX P
   ON a.task_id = p.task_id
   INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab
   ON a.proj_id = projects_tab.proj_id
WHERE A.DELETE_SESSION_ID is null
AND projects_tab.ORIG_PROJ_ID IS NULL
/
     
prompt creating view ACTIVITYCODE

--METADATA NAME:ACTIVITYCODE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYCODE
AS SELECT a.actv_code_id objectid
,a.actv_code_type_id codetypeobjectid
,a.seq_num sequencenumber
,a.short_name codevalue
,a.parent_actv_code_id parentobjectid
,a.actv_code_name description
,P.codetypename codetypename
,P.issecurecode issecurecode
,P.projectobjectid projectobjectid
,P.codetypescope codetypescope
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.ACTVCODE A 
   INNER JOIN ${pm.or.administrative_user}.ACTVCODEX P
   ON a.actv_code_id = p.actv_code_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view ACTIVITYCODEASSIGNMENT

--METADATA NAME:ACTIVITYCODEASSIGNMENT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYCODEASSIGNMENT
AS SELECT a.task_id activityobjectid
,a.actv_code_type_id activitycodetypeobjectid
,a.actv_code_id activitycodeobjectid
,a.proj_id projectobjectid
,P.activitycodedescription activitycodedescription
,P.activitycodetypename activitycodetypename
,P.activitycodetypescope activitycodetypescope
,P.activitycodevalue activitycodevalue
,P.activityid activityid
,P.activityname activityname
,P.issecurecode issecurecode
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.TASKACTV A 
   INNER JOIN ${pm.or.administrative_user}.TASKACTVX P
   ON a.task_id = p.task_id and a.actv_code_type_id = p.actv_code_type_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view ACTIVITYCODETYPE

--METADATA NAME:ACTIVITYCODETYPE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYCODETYPE
AS SELECT a.actv_code_type_id objectid
,a.actv_short_len length
,a.seq_num sequencenumber
,a.actv_code_type name
,CASE a.actv_code_type_scope WHEN 'AS_Global' THEN 'Global' WHEN 'AS_EPS' THEN 'EPS' WHEN 'AS_Project' THEN 'Project' ELSE a.actv_code_type_scope END scope
,CASE WHEN a.actv_code_type_scope = 'AS_Project' THEN a.proj_id ELSE null END projectobjectid
,CASE WHEN a.actv_code_type_scope = 'AS_EPS' THEN (select min(p.wbs_id)  FROM ${pm.or.administrative_user}.projwbs p where p.proj_id=a.proj_id and p.proj_node_flag='Y')  ELSE null END epsobjectid
,a.super_flag issecurecode
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.ACTVTYPE A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view ACTIVITYEXPENSE

--METADATA NAME:ACTIVITYEXPENSE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYEXPENSE
AS SELECT a.cost_item_id objectid
,a.proj_id projectobjectid
,a.task_id activityobjectid
,a.auto_compute_act_flag autocomputeactuals
,CASE a.cost_load_type WHEN 'CL_Start' THEN 'Start of Activity' WHEN 'CL_End' THEN 'End of Activity' WHEN 'CL_Uniform' THEN 'Uniform over Activity' ELSE a.cost_load_type END accrualtype
,a.acct_id costaccountobjectid
,a.cost_type_id expensecategoryobjectid
,a.cbs_id cbsobjectid
,a.target_cost plannedcost
,a.act_cost actualcost
,a.remain_cost remainingcost
,a.qty_name unitofmeasure
,a.target_qty plannedunits
,a.cost_per_qty priceperunit
,a.po_number documentnumber
,a.vendor_name vendor
,a.cost_name expenseitem
,a.cost_descr expensedescription
,P.activityid activityid
,P.activityname activityname
,P.actualunits actualunits
,P.atcompletioncost atcompletioncost
,P.atcompletionunits atcompletionunits
,P.costaccountid costaccountid
,P.costaccountname costaccountname
,c.cbs_code cbscode
,c.description cbsname
,P.expensecategoryname expensecategoryname
,P.expensepercentcomplete expensepercentcomplete
,P.overbudget overbudget
,P.projectid projectid
,P.remainingunits remainingunits
,P.wbsobjectid wbsobjectid
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.PROJCOST A 
   INNER JOIN ${pm.or.administrative_user}.PROJCOSTX P
   ON a.cost_item_id = p.cost_item_id 
   LEFT OUTER  JOIN ${pm.or.administrative_user}.cbs c
   ON a.cbs_id = c.cbs_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view ACTIVITYNOTE

--METADATA NAME:ACTIVITYNOTE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYNOTE
AS SELECT a.memo_id objectid
,a.task_id activityobjectid
,a.memo_type_id notebooktopicobjectid
,a.proj_id projectobjectid
,a.task_memo note
,P.activityid activityid
,P.activityname activityname
,P.notebooktopicname notebooktopicname
,P.projectid projectid
,P.rawtextnote rawtextnote
,P.wbsobjectid wbsobjectid
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.TASKMEMO A 
   INNER JOIN ${pm.or.administrative_user}.TASKMEMOX P
   ON a.memo_id = p.memo_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view ACTIVITYPERIODACTUAL

--METADATA NAME:ACTIVITYPERIODACTUAL TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYPERIODACTUAL
AS SELECT a.fin_dates_id financialperiodobjectid
,fd.start_date startdate
,fd.end_date enddate
,a.task_id activityobjectid
,a.proj_id projectobjectid
,a.act_work_qty actuallaborunits
,a.act_work_cost actuallaborcost
,a.act_equip_qty actualnonlaborunits
,a.act_equip_cost actualnonlaborcost
,a.act_mat_cost actualmaterialcost
,a.act_expense_cost actualexpensecost
,a.bcwp earnedvaluecost
,a.sched_work_qty plannedvaluelaborunits
,a.bcws plannedvaluecost
,a.perfm_work_qty earnedvaluelaborunits
,P.wbsobjectid wbsobjectid
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.TASKFIN A 
   INNER JOIN ${pm.or.administrative_user}.TASKFINX P
   ON a.fin_dates_id = p.fin_dates_id and a.task_id = p.task_id
   INNER JOIN ${pm.or.administrative_user}.FINDATES FD
   ON a.fin_dates_id = fd.fin_dates_id  
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view ACTIVITYRISK

--METADATA NAME:ACTIVITYRISK TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYRISK
AS SELECT a.task_id activityobjectid
,a.proj_id projectobjectid
,a.risk_id riskobjectid
,P.projectid projectid
,P.projectname projectname
,P.activityid activityid
,P.activityname activityname
,P.riskname riskname
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.TASKRISK A 
   INNER JOIN ${pm.or.administrative_user}.TASKRISKX P
   ON a.task_id = p.task_id and a.risk_id = p.risk_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view ACTIVITYSTEP

--METADATA NAME:ACTIVITYSTEP TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYSTEP
AS SELECT a.proc_id objectid
,a.task_id activityobjectid
,a.seq_num sequencenumber
,a.proj_id projectobjectid
,a.complete_flag iscompleted
,a.proc_name name
,a.proc_wt weight
,a.complete_pct percentcomplete
,a.proc_descr description
,P.activityid activityid
,P.activityname activityname
,P.projectid projectid
,P.wbsobjectid wbsobjectid
,P.weightpercent weightpercent
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.TASKPROC A 
   INNER JOIN ${pm.or.administrative_user}.TASKPROCX P
   ON a.proc_id = p.proc_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view BASELINETYPE

--METADATA NAME:BASELINETYPE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW BASELINETYPE
AS SELECT a.base_type_id objectid
,a.base_type_seq_num sequencenumber
,a.base_type name
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.BASETYPE A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view CALENDAR

--METADATA NAME:CALENDAR TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW CALENDAR
AS SELECT a.clndr_id objectid
,a.default_flag isdefault
,a.clndr_name name
,a.proj_id projectobjectid
,a.base_clndr_id basecalendarobjectid
,a.last_chng_date lastchangedate
,CASE a.clndr_type WHEN 'CA_Base' THEN 'Global' WHEN 'CA_Project' THEN 'Project' WHEN 'CA_Rsrc' THEN 'Resource' ELSE a.clndr_type END type
,P.daydate daydate
,P.weekdaynumber weekdaynumber
,P.workdayflag workdayflag
,P.totalworkhours totalworkhours
,P.workhoursbyhalfhour workhoursbyhalfhour
,P.workdaystarttime workdaystarttime
,P.workdayfinishtime workdayfinishtime
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
 FROM ${pm.or.administrative_user}.CALENDAR A 
   INNER JOIN ${pm.or.administrative_user}.CALENDARX P
   ON a.clndr_id = p.clndr_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view CHANGESET

--METADATA NAME:CHANGESET TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW CHANGESET
AS SELECT a.transaction_id objectid
,a.transaction_date changedate
,a.request_user_name requestusername
,a.request_user_id requestuserobjectid
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.CHGHEAD A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view ACTIVITYUPDATE

--METADATA NAME:ACTIVITYUPDATE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYUPDATE
AS SELECT a.transaction_id changesetobjectid
,a.task_id activityobjectid
,a.proj_id projectobjectid
,P.changedate changedate
,CASE a.status_code WHEN 'PENDING' THEN 'Pending' WHEN 'HELD' THEN 'Held' WHEN 'APPROVED' THEN 'Approved' WHEN 'REJECTED' THEN 'Rejected' ELSE a.status_code END status
,a.new_act_start_date pendingactualstartdate
,a.ovr_act_start_date overrideactualstartdate
,a.new_act_end_date pendingactualfinishdate
,a.ovr_act_end_date overrideactualfinishdate
,a.new_remain_drtn pendingremainingduration
,a.ovr_remain_drtn overrideremainingduration
,a.new_complete_pct pendingpercentcomplete
,a.ovr_complete_pct overridepercentcomplete
,a.ovr_act_work_qty overrideactuallaborunits
,a.new_act_work_qty pendingactuallaborunits
,a.new_act_equip_qty pendingactualnonlaborunits
,a.ovr_act_equip_qty overrideactualnonlaborunits
,a.ovr_remain_work_qty overrideremaininglaborunits
,a.new_remain_work_qty pendingremaininglaborunits
,a.ovr_remain_equip_qty overrideremainingnonlaborunits
,a.new_remain_equip_qty pendingremainingnonlaborunits
,a.new_exp_end_date pendingexpectedfinishdate
,a.ovr_exp_end_date overrideexpectedfinishdate
,a.approval_date approvaldate
,a.approval_user_name approvalusername
,a.approval_user_id approvaluserobjectid
,a.held_date helddate
,P.requestusername requestusername
,P.requestuserobjectid requestuserobjectid
 FROM ${pm.or.administrative_user}.CHGTASK A 
   INNER JOIN ${pm.or.administrative_user}.CHGTASKX P
   ON a.transaction_id = p.transaction_id and a.task_id = p.task_id
/
     
prompt creating view ACTIVITYSTEPUPDATE

--METADATA NAME:ACTIVITYSTEPUPDATE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYSTEPUPDATE
AS SELECT a.transaction_id changesetobjectid
,a.proc_id activitystepobjectid
,CASE a.status_code WHEN 'PENDING' THEN 'Pending' WHEN 'HELD' THEN 'Held' WHEN 'APPROVED' THEN 'Approved' WHEN 'REJECTED' THEN 'Rejected' ELSE a.status_code END status
,P.changedate changedate
,a.proj_id projectobjectid
,a.task_id activityobjectid
,a.new_complete_pct pendingpercentcomplete
,a.ovr_complete_pct overridepercentcomplete
,a.approval_date approvaldate
,a.approval_user_name approvalusername
,a.approval_user_id approvaluserobjectid
,a.held_date helddate
,P.requestusername requestusername
,P.requestuserobjectid requestuserobjectid
,P.pendingstepname pendingstepname
,P.overridestepname overridestepname
 FROM ${pm.or.administrative_user}.CHGTASKPROC A 
   INNER JOIN ${pm.or.administrative_user}.CHGTASKPROCX P
   ON a.transaction_id = p.transaction_id and a.proc_id = p.proc_id
/
     
prompt creating view ACTIVITYSTEPCREATE

--METADATA NAME:ACTIVITYSTEPCREATE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYSTEPCREATE
AS SELECT a.proc_id activitystepobjectid
,a.transaction_id changesetobjectid
,a.task_id activityobjectid
,a.proj_id projectobjectid
,CASE a.status_code WHEN 'PENDING' THEN 'Pending' WHEN 'HELD' THEN 'Held' WHEN 'APPROVED' THEN 'Approved' WHEN 'REJECTED' THEN 'Rejected' ELSE a.status_code END status
,P.changedate changedate
,a.proc_name activitystepname
,a.complete_pct steppercentcomplete
,a.proc_wt stepweight
 FROM ${pm.or.administrative_user}.ADDTASKPROC A 
   INNER JOIN ${pm.or.administrative_user}.ADDTASKPROCX P
   ON a.proc_id = p.proc_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view ACTIVITYSTEPDEL

--METADATA NAME:ACTIVITYSTEPDEL TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYSTEPDEL
AS SELECT a.proc_id activitystepobjectid
,a.transaction_id changesetobjectid
,a.task_id activityobjectid
,a.proj_id projectobjectid
,P.changedate changedate
,a.proc_name activitystepname
 FROM ${pm.or.administrative_user}.DELTASKPROC A 
   INNER JOIN ${pm.or.administrative_user}.DELTASKPROCX P
   ON a.proc_id = p.proc_id and a.transaction_id = p.transaction_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view ACTIVITYCOMMENT

--METADATA NAME:ACTIVITYCOMMENT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYCOMMENT
AS SELECT a.discussion_id commentid
,a.task_id activityobjectid
,a.user_id userobjectid
,a.discussion_date commentdate
,a.discussion_value commenttext
 FROM ${pm.or.administrative_user}.DISCUSSION A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view ACTIVITYCODEUPDATE

--METADATA NAME:ACTIVITYCODEUPDATE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYCODEUPDATE
AS SELECT a.transaction_id changesetobjectid
,a.task_id activityobjectid
,a.actv_code_type_id activitycodetypeobjectid
,a.proj_id projectobjectid
,a.approval_user_id approvaluserobjectid
,P.changedate changedate
,CASE a.status_code WHEN 'PENDING' THEN 'Pending' WHEN 'HELD' THEN 'Held' WHEN 'APPROVED' THEN 'Approved' WHEN 'REJECTED' THEN 'Rejected' ELSE a.status_code END status
,a.ovr_actv_code_id overrideactivitycodeid
,a.new_actv_code_id pendingactivitycodeid
,P.requestuserobjectid requestuserobjectid
,a.approval_user_name approvalusername
,a.approval_date approvaldate
,a.held_date helddate
 FROM ${pm.or.administrative_user}.CHGTASKACTV A 
   INNER JOIN ${pm.or.administrative_user}.CHGTASKACTVX P
   ON a.transaction_id = p.transaction_id and a.task_id = p.task_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view USERDEFINEDVALUEUPDATE

--METADATA NAME:USERDEFINEDVALUEUPDATE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW USERDEFINEDVALUEUPDATE
AS SELECT a.transaction_id changesetobjectid
,a.udf_type_id udftypeobjectid
,a.fk_id foreignobjectid
,P.changedate changedate
,a.proj_id projectobjectid
,CASE a.status_code WHEN 'PENDING' THEN 'Pending' WHEN 'HELD' THEN 'Held' WHEN 'APPROVED' THEN 'Approved' WHEN 'REJECTED' THEN 'Rejected' WHEN 'PENDING' THEN 'Pending' WHEN 'HELD' THEN 'Held' WHEN 'APPROVED' THEN 'Approved' WHEN 'REJECTED' THEN 'Rejected' ELSE a.status_code END status
,CASE a.ovr_udf_text WHEN '' THEN '??enm.UDF_RAGType.??' WHEN 'UDF_G1' THEN 'Red' WHEN 'UDF_G2' THEN 'Yellow' WHEN 'UDF_G3' THEN 'Green' WHEN 'UDF_G4' THEN 'Blue' WHEN '' THEN '??enm.UDF_RAGType.??' WHEN 'UDF_G1' THEN 'Red' WHEN 'UDF_G2' THEN 'Yellow' WHEN 'UDF_G3' THEN 'Green' WHEN 'UDF_G4' THEN 'Blue' ELSE a.ovr_udf_text END overrideudftext
,CASE a.new_udf_text WHEN '' THEN '??enm.UDF_RAGType.??' WHEN 'UDF_G1' THEN 'Red' WHEN 'UDF_G2' THEN 'Yellow' WHEN 'UDF_G3' THEN 'Green' WHEN 'UDF_G4' THEN 'Blue' WHEN '' THEN '??enm.UDF_RAGType.??' WHEN 'UDF_G1' THEN 'Red' WHEN 'UDF_G2' THEN 'Yellow' WHEN 'UDF_G3' THEN 'Green' WHEN 'UDF_G4' THEN 'Blue' ELSE a.new_udf_text END pendingudftext
,a.ovr_udf_date overrideudfstartdate
,a.new_udf_date pendingudfstartdate
,a.ovr_udf_date overrideudfenddate
,a.new_udf_date pendingudfenddate
,a.ovr_udf_code_id overrideudfcodeid
,a.new_udf_code_id pendingudfcodeid
,P.overrideudfnumber overrideudfnumber
,P.pendingudfnumber pendingudfnumber
,P.overrideudfinteger overrideudfinteger
,P.pendingudfinteger pendingudfinteger
,P.overrideudfcost overrideudfcost
,P.pendingudfcost pendingudfcost
,P.requestuserobjectid requestuserobjectid
,a.approval_user_id approvaluserobjectid
,a.approval_user_name approvalusername
,a.approval_date approvaldate
,a.held_date helddate
 FROM ${pm.or.administrative_user}.CHGUDFVALUE A 
   INNER JOIN ${pm.or.administrative_user}.CHGUDFVALUEX P
   ON a.transaction_id = p.transaction_id and a.udf_type_id = p.udf_type_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view RESOURCEASSIGNMENTUPDATE

--METADATA NAME:RESOURCEASSIGNMENTUPDATE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCEASSIGNMENTUPDATE
AS SELECT a.transaction_id changesetobjectid
,a.taskrsrc_id resourceassignmentobjectid
,a.task_id activityobjectid
,P.changedate changedate
,CASE a.status_code WHEN 'PENDING' THEN 'Pending' WHEN 'HELD' THEN 'Held' WHEN 'APPROVED' THEN 'Approved' WHEN 'REJECTED' THEN 'Rejected' ELSE a.status_code END status
,a.proj_id projectobjectid
,a.new_act_start_date pendingactualstartdate
,a.ovr_act_start_date overrideactualstartdate
,a.new_act_end_date pendingactualfinishdate
,a.ovr_act_end_date overrideactualfinishdate
,a.ovr_act_reg_qty overrideactualunits
,a.new_act_reg_qty pendingactualunits
,a.ovr_remain_qty overrideremainingunits
,a.new_remain_qty pendingremainingunits
,a.new_remain_drtn pendingremainingduration
,a.ovr_remain_drtn overrideremainingduration
,a.approval_date approvaldate
,a.approval_user_name approvalusername
,a.approval_user_id approvaluserobjectid
,a.held_date helddate
,a.new_reend_date pendingremainingfinishdate
,a.ovr_reend_date overrideremainingfinishdate
,P.requestusername requestusername
,P.requestuserobjectid requestuserobjectid
 FROM ${pm.or.administrative_user}.CHGTRSRC A 
   INNER JOIN ${pm.or.administrative_user}.CHGTRSRCX P
   ON a.transaction_id = p.transaction_id and a.taskrsrc_id = p.taskrsrc_id
/
     
prompt creating view COSTACCOUNT

--METADATA NAME:COSTACCOUNT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW COSTACCOUNT
AS SELECT a.acct_id objectid
,a.acct_seq_num sequencenumber
,a.acct_short_name id
,a.acct_name name
,a.parent_acct_id parentobjectid
,a.acct_descr description
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.ACCOUNT A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view CURRENCY

--METADATA NAME:CURRENCY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW CURRENCY
AS SELECT a.curr_id objectid
,a.decimal_digit_cnt decimalplaces
,a.curr_symbol symbol
,CASE a.decimal_symbol WHEN '.' THEN 'Period' WHEN ',' THEN 'Comma' ELSE a.decimal_symbol END decimalsymbol
,CASE a.digit_group_symbol WHEN '.' THEN 'Period' WHEN ',' THEN 'Comma' ELSE a.digit_group_symbol END digitgroupingsymbol
,CASE a.pos_curr_fmt_type WHEN '#1.1' THEN '#1.1' WHEN '1.1#' THEN '1.1#' WHEN '# 1.1' THEN '# 1.1' WHEN '1.1 #' THEN '1.1 #' ELSE a.pos_curr_fmt_type END positivesymbol
,CASE a.neg_curr_fmt_type WHEN '(#1.1)' THEN '(#1.1)' WHEN '-#1.1' THEN '-#1.1' WHEN '#-1.1' THEN '#-1.1' WHEN '#1.1-' THEN '#1.1-' WHEN '(1.1#)' THEN '(1.1#)' WHEN '-1.1#' THEN '-1.1#' WHEN '1.1-#' THEN '1.1-#' WHEN '1.1#-' THEN '1.1#-' WHEN '-1.1 #' THEN '-1.1 #' WHEN '-# 1.1' THEN '-# 1.1' WHEN '1.1 #-' THEN '1.1 #-' WHEN '# 1.1-' THEN '# 1.1-' WHEN '# -1.1' THEN '# -1.1' WHEN '1.1- #' THEN '1.1- #' WHEN '(# 1.1)' THEN '(# 1.1)' WHEN '(1.1 #)' THEN '(1.1 #)' ELSE a.neg_curr_fmt_type END negativesymbol
,a.curr_type name
,a.curr_short_name id
,a.base_exch_rate exchangerate
,P.isbasecurrency isbasecurrency
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.CURRTYPE A 
   INNER JOIN ${pm.or.administrative_user}.CURRTYPEX P
   ON a.curr_id = p.curr_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view DOCUMENT

--METADATA NAME:DOCUMENT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW DOCUMENT
AS SELECT a.doc_id objectid
,a.doc_seq_num sequencenumber
,a.deliv_flag deliverable
,a.doc_name title
,a.parent_doc_id parentobjectid
,a.proj_id projectobjectid
,a.doc_status_id documentstatuscodeobjectid
,a.doc_catg_id documentcategoryobjectid
,a.doc_date revisiondate
,a.version_name version
,a.doc_short_name referencenumber
,a.author_name author
,a.private_loc privatelocation
,a.public_loc publiclocation
,a.rsrc_id resourceobjectid
,a.doc_mgmt_type documenttype
,P.documentcategoryname documentcategoryname
,P.documentstatuscodename documentstatuscodename
,P.projectid projectid
,P.resourceid resourceid
,P.resourcename resourcename
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.DOCUMENT A 
   INNER JOIN ${pm.or.administrative_user}.DOCUMENTX P
   ON a.doc_id = p.doc_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view DOCUMENTCATEGORY

--METADATA NAME:DOCUMENTCATEGORY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW DOCUMENTCATEGORY
AS SELECT a.doc_catg_id objectid
,a.seq_num sequencenumber
,a.doc_catg_name name
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.DOCCATG A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view DOCUMENTSTATUSCODE

--METADATA NAME:DOCUMENTSTATUSCODE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW DOCUMENTSTATUSCODE
AS SELECT a.doc_status_id objectid
,a.seq_num sequencenumber
,a.doc_status_code name
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.DOCSTAT A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view EPS

--METADATA NAME:EPS TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW EPS
AS SELECT a.wbs_id objectid
,a.proj_id projectobjectid
,a.obs_id obsobjectid
,a.seq_num sequencenumber
,a.wbs_name name
,a.parent_wbs_id parentobjectid
,a.orig_cost originalbudget
,a.indep_remain_total_cost independentetctotalcost
,a.indep_remain_work_qty independentetclaborunits
,a.anticip_start_date anticipatedstartdate
,a.anticip_end_date anticipatedfinishdate
,P.currentbudget currentbudget
,P.currentvariance currentvariance
,P.distributedcurrentbudget distributedcurrentbudget
,P.finishdate finishdate
,P.fullname fullname
,P.id id
,P.lastsummarizeddate lastsummarizeddate
,P.obsname obsname
,P.plannedstartdate plannedstartdate
,P.proposedbudget proposedbudget
,P.startdate startdate
,P.sumplannedstartdate sumplannedstartdate
,P.sumplannedfinishdate sumplannedfinishdate
,P.sumplannedduration sumplannedduration
,P.sumplannedlaborunits sumplannedlaborunits
,P.sumplannednonlaborunits sumplannednonlaborunits
,P.sumplannedexpensecost sumplannedexpensecost
,P.sumplannedlaborcost sumplannedlaborcost
,P.sumplannedmaterialcost sumplannedmaterialcost
,P.sumplannednonlaborcost sumplannednonlaborcost
,P.sumplannedtotalcost sumplannedtotalcost
,P.sumaccountingvarbylaborunits sumaccountingvarbylaborunits
,P.sumaccountingvariancebycost sumaccountingvariancebycost
,P.sumactthisperiodmaterialcost sumactthisperiodmaterialcost
,P.sumactthisperiodnonlaborcost sumactthisperiodnonlaborcost
,P.sumactthisperiodnonlaborunits sumactthisperiodnonlaborunits
,P.sumactualthisperiodlaborcost sumactualthisperiodlaborcost
,P.sumactualthisperiodlaborunits sumactualthisperiodlaborunits
,P.sumatcompletionmaterialcost sumatcompletionmaterialcost
,P.sumatcompletionnonlaborcost sumatcompletionnonlaborcost
,P.sumatcompletionnonlaborunits sumatcompletionnonlaborunits
,P.sumatcompletiontotalcostvar sumatcompletiontotalcostvar
,P.sumbaselinecompactivitycount sumbaselinecompactivitycount
,P.sumbaselinenotstartedactcnt sumbaselinenotstartedactcnt
,P.sumblinprogressactivitycount sumblinprogressactivitycount
,P.sumbudgetatcmpbylaborunits sumbudgetatcmpbylaborunits
,P.sumbudgetatcompletionbycost sumbudgetatcompletionbycost
,P.sumcostperfindexbycost sumcostperfindexbycost
,P.sumcostperfindexbylaborunits sumcostperfindexbylaborunits
,P.sumcostvariancebylaborunits sumcostvariancebylaborunits
,P.sumcostvarindexbylaborunits sumcostvarindexbylaborunits
,P.sumdurationpercentofplanned sumdurationpercentofplanned
,P.sumeacbycost sumeacbycost
,P.sumeacbylaborunits sumeacbylaborunits
,P.sumeachighpctbylaborunits sumeachighpctbylaborunits
,P.sumeaclowpctbylaborunits sumeaclowpctbylaborunits
,P.sumetcbycost sumetcbycost
,P.sumetcbylaborunits sumetcbylaborunits
,P.sumexpensecostpctcomplete sumexpensecostpctcomplete
,P.sumlaborcostpercentcomplete sumlaborcostpercentcomplete
,P.sumlaborunitspercentcomplete sumlaborunitspercentcomplete
,P.sumactivitycount sumactivitycount
,P.sumactualduration sumactualduration
,P.sumactualexpensecost sumactualexpensecost
,P.sumactualfinishdate sumactualfinishdate
,P.sumactuallaborcost sumactuallaborcost
,P.sumactuallaborunits sumactuallaborunits
,P.sumactualmaterialcost sumactualmaterialcost
,P.sumactualnonlaborcost sumactualnonlaborcost
,P.sumactualnonlaborunits sumactualnonlaborunits
,P.sumactualstartdate sumactualstartdate
,P.sumactualthisperiodcost sumactualthisperiodcost
,P.sumactualtotalcost sumactualtotalcost
,P.sumactualvaluebycost sumactualvaluebycost
,P.sumactualvaluebylaborunits sumactualvaluebylaborunits
,P.sumatcompletionduration sumatcompletionduration
,P.sumatcompletionexpensecost sumatcompletionexpensecost
,P.sumatcompletionlaborcost sumatcompletionlaborcost
,P.sumatcompletionlaborunits sumatcompletionlaborunits
,P.sumatcompletiontotalcost sumatcompletiontotalcost
,P.sumbaselineduration sumbaselineduration
,P.sumbaselineexpensecost sumbaselineexpensecost
,P.sumbaselinefinishdate sumbaselinefinishdate
,P.sumbaselinelaborcost sumbaselinelaborcost
,P.sumbaselinelaborunits sumbaselinelaborunits
,P.sumbaselinematerialcost sumbaselinematerialcost
,P.sumbaselinenonlaborcost sumbaselinenonlaborcost
,P.sumbaselinenonlaborunits sumbaselinenonlaborunits
,P.sumbaselinestartdate sumbaselinestartdate
,P.sumbaselinetotalcost sumbaselinetotalcost
,P.sumcompletedactivitycount sumcompletedactivitycount
,P.sumcostpercentcomplete sumcostpercentcomplete
,P.sumcostpercentofplanned sumcostpercentofplanned
,P.sumcostvariancebycost sumcostvariancebycost
,P.sumcostvarianceindex sumcostvarianceindex
,P.sumcostvarianceindexbycost sumcostvarianceindexbycost
,P.sumdurationpercentcomplete sumdurationpercentcomplete
,P.sumdurationvariance sumdurationvariance
,P.sumearnedvaluebycost sumearnedvaluebycost
,P.sumearnedvaluebylaborunits sumearnedvaluebylaborunits
,P.sumexpensecostvariance sumexpensecostvariance
,P.sumfinishdatevariance sumfinishdatevariance
,P.suminprogressactivitycount suminprogressactivitycount
,P.sumlaborcostvariance sumlaborcostvariance
,P.sumlaborunitsvariance sumlaborunitsvariance
,P.summaterialcostvariance summaterialcostvariance
,P.sumnonlaborcostvariance sumnonlaborcostvariance
,P.sumnonlaborunitsvariance sumnonlaborunitsvariance
,P.sumnotstartedactivitycount sumnotstartedactivitycount
,P.sumplannedvaluebycost sumplannedvaluebycost
,P.sumprogressfinishdate sumprogressfinishdate
,P.sumremainingduration sumremainingduration
,P.sumremainingexpensecost sumremainingexpensecost
,P.sumremainingfinishdate sumremainingfinishdate
,P.sumremaininglaborcost sumremaininglaborcost
,P.sumremaininglaborunits sumremaininglaborunits
,P.sumremainingmaterialcost sumremainingmaterialcost
,P.sumremainingnonlaborcost sumremainingnonlaborcost
,P.sumremainingnonlaborunits sumremainingnonlaborunits
,P.sumremainingstartdate sumremainingstartdate
,P.sumremainingtotalcost sumremainingtotalcost
,P.sumschedulepercentcomplete sumschedulepercentcomplete
,P.sumperformancepercentcomplete sumperformancepercentcomplete
,P.sumschedulevariancebycost sumschedulevariancebycost
,P.sumschedulevarianceindex sumschedulevarianceindex
,P.sumstartdatevariance sumstartdatevariance
,P.sumtotalcostvariance sumtotalcostvariance
,P.sumtotalfloat sumtotalfloat
,P.sumunitspercentcomplete sumunitspercentcomplete
,P.summaterialcostpctcomplete summaterialcostpctcomplete
,P.sumnonlaborcostpctcomplete sumnonlaborcostpctcomplete
,P.sumnonlaborunitspctcomplete sumnonlaborunitspctcomplete
,P.sumperfpctcmpbylaborunits sumperfpctcmpbylaborunits
,P.sumplannedvaluebylaborunits sumplannedvaluebylaborunits
,P.sumschdpctcmpbylaborunits sumschdpctcmpbylaborunits
,P.sumschdperfindexbylaborunits sumschdperfindexbylaborunits
,P.sumschdvariancebylaborunits sumschdvariancebylaborunits
,P.sumschdvarianceindexbycost sumschdvarianceindexbycost
,P.sumschdvarindexbylaborunits sumschdvarindexbylaborunits
,P.sumscheduleperfindexbycost sumscheduleperfindexbycost
,P.sumtocompleteperfindexbycost sumtocompleteperfindexbycost
,P.sumvaratcmpbylaborunits sumvaratcmpbylaborunits
,P.totalbenefitplan totalbenefitplan
,P.totalbenefitplantally totalbenefitplantally
,P.totalfunding totalfunding
,P.totalspendingplan totalspendingplan
,P.totalspendingplantally totalspendingplantally
,P.unallocatedbudget unallocatedbudget
,P.undistributedcurrentvariance undistributedcurrentvariance
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
,P.update_dim_date lastupdatedatex
 FROM ${pm.or.administrative_user}.PROJWBS A 
   INNER JOIN ${pm.or.administrative_user}.PROJWBSX P
   ON a.wbs_id = p.wbs_id 
   INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab
   ON a.proj_id = projects_tab.proj_id and projects_tab.PROJECT_FLAG = 'N'
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view EPSBUDGETCHANGELOG

--METADATA NAME:EPSBUDGETCHANGELOG TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW EPSBUDGETCHANGELOG
AS SELECT a.budg_chng_id objectid
,a.proj_id projectobjectid
,a.wbs_id epsobjectid
,a.chng_date epsbudgetchangelogdate
,a.chng_short_name changenumber
,a.chng_cost amount
,a.chng_by_name responsible
,CASE a.status_code WHEN 'BC_Pending' THEN 'Pending' WHEN 'BC_Approved' THEN 'Approved' WHEN 'BC_NotApproved' THEN 'Not Approved' WHEN 'BC_Pending' THEN 'Pending' WHEN 'BC_Approved' THEN 'Approved' WHEN 'BC_NotApproved' THEN 'Not Approved' ELSE a.status_code END status
,a.chng_descr reason
,P.epsid epsid
,P.epsname epsname
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.BUDGCHNG A 
   INNER JOIN ${pm.or.administrative_user}.BUDGCHNGX P
   ON a.budg_chng_id = p.budg_chng_id 
   INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab
   ON a.proj_id = projects_tab.proj_id and projects_tab.PROJECT_FLAG = 'N'
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view EPSFUNDING

--METADATA NAME:EPSFUNDING TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW EPSFUNDING
AS SELECT a.proj_fund_id objectid
,a.fund_id fundingsourceobjectid
,a.proj_id projectobjectid
,a.fund_cost amount
,a.fund_wt fundshare
,P.epsid epsid
,P.epsname epsname
,P.epsobjectid epsobjectid
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.PROJFUND A 
   INNER JOIN ${pm.or.administrative_user}.PROJFUNDX P
   ON a.proj_fund_id = p.proj_fund_id 
   INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab
   ON a.proj_id = projects_tab.proj_id and projects_tab.PROJECT_FLAG = 'N'
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view EPSNOTE

--METADATA NAME:EPSNOTE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW EPSNOTE
AS SELECT a.wbs_memo_id objectid
,a.proj_id projectobjectid
,a.memo_type_id notebooktopicobjectid
,a.wbs_memo note
,P.epsid epsid
,P.epsname epsname
,P.epsobjectid epsobjectid
,P.notebooktopicname notebooktopicname
,P.rawtextnote rawtextnote
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.WBSMEMO A 
   INNER JOIN ${pm.or.administrative_user}.WBSMEMOX P
   ON a.wbs_memo_id = p.wbs_memo_id 
   INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab
   ON a.proj_id = projects_tab.proj_id and projects_tab.PROJECT_FLAG = 'N'
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view EPSSPENDINGPLAN

--METADATA NAME:EPSSPENDINGPLAN TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW EPSSPENDINGPLAN
AS SELECT a.wbs_budg_id objectid
,a.proj_id projectobjectid
,a.spend_cost spendingplan
,a.benefit_cost benefitplan
,a.start_date spendingplandate
,P.epsid epsid
,P.epsname epsname
,P.epsobjectid epsobjectid
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.WBSBUDG A 
   INNER JOIN ${pm.or.administrative_user}.WBSBUDGX P
   ON a.wbs_budg_id = p.wbs_budg_id 
   INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab
   ON a.proj_id = projects_tab.proj_id and projects_tab.PROJECT_FLAG = 'N'
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view EXPENSECATEGORY

--METADATA NAME:EXPENSECATEGORY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW EXPENSECATEGORY
AS SELECT a.cost_type_id objectid
,a.seq_num sequencenumber
,a.cost_type name
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.COSTTYPE A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view FINANCIALPERIOD

--METADATA NAME:FINANCIALPERIOD TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW FINANCIALPERIOD
AS SELECT a.fin_dates_id objectid
,a.fin_dates_name name
,a.start_date startdate
,a.end_date enddate
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.FINDATES A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view FUNDINGSOURCE

--METADATA NAME:FUNDINGSOURCE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW FUNDINGSOURCE
AS SELECT a.fund_id objectid
,a.seq_num sequencenumber
,a.fund_name name
,a.parent_fund_id parentobjectid
,a.fund_descr description
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.FUNDSRC A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view GLOBALPROFILE

--METADATA NAME:GLOBALPROFILE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW GLOBALPROFILE
AS SELECT a.prof_id objectid
,a.default_flag isdefault
,a.superuser_flag issuperuser
,a.prof_name name
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.PROFILE A
WHERE A.DELETE_SESSION_ID is null 
AND SCOPE_TYPE = 'ST_Global'
     
/
     
prompt creating view ISSUEHISTORY

--METADATA NAME:ISSUEHISTORY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ISSUEHISTORY
AS SELECT a.issue_id projectissueobjectid
,a.proj_id projectobjectid
,a.issue_history notes
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.ISSUHIST A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view ITERATION

--METADATA NAME:ITERATION TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ITERATION
AS SELECT a.iteration_id objectid
,a.iteration_name name
,a.start_date startdate
,a.end_date enddate
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.ITERATION A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view ITERATIONACTIVITY

--METADATA NAME:ITERATIONACTIVITY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ITERATIONACTIVITY
AS SELECT a.iteration_id iterationobjectid
,a.task_id activityobjectid
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.ITERTASK A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view ITERATIONTEAM

--METADATA NAME:ITERATIONTEAM TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ITERATIONTEAM
AS SELECT a.iteration_id iterationobjectid
,a.rfolio_id resourceteamobjectid
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.ITERTEAM A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view LOCATION

--METADATA NAME:LOCATION TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW LOCATION
AS SELECT a.location_id objectid
,a.location_name locationname
,a.location_type locationtype
,a.address_line1 addressline1
,a.address_line2 addressline2
,a.address_line3 addressline3
,a.city_name city
,a.municipality_name municipality
,a.state_name state
,a.state_code statecode
,a.country_name country
,a.country_code countrycode
,a.postal_code postalcode
,a.longitude longitude
,a.latitude latitude
,a.geo_location geolocation
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.LOCATION A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view NOTEBOOKTOPIC

--METADATA NAME:NOTEBOOKTOPIC TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW NOTEBOOKTOPIC
AS SELECT a.memo_type_id objectid
,a.seq_num sequencenumber
,a.eps_flag availableforeps
,a.proj_flag availableforproject
,a.wbs_flag availableforwbs
,a.task_flag availableforactivity
,a.memo_type name
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.MEMOTYPE A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view OBS

--METADATA NAME:OBS TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW OBS
AS SELECT a.obs_id objectid
,a.seq_num sequencenumber
,a.obs_name name
,a.parent_obs_id parentobjectid
,a.obs_descr description
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.OBS A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view OVERHEADCODE

--METADATA NAME:OVERHEADCODE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW OVERHEADCODE
AS SELECT a.nonwork_type_id objectid
,a.seq_num sequencenumber
,a.nonwork_code name
,a.nonwork_type description
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.NONWORK A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view PROJECT

--METADATA NAME:PROJECT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECT
AS SELECT a.proj_id objectid
,a.proj_short_name id
,a.fy_start_month_num fiscalyearstartmonth
,a.chng_eff_cmp_pct_flag resourcescaneditasgnmtpctcmp
,a.rsrc_self_add_flag resourcescanselfassigntoacts
,a.allow_complete_flag primaryrescanmarkactsascmp
,a.rsrc_multi_assign_flag resourcecanassigntosameact
,a.checkout_flag checkoutstatus
,a.step_complete_flag activitypctcmpbasedonsteps
,a.cost_qty_recalc_flag costquantityrecalculateflag
,a.sum_only_flag containssummarydataonly
,a.batch_sum_flag enablesummarization
,a.name_sep_char wbscodeseparator
,CASE a.def_complete_pct_type WHEN 'CP_Phys' THEN 'Physical' WHEN 'CP_Drtn' THEN 'Duration' WHEN 'CP_Units' THEN 'Units' WHEN 'CP_Scope' THEN 'Scope' WHEN 'CP_Phys' THEN 'Physical' WHEN 'CP_Drtn' THEN 'Duration' WHEN 'CP_Units' THEN 'Units' WHEN 'CP_Scope' THEN 'Scope' ELSE a.def_complete_pct_type END activitydefaultpctcmptype
,a.acct_id activitydefcostacctobjectid
,a.clndr_id activitydefcalendarobjectid
,a.sum_base_proj_id currentbaselineprojectobjectid
,a.task_code_base activityidsuffix
,a.task_code_step activityidincrement
,a.priority_num levelingpriority
,a.wbs_max_sum_level summarizetowbslevel
,a.strgy_priority_num strategicpriority
,a.critical_drtn_hr_cnt criticalactivityfloatlimit
,a.def_cost_per_qty activitydefaultpriceperunit
,a.plan_start_date plannedstartdate
,a.plan_end_date mustfinishbydate
,a.scd_end_date scheduledfinishdate
,a.add_date dateadded
,a.sum_data_date summarizeddatadate
,a.last_tasksum_date lastsummarizeddate
,a.fcst_start_date projectforecaststartdate
,CASE a.def_duration_type WHEN 'DT_FixedRate' THEN 'Fixed Units/Time' WHEN 'DT_FixedDrtn' THEN 'Fixed Duration & Units/Time' WHEN 'DT_FixedQty' THEN 'Fixed Units' WHEN 'DT_FixedDUR2' THEN 'Fixed Duration & Units' WHEN 'DT_FixedRate' THEN 'Fixed Units/Time' WHEN 'DT_FixedDrtn' THEN 'Fixed Duration & Units/Time' WHEN 'DT_FixedQty' THEN 'Fixed Units' WHEN 'DT_FixedDUR2' THEN 'Fixed Duration & Units' ELSE a.def_duration_type END activitydefaultdurationtype
,a.task_code_prefix activityidprefix
,CASE a.def_qty_type WHEN 'QT_Hour' THEN 'Hour' WHEN 'QT_Day' THEN 'Day' WHEN 'QT_Week' THEN 'Week' WHEN 'QT_Month' THEN 'Month' WHEN 'QT_Year' THEN 'Year' WHEN 'QT_DaysHours' THEN '??enm.UnitType.QT_DaysHours??' WHEN 'QT_HoursMinutes' THEN '??enm.UnitType.QT_HoursMinutes??' WHEN 'QT_Hour' THEN 'Hour' WHEN 'QT_Day' THEN 'Day' WHEN 'QT_Week' THEN 'Week' WHEN 'QT_Month' THEN 'Month' WHEN 'QT_Year' THEN 'Year' WHEN 'QT_DaysHours' THEN '??enm.UnitType.QT_DaysHours??' WHEN 'QT_HoursMinutes' THEN '??enm.UnitType.QT_HoursMinutes??' ELSE a.def_qty_type END defaultpricetimeunits
,a.add_by_name addedby
,a.web_local_root_path websiterootdirectory
,a.proj_url websiteurl
,CASE a.def_rate_type WHEN 'COST_PER_QTY' THEN 'Cost Per Qty' WHEN 'COST_PER_QTY2' THEN 'CostPerQty2' WHEN 'COST_PER_QTY3' THEN 'CostPerQty3' WHEN 'COST_PER_QTY4' THEN 'CostPerQty4' WHEN 'COST_PER_QTY5' THEN 'CostPerQty5' WHEN 'COST_PER_QTY' THEN 'Cost Per Qty' WHEN 'COST_PER_QTY2' THEN 'CostPerQty2' WHEN 'COST_PER_QTY3' THEN 'CostPerQty3' WHEN 'COST_PER_QTY4' THEN 'CostPerQty4' WHEN 'COST_PER_QTY5' THEN 'CostPerQty5' ELSE a.def_rate_type END assignmentdefaultratetype
,a.act_this_per_link_flag linkactualtoactualthisperiod
,CASE a.def_task_type WHEN 'TT_Task' THEN 'Task Dependent' WHEN 'TT_Rsrc' THEN 'Resource Dependent' WHEN 'TT_LOE' THEN 'Level Of Effort' WHEN 'TT_Mile' THEN 'Start Milestone' WHEN 'TT_FinMile' THEN 'Finish Milestone' WHEN 'TT_WBS' THEN 'WBS Summary' WHEN 'TT_Task' THEN 'Task Dependent' WHEN 'TT_Rsrc' THEN 'Resource Dependent' WHEN 'TT_LOE' THEN 'Level Of Effort' WHEN 'TT_Mile' THEN 'Start Milestone' WHEN 'TT_FinMile' THEN 'Finish Milestone' WHEN 'TT_WBS' THEN 'WBS Summary' ELSE a.def_task_type END activitydefaultactivitytype
,a.act_pct_link_flag linkpercentcompletewithactual
,a.add_act_remain_flag addactualtoremaining
,CASE a.critical_path_type WHEN 'CT_TotFloat' THEN 'Critical Float' WHEN 'CT_DrivPath' THEN 'Longest Path' WHEN 'CT_TotFloat' THEN 'Critical Float' WHEN 'CT_DrivPath' THEN 'Longest Path' ELSE a.critical_path_type END criticalactivitypathtype
,a.task_code_prefix_flag activityidbasedonselactivity
,a.def_rollup_dates_flag assignmentdefaultdrivingflag
,a.rem_target_link_flag linkplannedandatcompletionflag
,a.reset_planned_flag resetplannedtoremainingflag
,a.allow_neg_act_flag allownegativeactualunitsflag
,a.rsrc_id ownerresourceobjectid
,a.checkout_date checkoutdate
,a.checkout_user_id checkoutuserobjectid
,a.last_fin_dates_id lastfinancialperiodobjectid
,a.use_project_baseline_flag useprojectblforearnedvalue
,P.annualdiscountrate annualdiscountrate
,P.anticipatedfinishdate anticipatedfinishdate
,P.anticipatedstartdate anticipatedstartdate
,P.containssummarydata containssummarydata
,P.currentbudget currentbudget
,P.currentvariance currentvariance
,P.datadate datadate
,P.discountapplicationperiod discountapplicationperiod
,P.distributedcurrentbudget distributedcurrentbudget
,P.earnedvaluecomputetype earnedvaluecomputetype
,P.earnedvalueetccomputetype earnedvalueetccomputetype
,P.earnedvalueetcuservalue earnedvalueetcuservalue
,P.earnedvalueuserpercent earnedvalueuserpercent
,P.finishdate finishdate
,P.forecastfinishdate forecastfinishdate
,P.forecaststartdate forecaststartdate
,P.independentetclaborunits independentetclaborunits
,P.independentetctotalcost independentetctotalcost
,P.name name
,P.obsname obsname
,P.obsobjectid obsobjectid
,P.originalbudget originalbudget
,P.overallprojectscore overallprojectscore
,P.parentepsobjectid parentepsobjectid
,P.proposedbudget proposedbudget
,P.risklevel risklevel
,P.riskscore riskscore
,P.riskexposure riskexposure
,P.startdate startdate
,P.status status
,a.orig_proj_id originalprojectobjectid
,a.matrix_id riskscorematrixobjectid
,P.sumplannedstartdate sumplannedstartdate
,P.sumplannedfinishdate sumplannedfinishdate
,P.sumplannedduration sumplannedduration
,P.sumplannedlaborunits sumplannedlaborunits
,P.sumplannednonlaborunits sumplannednonlaborunits
,P.sumplannedexpensecost sumplannedexpensecost
,P.sumplannedlaborcost sumplannedlaborcost
,P.sumplannedmaterialcost sumplannedmaterialcost
,P.sumplannednonlaborcost sumplannednonlaborcost
,P.sumplannedtotalcost sumplannedtotalcost
,P.sumaccountingvarbylaborunits sumaccountingvarbylaborunits
,P.sumaccountingvariancebycost sumaccountingvariancebycost
,P.sumactthisperiodmaterialcost sumactthisperiodmaterialcost
,P.sumactthisperiodnonlaborcost sumactthisperiodnonlaborcost
,P.sumactthisperiodnonlaborunits sumactthisperiodnonlaborunits
,P.sumactualthisperiodlaborcost sumactualthisperiodlaborcost
,P.sumactualthisperiodlaborunits sumactualthisperiodlaborunits
,P.sumatcompletionmaterialcost sumatcompletionmaterialcost
,P.sumatcompletionnonlaborcost sumatcompletionnonlaborcost
,P.sumatcompletionnonlaborunits sumatcompletionnonlaborunits
,P.sumatcompletiontotalcostvar sumatcompletiontotalcostvar
,P.sumbaselinecompactivitycount sumbaselinecompactivitycount
,P.sumbaselinenotstartedactcnt sumbaselinenotstartedactcnt
,P.sumblinprogressactivitycount sumblinprogressactivitycount
,P.sumbudgetatcmpbylaborunits sumbudgetatcmpbylaborunits
,P.sumbudgetatcompletionbycost sumbudgetatcompletionbycost
,P.sumcostperfindexbycost sumcostperfindexbycost
,P.sumcostperfindexbylaborunits sumcostperfindexbylaborunits
,P.sumcostvariancebylaborunits sumcostvariancebylaborunits
,P.sumcostvarindexbylaborunits sumcostvarindexbylaborunits
,P.sumdurationpercentofplanned sumdurationpercentofplanned
,P.sumeacbycost sumeacbycost
,P.sumeacbylaborunits sumeacbylaborunits
,P.sumeachighpctbylaborunits sumeachighpctbylaborunits
,P.sumeaclowpctbylaborunits sumeaclowpctbylaborunits
,P.sumetcbycost sumetcbycost
,P.sumetcbylaborunits sumetcbylaborunits
,P.sumexpensecostpctcomplete sumexpensecostpctcomplete
,P.sumlaborcostpercentcomplete sumlaborcostpercentcomplete
,P.sumlaborunitspercentcomplete sumlaborunitspercentcomplete
,P.sumactivitycount sumactivitycount
,P.sumactualduration sumactualduration
,P.sumactualexpensecost sumactualexpensecost
,P.sumactualfinishdate sumactualfinishdate
,P.summaxactualfinishdate summaxactualfinishdate
,P.summaxrestartdate summaxrestartdate
,P.sumactuallaborcost sumactuallaborcost
,P.sumactuallaborunits sumactuallaborunits
,P.sumactualmaterialcost sumactualmaterialcost
,P.sumactualnonlaborcost sumactualnonlaborcost
,P.sumactualnonlaborunits sumactualnonlaborunits
,P.sumactualstartdate sumactualstartdate
,P.sumactualthisperiodcost sumactualthisperiodcost
,P.sumactualtotalcost sumactualtotalcost
,P.sumactualvaluebycost sumactualvaluebycost
,P.sumactualvaluebylaborunits sumactualvaluebylaborunits
,P.sumatcompletionduration sumatcompletionduration
,P.sumatcompletionexpensecost sumatcompletionexpensecost
,P.sumatcompletionlaborcost sumatcompletionlaborcost
,P.sumatcompletionlaborunits sumatcompletionlaborunits
,P.sumatcompletiontotalcost sumatcompletiontotalcost
,P.sumbaselineduration sumbaselineduration
,P.sumbaselineexpensecost sumbaselineexpensecost
,P.sumbaselinefinishdate sumbaselinefinishdate
,P.sumbaselinelaborcost sumbaselinelaborcost
,P.sumbaselinelaborunits sumbaselinelaborunits
,P.sumbaselinematerialcost sumbaselinematerialcost
,P.sumbaselinenonlaborcost sumbaselinenonlaborcost
,P.sumbaselinenonlaborunits sumbaselinenonlaborunits
,P.sumbaselinestartdate sumbaselinestartdate
,P.sumbaselinetotalcost sumbaselinetotalcost
,P.sumcompletedactivitycount sumcompletedactivitycount
,P.sumcostpercentcomplete sumcostpercentcomplete
,P.sumcostpercentofplanned sumcostpercentofplanned
,P.sumcostvariancebycost sumcostvariancebycost
,P.sumcostvarianceindex sumcostvarianceindex
,P.sumcostvarianceindexbycost sumcostvarianceindexbycost
,P.sumdurationpercentcomplete sumdurationpercentcomplete
,P.sumdurationvariance sumdurationvariance
,P.sumearnedvaluebycost sumearnedvaluebycost
,P.sumearnedvaluebylaborunits sumearnedvaluebylaborunits
,P.sumexpensecostvariance sumexpensecostvariance
,P.sumfinishdatevariance sumfinishdatevariance
,P.suminprogressactivitycount suminprogressactivitycount
,P.sumlaborcostvariance sumlaborcostvariance
,P.sumlaborunitsvariance sumlaborunitsvariance
,P.summaterialcostvariance summaterialcostvariance
,P.sumnonlaborcostvariance sumnonlaborcostvariance
,P.sumnonlaborunitsvariance sumnonlaborunitsvariance
,P.sumnotstartedactivitycount sumnotstartedactivitycount
,P.sumplannedvaluebycost sumplannedvaluebycost
,P.sumprogressfinishdate sumprogressfinishdate
,P.sumremainingduration sumremainingduration
,P.sumremainingexpensecost sumremainingexpensecost
,P.sumremainingfinishdate sumremainingfinishdate
,P.sumremaininglaborcost sumremaininglaborcost
,P.sumremaininglaborunits sumremaininglaborunits
,P.sumremainingmaterialcost sumremainingmaterialcost
,P.sumremainingnonlaborcost sumremainingnonlaborcost
,P.sumremainingnonlaborunits sumremainingnonlaborunits
,P.sumremainingstartdate sumremainingstartdate
,P.sumremainingtotalcost sumremainingtotalcost
,P.sumschedulepercentcomplete sumschedulepercentcomplete
,P.sumperformancepercentcomplete sumperformancepercentcomplete
,P.sumschedulevariancebycost sumschedulevariancebycost
,P.sumschedulevarianceindex sumschedulevarianceindex
,P.sumstartdatevariance sumstartdatevariance
,P.sumtotalcostvariance sumtotalcostvariance
,P.sumtotalfloat sumtotalfloat
,P.sumunitspercentcomplete sumunitspercentcomplete
,P.summaterialcostpctcomplete summaterialcostpctcomplete
,P.sumnonlaborcostpctcomplete sumnonlaborcostpctcomplete
,P.sumnonlaborunitspctcomplete sumnonlaborunitspctcomplete
,P.sumperfpctcmpbylaborunits sumperfpctcmpbylaborunits
,P.sumplannedvaluebylaborunits sumplannedvaluebylaborunits
,P.sumschdpctcmpbylaborunits sumschdpctcmpbylaborunits
,P.sumschdperfindexbylaborunits sumschdperfindexbylaborunits
,P.sumschdvariancebylaborunits sumschdvariancebylaborunits
,P.sumschdvarianceindexbycost sumschdvarianceindexbycost
,P.sumschdvarindexbylaborunits sumschdvarindexbylaborunits
,P.sumscheduleperfindexbycost sumscheduleperfindexbycost
,P.sumtocompleteperfindexbycost sumtocompleteperfindexbycost
,P.sumvaratcmpbylaborunits sumvaratcmpbylaborunits
,P.sumearlystartdate sumearlystartdate
,P.sumearlyenddate sumearlyenddate
,P.sumlatestartdate sumlatestartdate
,P.sumlateenddate sumlateenddate
,P.summaxcalendarid summaxcalendarid
,P.summincalendarid summincalendarid
,P.totalbenefitplan totalbenefitplan
,P.totalbenefitplantally totalbenefitplantally
,P.totalfunding totalfunding
,P.totalspendingplan totalspendingplan
,P.totalspendingplantally totalspendingplantally
,P.unallocatedbudget unallocatedbudget
,P.netpresentvalue netpresentvalue
,P.returnoninvestment returnoninvestment
,P.paybackperiod paybackperiod
,P.undistributedcurrentvariance undistributedcurrentvariance
,a.description projectdescription
,a.base_type_id baselinetypeobjectid
,a.px_enable_publication_flag enablepublication
,a.px_next_date nextpublicationdate
,a.px_last_update_date lastpublishedon
,a.px_priority publicationpriority
,a.location_id locationobjectid
,a.hist_interval historyinterval
,a.hist_level historylevel
,P.locationname locationname
,a.control_updates_flag allowstatusreview
,P.statusreviewerobjectid statusreviewerobjectid
,P.statusreviewername statusreviewername
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.etl_interval etlinterval
,a.etl_hour etlhour
,a.create_date createdate
,P.update_dim_date lastupdatedatex
 FROM ${pm.or.administrative_user}.PROJECT A 
   INNER JOIN ${pm.or.administrative_user}.PROJECTX P
   ON a.proj_id = p.proj_id 
   AND a.PROJECT_FLAG = 'Y'
WHERE A.DELETE_SESSION_ID is null
AND a.ORIG_PROJ_ID IS NULL
/
     
prompt creating view PROJECTBUDGETCHANGELOG

--METADATA NAME:PROJECTBUDGETCHANGELOG TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTBUDGETCHANGELOG
AS SELECT a.budg_chng_id objectid
,a.proj_id projectobjectid
,a.wbs_id wbsobjectid
,a.chng_date projectbudgetchangelogdate
,a.chng_short_name changenumber
,a.chng_cost amount
,a.chng_by_name responsible
,CASE a.status_code WHEN 'BC_Pending' THEN 'Pending' WHEN 'BC_Approved' THEN 'Approved' WHEN 'BC_NotApproved' THEN 'Not Approved' WHEN 'BC_Pending' THEN 'Pending' WHEN 'BC_Approved' THEN 'Approved' WHEN 'BC_NotApproved' THEN 'Not Approved' ELSE a.status_code END status
,a.chng_descr reason
,P.projectid projectid
,P.wbscode wbscode
,P.wbsname wbsname
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.BUDGCHNG A 
   INNER JOIN ${pm.or.administrative_user}.BUDGCHNGX P
   ON a.budg_chng_id = p.budg_chng_id 
   INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab
   ON a.proj_id = projects_tab.proj_id and projects_tab.PROJECT_FLAG = 'Y'
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view PROJECTCODE

--METADATA NAME:PROJECTCODE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTCODE
AS SELECT a.proj_catg_id objectid
,a.proj_catg_type_id codetypeobjectid
,a.seq_num sequencenumber
,a.proj_catg_short_name codevalue
,a.parent_proj_catg_id parentobjectid
,a.proj_catg_name description
,a.proj_catg_wt weight
,P.codetypename codetypename
,P.issecurecode issecurecode
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.PCATVAL A 
   INNER JOIN ${pm.or.administrative_user}.PCATVALX P
   ON a.proj_catg_id = p.proj_catg_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view PROJECTCODEASSIGNMENT

--METADATA NAME:PROJECTCODEASSIGNMENT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTCODEASSIGNMENT
AS SELECT a.proj_id projectobjectid
,a.proj_catg_type_id projectcodetypeobjectid
,a.proj_catg_id projectcodeobjectid
,P.projectcodedescription projectcodedescription
,P.projectcodetypename projectcodetypename
,P.projectcodevalue projectcodevalue
,P.projectname projectname
,P.issecurecode issecurecode
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.PROJPCAT A 
   INNER JOIN ${pm.or.administrative_user}.PROJPCATX P
   ON a.proj_id = p.proj_id and a.proj_catg_type_id = p.proj_catg_type_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view PROJECTCODETYPE

--METADATA NAME:PROJECTCODETYPE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTCODETYPE
AS SELECT a.proj_catg_type_id objectid
,a.seq_num sequencenumber
,a.proj_catg_short_len length
,a.proj_catg_type name
,a.super_flag issecurecode
,a.proj_catg_type_wt weight
,a.max_proj_catg_wt maxcodevalueweight
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.PCATTYPE A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view PROJECTCODEUSER

--METADATA NAME:PROJECTCODEUSER TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTCODEUSER
AS SELECT a.proj_catg_id codeobjectid
,a.user_id userobjectid
,P.codetypeobjectid codetypeobjectid
,P.codevalue codevalue
,P.username username
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.PCATUSER A 
   INNER JOIN ${pm.or.administrative_user}.PCATUSERX P
   ON a.proj_catg_id = p.proj_catg_id and a.user_id = p.user_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view PROJECTDOCUMENT

--METADATA NAME:PROJECTDOCUMENT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTDOCUMENT
AS SELECT a.taskdoc_id objectid
,a.doc_id documentobjectid
,a.proj_id projectobjectid
,a.wbs_id wbsobjectid
,a.wp_flag isworkproduct
,a.task_id activityobjectid
,P.activityid activityid
,P.activityname activityname
,P.documenttitle documenttitle
,P.projectid projectid
,P.wbscode wbscode
,P.wbsname wbsname
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.TASKDOC A 
   INNER JOIN ${pm.or.administrative_user}.TASKDOCX P
   ON a.taskdoc_id = p.taskdoc_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view PROJECTFUNDING

--METADATA NAME:PROJECTFUNDING TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTFUNDING
AS SELECT a.proj_fund_id objectid
,a.fund_id fundingsourceobjectid
,a.proj_id projectobjectid
,a.fund_cost amount
,a.fund_wt fundshare
,P.projectid projectid
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.PROJFUND A 
   INNER JOIN ${pm.or.administrative_user}.PROJFUNDX P
   ON a.proj_fund_id = p.proj_fund_id 
   INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab
   ON a.proj_id = projects_tab.proj_id and projects_tab.PROJECT_FLAG = 'Y'
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view PROJECTISSUE

--METADATA NAME:PROJECTISSUE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTISSUE
AS SELECT a.issue_id objectid
,a.proj_id projectobjectid
,a.obs_id obsobjectid
,CASE a.priority_type WHEN 'PT_Top' THEN 'Top' WHEN 'PT_High' THEN 'High' WHEN 'PT_Normal' THEN 'Normal' WHEN 'PT_Low' THEN 'Low' WHEN 'PT_Lowest' THEN 'Lowest' ELSE a.priority_type END priority
,CASE a.status_code WHEN 'IS_Open' THEN 'Open' WHEN 'IS_On_Hold' THEN 'On Hold' WHEN 'IS_Closed' THEN 'Closed' ELSE a.status_code END status
,a.issue_name name
,a.thresh_id projectthresholdobjectid
,a.wbs_id wbsobjectid
,a.task_id activityobjectid
,a.rsrc_id resourceobjectid
,a.thresh_parm_id thresholdparameterobjectid
,a.issue_value actualvalue
,a.lo_parm_value lowerthreshold
,a.hi_parm_value upperthreshold
,a.add_by_name identifiedby
,a.resolv_date resolutiondate
,a.add_date dateidentified
,a.issue_notes notes
,P.activityid activityid
,P.activityname activityname
,P.obsname obsname
,P.projectid projectid
,P.rawtextnote rawtextnote
,P.resourceid resourceid
,P.resourcename resourcename
,P.wbscode wbscode
,P.wbsname wbsname
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.PROJISSU A 
   INNER JOIN ${pm.or.administrative_user}.PROJISSUX P
   ON a.issue_id = p.issue_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view PROJECTNOTE

--METADATA NAME:PROJECTNOTE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTNOTE
AS SELECT a.wbs_memo_id objectid
,a.proj_id projectobjectid
,a.wbs_id wbsobjectid
,a.memo_type_id notebooktopicobjectid
,a.wbs_memo note
,P.notebooktopicname notebooktopicname
,P.projectid projectid
,P.rawtextnote rawtextnote
,P.wbscode wbscode
,P.wbsname wbsname
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.WBSMEMO A 
   INNER JOIN ${pm.or.administrative_user}.WBSMEMOX P
   ON a.wbs_memo_id = p.wbs_memo_id 
   INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab
   ON a.proj_id = projects_tab.proj_id and projects_tab.PROJECT_FLAG = 'Y'
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view PROJECTPORTFOLIO

--METADATA NAME:PROJECTPORTFOLIO TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTPORTFOLIO
AS SELECT a.pfolio_id objectid
,a.closed_proj_flag includeclosedprojects
,a.whatif_proj_flag includewhatifprojects
,CASE a.pfolio_type WHEN 'PT_MAN' THEN 'Manual List' WHEN 'PT_AUTO' THEN 'Automatic List' WHEN 'PT_FLT' THEN 'Semi Automatic List' ELSE a.pfolio_type END type
,a.pfolio_name name
,a.user_id userobjectid
,a.pfolio_descr description
,u.user_name username
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.PFOLIO A 
   LEFT OUTER  JOIN ${pm.or.administrative_user}.USERS U
   ON a.user_id = u.user_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view PROJECTPROFILE

--METADATA NAME:PROJECTPROFILE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTPROFILE
AS SELECT a.prof_id objectid
,a.default_flag isdefault
,a.superuser_flag issuperuser
,a.prof_name name
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.PROFILE A
WHERE A.DELETE_SESSION_ID is null 
AND SCOPE_TYPE = 'ST_Project'
     
/
     
prompt creating view PROJECTPROJECTPORTFOLIO

--METADATA NAME:PROJECTPROJECTPORTFOLIO TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTPROJECTPORTFOLIO
AS SELECT a.pfolio_id projectportfolioobjectid
,P.proj_id projectobjectid
,a.update_user lastupdateuser
,case when a.update_date > b.update_date then a.update_date else b.update_date end lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.PRPFOLIO A 
   INNER JOIN ${pm.or.administrative_user}.pfolio B
   ON a.pfolio_id = b.pfolio_id
   INNER JOIN ${pm.or.administrative_user}.projwbs P
   ON a.wbs_id = p.wbs_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view PROJECTRESOURCE

--METADATA NAME:PROJECTRESOURCE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTRESOURCE
AS SELECT a.wbsrsrc_id objectid
,a.wbs_id wbsobjectid
,a.rsrc_id resourceobjectid
,a.proj_id projectobjectid
,a.committed_flag committedflag
,a.start_date startdate
,a.end_date finishdate
,a.auto_compute_dates_flag lifeofprojectflag
,P.projectid projectid
,P.resourcename resourcename
,P.rolename rolename
,a.role_id roleobjectid
,P.status status
,P.wbscode wbscode
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.WBSRSRC A 
   INNER JOIN ${pm.or.administrative_user}.WBSRSRCX P
   ON a.wbsrsrc_id = p.wbsrsrc_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view PROJECTRESOURCEQUANTITY

--METADATA NAME:PROJECTRESOURCEQUANTITY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTRESOURCEQUANTITY
AS SELECT a.wbsrsrc_id projectresourceobjectid
,a.week_start weekstartdate
,a.month_start monthstartdate
,a.qty quantity
,P.committedflag committedflag
,P.projectobjectid projectobjectid
,P.resourceobjectid resourceobjectid
,P.wbsobjectid wbsobjectid
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.WBSRSRC_QTY A 
   INNER JOIN ${pm.or.administrative_user}.WBSRSRC_QTYX P
   ON a.wbsrsrc_id = p.wbsrsrc_id and a.week_start = p.week_start and a.month_start = p.month_start
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view RISK

--METADATA NAME:RISK TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RISK
AS SELECT a.risk_id objectid
,a.proj_id projectobjectid
,a.id id
,a.name name
,a.total_cost totalcost
,a.rsrc_id resourceobjectid
,a.category_id riskcategoryobjectid
,CASE a.type WHEN 'RT_Threat' THEN 'Threat' WHEN 'RT_Opport' THEN 'Opportunity' ELSE a.type END risktype
,CASE a.status WHEN 'RS_Propose' THEN 'Proposed' WHEN 'RS_Open' THEN 'Open' WHEN 'RS_Active' THEN 'Active' WHEN 'RS_Reject' THEN 'Rejected (Closed)' WHEN 'RS_Manage' THEN 'Managed (Closed)' WHEN 'RS_Impact' THEN 'Impacted (Closed)' ELSE a.status END riskstatus
,a.description description
,a.effect effect
,a.cause cause
,a.note note
,P.score score
,P.scoretext scoretext
,P.scorecolor scorecolor
,P.exposure exposure
,a.identified_by_id identifiedbyresourceobjectid
,P.identifiedbyresourceid identifiedbyresourceid
,P.identifiedbyresourcename identifiedbyresourcename
,a.identified_date identifieddate
,P.exposurestartdate exposurestartdate
,P.exposurefinishdate exposurefinishdate
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.RISK A 
   INNER JOIN ${pm.or.administrative_user}.RISKX P
   ON a.risk_id = p.risk_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view RISKIMPACT

--METADATA NAME:RISKIMPACT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RISKIMPACT
AS SELECT a.risk_id riskobjectid
,a.proj_id projectobjectid
,a.scoretype_id riskthresholdobjectid
,a.threshold_id riskthresholdlevelobjectid
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.RISKIMPACT A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view RISKRESPONSEACTION

--METADATA NAME:RISKRESPONSEACTION TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RISKRESPONSEACTION
AS SELECT a.mitigation_id objectid
,a.response_id riskresponseplanobjectid
,a.rsrc_id resourceobjectid
,a.proj_id projectobjectid
,a.task_id activityobjectid
,a.id id
,a.name name
,CASE a.status WHEN 'MS_Propose' THEN 'Proposed' WHEN 'MS_Sanct' THEN 'Sanctioned' WHEN 'MS_Reject' THEN 'Rejected' WHEN 'MS_InProg' THEN 'In-Progress' WHEN 'MS_Compl' THEN 'Complete' ELSE a.status END riskresponseactionstatus
,P.actualcost actualcost
,P.remainingcost remainingcost
,P.plannedcost plannedcost
,P.physicalstartdate physicalstartdate
,P.physicalfinishdate physicalfinishdate
,P.physicalbasestartdate physicalbasestartdate
,P.physicalbasefinishdate physicalbasefinishdate
,P.score score
,P.scoretext scoretext
,P.scorecolor scorecolor
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.RISKMIT A 
   INNER JOIN ${pm.or.administrative_user}.RISKMITX P
   ON a.mitigation_id = p.mitigation_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view RISKRESPONSEACTIONIMPACT

--METADATA NAME:RISKRESPONSEACTIONIMPACT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RISKRESPONSEACTIONIMPACT
AS SELECT a.mitigation_id riskresponseactionobjectid
,a.proj_id projectobjectid
,a.scoretype_id riskthresholdobjectid
,a.threshold_id riskthresholdlevelobjectid
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.RISKMITIMP A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view RISKRESPONSEPLAN

--METADATA NAME:RISKRESPONSEPLAN TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RISKRESPONSEPLAN
AS SELECT a.response_id objectid
,a.risk_id riskobjectid
,a.proj_id projectobjectid
,a.id id
,a.name name
,a.used isactive
,CASE a.type WHEN 'RP_Avoid' THEN 'Avoid' WHEN 'RP_Trans' THEN 'Transfer' WHEN 'RP_Reduce' THEN 'Reduce' WHEN 'RP_Accept' THEN 'Accept' WHEN 'RP_Exploit' THEN 'Exploit' WHEN 'RP_Facil' THEN 'Facilitate' WHEN 'RP_Enhance' THEN 'Enhance' WHEN 'RP_Reject' THEN 'Reject' ELSE a.type END responsetype
,P.actualcost actualcost
,P.remainingcost remainingcost
,P.plannedcost plannedcost
,P.startdate startdate
,P.finishdate finishdate
,P.plannedstartdate plannedstartdate
,P.plannedfinishdate plannedfinishdate
,P.score score
,P.scoretext scoretext
,P.scorecolor scorecolor
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.RISKRSPPLN A 
   INNER JOIN ${pm.or.administrative_user}.RISKRSPPLNX P
   ON a.response_id = p.response_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view RISKMATRIXSCORETYPE

--METADATA NAME:RISKMATRIXSCORETYPE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RISKMATRIXSCORETYPE
AS SELECT a.matrix_id matrixid
,a.scoretype_id scoretypeid
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.MTXSCRTYP A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view RISKSCORETYPE

--METADATA NAME:RISKSCORETYPE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RISKSCORETYPE
AS SELECT a.scoretype_id scoretypeid
,a.name name
,CASE a.type WHEN 'ST_Prob' THEN 'Probability' WHEN 'ST_Tol' THEN 'Tolerance' WHEN 'ST_Sch' THEN 'Schedule Impact by value' WHEN 'ST_Cost' THEN 'Cost Impact by value' WHEN 'ST_RelSch' THEN 'Schedule Impact by percentage' WHEN 'ST_RelCost' THEN 'Cost Impact by percentage' WHEN 'ST_User' THEN 'User-defined Impact' ELSE a.type END scoretype
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.RISKSCRTYP A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view RISKMATRIXSCORE

--METADATA NAME:RISKMATRIXSCORE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RISKMATRIXSCORE
AS SELECT a.score_id objectid
,a.matrix_id riskscorematrixobjectid
,a.probability_threshold_level probabilitythresholdlevel
,a.severity1 severity1
,a.severity2 severity2
,a.severity3 severity3
,a.severity4 severity4
,a.severity5 severity5
,a.severity6 severity6
,a.severity7 severity7
,a.severity8 severity8
,a.severity9 severity9
,a.severity1label severity1label
,a.severity2label severity2label
,a.severity3label severity3label
,a.severity4label severity4label
,a.severity5label severity5label
,a.severity6label severity6label
,a.severity7label severity7label
,a.severity8label severity8label
,a.severity9label severity9label
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.RISKMTXSCR A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view RISKSCOREMATRIX

--METADATA NAME:RISKSCOREMATRIX TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RISKSCOREMATRIX
AS SELECT a.matrix_id objectid
,a.name name
,a.description description
,CASE a.method WHEN 'SM_High' THEN 'Highest Impact' WHEN 'SM_AvImps' THEN 'Average Impact' WHEN 'SM_AvIndiv' THEN 'Average Individual Impact' ELSE a.method END riskscoringmethod
,a.impact_levels impact_levels
,a.probability_levels probability_levels
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.RISKSCRMTX A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view RISKTHRESHOLDLEVEL

--METADATA NAME:RISKTHRESHOLDLEVEL TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RISKTHRESHOLDLEVEL
AS SELECT a.threshold_id objectid
,a.scoretype_id riskthresholdobjectid
,a.short_name code
,a.full_name name
,a.color color
,a.lvl riskscorelevel
,a.value value
,a.tolerance_value tolerancerange
,a.cost_value costrange
,a.schedule_value schedulerange
,a.probability_value probabiltyrange
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.RISKSCRTHR A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view PROJECTSPENDINGPLAN

--METADATA NAME:PROJECTSPENDINGPLAN TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTSPENDINGPLAN
AS SELECT a.wbs_budg_id objectid
,a.proj_id projectobjectid
,a.wbs_id wbsobjectid
,a.start_date spendingplandate
,a.spend_cost spendingplan
,a.benefit_cost benefitplan
,P.projectid projectid
,P.wbscode wbscode
,P.wbsname wbsname
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.WBSBUDG A 
   INNER JOIN ${pm.or.administrative_user}.WBSBUDGX P
   ON a.wbs_budg_id = p.wbs_budg_id 
   INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab
   ON a.proj_id = projects_tab.proj_id and projects_tab.PROJECT_FLAG = 'Y'
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view RELATIONSHIP

--METADATA NAME:RELATIONSHIP TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RELATIONSHIP
AS SELECT a.task_pred_id objectid
,a.task_id successoractivityobjectid
,a.pred_task_id predecessoractivityobjectid
,a.proj_id successorprojectobjectid
,a.pred_proj_id predecessorprojectobjectid
,CASE a.pred_type WHEN 'PR_FS' THEN 'Finish to Start' WHEN 'PR_FF' THEN 'Finish to Finish' WHEN 'PR_SS' THEN 'Start to Start' WHEN 'PR_SF' THEN 'Start to Finish' ELSE a.pred_type END type
,a.lag_hr_cnt lag
,P.predecessoractivityid predecessoractivityid
,P.predecessoractivityname predecessoractivityname
,P.predecessorprojectid predecessorprojectid
,P.successoractivityid successoractivityid
,P.successoractivityname successoractivityname
,P.successorprojectid successorprojectid
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.TASKPRED A 
   INNER JOIN ${pm.or.administrative_user}.TASKPREDX P
   ON a.task_pred_id = p.task_pred_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view RELEASE

--METADATA NAME:RELEASE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RELEASE
AS SELECT a.release_id objectid
,a.release_name name
,a.start_date startdate
,a.release_theme releasetheme
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.RELEASE A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view RELEASEPROJECT

--METADATA NAME:RELEASEPROJECT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RELEASEPROJECT
AS SELECT a.release_id releaseobjectid
,a.proj_id projectobjectid
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.RELPROJ A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view RELEASEITERATION

--METADATA NAME:RELEASEITERATION TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RELEASEITERATION
AS SELECT a.release_id releaseobjectid
,a.proj_id projectobjectid
,a.iteration_id iterationobjectid
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.RELITER A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view RESASSIGNMENTPERIODACTUAL

--METADATA NAME:RESASSIGNMENTPERIODACTUAL TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESASSIGNMENTPERIODACTUAL
AS SELECT a.fin_dates_id financialperiodobjectid
,fd.start_date startdate
,fd.end_date enddate
,a.taskrsrc_id resourceassignmentobjectid
,a.task_id activityobjectid
,a.proj_id projectobjectid
,a.act_qty actualunits
,a.act_cost actualcost
,P.resourcetype resourcetype
,P.wbsobjectid wbsobjectid
,T.rsrc_id resourceobjectid
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.TRSRCFIN A 
   INNER JOIN ${pm.or.administrative_user}.TRSRCFINX P
   ON a.fin_dates_id = p.fin_dates_id and a.taskrsrc_id = p.taskrsrc_id
   INNER JOIN ${pm.or.administrative_user}.taskrsrc T
   ON a.taskrsrc_id = T.taskrsrc_id and a.proj_id = t.proj_id 
   INNER JOIN ${pm.or.administrative_user}.FINDATES FD
   ON a.fin_dates_id = fd.fin_dates_id 
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view RESOURCEACCESS

--METADATA NAME:RESOURCEACCESS TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCEACCESS
AS SELECT a.user_id userobjectid
,a.rsrc_id resourceobjectid
,P.resourceid resourceid
,P.resourcename resourcename
,P.username username
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
 FROM ${pm.or.administrative_user}.RSRCSEC A 
   INNER JOIN ${pm.or.administrative_user}.RSRCSECX P
   ON a.user_id = p.user_id and a.rsrc_id = p.rsrc_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view RESOURCEASSIGNMENT

--METADATA NAME:RESOURCEASSIGNMENT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCEASSIGNMENT
AS SELECT a.taskrsrc_id objectid
,a.task_id activityobjectid
,a.proj_id projectobjectid
,CASE a.rsrc_type WHEN 'RT_Labor' THEN 'Labor' WHEN 'RT_Equip' THEN 'Nonlabor' WHEN 'RT_Mat' THEN 'Material' ELSE a.rsrc_type END resourcetype
,a.cost_qty_link_flag iscostunitslinked
,a.role_id roleobjectid
,a.acct_id costaccountobjectid
,a.rsrc_id resourceobjectid
,P.proficiency proficiency
,a.pend_complete_pct pendingpercentcomplete
,a.remain_qty remainingunits
,a.pend_remain_qty pendingremainingunits
,a.target_qty plannedunits
,a.remain_qty_per_hr remainingunitspertime
,a.pend_act_reg_qty pendingactualregularunits
,a.target_lag_drtn_hr_cnt plannedlag
,a.target_qty_per_hr plannedunitspertime
,a.act_ot_qty actualovertimeunits
,a.pend_act_ot_qty pendingactualovertimeunits
,a.act_reg_qty actualregularunits
,P.remaininglag remaininglag
,a.ot_factor overtimefactor
,a.target_cost plannedcost
,a.act_reg_cost actualregularcost
,a.act_ot_cost actualovertimecost
,a.remain_cost remainingcost
,a.act_start_date actualstartdate
,a.act_end_date actualfinishdate
,a.restart_date remainingstartdate
,a.reend_date remainingfinishdate
,a.target_start_date plannedstartdate
,a.target_end_date plannedfinishdate
,a.rem_late_start_date remaininglatestartdate
,a.rem_late_end_date remaininglatefinishdate
,CASE a.rate_type WHEN 'COST_PER_QTY' THEN 'Price/Unit' WHEN 'COST_PER_QTY2' THEN 'Price/Unit 2' WHEN 'COST_PER_QTY3' THEN 'Price/Unit 3' WHEN 'COST_PER_QTY4' THEN 'Price/Unit 4' WHEN 'COST_PER_QTY5' THEN 'Price/Unit 5' ELSE a.rate_type END ratetype
,a.act_this_per_cost actualthisperiodcost
,a.act_this_per_qty actualthisperiodunits
,a.curv_id resourcecurveobjectid
,a.rollup_dates_flag drivingactivitydatesflag
,CASE a.cost_per_qty_source_type WHEN 'ST_Rsrc' THEN 'Resource' WHEN 'ST_Role' THEN 'Role' WHEN 'ST_Custom' THEN 'Override' ELSE a.cost_per_qty_source_type END ratesource
,P.activityid activityid
,P.activityname activityname
,P.actualcost actualcost
,P.actualduration actualduration
,P.actualunits actualunits
,P.atcompletioncost atcompletioncost
,P.atcompletionduration atcompletionduration
,P.atcompletionunits atcompletionunits
,P.autocomputeactuals autocomputeactuals
,P.calendarobjectid calendarobjectid
,P.costaccountid costaccountid
,P.costaccountname costaccountname
,P.finishdate finishdate
,P.isactive isactive
,P.isovertimeallowed isovertimeallowed
,P.isprimaryresource isprimaryresource
,P.plannedduration plannedduration
,P.priceperunit priceperunit
,P.projectid projectid
,P.remainingduration remainingduration
,P.resourcecurvename resourcecurvename
,P.resourceid resourceid
,P.resourcename resourcename
,P.roleid roleid
,P.rolename rolename
,P.staffedremainingcost staffedremainingcost
,P.staffedremainingunits staffedremainingunits
,P.startdate startdate
,P.unitspercentcomplete unitspercentcomplete
,P.unstaffedremainingcost unstaffedremainingcost
,P.unstaffedremainingunits unstaffedremainingunits
,P.wbsobjectid wbsobjectid
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
,P.update_date lastupdatedatex 
,case when a.update_date>P.update_date then 'N' ELSE 'Y' END rpt_current_flag
 FROM ${pm.or.administrative_user}.TASKRSRC A 
   INNER JOIN ${pm.or.administrative_user}.TASKRSRCX P
   ON a.taskrsrc_id = p.taskrsrc_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view RESOURCECODE

--METADATA NAME:RESOURCECODE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCECODE
AS SELECT a.rsrc_catg_id objectid
,a.rsrc_catg_type_id codetypeobjectid
,a.seq_num sequencenumber
,a.rsrc_catg_short_name codevalue
,a.rsrc_catg_name description
,a.parent_rsrc_catg_id parentobjectid
,P.codetypename codetypename
,P.issecurecode issecurecode
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.RCATVAL A 
   INNER JOIN ${pm.or.administrative_user}.RCATVALX P
   ON a.rsrc_catg_id = p.rsrc_catg_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view RESOURCECODEASSIGNMENT

--METADATA NAME:RESOURCECODEASSIGNMENT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCECODEASSIGNMENT
AS SELECT a.rsrc_id resourceobjectid
,a.rsrc_catg_type_id resourcecodetypeobjectid
,a.rsrc_catg_id resourcecodeobjectid
,P.resourcecodedescription resourcecodedescription
,P.resourcecodetypename resourcecodetypename
,P.resourcecodevalue resourcecodevalue
,P.resourceid resourceid
,P.resourcename resourcename
,P.issecurecode issecurecode
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.RSRCRCAT A 
   INNER JOIN ${pm.or.administrative_user}.RSRCRCATX P
   ON a.rsrc_id = p.rsrc_id and a.rsrc_catg_type_id = p.rsrc_catg_type_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view RESOURCECODETYPE

--METADATA NAME:RESOURCECODETYPE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCECODETYPE
AS SELECT a.rsrc_catg_type_id objectid
,a.seq_num sequencenumber
,a.rsrc_catg_short_len length
,a.rsrc_catg_type name
,a.super_flag issecurecode
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.RCATTYPE A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view RESOURCECURVE

--METADATA NAME:RESOURCECURVE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCECURVE
AS SELECT a.curv_id objectid
,a.curv_name name
,a.default_flag isdefault
,P.value0 value0
,P.value5 value5
,P.value10 value10
,P.value15 value15
,P.value20 value20
,P.value25 value25
,P.value30 value30
,P.value35 value35
,P.value40 value40
,P.value45 value45
,P.value50 value50
,P.value55 value55
,P.value60 value60
,P.value65 value65
,P.value70 value70
,P.value75 value75
,P.value80 value80
,P.value85 value85
,P.value90 value90
,P.value95 value95
,P.value100 value100
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.RSRCCURV A 
   INNER JOIN ${pm.or.administrative_user}.RSRCCURVX P
   ON a.curv_id = p.curv_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view RESOURCEHOUR

--METADATA NAME:RESOURCEHOUR TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCEHOUR
AS SELECT a.rsrc_hr_id objectid
,a.rsrc_id resourceobjectid
,a.ts_id timesheetperiodobjectid
,a.task_ts_flag activitytimesheetlinkflag
,a.taskrsrc_id resourceassignmentobjectid
,a.nonwork_type_id overheadcodeobjectid
,a.proj_id projectobjectid
,a.pend_hr_cnt unapprovedhours
,a.hr_cnt approvedhours
,a.pend_ot_hr_cnt unapprovedovertimehours
,a.ot_hr_cnt approvedovertimehours
,a.work_date resourcehourdate
,CASE a.status_code WHEN 'TS_Review' THEN 'Submitted' WHEN 'TS_Approv' THEN 'Approved' WHEN 'TS_RMApprov' THEN 'RM Approved' WHEN 'TS_PMApprov' THEN 'PM Approved' WHEN 'TS_Active' THEN 'Not Submitted' WHEN 'TS_Reject' THEN 'Rejected' WHEN 'TS_ReSubmit' THEN 'Resubmitted' WHEN 'TS_ReActive' THEN 'Not Submitted' WHEN 'TS_ReviewRM' THEN 'Submitted' WHEN 'TS_ReSubmitRM' THEN 'Resubmitted' ELSE a.status_code END status
,P.projectid projectid
,P.projectname projectname
,P.resourceid resourceid
,P.resourcename resourcename
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.RSRCHOUR A 
   INNER JOIN ${pm.or.administrative_user}.RSRCHOURX P
   ON a.rsrc_hr_id = p.rsrc_hr_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view RESOURCERATE

--METADATA NAME:RESOURCERATE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCERATE
AS SELECT a.rsrc_rate_id objectid
,a.rsrc_id resourceobjectid
,a.start_date effectivedate
,a.shift_period_id shiftperiodobjectid
,a.max_qty_per_hr maxunitspertime
,a.cost_per_qty priceperunit
,a.cost_per_qty2 priceperunit2
,a.cost_per_qty3 priceperunit3
,a.cost_per_qty4 priceperunit4
,a.cost_per_qty5 priceperunit5
,P.resourceid resourceid
,P.resourcename resourcename
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.RSRCRATE A 
   INNER JOIN ${pm.or.administrative_user}.RSRCRATEX P
   ON a.rsrc_rate_id = p.rsrc_rate_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view RESOURCERESOURCETEAM

--METADATA NAME:RESOURCERESOURCETEAM TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCERESOURCETEAM
AS SELECT a.rfolio_id resourceteamobjectid
,a.rsrc_id resourceobjectid
,a.update_user lastupdateuser
,case when a.update_date > b.update_date then a.update_date else b.update_date end lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.RSRFOLIO A
   INNER JOIN (select rfolio_id,max(update_date) update_date  FROM ${pm.or.administrative_user}.rsrfolio group by rfolio_id) B
   on A.rfolio_id = B.rfolio_id 
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view RESOURCEROLE

--METADATA NAME:RESOURCEROLE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCEROLE
AS SELECT a.rsrc_id resourceobjectid
,a.role_id roleobjectid
,P.proficiency proficiency
,P.resourceid resourceid
,P.resourcename resourcename
,P.roleid roleid
,P.rolename rolename
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.RSRCROLE A 
   INNER JOIN ${pm.or.administrative_user}.RSRCROLEX P
   ON a.rsrc_id = p.rsrc_id and a.role_id = p.role_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view RESOURCES

--METADATA NAME:RESOURCES TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCES
AS SELECT a.rsrc_id objectid
,a.clndr_id calendarobjectid
,a.rsrc_seq_num sequencenumber
,a.timesheet_flag usetimesheets
,a.active_flag isactive
,CASE a.rsrc_type WHEN 'RT_Labor' THEN 'Labor' WHEN 'RT_Equip' THEN 'Nonlabor' WHEN 'RT_Mat' THEN 'Material' ELSE a.rsrc_type END resourcetype
,a.auto_compute_act_flag autocomputeactuals
,a.ot_flag isovertimeallowed
,a.def_cost_qty_link_flag calculatecostfromunits
,a.rsrc_short_name id
,a.rsrc_name name
,a.parent_rsrc_id parentobjectid
,a.ts_approve_user_id timesheetapprovalmgrobjectid
,a.user_id userobjectid
,a.role_id primaryroleobjectid
,a.curr_id currencyobjectid
,a.shift_id shiftobjectid
,a.ot_factor overtimefactor
,a.def_qty_per_hr defaultunitspertime
,a.office_phone officephone
,a.other_phone otherphone
,a.employee_code employeeid
,a.rsrc_title_name title
,a.email_addr emailaddress
,a.unit_id unitofmeasureobjectid
,a.rsrc_notes resourcenotes
,P.calendarname calendarname
,P.currencyid currencyid
,P.currencyname currencyname
,P.primaryroleid primaryroleid
,P.primaryrolename primaryrolename
,P.timesheetapprovalmanager timesheetapprovalmanager
,P.username username
,a.location_id locationobjectid
,P.locationname locationname
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
,P.update_date lastupdatedatex
 FROM ${pm.or.administrative_user}.RSRC A 
   INNER JOIN ${pm.or.administrative_user}.RSRCX P
   ON a.rsrc_id = p.rsrc_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view RESOURCELOCATION

--METADATA NAME:RESOURCELOCATION TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCELOCATION
AS SELECT a.rsrc_loc_id objectid
,a.rsrc_id resourceobjectid
,a.longitude longitude
,a.latitude latitude
,a.geo_location geolocation
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.RSRCLOC A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view RESOURCETEAM

--METADATA NAME:RESOURCETEAM TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCETEAM
AS SELECT a.rfolio_id objectid
,a.user_id userobjectid
,a.rfolio_name name
,a.rfolio_descr description
,P.username username
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.RFOLIO A 
   INNER JOIN ${pm.or.administrative_user}.RFOLIOX P
   ON a.rfolio_id = p.rfolio_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view RISKTYPE

--METADATA NAME:RISKTYPE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RISKTYPE
AS SELECT a.risk_type_id objectid
,a.seq_num sequencenumber
,a.risk_type name
,a.parent_risk_type_id parentobjectid
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.RISKTYPE A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view ROLE

--METADATA NAME:ROLE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ROLE
AS SELECT a.role_id objectid
,a.role_short_name id
,a.role_name name
,a.seq_num sequencenumber
,a.parent_role_id parentobjectid
,a.def_cost_qty_link_flag calculatecostfromunits
,a.role_descr responsibilities
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.ROLES A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view ROLERATE

--METADATA NAME:ROLERATE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ROLERATE
AS SELECT a.role_rate_id objectid
,a.role_id roleobjectid
,a.cost_per_qty priceperunit
,a.cost_per_qty2 priceperunit2
,a.cost_per_qty3 priceperunit3
,a.cost_per_qty4 priceperunit4
,a.cost_per_qty5 priceperunit5
,P.roleid roleid
,P.rolename rolename
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.ROLERATE A 
   INNER JOIN ${pm.or.administrative_user}.ROLERATEX P
   ON a.role_rate_id = p.role_rate_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view ROLEROLETEAM

--METADATA NAME:ROLEROLETEAM TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ROLEROLETEAM
AS SELECT a.rlfolio_id roleteamobjectid
,a.role_id roleobjectid
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.ROLFOLIO A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view ROLETEAM

--METADATA NAME:ROLETEAM TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ROLETEAM
AS SELECT a.rlfolio_id objectid
,a.user_id userobjectid
,a.rlfolio_name name
,a.rlfolio_descr description
,P.username username
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.RLFOLIO A 
   INNER JOIN ${pm.or.administrative_user}.RLFOLIOX P
   ON a.rlfolio_id = p.rlfolio_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view SHIFT

--METADATA NAME:SHIFT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW SHIFT
AS SELECT a.shift_id objectid
,a.shift_name name
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.SHIFT A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view SHIFTPERIOD

--METADATA NAME:SHIFTPERIOD TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW SHIFTPERIOD
AS SELECT a.shift_period_id objectid
,a.shift_id shiftobjectid
,a.shift_start_hr_num starthour
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.SHIFTPER A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view SNAPSHOT

--METADATA NAME:SNAPSHOT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW SNAPSHOT
AS SELECT a.snapshot_id objectid
,a.snapshot_name name
,a.snapshot_date snapshotdate
,a.snap_group_id snapshotgroupobjectid
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.SNAPSHOT A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view SNAPSHOTGROUP

--METADATA NAME:SNAPSHOTGROUP TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW SNAPSHOTGROUP
AS SELECT a.snap_group_id objectid
,a.snap_group_name name
,a.snap_group_desc description
,a.snap_interval interval
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.SNAPGROUP A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view SNAPSHOTPROJECT

--METADATA NAME:SNAPSHOTPROJECT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW SNAPSHOTPROJECT
AS SELECT a.snap_group_id snapshotgroupobjectid
,a.proj_id projectobjectid
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.SNAPPROJ A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view TIMESHEET

--METADATA NAME:TIMESHEET TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW TIMESHEET
AS SELECT a.ts_id timesheetperiodobjectid
,a.rsrc_id resourceobjectid
,a.daily_flag isdaily
,CASE a.status_code WHEN 'TS_Review' THEN 'Submitted' WHEN 'TS_Approv' THEN 'Approved' WHEN 'TS_RMApprov' THEN 'RM Approved' WHEN 'TS_PMApprov' THEN 'PM Approved' WHEN 'TS_Active' THEN 'Not Submitted' WHEN 'TS_Reject' THEN 'Rejected' WHEN 'TS_NotStarted' THEN 'Not Started' WHEN 'TS_ReSubmit' THEN 'Resubmitted' WHEN 'TS_ReActive' THEN 'Not Submitted' WHEN 'TS_ReviewRM' THEN 'Submitted' WHEN 'TS_ReSubmitRM' THEN 'Resubmitted' ELSE a.status_code END status
,a.last_recv_date lastreceiveddate
,a.status_date statusdate
,a.ts_notes notes
,P.resourceid resourceid
,P.resourcename resourcename
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.TIMESHT A 
   INNER JOIN ${pm.or.administrative_user}.TIMESHTX P
   ON a.ts_id = p.ts_id and a.rsrc_id = p.rsrc_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view TIMESHEETPERIOD

--METADATA NAME:TIMESHEETPERIOD TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW TIMESHEETPERIOD
AS SELECT a.ts_id objectid
,a.start_date startdate
,a.end_date enddate
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.TSDATES A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view UDFCODE

--METADATA NAME:UDFCODE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW UDFCODE
AS SELECT a.udf_code_id objectid
,a.udf_type_id codetypeobjectid
,a.seq_num sequencenumber
,a.short_name codevalue
,a.udf_code_name description
,P.codetypetitle codetypetitle
,P.issecurecode issecurecode
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.UDFCODE A 
   INNER JOIN ${pm.or.administrative_user}.UDFCODEX P
   ON a.udf_code_id = p.udf_code_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view UDFTYPE

--METADATA NAME:UDFTYPE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW UDFTYPE
AS SELECT a.udf_type_id objectid
,CASE a.table_name WHEN 'TASK' THEN 'Activity' WHEN 'PROJCOST' THEN 'Activity Expense' WHEN 'TASKPROC' THEN 'Activity Step' WHEN 'PROJECT' THEN 'Project' WHEN 'PROJISSU' THEN 'Project Issue' WHEN 'RISK' THEN 'Project Risk' WHEN 'RSRC' THEN 'Resource' WHEN 'TASKRSRC' THEN 'Assignment' WHEN 'PROJWBS' THEN 'WBS' WHEN 'DOCUMENT' THEN 'Work Products and Documents' WHEN 'PROCITEM' THEN 'Activity Step Template Item' WHEN 'LEANTASK' THEN '??enm.UDFBusinessObjectType.LEANTASK??' ELSE a.table_name END subjectarea
,a.udf_type_label title
,CASE a.logical_data_type WHEN 'FT_TEXT' THEN 'Text' WHEN 'FT_START_DATE' THEN 'Start Date' WHEN 'FT_END_DATE' THEN 'Finish Date' WHEN 'FT_MONEY' THEN 'Cost' WHEN 'FT_FLOAT_2_DECIMALS' THEN 'Number' WHEN 'FT_INT' THEN 'Integer' WHEN 'FT_STATICTYPE' THEN 'Indicator' WHEN 'FT_CODE' THEN 'Code' ELSE a.logical_data_type END datatype
,a.super_flag issecurecode
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.UDFTYPE A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view UDFVALUE

--METADATA NAME:UDFVALUE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW UDFVALUE
AS SELECT a.udf_type_id udftypeobjectid
,a.fk_id foreignobjectid
,a.proj_id projectobjectid
,a.udf_date udfdate
,CASE a.udf_text WHEN '' THEN '??enm.UDF_RAGType.??' WHEN 'UDF_G1' THEN 'Red' WHEN 'UDF_G2' THEN 'Yellow' WHEN 'UDF_G3' THEN 'Green' WHEN 'UDF_G4' THEN 'Blue' ELSE a.udf_text END udftext
,a.udf_number udfnumber
,a.udf_code_id udfcodeobjectid
,P.subjectarea subjectarea
,P.datatype datatype
,P.issecurecode issecurecode
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.UDFVALUE A 
   INNER JOIN ${pm.or.administrative_user}.UDFVALUEX P
   ON a.udf_type_id = p.udf_type_id and a.fk_id = p.fk_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view UNITOFMEASURE

--METADATA NAME:UNITOFMEASURE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW UNITOFMEASURE
AS SELECT a.unit_id objectid
,a.seq_num sequencenumber
,a.unit_name name
,a.unit_abbrev abbreviation
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.UMEASURE A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view USERMODULEACCESS

--METADATA NAME:USERMODULEACCESS TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW USERMODULEACCESS
AS SELECT a.user_eng_id objectid
,a.user_id userobjectid
,CASE a.db_engine_type WHEN 'PM' THEN 'P6 Professional' WHEN 'TS' THEN 'Contributor' WHEN 'WU' THEN 'Portfolios' WHEN 'WEB_PM' THEN 'Projects' WHEN 'WEB_RM' THEN 'Resources' WHEN 'INT_API' THEN 'Integration API' WHEN 'TS_ONLY' THEN 'Timesheet' WHEN 'WS' THEN 'Web Services' WHEN 'STAR' THEN 'P6 Analytics' WHEN 'RDB' THEN 'Enterprise Reports' WHEN 'TM' THEN 'Team Member' WHEN 'VIS' THEN 'Visualizer' ELSE a.db_engine_type END moduletypecode
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.USERENG A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view USEROBS

--METADATA NAME:USEROBS TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW USEROBS
AS SELECT a.user_id userobjectid
,a.obs_id obsobjectid
,a.prof_id projectprofileobjectid
,P.obsname obsname
,P.profilename profilename
,P.username username
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.USEROBS A 
   INNER JOIN ${pm.or.administrative_user}.USEROBSX P
   ON a.user_id = p.user_id and a.obs_id = p.obs_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view USERPROFILEPRIVILEGE

--METADATA NAME:USERPROFILEPRIVILEGE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW USERPROFILEPRIVILEGE
AS SELECT a.prof_id profileid
,a.priv_num privlegenumber
,P.privlegename privlegename
,a.allow_flag allowflag
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.PROFPRIV A 
   INNER JOIN ${pm.or.administrative_user}.PROFPRIVX P
   ON a.prof_id = p.prof_id and a.priv_num = p.priv_num
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view USERS

--METADATA NAME:USERS TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW USERS
AS SELECT a.user_id objectid
,CASE a.email_type WHEN 'ET_Internet' THEN 'Internet' WHEN 'ET_MAPI' THEN 'MAPI' ELSE a.email_type END emailprotocol
,a.user_name rdbmsusername
,a.user_name name
,a.prof_id globalprofileobjectid
,a.curr_id currencyobjectid
,a.all_rsrc_access_flag allresourceaccessflag
,P.issuperuser issuperuser
,a.email_srv_user_name mailserverloginname
,a.office_phone officephone
,a.actual_name personalname
,a.email_send_server outgoingmailserver
,a.email_addr emailaddress
,a.notify_prefs notificationsettings
,P.respectactivitydurationtype respectactivitydurationtype
,P.assignmentstaffingpreference assignmentstaffingpreference
,P.currencyid currencyid
,P.currencyname currencyname
,P.financialperiodendobjectid financialperiodendobjectid
,P.financialperiodstartobjectid financialperiodstartobjectid
,P.newprojectdurationtype newprojectdurationtype
,P.ratesourcepreference ratesourcepreference
,a.report_user_flag reportingflag
,P.lastprojectsecuritydate lastprojectsecuritydate
,P.lastresourcesecuritydate lastresourcesecuritydate
,P.lastglobalsecuritydate lastglobalsecuritydate
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.USERS A 
   INNER JOIN ${pm.or.administrative_user}.USERSX P
   ON a.user_id = p.user_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view WBS

--METADATA NAME:WBS TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW WBS
AS SELECT a.wbs_id objectid
,a.proj_id projectobjectid
,a.obs_id obsobjectid
,a.seq_num sequencenumber
,a.sum_data_flag containssummarydata
,CASE a.status_code WHEN 'WS_Planned' THEN 'Planned' WHEN 'WS_Open' THEN 'Active' WHEN 'WS_Closed' THEN 'Inactive' WHEN 'WS_Whatif' THEN 'What If' WHEN 'WS_Requested' THEN 'Requested' WHEN 'WS_Template' THEN 'Template' WHEN 'WS_Planned' THEN 'Planned' WHEN 'WS_Open' THEN 'Active' WHEN 'WS_Closed' THEN 'Inactive' WHEN 'WS_Whatif' THEN 'What If' WHEN 'WS_Requested' THEN 'Requested' WHEN 'WS_Template' THEN 'Template' ELSE a.status_code END status
,a.wbs_short_name code
,a.wbs_name name
,a.phase_id wbscategoryobjectid
,a.parent_wbs_id parentobjectid
,a.ev_user_pct earnedvalueuserpercent
,a.ev_etc_user_value earnedvalueetcuservalue
,a.orig_cost originalbudget
,a.indep_remain_total_cost independentetctotalcost
,a.indep_remain_work_qty independentetclaborunits
,a.anticip_start_date anticipatedstartdate
,a.anticip_end_date anticipatedfinishdate
,CASE a.ev_compute_type WHEN 'EC_Cmp_pct' THEN 'Activity Percent Complete' WHEN 'EC_0_pct' THEN 'Zero Hundred' WHEN 'EC_50_pct' THEN 'Fifty Fifty' WHEN 'EC_User_pct' THEN 'Custom Percent Complete' WHEN 'EC_MS' THEN 'WBS Milestones Percent Complete' WHEN 'EC_Curve' THEN 'Activity Percent Complete Using Resource Curve' WHEN 'EC_Cmp_pct' THEN 'Activity Percent Complete' WHEN 'EC_0_pct' THEN 'Zero Hundred' WHEN 'EC_50_pct' THEN 'Fifty Fifty' WHEN 'EC_User_pct' THEN 'Custom Percent Complete' WHEN 'EC_MS' THEN 'WBS Milestones Percent Complete' WHEN 'EC_Curve' THEN 'Activity Percent Complete Using Resource Curve' ELSE a.ev_compute_type END earnedvaluecomputetype
,CASE a.ev_etc_compute_type WHEN 'EE_Rem_hr' THEN 'Remaining Cost For Activity' WHEN 'EE_PF_1' THEN 'PF 1' WHEN 'EE_PF_user' THEN 'PF Custom' WHEN 'EE_PF_cpi' THEN 'PF CPI' WHEN 'EE_PF_cpi_spi' THEN 'PF CPI SPI' WHEN 'EE_Rem_hr' THEN 'Remaining Cost For Activity' WHEN 'EE_PF_1' THEN 'PF 1' WHEN 'EE_PF_user' THEN 'PF Custom' WHEN 'EE_PF_cpi' THEN 'PF CPI' WHEN 'EE_PF_cpi_spi' THEN 'PF CPI SPI' ELSE a.ev_etc_compute_type END earnedvalueetccomputetype
,a.proj_node_flag projectnodeflag
,P.currentbudget currentbudget
,P.currentvariance currentvariance
,P.distributedcurrentbudget distributedcurrentbudget
,P.finishdate finishdate
,P.forecastfinishdate forecastfinishdate
,P.forecaststartdate forecaststartdate
,P.fullname fullname
,P.fullsequence fullsequence
,P.obsname obsname
,P.projectid projectid
,P.proposedbudget proposedbudget
,P.startdate startdate
,P.sumplannedstartdate sumplannedstartdate
,P.sumplannedfinishdate sumplannedfinishdate
,P.sumplannedduration sumplannedduration
,P.sumplannedlaborunits sumplannedlaborunits
,P.sumplannednonlaborunits sumplannednonlaborunits
,P.sumplannedexpensecost sumplannedexpensecost
,P.sumplannedlaborcost sumplannedlaborcost
,P.sumplannedmaterialcost sumplannedmaterialcost
,P.sumplannednonlaborcost sumplannednonlaborcost
,P.sumplannedtotalcost sumplannedtotalcost
,P.sumaccountingvarbylaborunits sumaccountingvarbylaborunits
,P.sumaccountingvariancebycost sumaccountingvariancebycost
,P.sumactthisperiodmaterialcost sumactthisperiodmaterialcost
,P.sumactthisperiodnonlaborcost sumactthisperiodnonlaborcost
,P.sumactthisperiodnonlaborunits sumactthisperiodnonlaborunits
,P.sumactualthisperiodlaborcost sumactualthisperiodlaborcost
,P.sumactualthisperiodlaborunits sumactualthisperiodlaborunits
,P.sumatcompletionmaterialcost sumatcompletionmaterialcost
,P.sumatcompletionnonlaborcost sumatcompletionnonlaborcost
,P.sumatcompletionnonlaborunits sumatcompletionnonlaborunits
,P.sumatcompletiontotalcostvar sumatcompletiontotalcostvar
,P.sumbaselinecompactivitycount sumbaselinecompactivitycount
,P.sumbaselinenotstartedactcnt sumbaselinenotstartedactcnt
,P.sumblinprogressactivitycount sumblinprogressactivitycount
,P.sumbudgetatcmpbylaborunits sumbudgetatcmpbylaborunits
,P.sumbudgetatcompletionbycost sumbudgetatcompletionbycost
,P.sumcostperfindexbycost sumcostperfindexbycost
,P.sumcostperfindexbylaborunits sumcostperfindexbylaborunits
,P.sumcostvariancebylaborunits sumcostvariancebylaborunits
,P.sumcostvarindexbylaborunits sumcostvarindexbylaborunits
,P.sumdurationpercentofplanned sumdurationpercentofplanned
,P.sumeacbycost sumeacbycost
,P.sumeacbylaborunits sumeacbylaborunits
,P.sumeachighpctbylaborunits sumeachighpctbylaborunits
,P.sumeaclowpctbylaborunits sumeaclowpctbylaborunits
,P.sumetcbycost sumetcbycost
,P.sumetcbylaborunits sumetcbylaborunits
,P.sumexpensecostpctcomplete sumexpensecostpctcomplete
,P.sumlaborcostpercentcomplete sumlaborcostpercentcomplete
,P.sumlaborunitspercentcomplete sumlaborunitspercentcomplete
,P.sumactivitycount sumactivitycount
,P.sumactualduration sumactualduration
,P.sumactualexpensecost sumactualexpensecost
,P.sumactualfinishdate sumactualfinishdate
,P.summaxactualfinishdate summaxactualfinishdate
,P.summaxrestartdate summaxrestartdate
,P.sumactuallaborcost sumactuallaborcost
,P.sumactuallaborunits sumactuallaborunits
,P.sumactualmaterialcost sumactualmaterialcost
,P.sumactualnonlaborcost sumactualnonlaborcost
,P.sumactualnonlaborunits sumactualnonlaborunits
,P.sumactualstartdate sumactualstartdate
,P.sumactualthisperiodcost sumactualthisperiodcost
,P.sumactualtotalcost sumactualtotalcost
,P.sumactualvaluebycost sumactualvaluebycost
,P.sumactualvaluebylaborunits sumactualvaluebylaborunits
,P.sumatcompletionduration sumatcompletionduration
,P.sumatcompletionexpensecost sumatcompletionexpensecost
,P.sumatcompletionlaborcost sumatcompletionlaborcost
,P.sumatcompletionlaborunits sumatcompletionlaborunits
,P.sumatcompletiontotalcost sumatcompletiontotalcost
,P.sumbaselineduration sumbaselineduration
,P.sumbaselineexpensecost sumbaselineexpensecost
,P.sumbaselinefinishdate sumbaselinefinishdate
,P.sumbaselinelaborcost sumbaselinelaborcost
,P.sumbaselinelaborunits sumbaselinelaborunits
,P.sumbaselinematerialcost sumbaselinematerialcost
,P.sumbaselinenonlaborcost sumbaselinenonlaborcost
,P.sumbaselinenonlaborunits sumbaselinenonlaborunits
,P.sumbaselinestartdate sumbaselinestartdate
,P.sumbaselinetotalcost sumbaselinetotalcost
,P.sumcompletedactivitycount sumcompletedactivitycount
,P.sumcostpercentcomplete sumcostpercentcomplete
,P.sumcostpercentofplanned sumcostpercentofplanned
,P.sumcostvariancebycost sumcostvariancebycost
,P.sumcostvarianceindex sumcostvarianceindex
,P.sumcostvarianceindexbycost sumcostvarianceindexbycost
,P.sumdurationpercentcomplete sumdurationpercentcomplete
,P.sumdurationvariance sumdurationvariance
,P.sumearnedvaluebycost sumearnedvaluebycost
,P.sumearnedvaluebylaborunits sumearnedvaluebylaborunits
,P.sumexpensecostvariance sumexpensecostvariance
,P.sumfinishdatevariance sumfinishdatevariance
,P.suminprogressactivitycount suminprogressactivitycount
,P.sumlaborcostvariance sumlaborcostvariance
,P.sumlaborunitsvariance sumlaborunitsvariance
,P.summaterialcostvariance summaterialcostvariance
,P.sumnonlaborcostvariance sumnonlaborcostvariance
,P.sumnonlaborunitsvariance sumnonlaborunitsvariance
,P.sumnotstartedactivitycount sumnotstartedactivitycount
,P.sumplannedvaluebycost sumplannedvaluebycost
,P.sumprogressfinishdate sumprogressfinishdate
,P.sumremainingduration sumremainingduration
,P.sumremainingexpensecost sumremainingexpensecost
,P.sumremainingfinishdate sumremainingfinishdate
,P.sumremaininglaborcost sumremaininglaborcost
,P.sumremaininglaborunits sumremaininglaborunits
,P.sumremainingmaterialcost sumremainingmaterialcost
,P.sumremainingnonlaborcost sumremainingnonlaborcost
,P.sumremainingnonlaborunits sumremainingnonlaborunits
,P.sumremainingstartdate sumremainingstartdate
,P.sumremainingtotalcost sumremainingtotalcost
,P.sumschedulepercentcomplete sumschedulepercentcomplete
,P.sumperformancepercentcomplete sumperformancepercentcomplete
,P.sumschedulevariancebycost sumschedulevariancebycost
,P.sumschedulevarianceindex sumschedulevarianceindex
,P.sumstartdatevariance sumstartdatevariance
,P.sumtotalcostvariance sumtotalcostvariance
,P.sumtotalfloat sumtotalfloat
,P.sumunitspercentcomplete sumunitspercentcomplete
,P.summaterialcostpctcomplete summaterialcostpctcomplete
,P.sumnonlaborcostpctcomplete sumnonlaborcostpctcomplete
,P.sumnonlaborunitspctcomplete sumnonlaborunitspctcomplete
,P.sumperfpctcmpbylaborunits sumperfpctcmpbylaborunits
,P.sumplannedvaluebylaborunits sumplannedvaluebylaborunits
,P.sumschdpctcmpbylaborunits sumschdpctcmpbylaborunits
,P.sumschdperfindexbylaborunits sumschdperfindexbylaborunits
,P.sumschdvariancebylaborunits sumschdvariancebylaborunits
,P.sumschdvarianceindexbycost sumschdvarianceindexbycost
,P.sumschdvarindexbylaborunits sumschdvarindexbylaborunits
,P.sumscheduleperfindexbycost sumscheduleperfindexbycost
,P.sumtocompleteperfindexbycost sumtocompleteperfindexbycost
,P.sumvaratcmpbylaborunits sumvaratcmpbylaborunits
,P.sumearlystartdate sumearlystartdate
,P.sumearlyenddate sumearlyenddate
,P.sumlatestartdate sumlatestartdate
,P.sumlateenddate sumlateenddate
,P.summaxcalendarid summaxcalendarid
,P.summincalendarid summincalendarid
,P.totalbenefitplan totalbenefitplan
,P.totalbenefitplantally totalbenefitplantally
,P.totalspendingplan totalspendingplan
,P.totalspendingplantally totalspendingplantally
,P.unallocatedbudget unallocatedbudget
,P.undistributedcurrentvariance undistributedcurrentvariance
,a.status_reviewer statusreviewerobjectid
,P.statusreviewername statusreviewername
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
,P.update_dim_date lastupdatedatex 
,case when a.update_date>P.update_date then 'N' ELSE 'Y' END rpt_current_flag
 FROM ${pm.or.administrative_user}.PROJWBS A 
   INNER JOIN ${pm.or.administrative_user}.PROJWBSX P
   ON a.wbs_id = p.wbs_id
   INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab
   ON a.proj_id = projects_tab.proj_id
WHERE A.DELETE_SESSION_ID is null
AND projects_tab.PROJECT_FLAG = 'Y'
AND projects_tab.ORIG_PROJ_ID IS NULL
/
     
prompt creating view WBSCATEGORY

--METADATA NAME:WBSCATEGORY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW WBSCATEGORY
AS SELECT a.phase_id objectid
,a.seq_num sequencenumber
,a.phase_name name
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.PHASE A
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view WBSMILESTONE

--METADATA NAME:WBSMILESTONE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW WBSMILESTONE
AS SELECT a.wbs_step_id objectid
,a.proj_id projectobjectid
,a.wbs_id wbsobjectid
,a.seq_num sequencenumber
,a.complete_flag iscompleted
,a.step_name name
,a.step_wt weight
,P.projectid projectid
,P.wbscode wbscode
,P.wbsname wbsname
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.WBSSTEP A 
   INNER JOIN ${pm.or.administrative_user}.WBSSTEPX P
   ON a.wbs_step_id = p.wbs_step_id
WHERE A.DELETE_SESSION_ID is null
/
     
prompt creating view PROJECTETLLIST

--METADATA NAME:PROJECTETLLIST TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTETLLIST
AS SELECT a.etl_id objectid
,b.proj_id projectobjectid
,a.update_date lastupdatedate
 FROM ${pm.or.administrative_user}.PROJECT_ETL_LIST A
   INNER JOIN ${pm.or.administrative_user}.PROJECTX B
   ON a.proj_id = b.proj_id
/
     
prompt creating view BLACTIVITY

--METADATA NAME:BLACTIVITY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW BLACTIVITY
AS SELECT a.task_id objectid
,a.proj_id projectobjectid
,a.wbs_id wbsobjectid
,a.clndr_id calendarobjectid
,a.rev_fdbk_flag isnewfeedback
,a.auto_compute_act_flag autocomputeactuals
,CASE a.complete_pct_type WHEN 'CP_Phys' THEN 'Physical' WHEN 'CP_Drtn' THEN 'Duration' WHEN 'CP_Units' THEN 'Units' WHEN 'CP_Scope' THEN 'Scope' ELSE a.complete_pct_type END percentcompletetype
,CASE a.task_type WHEN 'TT_Task' THEN 'Task Dependent' WHEN 'TT_Rsrc' THEN 'Resource Dependent' WHEN 'TT_LOE' THEN 'Level Of Effort' WHEN 'TT_Mile' THEN 'Start Milestone' WHEN 'TT_FinMile' THEN 'Finish Milestone' WHEN 'TT_WBS' THEN 'WBS Summary' ELSE a.task_type END type
,CASE a.duration_type WHEN 'DT_FixedRate' THEN 'Fixed Units/Time' WHEN 'DT_FixedDrtn' THEN 'Fixed Duration & Units/Time' WHEN 'DT_FixedQty' THEN 'Fixed Units' WHEN 'DT_FixedDUR2' THEN 'Fixed Duration & Units' ELSE a.duration_type END durationtype
,CASE a.review_type WHEN 'RV_OK' THEN 'OK' WHEN 'RV_Review' THEN 'For Review' WHEN 'RV_Reject' THEN 'Reject' ELSE a.review_type END reviewstatus
,CASE a.status_code WHEN 'TK_NotStart' THEN 'Not Started' WHEN 'TK_Active' THEN 'In Progress' WHEN 'TK_Complete' THEN 'Completed' ELSE a.status_code END status
,a.task_code id
,a.task_name name
,a.rsrc_id primaryresourceobjectid
,a.total_float_hr_cnt totalfloat
,a.free_float_hr_cnt freefloat
,a.remain_drtn_hr_cnt remainingduration
,a.act_work_qty actuallaborunits
,a.remain_work_qty remaininglaborunits
,a.target_work_qty plannedlaborunits
,a.target_drtn_hr_cnt plannedduration
,a.target_equip_qty plannednonlaborunits
,a.act_equip_qty actualnonlaborunits
,a.remain_equip_qty remainingnonlaborunits
,a.cstr_date primaryconstraintdate
,a.act_start_date actualstartdate
,a.act_end_date actualfinishdate
,a.late_start_date latestartdate
,a.late_end_date latefinishdate
,a.expect_end_date expectedfinishdate
,a.early_start_date earlystartdate
,a.early_end_date earlyfinishdate
,a.restart_date remainingearlystartdate
,a.reend_date remainingearlyfinishdate
,a.target_start_date plannedstartdate
,a.target_end_date plannedfinishdate
,a.review_end_date reviewfinishdate
,a.rem_late_start_date remaininglatestartdate
,a.rem_late_end_date remaininglatefinishdate
,CASE a.cstr_type WHEN 'CS_MSO' THEN 'Start On' WHEN 'CS_MSOB' THEN 'Start On or Before' WHEN 'CS_MSOA' THEN 'Start On or After' WHEN 'CS_MEO' THEN 'Finish On' WHEN 'CS_MEOB' THEN 'Finish On or Before' WHEN 'CS_MEOA' THEN 'Finish On or After' WHEN 'CS_ALAP' THEN 'As Late As Possible' WHEN 'CS_MANDSTART' THEN 'Mandatory Start' WHEN 'CS_MANDFIN' THEN 'Mandatory Finish' ELSE a.cstr_type END primaryconstrainttype
,CASE a.priority_type WHEN 'PT_Top' THEN 'Top' WHEN 'PT_High' THEN 'High' WHEN 'PT_Normal' THEN 'Normal' WHEN 'PT_Low' THEN 'Low' WHEN 'PT_Lowest' THEN 'Lowest' ELSE a.priority_type END levelingpriority
,a.cstr_date2 secondaryconstraintdate
,CASE a.cstr_type2 WHEN 'CS_MSO' THEN 'Start On' WHEN 'CS_MSOB' THEN 'Start On or Before' WHEN 'CS_MSOA' THEN 'Start On or After' WHEN 'CS_MEO' THEN 'Finish On' WHEN 'CS_MEOB' THEN 'Finish On or Before' WHEN 'CS_MEOA' THEN 'Finish On or After' WHEN 'CS_ALAP' THEN 'As Late As Possible' WHEN 'CS_MANDSTART' THEN 'Mandatory Start' WHEN 'CS_MANDFIN' THEN 'Mandatory Finish' ELSE a.cstr_type2 END secondaryconstrainttype
,a.float_path floatpath
,a.float_path_order floatpathorder
,a.act_this_per_work_qty actualthisperiodlaborunits
,a.act_this_per_equip_qty actualthisperiodnonlaborunits
,a.driving_path_flag islongestpath
,a.suspend_date suspenddate
,a.resume_date resumedate
,a.external_early_start_date externalearlystartdate
,a.external_late_end_date externallatefinishdate
,P.accountingvariance accountingvariance
,P.accountingvariancelaborunits accountingvariancelaborunits
,P.actualduration actualduration
,P.actualexpensecost actualexpensecost
,P.actuallaborcost actuallaborcost
,P.actualmaterialcost actualmaterialcost
,P.actualnonlaborcost actualnonlaborcost
,P.actualthisperiodlaborcost actualthisperiodlaborcost
,P.actualthisperiodmaterialcost actualthisperiodmaterialcost
,P.actualthisperiodnonlaborcost actualthisperiodnonlaborcost
,P.actualtotalcost actualtotalcost
,P.actualtotalunits actualtotalunits
,P.atcompletionduration atcompletionduration
,P.atcompletionexpensecost atcompletionexpensecost
,P.atcompletionlaborcost atcompletionlaborcost
,P.atcompletionlaborunits atcompletionlaborunits
,P.atcompletionlaborunitsvariance atcompletionlaborunitsvariance
,P.atcompletionmaterialcost atcompletionmaterialcost
,P.atcompletionnonlaborcost atcompletionnonlaborcost
,P.atcompletionnonlaborunits atcompletionnonlaborunits
,P.atcompletiontotalcost atcompletiontotalcost
,P.atcompletiontotalunits atcompletiontotalunits
,P.atcompletionvariance atcompletionvariance
,P.baselineduration baselineduration
,P.baselinefinishdate baselinefinishdate
,P.baselineplannedduration baselineplannedduration
,P.baselineplannedexpensecost baselineplannedexpensecost
,P.baselineplannedlaborcost baselineplannedlaborcost
,P.baselineplannedlaborunits baselineplannedlaborunits
,P.baselineplannedmaterialcost baselineplannedmaterialcost
,P.baselineplannednonlaborcost baselineplannednonlaborcost
,P.baselineplannednonlaborunits baselineplannednonlaborunits
,P.baselineplannedtotalcost baselineplannedtotalcost
,P.baselinestartdate baselinestartdate
,P.baselinelatestartdate baselinelatestartdate
,P.baseline1latestartdate baseline1latestartdate
,P.baselinelatefinishdate baselinelatefinishdate
,P.baseline1latefinishdate baseline1latefinishdate
,P.budgetatcompletion budgetatcompletion
,P.calendarname calendarname
,P.costpercentcomplete costpercentcomplete
,P.costpercentofplanned costpercentofplanned
,P.costperformanceindex costperformanceindex
,P.costperformanceindexlaborunits costperformanceindexlaborunits
,P.costvariance costvariance
,P.costvarianceindex costvarianceindex
,P.costvarianceindexlaborunits costvarianceindexlaborunits
,P.costvariancelaborunits costvariancelaborunits
,(select datadate  FROM ${pm.or.administrative_user}.projectx px where px.proj_id=a.proj_id) as  datadate
,P.duration1variance duration1variance
,P.durationpercentcomplete durationpercentcomplete
,P.durationpercentofplanned durationpercentofplanned
,P.durationvariance durationvariance
,P.earnedvaluecost earnedvaluecost
,P.earnedvaluelaborunits earnedvaluelaborunits
,P.estimateatcompletioncost estimateatcompletioncost
,P.estimateatcompletionlaborunits estimateatcompletionlaborunits
,P.estimatetocomplete estimatetocomplete
,P.estimatetocompletelaborunits estimatetocompletelaborunits
,P.expensecost1variance expensecost1variance
,P.expensecostpercentcomplete expensecostpercentcomplete
,P.expensecostvariance expensecostvariance
,P.finishdate finishdate
,P.finishdate1variance finishdate1variance
,P.finishdatevariance finishdatevariance
,P.iscritical iscritical
,P.laborcost1variance laborcost1variance
,P.laborcostpercentcomplete laborcostpercentcomplete
,P.laborcostvariance laborcostvariance
,P.laborunits1variance laborunits1variance
,P.laborunitspercentcomplete laborunitspercentcomplete
,P.laborunitsvariance laborunitsvariance
,P.materialcost1variance materialcost1variance
,P.materialcostpercentcomplete materialcostpercentcomplete
,P.materialcostvariance materialcostvariance
,P.nonlaborcost1variance nonlaborcost1variance
,P.nonlaborcostpercentcomplete nonlaborcostpercentcomplete
,P.nonlaborcostvariance nonlaborcostvariance
,P.nonlaborunits1variance nonlaborunits1variance
,P.nonlaborunitspercentcomplete nonlaborunitspercentcomplete
,P.nonlaborunitsvariance nonlaborunitsvariance
,P.percentcomplete percentcomplete
,P.performancepercentcomplete performancepercentcomplete
,P.physicalpercentcomplete physicalpercentcomplete
,P.plannedexpensecost plannedexpensecost
,P.plannedlaborcost plannedlaborcost
,P.plannedmaterialcost plannedmaterialcost
,P.plannednonlaborcost plannednonlaborcost
,P.plannedtotalcost plannedtotalcost
,P.plannedtotalunits plannedtotalunits
,P.plannedvaluecost plannedvaluecost
,P.plannedvaluelaborunits plannedvaluelaborunits
,P.primaryresourceid primaryresourceid
,P.primaryresourcename primaryresourcename
,P.remainingexpensecost remainingexpensecost
,P.remainingfloat remainingfloat
,P.remaininglaborcost remaininglaborcost
,P.remainingmaterialcost remainingmaterialcost
,P.remainingnonlaborcost remainingnonlaborcost
,P.remainingtotalcost remainingtotalcost
,P.remainingtotalunits remainingtotalunits
,P.schedulepercentcomplete schedulepercentcomplete
,P.scheduleperfindexlaborunits scheduleperfindexlaborunits
,P.scheduleperformanceindex scheduleperformanceindex
,P.schedulevariance schedulevariance
,P.schedulevarianceindex schedulevarianceindex
,P.schedulevariancelaborunits schedulevariancelaborunits
,P.schedulevarindexlaborunits schedulevarindexlaborunits
,P.startdate startdate
,P.startdate1variance startdate1variance
,P.startdatevariance startdatevariance
,P.tocompleteperformanceindex tocompleteperformanceindex
,P.totalcost1variance totalcost1variance
,P.totalcostvariance totalcostvariance
,P.unitspercentcomplete unitspercentcomplete
,P.wbscode wbscode
,P.wbsname wbsname
,a.location_id locationobjectid
,P.locationname locationname
,a.control_updates_flag reviewrequired
,a.starred_flag isstarred
,a.cbs_code cbscode
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
,P.update_date lastupdatedatex
,P.activityownerobjectid activityownerobjectid
,P.activityowner activityowner 
,case when a.update_date>P.update_date then 'N' ELSE 'Y' END rpt_current_flag
 FROM ${pm.or.administrative_user}.TASK A 
   INNER JOIN ${pm.or.administrative_user}.TASKX P
   ON a.task_id = p.task_id
   INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab
   ON a.proj_id = projects_tab.proj_id
WHERE 1 = 1
AND A.DELETE_SESSION_ID is null 
AND projects_tab.ORIG_PROJ_ID IS NOT NULL
AND projects_tab.ORIG_PROJ_ID <> projects_tab.PROJ_ID
/
     
prompt creating view BLPROJECT

--METADATA NAME:BLPROJECT TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW BLPROJECT
AS SELECT a.proj_id objectid
,a.proj_short_name id
,a.fy_start_month_num fiscalyearstartmonth
,a.chng_eff_cmp_pct_flag resourcescaneditasgnmtpctcmp
,a.rsrc_self_add_flag resourcescanselfassigntoacts
,a.allow_complete_flag primaryrescanmarkactsascmp
,a.rsrc_multi_assign_flag resourcecanassigntosameact
,a.checkout_flag checkoutstatus
,a.step_complete_flag activitypctcmpbasedonsteps
,a.cost_qty_recalc_flag costquantityrecalculateflag
,a.sum_only_flag containssummarydataonly
,a.batch_sum_flag enablesummarization
,a.name_sep_char wbscodeseparator
,CASE a.def_complete_pct_type WHEN 'CP_Phys' THEN 'Physical' WHEN 'CP_Drtn' THEN 'Duration' WHEN 'CP_Units' THEN 'Units' WHEN 'CP_Scope' THEN 'Scope' WHEN 'CP_Phys' THEN 'Physical' WHEN 'CP_Drtn' THEN 'Duration' WHEN 'CP_Units' THEN 'Units' WHEN 'CP_Scope' THEN 'Scope' ELSE a.def_complete_pct_type END activitydefaultpctcmptype
,a.acct_id activitydefcostacctobjectid
,a.clndr_id activitydefcalendarobjectid
,a.sum_base_proj_id currentbaselineprojectobjectid
,a.task_code_base activityidsuffix
,a.task_code_step activityidincrement
,a.priority_num levelingpriority
,a.wbs_max_sum_level summarizetowbslevel
,a.strgy_priority_num strategicpriority
,a.critical_drtn_hr_cnt criticalactivityfloatlimit
,a.def_cost_per_qty activitydefaultpriceperunit
,a.plan_start_date plannedstartdate
,a.plan_end_date mustfinishbydate
,a.scd_end_date scheduledfinishdate
,a.add_date dateadded
,a.sum_data_date summarizeddatadate
,a.last_tasksum_date lastsummarizeddate
,a.fcst_start_date projectforecaststartdate
,CASE a.def_duration_type WHEN 'DT_FixedRate' THEN 'Fixed Units/Time' WHEN 'DT_FixedDrtn' THEN 'Fixed Duration & Units/Time' WHEN 'DT_FixedQty' THEN 'Fixed Units' WHEN 'DT_FixedDUR2' THEN 'Fixed Duration & Units' WHEN 'DT_FixedRate' THEN 'Fixed Units/Time' WHEN 'DT_FixedDrtn' THEN 'Fixed Duration & Units/Time' WHEN 'DT_FixedQty' THEN 'Fixed Units' WHEN 'DT_FixedDUR2' THEN 'Fixed Duration & Units' ELSE a.def_duration_type END activitydefaultdurationtype
,a.task_code_prefix activityidprefix
,CASE a.def_qty_type WHEN 'QT_Hour' THEN 'Hour' WHEN 'QT_Day' THEN 'Day' WHEN 'QT_Week' THEN 'Week' WHEN 'QT_Month' THEN 'Month' WHEN 'QT_Year' THEN 'Year' WHEN 'QT_DaysHours' THEN '??enm.UnitType.QT_DaysHours??' WHEN 'QT_HoursMinutes' THEN '??enm.UnitType.QT_HoursMinutes??' WHEN 'QT_Hour' THEN 'Hour' WHEN 'QT_Day' THEN 'Day' WHEN 'QT_Week' THEN 'Week' WHEN 'QT_Month' THEN 'Month' WHEN 'QT_Year' THEN 'Year' WHEN 'QT_DaysHours' THEN '??enm.UnitType.QT_DaysHours??' WHEN 'QT_HoursMinutes' THEN '??enm.UnitType.QT_HoursMinutes??' ELSE a.def_qty_type END defaultpricetimeunits
,a.add_by_name addedby
,a.web_local_root_path websiterootdirectory
,a.proj_url websiteurl
,CASE a.def_rate_type WHEN 'COST_PER_QTY' THEN 'Cost Per Qty' WHEN 'COST_PER_QTY2' THEN 'CostPerQty2' WHEN 'COST_PER_QTY3' THEN 'CostPerQty3' WHEN 'COST_PER_QTY4' THEN 'CostPerQty4' WHEN 'COST_PER_QTY5' THEN 'CostPerQty5' WHEN 'COST_PER_QTY' THEN 'Cost Per Qty' WHEN 'COST_PER_QTY2' THEN 'CostPerQty2' WHEN 'COST_PER_QTY3' THEN 'CostPerQty3' WHEN 'COST_PER_QTY4' THEN 'CostPerQty4' WHEN 'COST_PER_QTY5' THEN 'CostPerQty5' ELSE a.def_rate_type END assignmentdefaultratetype
,a.act_this_per_link_flag linkactualtoactualthisperiod
,CASE a.def_task_type WHEN 'TT_Task' THEN 'Task Dependent' WHEN 'TT_Rsrc' THEN 'Resource Dependent' WHEN 'TT_LOE' THEN 'Level Of Effort' WHEN 'TT_Mile' THEN 'Start Milestone' WHEN 'TT_FinMile' THEN 'Finish Milestone' WHEN 'TT_WBS' THEN 'WBS Summary' WHEN 'TT_Task' THEN 'Task Dependent' WHEN 'TT_Rsrc' THEN 'Resource Dependent' WHEN 'TT_LOE' THEN 'Level Of Effort' WHEN 'TT_Mile' THEN 'Start Milestone' WHEN 'TT_FinMile' THEN 'Finish Milestone' WHEN 'TT_WBS' THEN 'WBS Summary' ELSE a.def_task_type END activitydefaultactivitytype
,a.act_pct_link_flag linkpercentcompletewithactual
,a.add_act_remain_flag addactualtoremaining
,CASE a.critical_path_type WHEN 'CT_TotFloat' THEN 'Critical Float' WHEN 'CT_DrivPath' THEN 'Longest Path' WHEN 'CT_TotFloat' THEN 'Critical Float' WHEN 'CT_DrivPath' THEN 'Longest Path' ELSE a.critical_path_type END criticalactivitypathtype
,a.task_code_prefix_flag activityidbasedonselactivity
,a.def_rollup_dates_flag assignmentdefaultdrivingflag
,a.rem_target_link_flag linkplannedandatcompletionflag
,a.reset_planned_flag resetplannedtoremainingflag
,a.allow_neg_act_flag allownegativeactualunitsflag
,a.rsrc_id ownerresourceobjectid
,a.checkout_date checkoutdate
,a.checkout_user_id checkoutuserobjectid
,a.last_fin_dates_id lastfinancialperiodobjectid
,a.use_project_baseline_flag useprojectblforearnedvalue
,P.annualdiscountrate annualdiscountrate
,P.anticipatedfinishdate anticipatedfinishdate
,P.anticipatedstartdate anticipatedstartdate
,P.containssummarydata containssummarydata
,P.currentbudget currentbudget
,P.currentvariance currentvariance
,P.datadate datadate
,P.discountapplicationperiod discountapplicationperiod
,P.distributedcurrentbudget distributedcurrentbudget
,P.earnedvaluecomputetype earnedvaluecomputetype
,P.earnedvalueetccomputetype earnedvalueetccomputetype
,P.earnedvalueetcuservalue earnedvalueetcuservalue
,P.earnedvalueuserpercent earnedvalueuserpercent
,P.finishdate finishdate
,P.forecastfinishdate forecastfinishdate
,P.forecaststartdate forecaststartdate
,P.independentetclaborunits independentetclaborunits
,P.independentetctotalcost independentetctotalcost
,P.name name
,P.obsname obsname
,P.obsobjectid obsobjectid
,P.originalbudget originalbudget
,P.overallprojectscore overallprojectscore
,P.parentepsobjectid parentepsobjectid
,P.proposedbudget proposedbudget
,P.risklevel risklevel
,P.riskscore riskscore
,P.riskexposure riskexposure
,P.startdate startdate
,P.status status
,a.orig_proj_id originalprojectobjectid
,a.matrix_id riskscorematrixobjectid
,P.sumplannedstartdate sumplannedstartdate
,P.sumplannedfinishdate sumplannedfinishdate
,P.sumplannedduration sumplannedduration
,P.sumplannedlaborunits sumplannedlaborunits
,P.sumplannednonlaborunits sumplannednonlaborunits
,P.sumplannedexpensecost sumplannedexpensecost
,P.sumplannedlaborcost sumplannedlaborcost
,P.sumplannedmaterialcost sumplannedmaterialcost
,P.sumplannednonlaborcost sumplannednonlaborcost
,P.sumplannedtotalcost sumplannedtotalcost
,P.sumaccountingvarbylaborunits sumaccountingvarbylaborunits
,P.sumaccountingvariancebycost sumaccountingvariancebycost
,P.sumactthisperiodmaterialcost sumactthisperiodmaterialcost
,P.sumactthisperiodnonlaborcost sumactthisperiodnonlaborcost
,P.sumactthisperiodnonlaborunits sumactthisperiodnonlaborunits
,P.sumactualthisperiodlaborcost sumactualthisperiodlaborcost
,P.sumactualthisperiodlaborunits sumactualthisperiodlaborunits
,P.sumatcompletionmaterialcost sumatcompletionmaterialcost
,P.sumatcompletionnonlaborcost sumatcompletionnonlaborcost
,P.sumatcompletionnonlaborunits sumatcompletionnonlaborunits
,P.sumatcompletiontotalcostvar sumatcompletiontotalcostvar
,P.sumbaselinecompactivitycount sumbaselinecompactivitycount
,P.sumbaselinenotstartedactcnt sumbaselinenotstartedactcnt
,P.sumblinprogressactivitycount sumblinprogressactivitycount
,P.sumbudgetatcmpbylaborunits sumbudgetatcmpbylaborunits
,P.sumbudgetatcompletionbycost sumbudgetatcompletionbycost
,P.sumcostperfindexbycost sumcostperfindexbycost
,P.sumcostperfindexbylaborunits sumcostperfindexbylaborunits
,P.sumcostvariancebylaborunits sumcostvariancebylaborunits
,P.sumcostvarindexbylaborunits sumcostvarindexbylaborunits
,P.sumdurationpercentofplanned sumdurationpercentofplanned
,P.sumeacbycost sumeacbycost
,P.sumeacbylaborunits sumeacbylaborunits
,P.sumeachighpctbylaborunits sumeachighpctbylaborunits
,P.sumeaclowpctbylaborunits sumeaclowpctbylaborunits
,P.sumetcbycost sumetcbycost
,P.sumetcbylaborunits sumetcbylaborunits
,P.sumexpensecostpctcomplete sumexpensecostpctcomplete
,P.sumlaborcostpercentcomplete sumlaborcostpercentcomplete
,P.sumlaborunitspercentcomplete sumlaborunitspercentcomplete
,P.sumactivitycount sumactivitycount
,P.sumactualduration sumactualduration
,P.sumactualexpensecost sumactualexpensecost
,P.sumactualfinishdate sumactualfinishdate
,P.summaxactualfinishdate summaxactualfinishdate
,P.summaxrestartdate summaxrestartdate
,P.sumactuallaborcost sumactuallaborcost
,P.sumactuallaborunits sumactuallaborunits
,P.sumactualmaterialcost sumactualmaterialcost
,P.sumactualnonlaborcost sumactualnonlaborcost
,P.sumactualnonlaborunits sumactualnonlaborunits
,P.sumactualstartdate sumactualstartdate
,P.sumactualthisperiodcost sumactualthisperiodcost
,P.sumactualtotalcost sumactualtotalcost
,P.sumactualvaluebycost sumactualvaluebycost
,P.sumactualvaluebylaborunits sumactualvaluebylaborunits
,P.sumatcompletionduration sumatcompletionduration
,P.sumatcompletionexpensecost sumatcompletionexpensecost
,P.sumatcompletionlaborcost sumatcompletionlaborcost
,P.sumatcompletionlaborunits sumatcompletionlaborunits
,P.sumatcompletiontotalcost sumatcompletiontotalcost
,P.sumbaselineduration sumbaselineduration
,P.sumbaselineexpensecost sumbaselineexpensecost
,P.sumbaselinefinishdate sumbaselinefinishdate
,P.sumbaselinelaborcost sumbaselinelaborcost
,P.sumbaselinelaborunits sumbaselinelaborunits
,P.sumbaselinematerialcost sumbaselinematerialcost
,P.sumbaselinenonlaborcost sumbaselinenonlaborcost
,P.sumbaselinenonlaborunits sumbaselinenonlaborunits
,P.sumbaselinestartdate sumbaselinestartdate
,P.sumbaselinetotalcost sumbaselinetotalcost
,P.sumcompletedactivitycount sumcompletedactivitycount
,P.sumcostpercentcomplete sumcostpercentcomplete
,P.sumcostpercentofplanned sumcostpercentofplanned
,P.sumcostvariancebycost sumcostvariancebycost
,P.sumcostvarianceindex sumcostvarianceindex
,P.sumcostvarianceindexbycost sumcostvarianceindexbycost
,P.sumdurationpercentcomplete sumdurationpercentcomplete
,P.sumdurationvariance sumdurationvariance
,P.sumearnedvaluebycost sumearnedvaluebycost
,P.sumearnedvaluebylaborunits sumearnedvaluebylaborunits
,P.sumexpensecostvariance sumexpensecostvariance
,P.sumfinishdatevariance sumfinishdatevariance
,P.suminprogressactivitycount suminprogressactivitycount
,P.sumlaborcostvariance sumlaborcostvariance
,P.sumlaborunitsvariance sumlaborunitsvariance
,P.summaterialcostvariance summaterialcostvariance
,P.sumnonlaborcostvariance sumnonlaborcostvariance
,P.sumnonlaborunitsvariance sumnonlaborunitsvariance
,P.sumnotstartedactivitycount sumnotstartedactivitycount
,P.sumplannedvaluebycost sumplannedvaluebycost
,P.sumprogressfinishdate sumprogressfinishdate
,P.sumremainingduration sumremainingduration
,P.sumremainingexpensecost sumremainingexpensecost
,P.sumremainingfinishdate sumremainingfinishdate
,P.sumremaininglaborcost sumremaininglaborcost
,P.sumremaininglaborunits sumremaininglaborunits
,P.sumremainingmaterialcost sumremainingmaterialcost
,P.sumremainingnonlaborcost sumremainingnonlaborcost
,P.sumremainingnonlaborunits sumremainingnonlaborunits
,P.sumremainingstartdate sumremainingstartdate
,P.sumremainingtotalcost sumremainingtotalcost
,P.sumschedulepercentcomplete sumschedulepercentcomplete
,P.sumperformancepercentcomplete sumperformancepercentcomplete
,P.sumschedulevariancebycost sumschedulevariancebycost
,P.sumschedulevarianceindex sumschedulevarianceindex
,P.sumstartdatevariance sumstartdatevariance
,P.sumtotalcostvariance sumtotalcostvariance
,P.sumtotalfloat sumtotalfloat
,P.sumunitspercentcomplete sumunitspercentcomplete
,P.summaterialcostpctcomplete summaterialcostpctcomplete
,P.sumnonlaborcostpctcomplete sumnonlaborcostpctcomplete
,P.sumnonlaborunitspctcomplete sumnonlaborunitspctcomplete
,P.sumperfpctcmpbylaborunits sumperfpctcmpbylaborunits
,P.sumplannedvaluebylaborunits sumplannedvaluebylaborunits
,P.sumschdpctcmpbylaborunits sumschdpctcmpbylaborunits
,P.sumschdperfindexbylaborunits sumschdperfindexbylaborunits
,P.sumschdvariancebylaborunits sumschdvariancebylaborunits
,P.sumschdvarianceindexbycost sumschdvarianceindexbycost
,P.sumschdvarindexbylaborunits sumschdvarindexbylaborunits
,P.sumscheduleperfindexbycost sumscheduleperfindexbycost
,P.sumtocompleteperfindexbycost sumtocompleteperfindexbycost
,P.sumvaratcmpbylaborunits sumvaratcmpbylaborunits
,P.sumearlystartdate sumearlystartdate
,P.sumearlyenddate sumearlyenddate
,P.sumlatestartdate sumlatestartdate
,P.sumlateenddate sumlateenddate
,P.summaxcalendarid summaxcalendarid
,P.summincalendarid summincalendarid
,P.totalbenefitplan totalbenefitplan
,P.totalbenefitplantally totalbenefitplantally
,P.totalfunding totalfunding
,P.totalspendingplan totalspendingplan
,P.totalspendingplantally totalspendingplantally
,P.unallocatedbudget unallocatedbudget
,P.netpresentvalue netpresentvalue
,P.returnoninvestment returnoninvestment
,P.paybackperiod paybackperiod
,P.undistributedcurrentvariance undistributedcurrentvariance
,a.description projectdescription
,a.base_type_id baselinetypeobjectid
,a.px_enable_publication_flag enablepublication
,a.px_next_date nextpublicationdate
,a.px_last_update_date lastpublishedon
,a.px_priority publicationpriority
,a.location_id locationobjectid
,a.hist_interval historyinterval
,a.hist_level historylevel
,P.locationname locationname
,a.control_updates_flag allowstatusreview
,P.statusreviewerobjectid statusreviewerobjectid
,P.statusreviewername statusreviewername
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.etl_interval etlinterval
,a.etl_hour etlhour
,a.create_date createdate
,P.update_dim_date lastupdatedatex
 FROM ${pm.or.administrative_user}.PROJECT A 
   INNER JOIN ${pm.or.administrative_user}.PROJECTX P
   ON a.proj_id = p.proj_id
   INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab
   ON a.proj_id = projects_tab.proj_id
WHERE 1 = 1
AND A.DELETE_SESSION_ID is null 
AND a.ORIG_PROJ_ID IS NOT NULL
AND a.ORIG_PROJ_ID <> projects_tab.PROJ_ID
/
     
prompt creating view BLWBS

--METADATA NAME:BLWBS TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW BLWBS
AS SELECT a.wbs_id objectid
,a.proj_id projectobjectid
,a.obs_id obsobjectid
,a.seq_num sequencenumber
,a.sum_data_flag containssummarydata
,CASE a.status_code WHEN 'WS_Planned' THEN 'Planned' WHEN 'WS_Open' THEN 'Active' WHEN 'WS_Closed' THEN 'Inactive' WHEN 'WS_Whatif' THEN 'What If' WHEN 'WS_Requested' THEN 'Requested' WHEN 'WS_Template' THEN 'Template' WHEN 'WS_Planned' THEN 'Planned' WHEN 'WS_Open' THEN 'Active' WHEN 'WS_Closed' THEN 'Inactive' WHEN 'WS_Whatif' THEN 'What If' WHEN 'WS_Requested' THEN 'Requested' WHEN 'WS_Template' THEN 'Template' ELSE a.status_code END status
,a.wbs_short_name code
,a.wbs_name name
,a.phase_id wbscategoryobjectid
,a.parent_wbs_id parentobjectid
,a.ev_user_pct earnedvalueuserpercent
,a.ev_etc_user_value earnedvalueetcuservalue
,a.orig_cost originalbudget
,a.indep_remain_total_cost independentetctotalcost
,a.indep_remain_work_qty independentetclaborunits
,a.anticip_start_date anticipatedstartdate
,a.anticip_end_date anticipatedfinishdate
,CASE a.ev_compute_type WHEN 'EC_Cmp_pct' THEN 'Activity Percent Complete' WHEN 'EC_0_pct' THEN 'Zero Hundred' WHEN 'EC_50_pct' THEN 'Fifty Fifty' WHEN 'EC_User_pct' THEN 'Custom Percent Complete' WHEN 'EC_MS' THEN 'WBS Milestones Percent Complete' WHEN 'EC_Curve' THEN 'Activity Percent Complete Using Resource Curve' WHEN 'EC_Cmp_pct' THEN 'Activity Percent Complete' WHEN 'EC_0_pct' THEN 'Zero Hundred' WHEN 'EC_50_pct' THEN 'Fifty Fifty' WHEN 'EC_User_pct' THEN 'Custom Percent Complete' WHEN 'EC_MS' THEN 'WBS Milestones Percent Complete' WHEN 'EC_Curve' THEN 'Activity Percent Complete Using Resource Curve' ELSE a.ev_compute_type END earnedvaluecomputetype
,CASE a.ev_etc_compute_type WHEN 'EE_Rem_hr' THEN 'Remaining Cost For Activity' WHEN 'EE_PF_1' THEN 'PF 1' WHEN 'EE_PF_user' THEN 'PF Custom' WHEN 'EE_PF_cpi' THEN 'PF CPI' WHEN 'EE_PF_cpi_spi' THEN 'PF CPI SPI' WHEN 'EE_Rem_hr' THEN 'Remaining Cost For Activity' WHEN 'EE_PF_1' THEN 'PF 1' WHEN 'EE_PF_user' THEN 'PF Custom' WHEN 'EE_PF_cpi' THEN 'PF CPI' WHEN 'EE_PF_cpi_spi' THEN 'PF CPI SPI' ELSE a.ev_etc_compute_type END earnedvalueetccomputetype
,a.proj_node_flag projectnodeflag
,P.currentbudget currentbudget
,P.currentvariance currentvariance
,P.distributedcurrentbudget distributedcurrentbudget
,P.finishdate finishdate
,P.forecastfinishdate forecastfinishdate
,P.forecaststartdate forecaststartdate
,P.fullname fullname
,P.fullsequence fullsequence
,P.obsname obsname
,P.projectid projectid
,P.proposedbudget proposedbudget
,P.startdate startdate
,P.sumplannedstartdate sumplannedstartdate
,P.sumplannedfinishdate sumplannedfinishdate
,P.sumplannedduration sumplannedduration
,P.sumplannedlaborunits sumplannedlaborunits
,P.sumplannednonlaborunits sumplannednonlaborunits
,P.sumplannedexpensecost sumplannedexpensecost
,P.sumplannedlaborcost sumplannedlaborcost
,P.sumplannedmaterialcost sumplannedmaterialcost
,P.sumplannednonlaborcost sumplannednonlaborcost
,P.sumplannedtotalcost sumplannedtotalcost
,P.sumaccountingvarbylaborunits sumaccountingvarbylaborunits
,P.sumaccountingvariancebycost sumaccountingvariancebycost
,P.sumactthisperiodmaterialcost sumactthisperiodmaterialcost
,P.sumactthisperiodnonlaborcost sumactthisperiodnonlaborcost
,P.sumactthisperiodnonlaborunits sumactthisperiodnonlaborunits
,P.sumactualthisperiodlaborcost sumactualthisperiodlaborcost
,P.sumactualthisperiodlaborunits sumactualthisperiodlaborunits
,P.sumatcompletionmaterialcost sumatcompletionmaterialcost
,P.sumatcompletionnonlaborcost sumatcompletionnonlaborcost
,P.sumatcompletionnonlaborunits sumatcompletionnonlaborunits
,P.sumatcompletiontotalcostvar sumatcompletiontotalcostvar
,P.sumbaselinecompactivitycount sumbaselinecompactivitycount
,P.sumbaselinenotstartedactcnt sumbaselinenotstartedactcnt
,P.sumblinprogressactivitycount sumblinprogressactivitycount
,P.sumbudgetatcmpbylaborunits sumbudgetatcmpbylaborunits
,P.sumbudgetatcompletionbycost sumbudgetatcompletionbycost
,P.sumcostperfindexbycost sumcostperfindexbycost
,P.sumcostperfindexbylaborunits sumcostperfindexbylaborunits
,P.sumcostvariancebylaborunits sumcostvariancebylaborunits
,P.sumcostvarindexbylaborunits sumcostvarindexbylaborunits
,P.sumdurationpercentofplanned sumdurationpercentofplanned
,P.sumeacbycost sumeacbycost
,P.sumeacbylaborunits sumeacbylaborunits
,P.sumeachighpctbylaborunits sumeachighpctbylaborunits
,P.sumeaclowpctbylaborunits sumeaclowpctbylaborunits
,P.sumetcbycost sumetcbycost
,P.sumetcbylaborunits sumetcbylaborunits
,P.sumexpensecostpctcomplete sumexpensecostpctcomplete
,P.sumlaborcostpercentcomplete sumlaborcostpercentcomplete
,P.sumlaborunitspercentcomplete sumlaborunitspercentcomplete
,P.sumactivitycount sumactivitycount
,P.sumactualduration sumactualduration
,P.sumactualexpensecost sumactualexpensecost
,P.sumactualfinishdate sumactualfinishdate
,P.summaxactualfinishdate summaxactualfinishdate
,P.summaxrestartdate summaxrestartdate
,P.sumactuallaborcost sumactuallaborcost
,P.sumactuallaborunits sumactuallaborunits
,P.sumactualmaterialcost sumactualmaterialcost
,P.sumactualnonlaborcost sumactualnonlaborcost
,P.sumactualnonlaborunits sumactualnonlaborunits
,P.sumactualstartdate sumactualstartdate
,P.sumactualthisperiodcost sumactualthisperiodcost
,P.sumactualtotalcost sumactualtotalcost
,P.sumactualvaluebycost sumactualvaluebycost
,P.sumactualvaluebylaborunits sumactualvaluebylaborunits
,P.sumatcompletionduration sumatcompletionduration
,P.sumatcompletionexpensecost sumatcompletionexpensecost
,P.sumatcompletionlaborcost sumatcompletionlaborcost
,P.sumatcompletionlaborunits sumatcompletionlaborunits
,P.sumatcompletiontotalcost sumatcompletiontotalcost
,P.sumbaselineduration sumbaselineduration
,P.sumbaselineexpensecost sumbaselineexpensecost
,P.sumbaselinefinishdate sumbaselinefinishdate
,P.sumbaselinelaborcost sumbaselinelaborcost
,P.sumbaselinelaborunits sumbaselinelaborunits
,P.sumbaselinematerialcost sumbaselinematerialcost
,P.sumbaselinenonlaborcost sumbaselinenonlaborcost
,P.sumbaselinenonlaborunits sumbaselinenonlaborunits
,P.sumbaselinestartdate sumbaselinestartdate
,P.sumbaselinetotalcost sumbaselinetotalcost
,P.sumcompletedactivitycount sumcompletedactivitycount
,P.sumcostpercentcomplete sumcostpercentcomplete
,P.sumcostpercentofplanned sumcostpercentofplanned
,P.sumcostvariancebycost sumcostvariancebycost
,P.sumcostvarianceindex sumcostvarianceindex
,P.sumcostvarianceindexbycost sumcostvarianceindexbycost
,P.sumdurationpercentcomplete sumdurationpercentcomplete
,P.sumdurationvariance sumdurationvariance
,P.sumearnedvaluebycost sumearnedvaluebycost
,P.sumearnedvaluebylaborunits sumearnedvaluebylaborunits
,P.sumexpensecostvariance sumexpensecostvariance
,P.sumfinishdatevariance sumfinishdatevariance
,P.suminprogressactivitycount suminprogressactivitycount
,P.sumlaborcostvariance sumlaborcostvariance
,P.sumlaborunitsvariance sumlaborunitsvariance
,P.summaterialcostvariance summaterialcostvariance
,P.sumnonlaborcostvariance sumnonlaborcostvariance
,P.sumnonlaborunitsvariance sumnonlaborunitsvariance
,P.sumnotstartedactivitycount sumnotstartedactivitycount
,P.sumplannedvaluebycost sumplannedvaluebycost
,P.sumprogressfinishdate sumprogressfinishdate
,P.sumremainingduration sumremainingduration
,P.sumremainingexpensecost sumremainingexpensecost
,P.sumremainingfinishdate sumremainingfinishdate
,P.sumremaininglaborcost sumremaininglaborcost
,P.sumremaininglaborunits sumremaininglaborunits
,P.sumremainingmaterialcost sumremainingmaterialcost
,P.sumremainingnonlaborcost sumremainingnonlaborcost
,P.sumremainingnonlaborunits sumremainingnonlaborunits
,P.sumremainingstartdate sumremainingstartdate
,P.sumremainingtotalcost sumremainingtotalcost
,P.sumschedulepercentcomplete sumschedulepercentcomplete
,P.sumperformancepercentcomplete sumperformancepercentcomplete
,P.sumschedulevariancebycost sumschedulevariancebycost
,P.sumschedulevarianceindex sumschedulevarianceindex
,P.sumstartdatevariance sumstartdatevariance
,P.sumtotalcostvariance sumtotalcostvariance
,P.sumtotalfloat sumtotalfloat
,P.sumunitspercentcomplete sumunitspercentcomplete
,P.summaterialcostpctcomplete summaterialcostpctcomplete
,P.sumnonlaborcostpctcomplete sumnonlaborcostpctcomplete
,P.sumnonlaborunitspctcomplete sumnonlaborunitspctcomplete
,P.sumperfpctcmpbylaborunits sumperfpctcmpbylaborunits
,P.sumplannedvaluebylaborunits sumplannedvaluebylaborunits
,P.sumschdpctcmpbylaborunits sumschdpctcmpbylaborunits
,P.sumschdperfindexbylaborunits sumschdperfindexbylaborunits
,P.sumschdvariancebylaborunits sumschdvariancebylaborunits
,P.sumschdvarianceindexbycost sumschdvarianceindexbycost
,P.sumschdvarindexbylaborunits sumschdvarindexbylaborunits
,P.sumscheduleperfindexbycost sumscheduleperfindexbycost
,P.sumtocompleteperfindexbycost sumtocompleteperfindexbycost
,P.sumvaratcmpbylaborunits sumvaratcmpbylaborunits
,P.sumearlystartdate sumearlystartdate
,P.sumearlyenddate sumearlyenddate
,P.sumlatestartdate sumlatestartdate
,P.sumlateenddate sumlateenddate
,P.summaxcalendarid summaxcalendarid
,P.summincalendarid summincalendarid
,P.totalbenefitplan totalbenefitplan
,P.totalbenefitplantally totalbenefitplantally
,P.totalspendingplan totalspendingplan
,P.totalspendingplantally totalspendingplantally
,P.unallocatedbudget unallocatedbudget
,P.undistributedcurrentvariance undistributedcurrentvariance
,a.status_reviewer statusreviewerobjectid
,P.statusreviewername statusreviewername
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end  lastupdatedate
,a.create_user createuser
,a.create_date createdate
,P.update_dim_date lastupdatedatex 
,case when a.update_date>P.update_date then 'N' ELSE 'Y' END rpt_current_flag
 FROM ${pm.or.administrative_user}.PROJWBS A 
   INNER JOIN ${pm.or.administrative_user}.PROJWBSX P
   ON a.wbs_id = p.wbs_id
   INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab
   ON a.proj_id = projects_tab.proj_id
WHERE 1 = 1
AND A.DELETE_SESSION_ID is null 
AND projects_tab.ORIG_PROJ_ID IS NOT NULL
AND projects_tab.ORIG_PROJ_ID <> projects_tab.PROJ_ID
/
     
prompt creating view RESOURCEASSIGNMENTSPREAD
--METADATA NAME:RESOURCEASSIGNMENTSPREAD TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCEASSIGNMENTSPREAD
AS
SELECT a.resourceassignmentobjectid  resourceassignmentobjectid
,a.startdate  startdate
,a.enddate  enddate
,a.resourceobjectid  resourceobjectid
,a.roleobjectid  roleobjectid
,a.activityobjectid  activityobjectid
,a.wbsobjectid  wbsobjectid
,a.projectobjectid  projectobjectid
,nvl(a.costaccountobjectid,0)  costaccountobjectid
,nvl(a.actualregularunits,0)  actualregularunits
,nvl(a.actualovertimeunits,0)  actualovertimeunits
,nvl(a.actualunits,0)  actualunits
,nvl(a.atcompletionunits,0)  atcompletionunits
,nvl(a.plannedunits,0)  plannedunits
,nvl(a.remainingunits,0)  remainingunits
,nvl(a.remaininglateunits,0)  remaininglateunits
,nvl(a.staffedremainingunits,0)  staffedremainingunits
,nvl(a.staffedremaininglateunits,0)  staffedremaininglateunits
,nvl(a.unstaffedremainingunits,0)  unstaffedremainingunits
,nvl(a.unstaffedremaininglateunits,0)  unstaffedremaininglateunits
,nvl(a.actualregularcost,0)  actualregularcost
,nvl(a.actualovertimecost,0)  actualovertimecost
,nvl(a.actualcost,0)  actualcost
,nvl(a.atcompletioncost,0)  atcompletioncost
,nvl(a.plannedcost,0)  plannedcost
,nvl(a.remainingcost,0)  remainingcost
,nvl(a.remaininglatecost,0)  remaininglatecost
,nvl(a.staffedremainingcost,0)  staffedremainingcost
,nvl(a.staffedremaininglatecost,0)  staffedremaininglatecost
,nvl(a.unstaffedremainingcost,0)  unstaffedremainingcost
,nvl(a.unstaffedremaininglatecost,0)  unstaffedremaininglatecost
,a.update_date  lastupdatedate
,T1.cbs_id cbsobjectid  
 FROM ${pm.or.administrative_user}.RESOURCEASSIGNMENTSPREAD a
    INNER JOIN ${pm.or.administrative_user}.TASKRSRC T1 
ON T1.taskrsrc_id = ResourceAssignmentObjectId  AND T1.DELETE_SESSION_ID IS NULL 
/
     
prompt creating view ACTIVITYSPREAD
--METADATA NAME:ACTIVITYSPREAD TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYSPREAD
AS
SELECT a.activityobjectid  activityobjectid
,a.startdate  startdate
,a.enddate  enddate
,a.activitycode  activitycode
,a.activityname  activityname
,a.wbsobjectid  wbsobjectid
,a.projectobjectid  projectobjectid
,a.actuallaborunits  actuallaborunits
,a.actualnonlaborunits  actualnonlaborunits
,a.atcompletionlaborunits  atcompletionlaborunits
,a.atcompletionnonlaborunits  atcompletionnonlaborunits
,a.baselineactuallaborunits  baselineactuallaborunits
,a.baselineactualnonlaborunits  baselineactualnonlaborunits
,a.baselineplannedlaborunits  baselineplannedlaborunits
,a.baselineplannednonlaborunits  baselineplannednonlaborunits
,a.baseline1actuallaborunits  baseline1actuallaborunits
,a.baseline1actualnonlaborunits  baseline1actualnonlaborunits
,a.baseline1plannedlaborunits  baseline1plannedlaborunits
,a.baseline1plannednonlaborunits  baseline1plannednonlaborunits
,a.earnedvaluelaborunits  earnedvaluelaborunits
,a.estimateatcompletionlaborunits  estimateatcompletionlaborunits
,a.estimatetocompletelaborunits  estimatetocompletelaborunits
,a.plannedlaborunits  plannedlaborunits
,a.plannednonlaborunits  plannednonlaborunits
,a.plannedvaluelaborunits  plannedvaluelaborunits
,a.remaininglaborunits  remaininglaborunits
,a.remaininglatelaborunits  remaininglatelaborunits
,a.remaininglatenonlaborunits  remaininglatenonlaborunits
,a.remainingnonlaborunits  remainingnonlaborunits
,a.actualcost  actualcost
,a.actualexpensecost  actualexpensecost
,a.actuallaborcost  actuallaborcost
,a.actualmaterialcost  actualmaterialcost
,a.actualnonlaborcost  actualnonlaborcost
,a.actualtotalcost  actualtotalcost
,a.atcompletionexpensecost  atcompletionexpensecost
,a.atcompletionlaborcost  atcompletionlaborcost
,a.atcompletionmaterialcost  atcompletionmaterialcost
,a.atcompletionnonlaborcost  atcompletionnonlaborcost
,a.atcompletiontotalcost  atcompletiontotalcost
,a.baselineplannedexpensecost  baselineplannedexpensecost
,a.baselineplannedlaborcost  baselineplannedlaborcost
,a.baselineplannedmaterialcost  baselineplannedmaterialcost
,a.baselineplannednonlaborcost  baselineplannednonlaborcost
,a.baselineplannedtotalcost  baselineplannedtotalcost
,a.baselineactualexpensecost  baselineactualexpensecost
,a.baselineactuallaborcost  baselineactuallaborcost
,a.baselineactualmaterialcost  baselineactualmaterialcost
,a.baselineactualnonlaborcost  baselineactualnonlaborcost
,a.baselineactualtotalcost  baselineactualtotalcost
,a.baseline1actualexpensecost  baseline1actualexpensecost
,a.baseline1actuallaborcost  baseline1actuallaborcost
,a.baseline1actualmaterialcost  baseline1actualmaterialcost
,a.baseline1actualnonlaborcost  baseline1actualnonlaborcost
,a.baseline1actualtotalcost  baseline1actualtotalcost
,a.baseline1plannedexpensecost  baseline1plannedexpensecost
,a.baseline1plannedlaborcost  baseline1plannedlaborcost
,a.baseline1plannedmaterialcost  baseline1plannedmaterialcost
,a.baseline1plannednonlaborcost  baseline1plannednonlaborcost
,a.baseline1plannedtotalcost  baseline1plannedtotalcost
,a.earnedvaluecost  earnedvaluecost
,a.estimateatcompletioncost  estimateatcompletioncost
,a.estimatetocompletecost  estimatetocompletecost
,a.plannedexpensecost  plannedexpensecost
,a.plannedlaborcost  plannedlaborcost
,a.plannedmaterialcost  plannedmaterialcost
,a.plannednonlaborcost  plannednonlaborcost
,a.plannedtotalcost  plannedtotalcost
,a.plannedvaluecost  plannedvaluecost
,a.remainingexpensecost  remainingexpensecost
,a.remaininglaborcost  remaininglaborcost
,a.remaininglateexpensecost  remaininglateexpensecost
,a.remaininglatelaborcost  remaininglatelaborcost
,a.remaininglatematerialcost  remaininglatematerialcost
,a.remaininglatenonlaborcost  remaininglatenonlaborcost
,a.remaininglatetotalcost  remaininglatetotalcost
,a.remainingmaterialcost  remainingmaterialcost
,a.remainingnonlaborcost  remainingnonlaborcost
,a.remainingtotalcost  remainingtotalcost
,a.update_date  lastupdatedate
,T1.cbs_id cbsobjectid  
 FROM ${pm.or.administrative_user}.ACTIVITYSPREAD a
    INNER JOIN ${pm.or.administrative_user}.TASK T1 
ON T1.task_id = ActivityObjectId  AND T1.DELETE_SESSION_ID IS NULL 
/
     
prompt creating view ACTIVITYCODEHIERARCHY
--METADATA NAME:ACTIVITYCODEHIERARCHY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYCODEHIERARCHY
AS
SELECT a.codetypeobjectid
,a.codetypename
,a.codetypesequencenumber
,a.codetypeissecure
,a.parentcodevalueobjectid
,a.parentcodevaluename
,a.parentcodevalueshortname
,a.parentcodevaluesequencenumber
,a.childcodevalueobjectid
,a.childcodevaluename
,a.childcodevalueshortname
,a.childcodevaluesequencenumber
,a.parentlevelsbelowroot
,a.childlevelsbelowroot
,a.levelsbetween
,a.childhaschildren
,a.fullpathname
,a.codetypescope
,a.codetypeprojectid 
 FROM ${pm.or.administrative_user}.ACTIVITYCODEHIERARCHY a
    INNER JOIN ${pm.or.administrative_user}.ACTVCODE T1 
ON T1.actv_code_id = ParentCodeValueObjectId  AND T1.DELETE_SESSION_ID IS NULL 
    INNER JOIN ${pm.or.administrative_user}.ACTVCODE T2 
ON T2.actv_code_id = ChildCodeValueObjectId  AND T2.DELETE_SESSION_ID IS NULL 
/
     
prompt creating view ACTIVITYCODETYPESECURITY
--METADATA NAME:ACTIVITYCODETYPESECURITY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYCODETYPESECURITY
AS
SELECT a.rdbmsuserid
,a.projectobjectid 
 FROM ${pm.or.administrative_user}.ACTIVITYCODETYPESECURITY a
/
     
prompt creating view COSTACCOUNTHIERARCHY
--METADATA NAME:COSTACCOUNTHIERARCHY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW COSTACCOUNTHIERARCHY
AS
SELECT a.parentobjectid
,a.parentsequencenumber
,a.parentname
,a.parentid
,a.childobjectid
,a.childsequencenumber
,a.childname
,a.childid
,a.parentlevelsbelowroot
,a.childlevelsbelowroot
,a.levelsbetween
,a.childhaschildren
,a.fullpathname 
 FROM ${pm.or.administrative_user}.COSTACCOUNTHIERARCHY a
    INNER JOIN ${pm.or.administrative_user}.ACCOUNT T1 
ON T1.acct_id = ParentObjectId  AND T1.DELETE_SESSION_ID IS NULL 
    INNER JOIN ${pm.or.administrative_user}.ACCOUNT T2 
ON T2.acct_id = ChildObjectId  AND T2.DELETE_SESSION_ID IS NULL 
/
     
prompt creating view COSTSECURITY
--METADATA NAME:COSTSECURITY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW COSTSECURITY
AS
SELECT a.rdbmsuserid
,a.projectobjectid
,a.wholeprojectflag 
 FROM ${pm.or.administrative_user}.COSTSECURITY a
/
     
prompt creating view EPSHIERARCHY
--METADATA NAME:EPSHIERARCHY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW EPSHIERARCHY
AS
SELECT a.parentobjectid
,a.parentprojectid
,a.parentsequencenumber
,a.parentname
,a.parentid
,a.childobjectid
,a.childprojectid
,a.childsequencenumber
,a.childname
,a.childid
,a.parentlevelsbelowroot
,a.childlevelsbelowroot
,a.levelsbetween
,a.childhaschildren
,a.fullpathname
,a.update_date  lastupdatedate 
 FROM ${pm.or.administrative_user}.EPSHIERARCHY a
    INNER JOIN ${pm.or.administrative_user}.PROJWBS T1 
ON T1.wbs_id = ParentObjectId  AND T1.DELETE_SESSION_ID IS NULL 
    INNER JOIN ${pm.or.administrative_user}.PROJWBS T2 
ON T2.wbs_id = ChildObjectId  AND T2.DELETE_SESSION_ID IS NULL 
/
     
prompt creating view WBSHIERARCHY
--METADATA NAME:WBSHIERARCHY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW WBSHIERARCHY
AS
SELECT a.parentobjectid
,a.parentprojectid
,a.parentsequencenumber
,a.parentname
,a.parentid
,a.childobjectid
,a.childprojectid
,a.childsequencenumber
,a.childname
,a.childid
,a.parentlevelsbelowroot
,a.childlevelsbelowroot
,a.levelsbetween
,a.childhaschildren
,a.fullpathname
,a.update_date  lastupdatedate 
 FROM ${pm.or.administrative_user}.WBSHIERARCHY a
    INNER JOIN ${pm.or.administrative_user}.PROJWBS T1 
ON T1.wbs_id = ParentObjectId  AND T1.DELETE_SESSION_ID IS NULL 
    INNER JOIN ${pm.or.administrative_user}.PROJWBS T2 
ON T2.wbs_id = ChildObjectId  AND T2.DELETE_SESSION_ID IS NULL 
/
     
prompt creating view EPSSPREAD
--METADATA NAME:EPSSPREAD TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW EPSSPREAD
AS
SELECT a.objectid
,a.id
,a.name
,a.parentobjectid
,a.projectobjectid
,a.obsobjectid
,a.obsname
,a.startdate
,a.enddate
,a.actuallaborunits
,a.actualnonlaborunits
,a.atcompletionlaborunits
,a.atcompletionnonlaborunits
,a.baselineplannedlaborunits
,a.baselineplannednonlaborunits
,a.earnedvaluelaborunits
,a.estimateatcompletionlaborunits
,a.estimatetocompletelaborunits
,a.plannedvaluelaborunits
,a.remaininglaborunits
,a.remainingnonlaborunits
,a.actualcost
,a.actualexpensecost
,a.actuallaborcost
,a.actualmaterialcost
,a.actualnonlaborcost
,a.actualtotalcost
,a.atcompletionexpensecost
,a.atcompletionlaborcost
,a.atcompletionmaterialcost
,a.atcompletionnonlaborcost
,a.atcompletiontotalcost
,a.baselineplannedexpensecost
,a.baselineplannedlaborcost
,a.baselineplannedmaterialcost
,a.baselineplannednonlaborcost
,a.baselineplannedtotalcost
,a.earnedvaluecost
,a.estimateatcompletioncost
,a.estimatetocompletecost
,a.plannedvaluecost
,a.remainingexpensecost
,a.remaininglaborcost
,a.remainingmaterialcost
,a.remainingnonlaborcost
,a.remainingtotalcost 
 FROM ${pm.or.administrative_user}.EPSSPREAD a
    INNER JOIN ${pm.or.administrative_user}.PROJWBS T1 
ON T1.wbs_id = ObjectId  AND T1.DELETE_SESSION_ID IS NULL 
/
     
prompt creating view GLOBALSECURITY
--METADATA NAME:GLOBALSECURITY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW GLOBALSECURITY
AS
SELECT a.rdbmsuserid
,a.securecodeflag
,a.resourcecostflag
,a.proficiencyflag 
 FROM ${pm.or.administrative_user}.GLOBALSECURITY a
/
     
prompt creating view PROJECTCODEHIERARCHY
--METADATA NAME:PROJECTCODEHIERARCHY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTCODEHIERARCHY
AS
SELECT a.codetypeobjectid
,a.codetypename
,a.codetypesequencenumber
,a.codetypeissecure
,a.parentcodevalueobjectid
,a.parentcodevaluename
,a.parentcodevalueshortname
,a.parentcodevaluesequencenumber
,a.childcodevalueobjectid
,a.childcodevaluename
,a.childcodevalueshortname
,a.childcodevaluesequencenumber
,a.parentlevelsbelowroot
,a.childlevelsbelowroot
,a.levelsbetween
,a.childhaschildren
,a.fullpathname
,a.codetypeweight
,a.maxcodevalueweight
,a.parentcodevalueweight
,a.childcodevalueweight 
 FROM ${pm.or.administrative_user}.PROJECTCODEHIERARCHY a
    INNER JOIN ${pm.or.administrative_user}.PCATVAL T1 
ON T1.proj_catg_id = ParentCodeValueObjectId  AND T1.DELETE_SESSION_ID IS NULL 
    INNER JOIN ${pm.or.administrative_user}.PCATVAL T2 
ON T2.proj_catg_id = ChildCodeValueObjectId  AND T2.DELETE_SESSION_ID IS NULL 
/
     
prompt creating view PROJECTSECURITY
--METADATA NAME:PROJECTSECURITY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTSECURITY
AS
SELECT a.rdbmsuserid
,a.projectobjectid
,a.costflag
,a.update_date  lastupdatedate 
 FROM ${pm.or.administrative_user}.PROJECTSECURITY a
/
     
prompt creating view PROJECTSPREAD
--METADATA NAME:PROJECTSPREAD TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTSPREAD
AS
SELECT a.objectid
,a.id
,a.name
,a.parentepsobjectid
,a.obsobjectid
,a.obsname
,a.startdate
,a.enddate
,a.actuallaborunits
,a.actualnonlaborunits
,a.atcompletionlaborunits
,a.atcompletionnonlaborunits
,a.baselineplannedlaborunits
,a.baselineplannednonlaborunits
,a.earnedvaluelaborunits
,a.estimateatcompletionlaborunits
,a.estimatetocompletelaborunits
,a.plannedlaborunits
,a.plannednonlaborunits
,a.plannedvaluelaborunits
,a.remaininglaborunits
,a.remainingnonlaborunits
,a.actualcost
,a.actualexpensecost
,a.actuallaborcost
,a.actualmaterialcost
,a.actualnonlaborcost
,a.actualtotalcost
,a.atcompletionexpensecost
,a.atcompletionlaborcost
,a.atcompletionmaterialcost
,a.atcompletionnonlaborcost
,a.atcompletiontotalcost
,a.baselineplannedexpensecost
,a.baselineplannedlaborcost
,a.baselineplannedmaterialcost
,a.baselineplannednonlaborcost
,a.baselineplannedtotalcost
,a.earnedvaluecost
,a.estimateatcompletioncost
,a.estimatetocompletecost
,a.plannedexpensecost
,a.plannedlaborcost
,a.plannedmaterialcost
,a.plannednonlaborcost
,a.plannedtotalcost
,a.plannedvaluecost
,a.remainingexpensecost
,a.remaininglaborcost
,a.remainingmaterialcost
,a.remainingnonlaborcost
,a.remainingtotalcost 
 FROM ${pm.or.administrative_user}.PROJECTSPREAD a
    INNER JOIN ${pm.or.administrative_user}.PROJECT T1 
ON T1.proj_id = ObjectId  AND T1.DELETE_SESSION_ID IS NULL 
/
     
prompt creating view REPORTDATE
--METADATA NAME:REPORTDATE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW REPORTDATE
AS
SELECT a.datename  datename
,a.daydate  daydate
,a.dayname  dayname
,a.dayofmonth  dayofmonth
,a.dayofyear  dayofyear
,a.ordinaldayofmonth  ordinaldayofmonth
,a.ordinaldayofyear  ordinaldayofyear
,a.weekbegindate  weekbegindate
,a.dayofweek  dayofweek
,a.weeknumber  weeknumber
,a.monthnumber  monthnumber
,a.monthname  monthname
,a.monthshortname  monthshortname
,a.monthenddate  monthenddate
,a.daysinmonth  daysinmonth
,a.yearmonth  yearmonth
,a.quarternumber  quarternumber
,a.quartername  quartername
,a.year  year
,a.etlprocess  etlprocess
,a.etluser  etluser 
 FROM ${pm.or.administrative_user}.REPORTDATE a
/
     
prompt creating view REPORTTIME
--METADATA NAME:REPORTTIME TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW REPORTTIME
AS
SELECT a.civiliantime  civiliantime
,a.militarytime  militarytime
,a.twochar  twochar
,a.timename  timename
,a.timeofday  timeofday
,a.etlprocess  etlprocess
,a.etluser  etluser 
 FROM ${pm.or.administrative_user}.REPORTTIME a
/
     
prompt creating view RESOURCECODEHIERARCHY
--METADATA NAME:RESOURCECODEHIERARCHY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCECODEHIERARCHY
AS
SELECT a.codetypeobjectid
,a.codetypename
,a.codetypesequencenumber
,a.codetypeissecure
,a.parentcodevalueobjectid
,a.parentcodevaluename
,a.parentcodevalueshortname
,a.parentcodevaluesequencenumber
,a.childcodevalueobjectid
,a.childcodevaluename
,a.childcodevalueshortname
,a.childcodevaluesequencenumber
,a.parentlevelsbelowroot
,a.childlevelsbelowroot
,a.levelsbetween
,a.childhaschildren
,a.fullpathname 
 FROM ${pm.or.administrative_user}.RESOURCECODEHIERARCHY a
    INNER JOIN ${pm.or.administrative_user}.RCATVAL T1 
ON T1.rsrc_catg_id = ParentCodeValueObjectId  AND T1.DELETE_SESSION_ID IS NULL 
    INNER JOIN ${pm.or.administrative_user}.RCATVAL T2 
ON T2.rsrc_catg_id = ChildCodeValueObjectId  AND T2.DELETE_SESSION_ID IS NULL 
/
     
prompt creating view RESOURCEHIERARCHY
--METADATA NAME:RESOURCEHIERARCHY TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCEHIERARCHY
AS
SELECT a.parentobjectid
,a.parentsequencenumber
,a.parentname
,a.parentid
,a.childobjectid
,a.childsequencenumber
,a.childname
,a.childid
,a.parentlevelsbelowroot
,a.childlevelsbelowroot
,a.levelsbetween
,a.childhaschildren
,a.fullpathname
,a.update_date  lastupdatedate 
 FROM ${pm.or.administrative_user}.RESOURCEHIERARCHY a
    INNER JOIN ${pm.or.administrative_user}.RSRC T1 
ON T1.rsrc_id = ParentObjectId  AND T1.DELETE_SESSION_ID IS NULL 
    INNER JOIN ${pm.or.administrative_user}.RSRC T2 
ON T2.rsrc_id = ChildObjectId  AND T2.DELETE_SESSION_ID IS NULL 
/
     
prompt creating view WBSSPREAD
--METADATA NAME:WBSSPREAD TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW WBSSPREAD
AS
SELECT a.objectid
,a.parentobjectid
,a.code
,a.name
,a.projectobjectid
,a.obsobjectid
,a.obsname
,a.startdate
,a.enddate
,a.actuallaborunits
,a.actualnonlaborunits
,a.atcompletionlaborunits
,a.atcompletionnonlaborunits
,a.baselineplannedlaborunits
,a.baselineplannednonlaborunits
,a.earnedvaluelaborunits
,a.estimateatcompletionlaborunits
,a.estimatetocompletelaborunits
,a.plannedlaborunits
,a.plannednonlaborunits
,a.plannedvaluelaborunits
,a.remaininglaborunits
,a.remainingnonlaborunits
,a.actualcost
,a.actualexpensecost
,a.actuallaborcost
,a.actualmaterialcost
,a.actualnonlaborcost
,a.actualtotalcost
,a.atcompletionexpensecost
,a.atcompletionlaborcost
,a.atcompletionmaterialcost
,a.atcompletionnonlaborcost
,a.atcompletiontotalcost
,a.baselineplannedexpensecost
,a.baselineplannedlaborcost
,a.baselineplannedmaterialcost
,a.baselineplannednonlaborcost
,a.baselineplannedtotalcost
,a.earnedvaluecost
,a.estimateatcompletioncost
,a.estimatetocompletecost
,a.plannedexpensecost
,a.plannedlaborcost
,a.plannedmaterialcost
,a.plannednonlaborcost
,a.plannedtotalcost
,a.plannedvaluecost
,a.remainingexpensecost
,a.remaininglaborcost
,a.remainingmaterialcost
,a.remainingnonlaborcost
,a.remainingtotalcost 
 FROM ${pm.or.administrative_user}.WBSSPREAD a
    INNER JOIN ${pm.or.administrative_user}.PROJWBS T1 
ON T1.wbs_id = ObjectId  AND T1.DELETE_SESSION_ID IS NULL 
/
     
--CONNECT USERNAME:pxrptuser
	 
set scan off
     
prompt creating view BASELINE

--METADATA NAME:BASELINE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW BASELINE
AS SELECT a.proj_id objectid
,a.proj_short_name id
,a.fy_start_month_num fiscalyearstartmonth
,a.chng_eff_cmp_pct_flag resourcescaneditasgnmtpctcmp
,a.rsrc_self_add_flag resourcescanselfassigntoacts
,a.allow_complete_flag primaryrescanmarkactsascmp
,a.rsrc_multi_assign_flag resourcecanassigntosameact
,a.checkout_flag checkoutstatus
,a.step_complete_flag activitypctcmpbasedonsteps
,a.cost_qty_recalc_flag costquantityrecalculateflag
,a.sum_only_flag containssummarydataonly
,a.batch_sum_flag enablesummarization
,a.name_sep_char wbscodeseparator
,CASE a.def_complete_pct_type WHEN 'CP_Phys' THEN 'Physical' WHEN 'CP_Drtn' THEN 'Duration' WHEN 'CP_Units' THEN 'Units' WHEN 'CP_Scope' THEN 'Scope' WHEN 'CP_Phys' THEN 'Physical' WHEN 'CP_Drtn' THEN 'Duration' WHEN 'CP_Units' THEN 'Units' WHEN 'CP_Scope' THEN 'Scope' ELSE a.def_complete_pct_type END activitydefaultpctcmptype
,a.acct_id activitydefcostacctobjectid
,a.clndr_id activitydefcalendarobjectid
,a.sum_base_proj_id currentbaselineprojectobjectid
,a.task_code_base activityidsuffix
,a.task_code_step activityidincrement
,a.priority_num levelingpriority
,a.wbs_max_sum_level summarizetowbslevel
,a.strgy_priority_num strategicpriority
,a.critical_drtn_hr_cnt criticalactivityfloatlimit
,a.def_cost_per_qty activitydefaultpriceperunit
,a.plan_start_date plannedstartdate
,a.plan_end_date mustfinishbydate
,a.scd_end_date scheduledfinishdate
,a.add_date dateadded
,a.sum_data_date summarizeddatadate
,a.last_tasksum_date lastsummarizeddate
,a.fcst_start_date projectforecaststartdate
,CASE a.def_duration_type WHEN 'DT_FixedRate' THEN 'Fixed Units/Time' WHEN 'DT_FixedDrtn' THEN 'Fixed Duration & Units/Time' WHEN 'DT_FixedQty' THEN 'Fixed Units' WHEN 'DT_FixedDUR2' THEN 'Fixed Duration & Units' WHEN 'DT_FixedRate' THEN 'Fixed Units/Time' WHEN 'DT_FixedDrtn' THEN 'Fixed Duration & Units/Time' WHEN 'DT_FixedQty' THEN 'Fixed Units' WHEN 'DT_FixedDUR2' THEN 'Fixed Duration & Units' ELSE a.def_duration_type END activitydefaultdurationtype
,a.task_code_prefix activityidprefix
,CASE a.def_qty_type WHEN 'QT_Hour' THEN 'Hour' WHEN 'QT_Day' THEN 'Day' WHEN 'QT_Week' THEN 'Week' WHEN 'QT_Month' THEN 'Month' WHEN 'QT_Year' THEN 'Year' WHEN 'QT_DaysHours' THEN '??enm.UnitType.QT_DaysHours??' WHEN 'QT_HoursMinutes' THEN '??enm.UnitType.QT_HoursMinutes??' WHEN 'QT_Hour' THEN 'Hour' WHEN 'QT_Day' THEN 'Day' WHEN 'QT_Week' THEN 'Week' WHEN 'QT_Month' THEN 'Month' WHEN 'QT_Year' THEN 'Year' WHEN 'QT_DaysHours' THEN '??enm.UnitType.QT_DaysHours??' WHEN 'QT_HoursMinutes' THEN '??enm.UnitType.QT_HoursMinutes??' ELSE a.def_qty_type END defaultpricetimeunits
,a.add_by_name addedby
,a.web_local_root_path websiterootdirectory
,a.proj_url websiteurl
,CASE a.def_rate_type WHEN 'COST_PER_QTY' THEN 'Cost Per Qty' WHEN 'COST_PER_QTY2' THEN 'CostPerQty2' WHEN 'COST_PER_QTY3' THEN 'CostPerQty3' WHEN 'COST_PER_QTY4' THEN 'CostPerQty4' WHEN 'COST_PER_QTY5' THEN 'CostPerQty5' WHEN 'COST_PER_QTY' THEN 'Cost Per Qty' WHEN 'COST_PER_QTY2' THEN 'CostPerQty2' WHEN 'COST_PER_QTY3' THEN 'CostPerQty3' WHEN 'COST_PER_QTY4' THEN 'CostPerQty4' WHEN 'COST_PER_QTY5' THEN 'CostPerQty5' ELSE a.def_rate_type END assignmentdefaultratetype
,a.act_this_per_link_flag linkactualtoactualthisperiod
,CASE a.def_task_type WHEN 'TT_Task' THEN 'Task Dependent' WHEN 'TT_Rsrc' THEN 'Resource Dependent' WHEN 'TT_LOE' THEN 'Level Of Effort' WHEN 'TT_Mile' THEN 'Start Milestone' WHEN 'TT_FinMile' THEN 'Finish Milestone' WHEN 'TT_WBS' THEN 'WBS Summary' WHEN 'TT_Task' THEN 'Task Dependent' WHEN 'TT_Rsrc' THEN 'Resource Dependent' WHEN 'TT_LOE' THEN 'Level Of Effort' WHEN 'TT_Mile' THEN 'Start Milestone' WHEN 'TT_FinMile' THEN 'Finish Milestone' WHEN 'TT_WBS' THEN 'WBS Summary' ELSE a.def_task_type END activitydefaultactivitytype
,a.act_pct_link_flag linkpercentcompletewithactual
,a.add_act_remain_flag addactualtoremaining
,CASE a.critical_path_type WHEN 'CT_TotFloat' THEN 'Critical Float' WHEN 'CT_DrivPath' THEN 'Longest Path' WHEN 'CT_TotFloat' THEN 'Critical Float' WHEN 'CT_DrivPath' THEN 'Longest Path' ELSE a.critical_path_type END criticalactivitypathtype
,a.task_code_prefix_flag activityidbasedonselactivity
,a.def_rollup_dates_flag assignmentdefaultdrivingflag
,a.rem_target_link_flag linkplannedandatcompletionflag
,a.reset_planned_flag resetplannedtoremainingflag
,a.allow_neg_act_flag allownegativeactualunitsflag
,a.rsrc_id ownerresourceobjectid
,a.checkout_date checkoutdate
,a.checkout_user_id checkoutuserobjectid
,a.last_fin_dates_id lastfinancialperiodobjectid
,a.use_project_baseline_flag useprojectblforearnedvalue
,a.orig_proj_id originalprojectobjectid
,a.matrix_id riskscorematrixobjectid
,a.description projectdescription
,a.base_type_id baselinetypeobjectid
,a.px_enable_publication_flag enablepublication
,a.px_next_date nextpublicationdate
,a.px_last_update_date lastpublishedon
,a.px_priority publicationpriority
,a.location_id locationobjectid
,a.hist_interval historyinterval
,a.hist_level historylevel
,a.control_updates_flag allowstatusreview
,a.update_user lastupdateuser
,a.update_date lastupdatedate
,a.create_user createuser
,a.etl_interval etlinterval
,a.etl_hour etlhour
,a.create_date createdate
,p.proj_short_name parentprojectid
,PW.wbs_name name
 FROM ${pm.or.administrative_user}.PROJECT a ,${pm.or.administrative_user}.PROJECT p ,${pm.or.administrative_user}.PROJWBS PW
WHERE (a.delete_session_id is null) and (a.orig_proj_id is not null) and (a.orig_proj_id != a.proj_id) and p.proj_id = a.orig_proj_id and pw.proj_id = a.proj_id and pw.proj_node_flag='Y'
/
     
--METADATA NAME:RESOURCESECURITY TYPE:VIEW SET:RESOURCE_SECURITY CHANGE:CREATE
create or replace view ResourceSecurity
as
select 0 rdbmsuserid, r.rsrc_id RESOURCEOBJECTID, r.update_date lastupdatedate
 FROM ${pm.or.administrative_user}.rsrc r
union
select u.user_id rdbmsuserid, r.rsrc_id RESOURCEOBJECTID, r.update_date lastupdatedate
 FROM ${pm.or.administrative_user}.rsrc r , ${pm.or.administrative_user}.users u
where u.all_rsrc_access_flag = 'Y'  and u.prof_id != 12
union
select r.user_id rdbmsuserid, rh.CHILDOBJECTID RESOURCEOBJECTID, r.update_date lastupdatedate
 FROM ${pm.or.administrative_user}.rsrcsec r
INNER JOIN ${pm.or.administrative_user}.resourcehierarchy rh on r.rsrc_id = rh.PARENTOBJECTID
INNER JOIN ${pm.or.administrative_user}.users u on r.user_id = u.user_id
where u.all_rsrc_access_flag = 'N'
/
--METADATA NAME:AUDIT_SETTINGS TYPE:VIEW SET:PRMAUDIT DATA FOR CLOUD CHANGE:CREATE
CREATE OR REPLACE VIEW AUDIT_SETTINGS
AS
SELECT UNIQUE SUBSTR(SES.NAMESPACE,16) AS TABLE_NAME FROM ${pm.or.administrative_user}.SETTINGS SES WHERE LOWER(SES.NAMESPACE) LIKE 'database.audit.%'
/

--METADATA NAME:AUDIT_USERS TYPE:VIEW SET:PRMAUDIT DATA FOR CLOUD CHANGE:CREATE
CREATE OR REPLACE VIEW AUDIT_USERS
AS
SELECT UNIQUE USER_NAME FROM ${pm.or.administrative_user}.USERS
/

--METADATA NAME:AUDIT_PROJINFO TYPE:VIEW SET:PRMAUDIT DATA FOR CLOUD CHANGE:CREATE
CREATE OR REPLACE VIEW AUDIT_PROJINFO
AS
SELECT PROJ_ID,PROJ_SHORT_NAME FROM ${pm.or.administrative_user}.PROJECT WHERE ORIG_PROJ_ID IS NULL
/

--METADATA NAME:PRMAUDIT_FULL TYPE:VIEW SET:PRMAUDIT DATA FOR CLOUD CHANGE:CREATE
CREATE OR REPLACE VIEW PRMAUDIT_FULL
AS
select audit_ts,
prm_user_name,
host_name,
app_name,
table_name,
tab_primary_keys,
tab_col_name,
old_value,
new_value,
oper
 FROM ${pm.or.administrative_user}.pauditx
order by audit_ts desc,table_name,tab_col_name
/

--METADATA NAME:PRMAUDIT_PROJ TYPE:VIEW SET:PRMAUDIT DATA FOR CLOUD CHANGE:CREATE
create or replace view prmaudit_proj 
as 
select distinct pr.proj_id, pr.proj_short_name, pw.wbs_name as proj_name, 
   px.table_name, substr(px.tab_primary_keys,1,instr(px.tab_primary_keys,':')-1) as tab_primary_keys, px.audit_ts,px.tab_col_name,
   px.old_value,px.new_value,px.oper, px.prm_user_name, px.app_name 
   FROM ${pm.or.administrative_user}.project pr INNER JOIN ${pm.or.administrative_user}.projwbs pw 
        on pr.proj_short_name=pw.wbs_short_name 
   INNER JOIN ${pm.or.administrative_user}.pauditx px
        on pw.proj_id=px.proj_id 
 order by audit_ts desc,table_name,tab_col_name
/

--METADATA NAME:P6AUDIT_SETTINGS TYPE:SYNONYM SET:PRMAUDIT DATA FOR CLOUD CHANGE:CREATE
CREATE OR REPLACE SYNONYM P6AUDIT_SETTINGS for AUDIT_SETTINGS
/

--METADATA NAME:P6AUDIT_USERS TYPE:SYNONYM SET:PRMAUDIT DATA FOR CLOUD CHANGE:CREATE
CREATE OR REPLACE SYNONYM P6AUDIT_USERS for AUDIT_USERS
/

--METADATA NAME:P6AUDIT_PROJINFO TYPE:SYNONYM SET:PRMAUDIT DATA FOR CLOUD CHANGE:CREATE
CREATE OR REPLACE SYNONYM P6AUDIT_PROJINFO for AUDIT_PROJINFO
/

--METADATA NAME:P6PRMAUDIT_FULL TYPE:SYNONYM SET:PRMAUDIT DATA FOR CLOUD CHANGE:CREATE
CREATE OR REPLACE SYNONYM P6PRMAUDIT_FULL for PRMAUDIT_FULL
/

--METADATA NAME:P6PRMAUDIT_PROJ TYPE:SYNONYM SET:PRMAUDIT DATA FOR CLOUD CHANGE:CREATE
CREATE OR REPLACE SYNONYM P6PRMAUDIT_PROJ for PRMAUDIT_PROJ
/

--METADATA NAME:REFRDELETE TYPE:VIEW SET:PRMAUDIT DATA FOR ANALYTICS CHANGE:CREATE
CREATE OR REPLACE VIEW REFRDELETE(LASTUPDATEDATE,TABLENAME,OBJECTID,OBJECTID2,OBJECTID3,OBJECTID4,PROJECTOBJECTID) 
AS
select DELETE_DATE,TABLE_NAME,PK1,PK2,PK3,PK4,PROJ_ID FROM  ${pm.or.administrative_user}.REFRDEL
where upper(TABLE_NAME) in ('ACTVCODE','ACTVTYPE','ACCOUNT','CALENDAR','CBS','COSTTYPE','FINDATES','LOCATION','OBS','PCATVAL','PROJCOST','PROJECT','PROJWBS','PROJPCAT',
'PCATTYPE','PROJECT_ETL_LIST','PFOLIO','RSRCSEC','RCATVAL','RSRCRCAT','RSRCRATE','RSRFOLIO','RISK','RISKTYPE','ROLES','TASK','TASKACTV','TASKMEMO','TASKRISK','TASKPROC','TASKRSRC',
'UDFTYPE','UDFVALUE','USERENG','USERS','WBSMEMO','ACTIVITYSPREAD','PROJECTSECURITY',' RESOURCEASSIGNMENTSPREAD','RESOURCECODEHIERARCHY','WBSHIERARCHY','EPSHIERARCHY',
'PRPFOLIO','RSRCROLE','RSRC','RFOLIO')
/

--METADATA NAME:P6REFRDELETE TYPE:SYNONYM SET:PRMAUDIT DATA FOR CLOUD CHANGE:CREATE
CREATE OR REPLACE SYNONYM P6REFRDELETE for REFRDELETE
/
--METADATA NAME:ROLELIMIT TYPE:VIEW SET:ROLE DATA FOR ROLE USAGE CHANGE:CREATE
CREATE OR REPLACE VIEW ROLELIMIT (roleobjectid,startdate,enddate,max_qty_per_hr,lastupdatedate) 
AS
SELECT R.ROLE_ID ROLEOBJECTID,
TO_DATE('12/31/1900','MM/DD/YYYY') STARTDATE,
NVL((SELECT MIN(R2.START_DATE)FROM ${pm.or.administrative_user}.ROLELIMIT R2 WHERE R2.ROLE_ID = R.ROLE_ID), 
TO_DATE('12/31/3000','MM/DD/YYYY')) ENDDATE,
0 MAX_QTY_PER_HR,
update_date lastupdatedate
FROM ${pm.or.administrative_user}.ROLES R
UNION
SELECT R.ROLE_ID ROLEOBJECTID,
R.START_DATE STARTDATE,
NVL((SELECT MIN(R2.START_DATE) FROM ${pm.or.administrative_user}.ROLELIMIT R2 WHERE R2.ROLE_ID = R.ROLE_ID AND R2.START_DATE > R.START_DATE), 
TO_DATE('12/31/3000','MM/DD/YYYY')) ENDDATE,
MAX_QTY_PER_HR,
update_date lastupdatedate
FROM ${pm.or.administrative_user}.ROLELIMIT R
/
--METADATA NAME:ROLEAVAILABILITY TYPE:VIEW SET:ROLE DATA FOR ROLE USAGE CHANGE:CREATE
CREATE OR REPLACE FORCE VIEW ROLEAVAILABILITY(year,yearmonth,quarter,week,startdate,enddate,rolename,roleid,roleobjectid,limit,lastupdatedate) AS
select rd.year,
rd.yearmonth yearmonth,
rd.quarternumber quarter,
rd.weekbegindate week,
rd.daydate startdate,
rd.daydate + 1 enddate,
r.name rolename,
r.id roleid,
r.objectid roleobjectid,
sum(c.totalworkhours * rv.max_qty_per_hr) limit,
r.lastupdatedate
from calendar c, rolelimit rv, reportdate rd, role r
where c.isdefault='Y' and c.daydate between rv.startdate and rv.enddate and rd.daydate = c.daydate and r.objectid = rv.roleobjectid
group by rd.year,rd.yearmonth,rd.quarternumber,rd.weekbegindate,rd.daydate,r.name,r.id,r.objectid,r.lastupdatedate
order by rd.year,rd.yearmonth,rd.quarternumber,rd.weekbegindate,rd.daydate,r.name,r.id,r.objectid
/
--METADATA NAME:PXSERVICES TYPE:VIEW SET:ROLE DATA FOR ROLE USAGE CHANGE:Lookup view for Jobsvc table 
create or replace view PXSERVICES
(JOBID, SEQNUM,AUDITFLAG,JOBTYPE,JOBTYPEKEY, JOBNAME,USERID,LASTRUNDATE,STATUSCODE,RECURDATA,RECURTYPE,
SUBMITTEDDATE,WORKHOST,UPDATEDATE,UPDATEUSER,CREATEDATE,CREATEUSER,DELETESESSIONID,DELETEDATE)
AS
select job_id, seq_num, audit_flag, job_type, job_type_key, job_name, user_id, last_run_date, status_code, recur_data,
recur_type, submitted_date, worker_host, update_date, update_user, create_date, create_user, delete_session_id, delete_date
 FROM ${pm.or.administrative_user}.jobsvc
where job_type in ('JT_EnterpriseSum', 'JT_Security', 'JT_ResourceMgmt', 'JT_EnterpriseData', 'JT_ProjectArbiter', 'JT_Project')
/
--METADATA NAME:PXSETTINGS TYPE:VIEW SET:ROLE DATA FOR ROLE USAGE CHANGE:Lookup view for settings table 
create or replace view PXSETTINGS
(namespace, settingname, settingvalue, userid, updatedate, updateuser, createdate, createuser)
AS
select namespace, setting_name, setting_value, user_id, update_date, update_user, create_date, create_user
 FROM ${pm.or.administrative_user}.SETTINGS
/
--METADATA NAME:ACTIVITY_SC TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITY_SC(OBJECTID, PROJECTOBJECTID, WBSOBJECTID, CALENDAROBJECTID, ISNEWFEEDBACK, AUTOCOMPUTEACTUALS, PERCENTCOMPLETETYPE, TYPE, DURATIONTYPE, REVIEWSTATUS, STATUS, ID, NAME, PRIMARYRESOURCEOBJECTID, TOTALFLOAT, FREEFLOAT, REMAININGDURATION, ACTUALLABORUNITS, REMAININGLABORUNITS, PLANNEDLABORUNITS, PLANNEDDURATION, PLANNEDNONLABORUNITS, ACTUALNONLABORUNITS, REMAININGNONLABORUNITS, PRIMARYCONSTRAINTDATE, ACTUALSTARTDATE, ACTUALFINISHDATE, LATESTARTDATE, LATEFINISHDATE, EXPECTEDFINISHDATE, EARLYSTARTDATE, EARLYFINISHDATE, REMAININGEARLYSTARTDATE, REMAININGEARLYFINISHDATE, PLANNEDSTARTDATE, PLANNEDFINISHDATE, REVIEWFINISHDATE, REMAININGLATESTARTDATE, REMAININGLATEFINISHDATE, PRIMARYCONSTRAINTTYPE, LEVELINGPRIORITY, SECONDARYCONSTRAINTDATE, SECONDARYCONSTRAINTTYPE, FLOATPATH, FLOATPATHORDER, ACTUALTHISPERIODLABORUNITS,
  ACTUALTHISPERIODNONLABORUNITS, ISLONGESTPATH, SUSPENDDATE, RESUMEDATE, EXTERNALEARLYSTARTDATE, EXTERNALLATEFINISHDATE, ACCOUNTINGVARIANCE, ACCOUNTINGVARIANCELABORUNITS, ACTUALDURATION, ACTUALEXPENSECOST, ACTUALLABORCOST, ACTUALMATERIALCOST, ACTUALNONLABORCOST, ACTUALTHISPERIODLABORCOST, ACTUALTHISPERIODMATERIALCOST, ACTUALTHISPERIODNONLABORCOST, ACTUALTOTALCOST, ACTUALTOTALUNITS, ATCOMPLETIONDURATION, ATCOMPLETIONEXPENSECOST, ATCOMPLETIONLABORCOST, ATCOMPLETIONLABORUNITS, ATCOMPLETIONLABORUNITSVARIANCE, ATCOMPLETIONMATERIALCOST, ATCOMPLETIONNONLABORCOST, ATCOMPLETIONNONLABORUNITS, ATCOMPLETIONTOTALCOST, ATCOMPLETIONTOTALUNITS, ATCOMPLETIONVARIANCE, BASELINEDURATION, BASELINEFINISHDATE, BASELINEPLANNEDDURATION, BASELINEPLANNEDEXPENSECOST, BASELINEPLANNEDLABORCOST, BASELINEPLANNEDLABORUNITS, BASELINEPLANNEDMATERIALCOST, BASELINEPLANNEDNONLABORCOST, BASELINEPLANNEDNONLABORUNITS, BASELINEPLANNEDTOTALCOST,
  BASELINESTARTDATE, BUDGETATCOMPLETION, CALENDARNAME, COSTPERCENTCOMPLETE, COSTPERCENTOFPLANNED, COSTPERFORMANCEINDEX, COSTPERFORMANCEINDEXLABORUNITS, COSTVARIANCE, COSTVARIANCEINDEX, COSTVARIANCEINDEXLABORUNITS, COSTVARIANCELABORUNITS, DATADATE, DURATION1VARIANCE, DURATIONPERCENTCOMPLETE, DURATIONPERCENTOFPLANNED, DURATIONVARIANCE, EARNEDVALUECOST, EARNEDVALUELABORUNITS, ESTIMATEATCOMPLETIONCOST, ESTIMATEATCOMPLETIONLABORUNITS, ESTIMATETOCOMPLETE, ESTIMATETOCOMPLETELABORUNITS, EXPENSECOST1VARIANCE, EXPENSECOSTPERCENTCOMPLETE, EXPENSECOSTVARIANCE, FINISHDATE, FINISHDATE1VARIANCE, FINISHDATEVARIANCE, ISCRITICAL, LABORCOST1VARIANCE, LABORCOSTPERCENTCOMPLETE, LABORCOSTVARIANCE, LABORUNITS1VARIANCE, LABORUNITSPERCENTCOMPLETE, LABORUNITSVARIANCE, MATERIALCOST1VARIANCE, MATERIALCOSTPERCENTCOMPLETE, MATERIALCOSTVARIANCE, NONLABORCOST1VARIANCE, NONLABORCOSTPERCENTCOMPLETE, NONLABORCOSTVARIANCE,
  NONLABORUNITS1VARIANCE, NONLABORUNITSPERCENTCOMPLETE, NONLABORUNITSVARIANCE, PERCENTCOMPLETE, PERFORMANCEPERCENTCOMPLETE, PHYSICALPERCENTCOMPLETE, PLANNEDEXPENSECOST, PLANNEDLABORCOST, PLANNEDMATERIALCOST, PLANNEDNONLABORCOST, PLANNEDTOTALCOST, PLANNEDTOTALUNITS, PLANNEDVALUECOST, PLANNEDVALUELABORUNITS, PRIMARYRESOURCEID, PRIMARYRESOURCENAME, REMAININGEXPENSECOST, REMAININGFLOAT, REMAININGLABORCOST, REMAININGMATERIALCOST, REMAININGNONLABORCOST, REMAININGTOTALCOST, REMAININGTOTALUNITS, SCHEDULEPERCENTCOMPLETE, SCHEDULEPERFINDEXLABORUNITS, SCHEDULEPERFORMANCEINDEX, SCHEDULEVARIANCE, SCHEDULEVARIANCEINDEX, SCHEDULEVARIANCELABORUNITS, SCHEDULEVARINDEXLABORUNITS, STARTDATE, STARTDATE1VARIANCE, STARTDATEVARIANCE, TOCOMPLETEPERFORMANCEINDEX, TOTALCOST1VARIANCE, TOTALCOSTVARIANCE, UNITSPERCENTCOMPLETE, WBSCODE, WBSNAME, LOCATIONOBJECTID, LOCATIONNAME, REVIEWREQUIRED, ISSTARRED, CBSCODE,
  LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE, LASTUPDATEDATEX, ACTIVITYOWNEROBJECTID, ACTIVITYOWNER, RPT_CURRENT_FLAG)
AS
  SELECT a.task_id objectid ,
    a.proj_id projectobjectid ,
    a.wbs_id wbsobjectid ,
    a.clndr_id calendarobjectid ,
    a.rev_fdbk_flag isnewfeedback ,
    a.auto_compute_act_flag autocomputeactuals ,
    CASE a.complete_pct_type
      WHEN 'CP_Phys'
      THEN 'Physical'
      WHEN 'CP_Drtn'
      THEN 'Duration'
      WHEN 'CP_Units'
      THEN 'Units'
      ELSE a.complete_pct_type
    END percentcompletetype ,
    CASE a.task_type
      WHEN 'TT_Task'
      THEN 'Task Dependent'
      WHEN 'TT_Rsrc'
      THEN 'Resource Dependent'
      WHEN 'TT_LOE'
      THEN 'Level Of Effort'
      WHEN 'TT_Mile'
      THEN 'Start Milestone'
      WHEN 'TT_FinMile'
      THEN 'Finish Milestone'
      WHEN 'TT_WBS'
      THEN 'WBS Summary'
      ELSE a.task_type
    END type ,
    CASE a.duration_type
      WHEN 'DT_FixedRate'
      THEN 'Fixed Units/Time'
      WHEN 'DT_FixedDrtn'
      THEN 'Fixed Duration and Units/Time'
      WHEN 'DT_FixedQty'
      THEN 'Fixed Units'
      WHEN 'DT_FixedDUR2'
      THEN 'Fixed Duration and Units'
      ELSE a.duration_type
    END durationtype ,
    CASE a.review_type
      WHEN 'RV_OK'
      THEN 'OK'
      WHEN 'RV_Review'
      THEN 'For Review'
      WHEN 'RV_Reject'
      THEN 'Rejected'
      ELSE a.review_type
    END reviewstatus ,
    CASE a.status_code
      WHEN 'TK_NotStart'
      THEN 'Not Started'
      WHEN 'TK_Active'
      THEN 'In Progress'
      WHEN 'TK_Complete'
      THEN 'Completed'
      ELSE a.status_code
    END status ,
    a.task_code id ,
    a.task_name name ,
    a.rsrc_id primaryresourceobjectid ,
    a.total_float_hr_cnt totalfloat ,
    a.free_float_hr_cnt freefloat ,
    a.remain_drtn_hr_cnt remainingduration ,
    a.act_work_qty actuallaborunits ,
    a.remain_work_qty remaininglaborunits ,
    a.target_work_qty plannedlaborunits ,
    a.target_drtn_hr_cnt plannedduration ,
    a.target_equip_qty plannednonlaborunits ,
    a.act_equip_qty actualnonlaborunits ,
    a.remain_equip_qty remainingnonlaborunits ,
    a.cstr_date primaryconstraintdate ,
    a.act_start_date actualstartdate ,
    a.act_end_date actualfinishdate ,
    a.late_start_date latestartdate ,
    a.late_end_date latefinishdate ,
    a.expect_end_date expectedfinishdate ,
    a.early_start_date earlystartdate ,
    a.early_end_date earlyfinishdate ,
    a.restart_date remainingearlystartdate ,
    a.reend_date remainingearlyfinishdate ,
    a.target_start_date plannedstartdate ,
    a.target_end_date plannedfinishdate ,
    a.review_end_date reviewfinishdate ,
    a.rem_late_start_date remaininglatestartdate ,
    a.rem_late_end_date remaininglatefinishdate ,
    CASE a.cstr_type
      WHEN 'CS_MSO'
      THEN 'Start On'
      WHEN 'CS_MSOB'
      THEN 'Start On or Before'
      WHEN 'CS_MSOA'
      THEN 'Start On or After'
      WHEN 'CS_MEO'
      THEN 'Finish On'
      WHEN 'CS_MEOB'
      THEN 'Finish On or Before'
      WHEN 'CS_MEOA'
      THEN 'Finish On or After'
      WHEN 'CS_ALAP'
      THEN 'As Late As Possible'
      WHEN 'CS_MANDSTART'
      THEN 'Mandatory Start'
      WHEN 'CS_MANDFIN'
      THEN 'Mandatory Finish'
      ELSE a.cstr_type
    END primaryconstrainttype ,
    CASE a.priority_type
      WHEN 'PT_Top'
      THEN 'Top'
      WHEN 'PT_High'
      THEN 'High'
      WHEN 'PT_Normal'
      THEN 'Normal'
      WHEN 'PT_Low'
      THEN 'Low'
      WHEN 'PT_Lowest'
      THEN 'Lowest'
      ELSE a.priority_type
    END levelingpriority ,
    a.cstr_date2 secondaryconstraintdate ,
    CASE a.cstr_type2
      WHEN 'CS_MSO'
      THEN 'Start On'
      WHEN 'CS_MSOB'
      THEN 'Start On or Before'
      WHEN 'CS_MSOA'
      THEN 'Start On or After'
      WHEN 'CS_MEO'
      THEN 'Finish On'
      WHEN 'CS_MEOB'
      THEN 'Finish On or Before'
      WHEN 'CS_MEOA'
      THEN 'Finish On or After'
      WHEN 'CS_ALAP'
      THEN 'As Late As Possible'
      WHEN 'CS_MANDSTART'
      THEN 'Mandatory Start'
      WHEN 'CS_MANDFIN'
      THEN 'Mandatory Finish'
      ELSE a.cstr_type2
    END secondaryconstrainttype ,
    a.float_path floatpath ,
    a.float_path_order floatpathorder ,
    a.act_this_per_work_qty actualthisperiodlaborunits ,
    a.act_this_per_equip_qty actualthisperiodnonlaborunits ,
    a.driving_path_flag islongestpath ,
    a.suspend_date suspenddate ,
    a.resume_date resumedate ,
    a.external_early_start_date externalearlystartdate ,
    a.external_late_end_date externallatefinishdate ,
    P.accountingvariance accountingvariance ,
    P.accountingvariancelaborunits accountingvariancelaborunits ,
    P.actualduration actualduration ,
    P.actualexpensecost actualexpensecost ,
    P.actuallaborcost actuallaborcost ,
    P.actualmaterialcost actualmaterialcost ,
    P.actualnonlaborcost actualnonlaborcost ,
    P.actualthisperiodlaborcost actualthisperiodlaborcost ,
    P.actualthisperiodmaterialcost actualthisperiodmaterialcost ,
    P.actualthisperiodnonlaborcost actualthisperiodnonlaborcost ,
    P.actualtotalcost actualtotalcost ,
    P.actualtotalunits actualtotalunits ,
    P.atcompletionduration atcompletionduration ,
    P.atcompletionexpensecost atcompletionexpensecost ,
    P.atcompletionlaborcost atcompletionlaborcost ,
    P.atcompletionlaborunits atcompletionlaborunits ,
    P.atcompletionlaborunitsvariance atcompletionlaborunitsvariance ,
    P.atcompletionmaterialcost atcompletionmaterialcost ,
    P.atcompletionnonlaborcost atcompletionnonlaborcost ,
    P.atcompletionnonlaborunits atcompletionnonlaborunits ,
    P.atcompletiontotalcost atcompletiontotalcost ,
    P.atcompletiontotalunits atcompletiontotalunits ,
    P.atcompletionvariance atcompletionvariance ,
    P.baselineduration baselineduration ,
    P.baselinefinishdate baselinefinishdate ,
    P.baselineplannedduration baselineplannedduration ,
    P.baselineplannedexpensecost baselineplannedexpensecost ,
    P.baselineplannedlaborcost baselineplannedlaborcost ,
    P.baselineplannedlaborunits baselineplannedlaborunits ,
    P.baselineplannedmaterialcost baselineplannedmaterialcost ,
    P.baselineplannednonlaborcost baselineplannednonlaborcost ,
    P.baselineplannednonlaborunits baselineplannednonlaborunits ,
    P.baselineplannedtotalcost baselineplannedtotalcost ,
    P.baselinestartdate baselinestartdate ,
    P.budgetatcompletion budgetatcompletion ,
    P.calendarname calendarname ,
    P.costpercentcomplete costpercentcomplete ,
    P.costpercentofplanned costpercentofplanned ,
    P.costperformanceindex costperformanceindex ,
    P.costperformanceindexlaborunits costperformanceindexlaborunits ,
    P.costvariance costvariance ,
    P.costvarianceindex costvarianceindex ,
    P.costvarianceindexlaborunits costvarianceindexlaborunits ,
    P.costvariancelaborunits costvariancelaborunits ,
    P.datadate datadate ,
    P.duration1variance duration1variance ,
    P.durationpercentcomplete durationpercentcomplete ,
    P.durationpercentofplanned durationpercentofplanned ,
    P.durationvariance durationvariance ,
    P.earnedvaluecost earnedvaluecost ,
    P.earnedvaluelaborunits earnedvaluelaborunits ,
    P.estimateatcompletioncost estimateatcompletioncost ,
    P.estimateatcompletionlaborunits estimateatcompletionlaborunits ,
    P.estimatetocomplete estimatetocomplete ,
    P.estimatetocompletelaborunits estimatetocompletelaborunits ,
    P.expensecost1variance expensecost1variance ,
    P.expensecostpercentcomplete expensecostpercentcomplete ,
    P.expensecostvariance expensecostvariance ,
    P.finishdate finishdate ,
    P.finishdate1variance finishdate1variance ,
    P.finishdatevariance finishdatevariance ,
    P.iscritical iscritical ,
    P.laborcost1variance laborcost1variance ,
    P.laborcostpercentcomplete laborcostpercentcomplete ,
    P.laborcostvariance laborcostvariance ,
    P.laborunits1variance laborunits1variance ,
    P.laborunitspercentcomplete laborunitspercentcomplete ,
    P.laborunitsvariance laborunitsvariance ,
    P.materialcost1variance materialcost1variance ,
    P.materialcostpercentcomplete materialcostpercentcomplete ,
    P.materialcostvariance materialcostvariance ,
    P.nonlaborcost1variance nonlaborcost1variance ,
    P.nonlaborcostpercentcomplete nonlaborcostpercentcomplete ,
    P.nonlaborcostvariance nonlaborcostvariance ,
    P.nonlaborunits1variance nonlaborunits1variance ,
    P.nonlaborunitspercentcomplete nonlaborunitspercentcomplete ,
    P.nonlaborunitsvariance nonlaborunitsvariance ,
    P.percentcomplete percentcomplete ,
    P.performancepercentcomplete performancepercentcomplete ,
    P.physicalpercentcomplete physicalpercentcomplete ,
    P.plannedexpensecost plannedexpensecost ,
    P.plannedlaborcost plannedlaborcost ,
    P.plannedmaterialcost plannedmaterialcost ,
    P.plannednonlaborcost plannednonlaborcost ,
    P.plannedtotalcost plannedtotalcost ,
    P.plannedtotalunits plannedtotalunits ,
    P.plannedvaluecost plannedvaluecost ,
    P.plannedvaluelaborunits plannedvaluelaborunits ,
    P.primaryresourceid primaryresourceid ,
    P.primaryresourcename primaryresourcename ,
    P.remainingexpensecost remainingexpensecost ,
    P.remainingfloat remainingfloat ,
    P.remaininglaborcost remaininglaborcost ,
    P.remainingmaterialcost remainingmaterialcost ,
    P.remainingnonlaborcost remainingnonlaborcost ,
    P.remainingtotalcost remainingtotalcost ,
    P.remainingtotalunits remainingtotalunits ,
    P.schedulepercentcomplete schedulepercentcomplete ,
    P.scheduleperfindexlaborunits scheduleperfindexlaborunits ,
    P.scheduleperformanceindex scheduleperformanceindex ,
    P.schedulevariance schedulevariance ,
    P.schedulevarianceindex schedulevarianceindex ,
    P.schedulevariancelaborunits schedulevariancelaborunits ,
    P.schedulevarindexlaborunits schedulevarindexlaborunits ,
    P.startdate startdate ,
    P.startdate1variance startdate1variance ,
    P.startdatevariance startdatevariance ,
    P.tocompleteperformanceindex tocompleteperformanceindex ,
    P.totalcost1variance totalcost1variance ,
    P.totalcostvariance totalcostvariance ,
    P.unitspercentcomplete unitspercentcomplete ,
    P.wbscode wbscode ,
    P.wbsname wbsname ,
    a.location_id locationobjectid ,
    P.locationname locationname ,
    a.control_updates_flag reviewrequired ,
    a.starred_flag isstarred ,
    a.cbs_code cbscode ,
    a.update_user lastupdateuser ,
    CASE
      WHEN a.update_date > P.update_date
      THEN a.update_date
      ELSE P.update_date
    END lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate ,
    P.update_date lastupdatedatex ,
    P.activityownerobjectid activityownerobjectid ,
    P.activityowner activityowner ,
    CASE
      WHEN a.update_date>P.update_date
      THEN 'N'
      ELSE 'Y'
    END rpt_current_flag
   FROM ${pm.or.administrative_user}.TASK A
  INNER JOIN ${pm.or.administrative_user}.TASKX P
  ON a.task_id = p.task_id
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab ON a.proj_id = projects_tab.proj_id AND upper(projects_tab.hist_level) in ('HL_TASK','HL_TASK_WK','HL_TASK_MN')  AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  WHERE A.DELETE_SESSION_ID     IS NULL
  /

--METADATA NAME:PROJECT_SC TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE  
CREATE OR REPLACE VIEW PROJECT_SC(OBJECTID, ID, FISCALYEARSTARTMONTH, RESOURCESCANEDITASGNMTPCTCMP, RESOURCESCANSELFASSIGNTOACTS, PRIMARYRESCANMARKACTSASCMP, RESOURCECANASSIGNTOSAMEACT, CHECKOUTSTATUS, ACTIVITYPCTCMPBASEDONSTEPS, COSTQUANTITYRECALCULATEFLAG, CONTAINSSUMMARYDATAONLY, ENABLESUMMARIZATION, WBSCODESEPARATOR, ACTIVITYDEFAULTPCTCMPTYPE, ACTIVITYDEFCOSTACCTOBJECTID, ACTIVITYDEFCALENDAROBJECTID, CURRENTBASELINEPROJECTOBJECTID, ACTIVITYIDSUFFIX, ACTIVITYIDINCREMENT, LEVELINGPRIORITY, SUMMARIZETOWBSLEVEL, STRATEGICPRIORITY, CRITICALACTIVITYFLOATLIMIT, ACTIVITYDEFAULTPRICEPERUNIT, PLANNEDSTARTDATE, MUSTFINISHBYDATE, SCHEDULEDFINISHDATE, DATEADDED, SUMMARIZEDDATADATE, LASTSUMMARIZEDDATE, PROJECTFORECASTSTARTDATE, ACTIVITYDEFAULTDURATIONTYPE, ACTIVITYIDPREFIX, DEFAULTPRICETIMEUNITS, ADDEDBY, WEBSITEROOTDIRECTORY, WEBSITEURL, ASSIGNMENTDEFAULTRATETYPE,
  LINKACTUALTOACTUALTHISPERIOD, ACTIVITYDEFAULTACTIVITYTYPE, LINKPERCENTCOMPLETEWITHACTUAL, ADDACTUALTOREMAINING, CRITICALACTIVITYPATHTYPE, ACTIVITYIDBASEDONSELACTIVITY, ASSIGNMENTDEFAULTDRIVINGFLAG, LINKPLANNEDANDATCOMPLETIONFLAG, RESETPLANNEDTOREMAININGFLAG, ALLOWNEGATIVEACTUALUNITSFLAG, OWNERRESOURCEOBJECTID, CHECKOUTDATE, CHECKOUTUSEROBJECTID, LASTFINANCIALPERIODOBJECTID, USEPROJECTBLFOREARNEDVALUE, ANNUALDISCOUNTRATE, ANTICIPATEDFINISHDATE, ANTICIPATEDSTARTDATE, CONTAINSSUMMARYDATA, CURRENTBUDGET, CURRENTVARIANCE, DATADATE, DISCOUNTAPPLICATIONPERIOD, DISTRIBUTEDCURRENTBUDGET, EARNEDVALUECOMPUTETYPE, EARNEDVALUEETCCOMPUTETYPE, EARNEDVALUEETCUSERVALUE, EARNEDVALUEUSERPERCENT, FINISHDATE, FORECASTFINISHDATE, FORECASTSTARTDATE, INDEPENDENTETCLABORUNITS, INDEPENDENTETCTOTALCOST, NAME, OBSNAME, OBSOBJECTID, ORIGINALBUDGET, OVERALLPROJECTSCORE, PARENTEPSOBJECTID, PROPOSEDBUDGET, RISKLEVEL, RISKSCORE,
  RISKEXPOSURE, STARTDATE, STATUS, ORIGINALPROJECTOBJECTID, RISKSCOREMATRIXOBJECTID, SUMPLANNEDSTARTDATE, SUMPLANNEDFINISHDATE, SUMPLANNEDDURATION, SUMPLANNEDLABORUNITS, SUMPLANNEDNONLABORUNITS, SUMPLANNEDEXPENSECOST, SUMPLANNEDLABORCOST, SUMPLANNEDMATERIALCOST, SUMPLANNEDNONLABORCOST, SUMPLANNEDTOTALCOST, SUMACCOUNTINGVARBYLABORUNITS, SUMACCOUNTINGVARIANCEBYCOST, SUMACTTHISPERIODMATERIALCOST, SUMACTTHISPERIODNONLABORCOST, SUMACTTHISPERIODNONLABORUNITS, SUMACTUALTHISPERIODLABORCOST, SUMACTUALTHISPERIODLABORUNITS, SUMATCOMPLETIONMATERIALCOST, SUMATCOMPLETIONNONLABORCOST, SUMATCOMPLETIONNONLABORUNITS, SUMATCOMPLETIONTOTALCOSTVAR, SUMBASELINECOMPACTIVITYCOUNT, SUMBASELINENOTSTARTEDACTCNT, SUMBLINPROGRESSACTIVITYCOUNT, SUMBUDGETATCMPBYLABORUNITS, SUMBUDGETATCOMPLETIONBYCOST, SUMCOSTPERFINDEXBYCOST, SUMCOSTPERFINDEXBYLABORUNITS, SUMCOSTVARIANCEBYLABORUNITS, SUMCOSTVARINDEXBYLABORUNITS, SUMDURATIONPERCENTOFPLANNED,
  SUMEACBYCOST, SUMEACBYLABORUNITS, SUMEACHIGHPCTBYLABORUNITS, SUMEACLOWPCTBYLABORUNITS, SUMETCBYCOST, SUMETCBYLABORUNITS, SUMEXPENSECOSTPCTCOMPLETE, SUMLABORCOSTPERCENTCOMPLETE, SUMLABORUNITSPERCENTCOMPLETE, SUMACTIVITYCOUNT, SUMACTUALDURATION, SUMACTUALEXPENSECOST, SUMACTUALFINISHDATE, SUMMAXACTUALFINISHDATE, SUMMAXRESTARTDATE, SUMACTUALLABORCOST, SUMACTUALLABORUNITS, SUMACTUALMATERIALCOST, SUMACTUALNONLABORCOST, SUMACTUALNONLABORUNITS, SUMACTUALSTARTDATE, SUMACTUALTHISPERIODCOST, SUMACTUALTOTALCOST, SUMACTUALVALUEBYCOST, SUMACTUALVALUEBYLABORUNITS, SUMATCOMPLETIONDURATION, SUMATCOMPLETIONEXPENSECOST, SUMATCOMPLETIONLABORCOST, SUMATCOMPLETIONLABORUNITS, SUMATCOMPLETIONTOTALCOST, SUMBASELINEDURATION, SUMBASELINEEXPENSECOST, SUMBASELINEFINISHDATE, SUMBASELINELABORCOST, SUMBASELINELABORUNITS, SUMBASELINEMATERIALCOST, SUMBASELINENONLABORCOST, SUMBASELINENONLABORUNITS, SUMBASELINESTARTDATE,
  SUMBASELINETOTALCOST, SUMCOMPLETEDACTIVITYCOUNT, SUMCOSTPERCENTCOMPLETE, SUMCOSTPERCENTOFPLANNED, SUMCOSTVARIANCEBYCOST, SUMCOSTVARIANCEINDEX, SUMCOSTVARIANCEINDEXBYCOST, SUMDURATIONPERCENTCOMPLETE, SUMDURATIONVARIANCE, SUMEARNEDVALUEBYCOST, SUMEARNEDVALUEBYLABORUNITS, SUMEXPENSECOSTVARIANCE, SUMFINISHDATEVARIANCE, SUMINPROGRESSACTIVITYCOUNT, SUMLABORCOSTVARIANCE, SUMLABORUNITSVARIANCE, SUMMATERIALCOSTVARIANCE, SUMNONLABORCOSTVARIANCE, SUMNONLABORUNITSVARIANCE, SUMNOTSTARTEDACTIVITYCOUNT, SUMPLANNEDVALUEBYCOST, SUMPROGRESSFINISHDATE, SUMREMAININGDURATION, SUMREMAININGEXPENSECOST, SUMREMAININGFINISHDATE, SUMREMAININGLABORCOST, SUMREMAININGLABORUNITS, SUMREMAININGMATERIALCOST, SUMREMAININGNONLABORCOST, SUMREMAININGNONLABORUNITS, SUMREMAININGSTARTDATE, SUMREMAININGTOTALCOST, SUMSCHEDULEPERCENTCOMPLETE, SUMPERFORMANCEPERCENTCOMPLETE, SUMSCHEDULEVARIANCEBYCOST, SUMSCHEDULEVARIANCEINDEX, SUMSTARTDATEVARIANCE,
  SUMTOTALCOSTVARIANCE, SUMTOTALFLOAT, SUMUNITSPERCENTCOMPLETE, SUMMATERIALCOSTPCTCOMPLETE, SUMNONLABORCOSTPCTCOMPLETE, SUMNONLABORUNITSPCTCOMPLETE, SUMPERFPCTCMPBYLABORUNITS, SUMPLANNEDVALUEBYLABORUNITS, SUMSCHDPCTCMPBYLABORUNITS, SUMSCHDPERFINDEXBYLABORUNITS, SUMSCHDVARIANCEBYLABORUNITS, SUMSCHDVARIANCEINDEXBYCOST, SUMSCHDVARINDEXBYLABORUNITS, SUMSCHEDULEPERFINDEXBYCOST, SUMTOCOMPLETEPERFINDEXBYCOST, SUMVARATCMPBYLABORUNITS, SUMEARLYSTARTDATE, SUMEARLYENDDATE, SUMLATESTARTDATE, SUMLATEENDDATE, SUMMAXCALENDARID, SUMMINCALENDARID, TOTALBENEFITPLAN, TOTALBENEFITPLANTALLY, TOTALFUNDING, TOTALSPENDINGPLAN, TOTALSPENDINGPLANTALLY, UNALLOCATEDBUDGET, NETPRESENTVALUE, RETURNONINVESTMENT, PAYBACKPERIOD, UNDISTRIBUTEDCURRENTVARIANCE, PROJECTDESCRIPTION, BASELINETYPEOBJECTID, ENABLEPUBLICATION, NEXTPUBLICATIONDATE, LASTPUBLISHEDON, PUBLICATIONPRIORITY, LOCATIONOBJECTID, HISTORYINTERVAL, HISTORYLEVEL,
  LOCATIONNAME, ALLOWSTATUSREVIEW, STATUSREVIEWEROBJECTID, STATUSREVIEWERNAME, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE, ETLINTERVAL, ETLHOUR, LASTUPDATEDATEX)
AS
  SELECT a.proj_id objectid ,
    a.proj_short_name id ,
    a.fy_start_month_num fiscalyearstartmonth ,
    a.chng_eff_cmp_pct_flag resourcescaneditasgnmtpctcmp ,
    a.rsrc_self_add_flag resourcescanselfassigntoacts ,
    a.allow_complete_flag primaryrescanmarkactsascmp ,
    a.rsrc_multi_assign_flag resourcecanassigntosameact ,
    a.checkout_flag checkoutstatus ,
    a.step_complete_flag activitypctcmpbasedonsteps ,
    a.cost_qty_recalc_flag costquantityrecalculateflag ,
    a.sum_only_flag containssummarydataonly ,
    a.batch_sum_flag enablesummarization ,
    a.name_sep_char wbscodeseparator ,
    CASE a.def_complete_pct_type
      WHEN 'CP_Phys'
      THEN 'Physical'
      WHEN 'CP_Drtn'
      THEN 'Duration'
      WHEN 'CP_Units'
      THEN 'Units'
      WHEN 'CP_Phys'
      THEN 'Physical'
      WHEN 'CP_Drtn'
      THEN 'Duration'
      WHEN 'CP_Units'
      THEN 'Units'
      ELSE a.def_complete_pct_type
    END activitydefaultpctcmptype ,
    a.acct_id activitydefcostacctobjectid ,
    a.clndr_id activitydefcalendarobjectid ,
    a.sum_base_proj_id currentbaselineprojectobjectid ,
    a.task_code_base activityidsuffix ,
    a.task_code_step activityidincrement ,
    a.priority_num levelingpriority ,
    a.wbs_max_sum_level summarizetowbslevel ,
    a.strgy_priority_num strategicpriority ,
    a.critical_drtn_hr_cnt criticalactivityfloatlimit ,
    a.def_cost_per_qty activitydefaultpriceperunit ,
    a.plan_start_date plannedstartdate ,
    a.plan_end_date mustfinishbydate ,
    a.scd_end_date scheduledfinishdate ,
    a.add_date dateadded ,
    a.sum_data_date summarizeddatadate ,
    a.last_tasksum_date lastsummarizeddate ,
    a.fcst_start_date projectforecaststartdate ,
    CASE a.def_duration_type
      WHEN 'DT_FixedRate'
      THEN 'Fixed Units/Time'
      WHEN 'DT_FixedDrtn'
      THEN 'Fixed Duration UNITS/Time'
      WHEN 'DT_FixedQty'
      THEN 'Fixed Units'
      WHEN 'DT_FixedDUR2'
      THEN 'Fixed Duration UNITS'
      WHEN 'DT_FixedRate'
      THEN 'Fixed Units/Time'
      WHEN 'DT_FixedDrtn'
      THEN 'Fixed Duration UNITS/Time'
      WHEN 'DT_FixedQty'
      THEN 'Fixed Units'
      WHEN 'DT_FixedDUR2'
      THEN 'Fixed Duration UNITS'
      ELSE a.def_duration_type
    END activitydefaultdurationtype ,
    a.task_code_prefix activityidprefix ,
    CASE a.def_qty_type
      WHEN 'QT_Hour'
      THEN 'Hour'
      WHEN 'QT_Day'
      THEN 'Day'
      WHEN 'QT_Week'
      THEN 'Week'
      WHEN 'QT_Month'
      THEN 'Month'
      WHEN 'QT_Year'
      THEN 'Year'
      WHEN 'QT_DaysHours'
      THEN '??enm.UnitType.QT_DaysHours??'
      WHEN 'QT_HoursMinutes'
      THEN '??enm.UnitType.QT_HoursMinutes??'
      WHEN 'QT_Hour'
      THEN 'Hour'
      WHEN 'QT_Day'
      THEN 'Day'
      WHEN 'QT_Week'
      THEN 'Week'
      WHEN 'QT_Month'
      THEN 'Month'
      WHEN 'QT_Year'
      THEN 'Year'
      WHEN 'QT_DaysHours'
      THEN '??enm.UnitType.QT_DaysHours??'
      WHEN 'QT_HoursMinutes'
      THEN '??enm.UnitType.QT_HoursMinutes??'
      ELSE a.def_qty_type
    END defaultpricetimeunits ,
    a.add_by_name addedby ,
    a.web_local_root_path websiterootdirectory ,
    a.proj_url websiteurl ,
    CASE a.def_rate_type
      WHEN 'COST_PER_QTY'
      THEN 'Cost Per Qty'
      WHEN 'COST_PER_QTY2'
      THEN 'CostPerQty2'
      WHEN 'COST_PER_QTY3'
      THEN 'CostPerQty3'
      WHEN 'COST_PER_QTY4'
      THEN 'CostPerQty4'
      WHEN 'COST_PER_QTY5'
      THEN 'CostPerQty5'
      WHEN 'COST_PER_QTY'
      THEN 'Cost Per Qty'
      WHEN 'COST_PER_QTY2'
      THEN 'CostPerQty2'
      WHEN 'COST_PER_QTY3'
      THEN 'CostPerQty3'
      WHEN 'COST_PER_QTY4'
      THEN 'CostPerQty4'
      WHEN 'COST_PER_QTY5'
      THEN 'CostPerQty5'
      ELSE a.def_rate_type
    END assignmentdefaultratetype ,
    a.act_this_per_link_flag linkactualtoactualthisperiod ,
    CASE a.def_task_type
      WHEN 'TT_Task'
      THEN 'Task Dependent'
      WHEN 'TT_Rsrc'
      THEN 'Resource Dependent'
      WHEN 'TT_LOE'
      THEN 'Level Of Effort'
      WHEN 'TT_Mile'
      THEN 'Start Milestone'
      WHEN 'TT_FinMile'
      THEN 'Finish Milestone'
      WHEN 'TT_WBS'
      THEN 'WBS Summary'
      WHEN 'TT_Task'
      THEN 'Task Dependent'
      WHEN 'TT_Rsrc'
      THEN 'Resource Dependent'
      WHEN 'TT_LOE'
      THEN 'Level Of Effort'
      WHEN 'TT_Mile'
      THEN 'Start Milestone'
      WHEN 'TT_FinMile'
      THEN 'Finish Milestone'
      WHEN 'TT_WBS'
      THEN 'WBS Summary'
      ELSE a.def_task_type
    END activitydefaultactivitytype ,
    a.act_pct_link_flag linkpercentcompletewithactual ,
    a.add_act_remain_flag addactualtoremaining ,
    CASE a.critical_path_type
      WHEN 'CT_TotFloat'
      THEN 'Critical Float'
      WHEN 'CT_DrivPath'
      THEN 'Longest Path'
      WHEN 'CT_TotFloat'
      THEN 'Critical Float'
      WHEN 'CT_DrivPath'
      THEN 'Longest Path'
      ELSE a.critical_path_type
    END criticalactivitypathtype ,
    a.task_code_prefix_flag activityidbasedonselactivity ,
    a.def_rollup_dates_flag assignmentdefaultdrivingflag ,
    a.rem_target_link_flag linkplannedandatcompletionflag ,
    a.reset_planned_flag resetplannedtoremainingflag ,
    a.allow_neg_act_flag allownegativeactualunitsflag ,
    a.rsrc_id ownerresourceobjectid ,
    a.checkout_date checkoutdate ,
    a.checkout_user_id checkoutuserobjectid ,
    a.last_fin_dates_id lastfinancialperiodobjectid ,
    a.use_project_baseline_flag useprojectblforearnedvalue ,
    P.annualdiscountrate annualdiscountrate ,
    P.anticipatedfinishdate anticipatedfinishdate ,
    P.anticipatedstartdate anticipatedstartdate ,
    P.containssummarydata containssummarydata ,
    P.currentbudget currentbudget ,
    P.currentvariance currentvariance ,
    P.datadate datadate ,
    P.discountapplicationperiod discountapplicationperiod ,
    P.distributedcurrentbudget distributedcurrentbudget ,
    P.earnedvaluecomputetype earnedvaluecomputetype ,
    P.earnedvalueetccomputetype earnedvalueetccomputetype ,
    P.earnedvalueetcuservalue earnedvalueetcuservalue ,
    P.earnedvalueuserpercent earnedvalueuserpercent ,
    P.finishdate finishdate ,
    P.forecastfinishdate forecastfinishdate ,
    P.forecaststartdate forecaststartdate ,
    P.independentetclaborunits independentetclaborunits ,
    P.independentetctotalcost independentetctotalcost ,
    P.name name ,
    P.obsname obsname ,
    P.obsobjectid obsobjectid ,
    P.originalbudget originalbudget ,
    P.overallprojectscore overallprojectscore ,
    P.parentepsobjectid parentepsobjectid ,
    P.proposedbudget proposedbudget ,
    P.risklevel risklevel ,
    P.riskscore riskscore ,
    P.riskexposure riskexposure ,
    P.startdate startdate ,
    P.status status ,
    a.orig_proj_id originalprojectobjectid ,
    a.matrix_id riskscorematrixobjectid ,
    P.sumplannedstartdate sumplannedstartdate ,
    P.sumplannedfinishdate sumplannedfinishdate ,
    P.sumplannedduration sumplannedduration ,
    P.sumplannedlaborunits sumplannedlaborunits ,
    P.sumplannednonlaborunits sumplannednonlaborunits ,
    P.sumplannedexpensecost sumplannedexpensecost ,
    P.sumplannedlaborcost sumplannedlaborcost ,
    P.sumplannedmaterialcost sumplannedmaterialcost ,
    P.sumplannednonlaborcost sumplannednonlaborcost ,
    P.sumplannedtotalcost sumplannedtotalcost ,
    P.sumaccountingvarbylaborunits sumaccountingvarbylaborunits ,
    P.sumaccountingvariancebycost sumaccountingvariancebycost ,
    P.sumactthisperiodmaterialcost sumactthisperiodmaterialcost ,
    P.sumactthisperiodnonlaborcost sumactthisperiodnonlaborcost ,
    P.sumactthisperiodnonlaborunits sumactthisperiodnonlaborunits ,
    P.sumactualthisperiodlaborcost sumactualthisperiodlaborcost ,
    P.sumactualthisperiodlaborunits sumactualthisperiodlaborunits ,
    P.sumatcompletionmaterialcost sumatcompletionmaterialcost ,
    P.sumatcompletionnonlaborcost sumatcompletionnonlaborcost ,
    P.sumatcompletionnonlaborunits sumatcompletionnonlaborunits ,
    P.sumatcompletiontotalcostvar sumatcompletiontotalcostvar ,
    P.sumbaselinecompactivitycount sumbaselinecompactivitycount ,
    P.sumbaselinenotstartedactcnt sumbaselinenotstartedactcnt ,
    P.sumblinprogressactivitycount sumblinprogressactivitycount ,
    P.sumbudgetatcmpbylaborunits sumbudgetatcmpbylaborunits ,
    P.sumbudgetatcompletionbycost sumbudgetatcompletionbycost ,
    P.sumcostperfindexbycost sumcostperfindexbycost ,
    P.sumcostperfindexbylaborunits sumcostperfindexbylaborunits ,
    P.sumcostvariancebylaborunits sumcostvariancebylaborunits ,
    P.sumcostvarindexbylaborunits sumcostvarindexbylaborunits ,
    P.sumdurationpercentofplanned sumdurationpercentofplanned ,
    P.sumeacbycost sumeacbycost ,
    P.sumeacbylaborunits sumeacbylaborunits ,
    P.sumeachighpctbylaborunits sumeachighpctbylaborunits ,
    P.sumeaclowpctbylaborunits sumeaclowpctbylaborunits ,
    P.sumetcbycost sumetcbycost ,
    P.sumetcbylaborunits sumetcbylaborunits ,
    P.sumexpensecostpctcomplete sumexpensecostpctcomplete ,
    P.sumlaborcostpercentcomplete sumlaborcostpercentcomplete ,
    P.sumlaborunitspercentcomplete sumlaborunitspercentcomplete ,
    P.sumactivitycount sumactivitycount ,
    P.sumactualduration sumactualduration ,
    P.sumactualexpensecost sumactualexpensecost ,
    P.sumactualfinishdate sumactualfinishdate ,
    P.summaxactualfinishdate summaxactualfinishdate ,
    P.summaxrestartdate summaxrestartdate ,
    P.sumactuallaborcost sumactuallaborcost ,
    P.sumactuallaborunits sumactuallaborunits ,
    P.sumactualmaterialcost sumactualmaterialcost ,
    P.sumactualnonlaborcost sumactualnonlaborcost ,
    P.sumactualnonlaborunits sumactualnonlaborunits ,
    P.sumactualstartdate sumactualstartdate ,
    P.sumactualthisperiodcost sumactualthisperiodcost ,
    P.sumactualtotalcost sumactualtotalcost ,
    P.sumactualvaluebycost sumactualvaluebycost ,
    P.sumactualvaluebylaborunits sumactualvaluebylaborunits ,
    P.sumatcompletionduration sumatcompletionduration ,
    P.sumatcompletionexpensecost sumatcompletionexpensecost ,
    P.sumatcompletionlaborcost sumatcompletionlaborcost ,
    P.sumatcompletionlaborunits sumatcompletionlaborunits ,
    P.sumatcompletiontotalcost sumatcompletiontotalcost ,
    P.sumbaselineduration sumbaselineduration ,
    P.sumbaselineexpensecost sumbaselineexpensecost ,
    P.sumbaselinefinishdate sumbaselinefinishdate ,
    P.sumbaselinelaborcost sumbaselinelaborcost ,
    P.sumbaselinelaborunits sumbaselinelaborunits ,
    P.sumbaselinematerialcost sumbaselinematerialcost ,
    P.sumbaselinenonlaborcost sumbaselinenonlaborcost ,
    P.sumbaselinenonlaborunits sumbaselinenonlaborunits ,
    P.sumbaselinestartdate sumbaselinestartdate ,
    P.sumbaselinetotalcost sumbaselinetotalcost ,
    P.sumcompletedactivitycount sumcompletedactivitycount ,
    P.sumcostpercentcomplete sumcostpercentcomplete ,
    P.sumcostpercentofplanned sumcostpercentofplanned ,
    P.sumcostvariancebycost sumcostvariancebycost ,
    P.sumcostvarianceindex sumcostvarianceindex ,
    P.sumcostvarianceindexbycost sumcostvarianceindexbycost ,
    P.sumdurationpercentcomplete sumdurationpercentcomplete ,
    P.sumdurationvariance sumdurationvariance ,
    P.sumearnedvaluebycost sumearnedvaluebycost ,
    P.sumearnedvaluebylaborunits sumearnedvaluebylaborunits ,
    P.sumexpensecostvariance sumexpensecostvariance ,
    P.sumfinishdatevariance sumfinishdatevariance ,
    P.suminprogressactivitycount suminprogressactivitycount ,
    P.sumlaborcostvariance sumlaborcostvariance ,
    P.sumlaborunitsvariance sumlaborunitsvariance ,
    P.summaterialcostvariance summaterialcostvariance ,
    P.sumnonlaborcostvariance sumnonlaborcostvariance ,
    P.sumnonlaborunitsvariance sumnonlaborunitsvariance ,
    P.sumnotstartedactivitycount sumnotstartedactivitycount ,
    P.sumplannedvaluebycost sumplannedvaluebycost ,
    P.sumprogressfinishdate sumprogressfinishdate ,
    P.sumremainingduration sumremainingduration ,
    P.sumremainingexpensecost sumremainingexpensecost ,
    P.sumremainingfinishdate sumremainingfinishdate ,
    P.sumremaininglaborcost sumremaininglaborcost ,
    P.sumremaininglaborunits sumremaininglaborunits ,
    P.sumremainingmaterialcost sumremainingmaterialcost ,
    P.sumremainingnonlaborcost sumremainingnonlaborcost ,
    P.sumremainingnonlaborunits sumremainingnonlaborunits ,
    P.sumremainingstartdate sumremainingstartdate ,
    P.sumremainingtotalcost sumremainingtotalcost ,
    P.sumschedulepercentcomplete sumschedulepercentcomplete ,
    P.sumperformancepercentcomplete sumperformancepercentcomplete ,
    P.sumschedulevariancebycost sumschedulevariancebycost ,
    P.sumschedulevarianceindex sumschedulevarianceindex ,
    P.sumstartdatevariance sumstartdatevariance ,
    P.sumtotalcostvariance sumtotalcostvariance ,
    P.sumtotalfloat sumtotalfloat ,
    P.sumunitspercentcomplete sumunitspercentcomplete ,
    P.summaterialcostpctcomplete summaterialcostpctcomplete ,
    P.sumnonlaborcostpctcomplete sumnonlaborcostpctcomplete ,
    P.sumnonlaborunitspctcomplete sumnonlaborunitspctcomplete ,
    P.sumperfpctcmpbylaborunits sumperfpctcmpbylaborunits ,
    P.sumplannedvaluebylaborunits sumplannedvaluebylaborunits ,
    P.sumschdpctcmpbylaborunits sumschdpctcmpbylaborunits ,
    P.sumschdperfindexbylaborunits sumschdperfindexbylaborunits ,
    P.sumschdvariancebylaborunits sumschdvariancebylaborunits ,
    P.sumschdvarianceindexbycost sumschdvarianceindexbycost ,
    P.sumschdvarindexbylaborunits sumschdvarindexbylaborunits ,
    P.sumscheduleperfindexbycost sumscheduleperfindexbycost ,
    P.sumtocompleteperfindexbycost sumtocompleteperfindexbycost ,
    P.sumvaratcmpbylaborunits sumvaratcmpbylaborunits ,
    P.sumearlystartdate sumearlystartdate ,
    P.sumearlyenddate sumearlyenddate ,
    P.sumlatestartdate sumlatestartdate ,
    P.sumlateenddate sumlateenddate ,
    P.summaxcalendarid summaxcalendarid ,
    P.summincalendarid summincalendarid ,
    P.totalbenefitplan totalbenefitplan ,
    P.totalbenefitplantally totalbenefitplantally ,
    P.totalfunding totalfunding ,
    P.totalspendingplan totalspendingplan ,
    P.totalspendingplantally totalspendingplantally ,
    P.unallocatedbudget unallocatedbudget ,
    P.netpresentvalue netpresentvalue ,
    P.returnoninvestment returnoninvestment ,
    P.paybackperiod paybackperiod ,
    P.undistributedcurrentvariance undistributedcurrentvariance ,
    a.description projectdescription ,
    a.base_type_id baselinetypeobjectid ,
    a.px_enable_publication_flag enablepublication ,
    a.px_next_date nextpublicationdate ,
    a.px_last_update_date lastpublishedon ,
    a.px_priority publicationpriority ,
    a.location_id locationobjectid ,
    a.hist_interval historyinterval ,
    a.hist_level historylevel ,
    P.locationname locationname ,
    a.control_updates_flag allowstatusreview ,
    P.statusreviewerobjectid statusreviewerobjectid ,
    P.statusreviewername statusreviewername ,
    a.update_user lastupdateuser ,
    a.update_date lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate ,
    a.etl_interval etlinterval ,
    a.etl_hour etlhour ,
    CASE
      WHEN a.update_date > p.update_date
      THEN a.update_date
      ELSE p.update_date
    END lastupdatedatex
   FROM ${pm.or.administrative_user}.PROJECT A
  INNER JOIN ${pm.or.administrative_user}.PROJECTX P
  ON a.proj_id               = p.proj_id
  AND a.PROJECT_FLAG         = 'Y'
  WHERE A.DELETE_SESSION_ID IS NULL
  AND upper(a.hist_level)    in ('HL_TASK','HL_TASK_WK','HL_TASK_MN')
  AND a.ORIG_PROJ_ID        IS NULL
  /

--METADATA NAME:ACTIVITYSPREAD_SC TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE   
CREATE OR REPLACE VIEW ACTIVITYSPREAD_SC(ACTIVITYOBJECTID, STARTDATE, ENDDATE, ACTIVITYCODE, ACTIVITYNAME, WBSOBJECTID, PROJECTOBJECTID, ACTUALLABORUNITS, ACTUALNONLABORUNITS, ATCOMPLETIONLABORUNITS, ATCOMPLETIONNONLABORUNITS, BASELINEACTUALLABORUNITS, BASELINEACTUALNONLABORUNITS, BASELINEPLANNEDLABORUNITS, BASELINEPLANNEDNONLABORUNITS, BASELINE1ACTUALLABORUNITS, BASELINE1ACTUALNONLABORUNITS, BASELINE1PLANNEDLABORUNITS, BASELINE1PLANNEDNONLABORUNITS, EARNEDVALUELABORUNITS, ESTIMATEATCOMPLETIONLABORUNITS, ESTIMATETOCOMPLETELABORUNITS, PLANNEDLABORUNITS, PLANNEDNONLABORUNITS, PLANNEDVALUELABORUNITS, REMAININGLABORUNITS, REMAININGLATELABORUNITS, REMAININGLATENONLABORUNITS, REMAININGNONLABORUNITS, ACTUALCOST, ACTUALEXPENSECOST, ACTUALLABORCOST, ACTUALMATERIALCOST, ACTUALNONLABORCOST, ACTUALTOTALCOST, ATCOMPLETIONEXPENSECOST, ATCOMPLETIONLABORCOST, ATCOMPLETIONMATERIALCOST,
  ATCOMPLETIONNONLABORCOST, ATCOMPLETIONTOTALCOST, BASELINEPLANNEDEXPENSECOST, BASELINEPLANNEDLABORCOST, BASELINEPLANNEDMATERIALCOST, BASELINEPLANNEDNONLABORCOST, BASELINEPLANNEDTOTALCOST, BASELINEACTUALEXPENSECOST, BASELINEACTUALLABORCOST, BASELINEACTUALMATERIALCOST, BASELINEACTUALNONLABORCOST, BASELINEACTUALTOTALCOST, BASELINE1ACTUALEXPENSECOST, BASELINE1ACTUALLABORCOST, BASELINE1ACTUALMATERIALCOST, BASELINE1ACTUALNONLABORCOST, BASELINE1ACTUALTOTALCOST, BASELINE1PLANNEDEXPENSECOST, BASELINE1PLANNEDLABORCOST, BASELINE1PLANNEDMATERIALCOST, BASELINE1PLANNEDNONLABORCOST, BASELINE1PLANNEDTOTALCOST, EARNEDVALUECOST, ESTIMATEATCOMPLETIONCOST, ESTIMATETOCOMPLETECOST, PLANNEDEXPENSECOST, PLANNEDLABORCOST, PLANNEDMATERIALCOST, PLANNEDNONLABORCOST, PLANNEDTOTALCOST, PLANNEDVALUECOST, REMAININGEXPENSECOST, REMAININGLABORCOST, REMAININGLATEEXPENSECOST, REMAININGLATELABORCOST, REMAININGLATEMATERIALCOST,
  REMAININGLATENONLABORCOST, REMAININGLATETOTALCOST, REMAININGMATERIALCOST, REMAININGNONLABORCOST, REMAININGTOTALCOST, LASTUPDATEDATE, CBSOBJECTID)
AS
  SELECT a.ACTIVITYOBJECTID,
    a.STARTDATE,
    a.ENDDATE,
    a.ACTIVITYCODE,
    a.ACTIVITYNAME,
    a.WBSOBJECTID,
    a.PROJECTOBJECTID,
    a.ACTUALLABORUNITS,
    a.ACTUALNONLABORUNITS,
    a.ATCOMPLETIONLABORUNITS,
    a.ATCOMPLETIONNONLABORUNITS,
    a.BASELINEACTUALLABORUNITS,
    a.BASELINEACTUALNONLABORUNITS,
    a.BASELINEPLANNEDLABORUNITS,
    a.BASELINEPLANNEDNONLABORUNITS,
    a.BASELINE1ACTUALLABORUNITS,
    a.BASELINE1ACTUALNONLABORUNITS,
    a.BASELINE1PLANNEDLABORUNITS,
    a.BASELINE1PLANNEDNONLABORUNITS,
    a.EARNEDVALUELABORUNITS,
    a.ESTIMATEATCOMPLETIONLABORUNITS,
    a.ESTIMATETOCOMPLETELABORUNITS,
    a.PLANNEDLABORUNITS,
    a.PLANNEDNONLABORUNITS,
    a.PLANNEDVALUELABORUNITS,
    a.REMAININGLABORUNITS,
    a.REMAININGLATELABORUNITS,
    a.REMAININGLATENONLABORUNITS,
    a.REMAININGNONLABORUNITS,
    a.ACTUALCOST,
    a.ACTUALEXPENSECOST,
    a.ACTUALLABORCOST,
    a.ACTUALMATERIALCOST,
    a.ACTUALNONLABORCOST,
    a.ACTUALTOTALCOST,
    a.ATCOMPLETIONEXPENSECOST,
    a.ATCOMPLETIONLABORCOST,
    a.ATCOMPLETIONMATERIALCOST,
    a.ATCOMPLETIONNONLABORCOST,
    a.ATCOMPLETIONTOTALCOST,
    a.BASELINEPLANNEDEXPENSECOST,
    a.BASELINEPLANNEDLABORCOST,
    a.BASELINEPLANNEDMATERIALCOST,
    a.BASELINEPLANNEDNONLABORCOST,
    a.BASELINEPLANNEDTOTALCOST,
    a.BASELINEACTUALEXPENSECOST,
    a.BASELINEACTUALLABORCOST,
    a.BASELINEACTUALMATERIALCOST,
    a.BASELINEACTUALNONLABORCOST,
    a.BASELINEACTUALTOTALCOST,
    a.BASELINE1ACTUALEXPENSECOST,
    a.BASELINE1ACTUALLABORCOST,
    a.BASELINE1ACTUALMATERIALCOST,
    a.BASELINE1ACTUALNONLABORCOST,
    a.BASELINE1ACTUALTOTALCOST,
    a.BASELINE1PLANNEDEXPENSECOST,
    a.BASELINE1PLANNEDLABORCOST,
    a.BASELINE1PLANNEDMATERIALCOST,
    a.BASELINE1PLANNEDNONLABORCOST,
    a.BASELINE1PLANNEDTOTALCOST,
    a.EARNEDVALUECOST,
    a.ESTIMATEATCOMPLETIONCOST,
    a.ESTIMATETOCOMPLETECOST,
    a.PLANNEDEXPENSECOST,
    a.PLANNEDLABORCOST,
    a.PLANNEDMATERIALCOST,
    a.PLANNEDNONLABORCOST,
    a.PLANNEDTOTALCOST,
    a.PLANNEDVALUECOST,
    a.REMAININGEXPENSECOST,
    a.REMAININGLABORCOST,
    a.REMAININGLATEEXPENSECOST,
    a.REMAININGLATELABORCOST,
    a.REMAININGLATEMATERIALCOST,
    a.REMAININGLATENONLABORCOST,
    a.REMAININGLATETOTALCOST,
    a.REMAININGMATERIALCOST,
    a.REMAININGNONLABORCOST,
    a.REMAININGTOTALCOST,
    a.UPDATE_DATE,
    T1.cbs_id cbsobjectid
   FROM ${pm.or.administrative_user}.ACTIVITYSPREAD a
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab on a.projectobjectid = projects_tab.proj_id AND upper(projects_tab.hist_level) in ('HL_TASK','HL_TASK_WK','HL_TASK_MN') AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  INNER JOIN ${pm.or.administrative_user}.TASK T1 ON T1.task_id = ActivityObjectId AND T1.DELETE_SESSION_ID IS NULL
  /
  
--METADATA NAME:RESOURCEASSIGNMENT_SC TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE 
CREATE OR REPLACE VIEW RESOURCEASSIGNMENT_SC(OBJECTID, ACTIVITYOBJECTID, PROJECTOBJECTID, RESOURCETYPE, ISCOSTUNITSLINKED, ROLEOBJECTID, COSTACCOUNTOBJECTID, RESOURCEOBJECTID, PROFICIENCY, PENDINGPERCENTCOMPLETE, REMAININGUNITS, PENDINGREMAININGUNITS, PLANNEDUNITS, REMAININGUNITSPERTIME, PENDINGACTUALREGULARUNITS, PLANNEDLAG, PLANNEDUNITSPERTIME, ACTUALOVERTIMEUNITS, PENDINGACTUALOVERTIMEUNITS, ACTUALREGULARUNITS, REMAININGLAG, OVERTIMEFACTOR, PLANNEDCOST, ACTUALREGULARCOST, ACTUALOVERTIMECOST, REMAININGCOST, ACTUALSTARTDATE, ACTUALFINISHDATE, REMAININGSTARTDATE, REMAININGFINISHDATE, PLANNEDSTARTDATE, PLANNEDFINISHDATE, REMAININGLATESTARTDATE, REMAININGLATEFINISHDATE, RATETYPE, ACTUALTHISPERIODCOST, ACTUALTHISPERIODUNITS, RESOURCECURVEOBJECTID, DRIVINGACTIVITYDATESFLAG, RATESOURCE, ACTIVITYID, ACTIVITYNAME, ACTUALCOST, ACTUALDURATION, ACTUALUNITS, ATCOMPLETIONCOST
  , ATCOMPLETIONDURATION, ATCOMPLETIONUNITS, AUTOCOMPUTEACTUALS, CALENDAROBJECTID, COSTACCOUNTID, COSTACCOUNTNAME, FINISHDATE, ISACTIVE, ISOVERTIMEALLOWED, ISPRIMARYRESOURCE, PLANNEDDURATION, PRICEPERUNIT, PROJECTID, REMAININGDURATION, RESOURCECURVENAME, RESOURCEID, RESOURCENAME, ROLEID, ROLENAME, STAFFEDREMAININGCOST, STAFFEDREMAININGUNITS, STARTDATE, UNITSPERCENTCOMPLETE, UNSTAFFEDREMAININGCOST, UNSTAFFEDREMAININGUNITS, WBSOBJECTID, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE, LASTUPDATEDATEX, RPT_CURRENT_FLAG)
AS
  SELECT a.taskrsrc_id objectid ,
    a.task_id activityobjectid ,
    a.proj_id projectobjectid ,
    CASE a.rsrc_type
      WHEN 'RT_Labor'
      THEN 'Labor'
      WHEN 'RT_Equip'
      THEN 'Nonlabor'
      WHEN 'RT_Mat'
      THEN 'Material'
      ELSE a.rsrc_type
    END resourcetype ,
    a.cost_qty_link_flag iscostunitslinked ,
    a.role_id roleobjectid ,
    a.acct_id costaccountobjectid ,
    a.rsrc_id resourceobjectid ,
    P.proficiency proficiency ,
    a.pend_complete_pct pendingpercentcomplete ,
    a.remain_qty remainingunits ,
    a.pend_remain_qty pendingremainingunits ,
    a.target_qty plannedunits ,
    a.remain_qty_per_hr remainingunitspertime ,
    a.pend_act_reg_qty pendingactualregularunits ,
    a.target_lag_drtn_hr_cnt plannedlag ,
    a.target_qty_per_hr plannedunitspertime ,
    a.act_ot_qty actualovertimeunits ,
    a.pend_act_ot_qty pendingactualovertimeunits ,
    a.act_reg_qty actualregularunits ,
    P.remaininglag remaininglag ,
    a.ot_factor overtimefactor ,
    a.target_cost plannedcost ,
    a.act_reg_cost actualregularcost ,
    a.act_ot_cost actualovertimecost ,
    a.remain_cost remainingcost ,
    a.act_start_date actualstartdate ,
    a.act_end_date actualfinishdate ,
    a.restart_date remainingstartdate ,
    a.reend_date remainingfinishdate ,
    a.target_start_date plannedstartdate ,
    a.target_end_date plannedfinishdate ,
    a.rem_late_start_date remaininglatestartdate ,
    a.rem_late_end_date remaininglatefinishdate ,
    CASE a.rate_type
      WHEN 'COST_PER_QTY'
      THEN 'Price/Unit'
      WHEN 'COST_PER_QTY2'
      THEN 'Price/Unit 2'
      WHEN 'COST_PER_QTY3'
      THEN 'Price/Unit 3'
      WHEN 'COST_PER_QTY4'
      THEN 'Price/Unit 4'
      WHEN 'COST_PER_QTY5'
      THEN 'Price/Unit 5'
      ELSE a.rate_type
    END ratetype ,
    a.act_this_per_cost actualthisperiodcost ,
    a.act_this_per_qty actualthisperiodunits ,
    a.curv_id resourcecurveobjectid ,
    a.rollup_dates_flag drivingactivitydatesflag ,
    CASE a.cost_per_qty_source_type
      WHEN 'ST_Rsrc'
      THEN 'Resource'
      WHEN 'ST_Role'
      THEN 'Role'
      WHEN 'ST_Custom'
      THEN 'Override'
      ELSE a.cost_per_qty_source_type
    END ratesource ,
    P.activityid activityid ,
    P.activityname activityname ,
    P.actualcost actualcost ,
    P.actualduration actualduration ,
    P.actualunits actualunits ,
    P.atcompletioncost atcompletioncost ,
    P.atcompletionduration atcompletionduration ,
    P.atcompletionunits atcompletionunits ,
    P.autocomputeactuals autocomputeactuals ,
    P.calendarobjectid calendarobjectid ,
    P.costaccountid costaccountid ,
    P.costaccountname costaccountname ,
    P.finishdate finishdate ,
    P.isactive isactive ,
    P.isovertimeallowed isovertimeallowed ,
    P.isprimaryresource isprimaryresource ,
    P.plannedduration plannedduration ,
    P.priceperunit priceperunit ,
    P.projectid projectid ,
    P.remainingduration remainingduration ,
    P.resourcecurvename resourcecurvename ,
    P.resourceid resourceid ,
    P.resourcename resourcename ,
    P.roleid roleid ,
    P.rolename rolename ,
    P.staffedremainingcost staffedremainingcost ,
    P.staffedremainingunits staffedremainingunits ,
    P.startdate startdate ,
    P.unitspercentcomplete unitspercentcomplete ,
    P.unstaffedremainingcost unstaffedremainingcost ,
    P.unstaffedremainingunits unstaffedremainingunits ,
    P.wbsobjectid wbsobjectid ,
    a.update_user lastupdateuser ,
    a.update_date lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate ,
    P.update_date lastupdatedatex ,
    CASE
      WHEN a.update_date>P.update_date
      THEN 'N'
      ELSE 'Y'
    END rpt_current_flag
   FROM ${pm.or.administrative_user}.TASKRSRC A
  INNER JOIN ${pm.or.administrative_user}.TASKRSRCX P ON a.taskrsrc_id           = p.taskrsrc_id
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab ON a.proj_id = projects_tab.proj_id AND upper(projects_tab.hist_level) in ('HL_TASK','HL_TASK_WK','HL_TASK_MN')  AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  WHERE A.DELETE_SESSION_ID IS NULL
  /

--METADATA NAME:RESOURCEASSIGNMENTSPREAD_SC TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE   
CREATE OR REPLACE VIEW RESOURCEASSIGNMENTSPREAD_SC(RESOURCEASSIGNMENTOBJECTID, STARTDATE, ENDDATE, RESOURCEOBJECTID, ROLEOBJECTID, ACTIVITYOBJECTID, WBSOBJECTID, PROJECTOBJECTID, COSTACCOUNTOBJECTID, ACTUALREGULARUNITS, ACTUALOVERTIMEUNITS, ACTUALUNITS, ATCOMPLETIONUNITS, PLANNEDUNITS, REMAININGUNITS, REMAININGLATEUNITS, STAFFEDREMAININGUNITS, STAFFEDREMAININGLATEUNITS, UNSTAFFEDREMAININGUNITS, UNSTAFFEDREMAININGLATEUNITS, ACTUALREGULARCOST, ACTUALOVERTIMECOST, ACTUALCOST, ATCOMPLETIONCOST, PLANNEDCOST, REMAININGCOST, REMAININGLATECOST, STAFFEDREMAININGCOST, STAFFEDREMAININGLATECOST, UNSTAFFEDREMAININGCOST, UNSTAFFEDREMAININGLATECOST, LASTUPDATEDATE, CBSOBJECTID)
AS
  SELECT a.RESOURCEASSIGNMENTOBJECTID,
    a.STARTDATE,
    a.ENDDATE,
    a.RESOURCEOBJECTID,
    a.ROLEOBJECTID,
    a.ACTIVITYOBJECTID,
    a.WBSOBJECTID,
    a.PROJECTOBJECTID,
    a.COSTACCOUNTOBJECTID,
    a.ACTUALREGULARUNITS,
    a.ACTUALOVERTIMEUNITS,
    a.ACTUALUNITS,
    a.ATCOMPLETIONUNITS,
    a.PLANNEDUNITS,
    a.REMAININGUNITS,
    a.REMAININGLATEUNITS,
    a.STAFFEDREMAININGUNITS,
    a.STAFFEDREMAININGLATEUNITS,
    a.UNSTAFFEDREMAININGUNITS,
    a.UNSTAFFEDREMAININGLATEUNITS,
    a.ACTUALREGULARCOST,
    a.ACTUALOVERTIMECOST,
    a.ACTUALCOST,
    a.ATCOMPLETIONCOST,
    a.PLANNEDCOST,
    a.REMAININGCOST,
    a.REMAININGLATECOST,
    a.STAFFEDREMAININGCOST,
    a.STAFFEDREMAININGLATECOST,
    a.UNSTAFFEDREMAININGCOST,
    a.UNSTAFFEDREMAININGLATECOST,
    a.update_date,
    T1.cbs_id cbsobjectid
   FROM ${pm.or.administrative_user}.RESOURCEASSIGNMENTSPREAD a
  INNER JOIN ${pm.or.administrative_user}.TASKRSRC T1  ON T1.taskrsrc_id         = ResourceAssignmentObjectId
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab ON a.projectobjectid = projects_tab.proj_id AND upper(projects_tab.hist_level) in ('HL_TASK','HL_TASK_WK','HL_TASK_MN')  AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  AND T1.DELETE_SESSION_ID IS NULL
  /

--METADATA NAME:WBS_SC TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE   
CREATE OR REPLACE VIEW WBS_SC(OBJECTID, PROJECTOBJECTID, OBSOBJECTID, SEQUENCENUMBER, CONTAINSSUMMARYDATA, STATUS, CODE, NAME, WBSCATEGORYOBJECTID, PARENTOBJECTID, EARNEDVALUEUSERPERCENT, EARNEDVALUEETCUSERVALUE, ORIGINALBUDGET, INDEPENDENTETCTOTALCOST, INDEPENDENTETCLABORUNITS, ANTICIPATEDSTARTDATE, ANTICIPATEDFINISHDATE, EARNEDVALUECOMPUTETYPE, EARNEDVALUEETCCOMPUTETYPE, CURRENTBUDGET, CURRENTVARIANCE, DISTRIBUTEDCURRENTBUDGET, FINISHDATE, FORECASTFINISHDATE, FORECASTSTARTDATE, FULLNAME, FULLSEQUENCE, OBSNAME, PROJECTID, PROPOSEDBUDGET, STARTDATE, SUMPLANNEDSTARTDATE, SUMPLANNEDFINISHDATE, SUMPLANNEDDURATION, SUMPLANNEDLABORUNITS, SUMPLANNEDNONLABORUNITS, SUMPLANNEDEXPENSECOST, SUMPLANNEDLABORCOST, SUMPLANNEDMATERIALCOST, SUMPLANNEDNONLABORCOST, SUMPLANNEDTOTALCOST, SUMACCOUNTINGVARBYLABORUNITS, SUMACCOUNTINGVARIANCEBYCOST, SUMACTTHISPERIODMATERIALCOST,
  SUMACTTHISPERIODNONLABORCOST, SUMACTTHISPERIODNONLABORUNITS, SUMACTUALTHISPERIODLABORCOST, SUMACTUALTHISPERIODLABORUNITS, SUMATCOMPLETIONMATERIALCOST, SUMATCOMPLETIONNONLABORCOST, SUMATCOMPLETIONNONLABORUNITS, SUMATCOMPLETIONTOTALCOSTVAR, SUMBASELINECOMPACTIVITYCOUNT, SUMBASELINENOTSTARTEDACTCNT, SUMBLINPROGRESSACTIVITYCOUNT, SUMBUDGETATCMPBYLABORUNITS, SUMBUDGETATCOMPLETIONBYCOST, SUMCOSTPERFINDEXBYCOST, SUMCOSTPERFINDEXBYLABORUNITS, SUMCOSTVARIANCEBYLABORUNITS, SUMCOSTVARINDEXBYLABORUNITS, SUMDURATIONPERCENTOFPLANNED, SUMEACBYCOST, SUMEACBYLABORUNITS, SUMEACHIGHPCTBYLABORUNITS, SUMEACLOWPCTBYLABORUNITS, SUMETCBYCOST, SUMETCBYLABORUNITS, SUMEXPENSECOSTPCTCOMPLETE, SUMLABORCOSTPERCENTCOMPLETE, SUMLABORUNITSPERCENTCOMPLETE, SUMACTIVITYCOUNT, SUMACTUALDURATION, SUMACTUALEXPENSECOST, SUMACTUALFINISHDATE, SUMMAXACTUALFINISHDATE, SUMMAXRESTARTDATE, SUMACTUALLABORCOST, SUMACTUALLABORUNITS, SUMACTUALMATERIALCOST,
  SUMACTUALNONLABORCOST, SUMACTUALNONLABORUNITS, SUMACTUALSTARTDATE, SUMACTUALTHISPERIODCOST, SUMACTUALTOTALCOST, SUMACTUALVALUEBYCOST, SUMACTUALVALUEBYLABORUNITS, SUMATCOMPLETIONDURATION, SUMATCOMPLETIONEXPENSECOST, SUMATCOMPLETIONLABORCOST, SUMATCOMPLETIONLABORUNITS, SUMATCOMPLETIONTOTALCOST, SUMBASELINEDURATION, SUMBASELINEEXPENSECOST, SUMBASELINEFINISHDATE, SUMBASELINELABORCOST, SUMBASELINELABORUNITS, SUMBASELINEMATERIALCOST, SUMBASELINENONLABORCOST, SUMBASELINENONLABORUNITS, SUMBASELINESTARTDATE, SUMBASELINETOTALCOST, SUMCOMPLETEDACTIVITYCOUNT, SUMCOSTPERCENTCOMPLETE, SUMCOSTPERCENTOFPLANNED, SUMCOSTVARIANCEBYCOST, SUMCOSTVARIANCEINDEX, SUMCOSTVARIANCEINDEXBYCOST, SUMDURATIONPERCENTCOMPLETE, SUMDURATIONVARIANCE, SUMEARNEDVALUEBYCOST, SUMEARNEDVALUEBYLABORUNITS, SUMEXPENSECOSTVARIANCE, SUMFINISHDATEVARIANCE, SUMINPROGRESSACTIVITYCOUNT, SUMLABORCOSTVARIANCE, SUMLABORUNITSVARIANCE, SUMMATERIALCOSTVARIANCE,
  SUMNONLABORCOSTVARIANCE, SUMNONLABORUNITSVARIANCE, SUMNOTSTARTEDACTIVITYCOUNT, SUMPLANNEDVALUEBYCOST, SUMPROGRESSFINISHDATE, SUMREMAININGDURATION, SUMREMAININGEXPENSECOST, SUMREMAININGFINISHDATE, SUMREMAININGLABORCOST, SUMREMAININGLABORUNITS, SUMREMAININGMATERIALCOST, SUMREMAININGNONLABORCOST, SUMREMAININGNONLABORUNITS, SUMREMAININGSTARTDATE, SUMREMAININGTOTALCOST, SUMSCHEDULEPERCENTCOMPLETE, SUMPERFORMANCEPERCENTCOMPLETE, SUMSCHEDULEVARIANCEBYCOST, SUMSCHEDULEVARIANCEINDEX, SUMSTARTDATEVARIANCE, SUMTOTALCOSTVARIANCE, SUMTOTALFLOAT, SUMUNITSPERCENTCOMPLETE, SUMMATERIALCOSTPCTCOMPLETE, SUMNONLABORCOSTPCTCOMPLETE, SUMNONLABORUNITSPCTCOMPLETE, SUMPERFPCTCMPBYLABORUNITS, SUMPLANNEDVALUEBYLABORUNITS, SUMSCHDPCTCMPBYLABORUNITS, SUMSCHDPERFINDEXBYLABORUNITS, SUMSCHDVARIANCEBYLABORUNITS, SUMSCHDVARIANCEINDEXBYCOST, SUMSCHDVARINDEXBYLABORUNITS, SUMSCHEDULEPERFINDEXBYCOST, SUMTOCOMPLETEPERFINDEXBYCOST,
  SUMVARATCMPBYLABORUNITS, SUMEARLYSTARTDATE, SUMEARLYENDDATE, SUMLATESTARTDATE, SUMLATEENDDATE, SUMMAXCALENDARID, SUMMINCALENDARID, TOTALBENEFITPLAN, TOTALBENEFITPLANTALLY, TOTALSPENDINGPLAN, TOTALSPENDINGPLANTALLY, UNALLOCATEDBUDGET, UNDISTRIBUTEDCURRENTVARIANCE, STATUSREVIEWEROBJECTID, STATUSREVIEWERNAME, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE, LASTUPDATEDATEX, RPT_CURRENT_FLAG, PROJECTNODEFLAG)
AS
  SELECT a.wbs_id objectid ,
    a.proj_id projectobjectid ,
    a.obs_id obsobjectid ,
    a.seq_num sequencenumber ,
    a.sum_data_flag containssummarydata ,
    CASE a.status_code
      WHEN 'WS_Planned'
      THEN 'Planned'
      WHEN 'WS_Open'
      THEN 'Active'
      WHEN 'WS_Closed'
      THEN 'Inactive'
      WHEN 'WS_Whatif'
      THEN 'What If'
      WHEN 'WS_Requested'
      THEN 'Requested'
      WHEN 'WS_Template'
      THEN 'Template'
      WHEN 'WS_Planned'
      THEN 'Planned'
      WHEN 'WS_Open'
      THEN 'Active'
      WHEN 'WS_Closed'
      THEN 'Inactive'
      WHEN 'WS_Whatif'
      THEN 'What If'
      WHEN 'WS_Requested'
      THEN 'Requested'
      WHEN 'WS_Template'
      THEN 'Template'
      ELSE a.status_code
    END status ,
    a.wbs_short_name code ,
    a.wbs_name name ,
    a.phase_id wbscategoryobjectid ,
    a.parent_wbs_id parentobjectid ,
    a.ev_user_pct earnedvalueuserpercent ,
    a.ev_etc_user_value earnedvalueetcuservalue ,
    a.orig_cost originalbudget ,
    a.indep_remain_total_cost independentetctotalcost ,
    a.indep_remain_work_qty independentetclaborunits ,
    a.anticip_start_date anticipatedstartdate ,
    a.anticip_end_date anticipatedfinishdate ,
    CASE a.ev_compute_type
      WHEN 'EC_Cmp_pct'
      THEN 'Activity Percent Complete'
      WHEN 'EC_0_pct'
      THEN 'Zero Hundred'
      WHEN 'EC_50_pct'
      THEN 'Fifty Fifty'
      WHEN 'EC_User_pct'
      THEN 'Custom Percent Complete'
      WHEN 'EC_MS'
      THEN 'WBS Milestones Percent Complete'
      WHEN 'EC_Curve'
      THEN 'Activity Percent Complete Using Resource Curve'
      WHEN 'EC_Cmp_pct'
      THEN 'Activity Percent Complete'
      WHEN 'EC_0_pct'
      THEN 'Zero Hundred'
      WHEN 'EC_50_pct'
      THEN 'Fifty Fifty'
      WHEN 'EC_User_pct'
      THEN 'Custom Percent Complete'
      WHEN 'EC_MS'
      THEN 'WBS Milestones Percent Complete'
      WHEN 'EC_Curve'
      THEN 'Activity Percent Complete Using Resource Curve'
      ELSE a.ev_compute_type
    END earnedvaluecomputetype ,
    CASE a.ev_etc_compute_type
      WHEN 'EE_Rem_hr'
      THEN 'Remaining Cost For Activity'
      WHEN 'EE_PF_1'
      THEN 'PF 1'
      WHEN 'EE_PF_user'
      THEN 'PF Custom'
      WHEN 'EE_PF_cpi'
      THEN 'PF CPI'
      WHEN 'EE_PF_cpi_spi'
      THEN 'PF CPI SPI'
      WHEN 'EE_Rem_hr'
      THEN 'Remaining Cost For Activity'
      WHEN 'EE_PF_1'
      THEN 'PF 1'
      WHEN 'EE_PF_user'
      THEN 'PF Custom'
      WHEN 'EE_PF_cpi'
      THEN 'PF CPI'
      WHEN 'EE_PF_cpi_spi'
      THEN 'PF CPI SPI'
      ELSE a.ev_etc_compute_type
    END earnedvalueetccomputetype ,
    P.currentbudget currentbudget ,
    P.currentvariance currentvariance ,
    P.distributedcurrentbudget distributedcurrentbudget ,
    P.finishdate finishdate ,
    P.forecastfinishdate forecastfinishdate ,
    P.forecaststartdate forecaststartdate ,
    P.fullname fullname ,
    P.fullsequence fullsequence ,
    P.obsname obsname ,
    P.projectid projectid ,
    P.proposedbudget proposedbudget ,
    P.startdate startdate ,
    P.sumplannedstartdate sumplannedstartdate ,
    P.sumplannedfinishdate sumplannedfinishdate ,
    P.sumplannedduration sumplannedduration ,
    P.sumplannedlaborunits sumplannedlaborunits ,
    P.sumplannednonlaborunits sumplannednonlaborunits ,
    P.sumplannedexpensecost sumplannedexpensecost ,
    P.sumplannedlaborcost sumplannedlaborcost ,
    P.sumplannedmaterialcost sumplannedmaterialcost ,
    P.sumplannednonlaborcost sumplannednonlaborcost ,
    P.sumplannedtotalcost sumplannedtotalcost ,
    P.sumaccountingvarbylaborunits sumaccountingvarbylaborunits ,
    P.sumaccountingvariancebycost sumaccountingvariancebycost ,
    P.sumactthisperiodmaterialcost sumactthisperiodmaterialcost ,
    P.sumactthisperiodnonlaborcost sumactthisperiodnonlaborcost ,
    P.sumactthisperiodnonlaborunits sumactthisperiodnonlaborunits ,
    P.sumactualthisperiodlaborcost sumactualthisperiodlaborcost ,
    P.sumactualthisperiodlaborunits sumactualthisperiodlaborunits ,
    P.sumatcompletionmaterialcost sumatcompletionmaterialcost ,
    P.sumatcompletionnonlaborcost sumatcompletionnonlaborcost ,
    P.sumatcompletionnonlaborunits sumatcompletionnonlaborunits ,
    P.sumatcompletiontotalcostvar sumatcompletiontotalcostvar ,
    P.sumbaselinecompactivitycount sumbaselinecompactivitycount ,
    P.sumbaselinenotstartedactcnt sumbaselinenotstartedactcnt ,
    P.sumblinprogressactivitycount sumblinprogressactivitycount ,
    P.sumbudgetatcmpbylaborunits sumbudgetatcmpbylaborunits ,
    P.sumbudgetatcompletionbycost sumbudgetatcompletionbycost ,
    P.sumcostperfindexbycost sumcostperfindexbycost ,
    P.sumcostperfindexbylaborunits sumcostperfindexbylaborunits ,
    P.sumcostvariancebylaborunits sumcostvariancebylaborunits ,
    P.sumcostvarindexbylaborunits sumcostvarindexbylaborunits ,
    P.sumdurationpercentofplanned sumdurationpercentofplanned ,
    P.sumeacbycost sumeacbycost ,
    P.sumeacbylaborunits sumeacbylaborunits ,
    P.sumeachighpctbylaborunits sumeachighpctbylaborunits ,
    P.sumeaclowpctbylaborunits sumeaclowpctbylaborunits ,
    P.sumetcbycost sumetcbycost ,
    P.sumetcbylaborunits sumetcbylaborunits ,
    P.sumexpensecostpctcomplete sumexpensecostpctcomplete ,
    P.sumlaborcostpercentcomplete sumlaborcostpercentcomplete ,
    P.sumlaborunitspercentcomplete sumlaborunitspercentcomplete ,
    P.sumactivitycount sumactivitycount ,
    P.sumactualduration sumactualduration ,
    P.sumactualexpensecost sumactualexpensecost ,
    P.sumactualfinishdate sumactualfinishdate ,
    P.summaxactualfinishdate summaxactualfinishdate ,
    P.summaxrestartdate summaxrestartdate ,
    P.sumactuallaborcost sumactuallaborcost ,
    P.sumactuallaborunits sumactuallaborunits ,
    P.sumactualmaterialcost sumactualmaterialcost ,
    P.sumactualnonlaborcost sumactualnonlaborcost ,
    P.sumactualnonlaborunits sumactualnonlaborunits ,
    P.sumactualstartdate sumactualstartdate ,
    P.sumactualthisperiodcost sumactualthisperiodcost ,
    P.sumactualtotalcost sumactualtotalcost ,
    P.sumactualvaluebycost sumactualvaluebycost ,
    P.sumactualvaluebylaborunits sumactualvaluebylaborunits ,
    P.sumatcompletionduration sumatcompletionduration ,
    P.sumatcompletionexpensecost sumatcompletionexpensecost ,
    P.sumatcompletionlaborcost sumatcompletionlaborcost ,
    P.sumatcompletionlaborunits sumatcompletionlaborunits ,
    P.sumatcompletiontotalcost sumatcompletiontotalcost ,
    P.sumbaselineduration sumbaselineduration ,
    P.sumbaselineexpensecost sumbaselineexpensecost ,
    P.sumbaselinefinishdate sumbaselinefinishdate ,
    P.sumbaselinelaborcost sumbaselinelaborcost ,
    P.sumbaselinelaborunits sumbaselinelaborunits ,
    P.sumbaselinematerialcost sumbaselinematerialcost ,
    P.sumbaselinenonlaborcost sumbaselinenonlaborcost ,
    P.sumbaselinenonlaborunits sumbaselinenonlaborunits ,
    P.sumbaselinestartdate sumbaselinestartdate ,
    P.sumbaselinetotalcost sumbaselinetotalcost ,
    P.sumcompletedactivitycount sumcompletedactivitycount ,
    P.sumcostpercentcomplete sumcostpercentcomplete ,
    P.sumcostpercentofplanned sumcostpercentofplanned ,
    P.sumcostvariancebycost sumcostvariancebycost ,
    P.sumcostvarianceindex sumcostvarianceindex ,
    P.sumcostvarianceindexbycost sumcostvarianceindexbycost ,
    P.sumdurationpercentcomplete sumdurationpercentcomplete ,
    P.sumdurationvariance sumdurationvariance ,
    P.sumearnedvaluebycost sumearnedvaluebycost ,
    P.sumearnedvaluebylaborunits sumearnedvaluebylaborunits ,
    P.sumexpensecostvariance sumexpensecostvariance ,
    P.sumfinishdatevariance sumfinishdatevariance ,
    P.suminprogressactivitycount suminprogressactivitycount ,
    P.sumlaborcostvariance sumlaborcostvariance ,
    P.sumlaborunitsvariance sumlaborunitsvariance ,
    P.summaterialcostvariance summaterialcostvariance ,
    P.sumnonlaborcostvariance sumnonlaborcostvariance ,
    P.sumnonlaborunitsvariance sumnonlaborunitsvariance ,
    P.sumnotstartedactivitycount sumnotstartedactivitycount ,
    P.sumplannedvaluebycost sumplannedvaluebycost ,
    P.sumprogressfinishdate sumprogressfinishdate ,
    P.sumremainingduration sumremainingduration ,
    P.sumremainingexpensecost sumremainingexpensecost ,
    P.sumremainingfinishdate sumremainingfinishdate ,
    P.sumremaininglaborcost sumremaininglaborcost ,
    P.sumremaininglaborunits sumremaininglaborunits ,
    P.sumremainingmaterialcost sumremainingmaterialcost ,
    P.sumremainingnonlaborcost sumremainingnonlaborcost ,
    P.sumremainingnonlaborunits sumremainingnonlaborunits ,
    P.sumremainingstartdate sumremainingstartdate ,
    P.sumremainingtotalcost sumremainingtotalcost ,
    P.sumschedulepercentcomplete sumschedulepercentcomplete ,
    P.sumperformancepercentcomplete sumperformancepercentcomplete ,
    P.sumschedulevariancebycost sumschedulevariancebycost ,
    P.sumschedulevarianceindex sumschedulevarianceindex ,
    P.sumstartdatevariance sumstartdatevariance ,
    P.sumtotalcostvariance sumtotalcostvariance ,
    P.sumtotalfloat sumtotalfloat ,
    P.sumunitspercentcomplete sumunitspercentcomplete ,
    P.summaterialcostpctcomplete summaterialcostpctcomplete ,
    P.sumnonlaborcostpctcomplete sumnonlaborcostpctcomplete ,
    P.sumnonlaborunitspctcomplete sumnonlaborunitspctcomplete ,
    P.sumperfpctcmpbylaborunits sumperfpctcmpbylaborunits ,
    P.sumplannedvaluebylaborunits sumplannedvaluebylaborunits ,
    P.sumschdpctcmpbylaborunits sumschdpctcmpbylaborunits ,
    P.sumschdperfindexbylaborunits sumschdperfindexbylaborunits ,
    P.sumschdvariancebylaborunits sumschdvariancebylaborunits ,
    P.sumschdvarianceindexbycost sumschdvarianceindexbycost ,
    P.sumschdvarindexbylaborunits sumschdvarindexbylaborunits ,
    P.sumscheduleperfindexbycost sumscheduleperfindexbycost ,
    P.sumtocompleteperfindexbycost sumtocompleteperfindexbycost ,
    P.sumvaratcmpbylaborunits sumvaratcmpbylaborunits ,
    P.sumearlystartdate sumearlystartdate ,
    P.sumearlyenddate sumearlyenddate ,
    P.sumlatestartdate sumlatestartdate ,
    P.sumlateenddate sumlateenddate ,
    P.summaxcalendarid summaxcalendarid ,
    P.summincalendarid summincalendarid ,
    P.totalbenefitplan totalbenefitplan ,
    P.totalbenefitplantally totalbenefitplantally ,
    P.totalspendingplan totalspendingplan ,
    P.totalspendingplantally totalspendingplantally ,
    P.unallocatedbudget unallocatedbudget ,
    P.undistributedcurrentvariance undistributedcurrentvariance ,
    a.status_reviewer statusreviewerobjectid ,
    P.statusreviewername statusreviewername ,
    a.update_user lastupdateuser ,
    a.update_date lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate ,
    P.update_dim_date lastupdatedatex ,
    CASE
      WHEN a.update_date>P.update_date
      THEN 'N'
      ELSE 'Y'
    END rpt_current_flag ,
    A.proj_node_flag
   FROM ${pm.or.administrative_user}.PROJWBS A
  INNER JOIN ${pm.or.administrative_user}.PROJWBSX P
  ON a.wbs_id = p.wbs_id
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab
  ON a.proj_id                   = projects_tab.proj_id
  WHERE A.DELETE_SESSION_ID     IS NULL
  AND upper(projects_tab.hist_level) in ('HL_TASK','HL_TASK_WK','HL_TASK_MN')
  AND projects_tab.PROJECT_FLAG = 'Y'
  AND projects_tab.ORIG_PROJ_ID IS NULL
  /
 
--METADATA NAME:REFRDELETE_SC TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE  
CREATE OR REPLACE VIEW REFRDELETE_SC(LASTUPDATEDATE, TABLENAME, OBJECTID, OBJECTID2, OBJECTID3, OBJECTID4, PROJECTOBJECTID)
AS
  SELECT a.DELETE_DATE,
    a.TABLE_NAME,
    a.PK1,
    a.PK2,
    a.PK3,
    a.PK4,
    a.PROJ_ID
  FROM ${pm.or.administrative_user}.REFRDEL a
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab ON a.proj_id = projects_tab.proj_id AND upper(projects_tab.hist_level) in ('HL_TASK','HL_TASK_WK','HL_TASK_MN')  AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  /

--METADATA NAME:COSTACCOUNT_SC TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE   
CREATE OR REPLACE VIEW COSTACCOUNT_SC (OBJECTID, SEQUENCENUMBER, ID, NAME, PARENTOBJECTID, DESCRIPTION, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE)
AS
  SELECT a.acct_id objectid ,
    a.acct_seq_num sequencenumber ,
    a.acct_short_name id ,
    a.acct_name name ,
    a.parent_acct_id parentobjectid ,
    a.acct_descr description ,
    a.update_user lastupdateuser ,
    a.update_date lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate
   FROM ${pm.or.administrative_user}.ACCOUNT A
  WHERE A.DELETE_SESSION_ID IS NULL
  /
  
--METADATA NAME:EPS_SC TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE   
CREATE OR REPLACE VIEW EPS_SC (OBJECTID, PROJECTOBJECTID, OBSOBJECTID, SEQUENCENUMBER, NAME, PARENTOBJECTID, ORIGINALBUDGET, INDEPENDENTETCTOTALCOST, INDEPENDENTETCLABORUNITS, ANTICIPATEDSTARTDATE, ANTICIPATEDFINISHDATE, CURRENTBUDGET, CURRENTVARIANCE, DISTRIBUTEDCURRENTBUDGET, FINISHDATE, FULLNAME, ID, LASTSUMMARIZEDDATE, OBSNAME, PLANNEDSTARTDATE, PROPOSEDBUDGET, STARTDATE, SUMPLANNEDSTARTDATE, SUMPLANNEDFINISHDATE, SUMPLANNEDDURATION, SUMPLANNEDLABORUNITS, SUMPLANNEDNONLABORUNITS, SUMPLANNEDEXPENSECOST, SUMPLANNEDLABORCOST, SUMPLANNEDMATERIALCOST, SUMPLANNEDNONLABORCOST, SUMPLANNEDTOTALCOST, SUMACCOUNTINGVARBYLABORUNITS, SUMACCOUNTINGVARIANCEBYCOST, SUMACTTHISPERIODMATERIALCOST, SUMACTTHISPERIODNONLABORCOST, SUMACTTHISPERIODNONLABORUNITS, SUMACTUALTHISPERIODLABORCOST, SUMACTUALTHISPERIODLABORUNITS, SUMATCOMPLETIONMATERIALCOST, SUMATCOMPLETIONNONLABORCOST,
  SUMATCOMPLETIONNONLABORUNITS, SUMATCOMPLETIONTOTALCOSTVAR, SUMBASELINECOMPACTIVITYCOUNT, SUMBASELINENOTSTARTEDACTCNT, SUMBLINPROGRESSACTIVITYCOUNT, SUMBUDGETATCMPBYLABORUNITS, SUMBUDGETATCOMPLETIONBYCOST, SUMCOSTPERFINDEXBYCOST, SUMCOSTPERFINDEXBYLABORUNITS, SUMCOSTVARIANCEBYLABORUNITS, SUMCOSTVARINDEXBYLABORUNITS, SUMDURATIONPERCENTOFPLANNED, SUMEACBYCOST, SUMEACBYLABORUNITS, SUMEACHIGHPCTBYLABORUNITS, SUMEACLOWPCTBYLABORUNITS, SUMETCBYCOST, SUMETCBYLABORUNITS, SUMEXPENSECOSTPCTCOMPLETE, SUMLABORCOSTPERCENTCOMPLETE, SUMLABORUNITSPERCENTCOMPLETE, SUMACTIVITYCOUNT, SUMACTUALDURATION, SUMACTUALEXPENSECOST, SUMACTUALFINISHDATE, SUMACTUALLABORCOST, SUMACTUALLABORUNITS, SUMACTUALMATERIALCOST, SUMACTUALNONLABORCOST, SUMACTUALNONLABORUNITS, SUMACTUALSTARTDATE, SUMACTUALTHISPERIODCOST, SUMACTUALTOTALCOST, SUMACTUALVALUEBYCOST, SUMACTUALVALUEBYLABORUNITS, SUMATCOMPLETIONDURATION, SUMATCOMPLETIONEXPENSECOST,
  SUMATCOMPLETIONLABORCOST, SUMATCOMPLETIONLABORUNITS, SUMATCOMPLETIONTOTALCOST, SUMBASELINEDURATION, SUMBASELINEEXPENSECOST, SUMBASELINEFINISHDATE, SUMBASELINELABORCOST, SUMBASELINELABORUNITS, SUMBASELINEMATERIALCOST, SUMBASELINENONLABORCOST, SUMBASELINENONLABORUNITS, SUMBASELINESTARTDATE, SUMBASELINETOTALCOST, SUMCOMPLETEDACTIVITYCOUNT, SUMCOSTPERCENTCOMPLETE, SUMCOSTPERCENTOFPLANNED, SUMCOSTVARIANCEBYCOST, SUMCOSTVARIANCEINDEX, SUMCOSTVARIANCEINDEXBYCOST, SUMDURATIONPERCENTCOMPLETE, SUMDURATIONVARIANCE, SUMEARNEDVALUEBYCOST, SUMEARNEDVALUEBYLABORUNITS, SUMEXPENSECOSTVARIANCE, SUMFINISHDATEVARIANCE, SUMINPROGRESSACTIVITYCOUNT, SUMLABORCOSTVARIANCE, SUMLABORUNITSVARIANCE, SUMMATERIALCOSTVARIANCE, SUMNONLABORCOSTVARIANCE, SUMNONLABORUNITSVARIANCE, SUMNOTSTARTEDACTIVITYCOUNT, SUMPLANNEDVALUEBYCOST, SUMPROGRESSFINISHDATE, SUMREMAININGDURATION, SUMREMAININGEXPENSECOST, SUMREMAININGFINISHDATE,
  SUMREMAININGLABORCOST, SUMREMAININGLABORUNITS, SUMREMAININGMATERIALCOST, SUMREMAININGNONLABORCOST, SUMREMAININGNONLABORUNITS, SUMREMAININGSTARTDATE, SUMREMAININGTOTALCOST, SUMSCHEDULEPERCENTCOMPLETE, SUMPERFORMANCEPERCENTCOMPLETE, SUMSCHEDULEVARIANCEBYCOST, SUMSCHEDULEVARIANCEINDEX, SUMSTARTDATEVARIANCE, SUMTOTALCOSTVARIANCE, SUMTOTALFLOAT, SUMUNITSPERCENTCOMPLETE, SUMMATERIALCOSTPCTCOMPLETE, SUMNONLABORCOSTPCTCOMPLETE, SUMNONLABORUNITSPCTCOMPLETE, SUMPERFPCTCMPBYLABORUNITS, SUMPLANNEDVALUEBYLABORUNITS, SUMSCHDPCTCMPBYLABORUNITS, SUMSCHDPERFINDEXBYLABORUNITS, SUMSCHDVARIANCEBYLABORUNITS, SUMSCHDVARIANCEINDEXBYCOST, SUMSCHDVARINDEXBYLABORUNITS, SUMSCHEDULEPERFINDEXBYCOST, SUMTOCOMPLETEPERFINDEXBYCOST, SUMVARATCMPBYLABORUNITS, TOTALBENEFITPLAN, TOTALBENEFITPLANTALLY, TOTALFUNDING, TOTALSPENDINGPLAN, TOTALSPENDINGPLANTALLY, UNALLOCATEDBUDGET, UNDISTRIBUTEDCURRENTVARIANCE, LASTUPDATEUSER, LASTUPDATEDATE,
  CREATEUSER, CREATEDATE, LASTUPDATEDATEX)
AS
  SELECT a.wbs_id objectid ,
    a.proj_id projectobjectid ,
    a.obs_id obsobjectid ,
    a.seq_num sequencenumber ,
    a.wbs_name name ,
    a.parent_wbs_id parentobjectid ,
    a.orig_cost originalbudget ,
    a.indep_remain_total_cost independentetctotalcost ,
    a.indep_remain_work_qty independentetclaborunits ,
    a.anticip_start_date anticipatedstartdate ,
    a.anticip_end_date anticipatedfinishdate ,
    P.currentbudget currentbudget ,
    P.currentvariance currentvariance ,
    P.distributedcurrentbudget distributedcurrentbudget ,
    P.finishdate finishdate ,
    P.fullname fullname ,
    P.id id ,
    P.lastsummarizeddate lastsummarizeddate ,
    P.obsname obsname ,
    P.plannedstartdate plannedstartdate ,
    P.proposedbudget proposedbudget ,
    P.startdate startdate ,
    P.sumplannedstartdate sumplannedstartdate ,
    P.sumplannedfinishdate sumplannedfinishdate ,
    P.sumplannedduration sumplannedduration ,
    P.sumplannedlaborunits sumplannedlaborunits ,
    P.sumplannednonlaborunits sumplannednonlaborunits ,
    P.sumplannedexpensecost sumplannedexpensecost ,
    P.sumplannedlaborcost sumplannedlaborcost ,
    P.sumplannedmaterialcost sumplannedmaterialcost ,
    P.sumplannednonlaborcost sumplannednonlaborcost ,
    P.sumplannedtotalcost sumplannedtotalcost ,
    P.sumaccountingvarbylaborunits sumaccountingvarbylaborunits ,
    P.sumaccountingvariancebycost sumaccountingvariancebycost ,
    P.sumactthisperiodmaterialcost sumactthisperiodmaterialcost ,
    P.sumactthisperiodnonlaborcost sumactthisperiodnonlaborcost ,
    P.sumactthisperiodnonlaborunits sumactthisperiodnonlaborunits ,
    P.sumactualthisperiodlaborcost sumactualthisperiodlaborcost ,
    P.sumactualthisperiodlaborunits sumactualthisperiodlaborunits ,
    P.sumatcompletionmaterialcost sumatcompletionmaterialcost ,
    P.sumatcompletionnonlaborcost sumatcompletionnonlaborcost ,
    P.sumatcompletionnonlaborunits sumatcompletionnonlaborunits ,
    P.sumatcompletiontotalcostvar sumatcompletiontotalcostvar ,
    P.sumbaselinecompactivitycount sumbaselinecompactivitycount ,
    P.sumbaselinenotstartedactcnt sumbaselinenotstartedactcnt ,
    P.sumblinprogressactivitycount sumblinprogressactivitycount ,
    P.sumbudgetatcmpbylaborunits sumbudgetatcmpbylaborunits ,
    P.sumbudgetatcompletionbycost sumbudgetatcompletionbycost ,
    P.sumcostperfindexbycost sumcostperfindexbycost ,
    P.sumcostperfindexbylaborunits sumcostperfindexbylaborunits ,
    P.sumcostvariancebylaborunits sumcostvariancebylaborunits ,
    P.sumcostvarindexbylaborunits sumcostvarindexbylaborunits ,
    P.sumdurationpercentofplanned sumdurationpercentofplanned ,
    P.sumeacbycost sumeacbycost ,
    P.sumeacbylaborunits sumeacbylaborunits ,
    P.sumeachighpctbylaborunits sumeachighpctbylaborunits ,
    P.sumeaclowpctbylaborunits sumeaclowpctbylaborunits ,
    P.sumetcbycost sumetcbycost ,
    P.sumetcbylaborunits sumetcbylaborunits ,
    P.sumexpensecostpctcomplete sumexpensecostpctcomplete ,
    P.sumlaborcostpercentcomplete sumlaborcostpercentcomplete ,
    P.sumlaborunitspercentcomplete sumlaborunitspercentcomplete ,
    P.sumactivitycount sumactivitycount ,
    P.sumactualduration sumactualduration ,
    P.sumactualexpensecost sumactualexpensecost ,
    P.sumactualfinishdate sumactualfinishdate ,
    P.sumactuallaborcost sumactuallaborcost ,
    P.sumactuallaborunits sumactuallaborunits ,
    P.sumactualmaterialcost sumactualmaterialcost ,
    P.sumactualnonlaborcost sumactualnonlaborcost ,
    P.sumactualnonlaborunits sumactualnonlaborunits ,
    P.sumactualstartdate sumactualstartdate ,
    P.sumactualthisperiodcost sumactualthisperiodcost ,
    P.sumactualtotalcost sumactualtotalcost ,
    P.sumactualvaluebycost sumactualvaluebycost ,
    P.sumactualvaluebylaborunits sumactualvaluebylaborunits ,
    P.sumatcompletionduration sumatcompletionduration ,
    P.sumatcompletionexpensecost sumatcompletionexpensecost ,
    P.sumatcompletionlaborcost sumatcompletionlaborcost ,
    P.sumatcompletionlaborunits sumatcompletionlaborunits ,
    P.sumatcompletiontotalcost sumatcompletiontotalcost ,
    P.sumbaselineduration sumbaselineduration ,
    P.sumbaselineexpensecost sumbaselineexpensecost ,
    P.sumbaselinefinishdate sumbaselinefinishdate ,
    P.sumbaselinelaborcost sumbaselinelaborcost ,
    P.sumbaselinelaborunits sumbaselinelaborunits ,
    P.sumbaselinematerialcost sumbaselinematerialcost ,
    P.sumbaselinenonlaborcost sumbaselinenonlaborcost ,
    P.sumbaselinenonlaborunits sumbaselinenonlaborunits ,
    P.sumbaselinestartdate sumbaselinestartdate ,
    P.sumbaselinetotalcost sumbaselinetotalcost ,
    P.sumcompletedactivitycount sumcompletedactivitycount ,
    P.sumcostpercentcomplete sumcostpercentcomplete ,
    P.sumcostpercentofplanned sumcostpercentofplanned ,
    P.sumcostvariancebycost sumcostvariancebycost ,
    P.sumcostvarianceindex sumcostvarianceindex ,
    P.sumcostvarianceindexbycost sumcostvarianceindexbycost ,
    P.sumdurationpercentcomplete sumdurationpercentcomplete ,
    P.sumdurationvariance sumdurationvariance ,
    P.sumearnedvaluebycost sumearnedvaluebycost ,
    P.sumearnedvaluebylaborunits sumearnedvaluebylaborunits ,
    P.sumexpensecostvariance sumexpensecostvariance ,
    P.sumfinishdatevariance sumfinishdatevariance ,
    P.suminprogressactivitycount suminprogressactivitycount ,
    P.sumlaborcostvariance sumlaborcostvariance ,
    P.sumlaborunitsvariance sumlaborunitsvariance ,
    P.summaterialcostvariance summaterialcostvariance ,
    P.sumnonlaborcostvariance sumnonlaborcostvariance ,
    P.sumnonlaborunitsvariance sumnonlaborunitsvariance ,
    P.sumnotstartedactivitycount sumnotstartedactivitycount ,
    P.sumplannedvaluebycost sumplannedvaluebycost ,
    P.sumprogressfinishdate sumprogressfinishdate ,
    P.sumremainingduration sumremainingduration ,
    P.sumremainingexpensecost sumremainingexpensecost ,
    P.sumremainingfinishdate sumremainingfinishdate ,
    P.sumremaininglaborcost sumremaininglaborcost ,
    P.sumremaininglaborunits sumremaininglaborunits ,
    P.sumremainingmaterialcost sumremainingmaterialcost ,
    P.sumremainingnonlaborcost sumremainingnonlaborcost ,
    P.sumremainingnonlaborunits sumremainingnonlaborunits ,
    P.sumremainingstartdate sumremainingstartdate ,
    P.sumremainingtotalcost sumremainingtotalcost ,
    P.sumschedulepercentcomplete sumschedulepercentcomplete ,
    P.sumperformancepercentcomplete sumperformancepercentcomplete ,
    P.sumschedulevariancebycost sumschedulevariancebycost ,
    P.sumschedulevarianceindex sumschedulevarianceindex ,
    P.sumstartdatevariance sumstartdatevariance ,
    P.sumtotalcostvariance sumtotalcostvariance ,
    P.sumtotalfloat sumtotalfloat ,
    P.sumunitspercentcomplete sumunitspercentcomplete ,
    P.summaterialcostpctcomplete summaterialcostpctcomplete ,
    P.sumnonlaborcostpctcomplete sumnonlaborcostpctcomplete ,
    P.sumnonlaborunitspctcomplete sumnonlaborunitspctcomplete ,
    P.sumperfpctcmpbylaborunits sumperfpctcmpbylaborunits ,
    P.sumplannedvaluebylaborunits sumplannedvaluebylaborunits ,
    P.sumschdpctcmpbylaborunits sumschdpctcmpbylaborunits ,
    P.sumschdperfindexbylaborunits sumschdperfindexbylaborunits ,
    P.sumschdvariancebylaborunits sumschdvariancebylaborunits ,
    P.sumschdvarianceindexbycost sumschdvarianceindexbycost ,
    P.sumschdvarindexbylaborunits sumschdvarindexbylaborunits ,
    P.sumscheduleperfindexbycost sumscheduleperfindexbycost ,
    P.sumtocompleteperfindexbycost sumtocompleteperfindexbycost ,
    P.sumvaratcmpbylaborunits sumvaratcmpbylaborunits ,
    P.totalbenefitplan totalbenefitplan ,
    P.totalbenefitplantally totalbenefitplantally ,
    P.totalfunding totalfunding ,
    P.totalspendingplan totalspendingplan ,
    P.totalspendingplantally totalspendingplantally ,
    P.unallocatedbudget unallocatedbudget ,
    P.undistributedcurrentvariance undistributedcurrentvariance ,
    a.update_user lastupdateuser ,
    CASE
      WHEN a.update_date > P.update_date
      THEN a.update_date
      ELSE P.update_date
    END lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate ,
    P.update_dim_date lastupdatedatex
   FROM ${pm.or.administrative_user}.PROJWBS A
  INNER JOIN ${pm.or.administrative_user}.PROJWBSX P
  ON a.wbs_id = p.wbs_id
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab
  ON a.proj_id                  = projects_tab.proj_id
  AND projects_tab.PROJECT_FLAG = 'N'
  WHERE A.DELETE_SESSION_ID    IS NULL
  /
  
--METADATA NAME:OBS_SC TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE   
CREATE OR REPLACE VIEW OBS_SC (OBJECTID, SEQUENCENUMBER, NAME, PARENTOBJECTID, DESCRIPTION, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE)
AS
  SELECT a.obs_id objectid ,
    a.seq_num sequencenumber ,
    a.obs_name name ,
    a.parent_obs_id parentobjectid ,
    a.obs_descr description ,
    a.update_user lastupdateuser ,
    a.update_date lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate
   FROM ${pm.or.administrative_user}.OBS A
  WHERE A.DELETE_SESSION_ID IS NULL
  /
  
--METADATA NAME:RESOURCES_SC TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE  
CREATE OR REPLACE VIEW RESOURCES_SC (OBJECTID, CALENDAROBJECTID, SEQUENCENUMBER, USETIMESHEETS, ISACTIVE, RESOURCETYPE, AUTOCOMPUTEACTUALS, ISOVERTIMEALLOWED, CALCULATECOSTFROMUNITS, ID, NAME, PARENTOBJECTID, TIMESHEETAPPROVALMGROBJECTID, USEROBJECTID, PRIMARYROLEOBJECTID, CURRENCYOBJECTID, SHIFTOBJECTID, OVERTIMEFACTOR, DEFAULTUNITSPERTIME, OFFICEPHONE, OTHERPHONE, EMPLOYEEID, TITLE, EMAILADDRESS, UNITOFMEASUREOBJECTID, RESOURCENOTES, CALENDARNAME, CURRENCYID, CURRENCYNAME, PRIMARYROLEID, PRIMARYROLENAME, TIMESHEETAPPROVALMANAGER, USERNAME, LOCATIONOBJECTID, LOCATIONNAME, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE, LASTUPDATEDATEX)
AS
  SELECT a.rsrc_id objectid ,
    a.clndr_id calendarobjectid ,
    a.rsrc_seq_num sequencenumber ,
    a.timesheet_flag usetimesheets ,
    a.active_flag isactive ,
    CASE a.rsrc_type
      WHEN 'RT_Labor'
      THEN 'Labor'
      WHEN 'RT_Equip'
      THEN 'Nonlabor'
      WHEN 'RT_Mat'
      THEN 'Material'
      ELSE a.rsrc_type
    END resourcetype ,
    a.auto_compute_act_flag autocomputeactuals ,
    a.ot_flag isovertimeallowed ,
    a.def_cost_qty_link_flag calculatecostfromunits ,
    a.rsrc_short_name id ,
    a.rsrc_name name ,
    a.parent_rsrc_id parentobjectid ,
    a.ts_approve_user_id timesheetapprovalmgrobjectid ,
    a.user_id userobjectid ,
    a.role_id primaryroleobjectid ,
    a.curr_id currencyobjectid ,
    a.shift_id shiftobjectid ,
    a.ot_factor overtimefactor ,
    a.def_qty_per_hr defaultunitspertime ,
    a.office_phone officephone ,
    a.other_phone otherphone ,
    a.employee_code employeeid ,
    a.rsrc_title_name title ,
    a.email_addr emailaddress ,
    a.unit_id unitofmeasureobjectid ,
    a.rsrc_notes resourcenotes ,
    P.calendarname calendarname ,
    P.currencyid currencyid ,
    P.currencyname currencyname ,
    P.primaryroleid primaryroleid ,
    P.primaryrolename primaryrolename ,
    P.timesheetapprovalmanager timesheetapprovalmanager ,
    P.username username ,
    a.location_id locationobjectid ,
    P.locationname locationname ,
    a.update_user lastupdateuser ,
    a.update_date lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate ,
    P.update_date lastupdatedatex
   FROM ${pm.or.administrative_user}.RSRC A
  INNER JOIN ${pm.or.administrative_user}.RSRCX P
  ON a.rsrc_id = p.rsrc_id
  WHERE A.DELETE_SESSION_ID IS NULL
  /
  
--METADATA NAME:ROLE_SC TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE 
CREATE OR REPLACE VIEW ROLE_SC (OBJECTID, ID, NAME, SEQUENCENUMBER, PARENTOBJECTID, CALCULATECOSTFROMUNITS, RESPONSIBILITIES, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE)
AS
  SELECT a.role_id objectid ,
    a.role_short_name id ,
    a.role_name name ,
    a.seq_num sequencenumber ,
    a.parent_role_id parentobjectid ,
    a.def_cost_qty_link_flag calculatecostfromunits ,
    a.role_descr responsibilities ,
    a.update_user lastupdateuser ,
    a.update_date lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate
   FROM ${pm.or.administrative_user}.ROLES A
  WHERE A.DELETE_SESSION_ID IS NULL
  /
  
--METADATA NAME:RESASSIGNMENTPERIODACTUAL_SC TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE 
CREATE OR REPLACE VIEW RESASSIGNMENTPERIODACTUAL_SC (FINANCIALPERIODOBJECTID, STARTDATE, ENDDATE, RESOURCEASSIGNMENTOBJECTID, ACTIVITYOBJECTID, PROJECTOBJECTID, ACTUALUNITS, ACTUALCOST, RESOURCETYPE, WBSOBJECTID, RESOURCEOBJECTID, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE) AS 
SELECT a.fin_dates_id financialperiodobjectid
,fd.start_date startdate
,fd.end_date enddate
,a.taskrsrc_id resourceassignmentobjectid
,a.task_id activityobjectid
,a.proj_id projectobjectid
,a.act_qty actualunits
,a.act_cost actualcost
,P.resourcetype resourcetype
,P.wbsobjectid wbsobjectid
,T.rsrc_id resourceobjectid
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.TRSRCFIN A 
INNER JOIN ${pm.or.administrative_user}.TRSRCFINX P
ON a.fin_dates_id = p.fin_dates_id and a.taskrsrc_id = p.taskrsrc_id
INNER JOIN ${pm.or.administrative_user}.taskrsrc T
ON a.taskrsrc_id = T.taskrsrc_id and a.proj_id = t.proj_id 
INNER JOIN ${pm.or.administrative_user}.FINDATES FD
ON a.fin_dates_id = fd.fin_dates_id 
INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab on a.proj_id = projects_tab.proj_id AND upper(projects_tab.hist_level) in('HL_TASK','HL_TASK_WK','HL_TASK_MN') AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
WHERE A.DELETE_SESSION_ID is null
/

--METADATA NAME:ACTIVITYPERIODACTUAL_SC TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE 
CREATE OR REPLACE VIEW ACTIVITYPERIODACTUAL_SC (FINANCIALPERIODOBJECTID, STARTDATE, ENDDATE, ACTIVITYOBJECTID, PROJECTOBJECTID, ACTUALLABORUNITS, ACTUALLABORCOST, ACTUALNONLABORUNITS, ACTUALNONLABORCOST, ACTUALMATERIALCOST, ACTUALEXPENSECOST, EARNEDVALUECOST, PLANNEDVALUELABORUNITS, PLANNEDVALUECOST, EARNEDVALUELABORUNITS, WBSOBJECTID, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE) AS 
SELECT a.fin_dates_id financialperiodobjectid
,fd.start_date startdate
,fd.end_date enddate
,a.task_id activityobjectid
,a.proj_id projectobjectid
,a.act_work_qty actuallaborunits
,a.act_work_cost actuallaborcost
,a.act_equip_qty actualnonlaborunits
,a.act_equip_cost actualnonlaborcost
,a.act_mat_cost actualmaterialcost
,a.act_expense_cost actualexpensecost
,a.bcwp earnedvaluecost
,a.sched_work_qty plannedvaluelaborunits
,a.bcws plannedvaluecost
,a.perfm_work_qty earnedvaluelaborunits
,P.wbsobjectid wbsobjectid
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.TASKFIN A 
INNER JOIN ${pm.or.administrative_user}.TASKFINX P
ON a.fin_dates_id = p.fin_dates_id and a.task_id = p.task_id
INNER JOIN ${pm.or.administrative_user}.FINDATES FD
ON a.fin_dates_id = fd.fin_dates_id 
INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab on a.proj_id = projects_tab.proj_id AND upper(projects_tab.hist_level) in('HL_TASK','HL_TASK_WK','HL_TASK_MN') AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
WHERE A.DELETE_SESSION_ID is null
/
--METADATA NAME:ACTIVITY_GE TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITY_GE(OBJECTID, PROJECTOBJECTID, WBSOBJECTID, CALENDAROBJECTID, ISNEWFEEDBACK, AUTOCOMPUTEACTUALS, PERCENTCOMPLETETYPE, TYPE, DURATIONTYPE, REVIEWSTATUS, STATUS, ID, NAME, PRIMARYRESOURCEOBJECTID, TOTALFLOAT, FREEFLOAT, REMAININGDURATION, ACTUALLABORUNITS, REMAININGLABORUNITS, PLANNEDLABORUNITS, PLANNEDDURATION, PLANNEDNONLABORUNITS, ACTUALNONLABORUNITS, REMAININGNONLABORUNITS, PRIMARYCONSTRAINTDATE, ACTUALSTARTDATE, ACTUALFINISHDATE, LATESTARTDATE, LATEFINISHDATE, EXPECTEDFINISHDATE, EARLYSTARTDATE, EARLYFINISHDATE, REMAININGEARLYSTARTDATE, REMAININGEARLYFINISHDATE, PLANNEDSTARTDATE, PLANNEDFINISHDATE, REVIEWFINISHDATE, REMAININGLATESTARTDATE, REMAININGLATEFINISHDATE, PRIMARYCONSTRAINTTYPE, LEVELINGPRIORITY, SECONDARYCONSTRAINTDATE, SECONDARYCONSTRAINTTYPE, FLOATPATH, FLOATPATHORDER, ACTUALTHISPERIODLABORUNITS,
  ACTUALTHISPERIODNONLABORUNITS, ISLONGESTPATH, SUSPENDDATE, RESUMEDATE, EXTERNALEARLYSTARTDATE, EXTERNALLATEFINISHDATE, ACCOUNTINGVARIANCE, ACCOUNTINGVARIANCELABORUNITS, ACTUALDURATION, ACTUALEXPENSECOST, ACTUALLABORCOST, ACTUALMATERIALCOST, ACTUALNONLABORCOST, ACTUALTHISPERIODLABORCOST, ACTUALTHISPERIODMATERIALCOST, ACTUALTHISPERIODNONLABORCOST, ACTUALTOTALCOST, ACTUALTOTALUNITS, ATCOMPLETIONDURATION, ATCOMPLETIONEXPENSECOST, ATCOMPLETIONLABORCOST, ATCOMPLETIONLABORUNITS, ATCOMPLETIONLABORUNITSVARIANCE, ATCOMPLETIONMATERIALCOST, ATCOMPLETIONNONLABORCOST, ATCOMPLETIONNONLABORUNITS, ATCOMPLETIONTOTALCOST, ATCOMPLETIONTOTALUNITS, ATCOMPLETIONVARIANCE, BASELINEDURATION, BASELINEFINISHDATE, BASELINEPLANNEDDURATION, BASELINEPLANNEDEXPENSECOST, BASELINEPLANNEDLABORCOST, BASELINEPLANNEDLABORUNITS, BASELINEPLANNEDMATERIALCOST, BASELINEPLANNEDNONLABORCOST, BASELINEPLANNEDNONLABORUNITS, BASELINEPLANNEDTOTALCOST,
  BASELINESTARTDATE, BUDGETATCOMPLETION, CALENDARNAME, COSTPERCENTCOMPLETE, COSTPERCENTOFPLANNED, COSTPERFORMANCEINDEX, COSTPERFORMANCEINDEXLABORUNITS, COSTVARIANCE, COSTVARIANCEINDEX, COSTVARIANCEINDEXLABORUNITS, COSTVARIANCELABORUNITS, DATADATE, DURATION1VARIANCE, DURATIONPERCENTCOMPLETE, DURATIONPERCENTOFPLANNED, DURATIONVARIANCE, EARNEDVALUECOST, EARNEDVALUELABORUNITS, ESTIMATEATCOMPLETIONCOST, ESTIMATEATCOMPLETIONLABORUNITS, ESTIMATETOCOMPLETE, ESTIMATETOCOMPLETELABORUNITS, EXPENSECOST1VARIANCE, EXPENSECOSTPERCENTCOMPLETE, EXPENSECOSTVARIANCE, FINISHDATE, FINISHDATE1VARIANCE, FINISHDATEVARIANCE, ISCRITICAL, LABORCOST1VARIANCE, LABORCOSTPERCENTCOMPLETE, LABORCOSTVARIANCE, LABORUNITS1VARIANCE, LABORUNITSPERCENTCOMPLETE, LABORUNITSVARIANCE, MATERIALCOST1VARIANCE, MATERIALCOSTPERCENTCOMPLETE, MATERIALCOSTVARIANCE, NONLABORCOST1VARIANCE, NONLABORCOSTPERCENTCOMPLETE, NONLABORCOSTVARIANCE,
  NONLABORUNITS1VARIANCE, NONLABORUNITSPERCENTCOMPLETE, NONLABORUNITSVARIANCE, PERCENTCOMPLETE, PERFORMANCEPERCENTCOMPLETE, PHYSICALPERCENTCOMPLETE, PLANNEDEXPENSECOST, PLANNEDLABORCOST, PLANNEDMATERIALCOST, PLANNEDNONLABORCOST, PLANNEDTOTALCOST, PLANNEDTOTALUNITS, PLANNEDVALUECOST, PLANNEDVALUELABORUNITS, PRIMARYRESOURCEID, PRIMARYRESOURCENAME, REMAININGEXPENSECOST, REMAININGFLOAT, REMAININGLABORCOST, REMAININGMATERIALCOST, REMAININGNONLABORCOST, REMAININGTOTALCOST, REMAININGTOTALUNITS, SCHEDULEPERCENTCOMPLETE, SCHEDULEPERFINDEXLABORUNITS, SCHEDULEPERFORMANCEINDEX, SCHEDULEVARIANCE, SCHEDULEVARIANCEINDEX, SCHEDULEVARIANCELABORUNITS, SCHEDULEVARINDEXLABORUNITS, STARTDATE, STARTDATE1VARIANCE, STARTDATEVARIANCE, TOCOMPLETEPERFORMANCEINDEX, TOTALCOST1VARIANCE, TOTALCOSTVARIANCE, UNITSPERCENTCOMPLETE, WBSCODE, WBSNAME, LOCATIONOBJECTID, LOCATIONNAME, REVIEWREQUIRED, ISSTARRED, CBSCODE,
  LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE, LASTUPDATEDATEX, ACTIVITYOWNEROBJECTID, ACTIVITYOWNER, RPT_CURRENT_FLAG)
AS
  SELECT a.task_id objectid ,
    a.proj_id projectobjectid ,
    a.wbs_id wbsobjectid ,
    a.clndr_id calendarobjectid ,
    a.rev_fdbk_flag isnewfeedback ,
    a.auto_compute_act_flag autocomputeactuals ,
    CASE a.complete_pct_type
      WHEN 'CP_Phys'
      THEN 'Physical'
      WHEN 'CP_Drtn'
      THEN 'Duration'
      WHEN 'CP_Units'
      THEN 'Units'
      ELSE a.complete_pct_type
    END percentcompletetype ,
    CASE a.task_type
      WHEN 'TT_Task'
      THEN 'Task Dependent'
      WHEN 'TT_Rsrc'
      THEN 'Resource Dependent'
      WHEN 'TT_LOE'
      THEN 'Level Of Effort'
      WHEN 'TT_Mile'
      THEN 'Start Milestone'
      WHEN 'TT_FinMile'
      THEN 'Finish Milestone'
      WHEN 'TT_WBS'
      THEN 'WBS Summary'
      ELSE a.task_type
    END type ,
    CASE a.duration_type
      WHEN 'DT_FixedRate'
      THEN 'Fixed Units/Time'
      WHEN 'DT_FixedDrtn'
      THEN 'Fixed Duration and Units/Time'
      WHEN 'DT_FixedQty'
      THEN 'Fixed Units'
      WHEN 'DT_FixedDUR2'
      THEN 'Fixed Duration and Units'
      ELSE a.duration_type
    END durationtype ,
    CASE a.review_type
      WHEN 'RV_OK'
      THEN 'OK'
      WHEN 'RV_Review'
      THEN 'For Review'
      WHEN 'RV_Reject'
      THEN 'Rejected'
      ELSE a.review_type
    END reviewstatus ,
    CASE a.status_code
      WHEN 'TK_NotStart'
      THEN 'Not Started'
      WHEN 'TK_Active'
      THEN 'In Progress'
      WHEN 'TK_Complete'
      THEN 'Completed'
      ELSE a.status_code
    END status ,
    a.task_code id ,
    a.task_name name ,
    a.rsrc_id primaryresourceobjectid ,
    a.total_float_hr_cnt totalfloat ,
    a.free_float_hr_cnt freefloat ,
    a.remain_drtn_hr_cnt remainingduration ,
    a.act_work_qty actuallaborunits ,
    a.remain_work_qty remaininglaborunits ,
    a.target_work_qty plannedlaborunits ,
    a.target_drtn_hr_cnt plannedduration ,
    a.target_equip_qty plannednonlaborunits ,
    a.act_equip_qty actualnonlaborunits ,
    a.remain_equip_qty remainingnonlaborunits ,
    a.cstr_date primaryconstraintdate ,
    a.act_start_date actualstartdate ,
    a.act_end_date actualfinishdate ,
    a.late_start_date latestartdate ,
    a.late_end_date latefinishdate ,
    a.expect_end_date expectedfinishdate ,
    a.early_start_date earlystartdate ,
    a.early_end_date earlyfinishdate ,
    a.restart_date remainingearlystartdate ,
    a.reend_date remainingearlyfinishdate ,
    a.target_start_date plannedstartdate ,
    a.target_end_date plannedfinishdate ,
    a.review_end_date reviewfinishdate ,
    a.rem_late_start_date remaininglatestartdate ,
    a.rem_late_end_date remaininglatefinishdate ,
    CASE a.cstr_type
      WHEN 'CS_MSO'
      THEN 'Start On'
      WHEN 'CS_MSOB'
      THEN 'Start On or Before'
      WHEN 'CS_MSOA'
      THEN 'Start On or After'
      WHEN 'CS_MEO'
      THEN 'Finish On'
      WHEN 'CS_MEOB'
      THEN 'Finish On or Before'
      WHEN 'CS_MEOA'
      THEN 'Finish On or After'
      WHEN 'CS_ALAP'
      THEN 'As Late As Possible'
      WHEN 'CS_MANDSTART'
      THEN 'Mandatory Start'
      WHEN 'CS_MANDFIN'
      THEN 'Mandatory Finish'
      ELSE a.cstr_type
    END primaryconstrainttype ,
    CASE a.priority_type
      WHEN 'PT_Top'
      THEN 'Top'
      WHEN 'PT_High'
      THEN 'High'
      WHEN 'PT_Normal'
      THEN 'Normal'
      WHEN 'PT_Low'
      THEN 'Low'
      WHEN 'PT_Lowest'
      THEN 'Lowest'
      ELSE a.priority_type
    END levelingpriority ,
    a.cstr_date2 secondaryconstraintdate ,
    CASE a.cstr_type2
      WHEN 'CS_MSO'
      THEN 'Start On'
      WHEN 'CS_MSOB'
      THEN 'Start On or Before'
      WHEN 'CS_MSOA'
      THEN 'Start On or After'
      WHEN 'CS_MEO'
      THEN 'Finish On'
      WHEN 'CS_MEOB'
      THEN 'Finish On or Before'
      WHEN 'CS_MEOA'
      THEN 'Finish On or After'
      WHEN 'CS_ALAP'
      THEN 'As Late As Possible'
      WHEN 'CS_MANDSTART'
      THEN 'Mandatory Start'
      WHEN 'CS_MANDFIN'
      THEN 'Mandatory Finish'
      ELSE a.cstr_type2
    END secondaryconstrainttype ,
    a.float_path floatpath ,
    a.float_path_order floatpathorder ,
    a.act_this_per_work_qty actualthisperiodlaborunits ,
    a.act_this_per_equip_qty actualthisperiodnonlaborunits ,
    a.driving_path_flag islongestpath ,
    a.suspend_date suspenddate ,
    a.resume_date resumedate ,
    a.external_early_start_date externalearlystartdate ,
    a.external_late_end_date externallatefinishdate ,
    P.accountingvariance accountingvariance ,
    P.accountingvariancelaborunits accountingvariancelaborunits ,
    P.actualduration actualduration ,
    P.actualexpensecost actualexpensecost ,
    P.actuallaborcost actuallaborcost ,
    P.actualmaterialcost actualmaterialcost ,
    P.actualnonlaborcost actualnonlaborcost ,
    P.actualthisperiodlaborcost actualthisperiodlaborcost ,
    P.actualthisperiodmaterialcost actualthisperiodmaterialcost ,
    P.actualthisperiodnonlaborcost actualthisperiodnonlaborcost ,
    P.actualtotalcost actualtotalcost ,
    P.actualtotalunits actualtotalunits ,
    P.atcompletionduration atcompletionduration ,
    P.atcompletionexpensecost atcompletionexpensecost ,
    P.atcompletionlaborcost atcompletionlaborcost ,
    P.atcompletionlaborunits atcompletionlaborunits ,
    P.atcompletionlaborunitsvariance atcompletionlaborunitsvariance ,
    P.atcompletionmaterialcost atcompletionmaterialcost ,
    P.atcompletionnonlaborcost atcompletionnonlaborcost ,
    P.atcompletionnonlaborunits atcompletionnonlaborunits ,
    P.atcompletiontotalcost atcompletiontotalcost ,
    P.atcompletiontotalunits atcompletiontotalunits ,
    P.atcompletionvariance atcompletionvariance ,
    P.baselineduration baselineduration ,
    P.baselinefinishdate baselinefinishdate ,
    P.baselineplannedduration baselineplannedduration ,
    P.baselineplannedexpensecost baselineplannedexpensecost ,
    P.baselineplannedlaborcost baselineplannedlaborcost ,
    P.baselineplannedlaborunits baselineplannedlaborunits ,
    P.baselineplannedmaterialcost baselineplannedmaterialcost ,
    P.baselineplannednonlaborcost baselineplannednonlaborcost ,
    P.baselineplannednonlaborunits baselineplannednonlaborunits ,
    P.baselineplannedtotalcost baselineplannedtotalcost ,
    P.baselinestartdate baselinestartdate ,
    P.budgetatcompletion budgetatcompletion ,
    P.calendarname calendarname ,
    P.costpercentcomplete costpercentcomplete ,
    P.costpercentofplanned costpercentofplanned ,
    P.costperformanceindex costperformanceindex ,
    P.costperformanceindexlaborunits costperformanceindexlaborunits ,
    P.costvariance costvariance ,
    P.costvarianceindex costvarianceindex ,
    P.costvarianceindexlaborunits costvarianceindexlaborunits ,
    P.costvariancelaborunits costvariancelaborunits ,
    P.datadate datadate ,
    P.duration1variance duration1variance ,
    P.durationpercentcomplete durationpercentcomplete ,
    P.durationpercentofplanned durationpercentofplanned ,
    P.durationvariance durationvariance ,
    P.earnedvaluecost earnedvaluecost ,
    P.earnedvaluelaborunits earnedvaluelaborunits ,
    P.estimateatcompletioncost estimateatcompletioncost ,
    P.estimateatcompletionlaborunits estimateatcompletionlaborunits ,
    P.estimatetocomplete estimatetocomplete ,
    P.estimatetocompletelaborunits estimatetocompletelaborunits ,
    P.expensecost1variance expensecost1variance ,
    P.expensecostpercentcomplete expensecostpercentcomplete ,
    P.expensecostvariance expensecostvariance ,
    P.finishdate finishdate ,
    P.finishdate1variance finishdate1variance ,
    P.finishdatevariance finishdatevariance ,
    P.iscritical iscritical ,
    P.laborcost1variance laborcost1variance ,
    P.laborcostpercentcomplete laborcostpercentcomplete ,
    P.laborcostvariance laborcostvariance ,
    P.laborunits1variance laborunits1variance ,
    P.laborunitspercentcomplete laborunitspercentcomplete ,
    P.laborunitsvariance laborunitsvariance ,
    P.materialcost1variance materialcost1variance ,
    P.materialcostpercentcomplete materialcostpercentcomplete ,
    P.materialcostvariance materialcostvariance ,
    P.nonlaborcost1variance nonlaborcost1variance ,
    P.nonlaborcostpercentcomplete nonlaborcostpercentcomplete ,
    P.nonlaborcostvariance nonlaborcostvariance ,
    P.nonlaborunits1variance nonlaborunits1variance ,
    P.nonlaborunitspercentcomplete nonlaborunitspercentcomplete ,
    P.nonlaborunitsvariance nonlaborunitsvariance ,
    P.percentcomplete percentcomplete ,
    P.performancepercentcomplete performancepercentcomplete ,
    P.physicalpercentcomplete physicalpercentcomplete ,
    P.plannedexpensecost plannedexpensecost ,
    P.plannedlaborcost plannedlaborcost ,
    P.plannedmaterialcost plannedmaterialcost ,
    P.plannednonlaborcost plannednonlaborcost ,
    P.plannedtotalcost plannedtotalcost ,
    P.plannedtotalunits plannedtotalunits ,
    P.plannedvaluecost plannedvaluecost ,
    P.plannedvaluelaborunits plannedvaluelaborunits ,
    P.primaryresourceid primaryresourceid ,
    P.primaryresourcename primaryresourcename ,
    P.remainingexpensecost remainingexpensecost ,
    P.remainingfloat remainingfloat ,
    P.remaininglaborcost remaininglaborcost ,
    P.remainingmaterialcost remainingmaterialcost ,
    P.remainingnonlaborcost remainingnonlaborcost ,
    P.remainingtotalcost remainingtotalcost ,
    P.remainingtotalunits remainingtotalunits ,
    P.schedulepercentcomplete schedulepercentcomplete ,
    P.scheduleperfindexlaborunits scheduleperfindexlaborunits ,
    P.scheduleperformanceindex scheduleperformanceindex ,
    P.schedulevariance schedulevariance ,
    P.schedulevarianceindex schedulevarianceindex ,
    P.schedulevariancelaborunits schedulevariancelaborunits ,
    P.schedulevarindexlaborunits schedulevarindexlaborunits ,
    P.startdate startdate ,
    P.startdate1variance startdate1variance ,
    P.startdatevariance startdatevariance ,
    P.tocompleteperformanceindex tocompleteperformanceindex ,
    P.totalcost1variance totalcost1variance ,
    P.totalcostvariance totalcostvariance ,
    P.unitspercentcomplete unitspercentcomplete ,
    P.wbscode wbscode ,
    P.wbsname wbsname ,
    a.location_id locationobjectid ,
    P.locationname locationname ,
    a.control_updates_flag reviewrequired ,
    a.starred_flag isstarred ,
    a.cbs_code cbscode ,
    a.update_user lastupdateuser ,
    CASE
      WHEN a.update_date > P.update_date
      THEN a.update_date
      ELSE P.update_date
    END lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate ,
    P.update_date lastupdatedatex ,
    P.activityownerobjectid activityownerobjectid ,
    P.activityowner activityowner ,
    CASE
      WHEN a.update_date>P.update_date
      THEN 'N'
      ELSE 'Y'
    END rpt_current_flag
   FROM ${pm.or.administrative_user}.TASK A
  INNER JOIN ${pm.or.administrative_user}.TASKX P
  ON a.task_id = p.task_id
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab ON a.proj_id = projects_tab.proj_id AND projects_tab.etl_interval > 0  AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  WHERE A.DELETE_SESSION_ID     IS NULL
  /

--METADATA NAME:PROJECT_GE TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE  
CREATE OR REPLACE VIEW PROJECT_GE(OBJECTID, ID, FISCALYEARSTARTMONTH, RESOURCESCANEDITASGNMTPCTCMP, RESOURCESCANSELFASSIGNTOACTS, PRIMARYRESCANMARKACTSASCMP, RESOURCECANASSIGNTOSAMEACT, CHECKOUTSTATUS, ACTIVITYPCTCMPBASEDONSTEPS, COSTQUANTITYRECALCULATEFLAG, CONTAINSSUMMARYDATAONLY, ENABLESUMMARIZATION, WBSCODESEPARATOR, ACTIVITYDEFAULTPCTCMPTYPE, ACTIVITYDEFCOSTACCTOBJECTID, ACTIVITYDEFCALENDAROBJECTID, CURRENTBASELINEPROJECTOBJECTID, ACTIVITYIDSUFFIX, ACTIVITYIDINCREMENT, LEVELINGPRIORITY, SUMMARIZETOWBSLEVEL, STRATEGICPRIORITY, CRITICALACTIVITYFLOATLIMIT, ACTIVITYDEFAULTPRICEPERUNIT, PLANNEDSTARTDATE, MUSTFINISHBYDATE, SCHEDULEDFINISHDATE, DATEADDED, SUMMARIZEDDATADATE, LASTSUMMARIZEDDATE, PROJECTFORECASTSTARTDATE, ACTIVITYDEFAULTDURATIONTYPE, ACTIVITYIDPREFIX, DEFAULTPRICETIMEUNITS, ADDEDBY, WEBSITEROOTDIRECTORY, WEBSITEURL, ASSIGNMENTDEFAULTRATETYPE,
  LINKACTUALTOACTUALTHISPERIOD, ACTIVITYDEFAULTACTIVITYTYPE, LINKPERCENTCOMPLETEWITHACTUAL, ADDACTUALTOREMAINING, CRITICALACTIVITYPATHTYPE, ACTIVITYIDBASEDONSELACTIVITY, ASSIGNMENTDEFAULTDRIVINGFLAG, LINKPLANNEDANDATCOMPLETIONFLAG, RESETPLANNEDTOREMAININGFLAG, ALLOWNEGATIVEACTUALUNITSFLAG, OWNERRESOURCEOBJECTID, CHECKOUTDATE, CHECKOUTUSEROBJECTID, LASTFINANCIALPERIODOBJECTID, USEPROJECTBLFOREARNEDVALUE, ANNUALDISCOUNTRATE, ANTICIPATEDFINISHDATE, ANTICIPATEDSTARTDATE, CONTAINSSUMMARYDATA, CURRENTBUDGET, CURRENTVARIANCE, DATADATE, DISCOUNTAPPLICATIONPERIOD, DISTRIBUTEDCURRENTBUDGET, EARNEDVALUECOMPUTETYPE, EARNEDVALUEETCCOMPUTETYPE, EARNEDVALUEETCUSERVALUE, EARNEDVALUEUSERPERCENT, FINISHDATE, FORECASTFINISHDATE, FORECASTSTARTDATE, INDEPENDENTETCLABORUNITS, INDEPENDENTETCTOTALCOST, NAME, OBSNAME, OBSOBJECTID, ORIGINALBUDGET, OVERALLPROJECTSCORE, PARENTEPSOBJECTID, PROPOSEDBUDGET, RISKLEVEL, RISKSCORE,
  RISKEXPOSURE, STARTDATE, STATUS, ORIGINALPROJECTOBJECTID, RISKSCOREMATRIXOBJECTID, SUMPLANNEDSTARTDATE, SUMPLANNEDFINISHDATE, SUMPLANNEDDURATION, SUMPLANNEDLABORUNITS, SUMPLANNEDNONLABORUNITS, SUMPLANNEDEXPENSECOST, SUMPLANNEDLABORCOST, SUMPLANNEDMATERIALCOST, SUMPLANNEDNONLABORCOST, SUMPLANNEDTOTALCOST, SUMACCOUNTINGVARBYLABORUNITS, SUMACCOUNTINGVARIANCEBYCOST, SUMACTTHISPERIODMATERIALCOST, SUMACTTHISPERIODNONLABORCOST, SUMACTTHISPERIODNONLABORUNITS, SUMACTUALTHISPERIODLABORCOST, SUMACTUALTHISPERIODLABORUNITS, SUMATCOMPLETIONMATERIALCOST, SUMATCOMPLETIONNONLABORCOST, SUMATCOMPLETIONNONLABORUNITS, SUMATCOMPLETIONTOTALCOSTVAR, SUMBASELINECOMPACTIVITYCOUNT, SUMBASELINENOTSTARTEDACTCNT, SUMBLINPROGRESSACTIVITYCOUNT, SUMBUDGETATCMPBYLABORUNITS, SUMBUDGETATCOMPLETIONBYCOST, SUMCOSTPERFINDEXBYCOST, SUMCOSTPERFINDEXBYLABORUNITS, SUMCOSTVARIANCEBYLABORUNITS, SUMCOSTVARINDEXBYLABORUNITS, SUMDURATIONPERCENTOFPLANNED,
  SUMEACBYCOST, SUMEACBYLABORUNITS, SUMEACHIGHPCTBYLABORUNITS, SUMEACLOWPCTBYLABORUNITS, SUMETCBYCOST, SUMETCBYLABORUNITS, SUMEXPENSECOSTPCTCOMPLETE, SUMLABORCOSTPERCENTCOMPLETE, SUMLABORUNITSPERCENTCOMPLETE, SUMACTIVITYCOUNT, SUMACTUALDURATION, SUMACTUALEXPENSECOST, SUMACTUALFINISHDATE, SUMMAXACTUALFINISHDATE, SUMMAXRESTARTDATE, SUMACTUALLABORCOST, SUMACTUALLABORUNITS, SUMACTUALMATERIALCOST, SUMACTUALNONLABORCOST, SUMACTUALNONLABORUNITS, SUMACTUALSTARTDATE, SUMACTUALTHISPERIODCOST, SUMACTUALTOTALCOST, SUMACTUALVALUEBYCOST, SUMACTUALVALUEBYLABORUNITS, SUMATCOMPLETIONDURATION, SUMATCOMPLETIONEXPENSECOST, SUMATCOMPLETIONLABORCOST, SUMATCOMPLETIONLABORUNITS, SUMATCOMPLETIONTOTALCOST, SUMBASELINEDURATION, SUMBASELINEEXPENSECOST, SUMBASELINEFINISHDATE, SUMBASELINELABORCOST, SUMBASELINELABORUNITS, SUMBASELINEMATERIALCOST, SUMBASELINENONLABORCOST, SUMBASELINENONLABORUNITS, SUMBASELINESTARTDATE,
  SUMBASELINETOTALCOST, SUMCOMPLETEDACTIVITYCOUNT, SUMCOSTPERCENTCOMPLETE, SUMCOSTPERCENTOFPLANNED, SUMCOSTVARIANCEBYCOST, SUMCOSTVARIANCEINDEX, SUMCOSTVARIANCEINDEXBYCOST, SUMDURATIONPERCENTCOMPLETE, SUMDURATIONVARIANCE, SUMEARNEDVALUEBYCOST, SUMEARNEDVALUEBYLABORUNITS, SUMEXPENSECOSTVARIANCE, SUMFINISHDATEVARIANCE, SUMINPROGRESSACTIVITYCOUNT, SUMLABORCOSTVARIANCE, SUMLABORUNITSVARIANCE, SUMMATERIALCOSTVARIANCE, SUMNONLABORCOSTVARIANCE, SUMNONLABORUNITSVARIANCE, SUMNOTSTARTEDACTIVITYCOUNT, SUMPLANNEDVALUEBYCOST, SUMPROGRESSFINISHDATE, SUMREMAININGDURATION, SUMREMAININGEXPENSECOST, SUMREMAININGFINISHDATE, SUMREMAININGLABORCOST, SUMREMAININGLABORUNITS, SUMREMAININGMATERIALCOST, SUMREMAININGNONLABORCOST, SUMREMAININGNONLABORUNITS, SUMREMAININGSTARTDATE, SUMREMAININGTOTALCOST, SUMSCHEDULEPERCENTCOMPLETE, SUMPERFORMANCEPERCENTCOMPLETE, SUMSCHEDULEVARIANCEBYCOST, SUMSCHEDULEVARIANCEINDEX, SUMSTARTDATEVARIANCE,
  SUMTOTALCOSTVARIANCE, SUMTOTALFLOAT, SUMUNITSPERCENTCOMPLETE, SUMMATERIALCOSTPCTCOMPLETE, SUMNONLABORCOSTPCTCOMPLETE, SUMNONLABORUNITSPCTCOMPLETE, SUMPERFPCTCMPBYLABORUNITS, SUMPLANNEDVALUEBYLABORUNITS, SUMSCHDPCTCMPBYLABORUNITS, SUMSCHDPERFINDEXBYLABORUNITS, SUMSCHDVARIANCEBYLABORUNITS, SUMSCHDVARIANCEINDEXBYCOST, SUMSCHDVARINDEXBYLABORUNITS, SUMSCHEDULEPERFINDEXBYCOST, SUMTOCOMPLETEPERFINDEXBYCOST, SUMVARATCMPBYLABORUNITS, SUMEARLYSTARTDATE, SUMEARLYENDDATE, SUMLATESTARTDATE, SUMLATEENDDATE, SUMMAXCALENDARID, SUMMINCALENDARID, TOTALBENEFITPLAN, TOTALBENEFITPLANTALLY, TOTALFUNDING, TOTALSPENDINGPLAN, TOTALSPENDINGPLANTALLY, UNALLOCATEDBUDGET, NETPRESENTVALUE, RETURNONINVESTMENT, PAYBACKPERIOD, UNDISTRIBUTEDCURRENTVARIANCE, PROJECTDESCRIPTION, BASELINETYPEOBJECTID, ENABLEPUBLICATION, NEXTPUBLICATIONDATE, LASTPUBLISHEDON, PUBLICATIONPRIORITY, LOCATIONOBJECTID, HISTORYINTERVAL, HISTORYLEVEL,
  LOCATIONNAME, ALLOWSTATUSREVIEW, STATUSREVIEWEROBJECTID, STATUSREVIEWERNAME, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE, ETLINTERVAL, ETLHOUR, LASTUPDATEDATEX)
AS
  SELECT a.proj_id objectid ,
    a.proj_short_name id ,
    a.fy_start_month_num fiscalyearstartmonth ,
    a.chng_eff_cmp_pct_flag resourcescaneditasgnmtpctcmp ,
    a.rsrc_self_add_flag resourcescanselfassigntoacts ,
    a.allow_complete_flag primaryrescanmarkactsascmp ,
    a.rsrc_multi_assign_flag resourcecanassigntosameact ,
    a.checkout_flag checkoutstatus ,
    a.step_complete_flag activitypctcmpbasedonsteps ,
    a.cost_qty_recalc_flag costquantityrecalculateflag ,
    a.sum_only_flag containssummarydataonly ,
    a.batch_sum_flag enablesummarization ,
    a.name_sep_char wbscodeseparator ,
    CASE a.def_complete_pct_type
      WHEN 'CP_Phys'
      THEN 'Physical'
      WHEN 'CP_Drtn'
      THEN 'Duration'
      WHEN 'CP_Units'
      THEN 'Units'
      WHEN 'CP_Phys'
      THEN 'Physical'
      WHEN 'CP_Drtn'
      THEN 'Duration'
      WHEN 'CP_Units'
      THEN 'Units'
      ELSE a.def_complete_pct_type
    END activitydefaultpctcmptype ,
    a.acct_id activitydefcostacctobjectid ,
    a.clndr_id activitydefcalendarobjectid ,
    a.sum_base_proj_id currentbaselineprojectobjectid ,
    a.task_code_base activityidsuffix ,
    a.task_code_step activityidincrement ,
    a.priority_num levelingpriority ,
    a.wbs_max_sum_level summarizetowbslevel ,
    a.strgy_priority_num strategicpriority ,
    a.critical_drtn_hr_cnt criticalactivityfloatlimit ,
    a.def_cost_per_qty activitydefaultpriceperunit ,
    a.plan_start_date plannedstartdate ,
    a.plan_end_date mustfinishbydate ,
    a.scd_end_date scheduledfinishdate ,
    a.add_date dateadded ,
    a.sum_data_date summarizeddatadate ,
    a.last_tasksum_date lastsummarizeddate ,
    a.fcst_start_date projectforecaststartdate ,
    CASE a.def_duration_type
      WHEN 'DT_FixedRate'
      THEN 'Fixed Units/Time'
      WHEN 'DT_FixedDrtn'
      THEN 'Fixed Duration UNITS/Time'
      WHEN 'DT_FixedQty'
      THEN 'Fixed Units'
      WHEN 'DT_FixedDUR2'
      THEN 'Fixed Duration UNITS'
      WHEN 'DT_FixedRate'
      THEN 'Fixed Units/Time'
      WHEN 'DT_FixedDrtn'
      THEN 'Fixed Duration UNITS/Time'
      WHEN 'DT_FixedQty'
      THEN 'Fixed Units'
      WHEN 'DT_FixedDUR2'
      THEN 'Fixed Duration UNITS'
      ELSE a.def_duration_type
    END activitydefaultdurationtype ,
    a.task_code_prefix activityidprefix ,
    CASE a.def_qty_type
      WHEN 'QT_Hour'
      THEN 'Hour'
      WHEN 'QT_Day'
      THEN 'Day'
      WHEN 'QT_Week'
      THEN 'Week'
      WHEN 'QT_Month'
      THEN 'Month'
      WHEN 'QT_Year'
      THEN 'Year'
      WHEN 'QT_DaysHours'
      THEN '??enm.UnitType.QT_DaysHours??'
      WHEN 'QT_HoursMinutes'
      THEN '??enm.UnitType.QT_HoursMinutes??'
      WHEN 'QT_Hour'
      THEN 'Hour'
      WHEN 'QT_Day'
      THEN 'Day'
      WHEN 'QT_Week'
      THEN 'Week'
      WHEN 'QT_Month'
      THEN 'Month'
      WHEN 'QT_Year'
      THEN 'Year'
      WHEN 'QT_DaysHours'
      THEN '??enm.UnitType.QT_DaysHours??'
      WHEN 'QT_HoursMinutes'
      THEN '??enm.UnitType.QT_HoursMinutes??'
      ELSE a.def_qty_type
    END defaultpricetimeunits ,
    a.add_by_name addedby ,
    a.web_local_root_path websiterootdirectory ,
    a.proj_url websiteurl ,
    CASE a.def_rate_type
      WHEN 'COST_PER_QTY'
      THEN 'Cost Per Qty'
      WHEN 'COST_PER_QTY2'
      THEN 'CostPerQty2'
      WHEN 'COST_PER_QTY3'
      THEN 'CostPerQty3'
      WHEN 'COST_PER_QTY4'
      THEN 'CostPerQty4'
      WHEN 'COST_PER_QTY5'
      THEN 'CostPerQty5'
      WHEN 'COST_PER_QTY'
      THEN 'Cost Per Qty'
      WHEN 'COST_PER_QTY2'
      THEN 'CostPerQty2'
      WHEN 'COST_PER_QTY3'
      THEN 'CostPerQty3'
      WHEN 'COST_PER_QTY4'
      THEN 'CostPerQty4'
      WHEN 'COST_PER_QTY5'
      THEN 'CostPerQty5'
      ELSE a.def_rate_type
    END assignmentdefaultratetype ,
    a.act_this_per_link_flag linkactualtoactualthisperiod ,
    CASE a.def_task_type
      WHEN 'TT_Task'
      THEN 'Task Dependent'
      WHEN 'TT_Rsrc'
      THEN 'Resource Dependent'
      WHEN 'TT_LOE'
      THEN 'Level Of Effort'
      WHEN 'TT_Mile'
      THEN 'Start Milestone'
      WHEN 'TT_FinMile'
      THEN 'Finish Milestone'
      WHEN 'TT_WBS'
      THEN 'WBS Summary'
      WHEN 'TT_Task'
      THEN 'Task Dependent'
      WHEN 'TT_Rsrc'
      THEN 'Resource Dependent'
      WHEN 'TT_LOE'
      THEN 'Level Of Effort'
      WHEN 'TT_Mile'
      THEN 'Start Milestone'
      WHEN 'TT_FinMile'
      THEN 'Finish Milestone'
      WHEN 'TT_WBS'
      THEN 'WBS Summary'
      ELSE a.def_task_type
    END activitydefaultactivitytype ,
    a.act_pct_link_flag linkpercentcompletewithactual ,
    a.add_act_remain_flag addactualtoremaining ,
    CASE a.critical_path_type
      WHEN 'CT_TotFloat'
      THEN 'Critical Float'
      WHEN 'CT_DrivPath'
      THEN 'Longest Path'
      WHEN 'CT_TotFloat'
      THEN 'Critical Float'
      WHEN 'CT_DrivPath'
      THEN 'Longest Path'
      ELSE a.critical_path_type
    END criticalactivitypathtype ,
    a.task_code_prefix_flag activityidbasedonselactivity ,
    a.def_rollup_dates_flag assignmentdefaultdrivingflag ,
    a.rem_target_link_flag linkplannedandatcompletionflag ,
    a.reset_planned_flag resetplannedtoremainingflag ,
    a.allow_neg_act_flag allownegativeactualunitsflag ,
    a.rsrc_id ownerresourceobjectid ,
    a.checkout_date checkoutdate ,
    a.checkout_user_id checkoutuserobjectid ,
    a.last_fin_dates_id lastfinancialperiodobjectid ,
    a.use_project_baseline_flag useprojectblforearnedvalue ,
    P.annualdiscountrate annualdiscountrate ,
    P.anticipatedfinishdate anticipatedfinishdate ,
    P.anticipatedstartdate anticipatedstartdate ,
    P.containssummarydata containssummarydata ,
    P.currentbudget currentbudget ,
    P.currentvariance currentvariance ,
    P.datadate datadate ,
    P.discountapplicationperiod discountapplicationperiod ,
    P.distributedcurrentbudget distributedcurrentbudget ,
    P.earnedvaluecomputetype earnedvaluecomputetype ,
    P.earnedvalueetccomputetype earnedvalueetccomputetype ,
    P.earnedvalueetcuservalue earnedvalueetcuservalue ,
    P.earnedvalueuserpercent earnedvalueuserpercent ,
    P.finishdate finishdate ,
    P.forecastfinishdate forecastfinishdate ,
    P.forecaststartdate forecaststartdate ,
    P.independentetclaborunits independentetclaborunits ,
    P.independentetctotalcost independentetctotalcost ,
    P.name name ,
    P.obsname obsname ,
    P.obsobjectid obsobjectid ,
    P.originalbudget originalbudget ,
    P.overallprojectscore overallprojectscore ,
    P.parentepsobjectid parentepsobjectid ,
    P.proposedbudget proposedbudget ,
    P.risklevel risklevel ,
    P.riskscore riskscore ,
    P.riskexposure riskexposure ,
    P.startdate startdate ,
    P.status status ,
    a.orig_proj_id originalprojectobjectid ,
    a.matrix_id riskscorematrixobjectid ,
    P.sumplannedstartdate sumplannedstartdate ,
    P.sumplannedfinishdate sumplannedfinishdate ,
    P.sumplannedduration sumplannedduration ,
    P.sumplannedlaborunits sumplannedlaborunits ,
    P.sumplannednonlaborunits sumplannednonlaborunits ,
    P.sumplannedexpensecost sumplannedexpensecost ,
    P.sumplannedlaborcost sumplannedlaborcost ,
    P.sumplannedmaterialcost sumplannedmaterialcost ,
    P.sumplannednonlaborcost sumplannednonlaborcost ,
    P.sumplannedtotalcost sumplannedtotalcost ,
    P.sumaccountingvarbylaborunits sumaccountingvarbylaborunits ,
    P.sumaccountingvariancebycost sumaccountingvariancebycost ,
    P.sumactthisperiodmaterialcost sumactthisperiodmaterialcost ,
    P.sumactthisperiodnonlaborcost sumactthisperiodnonlaborcost ,
    P.sumactthisperiodnonlaborunits sumactthisperiodnonlaborunits ,
    P.sumactualthisperiodlaborcost sumactualthisperiodlaborcost ,
    P.sumactualthisperiodlaborunits sumactualthisperiodlaborunits ,
    P.sumatcompletionmaterialcost sumatcompletionmaterialcost ,
    P.sumatcompletionnonlaborcost sumatcompletionnonlaborcost ,
    P.sumatcompletionnonlaborunits sumatcompletionnonlaborunits ,
    P.sumatcompletiontotalcostvar sumatcompletiontotalcostvar ,
    P.sumbaselinecompactivitycount sumbaselinecompactivitycount ,
    P.sumbaselinenotstartedactcnt sumbaselinenotstartedactcnt ,
    P.sumblinprogressactivitycount sumblinprogressactivitycount ,
    P.sumbudgetatcmpbylaborunits sumbudgetatcmpbylaborunits ,
    P.sumbudgetatcompletionbycost sumbudgetatcompletionbycost ,
    P.sumcostperfindexbycost sumcostperfindexbycost ,
    P.sumcostperfindexbylaborunits sumcostperfindexbylaborunits ,
    P.sumcostvariancebylaborunits sumcostvariancebylaborunits ,
    P.sumcostvarindexbylaborunits sumcostvarindexbylaborunits ,
    P.sumdurationpercentofplanned sumdurationpercentofplanned ,
    P.sumeacbycost sumeacbycost ,
    P.sumeacbylaborunits sumeacbylaborunits ,
    P.sumeachighpctbylaborunits sumeachighpctbylaborunits ,
    P.sumeaclowpctbylaborunits sumeaclowpctbylaborunits ,
    P.sumetcbycost sumetcbycost ,
    P.sumetcbylaborunits sumetcbylaborunits ,
    P.sumexpensecostpctcomplete sumexpensecostpctcomplete ,
    P.sumlaborcostpercentcomplete sumlaborcostpercentcomplete ,
    P.sumlaborunitspercentcomplete sumlaborunitspercentcomplete ,
    P.sumactivitycount sumactivitycount ,
    P.sumactualduration sumactualduration ,
    P.sumactualexpensecost sumactualexpensecost ,
    P.sumactualfinishdate sumactualfinishdate ,
    P.summaxactualfinishdate summaxactualfinishdate ,
    P.summaxrestartdate summaxrestartdate ,
    P.sumactuallaborcost sumactuallaborcost ,
    P.sumactuallaborunits sumactuallaborunits ,
    P.sumactualmaterialcost sumactualmaterialcost ,
    P.sumactualnonlaborcost sumactualnonlaborcost ,
    P.sumactualnonlaborunits sumactualnonlaborunits ,
    P.sumactualstartdate sumactualstartdate ,
    P.sumactualthisperiodcost sumactualthisperiodcost ,
    P.sumactualtotalcost sumactualtotalcost ,
    P.sumactualvaluebycost sumactualvaluebycost ,
    P.sumactualvaluebylaborunits sumactualvaluebylaborunits ,
    P.sumatcompletionduration sumatcompletionduration ,
    P.sumatcompletionexpensecost sumatcompletionexpensecost ,
    P.sumatcompletionlaborcost sumatcompletionlaborcost ,
    P.sumatcompletionlaborunits sumatcompletionlaborunits ,
    P.sumatcompletiontotalcost sumatcompletiontotalcost ,
    P.sumbaselineduration sumbaselineduration ,
    P.sumbaselineexpensecost sumbaselineexpensecost ,
    P.sumbaselinefinishdate sumbaselinefinishdate ,
    P.sumbaselinelaborcost sumbaselinelaborcost ,
    P.sumbaselinelaborunits sumbaselinelaborunits ,
    P.sumbaselinematerialcost sumbaselinematerialcost ,
    P.sumbaselinenonlaborcost sumbaselinenonlaborcost ,
    P.sumbaselinenonlaborunits sumbaselinenonlaborunits ,
    P.sumbaselinestartdate sumbaselinestartdate ,
    P.sumbaselinetotalcost sumbaselinetotalcost ,
    P.sumcompletedactivitycount sumcompletedactivitycount ,
    P.sumcostpercentcomplete sumcostpercentcomplete ,
    P.sumcostpercentofplanned sumcostpercentofplanned ,
    P.sumcostvariancebycost sumcostvariancebycost ,
    P.sumcostvarianceindex sumcostvarianceindex ,
    P.sumcostvarianceindexbycost sumcostvarianceindexbycost ,
    P.sumdurationpercentcomplete sumdurationpercentcomplete ,
    P.sumdurationvariance sumdurationvariance ,
    P.sumearnedvaluebycost sumearnedvaluebycost ,
    P.sumearnedvaluebylaborunits sumearnedvaluebylaborunits ,
    P.sumexpensecostvariance sumexpensecostvariance ,
    P.sumfinishdatevariance sumfinishdatevariance ,
    P.suminprogressactivitycount suminprogressactivitycount ,
    P.sumlaborcostvariance sumlaborcostvariance ,
    P.sumlaborunitsvariance sumlaborunitsvariance ,
    P.summaterialcostvariance summaterialcostvariance ,
    P.sumnonlaborcostvariance sumnonlaborcostvariance ,
    P.sumnonlaborunitsvariance sumnonlaborunitsvariance ,
    P.sumnotstartedactivitycount sumnotstartedactivitycount ,
    P.sumplannedvaluebycost sumplannedvaluebycost ,
    P.sumprogressfinishdate sumprogressfinishdate ,
    P.sumremainingduration sumremainingduration ,
    P.sumremainingexpensecost sumremainingexpensecost ,
    P.sumremainingfinishdate sumremainingfinishdate ,
    P.sumremaininglaborcost sumremaininglaborcost ,
    P.sumremaininglaborunits sumremaininglaborunits ,
    P.sumremainingmaterialcost sumremainingmaterialcost ,
    P.sumremainingnonlaborcost sumremainingnonlaborcost ,
    P.sumremainingnonlaborunits sumremainingnonlaborunits ,
    P.sumremainingstartdate sumremainingstartdate ,
    P.sumremainingtotalcost sumremainingtotalcost ,
    P.sumschedulepercentcomplete sumschedulepercentcomplete ,
    P.sumperformancepercentcomplete sumperformancepercentcomplete ,
    P.sumschedulevariancebycost sumschedulevariancebycost ,
    P.sumschedulevarianceindex sumschedulevarianceindex ,
    P.sumstartdatevariance sumstartdatevariance ,
    P.sumtotalcostvariance sumtotalcostvariance ,
    P.sumtotalfloat sumtotalfloat ,
    P.sumunitspercentcomplete sumunitspercentcomplete ,
    P.summaterialcostpctcomplete summaterialcostpctcomplete ,
    P.sumnonlaborcostpctcomplete sumnonlaborcostpctcomplete ,
    P.sumnonlaborunitspctcomplete sumnonlaborunitspctcomplete ,
    P.sumperfpctcmpbylaborunits sumperfpctcmpbylaborunits ,
    P.sumplannedvaluebylaborunits sumplannedvaluebylaborunits ,
    P.sumschdpctcmpbylaborunits sumschdpctcmpbylaborunits ,
    P.sumschdperfindexbylaborunits sumschdperfindexbylaborunits ,
    P.sumschdvariancebylaborunits sumschdvariancebylaborunits ,
    P.sumschdvarianceindexbycost sumschdvarianceindexbycost ,
    P.sumschdvarindexbylaborunits sumschdvarindexbylaborunits ,
    P.sumscheduleperfindexbycost sumscheduleperfindexbycost ,
    P.sumtocompleteperfindexbycost sumtocompleteperfindexbycost ,
    P.sumvaratcmpbylaborunits sumvaratcmpbylaborunits ,
    P.sumearlystartdate sumearlystartdate ,
    P.sumearlyenddate sumearlyenddate ,
    P.sumlatestartdate sumlatestartdate ,
    P.sumlateenddate sumlateenddate ,
    P.summaxcalendarid summaxcalendarid ,
    P.summincalendarid summincalendarid ,
    P.totalbenefitplan totalbenefitplan ,
    P.totalbenefitplantally totalbenefitplantally ,
    P.totalfunding totalfunding ,
    P.totalspendingplan totalspendingplan ,
    P.totalspendingplantally totalspendingplantally ,
    P.unallocatedbudget unallocatedbudget ,
    P.netpresentvalue netpresentvalue ,
    P.returnoninvestment returnoninvestment ,
    P.paybackperiod paybackperiod ,
    P.undistributedcurrentvariance undistributedcurrentvariance ,
    a.description projectdescription ,
    a.base_type_id baselinetypeobjectid ,
    a.px_enable_publication_flag enablepublication ,
    a.px_next_date nextpublicationdate ,
    a.px_last_update_date lastpublishedon ,
    a.px_priority publicationpriority ,
    a.location_id locationobjectid ,
    a.hist_interval historyinterval ,
    a.hist_level historylevel ,
    P.locationname locationname ,
    a.control_updates_flag allowstatusreview ,
    P.statusreviewerobjectid statusreviewerobjectid ,
    P.statusreviewername statusreviewername ,
    a.update_user lastupdateuser ,
    a.update_date lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate ,
    a.etl_interval etlinterval ,
    a.etl_hour etlhour ,
    CASE
      WHEN a.update_date > p.update_date
      THEN a.update_date
      ELSE p.update_date
    END lastupdatedatex
   FROM ${pm.or.administrative_user}.PROJECT A
  INNER JOIN ${pm.or.administrative_user}.PROJECTX P
  ON a.proj_id               = p.proj_id
  AND a.PROJECT_FLAG         = 'Y'
  WHERE A.DELETE_SESSION_ID IS NULL
  AND a.etl_interval         > 0
  AND a.ORIG_PROJ_ID        IS NULL
  /
  
--METADATA NAME:ACTIVITYEXPENSE_GE TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE  
CREATE OR REPLACE VIEW ACTIVITYEXPENSE_GE(OBJECTID, PROJECTOBJECTID, ACTIVITYOBJECTID, AUTOCOMPUTEACTUALS, ACCRUALTYPE, COSTACCOUNTOBJECTID, EXPENSECATEGORYOBJECTID, CBSOBJECTID, PLANNEDCOST, ACTUALCOST, REMAININGCOST, UNITOFMEASURE, PLANNEDUNITS, PRICEPERUNIT, DOCUMENTNUMBER, VENDOR, EXPENSEITEM, EXPENSEDESCRIPTION, ACTIVITYID, ACTIVITYNAME, ACTUALUNITS, ATCOMPLETIONCOST, ATCOMPLETIONUNITS, COSTACCOUNTID, COSTACCOUNTNAME, CBSCODE, CBSNAME, EXPENSECATEGORYNAME, EXPENSEPERCENTCOMPLETE, OVERBUDGET, PROJECTID, REMAININGUNITS, WBSOBJECTID, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE)
AS
  SELECT a.cost_item_id objectid ,
    a.proj_id projectobjectid ,
    a.task_id activityobjectid ,
    a.auto_compute_act_flag autocomputeactuals ,
    CASE a.cost_load_type
      WHEN 'CL_Start'
      THEN 'Start of Activity'
      WHEN 'CL_End'
      THEN 'End of Activity'
      WHEN 'CL_Uniform'
      THEN 'Uniform over Activity'
      ELSE a.cost_load_type
    END accrualtype ,
    a.acct_id costaccountobjectid ,
    a.cost_type_id expensecategoryobjectid ,
    a.cbs_id cbsobjectid ,
    a.target_cost plannedcost ,
    a.act_cost actualcost ,
    a.remain_cost remainingcost ,
    a.qty_name unitofmeasure ,
    a.target_qty plannedunits ,
    a.cost_per_qty priceperunit ,
    a.po_number documentnumber ,
    a.vendor_name vendor ,
    a.cost_name expenseitem ,
    a.cost_descr expensedescription ,
    P.activityid activityid ,
    P.activityname activityname ,
    P.actualunits actualunits ,
    P.atcompletioncost atcompletioncost ,
    P.atcompletionunits atcompletionunits ,
    P.costaccountid costaccountid ,
    P.costaccountname costaccountname ,
    c.cbs_code cbscode ,
    c.description cbsname ,
    P.expensecategoryname expensecategoryname ,
    P.expensepercentcomplete expensepercentcomplete ,
    P.overbudget overbudget ,
    P.projectid projectid ,
    P.remainingunits remainingunits ,
    P.wbsobjectid wbsobjectid ,
    a.update_user lastupdateuser ,
    a.update_date lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate
   FROM ${pm.or.administrative_user}.PROJCOST A
  INNER JOIN ${pm.or.administrative_user}.PROJCOSTX P ON a.cost_item_id = p.cost_item_id
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab on a.proj_id = projects_tab.proj_id AND projects_tab.etl_interval > 0  AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  LEFT OUTER  JOIN ${pm.or.administrative_user}.cbs c
  ON a.cbs_id = c.cbs_id
  WHERE A.DELETE_SESSION_ID IS NULL
  /
  
--METADATA NAME:ACTIVITYNOTE_GE TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE  
CREATE OR REPLACE VIEW ACTIVITYNOTE_GE(OBJECTID, ACTIVITYOBJECTID, NOTEBOOKTOPICOBJECTID, PROJECTOBJECTID, NOTE, ACTIVITYID, ACTIVITYNAME, NOTEBOOKTOPICNAME, PROJECTID, RAWTEXTNOTE, WBSOBJECTID, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE)
AS
  SELECT a.memo_id objectid ,
    a.task_id activityobjectid ,
    a.memo_type_id notebooktopicobjectid ,
    a.proj_id projectobjectid ,
    a.task_memo note ,
    P.activityid activityid ,
    P.activityname activityname ,
    P.notebooktopicname notebooktopicname ,
    P.projectid projectid ,
    P.rawtextnote rawtextnote ,
    P.wbsobjectid wbsobjectid ,
    a.update_user lastupdateuser ,
    a.update_date lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate
   FROM ${pm.or.administrative_user}.TASKMEMO A
  INNER JOIN ${pm.or.administrative_user}.TASKMEMOX P ON a.memo_id = p.memo_id
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab on a.proj_id = projects_tab.proj_id AND projects_tab.etl_interval > 0  AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  WHERE A.DELETE_SESSION_ID IS NULL
  /
  
--METADATA NAME:ACTIVITYRISK_GE TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE  
CREATE OR REPLACE VIEW ACTIVITYRISK_GE(ACTIVITYOBJECTID, PROJECTOBJECTID, RISKOBJECTID, PROJECTID, PROJECTNAME, ACTIVITYID, ACTIVITYNAME, RISKNAME, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE)
AS
  SELECT a.task_id activityobjectid ,
    a.proj_id projectobjectid ,
    a.risk_id riskobjectid ,
    P.projectid projectid ,
    P.projectname projectname ,
    P.activityid activityid ,
    P.activityname activityname ,
    P.riskname riskname ,
    a.update_user lastupdateuser ,
    a.update_date lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate
   FROM ${pm.or.administrative_user}.TASKRISK A
  INNER JOIN ${pm.or.administrative_user}.TASKRISKX P ON a.task_id = p.task_id AND a.risk_id = p.risk_id
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab on a.proj_id = projects_tab.proj_id AND projects_tab.etl_interval > 0  AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  WHERE A.DELETE_SESSION_ID IS NULL
  /
  
--METADATA NAME:ACTIVITYSPREAD_GE TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYSPREAD_GE(ACTIVITYOBJECTID, STARTDATE, ENDDATE, ACTIVITYCODE, ACTIVITYNAME, WBSOBJECTID, PROJECTOBJECTID, ACTUALLABORUNITS, ACTUALNONLABORUNITS, ATCOMPLETIONLABORUNITS, ATCOMPLETIONNONLABORUNITS, BASELINEACTUALLABORUNITS, BASELINEACTUALNONLABORUNITS, BASELINEPLANNEDLABORUNITS, BASELINEPLANNEDNONLABORUNITS, BASELINE1ACTUALLABORUNITS, BASELINE1ACTUALNONLABORUNITS, BASELINE1PLANNEDLABORUNITS, BASELINE1PLANNEDNONLABORUNITS, EARNEDVALUELABORUNITS, ESTIMATEATCOMPLETIONLABORUNITS, ESTIMATETOCOMPLETELABORUNITS, PLANNEDLABORUNITS, PLANNEDNONLABORUNITS, PLANNEDVALUELABORUNITS, REMAININGLABORUNITS, REMAININGLATELABORUNITS, REMAININGLATENONLABORUNITS, REMAININGNONLABORUNITS, ACTUALCOST, ACTUALEXPENSECOST, ACTUALLABORCOST, ACTUALMATERIALCOST, ACTUALNONLABORCOST, ACTUALTOTALCOST, ATCOMPLETIONEXPENSECOST, ATCOMPLETIONLABORCOST, ATCOMPLETIONMATERIALCOST,
  ATCOMPLETIONNONLABORCOST, ATCOMPLETIONTOTALCOST, BASELINEPLANNEDEXPENSECOST, BASELINEPLANNEDLABORCOST, BASELINEPLANNEDMATERIALCOST, BASELINEPLANNEDNONLABORCOST, BASELINEPLANNEDTOTALCOST, BASELINEACTUALEXPENSECOST, BASELINEACTUALLABORCOST, BASELINEACTUALMATERIALCOST, BASELINEACTUALNONLABORCOST, BASELINEACTUALTOTALCOST, BASELINE1ACTUALEXPENSECOST, BASELINE1ACTUALLABORCOST, BASELINE1ACTUALMATERIALCOST, BASELINE1ACTUALNONLABORCOST, BASELINE1ACTUALTOTALCOST, BASELINE1PLANNEDEXPENSECOST, BASELINE1PLANNEDLABORCOST, BASELINE1PLANNEDMATERIALCOST, BASELINE1PLANNEDNONLABORCOST, BASELINE1PLANNEDTOTALCOST, EARNEDVALUECOST, ESTIMATEATCOMPLETIONCOST, ESTIMATETOCOMPLETECOST, PLANNEDEXPENSECOST, PLANNEDLABORCOST, PLANNEDMATERIALCOST, PLANNEDNONLABORCOST, PLANNEDTOTALCOST, PLANNEDVALUECOST, REMAININGEXPENSECOST, REMAININGLABORCOST, REMAININGLATEEXPENSECOST, REMAININGLATELABORCOST, REMAININGLATEMATERIALCOST,
  REMAININGLATENONLABORCOST, REMAININGLATETOTALCOST, REMAININGMATERIALCOST, REMAININGNONLABORCOST, REMAININGTOTALCOST, LASTUPDATEDATE, CBSOBJECTID)
AS
  SELECT a.ACTIVITYOBJECTID,
    a.STARTDATE,
    a.ENDDATE,
    a.ACTIVITYCODE,
    a.ACTIVITYNAME,
    a.WBSOBJECTID,
    a.PROJECTOBJECTID,
    a.ACTUALLABORUNITS,
    a.ACTUALNONLABORUNITS,
    a.ATCOMPLETIONLABORUNITS,
    a.ATCOMPLETIONNONLABORUNITS,
    a.BASELINEACTUALLABORUNITS,
    a.BASELINEACTUALNONLABORUNITS,
    a.BASELINEPLANNEDLABORUNITS,
    a.BASELINEPLANNEDNONLABORUNITS,
    a.BASELINE1ACTUALLABORUNITS,
    a.BASELINE1ACTUALNONLABORUNITS,
    a.BASELINE1PLANNEDLABORUNITS,
    a.BASELINE1PLANNEDNONLABORUNITS,
    a.EARNEDVALUELABORUNITS,
    a.ESTIMATEATCOMPLETIONLABORUNITS,
    a.ESTIMATETOCOMPLETELABORUNITS,
    a.PLANNEDLABORUNITS,
    a.PLANNEDNONLABORUNITS,
    a.PLANNEDVALUELABORUNITS,
    a.REMAININGLABORUNITS,
    a.REMAININGLATELABORUNITS,
    a.REMAININGLATENONLABORUNITS,
    a.REMAININGNONLABORUNITS,
    a.ACTUALCOST,
    a.ACTUALEXPENSECOST,
    a.ACTUALLABORCOST,
    a.ACTUALMATERIALCOST,
    a.ACTUALNONLABORCOST,
    a.ACTUALTOTALCOST,
    a.ATCOMPLETIONEXPENSECOST,
    a.ATCOMPLETIONLABORCOST,
    a.ATCOMPLETIONMATERIALCOST,
    a.ATCOMPLETIONNONLABORCOST,
    a.ATCOMPLETIONTOTALCOST,
    a.BASELINEPLANNEDEXPENSECOST,
    a.BASELINEPLANNEDLABORCOST,
    a.BASELINEPLANNEDMATERIALCOST,
    a.BASELINEPLANNEDNONLABORCOST,
    a.BASELINEPLANNEDTOTALCOST,
    a.BASELINEACTUALEXPENSECOST,
    a.BASELINEACTUALLABORCOST,
    a.BASELINEACTUALMATERIALCOST,
    a.BASELINEACTUALNONLABORCOST,
    a.BASELINEACTUALTOTALCOST,
    a.BASELINE1ACTUALEXPENSECOST,
    a.BASELINE1ACTUALLABORCOST,
    a.BASELINE1ACTUALMATERIALCOST,
    a.BASELINE1ACTUALNONLABORCOST,
    a.BASELINE1ACTUALTOTALCOST,
    a.BASELINE1PLANNEDEXPENSECOST,
    a.BASELINE1PLANNEDLABORCOST,
    a.BASELINE1PLANNEDMATERIALCOST,
    a.BASELINE1PLANNEDNONLABORCOST,
    a.BASELINE1PLANNEDTOTALCOST,
    a.EARNEDVALUECOST,
    a.ESTIMATEATCOMPLETIONCOST,
    a.ESTIMATETOCOMPLETECOST,
    a.PLANNEDEXPENSECOST,
    a.PLANNEDLABORCOST,
    a.PLANNEDMATERIALCOST,
    a.PLANNEDNONLABORCOST,
    a.PLANNEDTOTALCOST,
    a.PLANNEDVALUECOST,
    a.REMAININGEXPENSECOST,
    a.REMAININGLABORCOST,
    a.REMAININGLATEEXPENSECOST,
    a.REMAININGLATELABORCOST,
    a.REMAININGLATEMATERIALCOST,
    a.REMAININGLATENONLABORCOST,
    a.REMAININGLATETOTALCOST,
    a.REMAININGMATERIALCOST,
    a.REMAININGNONLABORCOST,
    a.REMAININGTOTALCOST,
    a.UPDATE_DATE,
    T1.cbs_id cbsobjectid
   FROM ${pm.or.administrative_user}.ACTIVITYSPREAD a
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab on a.projectobjectid = projects_tab.proj_id AND projects_tab.etl_interval > 0  AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  INNER JOIN ${pm.or.administrative_user}.TASK T1 ON T1.task_id = ActivityObjectId AND T1.DELETE_SESSION_ID IS NULL
  /
  
--METADATA NAME:ACTIVITYSTEP_GE TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYSTEP_GE(OBJECTID, ACTIVITYOBJECTID, SEQUENCENUMBER, PROJECTOBJECTID, ISCOMPLETED, NAME, WEIGHT, PERCENTCOMPLETE, DESCRIPTION, ACTIVITYID, ACTIVITYNAME, PROJECTID, WBSOBJECTID, WEIGHTPERCENT, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE)
AS
  SELECT a.proc_id objectid ,
    a.task_id activityobjectid ,
    a.seq_num sequencenumber ,
    a.proj_id projectobjectid ,
    a.complete_flag iscompleted ,
    a.proc_name name ,
    a.proc_wt weight ,
    a.complete_pct percentcomplete ,
    a.proc_descr description ,
    P.activityid activityid ,
    P.activityname activityname ,
    P.projectid projectid ,
    P.wbsobjectid wbsobjectid ,
    P.weightpercent weightpercent ,
    a.update_user lastupdateuser ,
    a.update_date lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate
   FROM ${pm.or.administrative_user}.TASKPROC A
  INNER JOIN ${pm.or.administrative_user}.TASKPROCX P ON a.proc_id = p.proc_id
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab on a.proj_id = projects_tab.proj_id AND projects_tab.etl_interval > 0  AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  WHERE A.DELETE_SESSION_ID IS NULL
  /
  
--METADATA NAME:CBS_GE TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE  
CREATE OR REPLACE VIEW CBS_GE(OBJECTID, PROJECTOBJECTID, CODE, NAME, PARENTOBJECTID, STATUS, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE, LASTUPDATEDATEX)
AS
  SELECT A.cbs_id objectid,
    A.proj_id projectobjectid,
    A.cbs_code code,
    A.description name,
    A.parent_cbs_id parentobjectid,
    A.status status,
    A.update_user lastupdateuser,
    A.update_date lastupdatedate,
    A.create_user createuser,
    A.create_date createdate,
    P.update_dim_date lastupdatedatex
   FROM ${pm.or.administrative_user}.CBS A
  INNER JOIN ${pm.or.administrative_user}.PROJECTX P ON a.proj_id = p.proj_id
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab ON a.proj_id = projects_tab.proj_id AND projects_tab.etl_interval > 0  AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  WHERE A.DELETE_SESSION_ID IS NULL
  /
  
--METADATA NAME:PROJECTNOTE_GE TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTNOTE_GE(OBJECTID, PROJECTOBJECTID, WBSOBJECTID, NOTEBOOKTOPICOBJECTID, NOTE, NOTEBOOKTOPICNAME, PROJECTID, RAWTEXTNOTE, WBSCODE, WBSNAME, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE)
AS
  SELECT a.wbs_memo_id objectid ,
    a.proj_id projectobjectid ,
    a.wbs_id wbsobjectid ,
    a.memo_type_id notebooktopicobjectid ,
    a.wbs_memo note ,
    P.notebooktopicname notebooktopicname ,
    P.projectid projectid ,
    P.rawtextnote rawtextnote ,
    P.wbscode wbscode ,
    P.wbsname wbsname ,
    a.update_user lastupdateuser ,
    a.update_date lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate
   FROM ${pm.or.administrative_user}.WBSMEMO A
  INNER JOIN ${pm.or.administrative_user}.WBSMEMOX P
  ON a.wbs_memo_id = p.wbs_memo_id
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab ON a.proj_id = projects_tab.proj_id AND projects_tab.etl_interval > 0  AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  WHERE A.DELETE_SESSION_ID    IS NULL
  /
  
--METADATA NAME:RESOURCEASSIGNMENT_GE TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE  
CREATE OR REPLACE VIEW RESOURCEASSIGNMENT_GE(OBJECTID, ACTIVITYOBJECTID, PROJECTOBJECTID, RESOURCETYPE, ISCOSTUNITSLINKED, ROLEOBJECTID, COSTACCOUNTOBJECTID, RESOURCEOBJECTID, PROFICIENCY, PENDINGPERCENTCOMPLETE, REMAININGUNITS, PENDINGREMAININGUNITS, PLANNEDUNITS, REMAININGUNITSPERTIME, PENDINGACTUALREGULARUNITS, PLANNEDLAG, PLANNEDUNITSPERTIME, ACTUALOVERTIMEUNITS, PENDINGACTUALOVERTIMEUNITS, ACTUALREGULARUNITS, REMAININGLAG, OVERTIMEFACTOR, PLANNEDCOST, ACTUALREGULARCOST, ACTUALOVERTIMECOST, REMAININGCOST, ACTUALSTARTDATE, ACTUALFINISHDATE, REMAININGSTARTDATE, REMAININGFINISHDATE, PLANNEDSTARTDATE, PLANNEDFINISHDATE, REMAININGLATESTARTDATE, REMAININGLATEFINISHDATE, RATETYPE, ACTUALTHISPERIODCOST, ACTUALTHISPERIODUNITS, RESOURCECURVEOBJECTID, DRIVINGACTIVITYDATESFLAG, RATESOURCE, ACTIVITYID, ACTIVITYNAME, ACTUALCOST, ACTUALDURATION, ACTUALUNITS, ATCOMPLETIONCOST
  , ATCOMPLETIONDURATION, ATCOMPLETIONUNITS, AUTOCOMPUTEACTUALS, CALENDAROBJECTID, COSTACCOUNTID, COSTACCOUNTNAME, FINISHDATE, ISACTIVE, ISOVERTIMEALLOWED, ISPRIMARYRESOURCE, PLANNEDDURATION, PRICEPERUNIT, PROJECTID, REMAININGDURATION, RESOURCECURVENAME, RESOURCEID, RESOURCENAME, ROLEID, ROLENAME, STAFFEDREMAININGCOST, STAFFEDREMAININGUNITS, STARTDATE, UNITSPERCENTCOMPLETE, UNSTAFFEDREMAININGCOST, UNSTAFFEDREMAININGUNITS, WBSOBJECTID, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE, LASTUPDATEDATEX, RPT_CURRENT_FLAG)
AS
  SELECT a.taskrsrc_id objectid ,
    a.task_id activityobjectid ,
    a.proj_id projectobjectid ,
    CASE a.rsrc_type
      WHEN 'RT_Labor'
      THEN 'Labor'
      WHEN 'RT_Equip'
      THEN 'Nonlabor'
      WHEN 'RT_Mat'
      THEN 'Material'
      ELSE a.rsrc_type
    END resourcetype ,
    a.cost_qty_link_flag iscostunitslinked ,
    a.role_id roleobjectid ,
    a.acct_id costaccountobjectid ,
    a.rsrc_id resourceobjectid ,
    P.proficiency proficiency ,
    a.pend_complete_pct pendingpercentcomplete ,
    a.remain_qty remainingunits ,
    a.pend_remain_qty pendingremainingunits ,
    a.target_qty plannedunits ,
    a.remain_qty_per_hr remainingunitspertime ,
    a.pend_act_reg_qty pendingactualregularunits ,
    a.target_lag_drtn_hr_cnt plannedlag ,
    a.target_qty_per_hr plannedunitspertime ,
    a.act_ot_qty actualovertimeunits ,
    a.pend_act_ot_qty pendingactualovertimeunits ,
    a.act_reg_qty actualregularunits ,
    P.remaininglag remaininglag ,
    a.ot_factor overtimefactor ,
    a.target_cost plannedcost ,
    a.act_reg_cost actualregularcost ,
    a.act_ot_cost actualovertimecost ,
    a.remain_cost remainingcost ,
    a.act_start_date actualstartdate ,
    a.act_end_date actualfinishdate ,
    a.restart_date remainingstartdate ,
    a.reend_date remainingfinishdate ,
    a.target_start_date plannedstartdate ,
    a.target_end_date plannedfinishdate ,
    a.rem_late_start_date remaininglatestartdate ,
    a.rem_late_end_date remaininglatefinishdate ,
    CASE a.rate_type
      WHEN 'COST_PER_QTY'
      THEN 'Price/Unit'
      WHEN 'COST_PER_QTY2'
      THEN 'Price/Unit 2'
      WHEN 'COST_PER_QTY3'
      THEN 'Price/Unit 3'
      WHEN 'COST_PER_QTY4'
      THEN 'Price/Unit 4'
      WHEN 'COST_PER_QTY5'
      THEN 'Price/Unit 5'
      ELSE a.rate_type
    END ratetype ,
    a.act_this_per_cost actualthisperiodcost ,
    a.act_this_per_qty actualthisperiodunits ,
    a.curv_id resourcecurveobjectid ,
    a.rollup_dates_flag drivingactivitydatesflag ,
    CASE a.cost_per_qty_source_type
      WHEN 'ST_Rsrc'
      THEN 'Resource'
      WHEN 'ST_Role'
      THEN 'Role'
      WHEN 'ST_Custom'
      THEN 'Override'
      ELSE a.cost_per_qty_source_type
    END ratesource ,
    P.activityid activityid ,
    P.activityname activityname ,
    P.actualcost actualcost ,
    P.actualduration actualduration ,
    P.actualunits actualunits ,
    P.atcompletioncost atcompletioncost ,
    P.atcompletionduration atcompletionduration ,
    P.atcompletionunits atcompletionunits ,
    P.autocomputeactuals autocomputeactuals ,
    P.calendarobjectid calendarobjectid ,
    P.costaccountid costaccountid ,
    P.costaccountname costaccountname ,
    P.finishdate finishdate ,
    P.isactive isactive ,
    P.isovertimeallowed isovertimeallowed ,
    P.isprimaryresource isprimaryresource ,
    P.plannedduration plannedduration ,
    P.priceperunit priceperunit ,
    P.projectid projectid ,
    P.remainingduration remainingduration ,
    P.resourcecurvename resourcecurvename ,
    P.resourceid resourceid ,
    P.resourcename resourcename ,
    P.roleid roleid ,
    P.rolename rolename ,
    P.staffedremainingcost staffedremainingcost ,
    P.staffedremainingunits staffedremainingunits ,
    P.startdate startdate ,
    P.unitspercentcomplete unitspercentcomplete ,
    P.unstaffedremainingcost unstaffedremainingcost ,
    P.unstaffedremainingunits unstaffedremainingunits ,
    P.wbsobjectid wbsobjectid ,
    a.update_user lastupdateuser ,
    a.update_date lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate ,
    P.update_date lastupdatedatex ,
    CASE
      WHEN a.update_date>P.update_date
      THEN 'N'
      ELSE 'Y'
    END rpt_current_flag
   FROM ${pm.or.administrative_user}.TASKRSRC A
  INNER JOIN ${pm.or.administrative_user}.TASKRSRCX P ON a.taskrsrc_id           = p.taskrsrc_id
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab ON a.proj_id = projects_tab.proj_id AND projects_tab.etl_interval > 0  AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  WHERE A.DELETE_SESSION_ID IS NULL
  /
  
--METADATA NAME:RESOURCEASSIGNMENTSPREAD_GE TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE  
CREATE OR REPLACE VIEW RESOURCEASSIGNMENTSPREAD_GE(RESOURCEASSIGNMENTOBJECTID, STARTDATE, ENDDATE, RESOURCEOBJECTID, ROLEOBJECTID, ACTIVITYOBJECTID, WBSOBJECTID, PROJECTOBJECTID, COSTACCOUNTOBJECTID, ACTUALREGULARUNITS, ACTUALOVERTIMEUNITS, ACTUALUNITS, ATCOMPLETIONUNITS, PLANNEDUNITS, REMAININGUNITS, REMAININGLATEUNITS, STAFFEDREMAININGUNITS, STAFFEDREMAININGLATEUNITS, UNSTAFFEDREMAININGUNITS, UNSTAFFEDREMAININGLATEUNITS, ACTUALREGULARCOST, ACTUALOVERTIMECOST, ACTUALCOST, ATCOMPLETIONCOST, PLANNEDCOST, REMAININGCOST, REMAININGLATECOST, STAFFEDREMAININGCOST, STAFFEDREMAININGLATECOST, UNSTAFFEDREMAININGCOST, UNSTAFFEDREMAININGLATECOST, LASTUPDATEDATE, CBSOBJECTID)
AS
  SELECT a.RESOURCEASSIGNMENTOBJECTID,
    a.STARTDATE,
    a.ENDDATE,
    a.RESOURCEOBJECTID,
    a.ROLEOBJECTID,
    a.ACTIVITYOBJECTID,
    a.WBSOBJECTID,
    a.PROJECTOBJECTID,
    a.COSTACCOUNTOBJECTID,
    a.ACTUALREGULARUNITS,
    a.ACTUALOVERTIMEUNITS,
    a.ACTUALUNITS,
    a.ATCOMPLETIONUNITS,
    a.PLANNEDUNITS,
    a.REMAININGUNITS,
    a.REMAININGLATEUNITS,
    a.STAFFEDREMAININGUNITS,
    a.STAFFEDREMAININGLATEUNITS,
    a.UNSTAFFEDREMAININGUNITS,
    a.UNSTAFFEDREMAININGLATEUNITS,
    a.ACTUALREGULARCOST,
    a.ACTUALOVERTIMECOST,
    a.ACTUALCOST,
    a.ATCOMPLETIONCOST,
    a.PLANNEDCOST,
    a.REMAININGCOST,
    a.REMAININGLATECOST,
    a.STAFFEDREMAININGCOST,
    a.STAFFEDREMAININGLATECOST,
    a.UNSTAFFEDREMAININGCOST,
    a.UNSTAFFEDREMAININGLATECOST,
    a.update_date,
    T1.cbs_id cbsobjectid
   FROM ${pm.or.administrative_user}.RESOURCEASSIGNMENTSPREAD a
  INNER JOIN ${pm.or.administrative_user}.TASKRSRC T1  ON T1.taskrsrc_id         = ResourceAssignmentObjectId
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab ON a.projectobjectid = projects_tab.proj_id AND projects_tab.etl_interval > 0  AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  AND T1.DELETE_SESSION_ID IS NULL
  /
  
--METADATA NAME:RISK_GE TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE  
CREATE OR REPLACE VIEW RISK_GE(OBJECTID, PROJECTOBJECTID, ID, NAME, TOTALCOST, RESOURCEOBJECTID, RISKCATEGORYOBJECTID, RISKTYPE, RISKSTATUS, DESCRIPTION, EFFECT, CAUSE, NOTE, SCORE, SCORETEXT, SCORECOLOR, EXPOSURE, IDENTIFIEDBYRESOURCEOBJECTID, IDENTIFIEDBYRESOURCEID, IDENTIFIEDBYRESOURCENAME, IDENTIFIEDDATE, EXPOSURESTARTDATE, EXPOSUREFINISHDATE, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE)
AS
  SELECT a.risk_id objectid ,
    a.proj_id projectobjectid ,
    a.id id ,
    a.name name ,
    a.total_cost totalcost ,
    a.rsrc_id resourceobjectid ,
    a.category_id riskcategoryobjectid ,
    CASE a.type
      WHEN 'RT_Threat'
      THEN 'Threat'
      WHEN 'RT_Opport'
      THEN 'Opportunity'
      ELSE a.type
    END risktype ,
    CASE a.status
      WHEN 'RS_Propose'
      THEN 'Proposed'
      WHEN 'RS_Open'
      THEN 'Open'
      WHEN 'RS_Active'
      THEN 'Active'
      WHEN 'RS_Reject'
      THEN 'Rejected (Closed)'
      WHEN 'RS_Manage'
      THEN 'Managed (Closed)'
      WHEN 'RS_Impact'
      THEN 'Impacted (Closed)'
      ELSE a.status
    END riskstatus ,
    a.description description ,
    a.effect effect ,
    a.cause cause ,
    a.note note ,
    P.score score ,
    P.scoretext scoretext ,
    P.scorecolor scorecolor ,
    P.exposure exposure ,
    a.identified_by_id identifiedbyresourceobjectid ,
    P.identifiedbyresourceid identifiedbyresourceid ,
    P.identifiedbyresourcename identifiedbyresourcename ,
    a.identified_date identifieddate ,
    P.exposurestartdate exposurestartdate ,
    P.exposurefinishdate exposurefinishdate ,
    a.update_user lastupdateuser ,
    a.update_date lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate
   FROM ${pm.or.administrative_user}.RISK A
  INNER JOIN ${pm.or.administrative_user}.RISKX P  ON a.risk_id               = p.risk_id
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab ON a.proj_id = projects_tab.proj_id AND projects_tab.etl_interval > 0  AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  WHERE A.DELETE_SESSION_ID IS NULL
  /
  
--METADATA NAME:WBS_GE TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE  
CREATE OR REPLACE VIEW WBS_GE(OBJECTID, PROJECTOBJECTID, OBSOBJECTID, SEQUENCENUMBER, CONTAINSSUMMARYDATA, STATUS, CODE, NAME, WBSCATEGORYOBJECTID, PARENTOBJECTID, EARNEDVALUEUSERPERCENT, EARNEDVALUEETCUSERVALUE, ORIGINALBUDGET, INDEPENDENTETCTOTALCOST, INDEPENDENTETCLABORUNITS, ANTICIPATEDSTARTDATE, ANTICIPATEDFINISHDATE, EARNEDVALUECOMPUTETYPE, EARNEDVALUEETCCOMPUTETYPE, CURRENTBUDGET, CURRENTVARIANCE, DISTRIBUTEDCURRENTBUDGET, FINISHDATE, FORECASTFINISHDATE, FORECASTSTARTDATE, FULLNAME, FULLSEQUENCE, OBSNAME, PROJECTID, PROPOSEDBUDGET, STARTDATE, SUMPLANNEDSTARTDATE, SUMPLANNEDFINISHDATE, SUMPLANNEDDURATION, SUMPLANNEDLABORUNITS, SUMPLANNEDNONLABORUNITS, SUMPLANNEDEXPENSECOST, SUMPLANNEDLABORCOST, SUMPLANNEDMATERIALCOST, SUMPLANNEDNONLABORCOST, SUMPLANNEDTOTALCOST, SUMACCOUNTINGVARBYLABORUNITS, SUMACCOUNTINGVARIANCEBYCOST, SUMACTTHISPERIODMATERIALCOST,
  SUMACTTHISPERIODNONLABORCOST, SUMACTTHISPERIODNONLABORUNITS, SUMACTUALTHISPERIODLABORCOST, SUMACTUALTHISPERIODLABORUNITS, SUMATCOMPLETIONMATERIALCOST, SUMATCOMPLETIONNONLABORCOST, SUMATCOMPLETIONNONLABORUNITS, SUMATCOMPLETIONTOTALCOSTVAR, SUMBASELINECOMPACTIVITYCOUNT, SUMBASELINENOTSTARTEDACTCNT, SUMBLINPROGRESSACTIVITYCOUNT, SUMBUDGETATCMPBYLABORUNITS, SUMBUDGETATCOMPLETIONBYCOST, SUMCOSTPERFINDEXBYCOST, SUMCOSTPERFINDEXBYLABORUNITS, SUMCOSTVARIANCEBYLABORUNITS, SUMCOSTVARINDEXBYLABORUNITS, SUMDURATIONPERCENTOFPLANNED, SUMEACBYCOST, SUMEACBYLABORUNITS, SUMEACHIGHPCTBYLABORUNITS, SUMEACLOWPCTBYLABORUNITS, SUMETCBYCOST, SUMETCBYLABORUNITS, SUMEXPENSECOSTPCTCOMPLETE, SUMLABORCOSTPERCENTCOMPLETE, SUMLABORUNITSPERCENTCOMPLETE, SUMACTIVITYCOUNT, SUMACTUALDURATION, SUMACTUALEXPENSECOST, SUMACTUALFINISHDATE, SUMMAXACTUALFINISHDATE, SUMMAXRESTARTDATE, SUMACTUALLABORCOST, SUMACTUALLABORUNITS, SUMACTUALMATERIALCOST,
  SUMACTUALNONLABORCOST, SUMACTUALNONLABORUNITS, SUMACTUALSTARTDATE, SUMACTUALTHISPERIODCOST, SUMACTUALTOTALCOST, SUMACTUALVALUEBYCOST, SUMACTUALVALUEBYLABORUNITS, SUMATCOMPLETIONDURATION, SUMATCOMPLETIONEXPENSECOST, SUMATCOMPLETIONLABORCOST, SUMATCOMPLETIONLABORUNITS, SUMATCOMPLETIONTOTALCOST, SUMBASELINEDURATION, SUMBASELINEEXPENSECOST, SUMBASELINEFINISHDATE, SUMBASELINELABORCOST, SUMBASELINELABORUNITS, SUMBASELINEMATERIALCOST, SUMBASELINENONLABORCOST, SUMBASELINENONLABORUNITS, SUMBASELINESTARTDATE, SUMBASELINETOTALCOST, SUMCOMPLETEDACTIVITYCOUNT, SUMCOSTPERCENTCOMPLETE, SUMCOSTPERCENTOFPLANNED, SUMCOSTVARIANCEBYCOST, SUMCOSTVARIANCEINDEX, SUMCOSTVARIANCEINDEXBYCOST, SUMDURATIONPERCENTCOMPLETE, SUMDURATIONVARIANCE, SUMEARNEDVALUEBYCOST, SUMEARNEDVALUEBYLABORUNITS, SUMEXPENSECOSTVARIANCE, SUMFINISHDATEVARIANCE, SUMINPROGRESSACTIVITYCOUNT, SUMLABORCOSTVARIANCE, SUMLABORUNITSVARIANCE, SUMMATERIALCOSTVARIANCE,
  SUMNONLABORCOSTVARIANCE, SUMNONLABORUNITSVARIANCE, SUMNOTSTARTEDACTIVITYCOUNT, SUMPLANNEDVALUEBYCOST, SUMPROGRESSFINISHDATE, SUMREMAININGDURATION, SUMREMAININGEXPENSECOST, SUMREMAININGFINISHDATE, SUMREMAININGLABORCOST, SUMREMAININGLABORUNITS, SUMREMAININGMATERIALCOST, SUMREMAININGNONLABORCOST, SUMREMAININGNONLABORUNITS, SUMREMAININGSTARTDATE, SUMREMAININGTOTALCOST, SUMSCHEDULEPERCENTCOMPLETE, SUMPERFORMANCEPERCENTCOMPLETE, SUMSCHEDULEVARIANCEBYCOST, SUMSCHEDULEVARIANCEINDEX, SUMSTARTDATEVARIANCE, SUMTOTALCOSTVARIANCE, SUMTOTALFLOAT, SUMUNITSPERCENTCOMPLETE, SUMMATERIALCOSTPCTCOMPLETE, SUMNONLABORCOSTPCTCOMPLETE, SUMNONLABORUNITSPCTCOMPLETE, SUMPERFPCTCMPBYLABORUNITS, SUMPLANNEDVALUEBYLABORUNITS, SUMSCHDPCTCMPBYLABORUNITS, SUMSCHDPERFINDEXBYLABORUNITS, SUMSCHDVARIANCEBYLABORUNITS, SUMSCHDVARIANCEINDEXBYCOST, SUMSCHDVARINDEXBYLABORUNITS, SUMSCHEDULEPERFINDEXBYCOST, SUMTOCOMPLETEPERFINDEXBYCOST,
  SUMVARATCMPBYLABORUNITS, SUMEARLYSTARTDATE, SUMEARLYENDDATE, SUMLATESTARTDATE, SUMLATEENDDATE, SUMMAXCALENDARID, SUMMINCALENDARID, TOTALBENEFITPLAN, TOTALBENEFITPLANTALLY, TOTALSPENDINGPLAN, TOTALSPENDINGPLANTALLY, UNALLOCATEDBUDGET, UNDISTRIBUTEDCURRENTVARIANCE, STATUSREVIEWEROBJECTID, STATUSREVIEWERNAME, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE, LASTUPDATEDATEX, RPT_CURRENT_FLAG, PROJECTNODEFLAG)
AS
  SELECT a.wbs_id objectid ,
    a.proj_id projectobjectid ,
    a.obs_id obsobjectid ,
    a.seq_num sequencenumber ,
    a.sum_data_flag containssummarydata ,
    CASE a.status_code
      WHEN 'WS_Planned'
      THEN 'Planned'
      WHEN 'WS_Open'
      THEN 'Active'
      WHEN 'WS_Closed'
      THEN 'Inactive'
      WHEN 'WS_Whatif'
      THEN 'What If'
      WHEN 'WS_Requested'
      THEN 'Requested'
      WHEN 'WS_Template'
      THEN 'Template'
      WHEN 'WS_Planned'
      THEN 'Planned'
      WHEN 'WS_Open'
      THEN 'Active'
      WHEN 'WS_Closed'
      THEN 'Inactive'
      WHEN 'WS_Whatif'
      THEN 'What If'
      WHEN 'WS_Requested'
      THEN 'Requested'
      WHEN 'WS_Template'
      THEN 'Template'
      ELSE a.status_code
    END status ,
    a.wbs_short_name code ,
    a.wbs_name name ,
    a.phase_id wbscategoryobjectid ,
    a.parent_wbs_id parentobjectid ,
    a.ev_user_pct earnedvalueuserpercent ,
    a.ev_etc_user_value earnedvalueetcuservalue ,
    a.orig_cost originalbudget ,
    a.indep_remain_total_cost independentetctotalcost ,
    a.indep_remain_work_qty independentetclaborunits ,
    a.anticip_start_date anticipatedstartdate ,
    a.anticip_end_date anticipatedfinishdate ,
    CASE a.ev_compute_type
      WHEN 'EC_Cmp_pct'
      THEN 'Activity Percent Complete'
      WHEN 'EC_0_pct'
      THEN 'Zero Hundred'
      WHEN 'EC_50_pct'
      THEN 'Fifty Fifty'
      WHEN 'EC_User_pct'
      THEN 'Custom Percent Complete'
      WHEN 'EC_MS'
      THEN 'WBS Milestones Percent Complete'
      WHEN 'EC_Curve'
      THEN 'Activity Percent Complete Using Resource Curve'
      WHEN 'EC_Cmp_pct'
      THEN 'Activity Percent Complete'
      WHEN 'EC_0_pct'
      THEN 'Zero Hundred'
      WHEN 'EC_50_pct'
      THEN 'Fifty Fifty'
      WHEN 'EC_User_pct'
      THEN 'Custom Percent Complete'
      WHEN 'EC_MS'
      THEN 'WBS Milestones Percent Complete'
      WHEN 'EC_Curve'
      THEN 'Activity Percent Complete Using Resource Curve'
      ELSE a.ev_compute_type
    END earnedvaluecomputetype ,
    CASE a.ev_etc_compute_type
      WHEN 'EE_Rem_hr'
      THEN 'Remaining Cost For Activity'
      WHEN 'EE_PF_1'
      THEN 'PF 1'
      WHEN 'EE_PF_user'
      THEN 'PF Custom'
      WHEN 'EE_PF_cpi'
      THEN 'PF CPI'
      WHEN 'EE_PF_cpi_spi'
      THEN 'PF CPI SPI'
      WHEN 'EE_Rem_hr'
      THEN 'Remaining Cost For Activity'
      WHEN 'EE_PF_1'
      THEN 'PF 1'
      WHEN 'EE_PF_user'
      THEN 'PF Custom'
      WHEN 'EE_PF_cpi'
      THEN 'PF CPI'
      WHEN 'EE_PF_cpi_spi'
      THEN 'PF CPI SPI'
      ELSE a.ev_etc_compute_type
    END earnedvalueetccomputetype ,
    P.currentbudget currentbudget ,
    P.currentvariance currentvariance ,
    P.distributedcurrentbudget distributedcurrentbudget ,
    P.finishdate finishdate ,
    P.forecastfinishdate forecastfinishdate ,
    P.forecaststartdate forecaststartdate ,
    P.fullname fullname ,
    P.fullsequence fullsequence ,
    P.obsname obsname ,
    P.projectid projectid ,
    P.proposedbudget proposedbudget ,
    P.startdate startdate ,
    P.sumplannedstartdate sumplannedstartdate ,
    P.sumplannedfinishdate sumplannedfinishdate ,
    P.sumplannedduration sumplannedduration ,
    P.sumplannedlaborunits sumplannedlaborunits ,
    P.sumplannednonlaborunits sumplannednonlaborunits ,
    P.sumplannedexpensecost sumplannedexpensecost ,
    P.sumplannedlaborcost sumplannedlaborcost ,
    P.sumplannedmaterialcost sumplannedmaterialcost ,
    P.sumplannednonlaborcost sumplannednonlaborcost ,
    P.sumplannedtotalcost sumplannedtotalcost ,
    P.sumaccountingvarbylaborunits sumaccountingvarbylaborunits ,
    P.sumaccountingvariancebycost sumaccountingvariancebycost ,
    P.sumactthisperiodmaterialcost sumactthisperiodmaterialcost ,
    P.sumactthisperiodnonlaborcost sumactthisperiodnonlaborcost ,
    P.sumactthisperiodnonlaborunits sumactthisperiodnonlaborunits ,
    P.sumactualthisperiodlaborcost sumactualthisperiodlaborcost ,
    P.sumactualthisperiodlaborunits sumactualthisperiodlaborunits ,
    P.sumatcompletionmaterialcost sumatcompletionmaterialcost ,
    P.sumatcompletionnonlaborcost sumatcompletionnonlaborcost ,
    P.sumatcompletionnonlaborunits sumatcompletionnonlaborunits ,
    P.sumatcompletiontotalcostvar sumatcompletiontotalcostvar ,
    P.sumbaselinecompactivitycount sumbaselinecompactivitycount ,
    P.sumbaselinenotstartedactcnt sumbaselinenotstartedactcnt ,
    P.sumblinprogressactivitycount sumblinprogressactivitycount ,
    P.sumbudgetatcmpbylaborunits sumbudgetatcmpbylaborunits ,
    P.sumbudgetatcompletionbycost sumbudgetatcompletionbycost ,
    P.sumcostperfindexbycost sumcostperfindexbycost ,
    P.sumcostperfindexbylaborunits sumcostperfindexbylaborunits ,
    P.sumcostvariancebylaborunits sumcostvariancebylaborunits ,
    P.sumcostvarindexbylaborunits sumcostvarindexbylaborunits ,
    P.sumdurationpercentofplanned sumdurationpercentofplanned ,
    P.sumeacbycost sumeacbycost ,
    P.sumeacbylaborunits sumeacbylaborunits ,
    P.sumeachighpctbylaborunits sumeachighpctbylaborunits ,
    P.sumeaclowpctbylaborunits sumeaclowpctbylaborunits ,
    P.sumetcbycost sumetcbycost ,
    P.sumetcbylaborunits sumetcbylaborunits ,
    P.sumexpensecostpctcomplete sumexpensecostpctcomplete ,
    P.sumlaborcostpercentcomplete sumlaborcostpercentcomplete ,
    P.sumlaborunitspercentcomplete sumlaborunitspercentcomplete ,
    P.sumactivitycount sumactivitycount ,
    P.sumactualduration sumactualduration ,
    P.sumactualexpensecost sumactualexpensecost ,
    P.sumactualfinishdate sumactualfinishdate ,
    P.summaxactualfinishdate summaxactualfinishdate ,
    P.summaxrestartdate summaxrestartdate ,
    P.sumactuallaborcost sumactuallaborcost ,
    P.sumactuallaborunits sumactuallaborunits ,
    P.sumactualmaterialcost sumactualmaterialcost ,
    P.sumactualnonlaborcost sumactualnonlaborcost ,
    P.sumactualnonlaborunits sumactualnonlaborunits ,
    P.sumactualstartdate sumactualstartdate ,
    P.sumactualthisperiodcost sumactualthisperiodcost ,
    P.sumactualtotalcost sumactualtotalcost ,
    P.sumactualvaluebycost sumactualvaluebycost ,
    P.sumactualvaluebylaborunits sumactualvaluebylaborunits ,
    P.sumatcompletionduration sumatcompletionduration ,
    P.sumatcompletionexpensecost sumatcompletionexpensecost ,
    P.sumatcompletionlaborcost sumatcompletionlaborcost ,
    P.sumatcompletionlaborunits sumatcompletionlaborunits ,
    P.sumatcompletiontotalcost sumatcompletiontotalcost ,
    P.sumbaselineduration sumbaselineduration ,
    P.sumbaselineexpensecost sumbaselineexpensecost ,
    P.sumbaselinefinishdate sumbaselinefinishdate ,
    P.sumbaselinelaborcost sumbaselinelaborcost ,
    P.sumbaselinelaborunits sumbaselinelaborunits ,
    P.sumbaselinematerialcost sumbaselinematerialcost ,
    P.sumbaselinenonlaborcost sumbaselinenonlaborcost ,
    P.sumbaselinenonlaborunits sumbaselinenonlaborunits ,
    P.sumbaselinestartdate sumbaselinestartdate ,
    P.sumbaselinetotalcost sumbaselinetotalcost ,
    P.sumcompletedactivitycount sumcompletedactivitycount ,
    P.sumcostpercentcomplete sumcostpercentcomplete ,
    P.sumcostpercentofplanned sumcostpercentofplanned ,
    P.sumcostvariancebycost sumcostvariancebycost ,
    P.sumcostvarianceindex sumcostvarianceindex ,
    P.sumcostvarianceindexbycost sumcostvarianceindexbycost ,
    P.sumdurationpercentcomplete sumdurationpercentcomplete ,
    P.sumdurationvariance sumdurationvariance ,
    P.sumearnedvaluebycost sumearnedvaluebycost ,
    P.sumearnedvaluebylaborunits sumearnedvaluebylaborunits ,
    P.sumexpensecostvariance sumexpensecostvariance ,
    P.sumfinishdatevariance sumfinishdatevariance ,
    P.suminprogressactivitycount suminprogressactivitycount ,
    P.sumlaborcostvariance sumlaborcostvariance ,
    P.sumlaborunitsvariance sumlaborunitsvariance ,
    P.summaterialcostvariance summaterialcostvariance ,
    P.sumnonlaborcostvariance sumnonlaborcostvariance ,
    P.sumnonlaborunitsvariance sumnonlaborunitsvariance ,
    P.sumnotstartedactivitycount sumnotstartedactivitycount ,
    P.sumplannedvaluebycost sumplannedvaluebycost ,
    P.sumprogressfinishdate sumprogressfinishdate ,
    P.sumremainingduration sumremainingduration ,
    P.sumremainingexpensecost sumremainingexpensecost ,
    P.sumremainingfinishdate sumremainingfinishdate ,
    P.sumremaininglaborcost sumremaininglaborcost ,
    P.sumremaininglaborunits sumremaininglaborunits ,
    P.sumremainingmaterialcost sumremainingmaterialcost ,
    P.sumremainingnonlaborcost sumremainingnonlaborcost ,
    P.sumremainingnonlaborunits sumremainingnonlaborunits ,
    P.sumremainingstartdate sumremainingstartdate ,
    P.sumremainingtotalcost sumremainingtotalcost ,
    P.sumschedulepercentcomplete sumschedulepercentcomplete ,
    P.sumperformancepercentcomplete sumperformancepercentcomplete ,
    P.sumschedulevariancebycost sumschedulevariancebycost ,
    P.sumschedulevarianceindex sumschedulevarianceindex ,
    P.sumstartdatevariance sumstartdatevariance ,
    P.sumtotalcostvariance sumtotalcostvariance ,
    P.sumtotalfloat sumtotalfloat ,
    P.sumunitspercentcomplete sumunitspercentcomplete ,
    P.summaterialcostpctcomplete summaterialcostpctcomplete ,
    P.sumnonlaborcostpctcomplete sumnonlaborcostpctcomplete ,
    P.sumnonlaborunitspctcomplete sumnonlaborunitspctcomplete ,
    P.sumperfpctcmpbylaborunits sumperfpctcmpbylaborunits ,
    P.sumplannedvaluebylaborunits sumplannedvaluebylaborunits ,
    P.sumschdpctcmpbylaborunits sumschdpctcmpbylaborunits ,
    P.sumschdperfindexbylaborunits sumschdperfindexbylaborunits ,
    P.sumschdvariancebylaborunits sumschdvariancebylaborunits ,
    P.sumschdvarianceindexbycost sumschdvarianceindexbycost ,
    P.sumschdvarindexbylaborunits sumschdvarindexbylaborunits ,
    P.sumscheduleperfindexbycost sumscheduleperfindexbycost ,
    P.sumtocompleteperfindexbycost sumtocompleteperfindexbycost ,
    P.sumvaratcmpbylaborunits sumvaratcmpbylaborunits ,
    P.sumearlystartdate sumearlystartdate ,
    P.sumearlyenddate sumearlyenddate ,
    P.sumlatestartdate sumlatestartdate ,
    P.sumlateenddate sumlateenddate ,
    P.summaxcalendarid summaxcalendarid ,
    P.summincalendarid summincalendarid ,
    P.totalbenefitplan totalbenefitplan ,
    P.totalbenefitplantally totalbenefitplantally ,
    P.totalspendingplan totalspendingplan ,
    P.totalspendingplantally totalspendingplantally ,
    P.unallocatedbudget unallocatedbudget ,
    P.undistributedcurrentvariance undistributedcurrentvariance ,
    a.status_reviewer statusreviewerobjectid ,
    P.statusreviewername statusreviewername ,
    a.update_user lastupdateuser ,
    a.update_date lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate ,
    P.update_dim_date lastupdatedatex ,
    CASE
      WHEN a.update_date>P.update_date
      THEN 'N'
      ELSE 'Y'
    END rpt_current_flag ,
    A.proj_node_flag
   FROM ${pm.or.administrative_user}.PROJWBS A
  INNER JOIN ${pm.or.administrative_user}.PROJWBSX P
  ON a.wbs_id = p.wbs_id
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab
  ON a.proj_id                   = projects_tab.proj_id
  WHERE A.DELETE_SESSION_ID     IS NULL
  AND projects_tab.etl_interval > 0 
  AND projects_tab.PROJECT_FLAG = 'Y'
  AND projects_tab.ORIG_PROJ_ID IS NULL
  /
  
--METADATA NAME:REFRDELETE_GE TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE  
CREATE OR REPLACE VIEW REFRDELETE_GE(LASTUPDATEDATE, TABLENAME, OBJECTID, OBJECTID2, OBJECTID3, OBJECTID4, PROJECTOBJECTID)
AS
  SELECT a.DELETE_DATE,
    a.TABLE_NAME,
    a.PK1,
    a.PK2,
    a.PK3,
    a.PK4,
    a.PROJ_ID
  FROM ${pm.or.administrative_user}.REFRDEL a
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab ON a.proj_id = projects_tab.proj_id AND projects_tab.etl_interval > 0  AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  /
  
--METADATA NAME:WBSHIERARCHY_GE TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE  
CREATE OR REPLACE VIEW WBSHIERARCHY_GE(PARENTOBJECTID, PARENTPROJECTID, PARENTSEQUENCENUMBER, PARENTNAME, PARENTID, CHILDOBJECTID, CHILDPROJECTID, CHILDSEQUENCENUMBER, CHILDNAME, CHILDID, PARENTLEVELSBELOWROOT, CHILDLEVELSBELOWROOT, LEVELSBETWEEN, CHILDHASCHILDREN, FULLPATHNAME, LASTUPDATEDATE)
AS
  SELECT a.PARENTOBJECTID,
    a.PARENTPROJECTID,
    a.PARENTSEQUENCENUMBER,
    a.PARENTNAME,
    a.PARENTID,
    a.CHILDOBJECTID,
    a.CHILDPROJECTID,
    a.CHILDSEQUENCENUMBER,
    a.CHILDNAME,
    a.CHILDID,
    a.PARENTLEVELSBELOWROOT,
    a.CHILDLEVELSBELOWROOT,
    a.LEVELSBETWEEN,
    a.CHILDHASCHILDREN,
    a.FULLPATHNAME,
    a.update_date
   FROM ${pm.or.administrative_user}.WBSHIERARCHY a
  INNER JOIN ${pm.or.administrative_user}.PROJWBS T1  ON T1.wbs_id              = ParentObjectId  AND T1.DELETE_SESSION_ID IS NULL
  INNER JOIN ${pm.or.administrative_user}.PROJWBS T2  ON T2.wbs_id              = ChildObjectId  AND T2.DELETE_SESSION_ID IS NULL
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab ON T1.proj_id = projects_tab.proj_id AND projects_tab.etl_interval > 0  AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  /
  
--METADATA NAME:PROJECTCODEASSIGNMENT_GE TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE  
CREATE OR REPLACE VIEW PROJECTCODEASSIGNMENT_GE(PROJECTOBJECTID, PROJECTCODETYPEOBJECTID, PROJECTCODEOBJECTID, PROJECTCODEDESCRIPTION, PROJECTCODETYPENAME, PROJECTCODEVALUE, PROJECTNAME, ISSECURECODE, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE)
AS
  SELECT a.proj_id projectobjectid ,
    a.proj_catg_type_id projectcodetypeobjectid ,
    a.proj_catg_id projectcodeobjectid ,
    P.projectcodedescription projectcodedescription ,
    P.projectcodetypename projectcodetypename ,
    P.projectcodevalue projectcodevalue ,
    P.projectname projectname ,
    P.issecurecode issecurecode ,
    a.update_user lastupdateuser ,
    CASE
      WHEN a.update_date > P.update_date
      THEN a.update_date
      ELSE P.update_date
    END lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate
   FROM ${pm.or.administrative_user}.PROJPCAT A
  INNER JOIN ${pm.or.administrative_user}.PROJPCATX P  ON a.proj_id               = p.proj_id  AND a.proj_catg_type_id    = p.proj_catg_type_id
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab ON a.proj_id = projects_tab.proj_id AND projects_tab.etl_interval > 0  AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  WHERE A.DELETE_SESSION_ID IS NULL
  /
  
--METADATA NAME:ACTIVITYCODEASSIGNMENT_GE TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYCODEASSIGNMENT_GE(ACTIVITYOBJECTID, ACTIVITYCODETYPEOBJECTID, ACTIVITYCODEOBJECTID, PROJECTOBJECTID, ACTIVITYCODEDESCRIPTION, ACTIVITYCODETYPENAME, ACTIVITYCODETYPESCOPE, ACTIVITYCODEVALUE, ACTIVITYID, ACTIVITYNAME, ISSECURECODE, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE)
AS
  SELECT a.task_id activityobjectid ,
    a.actv_code_type_id activitycodetypeobjectid ,
    a.actv_code_id activitycodeobjectid ,
    a.proj_id projectobjectid ,
    P.activitycodedescription activitycodedescription ,
    P.activitycodetypename activitycodetypename ,
    P.activitycodetypescope activitycodetypescope ,
    P.activitycodevalue activitycodevalue ,
    P.activityid activityid ,
    P.activityname activityname ,
    P.issecurecode issecurecode ,
    a.update_user lastupdateuser ,
    CASE
      WHEN a.update_date > P.update_date
      THEN a.update_date
      ELSE P.update_date
    END lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate
   FROM ${pm.or.administrative_user}.TASKACTV A
  INNER JOIN ${pm.or.administrative_user}.TASKACTVX P  ON a.task_id               = p.task_id  AND a.actv_code_type_id    = p.actv_code_type_id
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab ON a.proj_id = projects_tab.proj_id AND projects_tab.etl_interval > 0  AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  WHERE A.DELETE_SESSION_ID IS NULL
  /
  
--METADATA NAME:ACTIVITYCODE_GE TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE  
CREATE OR REPLACE VIEW ACTIVITYCODE_GE(OBJECTID, CODETYPEOBJECTID, SEQUENCENUMBER, CODEVALUE, PARENTOBJECTID, DESCRIPTION, CODETYPENAME, ISSECURECODE, PROJECTOBJECTID, CODETYPESCOPE, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE)
AS
  SELECT a.actv_code_id objectid ,
    a.actv_code_type_id codetypeobjectid ,
    a.seq_num sequencenumber ,
    a.short_name codevalue ,
    a.parent_actv_code_id parentobjectid ,
    a.actv_code_name description ,
    P.codetypename codetypename ,
    P.issecurecode issecurecode ,
    P.projectobjectid projectobjectid ,
    P.codetypescope codetypescope ,
    a.update_user lastupdateuser ,
    CASE
      WHEN a.update_date > P.update_date
      THEN a.update_date
      ELSE P.update_date
    END lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate
   FROM ${pm.or.administrative_user}.ACTVCODE A
  INNER JOIN ${pm.or.administrative_user}.ACTVCODEX P  ON a.actv_code_id          = p.actv_code_id
  WHERE A.DELETE_SESSION_ID IS NULL
  /
  
--METADATA NAME:ACTIVITYCODETYPE_GE TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE  
CREATE OR REPLACE VIEW ACTIVITYCODETYPE_GE(OBJECTID, LENGTH, SEQUENCENUMBER, NAME, SCOPE, PROJECTOBJECTID, EPSOBJECTID, ISSECURECODE, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE)
AS
  SELECT a.actv_code_type_id objectid ,
    a.actv_short_len LENGTH ,
    a.seq_num sequencenumber ,
    a.actv_code_type name ,
    CASE a.actv_code_type_scope
      WHEN 'AS_Global'
      THEN 'Global'
      WHEN 'AS_EPS'
      THEN 'EPS'
      WHEN 'AS_Project'
      THEN 'Project'
      ELSE a.actv_code_type_scope
    END scope ,
    CASE
      WHEN a.actv_code_type_scope = 'AS_Project'
      THEN a.proj_id
      ELSE NULL
    END projectobjectid ,
    CASE
      WHEN a.actv_code_type_scope = 'AS_EPS'
      THEN
        (SELECT MIN(p.wbs_id)
         FROM ${pm.or.administrative_user}.projwbs p
        WHERE p.proj_id     =a.proj_id
        AND p.proj_node_flag='Y'
        )
      ELSE NULL
    END epsobjectid ,
    a.super_flag issecurecode ,
    a.update_user lastupdateuser ,
    a.update_date lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate
   FROM ${pm.or.administrative_user}.ACTVTYPE A
  WHERE A.DELETE_SESSION_ID IS NULL
  /
  
--METADATA NAME:CALENDAR_GE TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE  
CREATE OR REPLACE VIEW CALENDAR_GE(OBJECTID, ISDEFAULT, NAME, PROJECTOBJECTID, BASECALENDAROBJECTID, LASTCHANGEDATE, TYPE, DAYDATE, WEEKDAYNUMBER, WORKDAYFLAG, TOTALWORKHOURS, WORKHOURSBYHALFHOUR, WORKDAYSTARTTIME, WORKDAYFINISHTIME, LASTUPDATEDATE)
AS
  SELECT a.clndr_id objectid ,
    a.default_flag isdefault ,
    a.clndr_name name ,
    a.proj_id projectobjectid ,
    a.base_clndr_id basecalendarobjectid ,
    a.last_chng_date lastchangedate ,
    CASE a.clndr_type
      WHEN 'CA_Base'
      THEN 'Global'
      WHEN 'CA_Project'
      THEN 'Project'
      WHEN 'CA_Rsrc'
      THEN 'Resource'
      ELSE a.clndr_type
    END type ,
    P.daydate daydate ,
    P.weekdaynumber weekdaynumber ,
    P.workdayflag workdayflag ,
    P.totalworkhours totalworkhours ,
    P.workhoursbyhalfhour workhoursbyhalfhour ,
    P.workdaystarttime workdaystarttime ,
    P.workdayfinishtime workdayfinishtime,
    CASE
      WHEN A.UPDATE_DATE > P.UPDATE_DATE
      THEN A.UPDATE_DATE
      ELSE P.UPDATE_DATE
    END LASTUPDATEDATE
   FROM ${pm.or.administrative_user}.CALENDAR A
  INNER JOIN ${pm.or.administrative_user}.CALENDARX P  ON a.clndr_id              = p.clndr_id
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab ON a.proj_id = projects_tab.proj_id AND projects_tab.etl_interval > 0  AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  WHERE A.DELETE_SESSION_ID IS NULL
  /
  
--METADATA NAME:PROJECTSECURITY_GE TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE  
CREATE OR REPLACE VIEW PROJECTSECURITY_GE(RDBMSUSERID, PROJECTOBJECTID, COSTFLAG, LASTUPDATEDATE)
AS
  SELECT a.RDBMSUSERID,
    a.PROJECTOBJECTID,
    a.COSTFLAG,
    a.update_date
   FROM ${pm.or.administrative_user}.PROJECTSECURITY a
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab ON a.PROJECTOBJECTID = projects_tab.proj_id AND projects_tab.etl_interval > 0  AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  /
  
--METADATA NAME:RESASSIGNMENTPERIODACTUAL_GE TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE 
CREATE OR REPLACE VIEW RESASSIGNMENTPERIODACTUAL_GE (FINANCIALPERIODOBJECTID, STARTDATE, ENDDATE, RESOURCEASSIGNMENTOBJECTID, ACTIVITYOBJECTID, PROJECTOBJECTID, ACTUALUNITS, ACTUALCOST, RESOURCETYPE, WBSOBJECTID, RESOURCEOBJECTID, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE) AS 
SELECT a.fin_dates_id financialperiodobjectid
,fd.start_date startdate
,fd.end_date enddate
,a.taskrsrc_id resourceassignmentobjectid
,a.task_id activityobjectid
,a.proj_id projectobjectid
,a.act_qty actualunits
,a.act_cost actualcost
,P.resourcetype resourcetype
,P.wbsobjectid wbsobjectid
,T.rsrc_id resourceobjectid
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.TRSRCFIN A 
INNER JOIN ${pm.or.administrative_user}.TRSRCFINX P
ON a.fin_dates_id = p.fin_dates_id and a.taskrsrc_id = p.taskrsrc_id
INNER JOIN ${pm.or.administrative_user}.taskrsrc T
ON a.taskrsrc_id = T.taskrsrc_id and a.proj_id = t.proj_id 
INNER JOIN ${pm.or.administrative_user}.FINDATES FD
ON a.fin_dates_id = fd.fin_dates_id 
INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab on a.proj_id = projects_tab.proj_id AND projects_tab.etl_interval > 0 AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
WHERE A.DELETE_SESSION_ID is null
/

--METADATA NAME:ACTIVITYPERIODACTUAL_GE TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE 
CREATE OR REPLACE VIEW ACTIVITYPERIODACTUAL_GE (FINANCIALPERIODOBJECTID, STARTDATE, ENDDATE, ACTIVITYOBJECTID, PROJECTOBJECTID, ACTUALLABORUNITS, ACTUALLABORCOST, ACTUALNONLABORUNITS, ACTUALNONLABORCOST, ACTUALMATERIALCOST, ACTUALEXPENSECOST, EARNEDVALUECOST, PLANNEDVALUELABORUNITS, PLANNEDVALUECOST, EARNEDVALUELABORUNITS, WBSOBJECTID, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE) AS 
SELECT a.fin_dates_id financialperiodobjectid
,fd.start_date startdate
,fd.end_date enddate
,a.task_id activityobjectid
,a.proj_id projectobjectid
,a.act_work_qty actuallaborunits
,a.act_work_cost actuallaborcost
,a.act_equip_qty actualnonlaborunits
,a.act_equip_cost actualnonlaborcost
,a.act_mat_cost actualmaterialcost
,a.act_expense_cost actualexpensecost
,a.bcwp earnedvaluecost
,a.sched_work_qty plannedvaluelaborunits
,a.bcws plannedvaluecost
,a.perfm_work_qty earnedvaluelaborunits
,P.wbsobjectid wbsobjectid
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.TASKFIN A 
INNER JOIN ${pm.or.administrative_user}.TASKFINX P
ON a.fin_dates_id = p.fin_dates_id and a.task_id = p.task_id
INNER JOIN ${pm.or.administrative_user}.FINDATES FD
ON a.fin_dates_id = fd.fin_dates_id 
INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab on a.proj_id = projects_tab.proj_id AND projects_tab.etl_interval > 0 AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
WHERE A.DELETE_SESSION_ID is null
/
--METADATA NAME:ACTIVITY_RT TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITY_RT (OBJECTID, PROJECTOBJECTID, WBSOBJECTID, CALENDAROBJECTID, ISNEWFEEDBACK, AUTOCOMPUTEACTUALS, PERCENTCOMPLETETYPE, TYPE, DURATIONTYPE, REVIEWSTATUS, STATUS, ID, NAME, PRIMARYRESOURCEOBJECTID, TOTALFLOAT, FREEFLOAT, REMAININGDURATION, ACTUALLABORUNITS, REMAININGLABORUNITS, PLANNEDLABORUNITS, PLANNEDDURATION, PLANNEDNONLABORUNITS, ACTUALNONLABORUNITS, REMAININGNONLABORUNITS, PRIMARYCONSTRAINTDATE, ACTUALSTARTDATE, ACTUALFINISHDATE, LATESTARTDATE, LATEFINISHDATE, EXPECTEDFINISHDATE, EARLYSTARTDATE, EARLYFINISHDATE, REMAININGEARLYSTARTDATE, REMAININGEARLYFINISHDATE, PLANNEDSTARTDATE, PLANNEDFINISHDATE, REVIEWFINISHDATE, REMAININGLATESTARTDATE, REMAININGLATEFINISHDATE, PRIMARYCONSTRAINTTYPE, LEVELINGPRIORITY, SECONDARYCONSTRAINTDATE, SECONDARYCONSTRAINTTYPE, FLOATPATH, FLOATPATHORDER, ACTUALTHISPERIODLABORUNITS,
  ACTUALTHISPERIODNONLABORUNITS, ISLONGESTPATH, SUSPENDDATE, RESUMEDATE, EXTERNALEARLYSTARTDATE, EXTERNALLATEFINISHDATE, ACCOUNTINGVARIANCE, ACCOUNTINGVARIANCELABORUNITS, ACTUALDURATION, ACTUALEXPENSECOST, ACTUALLABORCOST, ACTUALMATERIALCOST, ACTUALNONLABORCOST, ACTUALTHISPERIODLABORCOST, ACTUALTHISPERIODMATERIALCOST, ACTUALTHISPERIODNONLABORCOST, ACTUALTOTALCOST, ACTUALTOTALUNITS, ATCOMPLETIONDURATION, ATCOMPLETIONEXPENSECOST, ATCOMPLETIONLABORCOST, ATCOMPLETIONLABORUNITS, ATCOMPLETIONLABORUNITSVARIANCE, ATCOMPLETIONMATERIALCOST, ATCOMPLETIONNONLABORCOST, ATCOMPLETIONNONLABORUNITS, ATCOMPLETIONTOTALCOST, ATCOMPLETIONTOTALUNITS, ATCOMPLETIONVARIANCE, BASELINEDURATION, BASELINEFINISHDATE, BASELINEPLANNEDDURATION, BASELINEPLANNEDEXPENSECOST, BASELINEPLANNEDLABORCOST, BASELINEPLANNEDLABORUNITS, BASELINEPLANNEDMATERIALCOST, BASELINEPLANNEDNONLABORCOST, BASELINEPLANNEDNONLABORUNITS, BASELINEPLANNEDTOTALCOST,
  BASELINESTARTDATE, BUDGETATCOMPLETION, CALENDARNAME, COSTPERCENTCOMPLETE, COSTPERCENTOFPLANNED, COSTPERFORMANCEINDEX, COSTPERFORMANCEINDEXLABORUNITS, COSTVARIANCE, COSTVARIANCEINDEX, COSTVARIANCEINDEXLABORUNITS, COSTVARIANCELABORUNITS, DATADATE, DURATION1VARIANCE, DURATIONPERCENTCOMPLETE, DURATIONPERCENTOFPLANNED, DURATIONVARIANCE, EARNEDVALUECOST, EARNEDVALUELABORUNITS, ESTIMATEATCOMPLETIONCOST, ESTIMATEATCOMPLETIONLABORUNITS, ESTIMATETOCOMPLETE, ESTIMATETOCOMPLETELABORUNITS, EXPENSECOST1VARIANCE, EXPENSECOSTPERCENTCOMPLETE, EXPENSECOSTVARIANCE, FINISHDATE, FINISHDATE1VARIANCE, FINISHDATEVARIANCE, ISCRITICAL, LABORCOST1VARIANCE, LABORCOSTPERCENTCOMPLETE, LABORCOSTVARIANCE, LABORUNITS1VARIANCE, LABORUNITSPERCENTCOMPLETE, LABORUNITSVARIANCE, MATERIALCOST1VARIANCE, MATERIALCOSTPERCENTCOMPLETE, MATERIALCOSTVARIANCE, NONLABORCOST1VARIANCE, NONLABORCOSTPERCENTCOMPLETE, NONLABORCOSTVARIANCE,
  NONLABORUNITS1VARIANCE, NONLABORUNITSPERCENTCOMPLETE, NONLABORUNITSVARIANCE, PERCENTCOMPLETE, PERFORMANCEPERCENTCOMPLETE, PHYSICALPERCENTCOMPLETE, PLANNEDEXPENSECOST, PLANNEDLABORCOST, PLANNEDMATERIALCOST, PLANNEDNONLABORCOST, PLANNEDTOTALCOST, PLANNEDTOTALUNITS, PLANNEDVALUECOST, PLANNEDVALUELABORUNITS, PRIMARYRESOURCEID, PRIMARYRESOURCENAME, REMAININGEXPENSECOST, REMAININGFLOAT, REMAININGLABORCOST, REMAININGMATERIALCOST, REMAININGNONLABORCOST, REMAININGTOTALCOST, REMAININGTOTALUNITS, SCHEDULEPERCENTCOMPLETE, SCHEDULEPERFINDEXLABORUNITS, SCHEDULEPERFORMANCEINDEX, SCHEDULEVARIANCE, SCHEDULEVARIANCEINDEX, SCHEDULEVARIANCELABORUNITS, SCHEDULEVARINDEXLABORUNITS, STARTDATE, STARTDATE1VARIANCE, STARTDATEVARIANCE, TOCOMPLETEPERFORMANCEINDEX, TOTALCOST1VARIANCE, TOTALCOSTVARIANCE, UNITSPERCENTCOMPLETE, WBSCODE, WBSNAME, LOCATIONOBJECTID, LOCATIONNAME, REVIEWREQUIRED, ISSTARRED, CBSCODE,
  LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE, LASTUPDATEDATEX, ACTIVITYOWNEROBJECTID, ACTIVITYOWNER, RPT_CURRENT_FLAG)
AS
  SELECT a.task_id objectid ,
    a.proj_id projectobjectid ,
    a.wbs_id wbsobjectid ,
    a.clndr_id calendarobjectid ,
    a.rev_fdbk_flag isnewfeedback ,
    a.auto_compute_act_flag autocomputeactuals ,
    CASE a.complete_pct_type
      WHEN 'CP_Phys'
      THEN 'Physical'
      WHEN 'CP_Drtn'
      THEN 'Duration'
      WHEN 'CP_Units'
      THEN 'Units'
      ELSE a.complete_pct_type
    END percentcompletetype ,
    CASE a.task_type
      WHEN 'TT_Task'
      THEN 'Task Dependent'
      WHEN 'TT_Rsrc'
      THEN 'Resource Dependent'
      WHEN 'TT_LOE'
      THEN 'Level Of Effort'
      WHEN 'TT_Mile'
      THEN 'Start Milestone'
      WHEN 'TT_FinMile'
      THEN 'Finish Milestone'
      WHEN 'TT_WBS'
      THEN 'WBS Summary'
      ELSE a.task_type
    END type ,
    CASE a.duration_type
      WHEN 'DT_FixedRate'
      THEN 'Fixed Units/Time'
      WHEN 'DT_FixedDrtn'
      THEN 'Fixed Duration and Units/Time'
      WHEN 'DT_FixedQty'
      THEN 'Fixed Units'
      WHEN 'DT_FixedDUR2'
      THEN 'Fixed Duration and Units'
      ELSE a.duration_type
    END durationtype ,
    CASE a.review_type
      WHEN 'RV_OK'
      THEN 'OK'
      WHEN 'RV_Review'
      THEN 'For Review'
      WHEN 'RV_Reject'
      THEN 'Rejected'
      ELSE a.review_type
    END reviewstatus ,
    CASE a.status_code
      WHEN 'TK_NotStart'
      THEN 'Not Started'
      WHEN 'TK_Active'
      THEN 'In Progress'
      WHEN 'TK_Complete'
      THEN 'Completed'
      ELSE a.status_code
    END status ,
    a.task_code id ,
    a.task_name name ,
    a.rsrc_id primaryresourceobjectid ,
    a.total_float_hr_cnt totalfloat ,
    a.free_float_hr_cnt freefloat ,
    a.remain_drtn_hr_cnt remainingduration ,
    a.act_work_qty actuallaborunits ,
    a.remain_work_qty remaininglaborunits ,
    a.target_work_qty plannedlaborunits ,
    a.target_drtn_hr_cnt plannedduration ,
    a.target_equip_qty plannednonlaborunits ,
    a.act_equip_qty actualnonlaborunits ,
    a.remain_equip_qty remainingnonlaborunits ,
    a.cstr_date primaryconstraintdate ,
    a.act_start_date actualstartdate ,
    a.act_end_date actualfinishdate ,
    a.late_start_date latestartdate ,
    a.late_end_date latefinishdate ,
    a.expect_end_date expectedfinishdate ,
    a.early_start_date earlystartdate ,
    a.early_end_date earlyfinishdate ,
    a.restart_date remainingearlystartdate ,
    a.reend_date remainingearlyfinishdate ,
    a.target_start_date plannedstartdate ,
    a.target_end_date plannedfinishdate ,
    a.review_end_date reviewfinishdate ,
    a.rem_late_start_date remaininglatestartdate ,
    a.rem_late_end_date remaininglatefinishdate ,
    CASE a.cstr_type
      WHEN 'CS_MSO'
      THEN 'Start On'
      WHEN 'CS_MSOB'
      THEN 'Start On or Before'
      WHEN 'CS_MSOA'
      THEN 'Start On or After'
      WHEN 'CS_MEO'
      THEN 'Finish On'
      WHEN 'CS_MEOB'
      THEN 'Finish On or Before'
      WHEN 'CS_MEOA'
      THEN 'Finish On or After'
      WHEN 'CS_ALAP'
      THEN 'As Late As Possible'
      WHEN 'CS_MANDSTART'
      THEN 'Mandatory Start'
      WHEN 'CS_MANDFIN'
      THEN 'Mandatory Finish'
      ELSE a.cstr_type
    END primaryconstrainttype ,
    CASE a.priority_type
      WHEN 'PT_Top'
      THEN 'Top'
      WHEN 'PT_High'
      THEN 'High'
      WHEN 'PT_Normal'
      THEN 'Normal'
      WHEN 'PT_Low'
      THEN 'Low'
      WHEN 'PT_Lowest'
      THEN 'Lowest'
      ELSE a.priority_type
    END levelingpriority ,
    a.cstr_date2 secondaryconstraintdate ,
    CASE a.cstr_type2
      WHEN 'CS_MSO'
      THEN 'Start On'
      WHEN 'CS_MSOB'
      THEN 'Start On or Before'
      WHEN 'CS_MSOA'
      THEN 'Start On or After'
      WHEN 'CS_MEO'
      THEN 'Finish On'
      WHEN 'CS_MEOB'
      THEN 'Finish On or Before'
      WHEN 'CS_MEOA'
      THEN 'Finish On or After'
      WHEN 'CS_ALAP'
      THEN 'As Late As Possible'
      WHEN 'CS_MANDSTART'
      THEN 'Mandatory Start'
      WHEN 'CS_MANDFIN'
      THEN 'Mandatory Finish'
      ELSE a.cstr_type2
    END secondaryconstrainttype ,
    a.float_path floatpath ,
    a.float_path_order floatpathorder ,
    a.act_this_per_work_qty actualthisperiodlaborunits ,
    a.act_this_per_equip_qty actualthisperiodnonlaborunits ,
    a.driving_path_flag islongestpath ,
    a.suspend_date suspenddate ,
    a.resume_date resumedate ,
    a.external_early_start_date externalearlystartdate ,
    a.external_late_end_date externallatefinishdate ,
    P.accountingvariance accountingvariance ,
    P.accountingvariancelaborunits accountingvariancelaborunits ,
    P.actualduration actualduration ,
    P.actualexpensecost actualexpensecost ,
    P.actuallaborcost actuallaborcost ,
    P.actualmaterialcost actualmaterialcost ,
    P.actualnonlaborcost actualnonlaborcost ,
    P.actualthisperiodlaborcost actualthisperiodlaborcost ,
    P.actualthisperiodmaterialcost actualthisperiodmaterialcost ,
    P.actualthisperiodnonlaborcost actualthisperiodnonlaborcost ,
    P.actualtotalcost actualtotalcost ,
    P.actualtotalunits actualtotalunits ,
    P.atcompletionduration atcompletionduration ,
    P.atcompletionexpensecost atcompletionexpensecost ,
    P.atcompletionlaborcost atcompletionlaborcost ,
    P.atcompletionlaborunits atcompletionlaborunits ,
    P.atcompletionlaborunitsvariance atcompletionlaborunitsvariance ,
    P.atcompletionmaterialcost atcompletionmaterialcost ,
    P.atcompletionnonlaborcost atcompletionnonlaborcost ,
    P.atcompletionnonlaborunits atcompletionnonlaborunits ,
    P.atcompletiontotalcost atcompletiontotalcost ,
    P.atcompletiontotalunits atcompletiontotalunits ,
    P.atcompletionvariance atcompletionvariance ,
    P.baselineduration baselineduration ,
    P.baselinefinishdate baselinefinishdate ,
    P.baselineplannedduration baselineplannedduration ,
    P.baselineplannedexpensecost baselineplannedexpensecost ,
    P.baselineplannedlaborcost baselineplannedlaborcost ,
    P.baselineplannedlaborunits baselineplannedlaborunits ,
    P.baselineplannedmaterialcost baselineplannedmaterialcost ,
    P.baselineplannednonlaborcost baselineplannednonlaborcost ,
    P.baselineplannednonlaborunits baselineplannednonlaborunits ,
    P.baselineplannedtotalcost baselineplannedtotalcost ,
    P.baselinestartdate baselinestartdate ,
    P.budgetatcompletion budgetatcompletion ,
    P.calendarname calendarname ,
    P.costpercentcomplete costpercentcomplete ,
    P.costpercentofplanned costpercentofplanned ,
    P.costperformanceindex costperformanceindex ,
    P.costperformanceindexlaborunits costperformanceindexlaborunits ,
    P.costvariance costvariance ,
    P.costvarianceindex costvarianceindex ,
    P.costvarianceindexlaborunits costvarianceindexlaborunits ,
    P.costvariancelaborunits costvariancelaborunits ,
    P.datadate datadate ,
    P.duration1variance duration1variance ,
    P.durationpercentcomplete durationpercentcomplete ,
    P.durationpercentofplanned durationpercentofplanned ,
    P.durationvariance durationvariance ,
    P.earnedvaluecost earnedvaluecost ,
    P.earnedvaluelaborunits earnedvaluelaborunits ,
    P.estimateatcompletioncost estimateatcompletioncost ,
    P.estimateatcompletionlaborunits estimateatcompletionlaborunits ,
    P.estimatetocomplete estimatetocomplete ,
    P.estimatetocompletelaborunits estimatetocompletelaborunits ,
    P.expensecost1variance expensecost1variance ,
    P.expensecostpercentcomplete expensecostpercentcomplete ,
    P.expensecostvariance expensecostvariance ,
    P.finishdate finishdate ,
    P.finishdate1variance finishdate1variance ,
    P.finishdatevariance finishdatevariance ,
    P.iscritical iscritical ,
    P.laborcost1variance laborcost1variance ,
    P.laborcostpercentcomplete laborcostpercentcomplete ,
    P.laborcostvariance laborcostvariance ,
    P.laborunits1variance laborunits1variance ,
    P.laborunitspercentcomplete laborunitspercentcomplete ,
    P.laborunitsvariance laborunitsvariance ,
    P.materialcost1variance materialcost1variance ,
    P.materialcostpercentcomplete materialcostpercentcomplete ,
    P.materialcostvariance materialcostvariance ,
    P.nonlaborcost1variance nonlaborcost1variance ,
    P.nonlaborcostpercentcomplete nonlaborcostpercentcomplete ,
    P.nonlaborcostvariance nonlaborcostvariance ,
    P.nonlaborunits1variance nonlaborunits1variance ,
    P.nonlaborunitspercentcomplete nonlaborunitspercentcomplete ,
    P.nonlaborunitsvariance nonlaborunitsvariance ,
    P.percentcomplete percentcomplete ,
    P.performancepercentcomplete performancepercentcomplete ,
    P.physicalpercentcomplete physicalpercentcomplete ,
    P.plannedexpensecost plannedexpensecost ,
    P.plannedlaborcost plannedlaborcost ,
    P.plannedmaterialcost plannedmaterialcost ,
    P.plannednonlaborcost plannednonlaborcost ,
    P.plannedtotalcost plannedtotalcost ,
    P.plannedtotalunits plannedtotalunits ,
    P.plannedvaluecost plannedvaluecost ,
    P.plannedvaluelaborunits plannedvaluelaborunits ,
    P.primaryresourceid primaryresourceid ,
    P.primaryresourcename primaryresourcename ,
    P.remainingexpensecost remainingexpensecost ,
    P.remainingfloat remainingfloat ,
    P.remaininglaborcost remaininglaborcost ,
    P.remainingmaterialcost remainingmaterialcost ,
    P.remainingnonlaborcost remainingnonlaborcost ,
    P.remainingtotalcost remainingtotalcost ,
    P.remainingtotalunits remainingtotalunits ,
    P.schedulepercentcomplete schedulepercentcomplete ,
    P.scheduleperfindexlaborunits scheduleperfindexlaborunits ,
    P.scheduleperformanceindex scheduleperformanceindex ,
    P.schedulevariance schedulevariance ,
    P.schedulevarianceindex schedulevarianceindex ,
    P.schedulevariancelaborunits schedulevariancelaborunits ,
    P.schedulevarindexlaborunits schedulevarindexlaborunits ,
    P.startdate startdate ,
    P.startdate1variance startdate1variance ,
    P.startdatevariance startdatevariance ,
    P.tocompleteperformanceindex tocompleteperformanceindex ,
    P.totalcost1variance totalcost1variance ,
    P.totalcostvariance totalcostvariance ,
    P.unitspercentcomplete unitspercentcomplete ,
    P.wbscode wbscode ,
    P.wbsname wbsname ,
    a.location_id locationobjectid ,
    P.locationname locationname ,
    a.control_updates_flag reviewrequired ,
    a.starred_flag isstarred ,
    a.cbs_code cbscode ,
    a.update_user lastupdateuser ,
    CASE
      WHEN a.update_date > P.update_date
      THEN a.update_date
      ELSE P.update_date
    END lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate ,
    P.update_date lastupdatedatex ,
    P.activityownerobjectid activityownerobjectid ,
    P.activityowner activityowner ,
    CASE
      WHEN a.update_date>P.update_date
      THEN 'N'
      ELSE 'Y'
    END rpt_current_flag
   FROM ${pm.or.administrative_user}.TASK A
  INNER JOIN ${pm.or.administrative_user}.TASKX P
  ON a.task_id = p.task_id
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab ON a.proj_id = projects_tab.proj_id AND projects_tab.etl_interval = 0 AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  WHERE A.DELETE_SESSION_ID     IS NULL
  /

--METADATA NAME:PROJECT_RT TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE  
CREATE OR REPLACE VIEW PROJECT_RT (OBJECTID, ID, FISCALYEARSTARTMONTH, RESOURCESCANEDITASGNMTPCTCMP, RESOURCESCANSELFASSIGNTOACTS, PRIMARYRESCANMARKACTSASCMP, RESOURCECANASSIGNTOSAMEACT, CHECKOUTSTATUS, ACTIVITYPCTCMPBASEDONSTEPS, COSTQUANTITYRECALCULATEFLAG, CONTAINSSUMMARYDATAONLY, ENABLESUMMARIZATION, WBSCODESEPARATOR, ACTIVITYDEFAULTPCTCMPTYPE, ACTIVITYDEFCOSTACCTOBJECTID, ACTIVITYDEFCALENDAROBJECTID, CURRENTBASELINEPROJECTOBJECTID, ACTIVITYIDSUFFIX, ACTIVITYIDINCREMENT, LEVELINGPRIORITY, SUMMARIZETOWBSLEVEL, STRATEGICPRIORITY, CRITICALACTIVITYFLOATLIMIT, ACTIVITYDEFAULTPRICEPERUNIT, PLANNEDSTARTDATE, MUSTFINISHBYDATE, SCHEDULEDFINISHDATE, DATEADDED, SUMMARIZEDDATADATE, LASTSUMMARIZEDDATE, PROJECTFORECASTSTARTDATE, ACTIVITYDEFAULTDURATIONTYPE, ACTIVITYIDPREFIX, DEFAULTPRICETIMEUNITS, ADDEDBY, WEBSITEROOTDIRECTORY, WEBSITEURL, ASSIGNMENTDEFAULTRATETYPE,
  LINKACTUALTOACTUALTHISPERIOD, ACTIVITYDEFAULTACTIVITYTYPE, LINKPERCENTCOMPLETEWITHACTUAL, ADDACTUALTOREMAINING, CRITICALACTIVITYPATHTYPE, ACTIVITYIDBASEDONSELACTIVITY, ASSIGNMENTDEFAULTDRIVINGFLAG, LINKPLANNEDANDATCOMPLETIONFLAG, RESETPLANNEDTOREMAININGFLAG, ALLOWNEGATIVEACTUALUNITSFLAG, OWNERRESOURCEOBJECTID, CHECKOUTDATE, CHECKOUTUSEROBJECTID, LASTFINANCIALPERIODOBJECTID, USEPROJECTBLFOREARNEDVALUE, ANNUALDISCOUNTRATE, ANTICIPATEDFINISHDATE, ANTICIPATEDSTARTDATE, CONTAINSSUMMARYDATA, CURRENTBUDGET, CURRENTVARIANCE, DATADATE, DISCOUNTAPPLICATIONPERIOD, DISTRIBUTEDCURRENTBUDGET, EARNEDVALUECOMPUTETYPE, EARNEDVALUEETCCOMPUTETYPE, EARNEDVALUEETCUSERVALUE, EARNEDVALUEUSERPERCENT, FINISHDATE, FORECASTFINISHDATE, FORECASTSTARTDATE, INDEPENDENTETCLABORUNITS, INDEPENDENTETCTOTALCOST, NAME, OBSNAME, OBSOBJECTID, ORIGINALBUDGET, OVERALLPROJECTSCORE, PARENTEPSOBJECTID, PROPOSEDBUDGET, RISKLEVEL, RISKSCORE,
  RISKEXPOSURE, STARTDATE, STATUS, ORIGINALPROJECTOBJECTID, RISKSCOREMATRIXOBJECTID, SUMPLANNEDSTARTDATE, SUMPLANNEDFINISHDATE, SUMPLANNEDDURATION, SUMPLANNEDLABORUNITS, SUMPLANNEDNONLABORUNITS, SUMPLANNEDEXPENSECOST, SUMPLANNEDLABORCOST, SUMPLANNEDMATERIALCOST, SUMPLANNEDNONLABORCOST, SUMPLANNEDTOTALCOST, SUMACCOUNTINGVARBYLABORUNITS, SUMACCOUNTINGVARIANCEBYCOST, SUMACTTHISPERIODMATERIALCOST, SUMACTTHISPERIODNONLABORCOST, SUMACTTHISPERIODNONLABORUNITS, SUMACTUALTHISPERIODLABORCOST, SUMACTUALTHISPERIODLABORUNITS, SUMATCOMPLETIONMATERIALCOST, SUMATCOMPLETIONNONLABORCOST, SUMATCOMPLETIONNONLABORUNITS, SUMATCOMPLETIONTOTALCOSTVAR, SUMBASELINECOMPACTIVITYCOUNT, SUMBASELINENOTSTARTEDACTCNT, SUMBLINPROGRESSACTIVITYCOUNT, SUMBUDGETATCMPBYLABORUNITS, SUMBUDGETATCOMPLETIONBYCOST, SUMCOSTPERFINDEXBYCOST, SUMCOSTPERFINDEXBYLABORUNITS, SUMCOSTVARIANCEBYLABORUNITS, SUMCOSTVARINDEXBYLABORUNITS, SUMDURATIONPERCENTOFPLANNED,
  SUMEACBYCOST, SUMEACBYLABORUNITS, SUMEACHIGHPCTBYLABORUNITS, SUMEACLOWPCTBYLABORUNITS, SUMETCBYCOST, SUMETCBYLABORUNITS, SUMEXPENSECOSTPCTCOMPLETE, SUMLABORCOSTPERCENTCOMPLETE, SUMLABORUNITSPERCENTCOMPLETE, SUMACTIVITYCOUNT, SUMACTUALDURATION, SUMACTUALEXPENSECOST, SUMACTUALFINISHDATE, SUMMAXACTUALFINISHDATE, SUMMAXRESTARTDATE, SUMACTUALLABORCOST, SUMACTUALLABORUNITS, SUMACTUALMATERIALCOST, SUMACTUALNONLABORCOST, SUMACTUALNONLABORUNITS, SUMACTUALSTARTDATE, SUMACTUALTHISPERIODCOST, SUMACTUALTOTALCOST, SUMACTUALVALUEBYCOST, SUMACTUALVALUEBYLABORUNITS, SUMATCOMPLETIONDURATION, SUMATCOMPLETIONEXPENSECOST, SUMATCOMPLETIONLABORCOST, SUMATCOMPLETIONLABORUNITS, SUMATCOMPLETIONTOTALCOST, SUMBASELINEDURATION, SUMBASELINEEXPENSECOST, SUMBASELINEFINISHDATE, SUMBASELINELABORCOST, SUMBASELINELABORUNITS, SUMBASELINEMATERIALCOST, SUMBASELINENONLABORCOST, SUMBASELINENONLABORUNITS, SUMBASELINESTARTDATE,
  SUMBASELINETOTALCOST, SUMCOMPLETEDACTIVITYCOUNT, SUMCOSTPERCENTCOMPLETE, SUMCOSTPERCENTOFPLANNED, SUMCOSTVARIANCEBYCOST, SUMCOSTVARIANCEINDEX, SUMCOSTVARIANCEINDEXBYCOST, SUMDURATIONPERCENTCOMPLETE, SUMDURATIONVARIANCE, SUMEARNEDVALUEBYCOST, SUMEARNEDVALUEBYLABORUNITS, SUMEXPENSECOSTVARIANCE, SUMFINISHDATEVARIANCE, SUMINPROGRESSACTIVITYCOUNT, SUMLABORCOSTVARIANCE, SUMLABORUNITSVARIANCE, SUMMATERIALCOSTVARIANCE, SUMNONLABORCOSTVARIANCE, SUMNONLABORUNITSVARIANCE, SUMNOTSTARTEDACTIVITYCOUNT, SUMPLANNEDVALUEBYCOST, SUMPROGRESSFINISHDATE, SUMREMAININGDURATION, SUMREMAININGEXPENSECOST, SUMREMAININGFINISHDATE, SUMREMAININGLABORCOST, SUMREMAININGLABORUNITS, SUMREMAININGMATERIALCOST, SUMREMAININGNONLABORCOST, SUMREMAININGNONLABORUNITS, SUMREMAININGSTARTDATE, SUMREMAININGTOTALCOST, SUMSCHEDULEPERCENTCOMPLETE, SUMPERFORMANCEPERCENTCOMPLETE, SUMSCHEDULEVARIANCEBYCOST, SUMSCHEDULEVARIANCEINDEX, SUMSTARTDATEVARIANCE,
  SUMTOTALCOSTVARIANCE, SUMTOTALFLOAT, SUMUNITSPERCENTCOMPLETE, SUMMATERIALCOSTPCTCOMPLETE, SUMNONLABORCOSTPCTCOMPLETE, SUMNONLABORUNITSPCTCOMPLETE, SUMPERFPCTCMPBYLABORUNITS, SUMPLANNEDVALUEBYLABORUNITS, SUMSCHDPCTCMPBYLABORUNITS, SUMSCHDPERFINDEXBYLABORUNITS, SUMSCHDVARIANCEBYLABORUNITS, SUMSCHDVARIANCEINDEXBYCOST, SUMSCHDVARINDEXBYLABORUNITS, SUMSCHEDULEPERFINDEXBYCOST, SUMTOCOMPLETEPERFINDEXBYCOST, SUMVARATCMPBYLABORUNITS, SUMEARLYSTARTDATE, SUMEARLYENDDATE, SUMLATESTARTDATE, SUMLATEENDDATE, SUMMAXCALENDARID, SUMMINCALENDARID, TOTALBENEFITPLAN, TOTALBENEFITPLANTALLY, TOTALFUNDING, TOTALSPENDINGPLAN, TOTALSPENDINGPLANTALLY, UNALLOCATEDBUDGET, NETPRESENTVALUE, RETURNONINVESTMENT, PAYBACKPERIOD, UNDISTRIBUTEDCURRENTVARIANCE, PROJECTDESCRIPTION, BASELINETYPEOBJECTID, ENABLEPUBLICATION, NEXTPUBLICATIONDATE, LASTPUBLISHEDON, PUBLICATIONPRIORITY, LOCATIONOBJECTID, HISTORYINTERVAL, HISTORYLEVEL,
  LOCATIONNAME, ALLOWSTATUSREVIEW, STATUSREVIEWEROBJECTID, STATUSREVIEWERNAME, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE, ETLINTERVAL, ETLHOUR, LASTUPDATEDATEX)
AS
  SELECT a.proj_id objectid ,
    a.proj_short_name id ,
    a.fy_start_month_num fiscalyearstartmonth ,
    a.chng_eff_cmp_pct_flag resourcescaneditasgnmtpctcmp ,
    a.rsrc_self_add_flag resourcescanselfassigntoacts ,
    a.allow_complete_flag primaryrescanmarkactsascmp ,
    a.rsrc_multi_assign_flag resourcecanassigntosameact ,
    a.checkout_flag checkoutstatus ,
    a.step_complete_flag activitypctcmpbasedonsteps ,
    a.cost_qty_recalc_flag costquantityrecalculateflag ,
    a.sum_only_flag containssummarydataonly ,
    a.batch_sum_flag enablesummarization ,
    a.name_sep_char wbscodeseparator ,
    CASE a.def_complete_pct_type
      WHEN 'CP_Phys'
      THEN 'Physical'
      WHEN 'CP_Drtn'
      THEN 'Duration'
      WHEN 'CP_Units'
      THEN 'Units'
      WHEN 'CP_Phys'
      THEN 'Physical'
      WHEN 'CP_Drtn'
      THEN 'Duration'
      WHEN 'CP_Units'
      THEN 'Units'
      ELSE a.def_complete_pct_type
    END activitydefaultpctcmptype ,
    a.acct_id activitydefcostacctobjectid ,
    a.clndr_id activitydefcalendarobjectid ,
    a.sum_base_proj_id currentbaselineprojectobjectid ,
    a.task_code_base activityidsuffix ,
    a.task_code_step activityidincrement ,
    a.priority_num levelingpriority ,
    a.wbs_max_sum_level summarizetowbslevel ,
    a.strgy_priority_num strategicpriority ,
    a.critical_drtn_hr_cnt criticalactivityfloatlimit ,
    a.def_cost_per_qty activitydefaultpriceperunit ,
    a.plan_start_date plannedstartdate ,
    a.plan_end_date mustfinishbydate ,
    a.scd_end_date scheduledfinishdate ,
    a.add_date dateadded ,
    a.sum_data_date summarizeddatadate ,
    a.last_tasksum_date lastsummarizeddate ,
    a.fcst_start_date projectforecaststartdate ,
    CASE a.def_duration_type
      WHEN 'DT_FixedRate'
      THEN 'Fixed Units/Time'
      WHEN 'DT_FixedDrtn'
      THEN 'Fixed Duration UNITS/Time'
      WHEN 'DT_FixedQty'
      THEN 'Fixed Units'
      WHEN 'DT_FixedDUR2'
      THEN 'Fixed Duration UNITS'
      WHEN 'DT_FixedRate'
      THEN 'Fixed Units/Time'
      WHEN 'DT_FixedDrtn'
      THEN 'Fixed Duration UNITS/Time'
      WHEN 'DT_FixedQty'
      THEN 'Fixed Units'
      WHEN 'DT_FixedDUR2'
      THEN 'Fixed Duration UNITS'
      ELSE a.def_duration_type
    END activitydefaultdurationtype ,
    a.task_code_prefix activityidprefix ,
    CASE a.def_qty_type
      WHEN 'QT_Hour'
      THEN 'Hour'
      WHEN 'QT_Day'
      THEN 'Day'
      WHEN 'QT_Week'
      THEN 'Week'
      WHEN 'QT_Month'
      THEN 'Month'
      WHEN 'QT_Year'
      THEN 'Year'
      WHEN 'QT_DaysHours'
      THEN '??enm.UnitType.QT_DaysHours??'
      WHEN 'QT_HoursMinutes'
      THEN '??enm.UnitType.QT_HoursMinutes??'
      WHEN 'QT_Hour'
      THEN 'Hour'
      WHEN 'QT_Day'
      THEN 'Day'
      WHEN 'QT_Week'
      THEN 'Week'
      WHEN 'QT_Month'
      THEN 'Month'
      WHEN 'QT_Year'
      THEN 'Year'
      WHEN 'QT_DaysHours'
      THEN '??enm.UnitType.QT_DaysHours??'
      WHEN 'QT_HoursMinutes'
      THEN '??enm.UnitType.QT_HoursMinutes??'
      ELSE a.def_qty_type
    END defaultpricetimeunits ,
    a.add_by_name addedby ,
    a.web_local_root_path websiterootdirectory ,
    a.proj_url websiteurl ,
    CASE a.def_rate_type
      WHEN 'COST_PER_QTY'
      THEN 'Cost Per Qty'
      WHEN 'COST_PER_QTY2'
      THEN 'CostPerQty2'
      WHEN 'COST_PER_QTY3'
      THEN 'CostPerQty3'
      WHEN 'COST_PER_QTY4'
      THEN 'CostPerQty4'
      WHEN 'COST_PER_QTY5'
      THEN 'CostPerQty5'
      WHEN 'COST_PER_QTY'
      THEN 'Cost Per Qty'
      WHEN 'COST_PER_QTY2'
      THEN 'CostPerQty2'
      WHEN 'COST_PER_QTY3'
      THEN 'CostPerQty3'
      WHEN 'COST_PER_QTY4'
      THEN 'CostPerQty4'
      WHEN 'COST_PER_QTY5'
      THEN 'CostPerQty5'
      ELSE a.def_rate_type
    END assignmentdefaultratetype ,
    a.act_this_per_link_flag linkactualtoactualthisperiod ,
    CASE a.def_task_type
      WHEN 'TT_Task'
      THEN 'Task Dependent'
      WHEN 'TT_Rsrc'
      THEN 'Resource Dependent'
      WHEN 'TT_LOE'
      THEN 'Level Of Effort'
      WHEN 'TT_Mile'
      THEN 'Start Milestone'
      WHEN 'TT_FinMile'
      THEN 'Finish Milestone'
      WHEN 'TT_WBS'
      THEN 'WBS Summary'
      WHEN 'TT_Task'
      THEN 'Task Dependent'
      WHEN 'TT_Rsrc'
      THEN 'Resource Dependent'
      WHEN 'TT_LOE'
      THEN 'Level Of Effort'
      WHEN 'TT_Mile'
      THEN 'Start Milestone'
      WHEN 'TT_FinMile'
      THEN 'Finish Milestone'
      WHEN 'TT_WBS'
      THEN 'WBS Summary'
      ELSE a.def_task_type
    END activitydefaultactivitytype ,
    a.act_pct_link_flag linkpercentcompletewithactual ,
    a.add_act_remain_flag addactualtoremaining ,
    CASE a.critical_path_type
      WHEN 'CT_TotFloat'
      THEN 'Critical Float'
      WHEN 'CT_DrivPath'
      THEN 'Longest Path'
      WHEN 'CT_TotFloat'
      THEN 'Critical Float'
      WHEN 'CT_DrivPath'
      THEN 'Longest Path'
      ELSE a.critical_path_type
    END criticalactivitypathtype ,
    a.task_code_prefix_flag activityidbasedonselactivity ,
    a.def_rollup_dates_flag assignmentdefaultdrivingflag ,
    a.rem_target_link_flag linkplannedandatcompletionflag ,
    a.reset_planned_flag resetplannedtoremainingflag ,
    a.allow_neg_act_flag allownegativeactualunitsflag ,
    a.rsrc_id ownerresourceobjectid ,
    a.checkout_date checkoutdate ,
    a.checkout_user_id checkoutuserobjectid ,
    a.last_fin_dates_id lastfinancialperiodobjectid ,
    a.use_project_baseline_flag useprojectblforearnedvalue ,
    P.annualdiscountrate annualdiscountrate ,
    P.anticipatedfinishdate anticipatedfinishdate ,
    P.anticipatedstartdate anticipatedstartdate ,
    P.containssummarydata containssummarydata ,
    P.currentbudget currentbudget ,
    P.currentvariance currentvariance ,
    P.datadate datadate ,
    P.discountapplicationperiod discountapplicationperiod ,
    P.distributedcurrentbudget distributedcurrentbudget ,
    P.earnedvaluecomputetype earnedvaluecomputetype ,
    P.earnedvalueetccomputetype earnedvalueetccomputetype ,
    P.earnedvalueetcuservalue earnedvalueetcuservalue ,
    P.earnedvalueuserpercent earnedvalueuserpercent ,
    P.finishdate finishdate ,
    P.forecastfinishdate forecastfinishdate ,
    P.forecaststartdate forecaststartdate ,
    P.independentetclaborunits independentetclaborunits ,
    P.independentetctotalcost independentetctotalcost ,
    P.name name ,
    P.obsname obsname ,
    P.obsobjectid obsobjectid ,
    P.originalbudget originalbudget ,
    P.overallprojectscore overallprojectscore ,
    P.parentepsobjectid parentepsobjectid ,
    P.proposedbudget proposedbudget ,
    P.risklevel risklevel ,
    P.riskscore riskscore ,
    P.riskexposure riskexposure ,
    P.startdate startdate ,
    P.status status ,
    a.orig_proj_id originalprojectobjectid ,
    a.matrix_id riskscorematrixobjectid ,
    P.sumplannedstartdate sumplannedstartdate ,
    P.sumplannedfinishdate sumplannedfinishdate ,
    P.sumplannedduration sumplannedduration ,
    P.sumplannedlaborunits sumplannedlaborunits ,
    P.sumplannednonlaborunits sumplannednonlaborunits ,
    P.sumplannedexpensecost sumplannedexpensecost ,
    P.sumplannedlaborcost sumplannedlaborcost ,
    P.sumplannedmaterialcost sumplannedmaterialcost ,
    P.sumplannednonlaborcost sumplannednonlaborcost ,
    P.sumplannedtotalcost sumplannedtotalcost ,
    P.sumaccountingvarbylaborunits sumaccountingvarbylaborunits ,
    P.sumaccountingvariancebycost sumaccountingvariancebycost ,
    P.sumactthisperiodmaterialcost sumactthisperiodmaterialcost ,
    P.sumactthisperiodnonlaborcost sumactthisperiodnonlaborcost ,
    P.sumactthisperiodnonlaborunits sumactthisperiodnonlaborunits ,
    P.sumactualthisperiodlaborcost sumactualthisperiodlaborcost ,
    P.sumactualthisperiodlaborunits sumactualthisperiodlaborunits ,
    P.sumatcompletionmaterialcost sumatcompletionmaterialcost ,
    P.sumatcompletionnonlaborcost sumatcompletionnonlaborcost ,
    P.sumatcompletionnonlaborunits sumatcompletionnonlaborunits ,
    P.sumatcompletiontotalcostvar sumatcompletiontotalcostvar ,
    P.sumbaselinecompactivitycount sumbaselinecompactivitycount ,
    P.sumbaselinenotstartedactcnt sumbaselinenotstartedactcnt ,
    P.sumblinprogressactivitycount sumblinprogressactivitycount ,
    P.sumbudgetatcmpbylaborunits sumbudgetatcmpbylaborunits ,
    P.sumbudgetatcompletionbycost sumbudgetatcompletionbycost ,
    P.sumcostperfindexbycost sumcostperfindexbycost ,
    P.sumcostperfindexbylaborunits sumcostperfindexbylaborunits ,
    P.sumcostvariancebylaborunits sumcostvariancebylaborunits ,
    P.sumcostvarindexbylaborunits sumcostvarindexbylaborunits ,
    P.sumdurationpercentofplanned sumdurationpercentofplanned ,
    P.sumeacbycost sumeacbycost ,
    P.sumeacbylaborunits sumeacbylaborunits ,
    P.sumeachighpctbylaborunits sumeachighpctbylaborunits ,
    P.sumeaclowpctbylaborunits sumeaclowpctbylaborunits ,
    P.sumetcbycost sumetcbycost ,
    P.sumetcbylaborunits sumetcbylaborunits ,
    P.sumexpensecostpctcomplete sumexpensecostpctcomplete ,
    P.sumlaborcostpercentcomplete sumlaborcostpercentcomplete ,
    P.sumlaborunitspercentcomplete sumlaborunitspercentcomplete ,
    P.sumactivitycount sumactivitycount ,
    P.sumactualduration sumactualduration ,
    P.sumactualexpensecost sumactualexpensecost ,
    P.sumactualfinishdate sumactualfinishdate ,
    P.summaxactualfinishdate summaxactualfinishdate ,
    P.summaxrestartdate summaxrestartdate ,
    P.sumactuallaborcost sumactuallaborcost ,
    P.sumactuallaborunits sumactuallaborunits ,
    P.sumactualmaterialcost sumactualmaterialcost ,
    P.sumactualnonlaborcost sumactualnonlaborcost ,
    P.sumactualnonlaborunits sumactualnonlaborunits ,
    P.sumactualstartdate sumactualstartdate ,
    P.sumactualthisperiodcost sumactualthisperiodcost ,
    P.sumactualtotalcost sumactualtotalcost ,
    P.sumactualvaluebycost sumactualvaluebycost ,
    P.sumactualvaluebylaborunits sumactualvaluebylaborunits ,
    P.sumatcompletionduration sumatcompletionduration ,
    P.sumatcompletionexpensecost sumatcompletionexpensecost ,
    P.sumatcompletionlaborcost sumatcompletionlaborcost ,
    P.sumatcompletionlaborunits sumatcompletionlaborunits ,
    P.sumatcompletiontotalcost sumatcompletiontotalcost ,
    P.sumbaselineduration sumbaselineduration ,
    P.sumbaselineexpensecost sumbaselineexpensecost ,
    P.sumbaselinefinishdate sumbaselinefinishdate ,
    P.sumbaselinelaborcost sumbaselinelaborcost ,
    P.sumbaselinelaborunits sumbaselinelaborunits ,
    P.sumbaselinematerialcost sumbaselinematerialcost ,
    P.sumbaselinenonlaborcost sumbaselinenonlaborcost ,
    P.sumbaselinenonlaborunits sumbaselinenonlaborunits ,
    P.sumbaselinestartdate sumbaselinestartdate ,
    P.sumbaselinetotalcost sumbaselinetotalcost ,
    P.sumcompletedactivitycount sumcompletedactivitycount ,
    P.sumcostpercentcomplete sumcostpercentcomplete ,
    P.sumcostpercentofplanned sumcostpercentofplanned ,
    P.sumcostvariancebycost sumcostvariancebycost ,
    P.sumcostvarianceindex sumcostvarianceindex ,
    P.sumcostvarianceindexbycost sumcostvarianceindexbycost ,
    P.sumdurationpercentcomplete sumdurationpercentcomplete ,
    P.sumdurationvariance sumdurationvariance ,
    P.sumearnedvaluebycost sumearnedvaluebycost ,
    P.sumearnedvaluebylaborunits sumearnedvaluebylaborunits ,
    P.sumexpensecostvariance sumexpensecostvariance ,
    P.sumfinishdatevariance sumfinishdatevariance ,
    P.suminprogressactivitycount suminprogressactivitycount ,
    P.sumlaborcostvariance sumlaborcostvariance ,
    P.sumlaborunitsvariance sumlaborunitsvariance ,
    P.summaterialcostvariance summaterialcostvariance ,
    P.sumnonlaborcostvariance sumnonlaborcostvariance ,
    P.sumnonlaborunitsvariance sumnonlaborunitsvariance ,
    P.sumnotstartedactivitycount sumnotstartedactivitycount ,
    P.sumplannedvaluebycost sumplannedvaluebycost ,
    P.sumprogressfinishdate sumprogressfinishdate ,
    P.sumremainingduration sumremainingduration ,
    P.sumremainingexpensecost sumremainingexpensecost ,
    P.sumremainingfinishdate sumremainingfinishdate ,
    P.sumremaininglaborcost sumremaininglaborcost ,
    P.sumremaininglaborunits sumremaininglaborunits ,
    P.sumremainingmaterialcost sumremainingmaterialcost ,
    P.sumremainingnonlaborcost sumremainingnonlaborcost ,
    P.sumremainingnonlaborunits sumremainingnonlaborunits ,
    P.sumremainingstartdate sumremainingstartdate ,
    P.sumremainingtotalcost sumremainingtotalcost ,
    P.sumschedulepercentcomplete sumschedulepercentcomplete ,
    P.sumperformancepercentcomplete sumperformancepercentcomplete ,
    P.sumschedulevariancebycost sumschedulevariancebycost ,
    P.sumschedulevarianceindex sumschedulevarianceindex ,
    P.sumstartdatevariance sumstartdatevariance ,
    P.sumtotalcostvariance sumtotalcostvariance ,
    P.sumtotalfloat sumtotalfloat ,
    P.sumunitspercentcomplete sumunitspercentcomplete ,
    P.summaterialcostpctcomplete summaterialcostpctcomplete ,
    P.sumnonlaborcostpctcomplete sumnonlaborcostpctcomplete ,
    P.sumnonlaborunitspctcomplete sumnonlaborunitspctcomplete ,
    P.sumperfpctcmpbylaborunits sumperfpctcmpbylaborunits ,
    P.sumplannedvaluebylaborunits sumplannedvaluebylaborunits ,
    P.sumschdpctcmpbylaborunits sumschdpctcmpbylaborunits ,
    P.sumschdperfindexbylaborunits sumschdperfindexbylaborunits ,
    P.sumschdvariancebylaborunits sumschdvariancebylaborunits ,
    P.sumschdvarianceindexbycost sumschdvarianceindexbycost ,
    P.sumschdvarindexbylaborunits sumschdvarindexbylaborunits ,
    P.sumscheduleperfindexbycost sumscheduleperfindexbycost ,
    P.sumtocompleteperfindexbycost sumtocompleteperfindexbycost ,
    P.sumvaratcmpbylaborunits sumvaratcmpbylaborunits ,
    P.sumearlystartdate sumearlystartdate ,
    P.sumearlyenddate sumearlyenddate ,
    P.sumlatestartdate sumlatestartdate ,
    P.sumlateenddate sumlateenddate ,
    P.summaxcalendarid summaxcalendarid ,
    P.summincalendarid summincalendarid ,
    P.totalbenefitplan totalbenefitplan ,
    P.totalbenefitplantally totalbenefitplantally ,
    P.totalfunding totalfunding ,
    P.totalspendingplan totalspendingplan ,
    P.totalspendingplantally totalspendingplantally ,
    P.unallocatedbudget unallocatedbudget ,
    P.netpresentvalue netpresentvalue ,
    P.returnoninvestment returnoninvestment ,
    P.paybackperiod paybackperiod ,
    P.undistributedcurrentvariance undistributedcurrentvariance ,
    a.description projectdescription ,
    a.base_type_id baselinetypeobjectid ,
    a.px_enable_publication_flag enablepublication ,
    a.px_next_date nextpublicationdate ,
    a.px_last_update_date lastpublishedon ,
    a.px_priority publicationpriority ,
    a.location_id locationobjectid ,
    a.hist_interval historyinterval ,
    a.hist_level historylevel ,
    P.locationname locationname ,
    a.control_updates_flag allowstatusreview ,
    P.statusreviewerobjectid statusreviewerobjectid ,
    P.statusreviewername statusreviewername ,
    a.update_user lastupdateuser ,
    a.update_date lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate ,
    a.etl_interval etlinterval ,
    a.etl_hour etlhour ,
    CASE
      WHEN a.update_date > p.update_date
      THEN a.update_date
      ELSE p.update_date
    END lastupdatedatex
   FROM ${pm.or.administrative_user}.PROJECT A
  INNER JOIN ${pm.or.administrative_user}.PROJECTX P
  ON a.proj_id               = p.proj_id
  AND a.PROJECT_FLAG         = 'Y'
  WHERE A.DELETE_SESSION_ID IS NULL
  AND a.etl_interval = 0
  AND a.ORIG_PROJ_ID        IS NULL
  /
  
--METADATA NAME:ACTIVITYEXPENSE_RT TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE  
CREATE OR REPLACE VIEW ACTIVITYEXPENSE_RT (OBJECTID, PROJECTOBJECTID, ACTIVITYOBJECTID, AUTOCOMPUTEACTUALS, ACCRUALTYPE, COSTACCOUNTOBJECTID, EXPENSECATEGORYOBJECTID, CBSOBJECTID, PLANNEDCOST, ACTUALCOST, REMAININGCOST, UNITOFMEASURE, PLANNEDUNITS, PRICEPERUNIT, DOCUMENTNUMBER, VENDOR, EXPENSEITEM, EXPENSEDESCRIPTION, ACTIVITYID, ACTIVITYNAME, ACTUALUNITS, ATCOMPLETIONCOST, ATCOMPLETIONUNITS, COSTACCOUNTID, COSTACCOUNTNAME, CBSCODE, CBSNAME, EXPENSECATEGORYNAME, EXPENSEPERCENTCOMPLETE, OVERBUDGET, PROJECTID, REMAININGUNITS, WBSOBJECTID, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE)
AS
  SELECT a.cost_item_id objectid ,
    a.proj_id projectobjectid ,
    a.task_id activityobjectid ,
    a.auto_compute_act_flag autocomputeactuals ,
    CASE a.cost_load_type
      WHEN 'CL_Start'
      THEN 'Start of Activity'
      WHEN 'CL_End'
      THEN 'End of Activity'
      WHEN 'CL_Uniform'
      THEN 'Uniform over Activity'
      ELSE a.cost_load_type
    END accrualtype ,
    a.acct_id costaccountobjectid ,
    a.cost_type_id expensecategoryobjectid ,
    a.cbs_id cbsobjectid ,
    a.target_cost plannedcost ,
    a.act_cost actualcost ,
    a.remain_cost remainingcost ,
    a.qty_name unitofmeasure ,
    a.target_qty plannedunits ,
    a.cost_per_qty priceperunit ,
    a.po_number documentnumber ,
    a.vendor_name vendor ,
    a.cost_name expenseitem ,
    a.cost_descr expensedescription ,
    P.activityid activityid ,
    P.activityname activityname ,
    P.actualunits actualunits ,
    P.atcompletioncost atcompletioncost ,
    P.atcompletionunits atcompletionunits ,
    P.costaccountid costaccountid ,
    P.costaccountname costaccountname ,
    c.cbs_code cbscode ,
    c.description cbsname ,
    P.expensecategoryname expensecategoryname ,
    P.expensepercentcomplete expensepercentcomplete ,
    P.overbudget overbudget ,
    P.projectid projectid ,
    P.remainingunits remainingunits ,
    P.wbsobjectid wbsobjectid ,
    a.update_user lastupdateuser ,
    a.update_date lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate
   FROM ${pm.or.administrative_user}.PROJCOST A
  INNER JOIN ${pm.or.administrative_user}.PROJCOSTX P ON a.cost_item_id = p.cost_item_id
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab on a.proj_id = projects_tab.proj_id AND projects_tab.etl_interval = 0 AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  LEFT OUTER  JOIN ${pm.or.administrative_user}.cbs c
  ON a.cbs_id = c.cbs_id
  WHERE A.DELETE_SESSION_ID IS NULL
  /
  
--METADATA NAME:ACTIVITYNOTE_RT TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE  
CREATE OR REPLACE VIEW ACTIVITYNOTE_RT (OBJECTID, ACTIVITYOBJECTID, NOTEBOOKTOPICOBJECTID, PROJECTOBJECTID, NOTE, ACTIVITYID, ACTIVITYNAME, NOTEBOOKTOPICNAME, PROJECTID, RAWTEXTNOTE, WBSOBJECTID, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE)
AS
  SELECT a.memo_id objectid ,
    a.task_id activityobjectid ,
    a.memo_type_id notebooktopicobjectid ,
    a.proj_id projectobjectid ,
    a.task_memo note ,
    P.activityid activityid ,
    P.activityname activityname ,
    P.notebooktopicname notebooktopicname ,
    P.projectid projectid ,
    P.rawtextnote rawtextnote ,
    P.wbsobjectid wbsobjectid ,
    a.update_user lastupdateuser ,
    a.update_date lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate
   FROM ${pm.or.administrative_user}.TASKMEMO A
  INNER JOIN ${pm.or.administrative_user}.TASKMEMOX P ON a.memo_id = p.memo_id
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab on a.proj_id = projects_tab.proj_id AND projects_tab.etl_interval = 0 AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  WHERE A.DELETE_SESSION_ID IS NULL
  /
  
--METADATA NAME:ACTIVITYRISK_RT TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE  
CREATE OR REPLACE VIEW ACTIVITYRISK_RT (ACTIVITYOBJECTID, PROJECTOBJECTID, RISKOBJECTID, PROJECTID, PROJECTNAME, ACTIVITYID, ACTIVITYNAME, RISKNAME, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE)
AS
  SELECT a.task_id activityobjectid ,
    a.proj_id projectobjectid ,
    a.risk_id riskobjectid ,
    P.projectid projectid ,
    P.projectname projectname ,
    P.activityid activityid ,
    P.activityname activityname ,
    P.riskname riskname ,
    a.update_user lastupdateuser ,
    a.update_date lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate
   FROM ${pm.or.administrative_user}.TASKRISK A
  INNER JOIN ${pm.or.administrative_user}.TASKRISKX P ON a.task_id = p.task_id AND a.risk_id = p.risk_id
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab on a.proj_id = projects_tab.proj_id AND projects_tab.etl_interval = 0 AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  WHERE A.DELETE_SESSION_ID IS NULL
  /
  
--METADATA NAME:ACTIVITYSPREAD_RT TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYSPREAD_RT (ACTIVITYOBJECTID, STARTDATE, ENDDATE, ACTIVITYCODE, ACTIVITYNAME, WBSOBJECTID, PROJECTOBJECTID, ACTUALLABORUNITS, ACTUALNONLABORUNITS, ATCOMPLETIONLABORUNITS, ATCOMPLETIONNONLABORUNITS, BASELINEACTUALLABORUNITS, BASELINEACTUALNONLABORUNITS, BASELINEPLANNEDLABORUNITS, BASELINEPLANNEDNONLABORUNITS, BASELINE1ACTUALLABORUNITS, BASELINE1ACTUALNONLABORUNITS, BASELINE1PLANNEDLABORUNITS, BASELINE1PLANNEDNONLABORUNITS, EARNEDVALUELABORUNITS, ESTIMATEATCOMPLETIONLABORUNITS, ESTIMATETOCOMPLETELABORUNITS, PLANNEDLABORUNITS, PLANNEDNONLABORUNITS, PLANNEDVALUELABORUNITS, REMAININGLABORUNITS, REMAININGLATELABORUNITS, REMAININGLATENONLABORUNITS, REMAININGNONLABORUNITS, ACTUALCOST, ACTUALEXPENSECOST, ACTUALLABORCOST, ACTUALMATERIALCOST, ACTUALNONLABORCOST, ACTUALTOTALCOST, ATCOMPLETIONEXPENSECOST, ATCOMPLETIONLABORCOST, ATCOMPLETIONMATERIALCOST,
  ATCOMPLETIONNONLABORCOST, ATCOMPLETIONTOTALCOST, BASELINEPLANNEDEXPENSECOST, BASELINEPLANNEDLABORCOST, BASELINEPLANNEDMATERIALCOST, BASELINEPLANNEDNONLABORCOST, BASELINEPLANNEDTOTALCOST, BASELINEACTUALEXPENSECOST, BASELINEACTUALLABORCOST, BASELINEACTUALMATERIALCOST, BASELINEACTUALNONLABORCOST, BASELINEACTUALTOTALCOST, BASELINE1ACTUALEXPENSECOST, BASELINE1ACTUALLABORCOST, BASELINE1ACTUALMATERIALCOST, BASELINE1ACTUALNONLABORCOST, BASELINE1ACTUALTOTALCOST, BASELINE1PLANNEDEXPENSECOST, BASELINE1PLANNEDLABORCOST, BASELINE1PLANNEDMATERIALCOST, BASELINE1PLANNEDNONLABORCOST, BASELINE1PLANNEDTOTALCOST, EARNEDVALUECOST, ESTIMATEATCOMPLETIONCOST, ESTIMATETOCOMPLETECOST, PLANNEDEXPENSECOST, PLANNEDLABORCOST, PLANNEDMATERIALCOST, PLANNEDNONLABORCOST, PLANNEDTOTALCOST, PLANNEDVALUECOST, REMAININGEXPENSECOST, REMAININGLABORCOST, REMAININGLATEEXPENSECOST, REMAININGLATELABORCOST, REMAININGLATEMATERIALCOST,
  REMAININGLATENONLABORCOST, REMAININGLATETOTALCOST, REMAININGMATERIALCOST, REMAININGNONLABORCOST, REMAININGTOTALCOST, LASTUPDATEDATE, CBSOBJECTID)
AS
  SELECT a.ACTIVITYOBJECTID,
    a.STARTDATE,
    a.ENDDATE,
    a.ACTIVITYCODE,
    a.ACTIVITYNAME,
    a.WBSOBJECTID,
    a.PROJECTOBJECTID,
    a.ACTUALLABORUNITS,
    a.ACTUALNONLABORUNITS,
    a.ATCOMPLETIONLABORUNITS,
    a.ATCOMPLETIONNONLABORUNITS,
    a.BASELINEACTUALLABORUNITS,
    a.BASELINEACTUALNONLABORUNITS,
    a.BASELINEPLANNEDLABORUNITS,
    a.BASELINEPLANNEDNONLABORUNITS,
    a.BASELINE1ACTUALLABORUNITS,
    a.BASELINE1ACTUALNONLABORUNITS,
    a.BASELINE1PLANNEDLABORUNITS,
    a.BASELINE1PLANNEDNONLABORUNITS,
    a.EARNEDVALUELABORUNITS,
    a.ESTIMATEATCOMPLETIONLABORUNITS,
    a.ESTIMATETOCOMPLETELABORUNITS,
    a.PLANNEDLABORUNITS,
    a.PLANNEDNONLABORUNITS,
    a.PLANNEDVALUELABORUNITS,
    a.REMAININGLABORUNITS,
    a.REMAININGLATELABORUNITS,
    a.REMAININGLATENONLABORUNITS,
    a.REMAININGNONLABORUNITS,
    a.ACTUALCOST,
    a.ACTUALEXPENSECOST,
    a.ACTUALLABORCOST,
    a.ACTUALMATERIALCOST,
    a.ACTUALNONLABORCOST,
    a.ACTUALTOTALCOST,
    a.ATCOMPLETIONEXPENSECOST,
    a.ATCOMPLETIONLABORCOST,
    a.ATCOMPLETIONMATERIALCOST,
    a.ATCOMPLETIONNONLABORCOST,
    a.ATCOMPLETIONTOTALCOST,
    a.BASELINEPLANNEDEXPENSECOST,
    a.BASELINEPLANNEDLABORCOST,
    a.BASELINEPLANNEDMATERIALCOST,
    a.BASELINEPLANNEDNONLABORCOST,
    a.BASELINEPLANNEDTOTALCOST,
    a.BASELINEACTUALEXPENSECOST,
    a.BASELINEACTUALLABORCOST,
    a.BASELINEACTUALMATERIALCOST,
    a.BASELINEACTUALNONLABORCOST,
    a.BASELINEACTUALTOTALCOST,
    a.BASELINE1ACTUALEXPENSECOST,
    a.BASELINE1ACTUALLABORCOST,
    a.BASELINE1ACTUALMATERIALCOST,
    a.BASELINE1ACTUALNONLABORCOST,
    a.BASELINE1ACTUALTOTALCOST,
    a.BASELINE1PLANNEDEXPENSECOST,
    a.BASELINE1PLANNEDLABORCOST,
    a.BASELINE1PLANNEDMATERIALCOST,
    a.BASELINE1PLANNEDNONLABORCOST,
    a.BASELINE1PLANNEDTOTALCOST,
    a.EARNEDVALUECOST,
    a.ESTIMATEATCOMPLETIONCOST,
    a.ESTIMATETOCOMPLETECOST,
    a.PLANNEDEXPENSECOST,
    a.PLANNEDLABORCOST,
    a.PLANNEDMATERIALCOST,
    a.PLANNEDNONLABORCOST,
    a.PLANNEDTOTALCOST,
    a.PLANNEDVALUECOST,
    a.REMAININGEXPENSECOST,
    a.REMAININGLABORCOST,
    a.REMAININGLATEEXPENSECOST,
    a.REMAININGLATELABORCOST,
    a.REMAININGLATEMATERIALCOST,
    a.REMAININGLATENONLABORCOST,
    a.REMAININGLATETOTALCOST,
    a.REMAININGMATERIALCOST,
    a.REMAININGNONLABORCOST,
    a.REMAININGTOTALCOST,
    a.UPDATE_DATE,
    T1.cbs_id cbsobjectid
   FROM ${pm.or.administrative_user}.ACTIVITYSPREAD a
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab on a.projectobjectid = projects_tab.proj_id AND projects_tab.etl_interval = 0 AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  INNER JOIN ${pm.or.administrative_user}.TASK T1 ON T1.task_id = ActivityObjectId AND T1.DELETE_SESSION_ID IS NULL
  /
  
--METADATA NAME:ACTIVITYSTEP_RT TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYSTEP_RT (OBJECTID, ACTIVITYOBJECTID, SEQUENCENUMBER, PROJECTOBJECTID, ISCOMPLETED, NAME, WEIGHT, PERCENTCOMPLETE, DESCRIPTION, ACTIVITYID, ACTIVITYNAME, PROJECTID, WBSOBJECTID, WEIGHTPERCENT, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE)
AS
  SELECT a.proc_id objectid ,
    a.task_id activityobjectid ,
    a.seq_num sequencenumber ,
    a.proj_id projectobjectid ,
    a.complete_flag iscompleted ,
    a.proc_name name ,
    a.proc_wt weight ,
    a.complete_pct percentcomplete ,
    a.proc_descr description ,
    P.activityid activityid ,
    P.activityname activityname ,
    P.projectid projectid ,
    P.wbsobjectid wbsobjectid ,
    P.weightpercent weightpercent ,
    a.update_user lastupdateuser ,
    a.update_date lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate
   FROM ${pm.or.administrative_user}.TASKPROC A
  INNER JOIN ${pm.or.administrative_user}.TASKPROCX P ON a.proc_id = p.proc_id
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab on a.proj_id = projects_tab.proj_id AND projects_tab.etl_interval = 0 AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  WHERE A.DELETE_SESSION_ID IS NULL
  /
  
--METADATA NAME:CBS_RT TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE  
CREATE OR REPLACE VIEW CBS_RT (OBJECTID, PROJECTOBJECTID, CODE, NAME, PARENTOBJECTID, STATUS, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE, LASTUPDATEDATEX)
AS
  SELECT A.cbs_id objectid,
    A.proj_id projectobjectid,
    A.cbs_code code,
    A.description name,
    A.parent_cbs_id parentobjectid,
    A.status status,
    A.update_user lastupdateuser,
    A.update_date lastupdatedate,
    A.create_user createuser,
    A.create_date createdate,
    P.update_dim_date lastupdatedatex
   FROM ${pm.or.administrative_user}.CBS A
  INNER JOIN ${pm.or.administrative_user}.PROJECTX P ON a.proj_id = p.proj_id
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab ON a.proj_id = projects_tab.proj_id AND projects_tab.etl_interval = 0 AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  WHERE A.DELETE_SESSION_ID IS NULL
  /
  
--METADATA NAME:PROJECTNOTE_RT TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTNOTE_RT (OBJECTID, PROJECTOBJECTID, WBSOBJECTID, NOTEBOOKTOPICOBJECTID, NOTE, NOTEBOOKTOPICNAME, PROJECTID, RAWTEXTNOTE, WBSCODE, WBSNAME, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE)
AS
  SELECT a.wbs_memo_id objectid ,
    a.proj_id projectobjectid ,
    a.wbs_id wbsobjectid ,
    a.memo_type_id notebooktopicobjectid ,
    a.wbs_memo note ,
    P.notebooktopicname notebooktopicname ,
    P.projectid projectid ,
    P.rawtextnote rawtextnote ,
    P.wbscode wbscode ,
    P.wbsname wbsname ,
    a.update_user lastupdateuser ,
    a.update_date lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate
   FROM ${pm.or.administrative_user}.WBSMEMO A
  INNER JOIN ${pm.or.administrative_user}.WBSMEMOX P
  ON a.wbs_memo_id = p.wbs_memo_id
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab ON a.proj_id = projects_tab.proj_id AND projects_tab.etl_interval = 0 AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  WHERE A.DELETE_SESSION_ID    IS NULL
  /
  
--METADATA NAME:RESOURCEASSIGNMENT_RT TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE  
CREATE OR REPLACE VIEW RESOURCEASSIGNMENT_RT (OBJECTID, ACTIVITYOBJECTID, PROJECTOBJECTID, RESOURCETYPE, ISCOSTUNITSLINKED, ROLEOBJECTID, COSTACCOUNTOBJECTID, RESOURCEOBJECTID, PROFICIENCY, PENDINGPERCENTCOMPLETE, REMAININGUNITS, PENDINGREMAININGUNITS, PLANNEDUNITS, REMAININGUNITSPERTIME, PENDINGACTUALREGULARUNITS, PLANNEDLAG, PLANNEDUNITSPERTIME, ACTUALOVERTIMEUNITS, PENDINGACTUALOVERTIMEUNITS, ACTUALREGULARUNITS, REMAININGLAG, OVERTIMEFACTOR, PLANNEDCOST, ACTUALREGULARCOST, ACTUALOVERTIMECOST, REMAININGCOST, ACTUALSTARTDATE, ACTUALFINISHDATE, REMAININGSTARTDATE, REMAININGFINISHDATE, PLANNEDSTARTDATE, PLANNEDFINISHDATE, REMAININGLATESTARTDATE, REMAININGLATEFINISHDATE, RATETYPE, ACTUALTHISPERIODCOST, ACTUALTHISPERIODUNITS, RESOURCECURVEOBJECTID, DRIVINGACTIVITYDATESFLAG, RATESOURCE, ACTIVITYID, ACTIVITYNAME, ACTUALCOST, ACTUALDURATION, ACTUALUNITS, ATCOMPLETIONCOST
  , ATCOMPLETIONDURATION, ATCOMPLETIONUNITS, AUTOCOMPUTEACTUALS, CALENDAROBJECTID, COSTACCOUNTID, COSTACCOUNTNAME, FINISHDATE, ISACTIVE, ISOVERTIMEALLOWED, ISPRIMARYRESOURCE, PLANNEDDURATION, PRICEPERUNIT, PROJECTID, REMAININGDURATION, RESOURCECURVENAME, RESOURCEID, RESOURCENAME, ROLEID, ROLENAME, STAFFEDREMAININGCOST, STAFFEDREMAININGUNITS, STARTDATE, UNITSPERCENTCOMPLETE, UNSTAFFEDREMAININGCOST, UNSTAFFEDREMAININGUNITS, WBSOBJECTID, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE, LASTUPDATEDATEX, RPT_CURRENT_FLAG)
AS
  SELECT a.taskrsrc_id objectid ,
    a.task_id activityobjectid ,
    a.proj_id projectobjectid ,
    CASE a.rsrc_type
      WHEN 'RT_Labor'
      THEN 'Labor'
      WHEN 'RT_Equip'
      THEN 'Nonlabor'
      WHEN 'RT_Mat'
      THEN 'Material'
      ELSE a.rsrc_type
    END resourcetype ,
    a.cost_qty_link_flag iscostunitslinked ,
    a.role_id roleobjectid ,
    a.acct_id costaccountobjectid ,
    a.rsrc_id resourceobjectid ,
    P.proficiency proficiency ,
    a.pend_complete_pct pendingpercentcomplete ,
    a.remain_qty remainingunits ,
    a.pend_remain_qty pendingremainingunits ,
    a.target_qty plannedunits ,
    a.remain_qty_per_hr remainingunitspertime ,
    a.pend_act_reg_qty pendingactualregularunits ,
    a.target_lag_drtn_hr_cnt plannedlag ,
    a.target_qty_per_hr plannedunitspertime ,
    a.act_ot_qty actualovertimeunits ,
    a.pend_act_ot_qty pendingactualovertimeunits ,
    a.act_reg_qty actualregularunits ,
    P.remaininglag remaininglag ,
    a.ot_factor overtimefactor ,
    a.target_cost plannedcost ,
    a.act_reg_cost actualregularcost ,
    a.act_ot_cost actualovertimecost ,
    a.remain_cost remainingcost ,
    a.act_start_date actualstartdate ,
    a.act_end_date actualfinishdate ,
    a.restart_date remainingstartdate ,
    a.reend_date remainingfinishdate ,
    a.target_start_date plannedstartdate ,
    a.target_end_date plannedfinishdate ,
    a.rem_late_start_date remaininglatestartdate ,
    a.rem_late_end_date remaininglatefinishdate ,
    CASE a.rate_type
      WHEN 'COST_PER_QTY'
      THEN 'Price/Unit'
      WHEN 'COST_PER_QTY2'
      THEN 'Price/Unit 2'
      WHEN 'COST_PER_QTY3'
      THEN 'Price/Unit 3'
      WHEN 'COST_PER_QTY4'
      THEN 'Price/Unit 4'
      WHEN 'COST_PER_QTY5'
      THEN 'Price/Unit 5'
      ELSE a.rate_type
    END ratetype ,
    a.act_this_per_cost actualthisperiodcost ,
    a.act_this_per_qty actualthisperiodunits ,
    a.curv_id resourcecurveobjectid ,
    a.rollup_dates_flag drivingactivitydatesflag ,
    CASE a.cost_per_qty_source_type
      WHEN 'ST_Rsrc'
      THEN 'Resource'
      WHEN 'ST_Role'
      THEN 'Role'
      WHEN 'ST_Custom'
      THEN 'Override'
      ELSE a.cost_per_qty_source_type
    END ratesource ,
    P.activityid activityid ,
    P.activityname activityname ,
    P.actualcost actualcost ,
    P.actualduration actualduration ,
    P.actualunits actualunits ,
    P.atcompletioncost atcompletioncost ,
    P.atcompletionduration atcompletionduration ,
    P.atcompletionunits atcompletionunits ,
    P.autocomputeactuals autocomputeactuals ,
    P.calendarobjectid calendarobjectid ,
    P.costaccountid costaccountid ,
    P.costaccountname costaccountname ,
    P.finishdate finishdate ,
    P.isactive isactive ,
    P.isovertimeallowed isovertimeallowed ,
    P.isprimaryresource isprimaryresource ,
    P.plannedduration plannedduration ,
    P.priceperunit priceperunit ,
    P.projectid projectid ,
    P.remainingduration remainingduration ,
    P.resourcecurvename resourcecurvename ,
    P.resourceid resourceid ,
    P.resourcename resourcename ,
    P.roleid roleid ,
    P.rolename rolename ,
    P.staffedremainingcost staffedremainingcost ,
    P.staffedremainingunits staffedremainingunits ,
    P.startdate startdate ,
    P.unitspercentcomplete unitspercentcomplete ,
    P.unstaffedremainingcost unstaffedremainingcost ,
    P.unstaffedremainingunits unstaffedremainingunits ,
    P.wbsobjectid wbsobjectid ,
    a.update_user lastupdateuser ,
    a.update_date lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate ,
    P.update_date lastupdatedatex ,
    CASE
      WHEN a.update_date>P.update_date
      THEN 'N'
      ELSE 'Y'
    END rpt_current_flag
   FROM ${pm.or.administrative_user}.TASKRSRC A
  INNER JOIN ${pm.or.administrative_user}.TASKRSRCX P ON a.taskrsrc_id           = p.taskrsrc_id
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab ON a.proj_id = projects_tab.proj_id AND projects_tab.etl_interval = 0 AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  WHERE A.DELETE_SESSION_ID IS NULL
  /
  
--METADATA NAME:RESOURCEASSIGNMENTSPREAD_RT TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE  
CREATE OR REPLACE VIEW RESOURCEASSIGNMENTSPREAD_RT (RESOURCEASSIGNMENTOBJECTID, STARTDATE, ENDDATE, RESOURCEOBJECTID, ROLEOBJECTID, ACTIVITYOBJECTID, WBSOBJECTID, PROJECTOBJECTID, COSTACCOUNTOBJECTID, ACTUALREGULARUNITS, ACTUALOVERTIMEUNITS, ACTUALUNITS, ATCOMPLETIONUNITS, PLANNEDUNITS, REMAININGUNITS, REMAININGLATEUNITS, STAFFEDREMAININGUNITS, STAFFEDREMAININGLATEUNITS, UNSTAFFEDREMAININGUNITS, UNSTAFFEDREMAININGLATEUNITS, ACTUALREGULARCOST, ACTUALOVERTIMECOST, ACTUALCOST, ATCOMPLETIONCOST, PLANNEDCOST, REMAININGCOST, REMAININGLATECOST, STAFFEDREMAININGCOST, STAFFEDREMAININGLATECOST, UNSTAFFEDREMAININGCOST, UNSTAFFEDREMAININGLATECOST, LASTUPDATEDATE, CBSOBJECTID)
AS
  SELECT a.RESOURCEASSIGNMENTOBJECTID,
    a.STARTDATE,
    a.ENDDATE,
    a.RESOURCEOBJECTID,
    a.ROLEOBJECTID,
    a.ACTIVITYOBJECTID,
    a.WBSOBJECTID,
    a.PROJECTOBJECTID,
    a.COSTACCOUNTOBJECTID,
    a.ACTUALREGULARUNITS,
    a.ACTUALOVERTIMEUNITS,
    a.ACTUALUNITS,
    a.ATCOMPLETIONUNITS,
    a.PLANNEDUNITS,
    a.REMAININGUNITS,
    a.REMAININGLATEUNITS,
    a.STAFFEDREMAININGUNITS,
    a.STAFFEDREMAININGLATEUNITS,
    a.UNSTAFFEDREMAININGUNITS,
    a.UNSTAFFEDREMAININGLATEUNITS,
    a.ACTUALREGULARCOST,
    a.ACTUALOVERTIMECOST,
    a.ACTUALCOST,
    a.ATCOMPLETIONCOST,
    a.PLANNEDCOST,
    a.REMAININGCOST,
    a.REMAININGLATECOST,
    a.STAFFEDREMAININGCOST,
    a.STAFFEDREMAININGLATECOST,
    a.UNSTAFFEDREMAININGCOST,
    a.UNSTAFFEDREMAININGLATECOST,
    a.update_date,
    T1.cbs_id cbsobjectid
   FROM ${pm.or.administrative_user}.RESOURCEASSIGNMENTSPREAD a
  INNER JOIN ${pm.or.administrative_user}.TASKRSRC T1  ON T1.taskrsrc_id         = ResourceAssignmentObjectId
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab ON a.projectobjectid = projects_tab.proj_id AND projects_tab.etl_interval = 0 AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  AND T1.DELETE_SESSION_ID IS NULL
  /
  
--METADATA NAME:RISK_RT TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE  
CREATE OR REPLACE VIEW RISK_RT (OBJECTID, PROJECTOBJECTID, ID, NAME, TOTALCOST, RESOURCEOBJECTID, RISKCATEGORYOBJECTID, RISKTYPE, RISKSTATUS, DESCRIPTION, EFFECT, CAUSE, NOTE, SCORE, SCORETEXT, SCORECOLOR, EXPOSURE, IDENTIFIEDBYRESOURCEOBJECTID, IDENTIFIEDBYRESOURCEID, IDENTIFIEDBYRESOURCENAME, IDENTIFIEDDATE, EXPOSURESTARTDATE, EXPOSUREFINISHDATE, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE)
AS
  SELECT a.risk_id objectid ,
    a.proj_id projectobjectid ,
    a.id id ,
    a.name name ,
    a.total_cost totalcost ,
    a.rsrc_id resourceobjectid ,
    a.category_id riskcategoryobjectid ,
    CASE a.type
      WHEN 'RT_Threat'
      THEN 'Threat'
      WHEN 'RT_Opport'
      THEN 'Opportunity'
      ELSE a.type
    END risktype ,
    CASE a.status
      WHEN 'RS_Propose'
      THEN 'Proposed'
      WHEN 'RS_Open'
      THEN 'Open'
      WHEN 'RS_Active'
      THEN 'Active'
      WHEN 'RS_Reject'
      THEN 'Rejected (Closed)'
      WHEN 'RS_Manage'
      THEN 'Managed (Closed)'
      WHEN 'RS_Impact'
      THEN 'Impacted (Closed)'
      ELSE a.status
    END riskstatus ,
    a.description description ,
    a.effect effect ,
    a.cause cause ,
    a.note note ,
    P.score score ,
    P.scoretext scoretext ,
    P.scorecolor scorecolor ,
    P.exposure exposure ,
    a.identified_by_id identifiedbyresourceobjectid ,
    P.identifiedbyresourceid identifiedbyresourceid ,
    P.identifiedbyresourcename identifiedbyresourcename ,
    a.identified_date identifieddate ,
    P.exposurestartdate exposurestartdate ,
    P.exposurefinishdate exposurefinishdate ,
    a.update_user lastupdateuser ,
    a.update_date lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate
   FROM ${pm.or.administrative_user}.RISK A
  INNER JOIN ${pm.or.administrative_user}.RISKX P  ON a.risk_id               = p.risk_id
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab ON a.proj_id = projects_tab.proj_id AND projects_tab.etl_interval = 0 AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  WHERE A.DELETE_SESSION_ID IS NULL
  /
  
--METADATA NAME:WBS_RT TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE  
CREATE OR REPLACE VIEW WBS_RT (OBJECTID, PROJECTOBJECTID, OBSOBJECTID, SEQUENCENUMBER, CONTAINSSUMMARYDATA, STATUS, CODE, NAME, WBSCATEGORYOBJECTID, PARENTOBJECTID, EARNEDVALUEUSERPERCENT, EARNEDVALUEETCUSERVALUE, ORIGINALBUDGET, INDEPENDENTETCTOTALCOST, INDEPENDENTETCLABORUNITS, ANTICIPATEDSTARTDATE, ANTICIPATEDFINISHDATE, EARNEDVALUECOMPUTETYPE, EARNEDVALUEETCCOMPUTETYPE, CURRENTBUDGET, CURRENTVARIANCE, DISTRIBUTEDCURRENTBUDGET, FINISHDATE, FORECASTFINISHDATE, FORECASTSTARTDATE, FULLNAME, FULLSEQUENCE, OBSNAME, PROJECTID, PROPOSEDBUDGET, STARTDATE, SUMPLANNEDSTARTDATE, SUMPLANNEDFINISHDATE, SUMPLANNEDDURATION, SUMPLANNEDLABORUNITS, SUMPLANNEDNONLABORUNITS, SUMPLANNEDEXPENSECOST, SUMPLANNEDLABORCOST, SUMPLANNEDMATERIALCOST, SUMPLANNEDNONLABORCOST, SUMPLANNEDTOTALCOST, SUMACCOUNTINGVARBYLABORUNITS, SUMACCOUNTINGVARIANCEBYCOST, SUMACTTHISPERIODMATERIALCOST,
  SUMACTTHISPERIODNONLABORCOST, SUMACTTHISPERIODNONLABORUNITS, SUMACTUALTHISPERIODLABORCOST, SUMACTUALTHISPERIODLABORUNITS, SUMATCOMPLETIONMATERIALCOST, SUMATCOMPLETIONNONLABORCOST, SUMATCOMPLETIONNONLABORUNITS, SUMATCOMPLETIONTOTALCOSTVAR, SUMBASELINECOMPACTIVITYCOUNT, SUMBASELINENOTSTARTEDACTCNT, SUMBLINPROGRESSACTIVITYCOUNT, SUMBUDGETATCMPBYLABORUNITS, SUMBUDGETATCOMPLETIONBYCOST, SUMCOSTPERFINDEXBYCOST, SUMCOSTPERFINDEXBYLABORUNITS, SUMCOSTVARIANCEBYLABORUNITS, SUMCOSTVARINDEXBYLABORUNITS, SUMDURATIONPERCENTOFPLANNED, SUMEACBYCOST, SUMEACBYLABORUNITS, SUMEACHIGHPCTBYLABORUNITS, SUMEACLOWPCTBYLABORUNITS, SUMETCBYCOST, SUMETCBYLABORUNITS, SUMEXPENSECOSTPCTCOMPLETE, SUMLABORCOSTPERCENTCOMPLETE, SUMLABORUNITSPERCENTCOMPLETE, SUMACTIVITYCOUNT, SUMACTUALDURATION, SUMACTUALEXPENSECOST, SUMACTUALFINISHDATE, SUMMAXACTUALFINISHDATE, SUMMAXRESTARTDATE, SUMACTUALLABORCOST, SUMACTUALLABORUNITS, SUMACTUALMATERIALCOST,
  SUMACTUALNONLABORCOST, SUMACTUALNONLABORUNITS, SUMACTUALSTARTDATE, SUMACTUALTHISPERIODCOST, SUMACTUALTOTALCOST, SUMACTUALVALUEBYCOST, SUMACTUALVALUEBYLABORUNITS, SUMATCOMPLETIONDURATION, SUMATCOMPLETIONEXPENSECOST, SUMATCOMPLETIONLABORCOST, SUMATCOMPLETIONLABORUNITS, SUMATCOMPLETIONTOTALCOST, SUMBASELINEDURATION, SUMBASELINEEXPENSECOST, SUMBASELINEFINISHDATE, SUMBASELINELABORCOST, SUMBASELINELABORUNITS, SUMBASELINEMATERIALCOST, SUMBASELINENONLABORCOST, SUMBASELINENONLABORUNITS, SUMBASELINESTARTDATE, SUMBASELINETOTALCOST, SUMCOMPLETEDACTIVITYCOUNT, SUMCOSTPERCENTCOMPLETE, SUMCOSTPERCENTOFPLANNED, SUMCOSTVARIANCEBYCOST, SUMCOSTVARIANCEINDEX, SUMCOSTVARIANCEINDEXBYCOST, SUMDURATIONPERCENTCOMPLETE, SUMDURATIONVARIANCE, SUMEARNEDVALUEBYCOST, SUMEARNEDVALUEBYLABORUNITS, SUMEXPENSECOSTVARIANCE, SUMFINISHDATEVARIANCE, SUMINPROGRESSACTIVITYCOUNT, SUMLABORCOSTVARIANCE, SUMLABORUNITSVARIANCE, SUMMATERIALCOSTVARIANCE,
  SUMNONLABORCOSTVARIANCE, SUMNONLABORUNITSVARIANCE, SUMNOTSTARTEDACTIVITYCOUNT, SUMPLANNEDVALUEBYCOST, SUMPROGRESSFINISHDATE, SUMREMAININGDURATION, SUMREMAININGEXPENSECOST, SUMREMAININGFINISHDATE, SUMREMAININGLABORCOST, SUMREMAININGLABORUNITS, SUMREMAININGMATERIALCOST, SUMREMAININGNONLABORCOST, SUMREMAININGNONLABORUNITS, SUMREMAININGSTARTDATE, SUMREMAININGTOTALCOST, SUMSCHEDULEPERCENTCOMPLETE, SUMPERFORMANCEPERCENTCOMPLETE, SUMSCHEDULEVARIANCEBYCOST, SUMSCHEDULEVARIANCEINDEX, SUMSTARTDATEVARIANCE, SUMTOTALCOSTVARIANCE, SUMTOTALFLOAT, SUMUNITSPERCENTCOMPLETE, SUMMATERIALCOSTPCTCOMPLETE, SUMNONLABORCOSTPCTCOMPLETE, SUMNONLABORUNITSPCTCOMPLETE, SUMPERFPCTCMPBYLABORUNITS, SUMPLANNEDVALUEBYLABORUNITS, SUMSCHDPCTCMPBYLABORUNITS, SUMSCHDPERFINDEXBYLABORUNITS, SUMSCHDVARIANCEBYLABORUNITS, SUMSCHDVARIANCEINDEXBYCOST, SUMSCHDVARINDEXBYLABORUNITS, SUMSCHEDULEPERFINDEXBYCOST, SUMTOCOMPLETEPERFINDEXBYCOST,
  SUMVARATCMPBYLABORUNITS, SUMEARLYSTARTDATE, SUMEARLYENDDATE, SUMLATESTARTDATE, SUMLATEENDDATE, SUMMAXCALENDARID, SUMMINCALENDARID, TOTALBENEFITPLAN, TOTALBENEFITPLANTALLY, TOTALSPENDINGPLAN, TOTALSPENDINGPLANTALLY, UNALLOCATEDBUDGET, UNDISTRIBUTEDCURRENTVARIANCE, STATUSREVIEWEROBJECTID, STATUSREVIEWERNAME, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE, LASTUPDATEDATEX, RPT_CURRENT_FLAG, PROJECTNODEFLAG)
AS
  SELECT a.wbs_id objectid ,
    a.proj_id projectobjectid ,
    a.obs_id obsobjectid ,
    a.seq_num sequencenumber ,
    a.sum_data_flag containssummarydata ,
    CASE a.status_code
      WHEN 'WS_Planned'
      THEN 'Planned'
      WHEN 'WS_Open'
      THEN 'Active'
      WHEN 'WS_Closed'
      THEN 'Inactive'
      WHEN 'WS_Whatif'
      THEN 'What If'
      WHEN 'WS_Requested'
      THEN 'Requested'
      WHEN 'WS_Template'
      THEN 'Template'
      WHEN 'WS_Planned'
      THEN 'Planned'
      WHEN 'WS_Open'
      THEN 'Active'
      WHEN 'WS_Closed'
      THEN 'Inactive'
      WHEN 'WS_Whatif'
      THEN 'What If'
      WHEN 'WS_Requested'
      THEN 'Requested'
      WHEN 'WS_Template'
      THEN 'Template'
      ELSE a.status_code
    END status ,
    a.wbs_short_name code ,
    a.wbs_name name ,
    a.phase_id wbscategoryobjectid ,
    a.parent_wbs_id parentobjectid ,
    a.ev_user_pct earnedvalueuserpercent ,
    a.ev_etc_user_value earnedvalueetcuservalue ,
    a.orig_cost originalbudget ,
    a.indep_remain_total_cost independentetctotalcost ,
    a.indep_remain_work_qty independentetclaborunits ,
    a.anticip_start_date anticipatedstartdate ,
    a.anticip_end_date anticipatedfinishdate ,
    CASE a.ev_compute_type
      WHEN 'EC_Cmp_pct'
      THEN 'Activity Percent Complete'
      WHEN 'EC_0_pct'
      THEN 'Zero Hundred'
      WHEN 'EC_50_pct'
      THEN 'Fifty Fifty'
      WHEN 'EC_User_pct'
      THEN 'Custom Percent Complete'
      WHEN 'EC_MS'
      THEN 'WBS Milestones Percent Complete'
      WHEN 'EC_Curve'
      THEN 'Activity Percent Complete Using Resource Curve'
      WHEN 'EC_Cmp_pct'
      THEN 'Activity Percent Complete'
      WHEN 'EC_0_pct'
      THEN 'Zero Hundred'
      WHEN 'EC_50_pct'
      THEN 'Fifty Fifty'
      WHEN 'EC_User_pct'
      THEN 'Custom Percent Complete'
      WHEN 'EC_MS'
      THEN 'WBS Milestones Percent Complete'
      WHEN 'EC_Curve'
      THEN 'Activity Percent Complete Using Resource Curve'
      ELSE a.ev_compute_type
    END earnedvaluecomputetype ,
    CASE a.ev_etc_compute_type
      WHEN 'EE_Rem_hr'
      THEN 'Remaining Cost For Activity'
      WHEN 'EE_PF_1'
      THEN 'PF 1'
      WHEN 'EE_PF_user'
      THEN 'PF Custom'
      WHEN 'EE_PF_cpi'
      THEN 'PF CPI'
      WHEN 'EE_PF_cpi_spi'
      THEN 'PF CPI SPI'
      WHEN 'EE_Rem_hr'
      THEN 'Remaining Cost For Activity'
      WHEN 'EE_PF_1'
      THEN 'PF 1'
      WHEN 'EE_PF_user'
      THEN 'PF Custom'
      WHEN 'EE_PF_cpi'
      THEN 'PF CPI'
      WHEN 'EE_PF_cpi_spi'
      THEN 'PF CPI SPI'
      ELSE a.ev_etc_compute_type
    END earnedvalueetccomputetype ,
    P.currentbudget currentbudget ,
    P.currentvariance currentvariance ,
    P.distributedcurrentbudget distributedcurrentbudget ,
    P.finishdate finishdate ,
    P.forecastfinishdate forecastfinishdate ,
    P.forecaststartdate forecaststartdate ,
    P.fullname fullname ,
    P.fullsequence fullsequence ,
    P.obsname obsname ,
    P.projectid projectid ,
    P.proposedbudget proposedbudget ,
    P.startdate startdate ,
    P.sumplannedstartdate sumplannedstartdate ,
    P.sumplannedfinishdate sumplannedfinishdate ,
    P.sumplannedduration sumplannedduration ,
    P.sumplannedlaborunits sumplannedlaborunits ,
    P.sumplannednonlaborunits sumplannednonlaborunits ,
    P.sumplannedexpensecost sumplannedexpensecost ,
    P.sumplannedlaborcost sumplannedlaborcost ,
    P.sumplannedmaterialcost sumplannedmaterialcost ,
    P.sumplannednonlaborcost sumplannednonlaborcost ,
    P.sumplannedtotalcost sumplannedtotalcost ,
    P.sumaccountingvarbylaborunits sumaccountingvarbylaborunits ,
    P.sumaccountingvariancebycost sumaccountingvariancebycost ,
    P.sumactthisperiodmaterialcost sumactthisperiodmaterialcost ,
    P.sumactthisperiodnonlaborcost sumactthisperiodnonlaborcost ,
    P.sumactthisperiodnonlaborunits sumactthisperiodnonlaborunits ,
    P.sumactualthisperiodlaborcost sumactualthisperiodlaborcost ,
    P.sumactualthisperiodlaborunits sumactualthisperiodlaborunits ,
    P.sumatcompletionmaterialcost sumatcompletionmaterialcost ,
    P.sumatcompletionnonlaborcost sumatcompletionnonlaborcost ,
    P.sumatcompletionnonlaborunits sumatcompletionnonlaborunits ,
    P.sumatcompletiontotalcostvar sumatcompletiontotalcostvar ,
    P.sumbaselinecompactivitycount sumbaselinecompactivitycount ,
    P.sumbaselinenotstartedactcnt sumbaselinenotstartedactcnt ,
    P.sumblinprogressactivitycount sumblinprogressactivitycount ,
    P.sumbudgetatcmpbylaborunits sumbudgetatcmpbylaborunits ,
    P.sumbudgetatcompletionbycost sumbudgetatcompletionbycost ,
    P.sumcostperfindexbycost sumcostperfindexbycost ,
    P.sumcostperfindexbylaborunits sumcostperfindexbylaborunits ,
    P.sumcostvariancebylaborunits sumcostvariancebylaborunits ,
    P.sumcostvarindexbylaborunits sumcostvarindexbylaborunits ,
    P.sumdurationpercentofplanned sumdurationpercentofplanned ,
    P.sumeacbycost sumeacbycost ,
    P.sumeacbylaborunits sumeacbylaborunits ,
    P.sumeachighpctbylaborunits sumeachighpctbylaborunits ,
    P.sumeaclowpctbylaborunits sumeaclowpctbylaborunits ,
    P.sumetcbycost sumetcbycost ,
    P.sumetcbylaborunits sumetcbylaborunits ,
    P.sumexpensecostpctcomplete sumexpensecostpctcomplete ,
    P.sumlaborcostpercentcomplete sumlaborcostpercentcomplete ,
    P.sumlaborunitspercentcomplete sumlaborunitspercentcomplete ,
    P.sumactivitycount sumactivitycount ,
    P.sumactualduration sumactualduration ,
    P.sumactualexpensecost sumactualexpensecost ,
    P.sumactualfinishdate sumactualfinishdate ,
    P.summaxactualfinishdate summaxactualfinishdate ,
    P.summaxrestartdate summaxrestartdate ,
    P.sumactuallaborcost sumactuallaborcost ,
    P.sumactuallaborunits sumactuallaborunits ,
    P.sumactualmaterialcost sumactualmaterialcost ,
    P.sumactualnonlaborcost sumactualnonlaborcost ,
    P.sumactualnonlaborunits sumactualnonlaborunits ,
    P.sumactualstartdate sumactualstartdate ,
    P.sumactualthisperiodcost sumactualthisperiodcost ,
    P.sumactualtotalcost sumactualtotalcost ,
    P.sumactualvaluebycost sumactualvaluebycost ,
    P.sumactualvaluebylaborunits sumactualvaluebylaborunits ,
    P.sumatcompletionduration sumatcompletionduration ,
    P.sumatcompletionexpensecost sumatcompletionexpensecost ,
    P.sumatcompletionlaborcost sumatcompletionlaborcost ,
    P.sumatcompletionlaborunits sumatcompletionlaborunits ,
    P.sumatcompletiontotalcost sumatcompletiontotalcost ,
    P.sumbaselineduration sumbaselineduration ,
    P.sumbaselineexpensecost sumbaselineexpensecost ,
    P.sumbaselinefinishdate sumbaselinefinishdate ,
    P.sumbaselinelaborcost sumbaselinelaborcost ,
    P.sumbaselinelaborunits sumbaselinelaborunits ,
    P.sumbaselinematerialcost sumbaselinematerialcost ,
    P.sumbaselinenonlaborcost sumbaselinenonlaborcost ,
    P.sumbaselinenonlaborunits sumbaselinenonlaborunits ,
    P.sumbaselinestartdate sumbaselinestartdate ,
    P.sumbaselinetotalcost sumbaselinetotalcost ,
    P.sumcompletedactivitycount sumcompletedactivitycount ,
    P.sumcostpercentcomplete sumcostpercentcomplete ,
    P.sumcostpercentofplanned sumcostpercentofplanned ,
    P.sumcostvariancebycost sumcostvariancebycost ,
    P.sumcostvarianceindex sumcostvarianceindex ,
    P.sumcostvarianceindexbycost sumcostvarianceindexbycost ,
    P.sumdurationpercentcomplete sumdurationpercentcomplete ,
    P.sumdurationvariance sumdurationvariance ,
    P.sumearnedvaluebycost sumearnedvaluebycost ,
    P.sumearnedvaluebylaborunits sumearnedvaluebylaborunits ,
    P.sumexpensecostvariance sumexpensecostvariance ,
    P.sumfinishdatevariance sumfinishdatevariance ,
    P.suminprogressactivitycount suminprogressactivitycount ,
    P.sumlaborcostvariance sumlaborcostvariance ,
    P.sumlaborunitsvariance sumlaborunitsvariance ,
    P.summaterialcostvariance summaterialcostvariance ,
    P.sumnonlaborcostvariance sumnonlaborcostvariance ,
    P.sumnonlaborunitsvariance sumnonlaborunitsvariance ,
    P.sumnotstartedactivitycount sumnotstartedactivitycount ,
    P.sumplannedvaluebycost sumplannedvaluebycost ,
    P.sumprogressfinishdate sumprogressfinishdate ,
    P.sumremainingduration sumremainingduration ,
    P.sumremainingexpensecost sumremainingexpensecost ,
    P.sumremainingfinishdate sumremainingfinishdate ,
    P.sumremaininglaborcost sumremaininglaborcost ,
    P.sumremaininglaborunits sumremaininglaborunits ,
    P.sumremainingmaterialcost sumremainingmaterialcost ,
    P.sumremainingnonlaborcost sumremainingnonlaborcost ,
    P.sumremainingnonlaborunits sumremainingnonlaborunits ,
    P.sumremainingstartdate sumremainingstartdate ,
    P.sumremainingtotalcost sumremainingtotalcost ,
    P.sumschedulepercentcomplete sumschedulepercentcomplete ,
    P.sumperformancepercentcomplete sumperformancepercentcomplete ,
    P.sumschedulevariancebycost sumschedulevariancebycost ,
    P.sumschedulevarianceindex sumschedulevarianceindex ,
    P.sumstartdatevariance sumstartdatevariance ,
    P.sumtotalcostvariance sumtotalcostvariance ,
    P.sumtotalfloat sumtotalfloat ,
    P.sumunitspercentcomplete sumunitspercentcomplete ,
    P.summaterialcostpctcomplete summaterialcostpctcomplete ,
    P.sumnonlaborcostpctcomplete sumnonlaborcostpctcomplete ,
    P.sumnonlaborunitspctcomplete sumnonlaborunitspctcomplete ,
    P.sumperfpctcmpbylaborunits sumperfpctcmpbylaborunits ,
    P.sumplannedvaluebylaborunits sumplannedvaluebylaborunits ,
    P.sumschdpctcmpbylaborunits sumschdpctcmpbylaborunits ,
    P.sumschdperfindexbylaborunits sumschdperfindexbylaborunits ,
    P.sumschdvariancebylaborunits sumschdvariancebylaborunits ,
    P.sumschdvarianceindexbycost sumschdvarianceindexbycost ,
    P.sumschdvarindexbylaborunits sumschdvarindexbylaborunits ,
    P.sumscheduleperfindexbycost sumscheduleperfindexbycost ,
    P.sumtocompleteperfindexbycost sumtocompleteperfindexbycost ,
    P.sumvaratcmpbylaborunits sumvaratcmpbylaborunits ,
    P.sumearlystartdate sumearlystartdate ,
    P.sumearlyenddate sumearlyenddate ,
    P.sumlatestartdate sumlatestartdate ,
    P.sumlateenddate sumlateenddate ,
    P.summaxcalendarid summaxcalendarid ,
    P.summincalendarid summincalendarid ,
    P.totalbenefitplan totalbenefitplan ,
    P.totalbenefitplantally totalbenefitplantally ,
    P.totalspendingplan totalspendingplan ,
    P.totalspendingplantally totalspendingplantally ,
    P.unallocatedbudget unallocatedbudget ,
    P.undistributedcurrentvariance undistributedcurrentvariance ,
    a.status_reviewer statusreviewerobjectid ,
    P.statusreviewername statusreviewername ,
    a.update_user lastupdateuser ,
    a.update_date lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate ,
    P.update_dim_date lastupdatedatex ,
    CASE
      WHEN a.update_date>P.update_date
      THEN 'N'
      ELSE 'Y'
    END rpt_current_flag ,
    A.proj_node_flag
   FROM ${pm.or.administrative_user}.PROJWBS A
  INNER JOIN ${pm.or.administrative_user}.PROJWBSX P
  ON a.wbs_id = p.wbs_id
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab
  ON a.proj_id                   = projects_tab.proj_id
  WHERE A.DELETE_SESSION_ID     IS NULL
  AND projects_tab.ETL_INTERVAL  = 0
  AND projects_tab.PROJECT_FLAG  = 'Y'
  AND projects_tab.ORIG_PROJ_ID IS NULL
  /
  
--METADATA NAME:REFRDELETE_RT TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE  
CREATE OR REPLACE VIEW REFRDELETE_RT (LASTUPDATEDATE, TABLENAME, OBJECTID, OBJECTID2, OBJECTID3, OBJECTID4, PROJECTOBJECTID)
AS
  SELECT a.DELETE_DATE,
    a.TABLE_NAME,
    a.PK1,
    a.PK2,
    a.PK3,
    a.PK4,
    a.PROJ_ID
  FROM ${pm.or.administrative_user}.REFRDEL a
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab ON a.proj_id = projects_tab.proj_id AND projects_tab.etl_interval = 0 AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  /
  
--METADATA NAME:WBSHIERARCHY_RT TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE  
CREATE OR REPLACE VIEW WBSHIERARCHY_RT (PARENTOBJECTID, PARENTPROJECTID, PARENTSEQUENCENUMBER, PARENTNAME, PARENTID, CHILDOBJECTID, CHILDPROJECTID, CHILDSEQUENCENUMBER, CHILDNAME, CHILDID, PARENTLEVELSBELOWROOT, CHILDLEVELSBELOWROOT, LEVELSBETWEEN, CHILDHASCHILDREN, FULLPATHNAME, LASTUPDATEDATE)
AS
  SELECT a.PARENTOBJECTID,
    a.PARENTPROJECTID,
    a.PARENTSEQUENCENUMBER,
    a.PARENTNAME,
    a.PARENTID,
    a.CHILDOBJECTID,
    a.CHILDPROJECTID,
    a.CHILDSEQUENCENUMBER,
    a.CHILDNAME,
    a.CHILDID,
    a.PARENTLEVELSBELOWROOT,
    a.CHILDLEVELSBELOWROOT,
    a.LEVELSBETWEEN,
    a.CHILDHASCHILDREN,
    a.FULLPATHNAME,
    a.update_date
   FROM ${pm.or.administrative_user}.WBSHIERARCHY a
  INNER JOIN ${pm.or.administrative_user}.PROJWBS T1  ON T1.wbs_id              = ParentObjectId  AND T1.DELETE_SESSION_ID IS NULL
  INNER JOIN ${pm.or.administrative_user}.PROJWBS T2  ON T2.wbs_id              = ChildObjectId  AND T2.DELETE_SESSION_ID IS NULL
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab ON T1.proj_id = projects_tab.proj_id AND projects_tab.etl_interval = 0 AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  /
  
--METADATA NAME:PROJECTCODEASSIGNMENT_RT TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE  
CREATE OR REPLACE VIEW PROJECTCODEASSIGNMENT_RT (PROJECTOBJECTID, PROJECTCODETYPEOBJECTID, PROJECTCODEOBJECTID, PROJECTCODEDESCRIPTION, PROJECTCODETYPENAME, PROJECTCODEVALUE, PROJECTNAME, ISSECURECODE, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE)
AS
  SELECT a.proj_id projectobjectid ,
    a.proj_catg_type_id projectcodetypeobjectid ,
    a.proj_catg_id projectcodeobjectid ,
    P.projectcodedescription projectcodedescription ,
    P.projectcodetypename projectcodetypename ,
    P.projectcodevalue projectcodevalue ,
    P.projectname projectname ,
    P.issecurecode issecurecode ,
    a.update_user lastupdateuser ,
    CASE
      WHEN a.update_date > P.update_date
      THEN a.update_date
      ELSE P.update_date
    END lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate
   FROM ${pm.or.administrative_user}.PROJPCAT A
  INNER JOIN ${pm.or.administrative_user}.PROJPCATX P  ON a.proj_id               = p.proj_id  AND a.proj_catg_type_id    = p.proj_catg_type_id
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab ON a.proj_id = projects_tab.proj_id AND projects_tab.etl_interval = 0 AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  WHERE A.DELETE_SESSION_ID IS NULL
/

--METADATA NAME:ACTIVITYCODEASSIGNMENT_RT TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYCODEASSIGNMENT_RT (ACTIVITYOBJECTID, ACTIVITYCODETYPEOBJECTID, ACTIVITYCODEOBJECTID, PROJECTOBJECTID, ACTIVITYCODEDESCRIPTION, ACTIVITYCODETYPENAME, ACTIVITYCODETYPESCOPE, ACTIVITYCODEVALUE, ACTIVITYID, ACTIVITYNAME, ISSECURECODE, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE)
AS
  SELECT a.task_id activityobjectid ,
    a.actv_code_type_id activitycodetypeobjectid ,
    a.actv_code_id activitycodeobjectid ,
    a.proj_id projectobjectid ,
    P.activitycodedescription activitycodedescription ,
    P.activitycodetypename activitycodetypename ,
    P.activitycodetypescope activitycodetypescope ,
    P.activitycodevalue activitycodevalue ,
    P.activityid activityid ,
    P.activityname activityname ,
    P.issecurecode issecurecode ,
    a.update_user lastupdateuser ,
    CASE
      WHEN a.update_date > P.update_date
      THEN a.update_date
      ELSE P.update_date
    END lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate
   FROM ${pm.or.administrative_user}.TASKACTV A
  INNER JOIN ${pm.or.administrative_user}.TASKACTVX P  ON a.task_id               = p.task_id  AND a.actv_code_type_id    = p.actv_code_type_id
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab ON a.proj_id = projects_tab.proj_id AND projects_tab.etl_interval = 0 AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  WHERE A.DELETE_SESSION_ID IS NULL
  /

--METADATA NAME:ACTIVITYCODE_RT TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE  
CREATE OR REPLACE VIEW ACTIVITYCODE_RT (OBJECTID, CODETYPEOBJECTID, SEQUENCENUMBER, CODEVALUE, PARENTOBJECTID, DESCRIPTION, CODETYPENAME, ISSECURECODE, PROJECTOBJECTID, CODETYPESCOPE, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE)
AS
  SELECT a.actv_code_id objectid ,
    a.actv_code_type_id codetypeobjectid ,
    a.seq_num sequencenumber ,
    a.short_name codevalue ,
    a.parent_actv_code_id parentobjectid ,
    a.actv_code_name description ,
    P.codetypename codetypename ,
    P.issecurecode issecurecode ,
    P.projectobjectid projectobjectid ,
    P.codetypescope codetypescope ,
    a.update_user lastupdateuser ,
    CASE
      WHEN a.update_date > P.update_date
      THEN a.update_date
      ELSE P.update_date
    END lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate
   FROM ${pm.or.administrative_user}.ACTVCODE A
  INNER JOIN ${pm.or.administrative_user}.ACTVCODEX P  ON a.actv_code_id          = p.actv_code_id
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab ON P.projectobjectid = projects_tab.proj_id AND projects_tab.etl_interval = 0 AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  WHERE A.DELETE_SESSION_ID IS NULL
  /
  
--METADATA NAME:ACTIVITYCODETYPE_RT TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE  
CREATE OR REPLACE VIEW ACTIVITYCODETYPE_RT (OBJECTID, LENGTH, SEQUENCENUMBER, NAME, SCOPE, PROJECTOBJECTID, EPSOBJECTID, ISSECURECODE, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE)
AS
  SELECT a.actv_code_type_id objectid ,
    a.actv_short_len LENGTH ,
    a.seq_num sequencenumber ,
    a.actv_code_type name ,
    CASE a.actv_code_type_scope
      WHEN 'AS_Global'
      THEN 'Global'
      WHEN 'AS_EPS'
      THEN 'EPS'
      WHEN 'AS_Project'
      THEN 'Project'
      ELSE a.actv_code_type_scope
    END scope ,
    CASE
      WHEN a.actv_code_type_scope = 'AS_Project'
      THEN a.proj_id
      ELSE NULL
    END projectobjectid ,
    CASE
      WHEN a.actv_code_type_scope = 'AS_EPS'
      THEN
        (SELECT MIN(p.wbs_id)
         FROM ${pm.or.administrative_user}.projwbs p
        WHERE p.proj_id     =a.proj_id
        AND p.proj_node_flag='Y'
        )
      ELSE NULL
    END epsobjectid ,
    a.super_flag issecurecode ,
    a.update_user lastupdateuser ,
    a.update_date lastupdatedate ,
    a.create_user createuser ,
    a.create_date createdate
   FROM ${pm.or.administrative_user}.ACTVTYPE A
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab ON a.proj_id = projects_tab.proj_id AND projects_tab.etl_interval = 0 AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  WHERE A.DELETE_SESSION_ID IS NULL
  /

--METADATA NAME:CALENDAR_RT TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE  
CREATE OR REPLACE VIEW CALENDAR_RT (OBJECTID, ISDEFAULT, NAME, PROJECTOBJECTID, BASECALENDAROBJECTID, LASTCHANGEDATE, TYPE, DAYDATE, WEEKDAYNUMBER, WORKDAYFLAG, TOTALWORKHOURS, WORKHOURSBYHALFHOUR, WORKDAYSTARTTIME, WORKDAYFINISHTIME, LASTUPDATEDATE)
AS
  SELECT a.clndr_id objectid ,
    a.default_flag isdefault ,
    a.clndr_name name ,
    a.proj_id projectobjectid ,
    a.base_clndr_id basecalendarobjectid ,
    a.last_chng_date lastchangedate ,
    CASE a.clndr_type
      WHEN 'CA_Base'
      THEN 'Global'
      WHEN 'CA_Project'
      THEN 'Project'
      WHEN 'CA_Rsrc'
      THEN 'Resource'
      ELSE a.clndr_type
    END type ,
    P.daydate daydate ,
    P.weekdaynumber weekdaynumber ,
    P.workdayflag workdayflag ,
    P.totalworkhours totalworkhours ,
    P.workhoursbyhalfhour workhoursbyhalfhour ,
    P.workdaystarttime workdaystarttime ,
    P.workdayfinishtime workdayfinishtime,
    CASE
      WHEN A.UPDATE_DATE > P.UPDATE_DATE
      THEN A.UPDATE_DATE
      ELSE P.UPDATE_DATE
    END LASTUPDATEDATE
   FROM ${pm.or.administrative_user}.CALENDAR A
  INNER JOIN ${pm.or.administrative_user}.CALENDARX P  ON a.clndr_id              = p.clndr_id
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab ON a.proj_id = projects_tab.proj_id AND projects_tab.etl_interval = 0 AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  WHERE A.DELETE_SESSION_ID IS NULL
  /

--METADATA NAME:PROJECTSECURITY_RT TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE  
CREATE OR REPLACE VIEW PROJECTSECURITY_RT (RDBMSUSERID, PROJECTOBJECTID, COSTFLAG, LASTUPDATEDATE)
AS
  SELECT a.RDBMSUSERID,
    a.PROJECTOBJECTID,
    a.COSTFLAG,
    a.update_date
   FROM ${pm.or.administrative_user}.PROJECTSECURITY a
  INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab ON a.PROJECTOBJECTID = projects_tab.proj_id AND projects_tab.etl_interval = 0 AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
  /

--METADATA NAME:RESASSIGNMENTPERIODACTUAL_RT TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE
CREATE OR REPLACE VIEW RESASSIGNMENTPERIODACTUAL_RT (FINANCIALPERIODOBJECTID, STARTDATE, ENDDATE, RESOURCEASSIGNMENTOBJECTID, ACTIVITYOBJECTID, PROJECTOBJECTID, ACTUALUNITS, ACTUALCOST, RESOURCETYPE, WBSOBJECTID, RESOURCEOBJECTID, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE) AS 
SELECT a.fin_dates_id financialperiodobjectid
,fd.start_date startdate
,fd.end_date enddate
,a.taskrsrc_id resourceassignmentobjectid
,a.task_id activityobjectid
,a.proj_id projectobjectid
,a.act_qty actualunits
,a.act_cost actualcost
,P.resourcetype resourcetype
,P.wbsobjectid wbsobjectid
,T.rsrc_id resourceobjectid
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.TRSRCFIN A 
INNER JOIN ${pm.or.administrative_user}.TRSRCFINX P
ON a.fin_dates_id = p.fin_dates_id and a.taskrsrc_id = p.taskrsrc_id
INNER JOIN ${pm.or.administrative_user}.taskrsrc T
ON a.taskrsrc_id = T.taskrsrc_id and a.proj_id = t.proj_id 
INNER JOIN ${pm.or.administrative_user}.FINDATES FD
ON a.fin_dates_id = fd.fin_dates_id 
INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab on a.proj_id = projects_tab.proj_id AND projects_tab.etl_interval = 0 AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
WHERE A.DELETE_SESSION_ID is null
/

--METADATA NAME:ACTIVITYPERIODACTUAL_RT TYPE:VIEW SET:PX VIEWS FOR PERFORMANCE CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYPERIODACTUAL_RT (FINANCIALPERIODOBJECTID, STARTDATE, ENDDATE, ACTIVITYOBJECTID, PROJECTOBJECTID, ACTUALLABORUNITS, ACTUALLABORCOST, ACTUALNONLABORUNITS, ACTUALNONLABORCOST, ACTUALMATERIALCOST, ACTUALEXPENSECOST, EARNEDVALUECOST, PLANNEDVALUELABORUNITS, PLANNEDVALUECOST, EARNEDVALUELABORUNITS, WBSOBJECTID, LASTUPDATEUSER, LASTUPDATEDATE, CREATEUSER, CREATEDATE) AS 
SELECT a.fin_dates_id financialperiodobjectid
,fd.start_date startdate
,fd.end_date enddate
,a.task_id activityobjectid
,a.proj_id projectobjectid
,a.act_work_qty actuallaborunits
,a.act_work_cost actuallaborcost
,a.act_equip_qty actualnonlaborunits
,a.act_equip_cost actualnonlaborcost
,a.act_mat_cost actualmaterialcost
,a.act_expense_cost actualexpensecost
,a.bcwp earnedvaluecost
,a.sched_work_qty plannedvaluelaborunits
,a.bcws plannedvaluecost
,a.perfm_work_qty earnedvaluelaborunits
,P.wbsobjectid wbsobjectid
,a.update_user lastupdateuser
,case when a.update_date > p.update_date then a.update_date else p.update_date end lastupdatedate
,a.create_user createuser
,a.create_date createdate
 FROM ${pm.or.administrative_user}.TASKFIN A 
INNER JOIN ${pm.or.administrative_user}.TASKFINX P
ON a.fin_dates_id = p.fin_dates_id and a.task_id = p.task_id
INNER JOIN ${pm.or.administrative_user}.FINDATES FD
ON a.fin_dates_id = fd.fin_dates_id 
INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab on a.proj_id = projects_tab.proj_id AND projects_tab.etl_interval = 0 AND projects_tab.PROJECT_FLAG = 'Y' AND projects_tab.ORIG_PROJ_ID IS NULL
WHERE A.DELETE_SESSION_ID is null
/
--METADATA NAME:USER_LOGIN_DTLS TYPE:VIEW SET:USESSION DATA FOR ANALYTICS CHANGE:CREATE
CREATE OR REPLACE VIEW USER_LOGIN_DTLS 
(USER_ID,USER_NAME,LOG_IN_DATE_AND_TIME,LOG_OUT_DATE_AND_TIME,TOTAL_TIME_LOGGED_IN,APP_NAME,HOST_NAME)
AS
SELECT USER_ID,USER_NAME,
TO_CHAR(LOGIN_DATE , 'DD-MM-YYYY HH24:MI:SS') as LOG_IN_DATE_AND_TIME,
TO_CHAR(LOGOUT_DATE , 'DD-MM-YYYY HH24:MI:SS') as LOG_OUT_DATE_AND_TIME,
TO_CHAR(trim(to_char(trunc(24*mod(LOGOUT_DATE - LOGIN_DATE,1)),'99999'))||':'||
trim(to_char(trunc( mod(mod(LOGOUT_DATE - LOGIN_DATE,1)*24,1)*60 ),'99'))||':'||
trim(to_char(mod(mod(mod(LOGOUT_DATE - LOGIN_DATE,1)*24,1)*60,1)*60,'99'))) AS TOTAL_TIME_LOGGED_IN,
case 
when APP_NAME = 'Projects' then 'P6 Web'
when APP_NAME = 'Resources' then 'P6 Web'
when APP_NAME = 'Portfolios' then 'P6 Web'
when APP_NAME = 'Enterprise Reports' then 'P6 Web'
when APP_NAME = 'P6 Optional Client' then 'P6 Client'
when APP_NAME = 'Team Member' then 'TM Web'
when APP_NAME = 'Web Services' then 'P6 Web Service'
when DB_ENGINE_TYPE = 'INT_OVR' then 'Integration API'
else APP_NAME
end APP_NAME,
HOST_NAME
FROM ${pm.or.administrative_user}.USESSAUD a
where not exists ( select 1 from ${pm.or.administrative_user}.USESSAUD b where b.login_date=a.login_date and b.logout_date=a.logout_date
                                          and app_name in ('Projects' ,'Resources' ,'Portfolios' ,'Enterprise Reports' ))
union all
select USER_ID,USER_NAME,
TO_CHAR(LOGIN_DATE , 'DD-MM-YYYY HH24:MI:SS') as LOG_IN_DATE_AND_TIME,
TO_CHAR(LOGOUT_DATE , 'DD-MM-YYYY HH24:MI:SS') as LOG_OUT_DATE_AND_TIME,
TO_CHAR(trim(to_char(trunc(24*mod(LOGOUT_DATE - LOGIN_DATE,1)),'99999'))||':'||
trim(to_char(trunc( mod(mod(LOGOUT_DATE - LOGIN_DATE,1)*24,1)*60 ),'99'))||':'||
trim(to_char(mod(mod(mod(LOGOUT_DATE - LOGIN_DATE,1)*24,1)*60,1)*60,'99'))) AS TOTAL_TIME_LOGGED_IN,
case 
when APP_NAME = 'Projects' then 'P6 Web'
when APP_NAME = 'Resources' then 'P6 Web'
when APP_NAME = 'Portfolios' then 'P6 Web'
when APP_NAME = 'Enterprise Reports' then 'P6 Web'
when APP_NAME = 'P6 Optional Client' then 'P6 Client'
when APP_NAME = 'Team Member' then 'TM Web'
when APP_NAME = 'Web Services' then 'P6 Web Service'
when DB_ENGINE_TYPE = 'INT_OVR' then 'Integration API'
else APP_NAME
end APP_NAME,
HOST_NAME
from ${pm.or.administrative_user}.USESSAUD a
where rowid in ( select max(rowid) from ${pm.or.administrative_user}.USESSAUD b where b.login_date=a.login_date and b.logout_date=a.logout_date 
                                 and app_name in ('Projects' ,'Resources' ,'Portfolios' ,'Enterprise Reports' ))
order by LOG_IN_DATE_AND_TIME desc
/

--METADATA NAME:USER_LOGIN_DTLS TYPE:SYNONYM SET:USESSION DATA FOR ANALYTICS CHANGE:CREATE
CREATE OR REPLACE SYNONYM P6USER_LOGIN_DTLS for USER_LOGIN_DTLS
/

--METADATA NAME:USER_NOT_LOGGED_DTL TYPE:VIEW SET:USESSION DATA FOR ANALYTICS CHANGE:CREATE

CREATE OR REPLACE VIEW  USER_NOT_LOGGED_DTL (USER_ID, USER_NAME,LAST_ACTIVE_TIME) 
AS 
SELECT U.USER_ID,U.USER_NAME,US.LAST_ACTIVE_TIME from 
${pm.or.administrative_user}.USERS U LEFT OUTER JOIN ${pm.or.administrative_user}.USESSAUD US 
ON U.USER_ID=US.USER_ID
ORDER BY LAST_ACTIVE_TIME
/

--METADATA NAME:USER_NOT_LOGGED_DTL TYPE:SYNONYM SET:USESSION DATA FOR ANALYTICS CHANGE:CREATE
CREATE OR REPLACE SYNONYM P6USER_NOT_LOGGED_DTL FOR USER_NOT_LOGGED_DTL
/

--METADATA NAME:NEVER_LOGGED_USER_DTL TYPE:VIEW SET:USESSION DATA FOR ANALYTICS CHANGE:CREATE
CREATE OR REPLACE VIEW NEVER_LOGGED_USER_DTL(USER_ID, USER_NAME) 
AS 
SELECT USER_ID,USER_NAME 
FROM ${pm.or.administrative_user}.USERS U
WHERE NOT EXISTS(SELECT 1 FROM ${pm.or.administrative_user}.USERSET US WHERE US.USER_ID=U.USER_ID 
AND US.SETTING_NAME='WebLoggedIn')
ORDER BY USER_NAME
/

--METADATA NAME:NEVER_LOGGED_USER_DTL TYPE:SYNONYM SET:USESSION DATA FOR ANALYTICS CHANGE:CREATE
CREATE OR REPLACE SYNONYM P6NEVER_LOGGED_USER_DTL FOR NEVER_LOGGED_USER_DTL
/

prompt Creating Full View RESOURCEASSIGNMENTSPREAD_FULL
prompt Creating Full View RESOURCEASSIGNMENTSPREAD_FULL
--METADATA NAME:RESOURCEASSIGNMENTSPREAD_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCEASSIGNMENTSPREAD_FULL
AS SELECT 
ResourceAssignmentObjectId,
StartDate,
EndDate,
resourceobjectid,
RoleObjectId,
ActivityObjectId,
WBSObjectId,
projectobjectid,
CostAccountObjectId,
ActualRegularUnits,
ActualOvertimeUnits,
ActualUnits,
AtCompletionUnits,
PlannedUnits,
RemainingUnits,
RemainingLateUnits,
StaffedRemainingUnits,
StaffedRemainingLateUnits,
UnstaffedRemainingUnits,
UnstaffedRemainingLateUnits,
ActualRegularCost,
ActualOvertimeCost,
ActualCost,
AtCompletionCost,
PlannedCost,
RemainingCost,
RemainingLateCost,
StaffedRemainingCost,
StaffedRemainingLateCost,
UnstaffedRemainingCost,
UnstaffedRemainingLateCost,
lastupdatedate
FROM RESOURCEASSIGNMENTSPREAD
/
     
prompt Creating Project-Level View RESOURCEASSIGNMENTSPREAD_U
--METADATA NAME:RESOURCEASSIGNMENTSPREAD_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCEASSIGNMENTSPREAD_U
AS SELECT 
t.ResourceAssignmentObjectId,
t.StartDate,
t.EndDate,
t.resourceobjectid,
t.RoleObjectId,
t.ActivityObjectId,
t.WBSObjectId,
t.projectobjectid,
t.CostAccountObjectId,
t.ActualRegularUnits,
t.ActualOvertimeUnits,
t.ActualUnits,
t.AtCompletionUnits,
t.PlannedUnits,
t.RemainingUnits,
t.RemainingLateUnits,
t.StaffedRemainingUnits,
t.StaffedRemainingLateUnits,
t.UnstaffedRemainingUnits,
t.UnstaffedRemainingLateUnits,
CASE CostFlag WHEN 'Y' THEN t.ActualRegularCost ELSE null END ActualRegularCost,
CASE CostFlag WHEN 'Y' THEN t.ActualOvertimeCost ELSE null END ActualOvertimeCost,
CASE CostFlag WHEN 'Y' THEN t.ActualCost ELSE null END ActualCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionCost ELSE null END AtCompletionCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedCost ELSE null END PlannedCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingCost ELSE null END RemainingCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingLateCost ELSE null END RemainingLateCost,
CASE CostFlag WHEN 'Y' THEN t.StaffedRemainingCost ELSE null END StaffedRemainingCost,
CASE CostFlag WHEN 'Y' THEN t.StaffedRemainingLateCost ELSE null END StaffedRemainingLateCost,
CASE CostFlag WHEN 'Y' THEN t.UnstaffedRemainingCost ELSE null END UnstaffedRemainingCost,
CASE CostFlag WHEN 'Y' THEN t.UnstaffedRemainingLateCost ELSE null END UnstaffedRemainingLateCost,
t.lastupdatedate
FROM RESOURCEASSIGNMENTSPREAD t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View RESOURCELIMIT_FULL
prompt Creating Full View RESOURCELIMIT_FULL
--METADATA NAME:RESOURCELIMIT_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCELIMIT_FULL
AS SELECT 
resourceobjectid,
startdate,
enddate,
limit,
lastupdatedate
FROM RESOURCELIMIT
/
     
prompt Creating Project-Level View RESOURCELIMIT_U
--METADATA NAME:RESOURCELIMIT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCELIMIT_U
AS SELECT 
t.resourceobjectid,
t.startdate,
t.enddate,
t.limit,
t.lastupdatedate
FROM RESOURCELIMIT t, ResourceSecurity rs, GlobalSecurity gs
WHERE 1=1 and t.resourceobjectid = rs.ResourceObjectId and gs.rdbmsuserid = rs.rdbmsuserid   and rs.RDBMSUserId = secpac.get_security_id and gs.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View ACTIVITYSPREAD_FULL
prompt Creating Full View ACTIVITYSPREAD_FULL
--METADATA NAME:ACTIVITYSPREAD_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYSPREAD_FULL
AS SELECT 
ActivityObjectId,
StartDate,
EndDate,
ActivityCode,
ActivityName,
WBSObjectId,
projectobjectid,
ActualLaborUnits,
ActualNonLaborUnits,
AtCompletionLaborUnits,
AtCompletionNonLaborUnits,
BaselineActualLaborUnits,
BaselineActualNonLaborUnits,
BaselinePlannedLaborUnits,
BaselinePlannedNonLaborUnits,
Baseline1ActualLaborUnits,
Baseline1ActualNonLaborUnits,
Baseline1PlannedLaborUnits,
Baseline1PlannedNonLaborUnits,
EarnedValueLaborUnits,
EstimateAtCompletionLaborUnits,
EstimateToCompleteLaborUnits,
PlannedLaborUnits,
PlannedNonLaborUnits,
PlannedValueLaborUnits,
RemainingLaborUnits,
RemainingLateLaborUnits,
RemainingLateNonLaborUnits,
RemainingNonLaborUnits,
ActualCost,
ActualExpenseCost,
ActualLaborCost,
ActualMaterialCost,
ActualNonLaborCost,
ActualTotalCost,
AtCompletionExpenseCost,
AtCompletionLaborCost,
AtCompletionMaterialCost,
AtCompletionNonLaborCost,
AtCompletionTotalCost,
BaselinePlannedExpenseCost,
BaselinePlannedLaborCost,
BaselinePlannedMaterialCost,
BaselinePlannedNonLaborCost,
BaselinePlannedTotalCost,
BaselineActualExpenseCost,
BaselineActualLaborCost,
BaselineActualMaterialCost,
BaselineActualNonLaborCost,
BaselineActualTotalCost,
Baseline1ActualExpenseCost,
Baseline1ActualLaborCost,
Baseline1ActualMaterialCost,
Baseline1ActualNonLaborCost,
Baseline1ActualTotalCost,
Baseline1PlannedExpenseCost,
Baseline1PlannedLaborCost,
Baseline1PlannedMaterialCost,
Baseline1PlannedNonLaborCost,
Baseline1PlannedTotalCost,
EarnedValueCost,
EstimateAtCompletionCost,
EstimateToCompleteCost,
PlannedExpenseCost,
PlannedLaborCost,
PlannedMaterialCost,
PlannedNonLaborCost,
PlannedTotalCost,
PlannedValueCost,
RemainingExpenseCost,
RemainingLaborCost,
RemainingLateExpenseCost,
RemainingLateLaborCost,
RemainingLateMaterialCost,
RemainingLateNonLaborCost,
RemainingLateTotalCost,
RemainingMaterialCost,
RemainingNonLaborCost,
RemainingTotalCost,
lastupdatedate
FROM ACTIVITYSPREAD
/
     
prompt Creating Project-Level View ACTIVITYSPREAD_U
--METADATA NAME:ACTIVITYSPREAD_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYSPREAD_U
AS SELECT 
t.ActivityObjectId,
t.StartDate,
t.EndDate,
t.ActivityCode,
t.ActivityName,
t.WBSObjectId,
t.projectobjectid,
t.ActualLaborUnits,
t.ActualNonLaborUnits,
t.AtCompletionLaborUnits,
t.AtCompletionNonLaborUnits,
t.BaselineActualLaborUnits,
t.BaselineActualNonLaborUnits,
t.BaselinePlannedLaborUnits,
t.BaselinePlannedNonLaborUnits,
t.Baseline1ActualLaborUnits,
t.Baseline1ActualNonLaborUnits,
t.Baseline1PlannedLaborUnits,
t.Baseline1PlannedNonLaborUnits,
t.EarnedValueLaborUnits,
t.EstimateAtCompletionLaborUnits,
t.EstimateToCompleteLaborUnits,
t.PlannedLaborUnits,
t.PlannedNonLaborUnits,
t.PlannedValueLaborUnits,
t.RemainingLaborUnits,
t.RemainingLateLaborUnits,
t.RemainingLateNonLaborUnits,
t.RemainingNonLaborUnits,
CASE CostFlag WHEN 'Y' THEN t.ActualCost ELSE null END ActualCost,
CASE CostFlag WHEN 'Y' THEN t.ActualExpenseCost ELSE null END ActualExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.ActualLaborCost ELSE null END ActualLaborCost,
CASE CostFlag WHEN 'Y' THEN t.ActualMaterialCost ELSE null END ActualMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.ActualNonLaborCost ELSE null END ActualNonLaborCost,
CASE CostFlag WHEN 'Y' THEN t.ActualTotalCost ELSE null END ActualTotalCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionExpenseCost ELSE null END AtCompletionExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionLaborCost ELSE null END AtCompletionLaborCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionMaterialCost ELSE null END AtCompletionMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionNonLaborCost ELSE null END AtCompletionNonLaborCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionTotalCost ELSE null END AtCompletionTotalCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedExpenseCost ELSE null END BaselinePlannedExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedLaborCost ELSE null END BaselinePlannedLaborCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedMaterialCost ELSE null END BaselinePlannedMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedNonLaborCost ELSE null END BaselinePlannedNonLaborCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedTotalCost ELSE null END BaselinePlannedTotalCost,
CASE CostFlag WHEN 'Y' THEN t.BaselineActualExpenseCost ELSE null END BaselineActualExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.BaselineActualLaborCost ELSE null END BaselineActualLaborCost,
CASE CostFlag WHEN 'Y' THEN t.BaselineActualMaterialCost ELSE null END BaselineActualMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.BaselineActualNonLaborCost ELSE null END BaselineActualNonLaborCost,
CASE CostFlag WHEN 'Y' THEN t.BaselineActualTotalCost ELSE null END BaselineActualTotalCost,
CASE CostFlag WHEN 'Y' THEN t.Baseline1ActualExpenseCost ELSE null END Baseline1ActualExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.Baseline1ActualLaborCost ELSE null END Baseline1ActualLaborCost,
CASE CostFlag WHEN 'Y' THEN t.Baseline1ActualMaterialCost ELSE null END Baseline1ActualMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.Baseline1ActualNonLaborCost ELSE null END Baseline1ActualNonLaborCost,
CASE CostFlag WHEN 'Y' THEN t.Baseline1ActualTotalCost ELSE null END Baseline1ActualTotalCost,
CASE CostFlag WHEN 'Y' THEN t.Baseline1PlannedExpenseCost ELSE null END Baseline1PlannedExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.Baseline1PlannedLaborCost ELSE null END Baseline1PlannedLaborCost,
CASE CostFlag WHEN 'Y' THEN t.Baseline1PlannedMaterialCost ELSE null END Baseline1PlannedMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.Baseline1PlannedNonLaborCost ELSE null END Baseline1PlannedNonLaborCost,
CASE CostFlag WHEN 'Y' THEN t.Baseline1PlannedTotalCost ELSE null END Baseline1PlannedTotalCost,
CASE CostFlag WHEN 'Y' THEN t.EarnedValueCost ELSE null END EarnedValueCost,
CASE CostFlag WHEN 'Y' THEN t.EstimateAtCompletionCost ELSE null END EstimateAtCompletionCost,
CASE CostFlag WHEN 'Y' THEN t.EstimateToCompleteCost ELSE null END EstimateToCompleteCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedExpenseCost ELSE null END PlannedExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedLaborCost ELSE null END PlannedLaborCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedMaterialCost ELSE null END PlannedMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedNonLaborCost ELSE null END PlannedNonLaborCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedTotalCost ELSE null END PlannedTotalCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedValueCost ELSE null END PlannedValueCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingExpenseCost ELSE null END RemainingExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingLaborCost ELSE null END RemainingLaborCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingLateExpenseCost ELSE null END RemainingLateExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingLateLaborCost ELSE null END RemainingLateLaborCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingLateMaterialCost ELSE null END RemainingLateMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingLateNonLaborCost ELSE null END RemainingLateNonLaborCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingLateTotalCost ELSE null END RemainingLateTotalCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingMaterialCost ELSE null END RemainingMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingNonLaborCost ELSE null END RemainingNonLaborCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingTotalCost ELSE null END RemainingTotalCost,
t.lastupdatedate
FROM ACTIVITYSPREAD t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View ACTIVITY_FULL
prompt Creating Full View ACTIVITY_FULL
--METADATA NAME:ACTIVITY_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITY_FULL
AS SELECT 
objectid,
projectobjectid,
wbsobjectid,
calendarobjectid,
isnewfeedback,
autocomputeactuals,
percentcompletetype,
type,
durationtype,
reviewstatus,
status,
id,
name,
primaryresourceobjectid,
totalfloat,
freefloat,
remainingduration,
actuallaborunits,
remaininglaborunits,
plannedlaborunits,
plannedduration,
plannednonlaborunits,
actualnonlaborunits,
remainingnonlaborunits,
primaryconstraintdate,
actualstartdate,
actualfinishdate,
latestartdate,
latefinishdate,
expectedfinishdate,
earlystartdate,
earlyfinishdate,
remainingearlystartdate,
remainingearlyfinishdate,
plannedstartdate,
plannedfinishdate,
reviewfinishdate,
remaininglatestartdate,
remaininglatefinishdate,
primaryconstrainttype,
levelingpriority,
secondaryconstraintdate,
secondaryconstrainttype,
floatpath,
floatpathorder,
actualthisperiodlaborunits,
actualthisperiodnonlaborunits,
islongestpath,
suspenddate,
resumedate,
externalearlystartdate,
externallatefinishdate,
accountingvariance,
accountingvariancelaborunits,
actualduration,
actualexpensecost,
actuallaborcost,
actualmaterialcost,
actualnonlaborcost,
actualthisperiodlaborcost,
actualthisperiodmaterialcost,
actualthisperiodnonlaborcost,
actualtotalcost,
actualtotalunits,
atcompletionduration,
atcompletionexpensecost,
atcompletionlaborcost,
atcompletionlaborunits,
atcompletionlaborunitsvariance,
atcompletionmaterialcost,
atcompletionnonlaborcost,
atcompletionnonlaborunits,
atcompletiontotalcost,
atcompletiontotalunits,
atcompletionvariance,
baselineduration,
baselinefinishdate,
baselineplannedduration,
baselineplannedexpensecost,
baselineplannedlaborcost,
baselineplannedlaborunits,
baselineplannedmaterialcost,
baselineplannednonlaborcost,
baselineplannednonlaborunits,
baselineplannedtotalcost,
baselinestartdate,
baselinelatestartdate,
baseline1latestartdate,
baselinelatefinishdate,
baseline1latefinishdate,
budgetatcompletion,
calendarname,
costpercentcomplete,
costpercentofplanned,
costperformanceindex,
costperformanceindexlaborunits,
costvariance,
costvarianceindex,
costvarianceindexlaborunits,
costvariancelaborunits,
datadate,
duration1variance,
durationpercentcomplete,
durationpercentofplanned,
durationvariance,
earnedvaluecost,
earnedvaluelaborunits,
estimateatcompletioncost,
estimateatcompletionlaborunits,
estimatetocomplete,
estimatetocompletelaborunits,
expensecost1variance,
expensecostpercentcomplete,
expensecostvariance,
finishdate,
finishdate1variance,
finishdatevariance,
iscritical,
laborcost1variance,
laborcostpercentcomplete,
laborcostvariance,
laborunits1variance,
laborunitspercentcomplete,
laborunitsvariance,
materialcost1variance,
materialcostpercentcomplete,
materialcostvariance,
nonlaborcost1variance,
nonlaborcostpercentcomplete,
nonlaborcostvariance,
nonlaborunits1variance,
nonlaborunitspercentcomplete,
nonlaborunitsvariance,
percentcomplete,
performancepercentcomplete,
physicalpercentcomplete,
plannedexpensecost,
plannedlaborcost,
plannedmaterialcost,
plannednonlaborcost,
plannedtotalcost,
plannedtotalunits,
plannedvaluecost,
plannedvaluelaborunits,
primaryresourceid,
primaryresourcename,
remainingexpensecost,
remainingfloat,
remaininglaborcost,
remainingmaterialcost,
remainingnonlaborcost,
remainingtotalcost,
remainingtotalunits,
schedulepercentcomplete,
scheduleperfindexlaborunits,
scheduleperformanceindex,
schedulevariance,
schedulevarianceindex,
schedulevariancelaborunits,
schedulevarindexlaborunits,
startdate,
startdate1variance,
startdatevariance,
tocompleteperformanceindex,
totalcost1variance,
totalcostvariance,
unitspercentcomplete,
wbscode,
wbsname,
locationobjectid,
locationname,
reviewrequired,
isstarred,
cbscode,
lastupdateuser,
lastupdatedate,
createuser,
createdate,
lastupdatedatex,
ActivityOwnerObjectId,
ActivityOwner 
,RPT_CURRENT_FLAG
FROM ACTIVITY
/
     
prompt Creating Project-Level View ACTIVITY_U
--METADATA NAME:ACTIVITY_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITY_U
AS SELECT 
t.objectid,
t.projectobjectid,
t.wbsobjectid,
t.calendarobjectid,
t.isnewfeedback,
t.autocomputeactuals,
t.percentcompletetype,
t.type,
t.durationtype,
t.reviewstatus,
t.status,
t.id,
t.name,
t.primaryresourceobjectid,
t.totalfloat,
t.freefloat,
t.remainingduration,
t.actuallaborunits,
t.remaininglaborunits,
t.plannedlaborunits,
t.plannedduration,
t.plannednonlaborunits,
t.actualnonlaborunits,
t.remainingnonlaborunits,
t.primaryconstraintdate,
t.actualstartdate,
t.actualfinishdate,
t.latestartdate,
t.latefinishdate,
t.expectedfinishdate,
t.earlystartdate,
t.earlyfinishdate,
t.remainingearlystartdate,
t.remainingearlyfinishdate,
t.plannedstartdate,
t.plannedfinishdate,
t.reviewfinishdate,
t.remaininglatestartdate,
t.remaininglatefinishdate,
t.primaryconstrainttype,
t.levelingpriority,
t.secondaryconstraintdate,
t.secondaryconstrainttype,
t.floatpath,
t.floatpathorder,
t.actualthisperiodlaborunits,
t.actualthisperiodnonlaborunits,
t.islongestpath,
t.suspenddate,
t.resumedate,
t.externalearlystartdate,
t.externallatefinishdate,
CASE CostFlag WHEN 'Y' THEN t.accountingvariance ELSE null END accountingvariance,
t.accountingvariancelaborunits,
t.actualduration,
CASE CostFlag WHEN 'Y' THEN t.actualexpensecost ELSE null END actualexpensecost,
CASE CostFlag WHEN 'Y' THEN t.actuallaborcost ELSE null END actuallaborcost,
CASE CostFlag WHEN 'Y' THEN t.actualmaterialcost ELSE null END actualmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.actualnonlaborcost ELSE null END actualnonlaborcost,
CASE CostFlag WHEN 'Y' THEN t.actualthisperiodlaborcost ELSE null END actualthisperiodlaborcost,
CASE CostFlag WHEN 'Y' THEN t.actualthisperiodmaterialcost ELSE null END actualthisperiodmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.actualthisperiodnonlaborcost ELSE null END actualthisperiodnonlaborcost,
CASE CostFlag WHEN 'Y' THEN t.actualtotalcost ELSE null END actualtotalcost,
t.actualtotalunits,
t.atcompletionduration,
CASE CostFlag WHEN 'Y' THEN t.atcompletionexpensecost ELSE null END atcompletionexpensecost,
CASE CostFlag WHEN 'Y' THEN t.atcompletionlaborcost ELSE null END atcompletionlaborcost,
t.atcompletionlaborunits,
t.atcompletionlaborunitsvariance,
CASE CostFlag WHEN 'Y' THEN t.atcompletionmaterialcost ELSE null END atcompletionmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.atcompletionnonlaborcost ELSE null END atcompletionnonlaborcost,
t.atcompletionnonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.atcompletiontotalcost ELSE null END atcompletiontotalcost,
t.atcompletiontotalunits,
CASE CostFlag WHEN 'Y' THEN t.atcompletionvariance ELSE null END atcompletionvariance,
t.baselineduration,
t.baselinefinishdate,
t.baselineplannedduration,
CASE CostFlag WHEN 'Y' THEN t.baselineplannedexpensecost ELSE null END baselineplannedexpensecost,
CASE CostFlag WHEN 'Y' THEN t.baselineplannedlaborcost ELSE null END baselineplannedlaborcost,
t.baselineplannedlaborunits,
CASE CostFlag WHEN 'Y' THEN t.baselineplannedmaterialcost ELSE null END baselineplannedmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.baselineplannednonlaborcost ELSE null END baselineplannednonlaborcost,
t.baselineplannednonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.baselineplannedtotalcost ELSE null END baselineplannedtotalcost,
t.baselinestartdate,
t.baselinelatestartdate,
t.baseline1latestartdate,
t.baselinelatefinishdate,
t.baseline1latefinishdate,
CASE CostFlag WHEN 'Y' THEN t.budgetatcompletion ELSE null END budgetatcompletion,
t.calendarname,
t.costpercentcomplete,
t.costpercentofplanned,
t.costperformanceindex,
t.costperformanceindexlaborunits,
CASE CostFlag WHEN 'Y' THEN t.costvariance ELSE null END costvariance,
t.costvarianceindex,
t.costvarianceindexlaborunits,
t.costvariancelaborunits,
t.datadate,
t.duration1variance,
t.durationpercentcomplete,
t.durationpercentofplanned,
t.durationvariance,
CASE CostFlag WHEN 'Y' THEN t.earnedvaluecost ELSE null END earnedvaluecost,
t.earnedvaluelaborunits,
CASE CostFlag WHEN 'Y' THEN t.estimateatcompletioncost ELSE null END estimateatcompletioncost,
t.estimateatcompletionlaborunits,
CASE CostFlag WHEN 'Y' THEN t.estimatetocomplete ELSE null END estimatetocomplete,
t.estimatetocompletelaborunits,
CASE CostFlag WHEN 'Y' THEN t.expensecost1variance ELSE null END expensecost1variance,
t.expensecostpercentcomplete,
CASE CostFlag WHEN 'Y' THEN t.expensecostvariance ELSE null END expensecostvariance,
t.finishdate,
t.finishdate1variance,
t.finishdatevariance,
t.iscritical,
CASE CostFlag WHEN 'Y' THEN t.laborcost1variance ELSE null END laborcost1variance,
t.laborcostpercentcomplete,
CASE CostFlag WHEN 'Y' THEN t.laborcostvariance ELSE null END laborcostvariance,
t.laborunits1variance,
t.laborunitspercentcomplete,
t.laborunitsvariance,
CASE CostFlag WHEN 'Y' THEN t.materialcost1variance ELSE null END materialcost1variance,
t.materialcostpercentcomplete,
CASE CostFlag WHEN 'Y' THEN t.materialcostvariance ELSE null END materialcostvariance,
CASE CostFlag WHEN 'Y' THEN t.nonlaborcost1variance ELSE null END nonlaborcost1variance,
t.nonlaborcostpercentcomplete,
CASE CostFlag WHEN 'Y' THEN t.nonlaborcostvariance ELSE null END nonlaborcostvariance,
t.nonlaborunits1variance,
t.nonlaborunitspercentcomplete,
t.nonlaborunitsvariance,
t.percentcomplete,
t.performancepercentcomplete,
t.physicalpercentcomplete,
CASE CostFlag WHEN 'Y' THEN t.plannedexpensecost ELSE null END plannedexpensecost,
CASE CostFlag WHEN 'Y' THEN t.plannedlaborcost ELSE null END plannedlaborcost,
CASE CostFlag WHEN 'Y' THEN t.plannedmaterialcost ELSE null END plannedmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.plannednonlaborcost ELSE null END plannednonlaborcost,
CASE CostFlag WHEN 'Y' THEN t.plannedtotalcost ELSE null END plannedtotalcost,
t.plannedtotalunits,
CASE CostFlag WHEN 'Y' THEN t.plannedvaluecost ELSE null END plannedvaluecost,
t.plannedvaluelaborunits,
t.primaryresourceid,
t.primaryresourcename,
CASE CostFlag WHEN 'Y' THEN t.remainingexpensecost ELSE null END remainingexpensecost,
t.remainingfloat,
CASE CostFlag WHEN 'Y' THEN t.remaininglaborcost ELSE null END remaininglaborcost,
CASE CostFlag WHEN 'Y' THEN t.remainingmaterialcost ELSE null END remainingmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.remainingnonlaborcost ELSE null END remainingnonlaborcost,
CASE CostFlag WHEN 'Y' THEN t.remainingtotalcost ELSE null END remainingtotalcost,
t.remainingtotalunits,
t.schedulepercentcomplete,
t.scheduleperfindexlaborunits,
t.scheduleperformanceindex,
CASE CostFlag WHEN 'Y' THEN t.schedulevariance ELSE null END schedulevariance,
t.schedulevarianceindex,
t.schedulevariancelaborunits,
t.schedulevarindexlaborunits,
t.startdate,
t.startdate1variance,
t.startdatevariance,
t.tocompleteperformanceindex,
CASE CostFlag WHEN 'Y' THEN t.totalcost1variance ELSE null END totalcost1variance,
CASE CostFlag WHEN 'Y' THEN t.totalcostvariance ELSE null END totalcostvariance,
t.unitspercentcomplete,
t.wbscode,
t.wbsname,
t.locationobjectid,
t.locationname,
t.reviewrequired,
t.isstarred,
t.cbscode,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate,
t.lastupdatedatex,
t.ActivityOwnerObjectId,
t.ActivityOwner 
,RPT_CURRENT_FLAG
FROM ACTIVITY t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
-- START BASELINE VIEW of ACTIVITY_U
prompt Creating Project-Level View BLACTIVITY_U
--METADATA NAME:BLACTIVITY_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW BLACTIVITY_U
AS SELECT 
t.objectid,
t.projectobjectid,
t.wbsobjectid,
t.calendarobjectid,
t.isnewfeedback,
t.autocomputeactuals,
t.percentcompletetype,
t.type,
t.durationtype,
t.reviewstatus,
t.status,
t.id,
t.name,
t.primaryresourceobjectid,
t.totalfloat,
t.freefloat,
t.remainingduration,
t.actuallaborunits,
t.remaininglaborunits,
t.plannedlaborunits,
t.plannedduration,
t.plannednonlaborunits,
t.actualnonlaborunits,
t.remainingnonlaborunits,
t.primaryconstraintdate,
t.actualstartdate,
t.actualfinishdate,
t.latestartdate,
t.latefinishdate,
t.expectedfinishdate,
t.earlystartdate,
t.earlyfinishdate,
t.remainingearlystartdate,
t.remainingearlyfinishdate,
t.plannedstartdate,
t.plannedfinishdate,
t.reviewfinishdate,
t.remaininglatestartdate,
t.remaininglatefinishdate,
t.primaryconstrainttype,
t.levelingpriority,
t.secondaryconstraintdate,
t.secondaryconstrainttype,
t.floatpath,
t.floatpathorder,
t.actualthisperiodlaborunits,
t.actualthisperiodnonlaborunits,
t.islongestpath,
t.suspenddate,
t.resumedate,
t.externalearlystartdate,
t.externallatefinishdate,
CASE CostFlag WHEN 'Y' THEN t.accountingvariance ELSE null END accountingvariance,
t.accountingvariancelaborunits,
t.actualduration,
CASE CostFlag WHEN 'Y' THEN t.actualexpensecost ELSE null END actualexpensecost,
CASE CostFlag WHEN 'Y' THEN t.actuallaborcost ELSE null END actuallaborcost,
CASE CostFlag WHEN 'Y' THEN t.actualmaterialcost ELSE null END actualmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.actualnonlaborcost ELSE null END actualnonlaborcost,
CASE CostFlag WHEN 'Y' THEN t.actualthisperiodlaborcost ELSE null END actualthisperiodlaborcost,
CASE CostFlag WHEN 'Y' THEN t.actualthisperiodmaterialcost ELSE null END actualthisperiodmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.actualthisperiodnonlaborcost ELSE null END actualthisperiodnonlaborcost,
CASE CostFlag WHEN 'Y' THEN t.actualtotalcost ELSE null END actualtotalcost,
t.actualtotalunits,
t.atcompletionduration,
CASE CostFlag WHEN 'Y' THEN t.atcompletionexpensecost ELSE null END atcompletionexpensecost,
CASE CostFlag WHEN 'Y' THEN t.atcompletionlaborcost ELSE null END atcompletionlaborcost,
t.atcompletionlaborunits,
t.atcompletionlaborunitsvariance,
CASE CostFlag WHEN 'Y' THEN t.atcompletionmaterialcost ELSE null END atcompletionmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.atcompletionnonlaborcost ELSE null END atcompletionnonlaborcost,
t.atcompletionnonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.atcompletiontotalcost ELSE null END atcompletiontotalcost,
t.atcompletiontotalunits,
CASE CostFlag WHEN 'Y' THEN t.atcompletionvariance ELSE null END atcompletionvariance,
t.baselineduration,
t.baselinefinishdate,
t.baselineplannedduration,
CASE CostFlag WHEN 'Y' THEN t.baselineplannedexpensecost ELSE null END baselineplannedexpensecost,
CASE CostFlag WHEN 'Y' THEN t.baselineplannedlaborcost ELSE null END baselineplannedlaborcost,
t.baselineplannedlaborunits,
CASE CostFlag WHEN 'Y' THEN t.baselineplannedmaterialcost ELSE null END baselineplannedmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.baselineplannednonlaborcost ELSE null END baselineplannednonlaborcost,
t.baselineplannednonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.baselineplannedtotalcost ELSE null END baselineplannedtotalcost,
t.baselinestartdate,
t.baselinelatestartdate,
t.baseline1latestartdate,
t.baselinelatefinishdate,
t.baseline1latefinishdate,
CASE CostFlag WHEN 'Y' THEN t.budgetatcompletion ELSE null END budgetatcompletion,
t.calendarname,
t.costpercentcomplete,
t.costpercentofplanned,
t.costperformanceindex,
t.costperformanceindexlaborunits,
CASE CostFlag WHEN 'Y' THEN t.costvariance ELSE null END costvariance,
t.costvarianceindex,
t.costvarianceindexlaborunits,
t.costvariancelaborunits,
t.datadate,
t.duration1variance,
t.durationpercentcomplete,
t.durationpercentofplanned,
t.durationvariance,
CASE CostFlag WHEN 'Y' THEN t.earnedvaluecost ELSE null END earnedvaluecost,
t.earnedvaluelaborunits,
CASE CostFlag WHEN 'Y' THEN t.estimateatcompletioncost ELSE null END estimateatcompletioncost,
t.estimateatcompletionlaborunits,
CASE CostFlag WHEN 'Y' THEN t.estimatetocomplete ELSE null END estimatetocomplete,
t.estimatetocompletelaborunits,
CASE CostFlag WHEN 'Y' THEN t.expensecost1variance ELSE null END expensecost1variance,
t.expensecostpercentcomplete,
CASE CostFlag WHEN 'Y' THEN t.expensecostvariance ELSE null END expensecostvariance,
t.finishdate,
t.finishdate1variance,
t.finishdatevariance,
t.iscritical,
CASE CostFlag WHEN 'Y' THEN t.laborcost1variance ELSE null END laborcost1variance,
t.laborcostpercentcomplete,
CASE CostFlag WHEN 'Y' THEN t.laborcostvariance ELSE null END laborcostvariance,
t.laborunits1variance,
t.laborunitspercentcomplete,
t.laborunitsvariance,
CASE CostFlag WHEN 'Y' THEN t.materialcost1variance ELSE null END materialcost1variance,
t.materialcostpercentcomplete,
CASE CostFlag WHEN 'Y' THEN t.materialcostvariance ELSE null END materialcostvariance,
CASE CostFlag WHEN 'Y' THEN t.nonlaborcost1variance ELSE null END nonlaborcost1variance,
t.nonlaborcostpercentcomplete,
CASE CostFlag WHEN 'Y' THEN t.nonlaborcostvariance ELSE null END nonlaborcostvariance,
t.nonlaborunits1variance,
t.nonlaborunitspercentcomplete,
t.nonlaborunitsvariance,
t.percentcomplete,
t.performancepercentcomplete,
t.physicalpercentcomplete,
CASE CostFlag WHEN 'Y' THEN t.plannedexpensecost ELSE null END plannedexpensecost,
CASE CostFlag WHEN 'Y' THEN t.plannedlaborcost ELSE null END plannedlaborcost,
CASE CostFlag WHEN 'Y' THEN t.plannedmaterialcost ELSE null END plannedmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.plannednonlaborcost ELSE null END plannednonlaborcost,
CASE CostFlag WHEN 'Y' THEN t.plannedtotalcost ELSE null END plannedtotalcost,
t.plannedtotalunits,
CASE CostFlag WHEN 'Y' THEN t.plannedvaluecost ELSE null END plannedvaluecost,
t.plannedvaluelaborunits,
t.primaryresourceid,
t.primaryresourcename,
CASE CostFlag WHEN 'Y' THEN t.remainingexpensecost ELSE null END remainingexpensecost,
t.remainingfloat,
CASE CostFlag WHEN 'Y' THEN t.remaininglaborcost ELSE null END remaininglaborcost,
CASE CostFlag WHEN 'Y' THEN t.remainingmaterialcost ELSE null END remainingmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.remainingnonlaborcost ELSE null END remainingnonlaborcost,
CASE CostFlag WHEN 'Y' THEN t.remainingtotalcost ELSE null END remainingtotalcost,
t.remainingtotalunits,
t.schedulepercentcomplete,
t.scheduleperfindexlaborunits,
t.scheduleperformanceindex,
CASE CostFlag WHEN 'Y' THEN t.schedulevariance ELSE null END schedulevariance,
t.schedulevarianceindex,
t.schedulevariancelaborunits,
t.schedulevarindexlaborunits,
t.startdate,
t.startdate1variance,
t.startdatevariance,
t.tocompleteperformanceindex,
CASE CostFlag WHEN 'Y' THEN t.totalcost1variance ELSE null END totalcost1variance,
CASE CostFlag WHEN 'Y' THEN t.totalcostvariance ELSE null END totalcostvariance,
t.unitspercentcomplete,
t.wbscode,
t.wbsname,
t.locationobjectid,
t.locationname,
t.reviewrequired,
t.isstarred,
t.cbscode,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate,
t.lastupdatedatex,
t.ActivityOwnerObjectId,
t.ActivityOwner
FROM BLACTIVITY t
LEFT OUTER JOIN Baseline b ON t.projectobjectid = b.ObjectId
LEFT OUTER JOIN ProjectSecurity ps ON b.OriginalProjectObjectId = ps.ProjectObjectId
-- At b
WHERE 1=1  and ps.RDBMSUserId = secpac.get_security_id and b.objectid = t.projectobjectid
    
/
     
-- FINISH BASELINE VIEW of ACTIVITY_U
prompt Creating Full View ACTIVITYCODE_FULL
prompt Creating Full View ACTIVITYCODE_FULL
--METADATA NAME:ACTIVITYCODE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYCODE_FULL
AS SELECT 
objectid,
codetypeobjectid,
sequencenumber,
codevalue,
parentobjectid,
description,
codetypename,
issecurecode,
projectobjectid,
codetypescope,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ACTIVITYCODE
/
     
prompt Creating Project-Level View ACTIVITYCODE_U
--METADATA NAME:ACTIVITYCODE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYCODE_U
AS SELECT 
t.objectid,
t.codetypeobjectid,
t.sequencenumber,
t.codevalue,
t.parentobjectid,
t.description,
t.codetypename,
t.projectobjectid,
t.codetypescope,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM ACTIVITYCODE t left outer join ProjectSecurity ps on t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
WHERE 1=1  and (ps.ProjectObjectId is not null 
or t.codetypescope in ('AS_Global','AS_EPS','Global','EPS') ) and issecurecode='N' 
/
     
prompt Creating Project-Level View ACTIVITYCODE_S
--METADATA NAME:ACTIVITYCODE_S TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYCODE_S
AS SELECT 
t.objectid,
t.codetypeobjectid,
t.sequencenumber,
t.codevalue,
t.parentobjectid,
t.description,
t.codetypename,
t.projectobjectid,
t.codetypescope,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM ACTIVITYCODE t left outer join ProjectSecurity ps on t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id, GlobalSecurity gs
WHERE 1=1  and (ps.ProjectObjectId is not null 
or t.codetypescope in ('AS_Global','AS_EPS','Global','EPS') ) and gs.RDBMSUserId = secpac.get_security_id and  ( gs.SecureCodeFlag='Y' and t.issecurecode='Y') 
/
     
prompt Creating Full View ACTIVITYCODEASSIGNMENT_FULL
prompt Creating Full View ACTIVITYCODEASSIGNMENT_FULL
--METADATA NAME:ACTIVITYCODEASSIGNMENT_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYCODEASSIGNMENT_FULL
AS SELECT 
activityobjectid,
activitycodetypeobjectid,
activitycodeobjectid,
projectobjectid,
activitycodedescription,
activitycodetypename,
activitycodetypescope,
activitycodevalue,
activityid,
activityname,
issecurecode,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ACTIVITYCODEASSIGNMENT
/
     
prompt Creating Project-Level View ACTIVITYCODEASSIGNMENT_U
--METADATA NAME:ACTIVITYCODEASSIGNMENT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYCODEASSIGNMENT_U
AS SELECT 
t.activityobjectid,
t.activitycodetypeobjectid,
t.activitycodeobjectid,
t.projectobjectid,
t.activitycodedescription,
t.activitycodetypename,
t.activitycodetypescope,
t.activitycodevalue,
t.activityid,
t.activityname,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM ACTIVITYCODEASSIGNMENT t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id and issecurecode='N' 
/
     
prompt Creating Project-Level View ACTIVITYCODEASSIGNMENT_S
--METADATA NAME:ACTIVITYCODEASSIGNMENT_S TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYCODEASSIGNMENT_S
AS SELECT 
t.activityobjectid,
t.activitycodetypeobjectid,
t.activitycodeobjectid,
t.projectobjectid,
t.activitycodedescription,
t.activitycodetypename,
t.activitycodetypescope,
t.activitycodevalue,
t.activityid,
t.activityname,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM ACTIVITYCODEASSIGNMENT t, ProjectSecurity ps, GlobalSecurity gs
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id and gs.RDBMSUserId = secpac.get_security_id and  ( gs.SecureCodeFlag='Y' and t.issecurecode='Y') 
/
     
prompt Creating Full View ACTIVITYCODEHIERARCHY_FULL
prompt Creating Full View ACTIVITYCODEHIERARCHY_FULL
--METADATA NAME:ACTIVITYCODEHIERARCHY_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYCODEHIERARCHY_FULL
AS SELECT 
CodeTypeObjectId,
CodeTypeName,
CodeTypeSequenceNumber,
CodeTypeIsSecure,
ParentCodeValueObjectId,
ParentCodeValueName,
ParentCodeValueShortName,
ParentCodeValueSequenceNumber,
ChildCodeValueObjectId,
ChildCodeValueName,
ChildCodeValueShortName,
ChildCodeValueSequenceNumber,
ParentLevelsBelowRoot,
ChildLevelsBelowRoot,
LevelsBetween,
ChildHasChildren,
FullPathName,
CodeTypeScope,
CodeTypeProjectId
FROM ACTIVITYCODEHIERARCHY
/
     
prompt Creating Project-Level View ACTIVITYCODEHIERARCHY_U
--METADATA NAME:ACTIVITYCODEHIERARCHY_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYCODEHIERARCHY_U
AS SELECT 
t.CodeTypeObjectId,
t.CodeTypeName,
t.CodeTypeSequenceNumber,
t.ParentCodeValueObjectId,
t.ParentCodeValueName,
t.ParentCodeValueShortName,
t.ParentCodeValueSequenceNumber,
t.ChildCodeValueObjectId,
t.ChildCodeValueName,
t.ChildCodeValueShortName,
t.ChildCodeValueSequenceNumber,
t.ParentLevelsBelowRoot,
t.ChildLevelsBelowRoot,
t.LevelsBetween,
t.ChildHasChildren,
t.FullPathName,
t.CodeTypeScope,
t.CodeTypeProjectId
FROM ACTIVITYCODEHIERARCHY t left outer join ProjectSecurity ps on t.CodeTypeProjectId = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
WHERE 1=1  and (ps.ProjectObjectId is not null 
or t.CodeTypeScope in ('AS_Global','AS_EPS','Global','EPS') ) and CodeTypeIsSecure='N' 
/
     
prompt Creating Project-Level View ACTIVITYCODEHIERARCHY_S
--METADATA NAME:ACTIVITYCODEHIERARCHY_S TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYCODEHIERARCHY_S
AS SELECT 
t.CodeTypeObjectId,
t.CodeTypeName,
t.CodeTypeSequenceNumber,
t.ParentCodeValueObjectId,
t.ParentCodeValueName,
t.ParentCodeValueShortName,
t.ParentCodeValueSequenceNumber,
t.ChildCodeValueObjectId,
t.ChildCodeValueName,
t.ChildCodeValueShortName,
t.ChildCodeValueSequenceNumber,
t.ParentLevelsBelowRoot,
t.ChildLevelsBelowRoot,
t.LevelsBetween,
t.ChildHasChildren,
t.FullPathName,
t.CodeTypeScope,
t.CodeTypeProjectId
FROM ACTIVITYCODEHIERARCHY t left outer join ProjectSecurity ps on t.CodeTypeProjectId = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id, GlobalSecurity gs
WHERE 1=1  and (ps.ProjectObjectId is not null 
or t.CodeTypeScope in ('AS_Global','AS_EPS','Global','EPS') ) and gs.RDBMSUserId = secpac.get_security_id and  ( gs.SecureCodeFlag='Y' and t.CodeTypeIsSecure='Y') 
/
     
prompt Creating Full View ACTIVITYCODETYPE_FULL
prompt Creating Full View ACTIVITYCODETYPE_FULL
--METADATA NAME:ACTIVITYCODETYPE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYCODETYPE_FULL
AS SELECT 
objectid,
length,
sequencenumber,
name,
scope,
projectobjectid,
epsobjectid,
issecurecode,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ACTIVITYCODETYPE
/
     
prompt Creating Project-Level View ACTIVITYCODETYPE_U
--METADATA NAME:ACTIVITYCODETYPE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYCODETYPE_U
AS SELECT 
t.objectid,
t.length,
t.sequencenumber,
t.name,
t.scope,
t.projectobjectid,
t.epsobjectid,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM ACTIVITYCODETYPE t left outer join ProjectSecurity ps on t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
WHERE 1=1  and (ps.ProjectObjectId is not null 
or t.scope in ('AS_Global','AS_EPS','Global','EPS') ) and issecurecode='N' 
/
     
prompt Creating Project-Level View ACTIVITYCODETYPE_S
--METADATA NAME:ACTIVITYCODETYPE_S TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYCODETYPE_S
AS SELECT 
t.objectid,
t.length,
t.sequencenumber,
t.name,
t.scope,
t.projectobjectid,
t.epsobjectid,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM ACTIVITYCODETYPE t left outer join ProjectSecurity ps on t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id, GlobalSecurity gs
WHERE 1=1  and (ps.ProjectObjectId is not null 
or t.scope in ('AS_Global','AS_EPS','Global','EPS') ) and gs.RDBMSUserId = secpac.get_security_id and  ( gs.SecureCodeFlag='Y' and t.issecurecode='Y') 
/
     
prompt Creating Full View ACTIVITYEXPENSE_FULL
prompt Creating Full View ACTIVITYEXPENSE_FULL
--METADATA NAME:ACTIVITYEXPENSE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYEXPENSE_FULL
AS SELECT 
objectid,
projectobjectid,
activityobjectid,
autocomputeactuals,
accrualtype,
costaccountobjectid,
expensecategoryobjectid,
cbsobjectid,
plannedcost,
actualcost,
remainingcost,
unitofmeasure,
plannedunits,
priceperunit,
documentnumber,
vendor,
expenseitem,
expensedescription,
activityid,
activityname,
actualunits,
atcompletioncost,
atcompletionunits,
costaccountid,
costaccountname,
cbscode,
cbsname,
expensecategoryname,
expensepercentcomplete,
overbudget,
projectid,
remainingunits,
wbsobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ACTIVITYEXPENSE
/
     
prompt Creating Project-Level View ACTIVITYEXPENSE_U
--METADATA NAME:ACTIVITYEXPENSE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYEXPENSE_U
AS SELECT 
t.objectid,
t.projectobjectid,
t.activityobjectid,
t.autocomputeactuals,
t.accrualtype,
t.costaccountobjectid,
t.expensecategoryobjectid,
t.cbsobjectid,
CASE CostFlag WHEN 'Y' THEN t.plannedcost ELSE null END plannedcost,
CASE CostFlag WHEN 'Y' THEN t.actualcost ELSE null END actualcost,
CASE CostFlag WHEN 'Y' THEN t.remainingcost ELSE null END remainingcost,
t.unitofmeasure,
t.plannedunits,
CASE CostFlag WHEN 'Y' THEN t.priceperunit ELSE null END priceperunit,
t.documentnumber,
t.vendor,
t.expenseitem,
t.expensedescription,
t.activityid,
t.activityname,
t.actualunits,
CASE CostFlag WHEN 'Y' THEN t.atcompletioncost ELSE null END atcompletioncost,
t.atcompletionunits,
t.costaccountid,
t.costaccountname,
t.cbscode,
t.cbsname,
t.expensecategoryname,
t.expensepercentcomplete,
t.overbudget,
t.projectid,
t.remainingunits,
t.wbsobjectid,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM ACTIVITYEXPENSE t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View ACTIVITYNOTE_FULL
prompt Creating Full View ACTIVITYNOTE_FULL
--METADATA NAME:ACTIVITYNOTE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYNOTE_FULL
AS SELECT 
objectid,
activityobjectid,
notebooktopicobjectid,
projectobjectid,
note,
activityid,
activityname,
notebooktopicname,
projectid,
rawtextnote,
wbsobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ACTIVITYNOTE
/
     
prompt Creating Project-Level View ACTIVITYNOTE_U
--METADATA NAME:ACTIVITYNOTE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYNOTE_U
AS SELECT 
t.objectid,
t.activityobjectid,
t.notebooktopicobjectid,
t.projectobjectid,
t.note,
t.activityid,
t.activityname,
t.notebooktopicname,
t.projectid,
t.rawtextnote,
t.wbsobjectid,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM ACTIVITYNOTE t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View ACTIVITYPERIODACTUAL_FULL
prompt Creating Full View ACTIVITYPERIODACTUAL_FULL
--METADATA NAME:ACTIVITYPERIODACTUAL_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYPERIODACTUAL_FULL
AS SELECT 
financialperiodobjectid,
startdate,
enddate,
activityobjectid,
projectobjectid,
actuallaborunits,
actuallaborcost,
actualnonlaborunits,
actualnonlaborcost,
actualmaterialcost,
actualexpensecost,
earnedvaluecost,
plannedvaluelaborunits,
plannedvaluecost,
earnedvaluelaborunits,
wbsobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ACTIVITYPERIODACTUAL
/
     
prompt Creating Project-Level View ACTIVITYPERIODACTUAL_U
--METADATA NAME:ACTIVITYPERIODACTUAL_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYPERIODACTUAL_U
AS SELECT 
t.financialperiodobjectid,
t.startdate,
t.enddate,
t.activityobjectid,
t.projectobjectid,
t.actuallaborunits,
CASE CostFlag WHEN 'Y' THEN t.actuallaborcost ELSE null END actuallaborcost,
t.actualnonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.actualnonlaborcost ELSE null END actualnonlaborcost,
CASE CostFlag WHEN 'Y' THEN t.actualmaterialcost ELSE null END actualmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.actualexpensecost ELSE null END actualexpensecost,
CASE CostFlag WHEN 'Y' THEN t.earnedvaluecost ELSE null END earnedvaluecost,
t.plannedvaluelaborunits,
CASE CostFlag WHEN 'Y' THEN t.plannedvaluecost ELSE null END plannedvaluecost,
t.earnedvaluelaborunits,
t.wbsobjectid,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM ACTIVITYPERIODACTUAL t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View ACTIVITYRISK_FULL
prompt Creating Full View ACTIVITYRISK_FULL
--METADATA NAME:ACTIVITYRISK_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYRISK_FULL
AS SELECT 
activityobjectid,
projectobjectid,
riskobjectid,
projectid,
projectname,
activityid,
activityname,
riskname,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ACTIVITYRISK
/
     
prompt Creating Project-Level View ACTIVITYRISK_U
--METADATA NAME:ACTIVITYRISK_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYRISK_U
AS SELECT 
t.activityobjectid,
t.projectobjectid,
t.riskobjectid,
t.projectid,
t.projectname,
t.activityid,
t.activityname,
t.riskname,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM ACTIVITYRISK t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View ACTIVITYSTEP_FULL
prompt Creating Full View ACTIVITYSTEP_FULL
--METADATA NAME:ACTIVITYSTEP_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYSTEP_FULL
AS SELECT 
objectid,
activityobjectid,
sequencenumber,
projectobjectid,
iscompleted,
name,
weight,
percentcomplete,
description,
activityid,
activityname,
projectid,
wbsobjectid,
weightpercent,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ACTIVITYSTEP
/
     
prompt Creating Project-Level View ACTIVITYSTEP_U
--METADATA NAME:ACTIVITYSTEP_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYSTEP_U
AS SELECT 
t.objectid,
t.activityobjectid,
t.sequencenumber,
t.projectobjectid,
t.iscompleted,
t.name,
t.weight,
t.percentcomplete,
t.description,
t.activityid,
t.activityname,
t.projectid,
t.wbsobjectid,
t.weightpercent,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM ACTIVITYSTEP t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View BASELINETYPE_FULL
prompt Creating Full View BASELINETYPE_FULL
--METADATA NAME:BASELINETYPE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW BASELINETYPE_FULL
AS SELECT 
objectid,
sequencenumber,
name,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM BASELINETYPE
/
     
prompt Creating Global View BASELINETYPE_U
prompt Creating Global View BASELINETYPE_U
--METADATA NAME:BASELINETYPE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  BASELINETYPE_U
AS SELECT 
objectid,
sequencenumber,
name,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM BASELINETYPE
/
     
prompt Creating Full View CALENDAR_FULL
prompt Creating Full View CALENDAR_FULL
--METADATA NAME:CALENDAR_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW CALENDAR_FULL
AS SELECT 
objectid,
isdefault,
name,
projectobjectid,
basecalendarobjectid,
lastchangedate,
type,
daydate,
WeekdayNumber,
WorkDayFlag,
TotalWorkHours,
WorkHoursByHalfHour,
WorkDayStartTime,
WorkDayFinishTime,
lastupdatedate
FROM CALENDAR
/
     
prompt Creating Project-Level View CALENDAR_U
--METADATA NAME:CALENDAR_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW CALENDAR_U
AS SELECT 
t.objectid,
t.isdefault,
t.name,
t.projectobjectid,
t.basecalendarobjectid,
t.lastchangedate,
t.type,
t.daydate,
t.WeekdayNumber,
t.WorkDayFlag,
t.TotalWorkHours,
t.WorkHoursByHalfHour,
t.WorkDayStartTime,
t.WorkDayFinishTime,
t.lastupdatedate
FROM CALENDAR t left outer join ProjectSecurity ps on t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
WHERE 1=1  and ( ps.projectobjectid is not null
or t.projectobjectid is null )
/
     
prompt Creating Full View CHANGESET_FULL
prompt Creating Full View CHANGESET_FULL
--METADATA NAME:CHANGESET_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW CHANGESET_FULL
AS SELECT 
objectid,
requestusername,
requestuserobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM CHANGESET
/
     
prompt Creating Global View CHANGESET_U
prompt Creating Global View CHANGESET_U
--METADATA NAME:CHANGESET_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  CHANGESET_U
AS SELECT 
objectid,
requestusername,
requestuserobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM CHANGESET
/
     
prompt Creating Full View ACTIVITYUPDATE_FULL
prompt Creating Full View ACTIVITYUPDATE_FULL
--METADATA NAME:ACTIVITYUPDATE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYUPDATE_FULL
AS SELECT 
changesetobjectid,
activityobjectid,
projectobjectid,
status,
pendingactualstartdate,
overrideactualstartdate,
pendingactualfinishdate,
overrideactualfinishdate,
pendingremainingduration,
overrideremainingduration,
pendingpercentcomplete,
overridepercentcomplete,
overrideactuallaborunits,
pendingactuallaborunits,
pendingactualnonlaborunits,
overrideactualnonlaborunits,
overrideremaininglaborunits,
pendingremaininglaborunits,
overrideremainingnonlaborunits,
pendingremainingnonlaborunits,
pendingexpectedfinishdate,
overrideexpectedfinishdate,
approvaldate,
approvalusername,
approvaluserobjectid,
helddate,
requestusername,
requestuserobjectid
FROM ACTIVITYUPDATE
/
     
prompt Creating Project-Level View ACTIVITYUPDATE_U
--METADATA NAME:ACTIVITYUPDATE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYUPDATE_U
AS SELECT 
t.changesetobjectid,
t.activityobjectid,
t.projectobjectid,
t.status,
t.pendingactualstartdate,
t.overrideactualstartdate,
t.pendingactualfinishdate,
t.overrideactualfinishdate,
t.pendingremainingduration,
t.overrideremainingduration,
t.pendingpercentcomplete,
t.overridepercentcomplete,
t.overrideactuallaborunits,
t.pendingactuallaborunits,
t.pendingactualnonlaborunits,
t.overrideactualnonlaborunits,
t.overrideremaininglaborunits,
t.pendingremaininglaborunits,
t.overrideremainingnonlaborunits,
t.pendingremainingnonlaborunits,
t.pendingexpectedfinishdate,
t.overrideexpectedfinishdate,
t.approvaldate,
t.approvalusername,
t.approvaluserobjectid,
t.helddate,
t.requestusername,
t.requestuserobjectid
FROM ACTIVITYUPDATE t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View ACTIVITYSTEPUPDATE_FULL
prompt Creating Full View ACTIVITYSTEPUPDATE_FULL
--METADATA NAME:ACTIVITYSTEPUPDATE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYSTEPUPDATE_FULL
AS SELECT 
changesetobjectid,
activitystepobjectid,
status,
projectobjectid,
activityobjectid,
pendingpercentcomplete,
overridepercentcomplete,
approvaldate,
approvalusername,
approvaluserobjectid,
helddate,
requestusername,
requestuserobjectid,
pendingstepname,
overridestepname
FROM ACTIVITYSTEPUPDATE
/
     
prompt Creating Project-Level View ACTIVITYSTEPUPDATE_U
--METADATA NAME:ACTIVITYSTEPUPDATE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYSTEPUPDATE_U
AS SELECT 
t.changesetobjectid,
t.activitystepobjectid,
t.status,
t.projectobjectid,
t.activityobjectid,
t.pendingpercentcomplete,
t.overridepercentcomplete,
t.approvaldate,
t.approvalusername,
t.approvaluserobjectid,
t.helddate,
t.requestusername,
t.requestuserobjectid,
t.pendingstepname,
t.overridestepname
FROM ACTIVITYSTEPUPDATE t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View ACTIVITYSTEPCREATE_FULL
prompt Creating Full View ACTIVITYSTEPCREATE_FULL
--METADATA NAME:ACTIVITYSTEPCREATE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYSTEPCREATE_FULL
AS SELECT 
activitystepobjectid,
changesetobjectid,
activityobjectid,
projectobjectid,
status,
activitystepname,
steppercentcomplete,
stepweight
FROM ACTIVITYSTEPCREATE
/
     
prompt Creating Project-Level View ACTIVITYSTEPCREATE_U
--METADATA NAME:ACTIVITYSTEPCREATE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYSTEPCREATE_U
AS SELECT 
t.activitystepobjectid,
t.changesetobjectid,
t.activityobjectid,
t.projectobjectid,
t.status,
t.activitystepname,
t.steppercentcomplete,
t.stepweight
FROM ACTIVITYSTEPCREATE t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View ACTIVITYSTEPDEL_FULL
prompt Creating Full View ACTIVITYSTEPDEL_FULL
--METADATA NAME:ACTIVITYSTEPDEL_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYSTEPDEL_FULL
AS SELECT 
activitystepobjectid,
changesetobjectid,
activityobjectid,
projectobjectid,
activitystepname
FROM ACTIVITYSTEPDEL
/
     
prompt Creating Project-Level View ACTIVITYSTEPDEL_U
--METADATA NAME:ACTIVITYSTEPDEL_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYSTEPDEL_U
AS SELECT 
t.activitystepobjectid,
t.changesetobjectid,
t.activityobjectid,
t.projectobjectid,
t.activitystepname
FROM ACTIVITYSTEPDEL t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View ACTIVITYCOMMENT_FULL
prompt Creating Full View ACTIVITYCOMMENT_FULL
--METADATA NAME:ACTIVITYCOMMENT_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYCOMMENT_FULL
AS SELECT 
commentid,
activityobjectid,
userobjectid,
commentdate,
commenttext
FROM ACTIVITYCOMMENT
/
     
prompt Creating Global View ACTIVITYCOMMENT_U
prompt Creating Global View ACTIVITYCOMMENT_U
--METADATA NAME:ACTIVITYCOMMENT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  ACTIVITYCOMMENT_U
AS SELECT 
commentid,
activityobjectid,
userobjectid,
commentdate,
commenttext
FROM ACTIVITYCOMMENT
/
     
prompt Creating Full View ACTIVITYCODEUPDATE_FULL
prompt Creating Full View ACTIVITYCODEUPDATE_FULL
--METADATA NAME:ACTIVITYCODEUPDATE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYCODEUPDATE_FULL
AS SELECT 
changesetobjectid,
activityobjectid,
activitycodetypeobjectid,
projectobjectid,
approvaluserobjectid,
status,
overrideactivitycodeid,
pendingactivitycodeid,
requestuserobjectid,
approvalusername,
approvaldate,
helddate
FROM ACTIVITYCODEUPDATE
/
     
prompt Creating Project-Level View ACTIVITYCODEUPDATE_U
--METADATA NAME:ACTIVITYCODEUPDATE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ACTIVITYCODEUPDATE_U
AS SELECT 
t.changesetobjectid,
t.activityobjectid,
t.activitycodetypeobjectid,
t.projectobjectid,
t.approvaluserobjectid,
t.status,
t.overrideactivitycodeid,
t.pendingactivitycodeid,
t.requestuserobjectid,
t.approvalusername,
t.approvaldate,
t.helddate
FROM ACTIVITYCODEUPDATE t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View USERDEFINEDVALUEUPDATE_FULL
prompt Creating Full View USERDEFINEDVALUEUPDATE_FULL
--METADATA NAME:USERDEFINEDVALUEUPDATE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW USERDEFINEDVALUEUPDATE_FULL
AS SELECT 
changesetobjectid,
udftypeobjectid,
foreignobjectid,
projectobjectid,
status,
overrideudftext,
pendingudftext,
overrideudfstartdate,
pendingudfstartdate,
overrideudfenddate,
pendingudfenddate,
overrideudfcodeid,
pendingudfcodeid,
overrideudfnumber,
pendingudfnumber,
overrideudfinteger,
pendingudfinteger,
overrideudfcost,
pendingudfcost,
requestuserobjectid,
approvaluserobjectid,
approvalusername,
approvaldate,
helddate
FROM USERDEFINEDVALUEUPDATE
/
     
prompt Creating Project-Level View USERDEFINEDVALUEUPDATE_U
--METADATA NAME:USERDEFINEDVALUEUPDATE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW USERDEFINEDVALUEUPDATE_U
AS SELECT 
t.changesetobjectid,
t.udftypeobjectid,
t.foreignobjectid,
t.projectobjectid,
t.status,
t.overrideudftext,
t.pendingudftext,
t.overrideudfstartdate,
t.pendingudfstartdate,
t.overrideudfenddate,
t.pendingudfenddate,
t.overrideudfcodeid,
t.pendingudfcodeid,
t.overrideudfnumber,
t.pendingudfnumber,
t.overrideudfinteger,
t.pendingudfinteger,
t.overrideudfcost,
t.pendingudfcost,
t.requestuserobjectid,
t.approvaluserobjectid,
t.approvalusername,
t.approvaldate,
t.helddate
FROM USERDEFINEDVALUEUPDATE t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View RESOURCEASSIGNMENTUPDATE_FULL
prompt Creating Full View RESOURCEASSIGNMENTUPDATE_FULL
--METADATA NAME:RESOURCEASSIGNMENTUPDATE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCEASSIGNMENTUPDATE_FULL
AS SELECT 
changesetobjectid,
resourceassignmentobjectid,
activityobjectid,
status,
projectobjectid,
pendingactualstartdate,
overrideactualstartdate,
pendingactualfinishdate,
overrideactualfinishdate,
overrideactualunits,
pendingactualunits,
overrideremainingunits,
pendingremainingunits,
pendingremainingduration,
overrideremainingduration,
approvaldate,
approvalusername,
approvaluserobjectid,
helddate,
pendingremainingfinishdate,
overrideremainingfinishdate,
requestusername,
requestuserobjectid
FROM RESOURCEASSIGNMENTUPDATE
/
     
prompt Creating Global View RESOURCEASSIGNMENTUPDATE_U
prompt Creating Global View RESOURCEASSIGNMENTUPDATE_U
--METADATA NAME:RESOURCEASSIGNMENTUPDATE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  RESOURCEASSIGNMENTUPDATE_U
AS SELECT 
changesetobjectid,
resourceassignmentobjectid,
activityobjectid,
status,
projectobjectid,
pendingactualstartdate,
overrideactualstartdate,
pendingactualfinishdate,
overrideactualfinishdate,
overrideactualunits,
pendingactualunits,
overrideremainingunits,
pendingremainingunits,
pendingremainingduration,
overrideremainingduration,
approvaldate,
approvalusername,
approvaluserobjectid,
helddate,
pendingremainingfinishdate,
overrideremainingfinishdate,
requestusername,
requestuserobjectid
FROM RESOURCEASSIGNMENTUPDATE
/
     
prompt Creating Full View COSTACCOUNT_FULL
prompt Creating Full View COSTACCOUNT_FULL
--METADATA NAME:COSTACCOUNT_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW COSTACCOUNT_FULL
AS SELECT 
objectid,
sequencenumber,
id,
name,
parentobjectid,
description,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM COSTACCOUNT
/
     
prompt Creating Global View COSTACCOUNT_U
prompt Creating Global View COSTACCOUNT_U
--METADATA NAME:COSTACCOUNT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  COSTACCOUNT_U
AS SELECT 
objectid,
sequencenumber,
id,
name,
parentobjectid,
description,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM COSTACCOUNT
/
     
prompt Creating Full View COSTACCOUNTHIERARCHY_FULL
prompt Creating Full View COSTACCOUNTHIERARCHY_FULL
--METADATA NAME:COSTACCOUNTHIERARCHY_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW COSTACCOUNTHIERARCHY_FULL
AS SELECT 
ParentObjectId,
ParentSequenceNumber,
ParentName,
ParentId,
ChildObjectId,
ChildSequenceNumber,
ChildName,
ChildId,
ParentLevelsBelowRoot,
ChildLevelsBelowRoot,
LevelsBetween,
ChildHasChildren,
FullPathName
FROM COSTACCOUNTHIERARCHY
/
     
prompt Creating Global View COSTACCOUNTHIERARCHY_U
prompt Creating Global View COSTACCOUNTHIERARCHY_U
--METADATA NAME:COSTACCOUNTHIERARCHY_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  COSTACCOUNTHIERARCHY_U
AS SELECT 
ParentObjectId,
ParentSequenceNumber,
ParentName,
ParentId,
ChildObjectId,
ChildSequenceNumber,
ChildName,
ChildId,
ParentLevelsBelowRoot,
ChildLevelsBelowRoot,
LevelsBetween,
ChildHasChildren,
FullPathName
FROM COSTACCOUNTHIERARCHY
/
     
prompt Creating Full View COSTSECURITY_FULL
prompt Creating Full View COSTSECURITY_FULL
--METADATA NAME:COSTSECURITY_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW COSTSECURITY_FULL
AS SELECT 
PROJECTOBJECTID,
WHOLEPROJECTFLAG
FROM COSTSECURITY
/
     
prompt Creating Global View COSTSECURITY_U
prompt Creating Global View COSTSECURITY_U
--METADATA NAME:COSTSECURITY_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  COSTSECURITY_U
AS SELECT 
PROJECTOBJECTID,
WHOLEPROJECTFLAG
FROM COSTSECURITY
/
     
prompt Creating Full View CURRENCY_FULL
prompt Creating Full View CURRENCY_FULL
--METADATA NAME:CURRENCY_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW CURRENCY_FULL
AS SELECT 
objectid,
decimalplaces,
symbol,
decimalsymbol,
digitgroupingsymbol,
positivesymbol,
negativesymbol,
name,
id,
exchangerate,
isbasecurrency,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM CURRENCY
/
     
prompt Creating Global View CURRENCY_U
prompt Creating Global View CURRENCY_U
--METADATA NAME:CURRENCY_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  CURRENCY_U
AS SELECT 
objectid,
decimalplaces,
symbol,
decimalsymbol,
digitgroupingsymbol,
positivesymbol,
negativesymbol,
name,
id,
exchangerate,
isbasecurrency,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM CURRENCY
/
     
prompt Creating Full View DOCUMENT_FULL
prompt Creating Full View DOCUMENT_FULL
--METADATA NAME:DOCUMENT_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW DOCUMENT_FULL
AS SELECT 
objectid,
sequencenumber,
deliverable,
title,
parentobjectid,
projectobjectid,
documentstatuscodeobjectid,
documentcategoryobjectid,
revisiondate,
version,
referencenumber,
author,
privatelocation,
publiclocation,
resourceobjectid,
documenttype,
documentcategoryname,
documentstatuscodename,
projectid,
resourceid,
resourcename,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM DOCUMENT
/
     
prompt Creating Project-Level View DOCUMENT_U
--METADATA NAME:DOCUMENT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW DOCUMENT_U
AS SELECT 
t.objectid,
t.sequencenumber,
t.deliverable,
t.title,
t.parentobjectid,
t.projectobjectid,
t.documentstatuscodeobjectid,
t.documentcategoryobjectid,
t.revisiondate,
t.version,
t.referencenumber,
t.author,
t.privatelocation,
t.publiclocation,
t.resourceobjectid,
t.documenttype,
t.documentcategoryname,
t.documentstatuscodename,
t.projectid,
t.resourceid,
t.resourcename,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM DOCUMENT t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View DOCUMENTCATEGORY_FULL
prompt Creating Full View DOCUMENTCATEGORY_FULL
--METADATA NAME:DOCUMENTCATEGORY_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW DOCUMENTCATEGORY_FULL
AS SELECT 
objectid,
sequencenumber,
name,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM DOCUMENTCATEGORY
/
     
prompt Creating Global View DOCUMENTCATEGORY_U
prompt Creating Global View DOCUMENTCATEGORY_U
--METADATA NAME:DOCUMENTCATEGORY_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  DOCUMENTCATEGORY_U
AS SELECT 
objectid,
sequencenumber,
name,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM DOCUMENTCATEGORY
/
     
prompt Creating Full View DOCUMENTSTATUSCODE_FULL
prompt Creating Full View DOCUMENTSTATUSCODE_FULL
--METADATA NAME:DOCUMENTSTATUSCODE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW DOCUMENTSTATUSCODE_FULL
AS SELECT 
objectid,
sequencenumber,
name,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM DOCUMENTSTATUSCODE
/
     
prompt Creating Global View DOCUMENTSTATUSCODE_U
prompt Creating Global View DOCUMENTSTATUSCODE_U
--METADATA NAME:DOCUMENTSTATUSCODE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  DOCUMENTSTATUSCODE_U
AS SELECT 
objectid,
sequencenumber,
name,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM DOCUMENTSTATUSCODE
/
     
prompt Creating Full View EPS_FULL
prompt Creating Full View EPS_FULL
--METADATA NAME:EPS_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW EPS_FULL
AS SELECT 
objectid,
projectobjectid,
obsobjectid,
sequencenumber,
name,
parentobjectid,
originalbudget,
independentetctotalcost,
independentetclaborunits,
anticipatedstartdate,
anticipatedfinishdate,
currentbudget,
currentvariance,
distributedcurrentbudget,
finishdate,
fullname,
id,
lastsummarizeddate,
obsname,
plannedstartdate,
proposedbudget,
startdate,
sumplannedstartdate,
sumplannedfinishdate,
sumplannedduration,
sumplannedlaborunits,
sumplannednonlaborunits,
sumplannedexpensecost,
sumplannedlaborcost,
sumplannedmaterialcost,
sumplannednonlaborcost,
sumplannedtotalcost,
sumaccountingvarbylaborunits,
sumaccountingvariancebycost,
sumactthisperiodmaterialcost,
sumactthisperiodnonlaborcost,
sumactthisperiodnonlaborunits,
sumactualthisperiodlaborcost,
sumactualthisperiodlaborunits,
sumatcompletionmaterialcost,
sumatcompletionnonlaborcost,
sumatcompletionnonlaborunits,
sumatcompletiontotalcostvar,
sumbaselinecompactivitycount,
sumbaselinenotstartedactcnt,
sumblinprogressactivitycount,
sumbudgetatcmpbylaborunits,
sumbudgetatcompletionbycost,
sumcostperfindexbycost,
sumcostperfindexbylaborunits,
sumcostvariancebylaborunits,
sumcostvarindexbylaborunits,
sumdurationpercentofplanned,
sumeacbycost,
sumeacbylaborunits,
sumeachighpctbylaborunits,
sumeaclowpctbylaborunits,
sumetcbycost,
sumetcbylaborunits,
sumexpensecostpctcomplete,
sumlaborcostpercentcomplete,
sumlaborunitspercentcomplete,
sumactivitycount,
sumactualduration,
sumactualexpensecost,
sumactualfinishdate,
sumactuallaborcost,
sumactuallaborunits,
sumactualmaterialcost,
sumactualnonlaborcost,
sumactualnonlaborunits,
sumactualstartdate,
sumactualthisperiodcost,
sumactualtotalcost,
sumactualvaluebycost,
sumactualvaluebylaborunits,
sumatcompletionduration,
sumatcompletionexpensecost,
sumatcompletionlaborcost,
sumatcompletionlaborunits,
sumatcompletiontotalcost,
sumbaselineduration,
sumbaselineexpensecost,
sumbaselinefinishdate,
sumbaselinelaborcost,
sumbaselinelaborunits,
sumbaselinematerialcost,
sumbaselinenonlaborcost,
sumbaselinenonlaborunits,
sumbaselinestartdate,
sumbaselinetotalcost,
sumcompletedactivitycount,
sumcostpercentcomplete,
sumcostpercentofplanned,
sumcostvariancebycost,
sumcostvarianceindex,
sumcostvarianceindexbycost,
sumdurationpercentcomplete,
sumdurationvariance,
sumearnedvaluebycost,
sumearnedvaluebylaborunits,
sumexpensecostvariance,
sumfinishdatevariance,
suminprogressactivitycount,
sumlaborcostvariance,
sumlaborunitsvariance,
summaterialcostvariance,
sumnonlaborcostvariance,
sumnonlaborunitsvariance,
sumnotstartedactivitycount,
sumplannedvaluebycost,
sumprogressfinishdate,
sumremainingduration,
sumremainingexpensecost,
sumremainingfinishdate,
sumremaininglaborcost,
sumremaininglaborunits,
sumremainingmaterialcost,
sumremainingnonlaborcost,
sumremainingnonlaborunits,
sumremainingstartdate,
sumremainingtotalcost,
sumschedulepercentcomplete,
sumperformancepercentcomplete,
sumschedulevariancebycost,
sumschedulevarianceindex,
sumstartdatevariance,
sumtotalcostvariance,
sumtotalfloat,
sumunitspercentcomplete,
summaterialcostpctcomplete,
sumnonlaborcostpctcomplete,
sumnonlaborunitspctcomplete,
sumperfpctcmpbylaborunits,
sumplannedvaluebylaborunits,
sumschdpctcmpbylaborunits,
sumschdperfindexbylaborunits,
sumschdvariancebylaborunits,
sumschdvarianceindexbycost,
sumschdvarindexbylaborunits,
sumscheduleperfindexbycost,
sumtocompleteperfindexbycost,
sumvaratcmpbylaborunits,
totalbenefitplan,
totalbenefitplantally,
totalfunding,
totalspendingplan,
totalspendingplantally,
unallocatedbudget,
undistributedcurrentvariance,
lastupdateuser,
lastupdatedate,
createuser,
createdate,
lastupdatedatex
FROM EPS
/
     
prompt Creating Project-Level View EPS_U
--METADATA NAME:EPS_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW EPS_U
AS SELECT 
t.objectid,
t.projectobjectid,
t.obsobjectid,
t.sequencenumber,
t.name,
t.parentobjectid,
CASE CostFlag WHEN 'Y' THEN t.originalbudget ELSE null END originalbudget,
CASE CostFlag WHEN 'Y' THEN t.independentetctotalcost ELSE null END independentetctotalcost,
t.independentetclaborunits,
t.anticipatedstartdate,
t.anticipatedfinishdate,
CASE CostFlag WHEN 'Y' THEN t.currentbudget ELSE null END currentbudget,
CASE CostFlag WHEN 'Y' THEN t.currentvariance ELSE null END currentvariance,
CASE CostFlag WHEN 'Y' THEN t.distributedcurrentbudget ELSE null END distributedcurrentbudget,
t.finishdate,
t.fullname,
t.id,
t.lastsummarizeddate,
t.obsname,
t.plannedstartdate,
CASE CostFlag WHEN 'Y' THEN t.proposedbudget ELSE null END proposedbudget,
t.startdate,
t.sumplannedstartdate,
t.sumplannedfinishdate,
t.sumplannedduration,
t.sumplannedlaborunits,
t.sumplannednonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumplannedexpensecost ELSE null END sumplannedexpensecost,
CASE CostFlag WHEN 'Y' THEN t.sumplannedlaborcost ELSE null END sumplannedlaborcost,
CASE CostFlag WHEN 'Y' THEN t.sumplannedmaterialcost ELSE null END sumplannedmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumplannednonlaborcost ELSE null END sumplannednonlaborcost,
CASE CostFlag WHEN 'Y' THEN t.sumplannedtotalcost ELSE null END sumplannedtotalcost,
t.sumaccountingvarbylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumaccountingvariancebycost ELSE null END sumaccountingvariancebycost,
CASE CostFlag WHEN 'Y' THEN t.sumactthisperiodmaterialcost ELSE null END sumactthisperiodmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumactthisperiodnonlaborcost ELSE null END sumactthisperiodnonlaborcost,
t.sumactthisperiodnonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumactualthisperiodlaborcost ELSE null END sumactualthisperiodlaborcost,
t.sumactualthisperiodlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionmaterialcost ELSE null END sumatcompletionmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionnonlaborcost ELSE null END sumatcompletionnonlaborcost,
t.sumatcompletionnonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletiontotalcostvar ELSE null END sumatcompletiontotalcostvar,
t.sumbaselinecompactivitycount,
t.sumbaselinenotstartedactcnt,
t.sumblinprogressactivitycount,
t.sumbudgetatcmpbylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumbudgetatcompletionbycost ELSE null END sumbudgetatcompletionbycost,
t.sumcostperfindexbycost,
t.sumcostperfindexbylaborunits,
t.sumcostvariancebylaborunits,
t.sumcostvarindexbylaborunits,
t.sumdurationpercentofplanned,
CASE CostFlag WHEN 'Y' THEN t.sumeacbycost ELSE null END sumeacbycost,
t.sumeacbylaborunits,
t.sumeachighpctbylaborunits,
t.sumeaclowpctbylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumetcbycost ELSE null END sumetcbycost,
t.sumetcbylaborunits,
t.sumexpensecostpctcomplete,
t.sumlaborcostpercentcomplete,
t.sumlaborunitspercentcomplete,
t.sumactivitycount,
t.sumactualduration,
CASE CostFlag WHEN 'Y' THEN t.sumactualexpensecost ELSE null END sumactualexpensecost,
t.sumactualfinishdate,
CASE CostFlag WHEN 'Y' THEN t.sumactuallaborcost ELSE null END sumactuallaborcost,
t.sumactuallaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumactualmaterialcost ELSE null END sumactualmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumactualnonlaborcost ELSE null END sumactualnonlaborcost,
t.sumactualnonlaborunits,
t.sumactualstartdate,
CASE CostFlag WHEN 'Y' THEN t.sumactualthisperiodcost ELSE null END sumactualthisperiodcost,
CASE CostFlag WHEN 'Y' THEN t.sumactualtotalcost ELSE null END sumactualtotalcost,
CASE CostFlag WHEN 'Y' THEN t.sumactualvaluebycost ELSE null END sumactualvaluebycost,
t.sumactualvaluebylaborunits,
t.sumatcompletionduration,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionexpensecost ELSE null END sumatcompletionexpensecost,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionlaborcost ELSE null END sumatcompletionlaborcost,
t.sumatcompletionlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletiontotalcost ELSE null END sumatcompletiontotalcost,
t.sumbaselineduration,
CASE CostFlag WHEN 'Y' THEN t.sumbaselineexpensecost ELSE null END sumbaselineexpensecost,
t.sumbaselinefinishdate,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinelaborcost ELSE null END sumbaselinelaborcost,
t.sumbaselinelaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinematerialcost ELSE null END sumbaselinematerialcost,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinenonlaborcost ELSE null END sumbaselinenonlaborcost,
t.sumbaselinenonlaborunits,
t.sumbaselinestartdate,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinetotalcost ELSE null END sumbaselinetotalcost,
t.sumcompletedactivitycount,
t.sumcostpercentcomplete,
t.sumcostpercentofplanned,
CASE CostFlag WHEN 'Y' THEN t.sumcostvariancebycost ELSE null END sumcostvariancebycost,
t.sumcostvarianceindex,
CASE CostFlag WHEN 'Y' THEN t.sumcostvarianceindexbycost ELSE null END sumcostvarianceindexbycost,
t.sumdurationpercentcomplete,
t.sumdurationvariance,
CASE CostFlag WHEN 'Y' THEN t.sumearnedvaluebycost ELSE null END sumearnedvaluebycost,
t.sumearnedvaluebylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumexpensecostvariance ELSE null END sumexpensecostvariance,
t.sumfinishdatevariance,
t.suminprogressactivitycount,
CASE CostFlag WHEN 'Y' THEN t.sumlaborcostvariance ELSE null END sumlaborcostvariance,
t.sumlaborunitsvariance,
CASE CostFlag WHEN 'Y' THEN t.summaterialcostvariance ELSE null END summaterialcostvariance,
CASE CostFlag WHEN 'Y' THEN t.sumnonlaborcostvariance ELSE null END sumnonlaborcostvariance,
t.sumnonlaborunitsvariance,
t.sumnotstartedactivitycount,
CASE CostFlag WHEN 'Y' THEN t.sumplannedvaluebycost ELSE null END sumplannedvaluebycost,
t.sumprogressfinishdate,
t.sumremainingduration,
CASE CostFlag WHEN 'Y' THEN t.sumremainingexpensecost ELSE null END sumremainingexpensecost,
t.sumremainingfinishdate,
CASE CostFlag WHEN 'Y' THEN t.sumremaininglaborcost ELSE null END sumremaininglaborcost,
t.sumremaininglaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumremainingmaterialcost ELSE null END sumremainingmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumremainingnonlaborcost ELSE null END sumremainingnonlaborcost,
t.sumremainingnonlaborunits,
t.sumremainingstartdate,
CASE CostFlag WHEN 'Y' THEN t.sumremainingtotalcost ELSE null END sumremainingtotalcost,
t.sumschedulepercentcomplete,
t.sumperformancepercentcomplete,
CASE CostFlag WHEN 'Y' THEN t.sumschedulevariancebycost ELSE null END sumschedulevariancebycost,
t.sumschedulevarianceindex,
t.sumstartdatevariance,
CASE CostFlag WHEN 'Y' THEN t.sumtotalcostvariance ELSE null END sumtotalcostvariance,
t.sumtotalfloat,
t.sumunitspercentcomplete,
t.summaterialcostpctcomplete,
t.sumnonlaborcostpctcomplete,
t.sumnonlaborunitspctcomplete,
t.sumperfpctcmpbylaborunits,
t.sumplannedvaluebylaborunits,
t.sumschdpctcmpbylaborunits,
t.sumschdperfindexbylaborunits,
t.sumschdvariancebylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumschdvarianceindexbycost ELSE null END sumschdvarianceindexbycost,
t.sumschdvarindexbylaborunits,
t.sumscheduleperfindexbycost,
t.sumtocompleteperfindexbycost,
t.sumvaratcmpbylaborunits,
CASE CostFlag WHEN 'Y' THEN t.totalbenefitplan ELSE null END totalbenefitplan,
CASE CostFlag WHEN 'Y' THEN t.totalbenefitplantally ELSE null END totalbenefitplantally,
CASE CostFlag WHEN 'Y' THEN t.totalfunding ELSE null END totalfunding,
CASE CostFlag WHEN 'Y' THEN t.totalspendingplan ELSE null END totalspendingplan,
CASE CostFlag WHEN 'Y' THEN t.totalspendingplantally ELSE null END totalspendingplantally,
CASE CostFlag WHEN 'Y' THEN t.unallocatedbudget ELSE null END unallocatedbudget,
CASE CostFlag WHEN 'Y' THEN t.undistributedcurrentvariance ELSE null END undistributedcurrentvariance,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate,
t.lastupdatedatex
FROM EPS t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View EPSBUDGETCHANGELOG_FULL
prompt Creating Full View EPSBUDGETCHANGELOG_FULL
--METADATA NAME:EPSBUDGETCHANGELOG_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW EPSBUDGETCHANGELOG_FULL
AS SELECT 
objectid,
projectobjectid,
epsobjectid,
epsbudgetchangelogdate,
changenumber,
amount,
responsible,
status,
reason,
epsid,
epsname,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM EPSBUDGETCHANGELOG
/
     
prompt Creating Project-Level View EPSBUDGETCHANGELOG_U
--METADATA NAME:EPSBUDGETCHANGELOG_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW EPSBUDGETCHANGELOG_U
AS SELECT 
t.objectid,
t.projectobjectid,
t.epsobjectid,
t.epsbudgetchangelogdate,
t.changenumber,
CASE CostFlag WHEN 'Y' THEN t.amount ELSE null END amount,
t.responsible,
t.status,
t.reason,
t.epsid,
t.epsname,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM EPSBUDGETCHANGELOG t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View EPSFUNDING_FULL
prompt Creating Full View EPSFUNDING_FULL
--METADATA NAME:EPSFUNDING_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW EPSFUNDING_FULL
AS SELECT 
objectid,
fundingsourceobjectid,
projectobjectid,
amount,
fundshare,
epsid,
epsname,
epsobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM EPSFUNDING
/
     
prompt Creating Project-Level View EPSFUNDING_U
--METADATA NAME:EPSFUNDING_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW EPSFUNDING_U
AS SELECT 
t.objectid,
t.fundingsourceobjectid,
t.projectobjectid,
CASE CostFlag WHEN 'Y' THEN t.amount ELSE null END amount,
t.fundshare,
t.epsid,
t.epsname,
t.epsobjectid,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM EPSFUNDING t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View EPSHIERARCHY_FULL
prompt Creating Full View EPSHIERARCHY_FULL
--METADATA NAME:EPSHIERARCHY_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW EPSHIERARCHY_FULL
AS SELECT 
ParentObjectId,
ParentProjectId,
ParentSequenceNumber,
ParentName,
ParentId,
ChildObjectId,
ChildProjectId,
ChildSequenceNumber,
ChildName,
ChildId,
ParentLevelsBelowRoot,
ChildLevelsBelowRoot,
LevelsBetween,
ChildHasChildren,
FullPathName,
lastupdatedate
FROM EPSHIERARCHY
/
     
prompt Creating Project-Level View EPSHIERARCHY_U
--METADATA NAME:EPSHIERARCHY_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW EPSHIERARCHY_U
AS SELECT 
t.ParentObjectId,
t.ParentProjectId,
t.ParentSequenceNumber,
t.ParentName,
t.ParentId,
t.ChildObjectId,
t.ChildProjectId,
t.ChildSequenceNumber,
t.ChildName,
t.ChildId,
t.ParentLevelsBelowRoot,
t.ChildLevelsBelowRoot,
t.LevelsBetween,
t.ChildHasChildren,
t.FullPathName,
t.lastupdatedate
FROM EPSHIERARCHY t, ProjectSecurity ps
WHERE 1=1  and t.ParentProjectId = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View WBSHIERARCHY_FULL
prompt Creating Full View WBSHIERARCHY_FULL
--METADATA NAME:WBSHIERARCHY_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW WBSHIERARCHY_FULL
AS SELECT 
ParentObjectId,
ParentProjectId,
ParentSequenceNumber,
ParentName,
ParentId,
ChildObjectId,
ChildProjectId,
ChildSequenceNumber,
ChildName,
ChildId,
ParentLevelsBelowRoot,
ChildLevelsBelowRoot,
LevelsBetween,
ChildHasChildren,
FullPathName,
lastupdatedate
FROM WBSHIERARCHY
/
     
prompt Creating Project-Level View WBSHIERARCHY_U
--METADATA NAME:WBSHIERARCHY_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW WBSHIERARCHY_U
AS SELECT 
t.ParentObjectId,
t.ParentProjectId,
t.ParentSequenceNumber,
t.ParentName,
t.ParentId,
t.ChildObjectId,
t.ChildProjectId,
t.ChildSequenceNumber,
t.ChildName,
t.ChildId,
t.ParentLevelsBelowRoot,
t.ChildLevelsBelowRoot,
t.LevelsBetween,
t.ChildHasChildren,
t.FullPathName,
t.lastupdatedate
FROM WBSHIERARCHY t, ProjectSecurity ps
WHERE 1=1  and t.ParentProjectId = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View EPSNOTE_FULL
prompt Creating Full View EPSNOTE_FULL
--METADATA NAME:EPSNOTE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW EPSNOTE_FULL
AS SELECT 
objectid,
projectobjectid,
notebooktopicobjectid,
note,
epsid,
epsname,
epsobjectid,
notebooktopicname,
rawtextnote,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM EPSNOTE
/
     
prompt Creating Project-Level View EPSNOTE_U
--METADATA NAME:EPSNOTE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW EPSNOTE_U
AS SELECT 
t.objectid,
t.projectobjectid,
t.notebooktopicobjectid,
t.note,
t.epsid,
t.epsname,
t.epsobjectid,
t.notebooktopicname,
t.rawtextnote,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM EPSNOTE t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View EPSSPENDINGPLAN_FULL
prompt Creating Full View EPSSPENDINGPLAN_FULL
--METADATA NAME:EPSSPENDINGPLAN_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW EPSSPENDINGPLAN_FULL
AS SELECT 
objectid,
projectobjectid,
spendingplan,
benefitplan,
spendingplandate,
epsid,
epsname,
epsobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM EPSSPENDINGPLAN
/
     
prompt Creating Project-Level View EPSSPENDINGPLAN_U
--METADATA NAME:EPSSPENDINGPLAN_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW EPSSPENDINGPLAN_U
AS SELECT 
t.objectid,
t.projectobjectid,
CASE CostFlag WHEN 'Y' THEN t.spendingplan ELSE null END spendingplan,
CASE CostFlag WHEN 'Y' THEN t.benefitplan ELSE null END benefitplan,
t.spendingplandate,
t.epsid,
t.epsname,
t.epsobjectid,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM EPSSPENDINGPLAN t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View EPSSPREAD_FULL
prompt Creating Full View EPSSPREAD_FULL
--METADATA NAME:EPSSPREAD_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW EPSSPREAD_FULL
AS SELECT 
ObjectId,
Id,
Name,
ParentObjectId,
projectobjectid,
ObsObjectId,
ObsName,
StartDate,
EndDate,
ActualLaborUnits,
ActualNonlaborUnits,
AtCompletionLaborUnits,
AtCompletionNonlaborUnits,
BaselinePlannedLaborUnits,
BaselinePlannedNonlaborUnits,
EarnedValueLaborUnits,
EstimateAtCompletionLaborUnits,
EstimateToCompleteLaborUnits,
PlannedValueLaborUnits,
RemainingLaborUnits,
RemainingNonlaborUnits,
ActualCost,
ActualExpenseCost,
ActualLaborCost,
ActualMaterialCost,
ActualNonlaborCost,
ActualTotalCost,
AtCompletionExpenseCost,
AtCompletionLaborCost,
AtCompletionMaterialCost,
AtCompletionNonlaborCost,
AtCompletionTotalCost,
BaselinePlannedExpenseCost,
BaselinePlannedLaborCost,
BaselinePlannedMaterialCost,
BaselinePlannedNonlaborCost,
BaselinePlannedTotalCost,
EarnedValueCost,
EstimateAtCompletionCost,
EstimateToCompleteCost,
PlannedValueCost,
RemainingExpenseCost,
RemainingLaborCost,
RemainingMaterialCost,
RemainingNonlaborCost,
RemainingTotalCost
FROM EPSSPREAD
/
     
prompt Creating Project-Level View EPSSPREAD_U
--METADATA NAME:EPSSPREAD_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW EPSSPREAD_U
AS SELECT 
t.ObjectId,
t.Id,
t.Name,
t.ParentObjectId,
t.projectobjectid,
t.ObsObjectId,
t.ObsName,
t.StartDate,
t.EndDate,
t.ActualLaborUnits,
t.ActualNonlaborUnits,
t.AtCompletionLaborUnits,
t.AtCompletionNonlaborUnits,
t.BaselinePlannedLaborUnits,
t.BaselinePlannedNonlaborUnits,
t.EarnedValueLaborUnits,
t.EstimateAtCompletionLaborUnits,
t.EstimateToCompleteLaborUnits,
t.PlannedValueLaborUnits,
t.RemainingLaborUnits,
t.RemainingNonlaborUnits,
CASE CostFlag WHEN 'Y' THEN t.ActualCost ELSE null END ActualCost,
CASE CostFlag WHEN 'Y' THEN t.ActualExpenseCost ELSE null END ActualExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.ActualLaborCost ELSE null END ActualLaborCost,
CASE CostFlag WHEN 'Y' THEN t.ActualMaterialCost ELSE null END ActualMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.ActualNonlaborCost ELSE null END ActualNonlaborCost,
CASE CostFlag WHEN 'Y' THEN t.ActualTotalCost ELSE null END ActualTotalCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionExpenseCost ELSE null END AtCompletionExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionLaborCost ELSE null END AtCompletionLaborCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionMaterialCost ELSE null END AtCompletionMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionNonlaborCost ELSE null END AtCompletionNonlaborCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionTotalCost ELSE null END AtCompletionTotalCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedExpenseCost ELSE null END BaselinePlannedExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedLaborCost ELSE null END BaselinePlannedLaborCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedMaterialCost ELSE null END BaselinePlannedMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedNonlaborCost ELSE null END BaselinePlannedNonlaborCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedTotalCost ELSE null END BaselinePlannedTotalCost,
CASE CostFlag WHEN 'Y' THEN t.EarnedValueCost ELSE null END EarnedValueCost,
CASE CostFlag WHEN 'Y' THEN t.EstimateAtCompletionCost ELSE null END EstimateAtCompletionCost,
CASE CostFlag WHEN 'Y' THEN t.EstimateToCompleteCost ELSE null END EstimateToCompleteCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedValueCost ELSE null END PlannedValueCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingExpenseCost ELSE null END RemainingExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingLaborCost ELSE null END RemainingLaborCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingMaterialCost ELSE null END RemainingMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingNonlaborCost ELSE null END RemainingNonlaborCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingTotalCost ELSE null END RemainingTotalCost
FROM EPSSPREAD t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View EXPENSECATEGORY_FULL
prompt Creating Full View EXPENSECATEGORY_FULL
--METADATA NAME:EXPENSECATEGORY_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW EXPENSECATEGORY_FULL
AS SELECT 
objectid,
sequencenumber,
name,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM EXPENSECATEGORY
/
     
prompt Creating Global View EXPENSECATEGORY_U
prompt Creating Global View EXPENSECATEGORY_U
--METADATA NAME:EXPENSECATEGORY_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  EXPENSECATEGORY_U
AS SELECT 
objectid,
sequencenumber,
name,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM EXPENSECATEGORY
/
     
prompt Creating Full View FINANCIALPERIOD_FULL
prompt Creating Full View FINANCIALPERIOD_FULL
--METADATA NAME:FINANCIALPERIOD_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW FINANCIALPERIOD_FULL
AS SELECT 
objectid,
name,
startdate,
enddate,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM FINANCIALPERIOD
/
     
prompt Creating Global View FINANCIALPERIOD_U
prompt Creating Global View FINANCIALPERIOD_U
--METADATA NAME:FINANCIALPERIOD_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  FINANCIALPERIOD_U
AS SELECT 
objectid,
name,
startdate,
enddate,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM FINANCIALPERIOD
/
     
prompt Creating Full View FUNDINGSOURCE_FULL
prompt Creating Full View FUNDINGSOURCE_FULL
--METADATA NAME:FUNDINGSOURCE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW FUNDINGSOURCE_FULL
AS SELECT 
objectid,
sequencenumber,
name,
parentobjectid,
description,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM FUNDINGSOURCE
/
     
prompt Creating Global View FUNDINGSOURCE_U
prompt Creating Global View FUNDINGSOURCE_U
--METADATA NAME:FUNDINGSOURCE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  FUNDINGSOURCE_U
AS SELECT 
objectid,
sequencenumber,
name,
parentobjectid,
description,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM FUNDINGSOURCE
/
     
prompt Creating Full View GLOBALPROFILE_FULL
prompt Creating Full View GLOBALPROFILE_FULL
--METADATA NAME:GLOBALPROFILE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW GLOBALPROFILE_FULL
AS SELECT 
objectid,
isdefault,
issuperuser,
name,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM GLOBALPROFILE
/
     
prompt Creating Global View GLOBALPROFILE_U
prompt Creating Global View GLOBALPROFILE_U
--METADATA NAME:GLOBALPROFILE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  GLOBALPROFILE_U
AS SELECT 
objectid,
isdefault,
issuperuser,
name,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM GLOBALPROFILE
/
     
prompt Creating Full View ISSUEHISTORY_FULL
prompt Creating Full View ISSUEHISTORY_FULL
--METADATA NAME:ISSUEHISTORY_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ISSUEHISTORY_FULL
AS SELECT 
projectissueobjectid,
projectobjectid,
notes,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ISSUEHISTORY
/
     
prompt Creating Project-Level View ISSUEHISTORY_U
--METADATA NAME:ISSUEHISTORY_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ISSUEHISTORY_U
AS SELECT 
t.projectissueobjectid,
t.projectobjectid,
t.notes,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM ISSUEHISTORY t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View ITERATION_FULL
prompt Creating Full View ITERATION_FULL
--METADATA NAME:ITERATION_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ITERATION_FULL
AS SELECT 
objectid,
name,
startdate,
enddate,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ITERATION
/
     
prompt Creating Global View ITERATION_U
prompt Creating Global View ITERATION_U
--METADATA NAME:ITERATION_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  ITERATION_U
AS SELECT 
objectid,
name,
startdate,
enddate,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ITERATION
/
     
prompt Creating Full View ITERATIONACTIVITY_FULL
prompt Creating Full View ITERATIONACTIVITY_FULL
--METADATA NAME:ITERATIONACTIVITY_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ITERATIONACTIVITY_FULL
AS SELECT 
iterationobjectid,
activityobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ITERATIONACTIVITY
/
     
prompt Creating Global View ITERATIONACTIVITY_U
prompt Creating Global View ITERATIONACTIVITY_U
--METADATA NAME:ITERATIONACTIVITY_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  ITERATIONACTIVITY_U
AS SELECT 
iterationobjectid,
activityobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ITERATIONACTIVITY
/
     
prompt Creating Full View ITERATIONTEAM_FULL
prompt Creating Full View ITERATIONTEAM_FULL
--METADATA NAME:ITERATIONTEAM_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ITERATIONTEAM_FULL
AS SELECT 
iterationobjectid,
resourceteamobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ITERATIONTEAM
/
     
prompt Creating Global View ITERATIONTEAM_U
prompt Creating Global View ITERATIONTEAM_U
--METADATA NAME:ITERATIONTEAM_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  ITERATIONTEAM_U
AS SELECT 
iterationobjectid,
resourceteamobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ITERATIONTEAM
/
     
prompt Creating Full View LOCATION_FULL
prompt Creating Full View LOCATION_FULL
--METADATA NAME:LOCATION_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW LOCATION_FULL
AS SELECT 
objectid,
locationname,
locationtype,
addressline1,
addressline2,
addressline3,
city,
municipality,
state,
statecode,
country,
countrycode,
postalcode,
longitude,
latitude,
geolocation,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM LOCATION
/
     
prompt Creating Global View LOCATION_U
prompt Creating Global View LOCATION_U
--METADATA NAME:LOCATION_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  LOCATION_U
AS SELECT 
objectid,
locationname,
locationtype,
addressline1,
addressline2,
addressline3,
city,
municipality,
state,
statecode,
country,
countrycode,
postalcode,
longitude,
latitude,
geolocation,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM LOCATION
/
     
prompt Creating Full View NOTEBOOKTOPIC_FULL
prompt Creating Full View NOTEBOOKTOPIC_FULL
--METADATA NAME:NOTEBOOKTOPIC_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW NOTEBOOKTOPIC_FULL
AS SELECT 
objectid,
sequencenumber,
availableforeps,
availableforproject,
availableforwbs,
availableforactivity,
name,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM NOTEBOOKTOPIC
/
     
prompt Creating Global View NOTEBOOKTOPIC_U
prompt Creating Global View NOTEBOOKTOPIC_U
--METADATA NAME:NOTEBOOKTOPIC_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  NOTEBOOKTOPIC_U
AS SELECT 
objectid,
sequencenumber,
availableforeps,
availableforproject,
availableforwbs,
availableforactivity,
name,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM NOTEBOOKTOPIC
/
     
prompt Creating Full View OBS_FULL
prompt Creating Full View OBS_FULL
--METADATA NAME:OBS_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW OBS_FULL
AS SELECT 
objectid,
sequencenumber,
name,
parentobjectid,
description,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM OBS
/
     
prompt Creating Global View OBS_U
prompt Creating Global View OBS_U
--METADATA NAME:OBS_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  OBS_U
AS SELECT 
objectid,
sequencenumber,
name,
parentobjectid,
description,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM OBS
/
     
prompt Creating Full View OVERHEADCODE_FULL
prompt Creating Full View OVERHEADCODE_FULL
--METADATA NAME:OVERHEADCODE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW OVERHEADCODE_FULL
AS SELECT 
objectid,
sequencenumber,
name,
description,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM OVERHEADCODE
/
     
prompt Creating Global View OVERHEADCODE_U
prompt Creating Global View OVERHEADCODE_U
--METADATA NAME:OVERHEADCODE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  OVERHEADCODE_U
AS SELECT 
objectid,
sequencenumber,
name,
description,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM OVERHEADCODE
/
     
prompt Creating Full View PROJECT_FULL
prompt Creating Full View PROJECT_FULL
--METADATA NAME:PROJECT_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECT_FULL
AS SELECT 
objectid,
id,
fiscalyearstartmonth,
resourcescaneditasgnmtpctcmp,
resourcescanselfassigntoacts,
primaryrescanmarkactsascmp,
resourcecanassigntosameact,
checkoutstatus,
activitypctcmpbasedonsteps,
costquantityrecalculateflag,
containssummarydataonly,
enablesummarization,
wbscodeseparator,
activitydefaultpctcmptype,
activitydefcostacctobjectid,
activitydefcalendarobjectid,
currentbaselineprojectobjectid,
activityidsuffix,
activityidincrement,
levelingpriority,
summarizetowbslevel,
strategicpriority,
criticalactivityfloatlimit,
activitydefaultpriceperunit,
plannedstartdate,
mustfinishbydate,
scheduledfinishdate,
dateadded,
summarizeddatadate,
lastsummarizeddate,
projectforecaststartdate,
activitydefaultdurationtype,
activityidprefix,
defaultpricetimeunits,
addedby,
websiterootdirectory,
websiteurl,
assignmentdefaultratetype,
linkactualtoactualthisperiod,
activitydefaultactivitytype,
linkpercentcompletewithactual,
addactualtoremaining,
criticalactivitypathtype,
activityidbasedonselactivity,
assignmentdefaultdrivingflag,
linkplannedandatcompletionflag,
resetplannedtoremainingflag,
allownegativeactualunitsflag,
ownerresourceobjectid,
checkoutdate,
checkoutuserobjectid,
lastfinancialperiodobjectid,
useprojectblforearnedvalue,
annualdiscountrate,
anticipatedfinishdate,
anticipatedstartdate,
containssummarydata,
currentbudget,
currentvariance,
datadate,
discountapplicationperiod,
distributedcurrentbudget,
earnedvaluecomputetype,
earnedvalueetccomputetype,
earnedvalueetcuservalue,
earnedvalueuserpercent,
finishdate,
forecastfinishdate,
forecaststartdate,
independentetclaborunits,
independentetctotalcost,
name,
obsname,
obsobjectid,
originalbudget,
overallprojectscore,
parentepsobjectid,
proposedbudget,
risklevel,
riskscore,
riskexposure,
startdate,
status,
originalprojectobjectid,
riskscorematrixobjectid,
sumplannedstartdate,
sumplannedfinishdate,
sumplannedduration,
sumplannedlaborunits,
sumplannednonlaborunits,
sumplannedexpensecost,
sumplannedlaborcost,
sumplannedmaterialcost,
sumplannednonlaborcost,
sumplannedtotalcost,
sumaccountingvarbylaborunits,
sumaccountingvariancebycost,
sumactthisperiodmaterialcost,
sumactthisperiodnonlaborcost,
sumactthisperiodnonlaborunits,
sumactualthisperiodlaborcost,
sumactualthisperiodlaborunits,
sumatcompletionmaterialcost,
sumatcompletionnonlaborcost,
sumatcompletionnonlaborunits,
sumatcompletiontotalcostvar,
sumbaselinecompactivitycount,
sumbaselinenotstartedactcnt,
sumblinprogressactivitycount,
sumbudgetatcmpbylaborunits,
sumbudgetatcompletionbycost,
sumcostperfindexbycost,
sumcostperfindexbylaborunits,
sumcostvariancebylaborunits,
sumcostvarindexbylaborunits,
sumdurationpercentofplanned,
sumeacbycost,
sumeacbylaborunits,
sumeachighpctbylaborunits,
sumeaclowpctbylaborunits,
sumetcbycost,
sumetcbylaborunits,
sumexpensecostpctcomplete,
sumlaborcostpercentcomplete,
sumlaborunitspercentcomplete,
sumactivitycount,
sumactualduration,
sumactualexpensecost,
sumactualfinishdate,
summaxactualfinishdate,
summaxrestartdate,
sumactuallaborcost,
sumactuallaborunits,
sumactualmaterialcost,
sumactualnonlaborcost,
sumactualnonlaborunits,
sumactualstartdate,
sumactualthisperiodcost,
sumactualtotalcost,
sumactualvaluebycost,
sumactualvaluebylaborunits,
sumatcompletionduration,
sumatcompletionexpensecost,
sumatcompletionlaborcost,
sumatcompletionlaborunits,
sumatcompletiontotalcost,
sumbaselineduration,
sumbaselineexpensecost,
sumbaselinefinishdate,
sumbaselinelaborcost,
sumbaselinelaborunits,
sumbaselinematerialcost,
sumbaselinenonlaborcost,
sumbaselinenonlaborunits,
sumbaselinestartdate,
sumbaselinetotalcost,
sumcompletedactivitycount,
sumcostpercentcomplete,
sumcostpercentofplanned,
sumcostvariancebycost,
sumcostvarianceindex,
sumcostvarianceindexbycost,
sumdurationpercentcomplete,
sumdurationvariance,
sumearnedvaluebycost,
sumearnedvaluebylaborunits,
sumexpensecostvariance,
sumfinishdatevariance,
suminprogressactivitycount,
sumlaborcostvariance,
sumlaborunitsvariance,
summaterialcostvariance,
sumnonlaborcostvariance,
sumnonlaborunitsvariance,
sumnotstartedactivitycount,
sumplannedvaluebycost,
sumprogressfinishdate,
sumremainingduration,
sumremainingexpensecost,
sumremainingfinishdate,
sumremaininglaborcost,
sumremaininglaborunits,
sumremainingmaterialcost,
sumremainingnonlaborcost,
sumremainingnonlaborunits,
sumremainingstartdate,
sumremainingtotalcost,
sumschedulepercentcomplete,
sumperformancepercentcomplete,
sumschedulevariancebycost,
sumschedulevarianceindex,
sumstartdatevariance,
sumtotalcostvariance,
sumtotalfloat,
sumunitspercentcomplete,
summaterialcostpctcomplete,
sumnonlaborcostpctcomplete,
sumnonlaborunitspctcomplete,
sumperfpctcmpbylaborunits,
sumplannedvaluebylaborunits,
sumschdpctcmpbylaborunits,
sumschdperfindexbylaborunits,
sumschdvariancebylaborunits,
sumschdvarianceindexbycost,
sumschdvarindexbylaborunits,
sumscheduleperfindexbycost,
sumtocompleteperfindexbycost,
sumvaratcmpbylaborunits,
sumearlystartdate,
sumearlyenddate,
sumlatestartdate,
sumlateenddate,
summaxcalendarid,
summincalendarid,
totalbenefitplan,
totalbenefitplantally,
totalfunding,
totalspendingplan,
totalspendingplantally,
unallocatedbudget,
NetPresentValue,
ReturnOnInvestment,
PaybackPeriod,
undistributedcurrentvariance,
projectdescription,
baselinetypeobjectid,
enablepublication,
nextpublicationdate,
lastpublishedon,
publicationpriority,
locationobjectid,
historyinterval,
historylevel,
locationname,
allowstatusreview,
statusreviewerobjectid,
statusreviewername,
lastupdateuser,
lastupdatedate,
createuser,
etlinterval,
etlhour,
createdate,
lastupdatedatex
FROM PROJECT
/
     
prompt Creating Project-Level View PROJECT_U
--METADATA NAME:PROJECT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECT_U
AS SELECT 
t.objectid,
t.id,
t.fiscalyearstartmonth,
t.resourcescaneditasgnmtpctcmp,
t.resourcescanselfassigntoacts,
t.primaryrescanmarkactsascmp,
t.resourcecanassigntosameact,
t.checkoutstatus,
t.activitypctcmpbasedonsteps,
t.costquantityrecalculateflag,
t.containssummarydataonly,
t.enablesummarization,
t.wbscodeseparator,
t.activitydefaultpctcmptype,
t.activitydefcostacctobjectid,
t.activitydefcalendarobjectid,
t.currentbaselineprojectobjectid,
t.activityidsuffix,
t.activityidincrement,
t.levelingpriority,
t.summarizetowbslevel,
t.strategicpriority,
t.criticalactivityfloatlimit,
CASE CostFlag WHEN 'Y' THEN t.activitydefaultpriceperunit ELSE null END activitydefaultpriceperunit,
t.plannedstartdate,
t.mustfinishbydate,
t.scheduledfinishdate,
t.dateadded,
t.summarizeddatadate,
t.lastsummarizeddate,
t.projectforecaststartdate,
t.activitydefaultdurationtype,
t.activityidprefix,
t.defaultpricetimeunits,
t.addedby,
t.websiterootdirectory,
t.websiteurl,
t.assignmentdefaultratetype,
t.linkactualtoactualthisperiod,
t.activitydefaultactivitytype,
t.linkpercentcompletewithactual,
t.addactualtoremaining,
t.criticalactivitypathtype,
t.activityidbasedonselactivity,
t.assignmentdefaultdrivingflag,
t.linkplannedandatcompletionflag,
t.resetplannedtoremainingflag,
t.allownegativeactualunitsflag,
t.ownerresourceobjectid,
t.checkoutdate,
t.checkoutuserobjectid,
t.lastfinancialperiodobjectid,
t.useprojectblforearnedvalue,
t.annualdiscountrate,
t.anticipatedfinishdate,
t.anticipatedstartdate,
t.containssummarydata,
CASE CostFlag WHEN 'Y' THEN t.currentbudget ELSE null END currentbudget,
CASE CostFlag WHEN 'Y' THEN t.currentvariance ELSE null END currentvariance,
t.datadate,
t.discountapplicationperiod,
CASE CostFlag WHEN 'Y' THEN t.distributedcurrentbudget ELSE null END distributedcurrentbudget,
t.earnedvaluecomputetype,
t.earnedvalueetccomputetype,
t.earnedvalueetcuservalue,
t.earnedvalueuserpercent,
t.finishdate,
t.forecastfinishdate,
t.forecaststartdate,
t.independentetclaborunits,
CASE CostFlag WHEN 'Y' THEN t.independentetctotalcost ELSE null END independentetctotalcost,
t.name,
t.obsname,
t.obsobjectid,
CASE CostFlag WHEN 'Y' THEN t.originalbudget ELSE null END originalbudget,
t.overallprojectscore,
t.parentepsobjectid,
CASE CostFlag WHEN 'Y' THEN t.proposedbudget ELSE null END proposedbudget,
t.risklevel,
t.riskscore,
t.riskexposure,
t.startdate,
t.status,
t.originalprojectobjectid,
t.riskscorematrixobjectid,
t.sumplannedstartdate,
t.sumplannedfinishdate,
t.sumplannedduration,
t.sumplannedlaborunits,
t.sumplannednonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumplannedexpensecost ELSE null END sumplannedexpensecost,
CASE CostFlag WHEN 'Y' THEN t.sumplannedlaborcost ELSE null END sumplannedlaborcost,
CASE CostFlag WHEN 'Y' THEN t.sumplannedmaterialcost ELSE null END sumplannedmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumplannednonlaborcost ELSE null END sumplannednonlaborcost,
CASE CostFlag WHEN 'Y' THEN t.sumplannedtotalcost ELSE null END sumplannedtotalcost,
t.sumaccountingvarbylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumaccountingvariancebycost ELSE null END sumaccountingvariancebycost,
CASE CostFlag WHEN 'Y' THEN t.sumactthisperiodmaterialcost ELSE null END sumactthisperiodmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumactthisperiodnonlaborcost ELSE null END sumactthisperiodnonlaborcost,
t.sumactthisperiodnonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumactualthisperiodlaborcost ELSE null END sumactualthisperiodlaborcost,
t.sumactualthisperiodlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionmaterialcost ELSE null END sumatcompletionmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionnonlaborcost ELSE null END sumatcompletionnonlaborcost,
t.sumatcompletionnonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletiontotalcostvar ELSE null END sumatcompletiontotalcostvar,
t.sumbaselinecompactivitycount,
t.sumbaselinenotstartedactcnt,
t.sumblinprogressactivitycount,
t.sumbudgetatcmpbylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumbudgetatcompletionbycost ELSE null END sumbudgetatcompletionbycost,
t.sumcostperfindexbycost,
t.sumcostperfindexbylaborunits,
t.sumcostvariancebylaborunits,
t.sumcostvarindexbylaborunits,
t.sumdurationpercentofplanned,
CASE CostFlag WHEN 'Y' THEN t.sumeacbycost ELSE null END sumeacbycost,
t.sumeacbylaborunits,
t.sumeachighpctbylaborunits,
t.sumeaclowpctbylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumetcbycost ELSE null END sumetcbycost,
t.sumetcbylaborunits,
t.sumexpensecostpctcomplete,
t.sumlaborcostpercentcomplete,
t.sumlaborunitspercentcomplete,
t.sumactivitycount,
t.sumactualduration,
CASE CostFlag WHEN 'Y' THEN t.sumactualexpensecost ELSE null END sumactualexpensecost,
t.sumactualfinishdate,
t.summaxactualfinishdate,
t.summaxrestartdate,
CASE CostFlag WHEN 'Y' THEN t.sumactuallaborcost ELSE null END sumactuallaborcost,
t.sumactuallaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumactualmaterialcost ELSE null END sumactualmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumactualnonlaborcost ELSE null END sumactualnonlaborcost,
t.sumactualnonlaborunits,
t.sumactualstartdate,
CASE CostFlag WHEN 'Y' THEN t.sumactualthisperiodcost ELSE null END sumactualthisperiodcost,
CASE CostFlag WHEN 'Y' THEN t.sumactualtotalcost ELSE null END sumactualtotalcost,
CASE CostFlag WHEN 'Y' THEN t.sumactualvaluebycost ELSE null END sumactualvaluebycost,
t.sumactualvaluebylaborunits,
t.sumatcompletionduration,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionexpensecost ELSE null END sumatcompletionexpensecost,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionlaborcost ELSE null END sumatcompletionlaborcost,
t.sumatcompletionlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletiontotalcost ELSE null END sumatcompletiontotalcost,
t.sumbaselineduration,
CASE CostFlag WHEN 'Y' THEN t.sumbaselineexpensecost ELSE null END sumbaselineexpensecost,
t.sumbaselinefinishdate,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinelaborcost ELSE null END sumbaselinelaborcost,
t.sumbaselinelaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinematerialcost ELSE null END sumbaselinematerialcost,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinenonlaborcost ELSE null END sumbaselinenonlaborcost,
t.sumbaselinenonlaborunits,
t.sumbaselinestartdate,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinetotalcost ELSE null END sumbaselinetotalcost,
t.sumcompletedactivitycount,
t.sumcostpercentcomplete,
t.sumcostpercentofplanned,
CASE CostFlag WHEN 'Y' THEN t.sumcostvariancebycost ELSE null END sumcostvariancebycost,
t.sumcostvarianceindex,
CASE CostFlag WHEN 'Y' THEN t.sumcostvarianceindexbycost ELSE null END sumcostvarianceindexbycost,
t.sumdurationpercentcomplete,
t.sumdurationvariance,
CASE CostFlag WHEN 'Y' THEN t.sumearnedvaluebycost ELSE null END sumearnedvaluebycost,
t.sumearnedvaluebylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumexpensecostvariance ELSE null END sumexpensecostvariance,
t.sumfinishdatevariance,
t.suminprogressactivitycount,
CASE CostFlag WHEN 'Y' THEN t.sumlaborcostvariance ELSE null END sumlaborcostvariance,
t.sumlaborunitsvariance,
CASE CostFlag WHEN 'Y' THEN t.summaterialcostvariance ELSE null END summaterialcostvariance,
CASE CostFlag WHEN 'Y' THEN t.sumnonlaborcostvariance ELSE null END sumnonlaborcostvariance,
t.sumnonlaborunitsvariance,
t.sumnotstartedactivitycount,
CASE CostFlag WHEN 'Y' THEN t.sumplannedvaluebycost ELSE null END sumplannedvaluebycost,
t.sumprogressfinishdate,
t.sumremainingduration,
CASE CostFlag WHEN 'Y' THEN t.sumremainingexpensecost ELSE null END sumremainingexpensecost,
t.sumremainingfinishdate,
CASE CostFlag WHEN 'Y' THEN t.sumremaininglaborcost ELSE null END sumremaininglaborcost,
t.sumremaininglaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumremainingmaterialcost ELSE null END sumremainingmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumremainingnonlaborcost ELSE null END sumremainingnonlaborcost,
t.sumremainingnonlaborunits,
t.sumremainingstartdate,
CASE CostFlag WHEN 'Y' THEN t.sumremainingtotalcost ELSE null END sumremainingtotalcost,
t.sumschedulepercentcomplete,
t.sumperformancepercentcomplete,
CASE CostFlag WHEN 'Y' THEN t.sumschedulevariancebycost ELSE null END sumschedulevariancebycost,
t.sumschedulevarianceindex,
t.sumstartdatevariance,
CASE CostFlag WHEN 'Y' THEN t.sumtotalcostvariance ELSE null END sumtotalcostvariance,
t.sumtotalfloat,
t.sumunitspercentcomplete,
t.summaterialcostpctcomplete,
t.sumnonlaborcostpctcomplete,
t.sumnonlaborunitspctcomplete,
t.sumperfpctcmpbylaborunits,
t.sumplannedvaluebylaborunits,
t.sumschdpctcmpbylaborunits,
t.sumschdperfindexbylaborunits,
t.sumschdvariancebylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumschdvarianceindexbycost ELSE null END sumschdvarianceindexbycost,
t.sumschdvarindexbylaborunits,
t.sumscheduleperfindexbycost,
t.sumtocompleteperfindexbycost,
t.sumvaratcmpbylaborunits,
t.sumearlystartdate,
t.sumearlyenddate,
t.sumlatestartdate,
t.sumlateenddate,
t.summaxcalendarid,
t.summincalendarid,
CASE CostFlag WHEN 'Y' THEN t.totalbenefitplan ELSE null END totalbenefitplan,
CASE CostFlag WHEN 'Y' THEN t.totalbenefitplantally ELSE null END totalbenefitplantally,
CASE CostFlag WHEN 'Y' THEN t.totalfunding ELSE null END totalfunding,
CASE CostFlag WHEN 'Y' THEN t.totalspendingplan ELSE null END totalspendingplan,
CASE CostFlag WHEN 'Y' THEN t.totalspendingplantally ELSE null END totalspendingplantally,
CASE CostFlag WHEN 'Y' THEN t.unallocatedbudget ELSE null END unallocatedbudget,
CASE CostFlag WHEN 'Y' THEN t.NetPresentValue ELSE null END NetPresentValue,
t.ReturnOnInvestment,
t.PaybackPeriod,
CASE CostFlag WHEN 'Y' THEN t.undistributedcurrentvariance ELSE null END undistributedcurrentvariance,
t.projectdescription,
t.baselinetypeobjectid,
t.enablepublication,
t.nextpublicationdate,
t.lastpublishedon,
t.publicationpriority,
t.locationobjectid,
t.historyinterval,
t.historylevel,
t.locationname,
t.allowstatusreview,
t.statusreviewerobjectid,
t.statusreviewername,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.etlinterval,
t.etlhour,
t.createdate,
t.lastupdatedatex
FROM PROJECT t, ProjectSecurity ps
WHERE 1=1  and t.objectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
-- START BASELINE VIEW of PROJECT_U
prompt Creating Project-Level View BLPROJECT_U
--METADATA NAME:BLPROJECT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW BLPROJECT_U
AS SELECT 
t.objectid,
t.id,
t.fiscalyearstartmonth,
t.resourcescaneditasgnmtpctcmp,
t.resourcescanselfassigntoacts,
t.primaryrescanmarkactsascmp,
t.resourcecanassigntosameact,
t.checkoutstatus,
t.activitypctcmpbasedonsteps,
t.costquantityrecalculateflag,
t.containssummarydataonly,
t.enablesummarization,
t.wbscodeseparator,
t.activitydefaultpctcmptype,
t.activitydefcostacctobjectid,
t.activitydefcalendarobjectid,
t.currentbaselineprojectobjectid,
t.activityidsuffix,
t.activityidincrement,
t.levelingpriority,
t.summarizetowbslevel,
t.strategicpriority,
t.criticalactivityfloatlimit,
CASE CostFlag WHEN 'Y' THEN t.activitydefaultpriceperunit ELSE null END activitydefaultpriceperunit,
t.plannedstartdate,
t.mustfinishbydate,
t.scheduledfinishdate,
t.dateadded,
t.summarizeddatadate,
t.lastsummarizeddate,
t.projectforecaststartdate,
t.activitydefaultdurationtype,
t.activityidprefix,
t.defaultpricetimeunits,
t.addedby,
t.websiterootdirectory,
t.websiteurl,
t.assignmentdefaultratetype,
t.linkactualtoactualthisperiod,
t.activitydefaultactivitytype,
t.linkpercentcompletewithactual,
t.addactualtoremaining,
t.criticalactivitypathtype,
t.activityidbasedonselactivity,
t.assignmentdefaultdrivingflag,
t.linkplannedandatcompletionflag,
t.resetplannedtoremainingflag,
t.allownegativeactualunitsflag,
t.ownerresourceobjectid,
t.checkoutdate,
t.checkoutuserobjectid,
t.lastfinancialperiodobjectid,
t.useprojectblforearnedvalue,
t.annualdiscountrate,
t.anticipatedfinishdate,
t.anticipatedstartdate,
t.containssummarydata,
CASE CostFlag WHEN 'Y' THEN t.currentbudget ELSE null END currentbudget,
CASE CostFlag WHEN 'Y' THEN t.currentvariance ELSE null END currentvariance,
t.datadate,
t.discountapplicationperiod,
CASE CostFlag WHEN 'Y' THEN t.distributedcurrentbudget ELSE null END distributedcurrentbudget,
t.earnedvaluecomputetype,
t.earnedvalueetccomputetype,
t.earnedvalueetcuservalue,
t.earnedvalueuserpercent,
t.finishdate,
t.forecastfinishdate,
t.forecaststartdate,
t.independentetclaborunits,
CASE CostFlag WHEN 'Y' THEN t.independentetctotalcost ELSE null END independentetctotalcost,
t.name,
t.obsname,
t.obsobjectid,
CASE CostFlag WHEN 'Y' THEN t.originalbudget ELSE null END originalbudget,
t.overallprojectscore,
t.parentepsobjectid,
CASE CostFlag WHEN 'Y' THEN t.proposedbudget ELSE null END proposedbudget,
t.risklevel,
t.riskscore,
t.riskexposure,
t.startdate,
t.status,
t.originalprojectobjectid,
t.riskscorematrixobjectid,
t.sumplannedstartdate,
t.sumplannedfinishdate,
t.sumplannedduration,
t.sumplannedlaborunits,
t.sumplannednonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumplannedexpensecost ELSE null END sumplannedexpensecost,
CASE CostFlag WHEN 'Y' THEN t.sumplannedlaborcost ELSE null END sumplannedlaborcost,
CASE CostFlag WHEN 'Y' THEN t.sumplannedmaterialcost ELSE null END sumplannedmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumplannednonlaborcost ELSE null END sumplannednonlaborcost,
CASE CostFlag WHEN 'Y' THEN t.sumplannedtotalcost ELSE null END sumplannedtotalcost,
t.sumaccountingvarbylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumaccountingvariancebycost ELSE null END sumaccountingvariancebycost,
CASE CostFlag WHEN 'Y' THEN t.sumactthisperiodmaterialcost ELSE null END sumactthisperiodmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumactthisperiodnonlaborcost ELSE null END sumactthisperiodnonlaborcost,
t.sumactthisperiodnonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumactualthisperiodlaborcost ELSE null END sumactualthisperiodlaborcost,
t.sumactualthisperiodlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionmaterialcost ELSE null END sumatcompletionmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionnonlaborcost ELSE null END sumatcompletionnonlaborcost,
t.sumatcompletionnonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletiontotalcostvar ELSE null END sumatcompletiontotalcostvar,
t.sumbaselinecompactivitycount,
t.sumbaselinenotstartedactcnt,
t.sumblinprogressactivitycount,
t.sumbudgetatcmpbylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumbudgetatcompletionbycost ELSE null END sumbudgetatcompletionbycost,
t.sumcostperfindexbycost,
t.sumcostperfindexbylaborunits,
t.sumcostvariancebylaborunits,
t.sumcostvarindexbylaborunits,
t.sumdurationpercentofplanned,
CASE CostFlag WHEN 'Y' THEN t.sumeacbycost ELSE null END sumeacbycost,
t.sumeacbylaborunits,
t.sumeachighpctbylaborunits,
t.sumeaclowpctbylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumetcbycost ELSE null END sumetcbycost,
t.sumetcbylaborunits,
t.sumexpensecostpctcomplete,
t.sumlaborcostpercentcomplete,
t.sumlaborunitspercentcomplete,
t.sumactivitycount,
t.sumactualduration,
CASE CostFlag WHEN 'Y' THEN t.sumactualexpensecost ELSE null END sumactualexpensecost,
t.sumactualfinishdate,
t.summaxactualfinishdate,
t.summaxrestartdate,
CASE CostFlag WHEN 'Y' THEN t.sumactuallaborcost ELSE null END sumactuallaborcost,
t.sumactuallaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumactualmaterialcost ELSE null END sumactualmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumactualnonlaborcost ELSE null END sumactualnonlaborcost,
t.sumactualnonlaborunits,
t.sumactualstartdate,
CASE CostFlag WHEN 'Y' THEN t.sumactualthisperiodcost ELSE null END sumactualthisperiodcost,
CASE CostFlag WHEN 'Y' THEN t.sumactualtotalcost ELSE null END sumactualtotalcost,
CASE CostFlag WHEN 'Y' THEN t.sumactualvaluebycost ELSE null END sumactualvaluebycost,
t.sumactualvaluebylaborunits,
t.sumatcompletionduration,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionexpensecost ELSE null END sumatcompletionexpensecost,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionlaborcost ELSE null END sumatcompletionlaborcost,
t.sumatcompletionlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletiontotalcost ELSE null END sumatcompletiontotalcost,
t.sumbaselineduration,
CASE CostFlag WHEN 'Y' THEN t.sumbaselineexpensecost ELSE null END sumbaselineexpensecost,
t.sumbaselinefinishdate,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinelaborcost ELSE null END sumbaselinelaborcost,
t.sumbaselinelaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinematerialcost ELSE null END sumbaselinematerialcost,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinenonlaborcost ELSE null END sumbaselinenonlaborcost,
t.sumbaselinenonlaborunits,
t.sumbaselinestartdate,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinetotalcost ELSE null END sumbaselinetotalcost,
t.sumcompletedactivitycount,
t.sumcostpercentcomplete,
t.sumcostpercentofplanned,
CASE CostFlag WHEN 'Y' THEN t.sumcostvariancebycost ELSE null END sumcostvariancebycost,
t.sumcostvarianceindex,
CASE CostFlag WHEN 'Y' THEN t.sumcostvarianceindexbycost ELSE null END sumcostvarianceindexbycost,
t.sumdurationpercentcomplete,
t.sumdurationvariance,
CASE CostFlag WHEN 'Y' THEN t.sumearnedvaluebycost ELSE null END sumearnedvaluebycost,
t.sumearnedvaluebylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumexpensecostvariance ELSE null END sumexpensecostvariance,
t.sumfinishdatevariance,
t.suminprogressactivitycount,
CASE CostFlag WHEN 'Y' THEN t.sumlaborcostvariance ELSE null END sumlaborcostvariance,
t.sumlaborunitsvariance,
CASE CostFlag WHEN 'Y' THEN t.summaterialcostvariance ELSE null END summaterialcostvariance,
CASE CostFlag WHEN 'Y' THEN t.sumnonlaborcostvariance ELSE null END sumnonlaborcostvariance,
t.sumnonlaborunitsvariance,
t.sumnotstartedactivitycount,
CASE CostFlag WHEN 'Y' THEN t.sumplannedvaluebycost ELSE null END sumplannedvaluebycost,
t.sumprogressfinishdate,
t.sumremainingduration,
CASE CostFlag WHEN 'Y' THEN t.sumremainingexpensecost ELSE null END sumremainingexpensecost,
t.sumremainingfinishdate,
CASE CostFlag WHEN 'Y' THEN t.sumremaininglaborcost ELSE null END sumremaininglaborcost,
t.sumremaininglaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumremainingmaterialcost ELSE null END sumremainingmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumremainingnonlaborcost ELSE null END sumremainingnonlaborcost,
t.sumremainingnonlaborunits,
t.sumremainingstartdate,
CASE CostFlag WHEN 'Y' THEN t.sumremainingtotalcost ELSE null END sumremainingtotalcost,
t.sumschedulepercentcomplete,
t.sumperformancepercentcomplete,
CASE CostFlag WHEN 'Y' THEN t.sumschedulevariancebycost ELSE null END sumschedulevariancebycost,
t.sumschedulevarianceindex,
t.sumstartdatevariance,
CASE CostFlag WHEN 'Y' THEN t.sumtotalcostvariance ELSE null END sumtotalcostvariance,
t.sumtotalfloat,
t.sumunitspercentcomplete,
t.summaterialcostpctcomplete,
t.sumnonlaborcostpctcomplete,
t.sumnonlaborunitspctcomplete,
t.sumperfpctcmpbylaborunits,
t.sumplannedvaluebylaborunits,
t.sumschdpctcmpbylaborunits,
t.sumschdperfindexbylaborunits,
t.sumschdvariancebylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumschdvarianceindexbycost ELSE null END sumschdvarianceindexbycost,
t.sumschdvarindexbylaborunits,
t.sumscheduleperfindexbycost,
t.sumtocompleteperfindexbycost,
t.sumvaratcmpbylaborunits,
t.sumearlystartdate,
t.sumearlyenddate,
t.sumlatestartdate,
t.sumlateenddate,
t.summaxcalendarid,
t.summincalendarid,
CASE CostFlag WHEN 'Y' THEN t.totalbenefitplan ELSE null END totalbenefitplan,
CASE CostFlag WHEN 'Y' THEN t.totalbenefitplantally ELSE null END totalbenefitplantally,
CASE CostFlag WHEN 'Y' THEN t.totalfunding ELSE null END totalfunding,
CASE CostFlag WHEN 'Y' THEN t.totalspendingplan ELSE null END totalspendingplan,
CASE CostFlag WHEN 'Y' THEN t.totalspendingplantally ELSE null END totalspendingplantally,
CASE CostFlag WHEN 'Y' THEN t.unallocatedbudget ELSE null END unallocatedbudget,
CASE CostFlag WHEN 'Y' THEN t.NetPresentValue ELSE null END NetPresentValue,
t.ReturnOnInvestment,
t.PaybackPeriod,
CASE CostFlag WHEN 'Y' THEN t.undistributedcurrentvariance ELSE null END undistributedcurrentvariance,
t.projectdescription,
t.baselinetypeobjectid,
t.enablepublication,
t.nextpublicationdate,
t.lastpublishedon,
t.publicationpriority,
t.locationobjectid,
t.historyinterval,
t.historylevel,
t.locationname,
t.allowstatusreview,
t.statusreviewerobjectid,
t.statusreviewername,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.etlinterval,
t.etlhour,
t.createdate,
t.lastupdatedatex
FROM BLPROJECT t
LEFT OUTER JOIN Baseline b ON t.objectid = b.ObjectId
LEFT OUTER JOIN ProjectSecurity ps ON b.OriginalProjectObjectId = ps.ProjectObjectId
-- At b
WHERE 1=1  and ps.RDBMSUserId = secpac.get_security_id and b.objectid = t.objectid
    
/
     
-- FINISH BASELINE VIEW of PROJECT_U
prompt Creating Full View PROJECTBUDGETCHANGELOG_FULL
prompt Creating Full View PROJECTBUDGETCHANGELOG_FULL
--METADATA NAME:PROJECTBUDGETCHANGELOG_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTBUDGETCHANGELOG_FULL
AS SELECT 
objectid,
projectobjectid,
wbsobjectid,
projectbudgetchangelogdate,
changenumber,
amount,
responsible,
status,
reason,
projectid,
wbscode,
wbsname,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTBUDGETCHANGELOG
/
     
prompt Creating Project-Level View PROJECTBUDGETCHANGELOG_U
--METADATA NAME:PROJECTBUDGETCHANGELOG_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTBUDGETCHANGELOG_U
AS SELECT 
t.objectid,
t.projectobjectid,
t.wbsobjectid,
t.projectbudgetchangelogdate,
t.changenumber,
CASE CostFlag WHEN 'Y' THEN t.amount ELSE null END amount,
t.responsible,
t.status,
t.reason,
t.projectid,
t.wbscode,
t.wbsname,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM PROJECTBUDGETCHANGELOG t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View PROJECTCODE_FULL
prompt Creating Full View PROJECTCODE_FULL
--METADATA NAME:PROJECTCODE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTCODE_FULL
AS SELECT 
objectid,
codetypeobjectid,
sequencenumber,
codevalue,
parentobjectid,
description,
weight,
codetypename,
issecurecode,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTCODE
/
     
prompt Creating Project-Level View PROJECTCODE_U
--METADATA NAME:PROJECTCODE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTCODE_U
AS SELECT 
t.objectid,
t.codetypeobjectid,
t.sequencenumber,
t.codevalue,
t.parentobjectid,
t.description,
t.weight,
t.codetypename,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM PROJECTCODE t
WHERE 1=1  and issecurecode='N' 
/
     
prompt Creating Project-Level View PROJECTCODE_S
--METADATA NAME:PROJECTCODE_S TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTCODE_S
AS SELECT 
t.objectid,
t.codetypeobjectid,
t.sequencenumber,
t.codevalue,
t.parentobjectid,
t.description,
t.weight,
t.codetypename,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM PROJECTCODE t, GlobalSecurity gs
WHERE 1=1  and gs.RDBMSUserId = secpac.get_security_id and  ( gs.SecureCodeFlag='Y' and t.issecurecode='Y') 
/
     
prompt Creating Full View PROJECTCODEASSIGNMENT_FULL
prompt Creating Full View PROJECTCODEASSIGNMENT_FULL
--METADATA NAME:PROJECTCODEASSIGNMENT_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTCODEASSIGNMENT_FULL
AS SELECT 
projectobjectid,
projectcodetypeobjectid,
projectcodeobjectid,
projectcodedescription,
projectcodetypename,
projectcodevalue,
projectname,
issecurecode,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTCODEASSIGNMENT
/
     
prompt Creating Project-Level View PROJECTCODEASSIGNMENT_U
--METADATA NAME:PROJECTCODEASSIGNMENT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTCODEASSIGNMENT_U
AS SELECT 
t.projectobjectid,
t.projectcodetypeobjectid,
t.projectcodeobjectid,
t.projectcodedescription,
t.projectcodetypename,
t.projectcodevalue,
t.projectname,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM PROJECTCODEASSIGNMENT t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id and issecurecode='N' 
/
     
prompt Creating Project-Level View PROJECTCODEASSIGNMENT_S
--METADATA NAME:PROJECTCODEASSIGNMENT_S TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTCODEASSIGNMENT_S
AS SELECT 
t.projectobjectid,
t.projectcodetypeobjectid,
t.projectcodeobjectid,
t.projectcodedescription,
t.projectcodetypename,
t.projectcodevalue,
t.projectname,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM PROJECTCODEASSIGNMENT t, ProjectSecurity ps, GlobalSecurity gs
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id and gs.RDBMSUserId = secpac.get_security_id and  ( gs.SecureCodeFlag='Y' and t.issecurecode='Y') 
/
     
prompt Creating Full View PROJECTCODEHIERARCHY_FULL
prompt Creating Full View PROJECTCODEHIERARCHY_FULL
--METADATA NAME:PROJECTCODEHIERARCHY_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTCODEHIERARCHY_FULL
AS SELECT 
CodeTypeObjectId,
CodeTypeName,
CodeTypeSequenceNumber,
CodeTypeIsSecure,
ParentCodeValueObjectId,
ParentCodeValueName,
ParentCodeValueShortName,
ParentCodeValueSequenceNumber,
ChildCodeValueObjectId,
ChildCodeValueName,
ChildCodeValueShortName,
ChildCodeValueSequenceNumber,
ParentLevelsBelowRoot,
ChildLevelsBelowRoot,
LevelsBetween,
ChildHasChildren,
FullPathName,
CodeTypeWeight,
MaxCodeValueWeight,
ParentCodeValueWeight,
ChildCodeValueWeight
FROM PROJECTCODEHIERARCHY
/
     
prompt Creating Project-Level View PROJECTCODEHIERARCHY_U
--METADATA NAME:PROJECTCODEHIERARCHY_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTCODEHIERARCHY_U
AS SELECT 
t.CodeTypeObjectId,
t.CodeTypeName,
t.CodeTypeSequenceNumber,
t.ParentCodeValueObjectId,
t.ParentCodeValueName,
t.ParentCodeValueShortName,
t.ParentCodeValueSequenceNumber,
t.ChildCodeValueObjectId,
t.ChildCodeValueName,
t.ChildCodeValueShortName,
t.ChildCodeValueSequenceNumber,
t.ParentLevelsBelowRoot,
t.ChildLevelsBelowRoot,
t.LevelsBetween,
t.ChildHasChildren,
t.FullPathName,
t.CodeTypeWeight,
t.MaxCodeValueWeight,
t.ParentCodeValueWeight,
t.ChildCodeValueWeight
FROM PROJECTCODEHIERARCHY t
WHERE 1=1  and CodeTypeIsSecure='N' 
/
     
prompt Creating Project-Level View PROJECTCODEHIERARCHY_S
--METADATA NAME:PROJECTCODEHIERARCHY_S TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTCODEHIERARCHY_S
AS SELECT 
t.CodeTypeObjectId,
t.CodeTypeName,
t.CodeTypeSequenceNumber,
t.ParentCodeValueObjectId,
t.ParentCodeValueName,
t.ParentCodeValueShortName,
t.ParentCodeValueSequenceNumber,
t.ChildCodeValueObjectId,
t.ChildCodeValueName,
t.ChildCodeValueShortName,
t.ChildCodeValueSequenceNumber,
t.ParentLevelsBelowRoot,
t.ChildLevelsBelowRoot,
t.LevelsBetween,
t.ChildHasChildren,
t.FullPathName,
t.CodeTypeWeight,
t.MaxCodeValueWeight,
t.ParentCodeValueWeight,
t.ChildCodeValueWeight
FROM PROJECTCODEHIERARCHY t, GlobalSecurity gs
WHERE 1=1  and gs.RDBMSUserId = secpac.get_security_id and  ( gs.SecureCodeFlag='Y' and t.CodeTypeIsSecure='Y') 
/
     
prompt Creating Full View PROJECTCODETYPE_FULL
prompt Creating Full View PROJECTCODETYPE_FULL
--METADATA NAME:PROJECTCODETYPE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTCODETYPE_FULL
AS SELECT 
objectid,
sequencenumber,
length,
name,
issecurecode,
weight,
maxcodevalueweight,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTCODETYPE
/
     
prompt Creating Project-Level View PROJECTCODETYPE_U
--METADATA NAME:PROJECTCODETYPE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTCODETYPE_U
AS SELECT 
t.objectid,
t.sequencenumber,
t.length,
t.name,
t.weight,
t.maxcodevalueweight,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM PROJECTCODETYPE t
WHERE 1=1  and issecurecode='N' 
/
     
prompt Creating Project-Level View PROJECTCODETYPE_S
--METADATA NAME:PROJECTCODETYPE_S TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTCODETYPE_S
AS SELECT 
t.objectid,
t.sequencenumber,
t.length,
t.name,
t.weight,
t.maxcodevalueweight,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM PROJECTCODETYPE t, GlobalSecurity gs
WHERE 1=1  and gs.RDBMSUserId = secpac.get_security_id and  ( gs.SecureCodeFlag='Y' and t.issecurecode='Y') 
/
     
prompt Creating Full View PROJECTCODEUSER_FULL
prompt Creating Full View PROJECTCODEUSER_FULL
--METADATA NAME:PROJECTCODEUSER_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTCODEUSER_FULL
AS SELECT 
codeobjectid,
userobjectid,
codetypeobjectid,
codevalue,
username,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTCODEUSER
/
     
prompt Creating Global View PROJECTCODEUSER_U
prompt Creating Global View PROJECTCODEUSER_U
--METADATA NAME:PROJECTCODEUSER_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  PROJECTCODEUSER_U
AS SELECT 
codeobjectid,
userobjectid,
codetypeobjectid,
codevalue,
username,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTCODEUSER
/
     
prompt Creating Full View PROJECTDOCUMENT_FULL
prompt Creating Full View PROJECTDOCUMENT_FULL
--METADATA NAME:PROJECTDOCUMENT_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTDOCUMENT_FULL
AS SELECT 
objectid,
documentobjectid,
projectobjectid,
wbsobjectid,
isworkproduct,
activityobjectid,
activityid,
activityname,
documenttitle,
projectid,
wbscode,
wbsname,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTDOCUMENT
/
     
prompt Creating Project-Level View PROJECTDOCUMENT_U
--METADATA NAME:PROJECTDOCUMENT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTDOCUMENT_U
AS SELECT 
t.objectid,
t.documentobjectid,
t.projectobjectid,
t.wbsobjectid,
t.isworkproduct,
t.activityobjectid,
t.activityid,
t.activityname,
t.documenttitle,
t.projectid,
t.wbscode,
t.wbsname,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM PROJECTDOCUMENT t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View PROJECTFUNDING_FULL
prompt Creating Full View PROJECTFUNDING_FULL
--METADATA NAME:PROJECTFUNDING_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTFUNDING_FULL
AS SELECT 
objectid,
fundingsourceobjectid,
projectobjectid,
amount,
fundshare,
projectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTFUNDING
/
     
prompt Creating Project-Level View PROJECTFUNDING_U
--METADATA NAME:PROJECTFUNDING_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTFUNDING_U
AS SELECT 
t.objectid,
t.fundingsourceobjectid,
t.projectobjectid,
CASE CostFlag WHEN 'Y' THEN t.amount ELSE null END amount,
t.fundshare,
t.projectid,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM PROJECTFUNDING t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View PROJECTISSUE_FULL
prompt Creating Full View PROJECTISSUE_FULL
--METADATA NAME:PROJECTISSUE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTISSUE_FULL
AS SELECT 
objectid,
projectobjectid,
obsobjectid,
priority,
status,
name,
projectthresholdobjectid,
wbsobjectid,
activityobjectid,
resourceobjectid,
thresholdparameterobjectid,
actualvalue,
lowerthreshold,
upperthreshold,
identifiedby,
resolutiondate,
dateidentified,
notes,
activityid,
activityname,
obsname,
projectid,
rawtextnote,
resourceid,
resourcename,
wbscode,
wbsname,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTISSUE
/
     
prompt Creating Project-Level View PROJECTISSUE_U
--METADATA NAME:PROJECTISSUE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTISSUE_U
AS SELECT 
t.objectid,
t.projectobjectid,
t.obsobjectid,
t.priority,
t.status,
t.name,
t.projectthresholdobjectid,
t.wbsobjectid,
t.activityobjectid,
t.resourceobjectid,
t.thresholdparameterobjectid,
t.actualvalue,
t.lowerthreshold,
t.upperthreshold,
t.identifiedby,
t.resolutiondate,
t.dateidentified,
t.notes,
t.activityid,
t.activityname,
t.obsname,
t.projectid,
t.rawtextnote,
t.resourceid,
t.resourcename,
t.wbscode,
t.wbsname,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM PROJECTISSUE t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View PROJECTNOTE_FULL
prompt Creating Full View PROJECTNOTE_FULL
--METADATA NAME:PROJECTNOTE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTNOTE_FULL
AS SELECT 
objectid,
projectobjectid,
wbsobjectid,
notebooktopicobjectid,
note,
notebooktopicname,
projectid,
rawtextnote,
wbscode,
wbsname,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTNOTE
/
     
prompt Creating Project-Level View PROJECTNOTE_U
--METADATA NAME:PROJECTNOTE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTNOTE_U
AS SELECT 
t.objectid,
t.projectobjectid,
t.wbsobjectid,
t.notebooktopicobjectid,
t.note,
t.notebooktopicname,
t.projectid,
t.rawtextnote,
t.wbscode,
t.wbsname,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM PROJECTNOTE t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View PROJECTPORTFOLIO_FULL
prompt Creating Full View PROJECTPORTFOLIO_FULL
--METADATA NAME:PROJECTPORTFOLIO_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTPORTFOLIO_FULL
AS SELECT 
objectid,
includeclosedprojects,
includewhatifprojects,
type,
name,
userobjectid,
description,
username,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTPORTFOLIO
/
     
prompt Creating Global View PROJECTPORTFOLIO_U
prompt Creating Global View PROJECTPORTFOLIO_U
--METADATA NAME:PROJECTPORTFOLIO_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  PROJECTPORTFOLIO_U
AS SELECT 
objectid,
includeclosedprojects,
includewhatifprojects,
type,
name,
userobjectid,
description,
username,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTPORTFOLIO
/
     
prompt Creating Full View PROJECTPROFILE_FULL
prompt Creating Full View PROJECTPROFILE_FULL
--METADATA NAME:PROJECTPROFILE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTPROFILE_FULL
AS SELECT 
objectid,
isdefault,
issuperuser,
name,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTPROFILE
/
     
prompt Creating Global View PROJECTPROFILE_U
prompt Creating Global View PROJECTPROFILE_U
--METADATA NAME:PROJECTPROFILE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  PROJECTPROFILE_U
AS SELECT 
objectid,
isdefault,
issuperuser,
name,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTPROFILE
/
     
prompt Creating Full View PROJECTPROJECTPORTFOLIO_FULL
prompt Creating Full View PROJECTPROJECTPORTFOLIO_FULL
--METADATA NAME:PROJECTPROJECTPORTFOLIO_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTPROJECTPORTFOLIO_FULL
AS SELECT 
projectportfolioobjectid,
projectobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTPROJECTPORTFOLIO
/
     
prompt Creating Global View PROJECTPROJECTPORTFOLIO_U
prompt Creating Global View PROJECTPROJECTPORTFOLIO_U
--METADATA NAME:PROJECTPROJECTPORTFOLIO_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  PROJECTPROJECTPORTFOLIO_U
AS SELECT 
projectportfolioobjectid,
projectobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTPROJECTPORTFOLIO
/
     
prompt Creating Full View PROJECTRESOURCE_FULL
prompt Creating Full View PROJECTRESOURCE_FULL
--METADATA NAME:PROJECTRESOURCE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTRESOURCE_FULL
AS SELECT 
objectid,
wbsobjectid,
resourceobjectid,
projectobjectid,
committedflag,
startdate,
finishdate,
lifeofprojectflag,
projectid,
resourcename,
rolename,
roleobjectid,
status,
wbscode,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTRESOURCE
/
     
prompt Creating Project-Level View PROJECTRESOURCE_U
--METADATA NAME:PROJECTRESOURCE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTRESOURCE_U
AS SELECT 
t.objectid,
t.wbsobjectid,
t.resourceobjectid,
t.projectobjectid,
t.committedflag,
t.startdate,
t.finishdate,
t.lifeofprojectflag,
t.projectid,
t.resourcename,
t.rolename,
t.roleobjectid,
t.status,
t.wbscode,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM PROJECTRESOURCE t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View PROJECTRESOURCEQUANTITY_FULL
prompt Creating Full View PROJECTRESOURCEQUANTITY_FULL
--METADATA NAME:PROJECTRESOURCEQUANTITY_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTRESOURCEQUANTITY_FULL
AS SELECT 
projectresourceobjectid,
weekstartdate,
monthstartdate,
quantity,
committedflag,
projectobjectid,
resourceobjectid,
wbsobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTRESOURCEQUANTITY
/
     
prompt Creating Project-Level View PROJECTRESOURCEQUANTITY_U
--METADATA NAME:PROJECTRESOURCEQUANTITY_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTRESOURCEQUANTITY_U
AS SELECT 
t.projectresourceobjectid,
t.weekstartdate,
t.monthstartdate,
t.quantity,
t.committedflag,
t.projectobjectid,
t.resourceobjectid,
t.wbsobjectid,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM PROJECTRESOURCEQUANTITY t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View RISK_FULL
prompt Creating Full View RISK_FULL
--METADATA NAME:RISK_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RISK_FULL
AS SELECT 
objectid,
projectobjectid,
id,
name,
totalcost,
resourceobjectid,
riskcategoryobjectid,
risktype,
riskstatus,
description,
effect,
cause,
note,
score,
scoretext,
scorecolor,
exposure,
identifiedbyresourceobjectid,
identifiedbyresourceid,
identifiedbyresourcename,
identifieddate,
exposurestartdate,
exposurefinishdate,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RISK
/
     
prompt Creating Project-Level View RISK_U
--METADATA NAME:RISK_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RISK_U
AS SELECT 
t.objectid,
t.projectobjectid,
t.id,
t.name,
CASE CostFlag WHEN 'Y' THEN t.totalcost ELSE null END totalcost,
t.resourceobjectid,
t.riskcategoryobjectid,
t.risktype,
t.riskstatus,
t.description,
t.effect,
t.cause,
t.note,
t.score,
t.scoretext,
t.scorecolor,
CASE CostFlag WHEN 'Y' THEN t.exposure ELSE null END exposure,
t.identifiedbyresourceobjectid,
t.identifiedbyresourceid,
t.identifiedbyresourcename,
t.identifieddate,
t.exposurestartdate,
t.exposurefinishdate,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM RISK t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View RISKIMPACT_FULL
prompt Creating Full View RISKIMPACT_FULL
--METADATA NAME:RISKIMPACT_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RISKIMPACT_FULL
AS SELECT 
riskobjectid,
projectobjectid,
riskthresholdobjectid,
riskthresholdlevelobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RISKIMPACT
/
     
prompt Creating Project-Level View RISKIMPACT_U
--METADATA NAME:RISKIMPACT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RISKIMPACT_U
AS SELECT 
t.riskobjectid,
t.projectobjectid,
t.riskthresholdobjectid,
t.riskthresholdlevelobjectid,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM RISKIMPACT t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View RISKRESPONSEACTION_FULL
prompt Creating Full View RISKRESPONSEACTION_FULL
--METADATA NAME:RISKRESPONSEACTION_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RISKRESPONSEACTION_FULL
AS SELECT 
objectid,
riskresponseplanobjectId,
resourceobjectid,
projectobjectid,
activityobjectid,
id,
name,
riskresponseactionstatus,
actualcost,
remainingcost,
plannedcost,
PhysicalStartDate,
PhysicalFinishDate,
PhysicalBaseStartDate,
PhysicalBaseFinishDate,
score,
scoretext,
scorecolor,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RISKRESPONSEACTION
/
     
prompt Creating Project-Level View RISKRESPONSEACTION_U
--METADATA NAME:RISKRESPONSEACTION_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RISKRESPONSEACTION_U
AS SELECT 
t.objectid,
t.riskresponseplanobjectId,
t.resourceobjectid,
t.projectobjectid,
t.activityobjectid,
t.id,
t.name,
t.riskresponseactionstatus,
CASE CostFlag WHEN 'Y' THEN t.actualcost ELSE null END actualcost,
CASE CostFlag WHEN 'Y' THEN t.remainingcost ELSE null END remainingcost,
CASE CostFlag WHEN 'Y' THEN t.plannedcost ELSE null END plannedcost,
t.PhysicalStartDate,
t.PhysicalFinishDate,
t.PhysicalBaseStartDate,
t.PhysicalBaseFinishDate,
t.score,
t.scoretext,
t.scorecolor,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM RISKRESPONSEACTION t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View RISKRESPONSEACTIONIMPACT_FULL
prompt Creating Full View RISKRESPONSEACTIONIMPACT_FULL
--METADATA NAME:RISKRESPONSEACTIONIMPACT_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RISKRESPONSEACTIONIMPACT_FULL
AS SELECT 
riskresponseactionobjectid,
projectobjectid,
riskthresholdobjectid,
riskthresholdlevelobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RISKRESPONSEACTIONIMPACT
/
     
prompt Creating Project-Level View RISKRESPONSEACTIONIMPACT_U
--METADATA NAME:RISKRESPONSEACTIONIMPACT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RISKRESPONSEACTIONIMPACT_U
AS SELECT 
t.riskresponseactionobjectid,
t.projectobjectid,
t.riskthresholdobjectid,
t.riskthresholdlevelobjectid,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM RISKRESPONSEACTIONIMPACT t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View RISKRESPONSEPLAN_FULL
prompt Creating Full View RISKRESPONSEPLAN_FULL
--METADATA NAME:RISKRESPONSEPLAN_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RISKRESPONSEPLAN_FULL
AS SELECT 
objectid,
riskobjectid,
projectobjectid,
id,
name,
isactive,
responsetype,
actualcost,
remainingcost,
plannedcost,
startdate,
finishdate,
plannedstartdate,
plannedfinishdate,
score,
scoretext,
scorecolor,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RISKRESPONSEPLAN
/
     
prompt Creating Project-Level View RISKRESPONSEPLAN_U
--METADATA NAME:RISKRESPONSEPLAN_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RISKRESPONSEPLAN_U
AS SELECT 
t.objectid,
t.riskobjectid,
t.projectobjectid,
t.id,
t.name,
t.isactive,
t.responsetype,
CASE CostFlag WHEN 'Y' THEN t.actualcost ELSE null END actualcost,
CASE CostFlag WHEN 'Y' THEN t.remainingcost ELSE null END remainingcost,
CASE CostFlag WHEN 'Y' THEN t.plannedcost ELSE null END plannedcost,
t.startdate,
t.finishdate,
t.plannedstartdate,
t.plannedfinishdate,
t.score,
t.scoretext,
t.scorecolor,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM RISKRESPONSEPLAN t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View RISKMATRIXSCORETYPE_FULL
prompt Creating Full View RISKMATRIXSCORETYPE_FULL
--METADATA NAME:RISKMATRIXSCORETYPE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RISKMATRIXSCORETYPE_FULL
AS SELECT 
matrixid,
scoretypeid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RISKMATRIXSCORETYPE
/
     
prompt Creating Global View RISKMATRIXSCORETYPE_U
prompt Creating Global View RISKMATRIXSCORETYPE_U
--METADATA NAME:RISKMATRIXSCORETYPE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  RISKMATRIXSCORETYPE_U
AS SELECT 
matrixid,
scoretypeid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RISKMATRIXSCORETYPE
/
     
prompt Creating Full View RISKSCORETYPE_FULL
prompt Creating Full View RISKSCORETYPE_FULL
--METADATA NAME:RISKSCORETYPE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RISKSCORETYPE_FULL
AS SELECT 
scoretypeid,
name,
scoretype,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RISKSCORETYPE
/
     
prompt Creating Global View RISKSCORETYPE_U
prompt Creating Global View RISKSCORETYPE_U
--METADATA NAME:RISKSCORETYPE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  RISKSCORETYPE_U
AS SELECT 
scoretypeid,
name,
scoretype,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RISKSCORETYPE
/
     
prompt Creating Full View RISKMATRIXSCORE_FULL
prompt Creating Full View RISKMATRIXSCORE_FULL
--METADATA NAME:RISKMATRIXSCORE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RISKMATRIXSCORE_FULL
AS SELECT 
objectid,
riskscorematrixobjectid,
probabilitythresholdlevel,
severity1,
severity2,
severity3,
severity4,
severity5,
severity6,
severity7,
severity8,
severity9,
severity1label,
severity2label,
severity3label,
severity4label,
severity5label,
severity6label,
severity7label,
severity8label,
severity9label,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RISKMATRIXSCORE
/
     
prompt Creating Global View RISKMATRIXSCORE_U
prompt Creating Global View RISKMATRIXSCORE_U
--METADATA NAME:RISKMATRIXSCORE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  RISKMATRIXSCORE_U
AS SELECT 
objectid,
riskscorematrixobjectid,
probabilitythresholdlevel,
severity1,
severity2,
severity3,
severity4,
severity5,
severity6,
severity7,
severity8,
severity9,
severity1label,
severity2label,
severity3label,
severity4label,
severity5label,
severity6label,
severity7label,
severity8label,
severity9label,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RISKMATRIXSCORE
/
     
prompt Creating Full View RISKSCOREMATRIX_FULL
prompt Creating Full View RISKSCOREMATRIX_FULL
--METADATA NAME:RISKSCOREMATRIX_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RISKSCOREMATRIX_FULL
AS SELECT 
objectid,
name,
description,
riskscoringmethod,
impact_levels,
probability_levels,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RISKSCOREMATRIX
/
     
prompt Creating Global View RISKSCOREMATRIX_U
prompt Creating Global View RISKSCOREMATRIX_U
--METADATA NAME:RISKSCOREMATRIX_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  RISKSCOREMATRIX_U
AS SELECT 
objectid,
name,
description,
riskscoringmethod,
impact_levels,
probability_levels,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RISKSCOREMATRIX
/
     
prompt Creating Full View RISKTHRESHOLDLEVEL_FULL
prompt Creating Full View RISKTHRESHOLDLEVEL_FULL
--METADATA NAME:RISKTHRESHOLDLEVEL_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RISKTHRESHOLDLEVEL_FULL
AS SELECT 
objectid,
riskthresholdobjectId,
code,
name,
color,
riskscorelevel,
value,
tolerancerange,
costrange,
schedulerange,
probabiltyrange,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RISKTHRESHOLDLEVEL
/
     
prompt Creating Global View RISKTHRESHOLDLEVEL_U
prompt Creating Global View RISKTHRESHOLDLEVEL_U
--METADATA NAME:RISKTHRESHOLDLEVEL_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  RISKTHRESHOLDLEVEL_U
AS SELECT 
objectid,
riskthresholdobjectId,
code,
name,
color,
riskscorelevel,
value,
tolerancerange,
costrange,
schedulerange,
probabiltyrange,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RISKTHRESHOLDLEVEL
/
     
prompt Creating Full View PROJECTSPENDINGPLAN_FULL
prompt Creating Full View PROJECTSPENDINGPLAN_FULL
--METADATA NAME:PROJECTSPENDINGPLAN_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTSPENDINGPLAN_FULL
AS SELECT 
objectid,
projectobjectid,
wbsobjectid,
spendingplandate,
spendingplan,
benefitplan,
projectid,
wbscode,
wbsname,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM PROJECTSPENDINGPLAN
/
     
prompt Creating Project-Level View PROJECTSPENDINGPLAN_U
--METADATA NAME:PROJECTSPENDINGPLAN_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTSPENDINGPLAN_U
AS SELECT 
t.objectid,
t.projectobjectid,
t.wbsobjectid,
t.spendingplandate,
CASE CostFlag WHEN 'Y' THEN t.spendingplan ELSE null END spendingplan,
CASE CostFlag WHEN 'Y' THEN t.benefitplan ELSE null END benefitplan,
t.projectid,
t.wbscode,
t.wbsname,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM PROJECTSPENDINGPLAN t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View PROJECTSPREAD_FULL
prompt Creating Full View PROJECTSPREAD_FULL
--METADATA NAME:PROJECTSPREAD_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTSPREAD_FULL
AS SELECT 
ObjectId,
Id,
Name,
ParentEPSObjectId,
ObsObjectId,
ObsName,
StartDate,
EndDate,
ActualLaborUnits,
ActualNonlaborUnits,
AtCompletionLaborUnits,
AtCompletionNonlaborUnits,
BaselinePlannedLaborUnits,
BaselinePlannedNonlaborUnits,
EarnedValueLaborUnits,
EstimateAtCompletionLaborUnits,
EstimateToCompleteLaborUnits,
PlannedLaborUnits,
PlannedNonlaborUnits,
PlannedValueLaborUnits,
RemainingLaborUnits,
RemainingNonlaborUnits,
ActualCost,
ActualExpenseCost,
ActualLaborCost,
ActualMaterialCost,
ActualNonlaborCost,
ActualTotalCost,
AtCompletionExpenseCost,
AtCompletionLaborCost,
AtCompletionMaterialCost,
AtCompletionNonlaborCost,
AtCompletionTotalCost,
BaselinePlannedExpenseCost,
BaselinePlannedLaborCost,
BaselinePlannedMaterialCost,
BaselinePlannedNonlaborCost,
BaselinePlannedTotalCost,
EarnedValueCost,
EstimateAtCompletionCost,
EstimateToCompleteCost,
PlannedExpenseCost,
PlannedLaborCost,
PlannedMaterialCost,
PlannedNonlaborCost,
PlannedTotalCost,
PlannedValueCost,
RemainingExpenseCost,
RemainingLaborCost,
RemainingMaterialCost,
RemainingNonlaborCost,
RemainingTotalCost
FROM PROJECTSPREAD
/
     
prompt Creating Project-Level View PROJECTSPREAD_U
--METADATA NAME:PROJECTSPREAD_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTSPREAD_U
AS SELECT 
t.ObjectId,
t.Id,
t.Name,
t.ParentEPSObjectId,
t.ObsObjectId,
t.ObsName,
t.StartDate,
t.EndDate,
t.ActualLaborUnits,
t.ActualNonlaborUnits,
t.AtCompletionLaborUnits,
t.AtCompletionNonlaborUnits,
t.BaselinePlannedLaborUnits,
t.BaselinePlannedNonlaborUnits,
t.EarnedValueLaborUnits,
t.EstimateAtCompletionLaborUnits,
t.EstimateToCompleteLaborUnits,
t.PlannedLaborUnits,
t.PlannedNonlaborUnits,
t.PlannedValueLaborUnits,
t.RemainingLaborUnits,
t.RemainingNonlaborUnits,
CASE CostFlag WHEN 'Y' THEN t.ActualCost ELSE null END ActualCost,
CASE CostFlag WHEN 'Y' THEN t.ActualExpenseCost ELSE null END ActualExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.ActualLaborCost ELSE null END ActualLaborCost,
CASE CostFlag WHEN 'Y' THEN t.ActualMaterialCost ELSE null END ActualMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.ActualNonlaborCost ELSE null END ActualNonlaborCost,
CASE CostFlag WHEN 'Y' THEN t.ActualTotalCost ELSE null END ActualTotalCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionExpenseCost ELSE null END AtCompletionExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionLaborCost ELSE null END AtCompletionLaborCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionMaterialCost ELSE null END AtCompletionMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionNonlaborCost ELSE null END AtCompletionNonlaborCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionTotalCost ELSE null END AtCompletionTotalCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedExpenseCost ELSE null END BaselinePlannedExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedLaborCost ELSE null END BaselinePlannedLaborCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedMaterialCost ELSE null END BaselinePlannedMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedNonlaborCost ELSE null END BaselinePlannedNonlaborCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedTotalCost ELSE null END BaselinePlannedTotalCost,
CASE CostFlag WHEN 'Y' THEN t.EarnedValueCost ELSE null END EarnedValueCost,
CASE CostFlag WHEN 'Y' THEN t.EstimateAtCompletionCost ELSE null END EstimateAtCompletionCost,
CASE CostFlag WHEN 'Y' THEN t.EstimateToCompleteCost ELSE null END EstimateToCompleteCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedExpenseCost ELSE null END PlannedExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedLaborCost ELSE null END PlannedLaborCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedMaterialCost ELSE null END PlannedMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedNonlaborCost ELSE null END PlannedNonlaborCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedTotalCost ELSE null END PlannedTotalCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedValueCost ELSE null END PlannedValueCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingExpenseCost ELSE null END RemainingExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingLaborCost ELSE null END RemainingLaborCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingMaterialCost ELSE null END RemainingMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingNonlaborCost ELSE null END RemainingNonlaborCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingTotalCost ELSE null END RemainingTotalCost
FROM PROJECTSPREAD t, ProjectSecurity ps
WHERE 1=1  and t.ObjectId = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View RELATIONSHIP_FULL
prompt Creating Full View RELATIONSHIP_FULL
--METADATA NAME:RELATIONSHIP_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RELATIONSHIP_FULL
AS SELECT 
objectid,
successoractivityobjectid,
predecessoractivityobjectid,
successorprojectobjectid,
predecessorprojectobjectid,
type,
lag,
predecessoractivityid,
predecessoractivityname,
predecessorprojectid,
successoractivityid,
successoractivityname,
successorprojectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RELATIONSHIP
/
     
prompt Creating Project-Level View RELATIONSHIP_U
--METADATA NAME:RELATIONSHIP_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RELATIONSHIP_U
AS SELECT 
t.objectid,
t.successoractivityobjectid,
t.predecessoractivityobjectid,
t.successorprojectobjectid,
t.predecessorprojectobjectid,
t.type,
t.lag,
t.predecessoractivityid,
t.predecessoractivityname,
t.predecessorprojectid,
t.successoractivityid,
t.successoractivityname,
t.successorprojectid,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM RELATIONSHIP t, ProjectSecurity ps
WHERE 1=1  and t.successorprojectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View RELEASE_FULL
prompt Creating Full View RELEASE_FULL
--METADATA NAME:RELEASE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RELEASE_FULL
AS SELECT 
objectid,
name,
startdate,
releasetheme,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RELEASE
/
     
prompt Creating Global View RELEASE_U
prompt Creating Global View RELEASE_U
--METADATA NAME:RELEASE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  RELEASE_U
AS SELECT 
objectid,
name,
startdate,
releasetheme,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RELEASE
/
     
prompt Creating Full View RELEASEPROJECT_FULL
prompt Creating Full View RELEASEPROJECT_FULL
--METADATA NAME:RELEASEPROJECT_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RELEASEPROJECT_FULL
AS SELECT 
releaseobjectid,
projectobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RELEASEPROJECT
/
     
prompt Creating Global View RELEASEPROJECT_U
prompt Creating Global View RELEASEPROJECT_U
--METADATA NAME:RELEASEPROJECT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  RELEASEPROJECT_U
AS SELECT 
releaseobjectid,
projectobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RELEASEPROJECT
/
     
prompt Creating Full View RELEASEITERATION_FULL
prompt Creating Full View RELEASEITERATION_FULL
--METADATA NAME:RELEASEITERATION_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RELEASEITERATION_FULL
AS SELECT 
releaseobjectid,
projectobjectid,
iterationobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RELEASEITERATION
/
     
prompt Creating Global View RELEASEITERATION_U
prompt Creating Global View RELEASEITERATION_U
--METADATA NAME:RELEASEITERATION_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  RELEASEITERATION_U
AS SELECT 
releaseobjectid,
projectobjectid,
iterationobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RELEASEITERATION
/
     
prompt Creating Full View REPORTDATE_FULL
prompt Creating Full View REPORTDATE_FULL
--METADATA NAME:REPORTDATE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW REPORTDATE_FULL
AS SELECT 
DateName,
DayDate,
DayName,
DayOfMonth,
DayOfYear,
OrdinalDayOfMonth,
OrdinalDayOfYear,
WeekBeginDate,
DayOfWeek,
WeekNumber,
MonthNumber,
MonthName,
MonthShortName,
MonthEndDate,
DaysInMonth,
YearMonth,
QuarterNumber,
QuarterName,
Year,
ETLProcess,
ETLUser
FROM REPORTDATE
/
     
prompt Creating Global View REPORTDATE_U
prompt Creating Global View REPORTDATE_U
--METADATA NAME:REPORTDATE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  REPORTDATE_U
AS SELECT 
DateName,
DayDate,
DayName,
DayOfMonth,
DayOfYear,
OrdinalDayOfMonth,
OrdinalDayOfYear,
WeekBeginDate,
DayOfWeek,
WeekNumber,
MonthNumber,
MonthName,
MonthShortName,
MonthEndDate,
DaysInMonth,
YearMonth,
QuarterNumber,
QuarterName,
Year,
ETLProcess,
ETLUser
FROM REPORTDATE
/
     
prompt Creating Full View REPORTTIME_FULL
prompt Creating Full View REPORTTIME_FULL
--METADATA NAME:REPORTTIME_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW REPORTTIME_FULL
AS SELECT 
CivilianTime,
MilitaryTime,
TwoChar,
TimeName,
TimeOfDay,
ETLProcess,
ETLUser
FROM REPORTTIME
/
     
prompt Creating Global View REPORTTIME_U
prompt Creating Global View REPORTTIME_U
--METADATA NAME:REPORTTIME_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  REPORTTIME_U
AS SELECT 
CivilianTime,
MilitaryTime,
TwoChar,
TimeName,
TimeOfDay,
ETLProcess,
ETLUser
FROM REPORTTIME
/
     
prompt Creating Full View RESASSIGNMENTPERIODACTUAL_FULL
prompt Creating Full View RESASSIGNMENTPERIODACTUAL_FULL
--METADATA NAME:RESASSIGNMENTPERIODACTUAL_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESASSIGNMENTPERIODACTUAL_FULL
AS SELECT 
financialperiodobjectid,
startdate,
enddate,
resourceassignmentobjectid,
activityobjectid,
projectobjectid,
actualunits,
actualcost,
resourcetype,
wbsobjectid,
resourceobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RESASSIGNMENTPERIODACTUAL
/
     
prompt Creating Project-Level View RESASSIGNMENTPERIODACTUAL_U
--METADATA NAME:RESASSIGNMENTPERIODACTUAL_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESASSIGNMENTPERIODACTUAL_U
AS SELECT 
t.financialperiodobjectid,
t.startdate,
t.enddate,
t.resourceassignmentobjectid,
t.activityobjectid,
t.projectobjectid,
t.actualunits,
CASE CostFlag WHEN 'Y' THEN t.actualcost ELSE null END actualcost,
t.resourcetype,
t.wbsobjectid,
t.resourceobjectid,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM RESASSIGNMENTPERIODACTUAL t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View RESOURCEACCESS_FULL
prompt Creating Full View RESOURCEACCESS_FULL
--METADATA NAME:RESOURCEACCESS_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCEACCESS_FULL
AS SELECT 
userobjectid,
resourceobjectid,
resourceid,
resourcename,
username,
lastupdatedate
FROM RESOURCEACCESS
/
     
prompt Creating Project-Level View RESOURCEACCESS_U
--METADATA NAME:RESOURCEACCESS_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCEACCESS_U
AS SELECT 
t.userobjectid,
t.resourceobjectid,
t.resourceid,
t.resourcename,
t.username,
t.lastupdatedate
FROM RESOURCEACCESS t, ResourceSecurity rs, GlobalSecurity gs
WHERE 1=1 and t.resourceobjectid = rs.ResourceObjectId and gs.rdbmsuserid = rs.rdbmsuserid   and rs.RDBMSUserId = secpac.get_security_id and gs.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View RESOURCEASSIGNMENT_FULL
prompt Creating Full View RESOURCEASSIGNMENT_FULL
--METADATA NAME:RESOURCEASSIGNMENT_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCEASSIGNMENT_FULL
AS SELECT 
objectid,
activityobjectid,
projectobjectid,
resourcetype,
iscostunitslinked,
roleobjectid,
costaccountobjectid,
resourceobjectid,
proficiency,
pendingpercentcomplete,
remainingunits,
pendingremainingunits,
plannedunits,
remainingunitspertime,
pendingactualregularunits,
plannedlag,
plannedunitspertime,
actualovertimeunits,
pendingactualovertimeunits,
actualregularunits,
remaininglag,
overtimefactor,
plannedcost,
actualregularcost,
actualovertimecost,
remainingcost,
actualstartdate,
actualfinishdate,
remainingstartdate,
remainingfinishdate,
plannedstartdate,
plannedfinishdate,
remaininglatestartdate,
remaininglatefinishdate,
ratetype,
actualthisperiodcost,
actualthisperiodunits,
resourcecurveobjectid,
drivingactivitydatesflag,
ratesource,
activityid,
activityname,
actualcost,
actualduration,
actualunits,
atcompletioncost,
atcompletionduration,
atcompletionunits,
autocomputeactuals,
calendarobjectid,
costaccountid,
costaccountname,
finishdate,
isactive,
isovertimeallowed,
isprimaryresource,
plannedduration,
priceperunit,
projectid,
remainingduration,
resourcecurvename,
resourceid,
resourcename,
roleid,
rolename,
staffedremainingcost,
staffedremainingunits,
startdate,
unitspercentcomplete,
unstaffedremainingcost,
unstaffedremainingunits,
wbsobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate,
lastupdatedatex 
,RPT_CURRENT_FLAG
FROM RESOURCEASSIGNMENT
/
     
prompt Creating Project-Level View RESOURCEASSIGNMENT_U
--METADATA NAME:RESOURCEASSIGNMENT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCEASSIGNMENT_U
AS SELECT 
t.objectid,
t.activityobjectid,
t.projectobjectid,
t.resourcetype,
t.iscostunitslinked,
t.roleobjectid,
t.costaccountobjectid,
t.resourceobjectid,
CASE ProficiencyFlag WHEN 'Y' THEN t.proficiency ELSE null END proficiency,
t.pendingpercentcomplete,
t.remainingunits,
t.pendingremainingunits,
t.plannedunits,
t.remainingunitspertime,
t.pendingactualregularunits,
t.plannedlag,
t.plannedunitspertime,
t.actualovertimeunits,
t.pendingactualovertimeunits,
t.actualregularunits,
t.remaininglag,
t.overtimefactor,
CASE CostFlag WHEN 'Y' THEN t.plannedcost ELSE null END plannedcost,
CASE CostFlag WHEN 'Y' THEN t.actualregularcost ELSE null END actualregularcost,
CASE CostFlag WHEN 'Y' THEN t.actualovertimecost ELSE null END actualovertimecost,
CASE CostFlag WHEN 'Y' THEN t.remainingcost ELSE null END remainingcost,
t.actualstartdate,
t.actualfinishdate,
t.remainingstartdate,
t.remainingfinishdate,
t.plannedstartdate,
t.plannedfinishdate,
t.remaininglatestartdate,
t.remaininglatefinishdate,
t.ratetype,
CASE CostFlag WHEN 'Y' THEN t.actualthisperiodcost ELSE null END actualthisperiodcost,
t.actualthisperiodunits,
t.resourcecurveobjectid,
t.drivingactivitydatesflag,
t.ratesource,
t.activityid,
t.activityname,
CASE CostFlag WHEN 'Y' THEN t.actualcost ELSE null END actualcost,
t.actualduration,
t.actualunits,
CASE CostFlag WHEN 'Y' THEN t.atcompletioncost ELSE null END atcompletioncost,
t.atcompletionduration,
t.atcompletionunits,
t.autocomputeactuals,
t.calendarobjectid,
t.costaccountid,
t.costaccountname,
t.finishdate,
t.isactive,
t.isovertimeallowed,
t.isprimaryresource,
t.plannedduration,
CASE CostFlag WHEN 'Y' THEN t.priceperunit ELSE null END priceperunit,
t.projectid,
t.remainingduration,
t.resourcecurvename,
t.resourceid,
t.resourcename,
t.roleid,
t.rolename,
CASE CostFlag WHEN 'Y' THEN t.staffedremainingcost ELSE null END staffedremainingcost,
t.staffedremainingunits,
t.startdate,
t.unitspercentcomplete,
CASE CostFlag WHEN 'Y' THEN t.unstaffedremainingcost ELSE null END unstaffedremainingcost,
t.unstaffedremainingunits,
t.wbsobjectid,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate,
t.lastupdatedatex 
,RPT_CURRENT_FLAG
FROM RESOURCEASSIGNMENT t, ProjectSecurity ps, GlobalSecurity gs
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id and gs.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View RESOURCECODE_FULL
prompt Creating Full View RESOURCECODE_FULL
--METADATA NAME:RESOURCECODE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCECODE_FULL
AS SELECT 
objectid,
codetypeobjectid,
sequencenumber,
codevalue,
description,
parentobjectid,
codetypename,
issecurecode,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RESOURCECODE
/
     
prompt Creating Project-Level View RESOURCECODE_U
--METADATA NAME:RESOURCECODE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCECODE_U
AS SELECT 
t.objectid,
t.codetypeobjectid,
t.sequencenumber,
t.codevalue,
t.description,
t.parentobjectid,
t.codetypename,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM RESOURCECODE t
WHERE 1=1  and issecurecode='N' 
/
     
prompt Creating Project-Level View RESOURCECODE_S
--METADATA NAME:RESOURCECODE_S TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCECODE_S
AS SELECT 
t.objectid,
t.codetypeobjectid,
t.sequencenumber,
t.codevalue,
t.description,
t.parentobjectid,
t.codetypename,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM RESOURCECODE t, GlobalSecurity gs
WHERE 1=1  and gs.RDBMSUserId = secpac.get_security_id and  ( gs.SecureCodeFlag='Y' and t.issecurecode='Y') 
/
     
prompt Creating Full View RESOURCECODEASSIGNMENT_FULL
prompt Creating Full View RESOURCECODEASSIGNMENT_FULL
--METADATA NAME:RESOURCECODEASSIGNMENT_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCECODEASSIGNMENT_FULL
AS SELECT 
resourceobjectid,
resourcecodetypeobjectid,
resourcecodeobjectid,
resourcecodedescription,
resourcecodetypename,
resourcecodevalue,
resourceid,
resourcename,
issecurecode,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RESOURCECODEASSIGNMENT
/
     
prompt Creating Project-Level View RESOURCECODEASSIGNMENT_U
--METADATA NAME:RESOURCECODEASSIGNMENT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCECODEASSIGNMENT_U
AS SELECT 
t.resourceobjectid,
t.resourcecodetypeobjectid,
t.resourcecodeobjectid,
t.resourcecodedescription,
t.resourcecodetypename,
t.resourcecodevalue,
t.resourceid,
t.resourcename,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM RESOURCECODEASSIGNMENT t, ResourceSecurity rs, GlobalSecurity gs
WHERE 1=1 and t.resourceobjectid = rs.ResourceObjectId and gs.rdbmsuserid = rs.rdbmsuserid   and rs.RDBMSUserId = secpac.get_security_id and gs.RDBMSUserId = secpac.get_security_id and issecurecode='N' 
/
     
prompt Creating Project-Level View RESOURCECODEASSIGNMENT_S
--METADATA NAME:RESOURCECODEASSIGNMENT_S TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCECODEASSIGNMENT_S
AS SELECT 
t.resourceobjectid,
t.resourcecodetypeobjectid,
t.resourcecodeobjectid,
t.resourcecodedescription,
t.resourcecodetypename,
t.resourcecodevalue,
t.resourceid,
t.resourcename,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM RESOURCECODEASSIGNMENT t, ResourceSecurity rs, GlobalSecurity gs
WHERE 1=1 and t.resourceobjectid = rs.ResourceObjectId and gs.rdbmsuserid = rs.rdbmsuserid   and rs.RDBMSUserId = secpac.get_security_id and gs.RDBMSUserId = secpac.get_security_id and  ( gs.SecureCodeFlag='Y' and t.issecurecode='Y') 
/
     
prompt Creating Full View RESOURCECODEHIERARCHY_FULL
prompt Creating Full View RESOURCECODEHIERARCHY_FULL
--METADATA NAME:RESOURCECODEHIERARCHY_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCECODEHIERARCHY_FULL
AS SELECT 
CodeTypeObjectId,
CodeTypeName,
CodeTypeSequenceNumber,
CodeTypeIsSecure,
ParentCodeValueObjectId,
ParentCodeValueName,
ParentCodeValueShortName,
ParentCodeValueSequenceNumber,
ChildCodeValueObjectId,
ChildCodeValueName,
ChildCodeValueShortName,
ChildCodeValueSequenceNumber,
ParentLevelsBelowRoot,
ChildLevelsBelowRoot,
LevelsBetween,
ChildHasChildren,
FullPathName
FROM RESOURCECODEHIERARCHY
/
     
prompt Creating Project-Level View RESOURCECODEHIERARCHY_U
--METADATA NAME:RESOURCECODEHIERARCHY_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCECODEHIERARCHY_U
AS SELECT 
t.CodeTypeObjectId,
t.CodeTypeName,
t.CodeTypeSequenceNumber,
t.ParentCodeValueObjectId,
t.ParentCodeValueName,
t.ParentCodeValueShortName,
t.ParentCodeValueSequenceNumber,
t.ChildCodeValueObjectId,
t.ChildCodeValueName,
t.ChildCodeValueShortName,
t.ChildCodeValueSequenceNumber,
t.ParentLevelsBelowRoot,
t.ChildLevelsBelowRoot,
t.LevelsBetween,
t.ChildHasChildren,
t.FullPathName
FROM RESOURCECODEHIERARCHY t
WHERE 1=1  and CodeTypeIsSecure='N' 
/
     
prompt Creating Project-Level View RESOURCECODEHIERARCHY_S
--METADATA NAME:RESOURCECODEHIERARCHY_S TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCECODEHIERARCHY_S
AS SELECT 
t.CodeTypeObjectId,
t.CodeTypeName,
t.CodeTypeSequenceNumber,
t.ParentCodeValueObjectId,
t.ParentCodeValueName,
t.ParentCodeValueShortName,
t.ParentCodeValueSequenceNumber,
t.ChildCodeValueObjectId,
t.ChildCodeValueName,
t.ChildCodeValueShortName,
t.ChildCodeValueSequenceNumber,
t.ParentLevelsBelowRoot,
t.ChildLevelsBelowRoot,
t.LevelsBetween,
t.ChildHasChildren,
t.FullPathName
FROM RESOURCECODEHIERARCHY t, GlobalSecurity gs
WHERE 1=1  and gs.RDBMSUserId = secpac.get_security_id and  ( gs.SecureCodeFlag='Y' and t.CodeTypeIsSecure='Y') 
/
     
prompt Creating Full View RESOURCECODETYPE_FULL
prompt Creating Full View RESOURCECODETYPE_FULL
--METADATA NAME:RESOURCECODETYPE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCECODETYPE_FULL
AS SELECT 
objectid,
sequencenumber,
length,
name,
issecurecode,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RESOURCECODETYPE
/
     
prompt Creating Project-Level View RESOURCECODETYPE_U
--METADATA NAME:RESOURCECODETYPE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCECODETYPE_U
AS SELECT 
t.objectid,
t.sequencenumber,
t.length,
t.name,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM RESOURCECODETYPE t
WHERE 1=1  and issecurecode='N' 
/
     
prompt Creating Project-Level View RESOURCECODETYPE_S
--METADATA NAME:RESOURCECODETYPE_S TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCECODETYPE_S
AS SELECT 
t.objectid,
t.sequencenumber,
t.length,
t.name,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM RESOURCECODETYPE t, GlobalSecurity gs
WHERE 1=1  and gs.RDBMSUserId = secpac.get_security_id and  ( gs.SecureCodeFlag='Y' and t.issecurecode='Y') 
/
     
prompt Creating Full View RESOURCECURVE_FULL
prompt Creating Full View RESOURCECURVE_FULL
--METADATA NAME:RESOURCECURVE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCECURVE_FULL
AS SELECT 
objectid,
name,
isdefault,
value0,
value5,
value10,
value15,
value20,
value25,
value30,
value35,
value40,
value45,
value50,
value55,
value60,
value65,
value70,
value75,
value80,
value85,
value90,
value95,
value100,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RESOURCECURVE
/
     
prompt Creating Global View RESOURCECURVE_U
prompt Creating Global View RESOURCECURVE_U
--METADATA NAME:RESOURCECURVE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  RESOURCECURVE_U
AS SELECT 
objectid,
name,
isdefault,
value0,
value5,
value10,
value15,
value20,
value25,
value30,
value35,
value40,
value45,
value50,
value55,
value60,
value65,
value70,
value75,
value80,
value85,
value90,
value95,
value100,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RESOURCECURVE
/
     
prompt Creating Full View RESOURCEHIERARCHY_FULL
prompt Creating Full View RESOURCEHIERARCHY_FULL
--METADATA NAME:RESOURCEHIERARCHY_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCEHIERARCHY_FULL
AS SELECT 
ParentObjectId,
ParentSequenceNumber,
ParentName,
ParentId,
ChildObjectId,
ChildSequenceNumber,
ChildName,
ChildId,
ParentLevelsBelowRoot,
ChildLevelsBelowRoot,
LevelsBetween,
ChildHasChildren,
FullPathName,
lastupdatedate
FROM RESOURCEHIERARCHY
/
     
prompt Creating Project-Level View RESOURCEHIERARCHY_U
--METADATA NAME:RESOURCEHIERARCHY_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCEHIERARCHY_U
AS SELECT 
t.ParentObjectId,
t.ParentSequenceNumber,
t.ParentName,
t.ParentId,
t.ChildObjectId,
t.ChildSequenceNumber,
t.ChildName,
t.ChildId,
t.ParentLevelsBelowRoot,
t.ChildLevelsBelowRoot,
t.LevelsBetween,
t.ChildHasChildren,
t.FullPathName,
t.lastupdatedate
FROM RESOURCEHIERARCHY t, ResourceSecurity rs, GlobalSecurity gs
WHERE 1=1 and t.ParentObjectId = rs.ResourceObjectId and gs.rdbmsuserid = rs.rdbmsuserid   and rs.RDBMSUserId = secpac.get_security_id and gs.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View RESOURCEHOUR_FULL
prompt Creating Full View RESOURCEHOUR_FULL
--METADATA NAME:RESOURCEHOUR_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCEHOUR_FULL
AS SELECT 
objectid,
resourceobjectid,
timesheetperiodobjectid,
activitytimesheetlinkflag,
resourceassignmentobjectid,
overheadcodeobjectid,
projectobjectid,
unapprovedhours,
approvedhours,
unapprovedovertimehours,
approvedovertimehours,
resourcehourdate,
status,
projectid,
projectname,
resourceid,
resourcename,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RESOURCEHOUR
/
     
prompt Creating Project-Level View RESOURCEHOUR_U
--METADATA NAME:RESOURCEHOUR_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCEHOUR_U
AS SELECT 
t.objectid,
t.resourceobjectid,
t.timesheetperiodobjectid,
t.activitytimesheetlinkflag,
t.resourceassignmentobjectid,
t.overheadcodeobjectid,
t.projectobjectid,
t.unapprovedhours,
t.approvedhours,
t.unapprovedovertimehours,
t.approvedovertimehours,
t.resourcehourdate,
t.status,
t.projectid,
t.projectname,
t.resourceid,
t.resourcename,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM RESOURCEHOUR t left outer join ProjectSecurity ps on t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
WHERE 1=1  and ( ps.projectobjectid is not null
or t.projectobjectid is null )
/
     
prompt Creating Full View RESOURCERATE_FULL
prompt Creating Full View RESOURCERATE_FULL
--METADATA NAME:RESOURCERATE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCERATE_FULL
AS SELECT 
objectid,
resourceobjectid,
effectivedate,
shiftperiodobjectid,
maxunitspertime,
priceperunit,
priceperunit2,
priceperunit3,
priceperunit4,
priceperunit5,
resourceid,
resourcename,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RESOURCERATE
/
     
prompt Creating Project-Level View RESOURCERATE_U
--METADATA NAME:RESOURCERATE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCERATE_U
AS SELECT 
t.objectid,
t.resourceobjectid,
t.effectivedate,
t.shiftperiodobjectid,
t.maxunitspertime,
CASE ResourceCostFlag WHEN 'Y' THEN t.priceperunit ELSE null END priceperunit,
CASE ResourceCostFlag WHEN 'Y' THEN t.priceperunit2 ELSE null END priceperunit2,
CASE ResourceCostFlag WHEN 'Y' THEN t.priceperunit3 ELSE null END priceperunit3,
CASE ResourceCostFlag WHEN 'Y' THEN t.priceperunit4 ELSE null END priceperunit4,
CASE ResourceCostFlag WHEN 'Y' THEN t.priceperunit5 ELSE null END priceperunit5,
t.resourceid,
t.resourcename,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM RESOURCERATE t, ResourceSecurity rs, GlobalSecurity gs
WHERE 1=1 and t.resourceobjectid = rs.ResourceObjectId and gs.rdbmsuserid = rs.rdbmsuserid   and rs.RDBMSUserId = secpac.get_security_id and gs.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View RESOURCERESOURCETEAM_FULL
prompt Creating Full View RESOURCERESOURCETEAM_FULL
--METADATA NAME:RESOURCERESOURCETEAM_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCERESOURCETEAM_FULL
AS SELECT 
resourceteamobjectid,
resourceobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RESOURCERESOURCETEAM
/
     
prompt Creating Project-Level View RESOURCERESOURCETEAM_U
--METADATA NAME:RESOURCERESOURCETEAM_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCERESOURCETEAM_U
AS SELECT 
t.resourceteamobjectid,
t.resourceobjectid,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM RESOURCERESOURCETEAM t, ResourceSecurity rs, GlobalSecurity gs
WHERE 1=1 and t.resourceobjectid = rs.ResourceObjectId and gs.rdbmsuserid = rs.rdbmsuserid   and rs.RDBMSUserId = secpac.get_security_id and gs.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View RESOURCEROLE_FULL
prompt Creating Full View RESOURCEROLE_FULL
--METADATA NAME:RESOURCEROLE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCEROLE_FULL
AS SELECT 
resourceobjectid,
roleobjectid,
proficiency,
resourceid,
resourcename,
roleid,
rolename,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RESOURCEROLE
/
     
prompt Creating Project-Level View RESOURCEROLE_U
--METADATA NAME:RESOURCEROLE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCEROLE_U
AS SELECT 
t.resourceobjectid,
t.roleobjectid,
CASE ProficiencyFlag WHEN 'Y' THEN t.proficiency ELSE null END proficiency,
t.resourceid,
t.resourcename,
t.roleid,
t.rolename,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM RESOURCEROLE t, ResourceSecurity rs, GlobalSecurity gs
WHERE 1=1 and t.resourceobjectid = rs.ResourceObjectId and gs.rdbmsuserid = rs.rdbmsuserid   and rs.RDBMSUserId = secpac.get_security_id and gs.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View RESOURCES_FULL
prompt Creating Full View RESOURCES_FULL
--METADATA NAME:RESOURCES_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCES_FULL
AS SELECT 
objectid,
calendarobjectid,
sequencenumber,
usetimesheets,
isactive,
resourcetype,
autocomputeactuals,
isovertimeallowed,
calculatecostfromunits,
id,
name,
parentobjectid,
timesheetapprovalmgrobjectid,
userobjectid,
primaryroleobjectid,
currencyobjectid,
shiftobjectid,
overtimefactor,
defaultunitspertime,
officephone,
otherphone,
employeeid,
title,
emailaddress,
unitofmeasureobjectid,
resourcenotes,
calendarname,
currencyid,
currencyname,
primaryroleid,
primaryrolename,
timesheetapprovalmanager,
username,
locationobjectid,
locationname,
lastupdateuser,
lastupdatedate,
createuser,
createdate,
lastupdatedatex
FROM RESOURCES
/
     
prompt Creating Project-Level View RESOURCES_U
--METADATA NAME:RESOURCES_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCES_U
AS SELECT 
t.objectid,
t.calendarobjectid,
t.sequencenumber,
t.usetimesheets,
t.isactive,
t.resourcetype,
t.autocomputeactuals,
t.isovertimeallowed,
t.calculatecostfromunits,
t.id,
t.name,
t.parentobjectid,
t.timesheetapprovalmgrobjectid,
t.userobjectid,
t.primaryroleobjectid,
t.currencyobjectid,
t.shiftobjectid,
t.overtimefactor,
t.defaultunitspertime,
t.officephone,
t.otherphone,
t.employeeid,
t.title,
t.emailaddress,
t.unitofmeasureobjectid,
t.resourcenotes,
t.calendarname,
t.currencyid,
t.currencyname,
t.primaryroleid,
t.primaryrolename,
t.timesheetapprovalmanager,
t.username,
t.locationobjectid,
t.locationname,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate,
t.lastupdatedatex
FROM RESOURCES t, ResourceSecurity rs, GlobalSecurity gs
WHERE 1=1 and t.objectid = rs.ResourceObjectId and gs.rdbmsuserid = rs.rdbmsuserid   and rs.RDBMSUserId = secpac.get_security_id and gs.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View RESOURCELOCATION_FULL
prompt Creating Full View RESOURCELOCATION_FULL
--METADATA NAME:RESOURCELOCATION_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCELOCATION_FULL
AS SELECT 
objectid,
resourceobjectid,
longitude,
latitude,
geolocation,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RESOURCELOCATION
/
     
prompt Creating Global View RESOURCELOCATION_U
prompt Creating Global View RESOURCELOCATION_U
--METADATA NAME:RESOURCELOCATION_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  RESOURCELOCATION_U
AS SELECT 
objectid,
resourceobjectid,
longitude,
latitude,
geolocation,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RESOURCELOCATION
/
     
prompt Creating Full View RESOURCETEAM_FULL
prompt Creating Full View RESOURCETEAM_FULL
--METADATA NAME:RESOURCETEAM_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCETEAM_FULL
AS SELECT 
objectid,
userobjectid,
name,
description,
username,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RESOURCETEAM
/
     
prompt Creating Global View RESOURCETEAM_U
prompt Creating Global View RESOURCETEAM_U
--METADATA NAME:RESOURCETEAM_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  RESOURCETEAM_U
AS SELECT 
objectid,
userobjectid,
name,
description,
username,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RESOURCETEAM
/
     
prompt Creating Full View RISKTYPE_FULL
prompt Creating Full View RISKTYPE_FULL
--METADATA NAME:RISKTYPE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RISKTYPE_FULL
AS SELECT 
objectid,
sequencenumber,
name,
parentobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RISKTYPE
/
     
prompt Creating Global View RISKTYPE_U
prompt Creating Global View RISKTYPE_U
--METADATA NAME:RISKTYPE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  RISKTYPE_U
AS SELECT 
objectid,
sequencenumber,
name,
parentobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM RISKTYPE
/
     
prompt Creating Full View ROLE_FULL
prompt Creating Full View ROLE_FULL
--METADATA NAME:ROLE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ROLE_FULL
AS SELECT 
objectid,
id,
name,
sequencenumber,
parentobjectid,
calculatecostfromunits,
responsibilities,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ROLE
/
     
prompt Creating Global View ROLE_U
prompt Creating Global View ROLE_U
--METADATA NAME:ROLE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  ROLE_U
AS SELECT 
objectid,
id,
name,
sequencenumber,
parentobjectid,
calculatecostfromunits,
responsibilities,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ROLE
/
     
prompt Creating Full View ROLERATE_FULL
prompt Creating Full View ROLERATE_FULL
--METADATA NAME:ROLERATE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ROLERATE_FULL
AS SELECT 
objectid,
roleobjectid,
priceperunit,
priceperunit2,
priceperunit3,
priceperunit4,
priceperunit5,
roleid,
rolename,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ROLERATE
/
     
prompt Creating Global View ROLERATE_U
prompt Creating Global View ROLERATE_U
--METADATA NAME:ROLERATE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  ROLERATE_U
AS SELECT 
objectid,
roleobjectid,
priceperunit,
priceperunit2,
priceperunit3,
priceperunit4,
priceperunit5,
roleid,
rolename,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ROLERATE
/
     
prompt Creating Full View ROLEROLETEAM_FULL
prompt Creating Full View ROLEROLETEAM_FULL
--METADATA NAME:ROLEROLETEAM_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ROLEROLETEAM_FULL
AS SELECT 
roleteamobjectid,
roleobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ROLEROLETEAM
/
     
prompt Creating Global View ROLEROLETEAM_U
prompt Creating Global View ROLEROLETEAM_U
--METADATA NAME:ROLEROLETEAM_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  ROLEROLETEAM_U
AS SELECT 
roleteamobjectid,
roleobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ROLEROLETEAM
/
     
prompt Creating Full View ROLETEAM_FULL
prompt Creating Full View ROLETEAM_FULL
--METADATA NAME:ROLETEAM_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW ROLETEAM_FULL
AS SELECT 
objectid,
userobjectid,
name,
description,
username,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ROLETEAM
/
     
prompt Creating Global View ROLETEAM_U
prompt Creating Global View ROLETEAM_U
--METADATA NAME:ROLETEAM_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  ROLETEAM_U
AS SELECT 
objectid,
userobjectid,
name,
description,
username,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM ROLETEAM
/
     
prompt Creating Full View SHIFT_FULL
prompt Creating Full View SHIFT_FULL
--METADATA NAME:SHIFT_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW SHIFT_FULL
AS SELECT 
objectid,
name,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM SHIFT
/
     
prompt Creating Global View SHIFT_U
prompt Creating Global View SHIFT_U
--METADATA NAME:SHIFT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  SHIFT_U
AS SELECT 
objectid,
name,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM SHIFT
/
     
prompt Creating Full View SHIFTPERIOD_FULL
prompt Creating Full View SHIFTPERIOD_FULL
--METADATA NAME:SHIFTPERIOD_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW SHIFTPERIOD_FULL
AS SELECT 
objectid,
shiftobjectid,
starthour,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM SHIFTPERIOD
/
     
prompt Creating Global View SHIFTPERIOD_U
prompt Creating Global View SHIFTPERIOD_U
--METADATA NAME:SHIFTPERIOD_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  SHIFTPERIOD_U
AS SELECT 
objectid,
shiftobjectid,
starthour,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM SHIFTPERIOD
/
     
prompt Creating Full View SNAPSHOT_FULL
prompt Creating Full View SNAPSHOT_FULL
--METADATA NAME:SNAPSHOT_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW SNAPSHOT_FULL
AS SELECT 
objectid,
name,
snapshotdate,
snapshotgroupobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM SNAPSHOT
/
     
prompt Creating Global View SNAPSHOT_U
prompt Creating Global View SNAPSHOT_U
--METADATA NAME:SNAPSHOT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  SNAPSHOT_U
AS SELECT 
objectid,
name,
snapshotdate,
snapshotgroupobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM SNAPSHOT
/
     
prompt Creating Full View SNAPSHOTGROUP_FULL
prompt Creating Full View SNAPSHOTGROUP_FULL
--METADATA NAME:SNAPSHOTGROUP_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW SNAPSHOTGROUP_FULL
AS SELECT 
objectid,
name,
description,
interval,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM SNAPSHOTGROUP
/
     
prompt Creating Global View SNAPSHOTGROUP_U
prompt Creating Global View SNAPSHOTGROUP_U
--METADATA NAME:SNAPSHOTGROUP_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  SNAPSHOTGROUP_U
AS SELECT 
objectid,
name,
description,
interval,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM SNAPSHOTGROUP
/
     
prompt Creating Full View SNAPSHOTPROJECT_FULL
prompt Creating Full View SNAPSHOTPROJECT_FULL
--METADATA NAME:SNAPSHOTPROJECT_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW SNAPSHOTPROJECT_FULL
AS SELECT 
snapshotgroupobjectid,
projectobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM SNAPSHOTPROJECT
/
     
prompt Creating Global View SNAPSHOTPROJECT_U
prompt Creating Global View SNAPSHOTPROJECT_U
--METADATA NAME:SNAPSHOTPROJECT_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  SNAPSHOTPROJECT_U
AS SELECT 
snapshotgroupobjectid,
projectobjectid,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM SNAPSHOTPROJECT
/
     
prompt Creating Full View TIMESHEET_FULL
prompt Creating Full View TIMESHEET_FULL
--METADATA NAME:TIMESHEET_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW TIMESHEET_FULL
AS SELECT 
timesheetperiodobjectid,
resourceobjectid,
isdaily,
status,
lastreceiveddate,
statusdate,
notes,
resourceid,
resourcename,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM TIMESHEET
/
     
prompt Creating Global View TIMESHEET_U
prompt Creating Global View TIMESHEET_U
--METADATA NAME:TIMESHEET_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  TIMESHEET_U
AS SELECT 
timesheetperiodobjectid,
resourceobjectid,
isdaily,
status,
lastreceiveddate,
statusdate,
notes,
resourceid,
resourcename,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM TIMESHEET
/
     
prompt Creating Full View TIMESHEETPERIOD_FULL
prompt Creating Full View TIMESHEETPERIOD_FULL
--METADATA NAME:TIMESHEETPERIOD_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW TIMESHEETPERIOD_FULL
AS SELECT 
objectid,
startdate,
enddate,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM TIMESHEETPERIOD
/
     
prompt Creating Global View TIMESHEETPERIOD_U
prompt Creating Global View TIMESHEETPERIOD_U
--METADATA NAME:TIMESHEETPERIOD_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  TIMESHEETPERIOD_U
AS SELECT 
objectid,
startdate,
enddate,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM TIMESHEETPERIOD
/
     
prompt Creating Full View UDFCODE_FULL
prompt Creating Full View UDFCODE_FULL
--METADATA NAME:UDFCODE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW UDFCODE_FULL
AS SELECT 
objectid,
codetypeobjectid,
sequencenumber,
codevalue,
description,
codetypetitle,
issecurecode,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM UDFCODE
/
     
prompt Creating Project-Level View UDFCODE_U
--METADATA NAME:UDFCODE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW UDFCODE_U
AS SELECT 
t.objectid,
t.codetypeobjectid,
t.sequencenumber,
t.codevalue,
t.description,
t.codetypetitle,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM UDFCODE t
WHERE 1=1  and issecurecode='N' 
/
     
prompt Creating Project-Level View UDFCODE_S
--METADATA NAME:UDFCODE_S TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW UDFCODE_S
AS SELECT 
t.objectid,
t.codetypeobjectid,
t.sequencenumber,
t.codevalue,
t.description,
t.codetypetitle,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM UDFCODE t, GlobalSecurity gs
WHERE 1=1  and gs.RDBMSUserId = secpac.get_security_id and  ( gs.SecureCodeFlag='Y' and t.issecurecode='Y') 
/
     
prompt Creating Full View UDFTYPE_FULL
prompt Creating Full View UDFTYPE_FULL
--METADATA NAME:UDFTYPE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW UDFTYPE_FULL
AS SELECT 
objectid,
subjectarea,
title,
datatype,
issecurecode,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM UDFTYPE
/
     
prompt Creating Project-Level View UDFTYPE_U
--METADATA NAME:UDFTYPE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW UDFTYPE_U
AS SELECT 
t.objectid,
t.subjectarea,
t.title,
t.datatype,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM UDFTYPE t
WHERE 1=1  and issecurecode='N' 
/
     
prompt Creating Project-Level View UDFTYPE_S
--METADATA NAME:UDFTYPE_S TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW UDFTYPE_S
AS SELECT 
t.objectid,
t.subjectarea,
t.title,
t.datatype,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM UDFTYPE t, GlobalSecurity gs
WHERE 1=1  and gs.RDBMSUserId = secpac.get_security_id and  ( gs.SecureCodeFlag='Y' and t.issecurecode='Y') 
/
     
prompt Creating Full View UDFVALUE_FULL
prompt Creating Full View UDFVALUE_FULL
--METADATA NAME:UDFVALUE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW UDFVALUE_FULL
AS SELECT 
udftypeobjectid,
foreignobjectid,
projectobjectid,
udfdate,
udftext,
udfnumber,
udfcodeobjectid,
subjectarea,
datatype,
issecurecode,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM UDFVALUE
/
     
prompt Creating UDF View PROJECT_UDFVALUE_U
--METADATA NAME:PROJECT_UDFVALUE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECT_UDFVALUE_U
AS SELECT t.udftypeobjectid
,t.foreignobjectid
,t.projectobjectid
,t.udfdate
,t.udftext
,case when datatype = 'FT_MONEY' and costflag = 'N' then null else t.UdfNumber end UdfNumber
,t.udfcodeobjectid
,t.subjectarea
,t.datatype
,t.issecurecode
,t.lastupdateuser
,t.lastupdatedate
,t.createuser
,t.createdate
FROM udfvalue t, ProjectSecurity ps 
WHERE t.ProjectObjectId = ps.ProjectObjectId and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating view RESOURCE_UDFVALUE_U
prompt Creating UDF View RESOURCE_UDFVALUE_U
--METADATA NAME:RESOURCE_UDFVALUE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW RESOURCE_UDFVALUE_U
AS SELECT t.udftypeobjectid
,t.foreignobjectid
,t.projectobjectid
,t.udfdate
,t.udftext
,case when datatype = 'FT_MONEY' and resourcecostflag = 'N' then null else t.UdfNumber end UdfNumber
,t.udfcodeobjectid
,t.subjectarea
,t.datatype
,t.issecurecode
,t.lastupdateuser
,t.lastupdatedate
,t.createuser
,t.createdate
FROM udfvalue t, ResourceSecurity rs, GlobalSecurity gs
WHERE t.SubjectArea = 'RSRC' and t.ForeignObjectId = rs.ResourceObjectId and rs.rdbmsuserid = gs.rdbmsuserid and rs.rdbmsuserid = secpac.get_security_id
/
     
prompt Creating view GLOBAL_UDFVALUE_U
prompt Creating UDF View GLOBAL_UDFVALUE_U
--METADATA NAME:GLOBAL_UDFVALUE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW GLOBAL_UDFVALUE_U
AS SELECT t.udftypeobjectid
,t.foreignobjectid
,t.projectobjectid
,t.udfdate
,t.udftext
,t.udfnumber
,t.udfcodeobjectid
,t.subjectarea
,t.datatype
,t.issecurecode
,t.lastupdateuser
,t.lastupdatedate
,t.createuser
,t.createdate
FROM udfvalue t
WHERE ProjectobjectId is null and t.SubjectArea != 'RSRC' 

/
     
prompt Creating Full View UNITOFMEASURE_FULL
prompt Creating Full View UNITOFMEASURE_FULL
--METADATA NAME:UNITOFMEASURE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW UNITOFMEASURE_FULL
AS SELECT 
objectid,
sequencenumber,
name,
abbreviation,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM UNITOFMEASURE
/
     
prompt Creating Global View UNITOFMEASURE_U
prompt Creating Global View UNITOFMEASURE_U
--METADATA NAME:UNITOFMEASURE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  UNITOFMEASURE_U
AS SELECT 
objectid,
sequencenumber,
name,
abbreviation,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM UNITOFMEASURE
/
     
prompt Creating Full View USERMODULEACCESS_FULL
prompt Creating Full View USERMODULEACCESS_FULL
--METADATA NAME:USERMODULEACCESS_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW USERMODULEACCESS_FULL
AS SELECT 
objectid,
userobjectid,
moduletypecode,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM USERMODULEACCESS
/
     
prompt Creating Global View USERMODULEACCESS_U
prompt Creating Global View USERMODULEACCESS_U
--METADATA NAME:USERMODULEACCESS_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  USERMODULEACCESS_U
AS SELECT 
objectid,
userobjectid,
moduletypecode,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM USERMODULEACCESS
/
     
prompt Creating Full View USEROBS_FULL
prompt Creating Full View USEROBS_FULL
--METADATA NAME:USEROBS_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW USEROBS_FULL
AS SELECT 
userobjectid,
obsobjectid,
projectprofileobjectid,
obsname,
profilename,
username,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM USEROBS
/
     
prompt Creating Global View USEROBS_U
prompt Creating Global View USEROBS_U
--METADATA NAME:USEROBS_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  USEROBS_U
AS SELECT 
userobjectid,
obsobjectid,
projectprofileobjectid,
obsname,
profilename,
username,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM USEROBS
/
     
prompt Creating Full View USERPROFILEPRIVILEGE_FULL
prompt Creating Full View USERPROFILEPRIVILEGE_FULL
--METADATA NAME:USERPROFILEPRIVILEGE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW USERPROFILEPRIVILEGE_FULL
AS SELECT 
profileid,
privlegenumber,
privlegename,
allowflag,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM USERPROFILEPRIVILEGE
/
     
prompt Creating Global View USERPROFILEPRIVILEGE_U
prompt Creating Global View USERPROFILEPRIVILEGE_U
--METADATA NAME:USERPROFILEPRIVILEGE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  USERPROFILEPRIVILEGE_U
AS SELECT 
profileid,
privlegenumber,
privlegename,
allowflag,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM USERPROFILEPRIVILEGE
/
     
prompt Creating Full View USERS_FULL
prompt Creating Full View USERS_FULL
--METADATA NAME:USERS_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW USERS_FULL
AS SELECT 
objectid,
emailprotocol,
rdbmsusername,
name,
globalprofileobjectid,
currencyobjectid,
allresourceaccessflag,
issuperuser,
mailserverloginname,
officephone,
personalname,
outgoingmailserver,
emailaddress,
notificationsettings,
respectactivitydurationtype,
assignmentstaffingpreference,
currencyid,
currencyname,
financialperiodendobjectid,
financialperiodstartobjectid,
newprojectdurationtype,
ratesourcepreference,
reportingflag,
lastprojectsecuritydate,
lastresourcesecuritydate,
lastglobalsecuritydate,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM USERS
/
     
prompt Creating Global View USERS_U
prompt Creating Global View USERS_U
--METADATA NAME:USERS_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  USERS_U
AS SELECT 
objectid,
emailprotocol,
rdbmsusername,
name,
globalprofileobjectid,
currencyobjectid,
allresourceaccessflag,
issuperuser,
mailserverloginname,
officephone,
personalname,
outgoingmailserver,
emailaddress,
notificationsettings,
respectactivitydurationtype,
assignmentstaffingpreference,
currencyid,
currencyname,
financialperiodendobjectid,
financialperiodstartobjectid,
newprojectdurationtype,
ratesourcepreference,
reportingflag,
lastprojectsecuritydate,
lastresourcesecuritydate,
lastglobalsecuritydate,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM USERS
/
     
prompt Creating Full View WBS_FULL
prompt Creating Full View WBS_FULL
--METADATA NAME:WBS_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW WBS_FULL
AS SELECT 
objectid,
projectobjectid,
obsobjectid,
sequencenumber,
containssummarydata,
status,
code,
name,
wbscategoryobjectid,
parentobjectid,
earnedvalueuserpercent,
earnedvalueetcuservalue,
originalbudget,
independentetctotalcost,
independentetclaborunits,
anticipatedstartdate,
anticipatedfinishdate,
earnedvaluecomputetype,
earnedvalueetccomputetype,
projectnodeflag,
currentbudget,
currentvariance,
distributedcurrentbudget,
finishdate,
forecastfinishdate,
forecaststartdate,
fullname,
fullsequence,
obsname,
projectid,
proposedbudget,
startdate,
sumplannedstartdate,
sumplannedfinishdate,
sumplannedduration,
sumplannedlaborunits,
sumplannednonlaborunits,
sumplannedexpensecost,
sumplannedlaborcost,
sumplannedmaterialcost,
sumplannednonlaborcost,
sumplannedtotalcost,
sumaccountingvarbylaborunits,
sumaccountingvariancebycost,
sumactthisperiodmaterialcost,
sumactthisperiodnonlaborcost,
sumactthisperiodnonlaborunits,
sumactualthisperiodlaborcost,
sumactualthisperiodlaborunits,
sumatcompletionmaterialcost,
sumatcompletionnonlaborcost,
sumatcompletionnonlaborunits,
sumatcompletiontotalcostvar,
sumbaselinecompactivitycount,
sumbaselinenotstartedactcnt,
sumblinprogressactivitycount,
sumbudgetatcmpbylaborunits,
sumbudgetatcompletionbycost,
sumcostperfindexbycost,
sumcostperfindexbylaborunits,
sumcostvariancebylaborunits,
sumcostvarindexbylaborunits,
sumdurationpercentofplanned,
sumeacbycost,
sumeacbylaborunits,
sumeachighpctbylaborunits,
sumeaclowpctbylaborunits,
sumetcbycost,
sumetcbylaborunits,
sumexpensecostpctcomplete,
sumlaborcostpercentcomplete,
sumlaborunitspercentcomplete,
sumactivitycount,
sumactualduration,
sumactualexpensecost,
sumactualfinishdate,
summaxactualfinishdate,
summaxrestartdate,
sumactuallaborcost,
sumactuallaborunits,
sumactualmaterialcost,
sumactualnonlaborcost,
sumactualnonlaborunits,
sumactualstartdate,
sumactualthisperiodcost,
sumactualtotalcost,
sumactualvaluebycost,
sumactualvaluebylaborunits,
sumatcompletionduration,
sumatcompletionexpensecost,
sumatcompletionlaborcost,
sumatcompletionlaborunits,
sumatcompletiontotalcost,
sumbaselineduration,
sumbaselineexpensecost,
sumbaselinefinishdate,
sumbaselinelaborcost,
sumbaselinelaborunits,
sumbaselinematerialcost,
sumbaselinenonlaborcost,
sumbaselinenonlaborunits,
sumbaselinestartdate,
sumbaselinetotalcost,
sumcompletedactivitycount,
sumcostpercentcomplete,
sumcostpercentofplanned,
sumcostvariancebycost,
sumcostvarianceindex,
sumcostvarianceindexbycost,
sumdurationpercentcomplete,
sumdurationvariance,
sumearnedvaluebycost,
sumearnedvaluebylaborunits,
sumexpensecostvariance,
sumfinishdatevariance,
suminprogressactivitycount,
sumlaborcostvariance,
sumlaborunitsvariance,
summaterialcostvariance,
sumnonlaborcostvariance,
sumnonlaborunitsvariance,
sumnotstartedactivitycount,
sumplannedvaluebycost,
sumprogressfinishdate,
sumremainingduration,
sumremainingexpensecost,
sumremainingfinishdate,
sumremaininglaborcost,
sumremaininglaborunits,
sumremainingmaterialcost,
sumremainingnonlaborcost,
sumremainingnonlaborunits,
sumremainingstartdate,
sumremainingtotalcost,
sumschedulepercentcomplete,
sumperformancepercentcomplete,
sumschedulevariancebycost,
sumschedulevarianceindex,
sumstartdatevariance,
sumtotalcostvariance,
sumtotalfloat,
sumunitspercentcomplete,
summaterialcostpctcomplete,
sumnonlaborcostpctcomplete,
sumnonlaborunitspctcomplete,
sumperfpctcmpbylaborunits,
sumplannedvaluebylaborunits,
sumschdpctcmpbylaborunits,
sumschdperfindexbylaborunits,
sumschdvariancebylaborunits,
sumschdvarianceindexbycost,
sumschdvarindexbylaborunits,
sumscheduleperfindexbycost,
sumtocompleteperfindexbycost,
sumvaratcmpbylaborunits,
sumearlystartdate,
sumearlyenddate,
sumlatestartdate,
sumlateenddate,
summaxcalendarid,
summincalendarid,
totalbenefitplan,
totalbenefitplantally,
totalspendingplan,
totalspendingplantally,
unallocatedbudget,
undistributedcurrentvariance,
statusreviewerobjectid,
statusreviewername,
lastupdateuser,
lastupdatedate,
createuser,
createdate,
lastupdatedatex 
,RPT_CURRENT_FLAG
FROM WBS
/
     
prompt Creating Project-Level View WBS_U
--METADATA NAME:WBS_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW WBS_U
AS SELECT 
t.objectid,
t.projectobjectid,
t.obsobjectid,
t.sequencenumber,
t.containssummarydata,
t.status,
t.code,
t.name,
t.wbscategoryobjectid,
t.parentobjectid,
t.earnedvalueuserpercent,
t.earnedvalueetcuservalue,
CASE CostFlag WHEN 'Y' THEN t.originalbudget ELSE null END originalbudget,
CASE CostFlag WHEN 'Y' THEN t.independentetctotalcost ELSE null END independentetctotalcost,
t.independentetclaborunits,
t.anticipatedstartdate,
t.anticipatedfinishdate,
t.earnedvaluecomputetype,
t.earnedvalueetccomputetype,
t.projectnodeflag,
CASE CostFlag WHEN 'Y' THEN t.currentbudget ELSE null END currentbudget,
CASE CostFlag WHEN 'Y' THEN t.currentvariance ELSE null END currentvariance,
CASE CostFlag WHEN 'Y' THEN t.distributedcurrentbudget ELSE null END distributedcurrentbudget,
t.finishdate,
t.forecastfinishdate,
t.forecaststartdate,
t.fullname,
t.fullsequence,
t.obsname,
t.projectid,
CASE CostFlag WHEN 'Y' THEN t.proposedbudget ELSE null END proposedbudget,
t.startdate,
t.sumplannedstartdate,
t.sumplannedfinishdate,
t.sumplannedduration,
t.sumplannedlaborunits,
t.sumplannednonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumplannedexpensecost ELSE null END sumplannedexpensecost,
CASE CostFlag WHEN 'Y' THEN t.sumplannedlaborcost ELSE null END sumplannedlaborcost,
CASE CostFlag WHEN 'Y' THEN t.sumplannedmaterialcost ELSE null END sumplannedmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumplannednonlaborcost ELSE null END sumplannednonlaborcost,
CASE CostFlag WHEN 'Y' THEN t.sumplannedtotalcost ELSE null END sumplannedtotalcost,
t.sumaccountingvarbylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumaccountingvariancebycost ELSE null END sumaccountingvariancebycost,
CASE CostFlag WHEN 'Y' THEN t.sumactthisperiodmaterialcost ELSE null END sumactthisperiodmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumactthisperiodnonlaborcost ELSE null END sumactthisperiodnonlaborcost,
t.sumactthisperiodnonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumactualthisperiodlaborcost ELSE null END sumactualthisperiodlaborcost,
t.sumactualthisperiodlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionmaterialcost ELSE null END sumatcompletionmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionnonlaborcost ELSE null END sumatcompletionnonlaborcost,
t.sumatcompletionnonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletiontotalcostvar ELSE null END sumatcompletiontotalcostvar,
t.sumbaselinecompactivitycount,
t.sumbaselinenotstartedactcnt,
t.sumblinprogressactivitycount,
t.sumbudgetatcmpbylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumbudgetatcompletionbycost ELSE null END sumbudgetatcompletionbycost,
t.sumcostperfindexbycost,
t.sumcostperfindexbylaborunits,
t.sumcostvariancebylaborunits,
t.sumcostvarindexbylaborunits,
t.sumdurationpercentofplanned,
CASE CostFlag WHEN 'Y' THEN t.sumeacbycost ELSE null END sumeacbycost,
t.sumeacbylaborunits,
t.sumeachighpctbylaborunits,
t.sumeaclowpctbylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumetcbycost ELSE null END sumetcbycost,
t.sumetcbylaborunits,
t.sumexpensecostpctcomplete,
t.sumlaborcostpercentcomplete,
t.sumlaborunitspercentcomplete,
t.sumactivitycount,
t.sumactualduration,
CASE CostFlag WHEN 'Y' THEN t.sumactualexpensecost ELSE null END sumactualexpensecost,
t.sumactualfinishdate,
t.summaxactualfinishdate,
t.summaxrestartdate,
CASE CostFlag WHEN 'Y' THEN t.sumactuallaborcost ELSE null END sumactuallaborcost,
t.sumactuallaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumactualmaterialcost ELSE null END sumactualmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumactualnonlaborcost ELSE null END sumactualnonlaborcost,
t.sumactualnonlaborunits,
t.sumactualstartdate,
CASE CostFlag WHEN 'Y' THEN t.sumactualthisperiodcost ELSE null END sumactualthisperiodcost,
CASE CostFlag WHEN 'Y' THEN t.sumactualtotalcost ELSE null END sumactualtotalcost,
CASE CostFlag WHEN 'Y' THEN t.sumactualvaluebycost ELSE null END sumactualvaluebycost,
t.sumactualvaluebylaborunits,
t.sumatcompletionduration,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionexpensecost ELSE null END sumatcompletionexpensecost,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionlaborcost ELSE null END sumatcompletionlaborcost,
t.sumatcompletionlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletiontotalcost ELSE null END sumatcompletiontotalcost,
t.sumbaselineduration,
CASE CostFlag WHEN 'Y' THEN t.sumbaselineexpensecost ELSE null END sumbaselineexpensecost,
t.sumbaselinefinishdate,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinelaborcost ELSE null END sumbaselinelaborcost,
t.sumbaselinelaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinematerialcost ELSE null END sumbaselinematerialcost,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinenonlaborcost ELSE null END sumbaselinenonlaborcost,
t.sumbaselinenonlaborunits,
t.sumbaselinestartdate,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinetotalcost ELSE null END sumbaselinetotalcost,
t.sumcompletedactivitycount,
t.sumcostpercentcomplete,
t.sumcostpercentofplanned,
CASE CostFlag WHEN 'Y' THEN t.sumcostvariancebycost ELSE null END sumcostvariancebycost,
t.sumcostvarianceindex,
CASE CostFlag WHEN 'Y' THEN t.sumcostvarianceindexbycost ELSE null END sumcostvarianceindexbycost,
t.sumdurationpercentcomplete,
t.sumdurationvariance,
CASE CostFlag WHEN 'Y' THEN t.sumearnedvaluebycost ELSE null END sumearnedvaluebycost,
t.sumearnedvaluebylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumexpensecostvariance ELSE null END sumexpensecostvariance,
t.sumfinishdatevariance,
t.suminprogressactivitycount,
CASE CostFlag WHEN 'Y' THEN t.sumlaborcostvariance ELSE null END sumlaborcostvariance,
t.sumlaborunitsvariance,
CASE CostFlag WHEN 'Y' THEN t.summaterialcostvariance ELSE null END summaterialcostvariance,
CASE CostFlag WHEN 'Y' THEN t.sumnonlaborcostvariance ELSE null END sumnonlaborcostvariance,
t.sumnonlaborunitsvariance,
t.sumnotstartedactivitycount,
CASE CostFlag WHEN 'Y' THEN t.sumplannedvaluebycost ELSE null END sumplannedvaluebycost,
t.sumprogressfinishdate,
t.sumremainingduration,
CASE CostFlag WHEN 'Y' THEN t.sumremainingexpensecost ELSE null END sumremainingexpensecost,
t.sumremainingfinishdate,
CASE CostFlag WHEN 'Y' THEN t.sumremaininglaborcost ELSE null END sumremaininglaborcost,
t.sumremaininglaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumremainingmaterialcost ELSE null END sumremainingmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumremainingnonlaborcost ELSE null END sumremainingnonlaborcost,
t.sumremainingnonlaborunits,
t.sumremainingstartdate,
CASE CostFlag WHEN 'Y' THEN t.sumremainingtotalcost ELSE null END sumremainingtotalcost,
t.sumschedulepercentcomplete,
t.sumperformancepercentcomplete,
CASE CostFlag WHEN 'Y' THEN t.sumschedulevariancebycost ELSE null END sumschedulevariancebycost,
t.sumschedulevarianceindex,
t.sumstartdatevariance,
CASE CostFlag WHEN 'Y' THEN t.sumtotalcostvariance ELSE null END sumtotalcostvariance,
t.sumtotalfloat,
t.sumunitspercentcomplete,
t.summaterialcostpctcomplete,
t.sumnonlaborcostpctcomplete,
t.sumnonlaborunitspctcomplete,
t.sumperfpctcmpbylaborunits,
t.sumplannedvaluebylaborunits,
t.sumschdpctcmpbylaborunits,
t.sumschdperfindexbylaborunits,
t.sumschdvariancebylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumschdvarianceindexbycost ELSE null END sumschdvarianceindexbycost,
t.sumschdvarindexbylaborunits,
t.sumscheduleperfindexbycost,
t.sumtocompleteperfindexbycost,
t.sumvaratcmpbylaborunits,
t.sumearlystartdate,
t.sumearlyenddate,
t.sumlatestartdate,
t.sumlateenddate,
t.summaxcalendarid,
t.summincalendarid,
CASE CostFlag WHEN 'Y' THEN t.totalbenefitplan ELSE null END totalbenefitplan,
CASE CostFlag WHEN 'Y' THEN t.totalbenefitplantally ELSE null END totalbenefitplantally,
CASE CostFlag WHEN 'Y' THEN t.totalspendingplan ELSE null END totalspendingplan,
CASE CostFlag WHEN 'Y' THEN t.totalspendingplantally ELSE null END totalspendingplantally,
CASE CostFlag WHEN 'Y' THEN t.unallocatedbudget ELSE null END unallocatedbudget,
CASE CostFlag WHEN 'Y' THEN t.undistributedcurrentvariance ELSE null END undistributedcurrentvariance,
t.statusreviewerobjectid,
t.statusreviewername,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate,
t.lastupdatedatex 
,RPT_CURRENT_FLAG
FROM WBS t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
-- START BASELINE VIEW of WBS_U
prompt Creating Project-Level View BLWBS_U
--METADATA NAME:BLWBS_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW BLWBS_U
AS SELECT 
t.objectid,
t.projectobjectid,
t.obsobjectid,
t.sequencenumber,
t.containssummarydata,
t.status,
t.code,
t.name,
t.wbscategoryobjectid,
t.parentobjectid,
t.earnedvalueuserpercent,
t.earnedvalueetcuservalue,
CASE CostFlag WHEN 'Y' THEN t.originalbudget ELSE null END originalbudget,
CASE CostFlag WHEN 'Y' THEN t.independentetctotalcost ELSE null END independentetctotalcost,
t.independentetclaborunits,
t.anticipatedstartdate,
t.anticipatedfinishdate,
t.earnedvaluecomputetype,
t.earnedvalueetccomputetype,
t.projectnodeflag,
CASE CostFlag WHEN 'Y' THEN t.currentbudget ELSE null END currentbudget,
CASE CostFlag WHEN 'Y' THEN t.currentvariance ELSE null END currentvariance,
CASE CostFlag WHEN 'Y' THEN t.distributedcurrentbudget ELSE null END distributedcurrentbudget,
t.finishdate,
t.forecastfinishdate,
t.forecaststartdate,
t.fullname,
t.fullsequence,
t.obsname,
t.projectid,
CASE CostFlag WHEN 'Y' THEN t.proposedbudget ELSE null END proposedbudget,
t.startdate,
t.sumplannedstartdate,
t.sumplannedfinishdate,
t.sumplannedduration,
t.sumplannedlaborunits,
t.sumplannednonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumplannedexpensecost ELSE null END sumplannedexpensecost,
CASE CostFlag WHEN 'Y' THEN t.sumplannedlaborcost ELSE null END sumplannedlaborcost,
CASE CostFlag WHEN 'Y' THEN t.sumplannedmaterialcost ELSE null END sumplannedmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumplannednonlaborcost ELSE null END sumplannednonlaborcost,
CASE CostFlag WHEN 'Y' THEN t.sumplannedtotalcost ELSE null END sumplannedtotalcost,
t.sumaccountingvarbylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumaccountingvariancebycost ELSE null END sumaccountingvariancebycost,
CASE CostFlag WHEN 'Y' THEN t.sumactthisperiodmaterialcost ELSE null END sumactthisperiodmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumactthisperiodnonlaborcost ELSE null END sumactthisperiodnonlaborcost,
t.sumactthisperiodnonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumactualthisperiodlaborcost ELSE null END sumactualthisperiodlaborcost,
t.sumactualthisperiodlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionmaterialcost ELSE null END sumatcompletionmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionnonlaborcost ELSE null END sumatcompletionnonlaborcost,
t.sumatcompletionnonlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletiontotalcostvar ELSE null END sumatcompletiontotalcostvar,
t.sumbaselinecompactivitycount,
t.sumbaselinenotstartedactcnt,
t.sumblinprogressactivitycount,
t.sumbudgetatcmpbylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumbudgetatcompletionbycost ELSE null END sumbudgetatcompletionbycost,
t.sumcostperfindexbycost,
t.sumcostperfindexbylaborunits,
t.sumcostvariancebylaborunits,
t.sumcostvarindexbylaborunits,
t.sumdurationpercentofplanned,
CASE CostFlag WHEN 'Y' THEN t.sumeacbycost ELSE null END sumeacbycost,
t.sumeacbylaborunits,
t.sumeachighpctbylaborunits,
t.sumeaclowpctbylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumetcbycost ELSE null END sumetcbycost,
t.sumetcbylaborunits,
t.sumexpensecostpctcomplete,
t.sumlaborcostpercentcomplete,
t.sumlaborunitspercentcomplete,
t.sumactivitycount,
t.sumactualduration,
CASE CostFlag WHEN 'Y' THEN t.sumactualexpensecost ELSE null END sumactualexpensecost,
t.sumactualfinishdate,
t.summaxactualfinishdate,
t.summaxrestartdate,
CASE CostFlag WHEN 'Y' THEN t.sumactuallaborcost ELSE null END sumactuallaborcost,
t.sumactuallaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumactualmaterialcost ELSE null END sumactualmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumactualnonlaborcost ELSE null END sumactualnonlaborcost,
t.sumactualnonlaborunits,
t.sumactualstartdate,
CASE CostFlag WHEN 'Y' THEN t.sumactualthisperiodcost ELSE null END sumactualthisperiodcost,
CASE CostFlag WHEN 'Y' THEN t.sumactualtotalcost ELSE null END sumactualtotalcost,
CASE CostFlag WHEN 'Y' THEN t.sumactualvaluebycost ELSE null END sumactualvaluebycost,
t.sumactualvaluebylaborunits,
t.sumatcompletionduration,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionexpensecost ELSE null END sumatcompletionexpensecost,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletionlaborcost ELSE null END sumatcompletionlaborcost,
t.sumatcompletionlaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumatcompletiontotalcost ELSE null END sumatcompletiontotalcost,
t.sumbaselineduration,
CASE CostFlag WHEN 'Y' THEN t.sumbaselineexpensecost ELSE null END sumbaselineexpensecost,
t.sumbaselinefinishdate,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinelaborcost ELSE null END sumbaselinelaborcost,
t.sumbaselinelaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinematerialcost ELSE null END sumbaselinematerialcost,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinenonlaborcost ELSE null END sumbaselinenonlaborcost,
t.sumbaselinenonlaborunits,
t.sumbaselinestartdate,
CASE CostFlag WHEN 'Y' THEN t.sumbaselinetotalcost ELSE null END sumbaselinetotalcost,
t.sumcompletedactivitycount,
t.sumcostpercentcomplete,
t.sumcostpercentofplanned,
CASE CostFlag WHEN 'Y' THEN t.sumcostvariancebycost ELSE null END sumcostvariancebycost,
t.sumcostvarianceindex,
CASE CostFlag WHEN 'Y' THEN t.sumcostvarianceindexbycost ELSE null END sumcostvarianceindexbycost,
t.sumdurationpercentcomplete,
t.sumdurationvariance,
CASE CostFlag WHEN 'Y' THEN t.sumearnedvaluebycost ELSE null END sumearnedvaluebycost,
t.sumearnedvaluebylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumexpensecostvariance ELSE null END sumexpensecostvariance,
t.sumfinishdatevariance,
t.suminprogressactivitycount,
CASE CostFlag WHEN 'Y' THEN t.sumlaborcostvariance ELSE null END sumlaborcostvariance,
t.sumlaborunitsvariance,
CASE CostFlag WHEN 'Y' THEN t.summaterialcostvariance ELSE null END summaterialcostvariance,
CASE CostFlag WHEN 'Y' THEN t.sumnonlaborcostvariance ELSE null END sumnonlaborcostvariance,
t.sumnonlaborunitsvariance,
t.sumnotstartedactivitycount,
CASE CostFlag WHEN 'Y' THEN t.sumplannedvaluebycost ELSE null END sumplannedvaluebycost,
t.sumprogressfinishdate,
t.sumremainingduration,
CASE CostFlag WHEN 'Y' THEN t.sumremainingexpensecost ELSE null END sumremainingexpensecost,
t.sumremainingfinishdate,
CASE CostFlag WHEN 'Y' THEN t.sumremaininglaborcost ELSE null END sumremaininglaborcost,
t.sumremaininglaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumremainingmaterialcost ELSE null END sumremainingmaterialcost,
CASE CostFlag WHEN 'Y' THEN t.sumremainingnonlaborcost ELSE null END sumremainingnonlaborcost,
t.sumremainingnonlaborunits,
t.sumremainingstartdate,
CASE CostFlag WHEN 'Y' THEN t.sumremainingtotalcost ELSE null END sumremainingtotalcost,
t.sumschedulepercentcomplete,
t.sumperformancepercentcomplete,
CASE CostFlag WHEN 'Y' THEN t.sumschedulevariancebycost ELSE null END sumschedulevariancebycost,
t.sumschedulevarianceindex,
t.sumstartdatevariance,
CASE CostFlag WHEN 'Y' THEN t.sumtotalcostvariance ELSE null END sumtotalcostvariance,
t.sumtotalfloat,
t.sumunitspercentcomplete,
t.summaterialcostpctcomplete,
t.sumnonlaborcostpctcomplete,
t.sumnonlaborunitspctcomplete,
t.sumperfpctcmpbylaborunits,
t.sumplannedvaluebylaborunits,
t.sumschdpctcmpbylaborunits,
t.sumschdperfindexbylaborunits,
t.sumschdvariancebylaborunits,
CASE CostFlag WHEN 'Y' THEN t.sumschdvarianceindexbycost ELSE null END sumschdvarianceindexbycost,
t.sumschdvarindexbylaborunits,
t.sumscheduleperfindexbycost,
t.sumtocompleteperfindexbycost,
t.sumvaratcmpbylaborunits,
t.sumearlystartdate,
t.sumearlyenddate,
t.sumlatestartdate,
t.sumlateenddate,
t.summaxcalendarid,
t.summincalendarid,
CASE CostFlag WHEN 'Y' THEN t.totalbenefitplan ELSE null END totalbenefitplan,
CASE CostFlag WHEN 'Y' THEN t.totalbenefitplantally ELSE null END totalbenefitplantally,
CASE CostFlag WHEN 'Y' THEN t.totalspendingplan ELSE null END totalspendingplan,
CASE CostFlag WHEN 'Y' THEN t.totalspendingplantally ELSE null END totalspendingplantally,
CASE CostFlag WHEN 'Y' THEN t.unallocatedbudget ELSE null END unallocatedbudget,
CASE CostFlag WHEN 'Y' THEN t.undistributedcurrentvariance ELSE null END undistributedcurrentvariance,
t.statusreviewerobjectid,
t.statusreviewername,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate,
t.lastupdatedatex
FROM BLWBS t
LEFT OUTER JOIN Baseline b ON t.projectobjectid = b.ObjectId
LEFT OUTER JOIN ProjectSecurity ps ON b.OriginalProjectObjectId = ps.ProjectObjectId
-- At b
WHERE 1=1  and ps.RDBMSUserId = secpac.get_security_id and b.objectid = t.projectobjectid
    
/
     
-- FINISH BASELINE VIEW of WBS_U
prompt Creating Full View WBSCATEGORY_FULL
prompt Creating Full View WBSCATEGORY_FULL
--METADATA NAME:WBSCATEGORY_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW WBSCATEGORY_FULL
AS SELECT 
objectid,
sequencenumber,
name,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM WBSCATEGORY
/
     
prompt Creating Global View WBSCATEGORY_U
prompt Creating Global View WBSCATEGORY_U
--METADATA NAME:WBSCATEGORY_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  WBSCATEGORY_U
AS SELECT 
objectid,
sequencenumber,
name,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM WBSCATEGORY
/
     
prompt Creating Full View WBSMILESTONE_FULL
prompt Creating Full View WBSMILESTONE_FULL
--METADATA NAME:WBSMILESTONE_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW WBSMILESTONE_FULL
AS SELECT 
objectid,
projectobjectid,
wbsobjectid,
sequencenumber,
iscompleted,
name,
weight,
projectid,
wbscode,
wbsname,
lastupdateuser,
lastupdatedate,
createuser,
createdate
FROM WBSMILESTONE
/
     
prompt Creating Project-Level View WBSMILESTONE_U
--METADATA NAME:WBSMILESTONE_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW WBSMILESTONE_U
AS SELECT 
t.objectid,
t.projectobjectid,
t.wbsobjectid,
t.sequencenumber,
t.iscompleted,
t.name,
t.weight,
t.projectid,
t.wbscode,
t.wbsname,
t.lastupdateuser,
t.lastupdatedate,
t.createuser,
t.createdate
FROM WBSMILESTONE t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View WBSSPREAD_FULL
prompt Creating Full View WBSSPREAD_FULL
--METADATA NAME:WBSSPREAD_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW WBSSPREAD_FULL
AS SELECT 
ObjectId,
ParentObjectId,
Code,
Name,
projectobjectid,
ObsObjectId,
ObsName,
StartDate,
EndDate,
ActualLaborUnits,
ActualNonlaborUnits,
AtCompletionLaborUnits,
AtCompletionNonlaborUnits,
BaselinePlannedLaborUnits,
BaselinePlannedNonlaborUnits,
EarnedValueLaborUnits,
EstimateAtCompletionLaborUnits,
EstimateToCompleteLaborUnits,
PlannedLaborUnits,
PlannedNonlaborUnits,
PlannedValueLaborUnits,
RemainingLaborUnits,
RemainingNonlaborUnits,
ActualCost,
ActualExpenseCost,
ActualLaborCost,
ActualMaterialCost,
ActualNonlaborCost,
ActualTotalCost,
AtCompletionExpenseCost,
AtCompletionLaborCost,
AtCompletionMaterialCost,
AtCompletionNonlaborCost,
AtCompletionTotalCost,
BaselinePlannedExpenseCost,
BaselinePlannedLaborCost,
BaselinePlannedMaterialCost,
BaselinePlannedNonlaborCost,
BaselinePlannedTotalCost,
EarnedValueCost,
EstimateAtCompletionCost,
EstimateToCompleteCost,
PlannedExpenseCost,
PlannedLaborCost,
PlannedMaterialCost,
PlannedNonlaborCost,
PlannedTotalCost,
PlannedValueCost,
RemainingExpenseCost,
RemainingLaborCost,
RemainingMaterialCost,
RemainingNonlaborCost,
RemainingTotalCost
FROM WBSSPREAD
/
     
prompt Creating Project-Level View WBSSPREAD_U
--METADATA NAME:WBSSPREAD_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW WBSSPREAD_U
AS SELECT 
t.ObjectId,
t.ParentObjectId,
t.Code,
t.Name,
t.projectobjectid,
t.ObsObjectId,
t.ObsName,
t.StartDate,
t.EndDate,
t.ActualLaborUnits,
t.ActualNonlaborUnits,
t.AtCompletionLaborUnits,
t.AtCompletionNonlaborUnits,
t.BaselinePlannedLaborUnits,
t.BaselinePlannedNonlaborUnits,
t.EarnedValueLaborUnits,
t.EstimateAtCompletionLaborUnits,
t.EstimateToCompleteLaborUnits,
t.PlannedLaborUnits,
t.PlannedNonlaborUnits,
t.PlannedValueLaborUnits,
t.RemainingLaborUnits,
t.RemainingNonlaborUnits,
CASE CostFlag WHEN 'Y' THEN t.ActualCost ELSE null END ActualCost,
CASE CostFlag WHEN 'Y' THEN t.ActualExpenseCost ELSE null END ActualExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.ActualLaborCost ELSE null END ActualLaborCost,
CASE CostFlag WHEN 'Y' THEN t.ActualMaterialCost ELSE null END ActualMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.ActualNonlaborCost ELSE null END ActualNonlaborCost,
CASE CostFlag WHEN 'Y' THEN t.ActualTotalCost ELSE null END ActualTotalCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionExpenseCost ELSE null END AtCompletionExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionLaborCost ELSE null END AtCompletionLaborCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionMaterialCost ELSE null END AtCompletionMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionNonlaborCost ELSE null END AtCompletionNonlaborCost,
CASE CostFlag WHEN 'Y' THEN t.AtCompletionTotalCost ELSE null END AtCompletionTotalCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedExpenseCost ELSE null END BaselinePlannedExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedLaborCost ELSE null END BaselinePlannedLaborCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedMaterialCost ELSE null END BaselinePlannedMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedNonlaborCost ELSE null END BaselinePlannedNonlaborCost,
CASE CostFlag WHEN 'Y' THEN t.BaselinePlannedTotalCost ELSE null END BaselinePlannedTotalCost,
CASE CostFlag WHEN 'Y' THEN t.EarnedValueCost ELSE null END EarnedValueCost,
CASE CostFlag WHEN 'Y' THEN t.EstimateAtCompletionCost ELSE null END EstimateAtCompletionCost,
CASE CostFlag WHEN 'Y' THEN t.EstimateToCompleteCost ELSE null END EstimateToCompleteCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedExpenseCost ELSE null END PlannedExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedLaborCost ELSE null END PlannedLaborCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedMaterialCost ELSE null END PlannedMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedNonlaborCost ELSE null END PlannedNonlaborCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedTotalCost ELSE null END PlannedTotalCost,
CASE CostFlag WHEN 'Y' THEN t.PlannedValueCost ELSE null END PlannedValueCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingExpenseCost ELSE null END RemainingExpenseCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingLaborCost ELSE null END RemainingLaborCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingMaterialCost ELSE null END RemainingMaterialCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingNonlaborCost ELSE null END RemainingNonlaborCost,
CASE CostFlag WHEN 'Y' THEN t.RemainingTotalCost ELSE null END RemainingTotalCost
FROM WBSSPREAD t, ProjectSecurity ps
WHERE 1=1  and t.projectobjectid = ps.ProjectObjectId  and ps.RDBMSUserId = secpac.get_security_id
/
     
prompt Creating Full View PROJECTETLLIST_FULL
prompt Creating Full View PROJECTETLLIST_FULL
--METADATA NAME:PROJECTETLLIST_FULL TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW PROJECTETLLIST_FULL
AS SELECT 
OBJECTID,
PROJECTOBJECTID,
LASTUPDATEDATE
FROM PROJECTETLLIST
/
     
prompt Creating Global View PROJECTETLLIST_U
prompt Creating Global View PROJECTETLLIST_U
--METADATA NAME:PROJECTETLLIST_U TYPE:VIEW SET:RPT_SEC_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW  PROJECTETLLIST_U
AS SELECT 
OBJECTID,
PROJECTOBJECTID,
LASTUPDATEDATE
FROM PROJECTETLLIST
/
     
--METADATA NAME:CBS TYPE:VIEW SET:CBS DATA  CHANGE:Lookup view for cbs
CREATE OR REPLACE VIEW CBS AS
SELECT  A.cbs_id objectid,A.proj_id projectobjectid,A.cbs_code code,  A.description name,A.parent_cbs_id parentobjectid,A.status status,
A.update_user lastupdateuser,A.update_date lastupdatedate,A.create_user createuser,A.create_date createdate,P.update_dim_date lastupdatedatex
 FROM ${pm.or.administrative_user}.CBS A INNER JOIN ${pm.or.administrative_user}.PROJECTX P ON a.proj_id = p.proj_id
INNER JOIN ${pm.or.administrative_user}.PROJECT projects_tab ON a.proj_id = projects_tab.proj_id
WHERE A.DELETE_SESSION_ID is null AND projects_tab.PROJECT_FLAG = 'Y'
/
--METADATA NAME:ETLFILTER TYPE:VIEW SET:ETLFILTER DATA  CHANGE:List of project object ids
CREATE OR REPLACE VIEW ETLFILTER (objectid) AS
select projectobjectid from projectcodeassignment
where projectcodetypeobjectid =(select objectid from projectcodetype where UPPER(name) = 'ETLFILTER') and projectobjectid in (select objectid from project)
/
--CONNECT USERNAME:pxrptuser
	 
set scan off
     
prompt creating view BASELINE

--METADATA NAME:BASELINE TYPE:VIEW SET:RPT_BASE_VIEWS CHANGE:CREATE
CREATE OR REPLACE VIEW BASELINE_U
AS SELECT  baseline.objectid
, baseline.id
, baseline.fiscalyearstartmonth
, baseline.resourcescaneditasgnmtpctcmp
, baseline.resourcescanselfassigntoacts
, baseline.primaryrescanmarkactsascmp
, baseline.resourcecanassigntosameact
, baseline.checkoutstatus
, baseline.activitypctcmpbasedonsteps
, baseline.costquantityrecalculateflag
, baseline.containssummarydataonly
, baseline.enablesummarization
, baseline.wbscodeseparator
, baseline.activitydefaultpctcmptype
, baseline.activitydefcostacctobjectid
, baseline.activitydefcalendarobjectid
, baseline.currentbaselineprojectobjectid
, baseline.activityidsuffix
, baseline.activityidincrement
, baseline.levelingpriority
, baseline.summarizetowbslevel
, baseline.strategicpriority
, baseline.criticalactivityfloatlimit
, baseline.activitydefaultpriceperunit
, baseline.plannedstartdate
, baseline.mustfinishbydate
, baseline.scheduledfinishdate
, baseline.dateadded
, baseline.summarizeddatadate
, baseline.lastsummarizeddate
, baseline.projectforecaststartdate
, baseline.activitydefaultdurationtype
, baseline.activityidprefix
, baseline.defaultpricetimeunits
, baseline.addedby
, baseline.websiterootdirectory
, baseline.websiteurl
, baseline.assignmentdefaultratetype
, baseline.linkactualtoactualthisperiod
, baseline.activitydefaultactivitytype
, baseline.linkpercentcompletewithactual
, baseline.addactualtoremaining
, baseline.criticalactivitypathtype
, baseline.activityidbasedonselactivity
, baseline.assignmentdefaultdrivingflag
, baseline.linkplannedandatcompletionflag
, baseline.resetplannedtoremainingflag
, baseline.allownegativeactualunitsflag
, baseline.ownerresourceobjectid
, baseline.checkoutdate
, baseline.checkoutuserobjectid
, baseline.lastfinancialperiodobjectid
, baseline.useprojectblforearnedvalue
, baseline.originalprojectobjectid
, baseline.riskscorematrixobjectid
, baseline.projectdescription
, baseline.baselinetypeobjectid
, baseline.enablepublication
, baseline.nextpublicationdate
, baseline.lastpublishedon
, baseline.publicationpriority
, baseline.locationobjectid
, baseline.historyinterval
, baseline.historylevel
, baseline.allowstatusreview
, baseline.lastupdateuser
, baseline.lastupdatedate
, baseline.createuser
, baseline.etlinterval
, baseline.etlhour
, baseline.createdate
, parentprojectid
, name
FROM BASELINE, projectsecurity ps
WHERE 1=1 and ps.projectobjectid = baseline.originalprojectobjectid and ps.RDBMSUserId = secpac.get_security_id
/
     

--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RESOURCEASSIGNMENTSPREAD FOR RESOURCEASSIGNMENTSPREAD_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RESOURCELIMIT FOR RESOURCELIMIT_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6ACTIVITYSPREAD FOR ACTIVITYSPREAD_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6ACTIVITY FOR ACTIVITY_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6BLACTIVITY FOR BLACTIVITY_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6ACTIVITYCODE FOR ACTIVITYCODE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6ACTIVITYCODE_S FOR ACTIVITYCODE_S
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6ACTIVITYCODEASSIGNMENT FOR ACTIVITYCODEASSIGNMENT_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6ACTIVITYCODEASSIGNMENT_S FOR ACTIVITYCODEASSIGNMENT_S
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6ACTIVITYCODEHIERARCHY FOR ACTIVITYCODEHIERARCHY_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6ACTIVITYCODEHIERARCHY_S FOR ACTIVITYCODEHIERARCHY_S
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6ACTIVITYCODETYPE FOR ACTIVITYCODETYPE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6ACTIVITYCODETYPE_S FOR ACTIVITYCODETYPE_S
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6ACTIVITYEXPENSE FOR ACTIVITYEXPENSE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6ACTIVITYNOTE FOR ACTIVITYNOTE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6ACTIVITYPERIODACTUAL FOR ACTIVITYPERIODACTUAL_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6ACTIVITYRISK FOR ACTIVITYRISK_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6ACTIVITYSTEP FOR ACTIVITYSTEP_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6BASELINETYPE FOR BASELINETYPE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6CALENDAR FOR CALENDAR_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6CHANGESET FOR CHANGESET_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6ACTIVITYUPDATE FOR ACTIVITYUPDATE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6ACTIVITYSTEPUPDATE FOR ACTIVITYSTEPUPDATE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6ACTIVITYSTEPCREATE FOR ACTIVITYSTEPCREATE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6ACTIVITYSTEPDEL FOR ACTIVITYSTEPDEL_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6ACTIVITYCOMMENT FOR ACTIVITYCOMMENT_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6ACTIVITYCODEUPDATE FOR ACTIVITYCODEUPDATE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6USERDEFINEDVALUEUPDATE FOR USERDEFINEDVALUEUPDATE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RESOURCEASSIGNMENTUPDATE FOR RESOURCEASSIGNMENTUPDATE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6COSTACCOUNT FOR COSTACCOUNT_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6COSTACCOUNTHIERARCHY FOR COSTACCOUNTHIERARCHY_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6COSTSECURITY FOR COSTSECURITY_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6CURRENCY FOR CURRENCY_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6DOCUMENT FOR DOCUMENT_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6DOCUMENTCATEGORY FOR DOCUMENTCATEGORY_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6DOCUMENTSTATUSCODE FOR DOCUMENTSTATUSCODE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6EPS FOR EPS_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6EPSBUDGETCHANGELOG FOR EPSBUDGETCHANGELOG_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6EPSFUNDING FOR EPSFUNDING_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6EPSHIERARCHY FOR EPSHIERARCHY_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6WBSHIERARCHY FOR WBSHIERARCHY_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6EPSNOTE FOR EPSNOTE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6EPSSPENDINGPLAN FOR EPSSPENDINGPLAN_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6EPSSPREAD FOR EPSSPREAD_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6EXPENSECATEGORY FOR EXPENSECATEGORY_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6FINANCIALPERIOD FOR FINANCIALPERIOD_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6FUNDINGSOURCE FOR FUNDINGSOURCE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6GLOBALPROFILE FOR GLOBALPROFILE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6ISSUEHISTORY FOR ISSUEHISTORY_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6ITERATION FOR ITERATION_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6ITERATIONACTIVITY FOR ITERATIONACTIVITY_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6ITERATIONTEAM FOR ITERATIONTEAM_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6LOCATION FOR LOCATION_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6NOTEBOOKTOPIC FOR NOTEBOOKTOPIC_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6OBS FOR OBS_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6OVERHEADCODE FOR OVERHEADCODE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6PROJECT FOR PROJECT_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6BLPROJECT FOR BLPROJECT_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6PROJECTBUDGETCHANGELOG FOR PROJECTBUDGETCHANGELOG_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6PROJECTCODE FOR PROJECTCODE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6PROJECTCODE_S FOR PROJECTCODE_S
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6PROJECTCODEASSIGNMENT FOR PROJECTCODEASSIGNMENT_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6PROJECTCODEASSIGNMENT_S FOR PROJECTCODEASSIGNMENT_S
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6PROJECTCODEHIERARCHY FOR PROJECTCODEHIERARCHY_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6PROJECTCODEHIERARCHY_S FOR PROJECTCODEHIERARCHY_S
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6PROJECTCODETYPE FOR PROJECTCODETYPE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6PROJECTCODETYPE_S FOR PROJECTCODETYPE_S
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6PROJECTCODEUSER FOR PROJECTCODEUSER_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6PROJECTDOCUMENT FOR PROJECTDOCUMENT_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6PROJECTFUNDING FOR PROJECTFUNDING_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6PROJECTISSUE FOR PROJECTISSUE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6PROJECTNOTE FOR PROJECTNOTE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6PROJECTPORTFOLIO FOR PROJECTPORTFOLIO_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6PROJECTPROFILE FOR PROJECTPROFILE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6PROJECTPROJECTPORTFOLIO FOR PROJECTPROJECTPORTFOLIO_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6PROJECTRESOURCE FOR PROJECTRESOURCE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6PROJECTRESOURCEQUANTITY FOR PROJECTRESOURCEQUANTITY_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RISK FOR RISK_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RISKIMPACT FOR RISKIMPACT_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RISKRESPONSEACTION FOR RISKRESPONSEACTION_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RISKRESPONSEACTIONIMPACT FOR RISKRESPONSEACTIONIMPACT_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RISKRESPONSEPLAN FOR RISKRESPONSEPLAN_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RISKMATRIXSCORETYPE FOR RISKMATRIXSCORETYPE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RISKSCORETYPE FOR RISKSCORETYPE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RISKMATRIXSCORE FOR RISKMATRIXSCORE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RISKSCOREMATRIX FOR RISKSCOREMATRIX_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RISKTHRESHOLDLEVEL FOR RISKTHRESHOLDLEVEL_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6PROJECTSPENDINGPLAN FOR PROJECTSPENDINGPLAN_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6PROJECTSPREAD FOR PROJECTSPREAD_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RELATIONSHIP FOR RELATIONSHIP_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RELEASE FOR RELEASE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RELEASEPROJECT FOR RELEASEPROJECT_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RELEASEITERATION FOR RELEASEITERATION_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6REPORTDATE FOR REPORTDATE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6REPORTTIME FOR REPORTTIME_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RESASSIGNMENTPERIODACTUAL FOR RESASSIGNMENTPERIODACTUAL_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RESOURCEACCESS FOR RESOURCEACCESS_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RESOURCEASSIGNMENT FOR RESOURCEASSIGNMENT_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RESOURCECODE FOR RESOURCECODE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RESOURCECODE_S FOR RESOURCECODE_S
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RESOURCECODEASSIGNMENT FOR RESOURCECODEASSIGNMENT_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RESOURCECODEASSIGNMENT_S FOR RESOURCECODEASSIGNMENT_S
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RESOURCECODEHIERARCHY FOR RESOURCECODEHIERARCHY_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RESOURCECODEHIERARCHY_S FOR RESOURCECODEHIERARCHY_S
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RESOURCECODETYPE FOR RESOURCECODETYPE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RESOURCECODETYPE_S FOR RESOURCECODETYPE_S
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RESOURCECURVE FOR RESOURCECURVE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RESOURCEHIERARCHY FOR RESOURCEHIERARCHY_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RESOURCEHOUR FOR RESOURCEHOUR_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RESOURCERATE FOR RESOURCERATE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RESOURCERESOURCETEAM FOR RESOURCERESOURCETEAM_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RESOURCEROLE FOR RESOURCEROLE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RESOURCES FOR RESOURCES_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RESOURCELOCATION FOR RESOURCELOCATION_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RESOURCETEAM FOR RESOURCETEAM_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RISKTYPE FOR RISKTYPE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6ROLE FOR ROLE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6ROLERATE FOR ROLERATE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6ROLEROLETEAM FOR ROLEROLETEAM_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6ROLETEAM FOR ROLETEAM_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6SHIFT FOR SHIFT_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6SHIFTPERIOD FOR SHIFTPERIOD_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6SNAPSHOT FOR SNAPSHOT_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6SNAPSHOTGROUP FOR SNAPSHOTGROUP_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6SNAPSHOTPROJECT FOR SNAPSHOTPROJECT_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6TIMESHEET FOR TIMESHEET_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6TIMESHEETPERIOD FOR TIMESHEETPERIOD_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6UDFCODE FOR UDFCODE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6UDFCODE_S FOR UDFCODE_S
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6UDFTYPE FOR UDFTYPE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6UDFTYPE_S FOR UDFTYPE_S
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6UNITOFMEASURE FOR UNITOFMEASURE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6USERMODULEACCESS FOR USERMODULEACCESS_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6USEROBS FOR USEROBS_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6USERPROFILEPRIVILEGE FOR USERPROFILEPRIVILEGE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6USERS FOR USERS_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6WBS FOR WBS_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6BLWBS FOR BLWBS_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6WBSCATEGORY FOR WBSCATEGORY_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6WBSMILESTONE FOR WBSMILESTONE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6WBSSPREAD FOR WBSSPREAD_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6PROJECTETLLIST FOR PROJECTETLLIST_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6PROJECT_UDFVALUE FOR PROJECT_UDFVALUE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6RESOURCE_UDFVALUE FOR RESOURCE_UDFVALUE_U
/ 
		
--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM P6GLOBAL_UDFVALUE FOR GLOBAL_UDFVALUE_U
/ 
		

--METADATA  TYPE:ADHOC_SQL
CREATE OR REPLACE SYNONYM p6BASELINE FOR BASELINE_u
/ 
		
