/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.poc;

import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import com.primavera.database.PrimaveraDatabaseException;
import com.primavera.database.common.DatabaseSyntaxHelper;
import com.primavera.database.common.GenericDataTypes;
import com.primavera.database.common.ServerType;
import com.primavera.database.tools.Dataloader.FileZipOutputProvider;
import com.primavera.database.tools.Dataloader.output.ZipOutputter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.jdbc.OracleDriver;

public class CA {
    private final String TEST_TABLE = "CA_TEST_TABLE";
    private ServerType m_servertype = ServerType.SQLSERVER;
    private String m_username;
    private String m_password;
    private String m_server;
    private String m_database;
    private Connection m_conn;
    private String m_oper;

    private String parseParam(String s) {
        return s.substring(s.indexOf(":") + 1, s.length());
    }

    public static void usageError(String msg) {
        System.out.println("ERROR: " + msg);
        System.out.println("usage: <pump:basic> /servertype:ss /username:sa /password:dbtype /servername:localhost:1980 /dbname:PMDB");
    }

    public static void main(String[] args) {
        CA ca = new CA();
        if (args.length < 5) {
            CA.usageError("Too few arguments");
            return;
        }
        ca.m_oper = args[0];
        String param = ca.parseParam(args[1]);
        if (param.compareToIgnoreCase("ss") == 0) {
            ca.m_servertype = ServerType.SQLSERVER;
            System.out.println("RDBMS is SQL Server");
        } else if (param.compareToIgnoreCase("or") == 0) {
            ca.m_servertype = ServerType.ORACLE;
            System.out.println("RDBMS is Oracle");
        } else if (param.compareToIgnoreCase("asa") == 0) {
            ca.m_servertype = ServerType.SYBASE;
            System.out.println("RDBMS is Sybase");
        } else {
            CA.usageError("Invalid servertype=" + param);
            return;
        }
        ca.m_username = ca.parseParam(args[2]);
        ca.m_password = ca.parseParam(args[3]);
        ca.m_server = ca.parseParam(args[4]);
        ca.m_database = ca.parseParam(args[5]);
        System.out.println("Running with params:");
        System.out.println("Username=>" + ca.m_username);
        System.out.println("Password=>" + ca.m_password);
        System.out.println("Server=>" + ca.m_server);
        System.out.println("Database=>" + ca.m_database);
        try {
            ca.connect();
        }
        catch (SQLException e) {
            System.out.println("Connection failed: " + e.getMessage());
            return;
        }
        System.out.println("Connection Succeeded");
        try {
            if (ca.m_oper.compareToIgnoreCase("pump") == 0) {
                ca.pump();
            } else {
                ca.doWork();
            }
        }
        catch (Exception e) {
            System.out.println("CA Failed: " + e.getMessage());
            return;
        }
        System.out.println("Work Complete");
        System.out.println("CA completed successfully");
    }

    private void pump() throws PrimaveraDatabaseException {
        ZipOutputter z = new ZipOutputter(new FileZipOutputProvider());
        z.setTablePattern("%");
        z.excludeTable("SETTINGS");
        z.output(this.m_conn);
    }

    private void connect() throws SQLException {
        if (this.m_servertype == ServerType.ORACLE) {
            String url = "jdbc:oracle:thin:@" + this.m_server;
            DriverManager.registerDriver((Driver)new OracleDriver());
            this.m_conn = DriverManager.getConnection(url, this.m_username, this.m_password);
        } else if (this.m_servertype == ServerType.SQLSERVER) {
            String url = "jdbc:jtds:sqlserver://" + this.m_server + "/" + this.m_database;
            DriverManager.registerDriver((Driver)new SQLServerDriver());
            this.m_conn = DriverManager.getConnection(url, this.m_username, this.m_password);
        } else if (this.m_servertype == ServerType.SYBASE) {
            throw new SQLException("Sybase not supported");
        }
    }

    private void doWork() throws SQLException {
        Statement stmt = this.m_conn.createStatement();
        System.out.print("Droping table...");
        try {
            stmt.execute("drop table CA_TEST_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        System.out.println("done");
        System.out.print("Creating table...");
        String s = new String("create table CA_TEST_TABLE(intcol " + DatabaseSyntaxHelper.getPhysicalDataType(GenericDataTypes.INTEGER, this.m_servertype) + ", varcol " + DatabaseSyntaxHelper.getPhysicalDataType(GenericDataTypes.STRING, this.m_servertype) + "(100)" + ", datecol " + DatabaseSyntaxHelper.getPhysicalDataType(GenericDataTypes.DATE, this.m_servertype) + ", numcol " + DatabaseSyntaxHelper.getPhysicalDataType(GenericDataTypes.NUMBER, this.m_servertype) + "(17,6)" + ", memocol " + DatabaseSyntaxHelper.getPhysicalDataType(GenericDataTypes.MEMO, this.m_servertype) + ")");
        System.out.println("done");
        stmt.execute(s);
        s = "insert into CA_TEST_TABLE(intcol,varcol,numcol) values (101,'Test data',123.456)";
        System.out.print("Inserting data...");
        stmt.execute(s);
        System.out.println("done");
    }
}

