/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.common;

import com.primavera.database.common.ApplicationProperties;
import com.primavera.database.common.DynamicClassLoader;
import com.primavera.database.common.ProductVersion;
import com.primavera.database.common.SchemaInfo;
import com.primavera.database.common.SchemaInfoImpl;
import com.primavera.database.common.logging.Log;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class DynamicSchemaBundleManager {
    public static final String JAR_PATH_SYSTEM_PROPERTY = "dbmt.dbschema.package.location";
    private static final Collection<File> EMPTY_FILE_COLLECTION = new ArrayList<File>();
    private static Collection<File> s_jarFileList;
    private static Collection<SchemaInfoImpl> s_schemaInfoList;
    private static String s_loadJarPath;

    private static Collection<File> findSchemaJarFiles(String location) {
        File directory = new File(location);
        if (!directory.exists()) {
            Log.error("Directory " + directory.toString() + " does not exist");
            return EMPTY_FILE_COLLECTION;
        }
        if (!directory.isDirectory()) {
            Log.error(directory.toString() + " is not a directory");
            return EMPTY_FILE_COLLECTION;
        }
        String dirPath = directory.getParent();
        try {
            dirPath = directory.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File[] filesInDir = directory.listFiles();
        ArrayList<File> fileSet = new ArrayList<File>();
        for (File f : filesInDir) {
            File file;
            SchemaInfoImpl schemaInfo;
            if (f.isDirectory() || (schemaInfo = SchemaInfoImpl.createFromFile(f)) == null || !(file = new File(dirPath + File.separator + schemaInfo.getFileName())).exists() || file.isDirectory()) continue;
            fileSet.add(file);
            s_schemaInfoList.add(schemaInfo);
        }
        return fileSet;
    }

    public static Collection<File> getJarFileList() {
        return s_jarFileList;
    }

    public static Collection<SchemaInfoImpl> getSchemaInfoList() {
        return s_schemaInfoList;
    }

    public static void load() {
        s_jarFileList = DynamicSchemaBundleManager.findSchemaJarFiles(s_loadJarPath);
        for (File jarFile : s_jarFileList) {
            try {
                DynamicClassLoader.addFile(jarFile);
            }
            catch (IOException e) {
                Log.error("Unable to add jar file " + jarFile + " to classpath");
            }
        }
    }

    public static String getLoadJarPath() {
        return s_loadJarPath;
    }

    public static void setLoadJarPath(String jarPath) {
        s_loadJarPath = jarPath;
    }

    public static String getDefaultVersion(String productString) {
        String verstring = "00_00_00";
        for (SchemaInfo schemaInfo : s_schemaInfoList) {
            String compareString;
            SchemaInfo info = schemaInfo;
            if (!info.getSchemaType().toString().equalsIgnoreCase(productString) || (compareString = ProductVersion.format(info.getMajVersion()) + "_" + ProductVersion.format(info.getMinVersion()) + "_" + ProductVersion.format(info.getRelVersion())).compareTo(verstring) <= 0) continue;
            verstring = compareString;
        }
        return verstring;
    }

    static {
        s_schemaInfoList = new ArrayList<SchemaInfoImpl>();
        s_loadJarPath = "lib";
        if (ApplicationProperties.getProps().getProperty(JAR_PATH_SYSTEM_PROPERTY) != null) {
            s_loadJarPath = ApplicationProperties.getProps().getProperty(JAR_PATH_SYSTEM_PROPERTY);
        }
        DynamicSchemaBundleManager.load();
    }
}

