/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.ScriptRunner;

import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.common.logging.Log;
import com.primavera.database.tools.DatabaseToolException;
import com.primavera.database.tools.ScriptRunner.RunScriptListener;
import com.primavera.database.tools.ScriptRunner.ScriptHelper;
import com.primavera.database.tools.ScriptRunner.ScriptProperties;
import com.primavera.database.tools.ScriptRunner.ScriptRunner;
import java.io.File;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class RedefineTables {
    public static final String LOG_FILE_NAME = "RedefineTables.log";

    public static void main(String[] args) throws SQLException, DatabaseToolException {
        String userHome = System.getProperty("user.home");
        Log.setLogFileName(userHome + File.separatorChar + LOG_FILE_NAME);
        if (args.length < 3) {
            Log.info("Usage: java -classpath dbtools.jar " + RedefineTables.class.getName() + " {Source String} {Admuser name} {password}");
            System.exit(-1);
        }
        String connectstring = args[0];
        String adminUser = args[1];
        String adminPass = args[2];
        String adminConnString = RedefineTables.setAdminConn(connectstring, adminUser, adminPass);
        String scriptname = "orpm_table_redefinition.sql";
        ScriptProperties m_properties = null;
        String ndx_name = RedefineTables.findIndexTablespace(connectstring, adminUser);
        String dat_name = RedefineTables.findDataTablespace(connectstring, adminUser);
        try {
            ScriptRunner sr = new ScriptRunner();
            DatabaseConnection dbconn = new DatabaseConnection(connectstring);
            sr.setDbconn(dbconn);
            m_properties = sr.properties;
            m_properties.setProperty("pm.index_tablespace", ndx_name);
            m_properties.setProperty("pm.data_tablespace", dat_name);
            m_properties.setProperty("pm.or.administrative_user", adminUser);
            URL url = ScriptHelper.findScript(sr, scriptname);
            if (url == null) {
                throw new DatabaseToolException("No Script Found");
            }
            Log.info("Running Script: " + url.getPath());
            sr.setScriptUrl(url);
            sr.addListener(new RunScriptListener());
            sr.run();
        }
        catch (SQLException e) {
            Log.error("Script Failed with SQL Exception");
            Log.error(e.getMessage());
            System.exit(-1);
        }
        catch (DatabaseToolException e) {
            e.printStackTrace();
            if (e.getSql().length() > 0) {
                Log.error(e.getSql());
            }
            Log.error("Script Failed");
            System.exit(-1);
        }
        Log.info("Table redefinition script Succeeded");
        Log.info("Recompiling schema");
        RedefineTables.compileSchema(connectstring, adminUser, RedefineTables.getPrivUser(adminConnString), RedefineTables.getBGJobUser(connectstring, adminUser), RedefineTables.getPxrptUser(adminConnString));
        RedefineTables.compileInvalidObjects(connectstring, adminConnString, adminUser);
        Log.info("Schema Recompilation completed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String findIndexTablespace(String conn, String adminUser) throws SQLException {
        String ndx_name = null;
        DatabaseConnection dbconn = null;
        Statement stmt = null;
        try {
            dbconn = new DatabaseConnection(conn);
            String sqlStatement = "SELECT TABLESPACE_NAME FROM DBA_SEGMENTS \r\nWHERE OWNER ='" + adminUser.toUpperCase() + "' AND TABLESPACE_NAME LIKE 'PMDB_NDX%' AND ROWNUM=1";
            stmt = dbconn.getConnection().createStatement();
            ResultSet rs = stmt.executeQuery(sqlStatement);
            while (rs.next()) {
                ndx_name = rs.getString("TABLESPACE_NAME");
            }
        }
        catch (SQLException e) {
            DBMTLogger.error(e.getLocalizedMessage());
        }
        finally {
            stmt.close();
            dbconn.close();
        }
        return ndx_name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String findDataTablespace(String conn, String adminUser) throws SQLException {
        String dat_name = null;
        DatabaseConnection dbconn = null;
        Statement stmt = null;
        try {
            dbconn = new DatabaseConnection(conn);
            String sqlStatement = "SELECT TABLESPACE_NAME FROM DBA_SEGMENTS \r\nWHERE OWNER ='" + adminUser.toUpperCase() + "' AND TABLESPACE_NAME LIKE 'PMDB_DAT%' AND ROWNUM=1";
            stmt = dbconn.getConnection().createStatement();
            ResultSet rs = stmt.executeQuery(sqlStatement);
            while (rs.next()) {
                dat_name = rs.getString("TABLESPACE_NAME");
            }
        }
        catch (SQLException e) {
            DBMTLogger.error(e.getLocalizedMessage());
        }
        finally {
            stmt.close();
            dbconn.close();
        }
        return dat_name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compileInvalidObjects(String conn, String adminString, String adminUser) throws SQLException {
        ArrayList<String> objName = new ArrayList<String>();
        ArrayList<String> objType = new ArrayList<String>();
        DatabaseConnection dbconn = null;
        DatabaseConnection dbconn1 = null;
        Statement stmt = null;
        Statement stmt1 = null;
        try {
            dbconn = new DatabaseConnection(conn);
            String sqlStatement = "SELECT OBJECT_NAME,OBJECT_TYPE FROM DBA_OBJECTS WHERE STATUS='INVALID' AND OWNER='" + adminUser.toUpperCase() + "'";
            stmt = dbconn.getConnection().createStatement();
            ResultSet rs = stmt.executeQuery(sqlStatement);
            while (rs.next()) {
                String lobjName = rs.getString("OBJECT_NAME");
                String lobjType = rs.getString("OBJECT_TYPE");
                objName.add(lobjName);
                objType.add(lobjType);
            }
        }
        catch (SQLException e) {
            DBMTLogger.warn(e.getMessage());
        }
        finally {
            stmt.close();
            dbconn.close();
        }
        try {
            for (int i = 0; i < objName.size(); ++i) {
                if (!((String)objType.get(i)).equals("TRIGGER")) continue;
                String sqlStatement1 = "ALTER TRIGGER " + (String)objName.get(i) + " COMPILE";
                dbconn1 = new DatabaseConnection(adminString);
                stmt1 = dbconn1.getConnection().createStatement();
                stmt1.execute(sqlStatement1);
                stmt1.close();
                dbconn1.close();
            }
        }
        catch (SQLException e) {
            DBMTLogger.warn(e.getMessage());
        }
    }

    private static String setAdminConn(String conn, String adminUser, String adminPass) {
        int at = conn.indexOf("@");
        String tail = conn.substring(at);
        if (!adminUser.isEmpty() && !adminPass.isEmpty() && conn.contains("@")) {
            return adminUser + "/" + adminPass + tail;
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPrivUser(String adminConnString) throws SQLException {
        String privUsername = null;
        DatabaseConnection dbconn = null;
        Statement stmt = null;
        try {
            dbconn = new DatabaseConnection(adminConnString);
            String sqlStatement = "SELECT PRIVATE_DB_USER_NAME FROM PUBUSER";
            stmt = dbconn.getConnection().createStatement();
            ResultSet rs = stmt.executeQuery(sqlStatement);
            while (rs.next()) {
                privUsername = rs.getString("PRIVATE_DB_USER_NAME");
            }
        }
        catch (SQLException e) {
            DBMTLogger.warn(e.getMessage());
        }
        finally {
            stmt.close();
            dbconn.close();
        }
        return privUsername;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getBGJobUser(String conn, String adminUser) throws SQLException {
        String bgjobUsername = null;
        DatabaseConnection dbconn = null;
        Statement stmt = null;
        try {
            dbconn = new DatabaseConnection(conn);
            String sqlStatement = "select  grantee from dba_role_privs rp where granted_role = 'PM_BG_JOB_ROLE' and admin_option='NO'\r\nand exists (select 1 from dba_synonyms where owner=rp.grantee and table_owner='" + adminUser.toUpperCase() + "' and synonym_name in('DATA_MONITOR')) order by grantee";
            stmt = dbconn.getConnection().createStatement();
            ResultSet rs = stmt.executeQuery(sqlStatement);
            while (rs.next()) {
                bgjobUsername = rs.getString("GRANTEE");
            }
        }
        catch (SQLException e) {
            DBMTLogger.warn(e.getMessage());
        }
        finally {
            stmt.close();
            dbconn.close();
        }
        return bgjobUsername;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPxrptUser(String adminConnString) throws SQLException {
        String pxrptUsername = null;
        DatabaseConnection dbconn = null;
        Statement stmt = null;
        try {
            dbconn = new DatabaseConnection(adminConnString);
            String sqlStatement = "SELECT grantee username, COUNT(*) grantcount FROM user_tab_privs_made  WHERE table_name = 'TASKX'  GROUP BY grantee having count(*)=1";
            stmt = dbconn.getConnection().createStatement();
            ResultSet rs = stmt.executeQuery(sqlStatement);
            while (rs.next()) {
                pxrptUsername = rs.getString("USERNAME");
            }
        }
        catch (SQLException e) {
            DBMTLogger.warn(e.getMessage());
        }
        finally {
            stmt.close();
            dbconn.close();
        }
        return pxrptUsername;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compileSchema(String conn, String adminUser, String privUsername, String bgjobUsername, String pxrptUsername) throws SQLException {
        DatabaseConnection dbconn = null;
        Statement stmt = null;
        try {
            dbconn = new DatabaseConnection(conn);
            String sqlStatement = "begin \r\nDBMS_UTILITY.compile_schema(schema=> '" + adminUser.toUpperCase() + "');\r\n" + "DBMS_UTILITY.compile_schema(schema=> '" + privUsername.toUpperCase() + "');\r\n" + "DBMS_UTILITY.compile_schema(schema=> '" + bgjobUsername.toUpperCase() + "');\r\n" + "DBMS_UTILITY.compile_schema(schema=> '" + pxrptUsername.toUpperCase() + "');\r\n" + "END;";
            stmt = dbconn.getConnection().createStatement();
            stmt.execute(sqlStatement);
        }
        catch (SQLException e) {
            DBMTLogger.warn(e.getMessage());
        }
        finally {
            stmt.close();
            dbconn.close();
        }
    }
}

