/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.ScriptRunner;

import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.logging.Log;
import com.primavera.database.tools.DatabaseToolException;
import com.primavera.database.tools.ScriptRunner.RunScriptListener;
import com.primavera.database.tools.ScriptRunner.ScriptHelper;
import com.primavera.database.tools.ScriptRunner.ScriptRunner;
import java.io.File;
import java.net.URL;
import java.util.Properties;

public class InvokeScriptRunner {
    private static Properties scriptProperties;

    public static void start(String[] args) throws Exception {
        if (args.length < 2) {
            throw new Exception(InvokeScriptRunner.class.getSimpleName() + " failed.  Usage InvokeScriptRunner connect_string script_name");
        }
        File f = new File(args[1]);
        if (f == null || !f.isFile()) {
            throw new Exception(InvokeScriptRunner.class.getSimpleName() + " failed.  File " + args[1] + " does not exist");
        }
        if (!new InvokeScriptRunner().execute(args)) {
            throw new Exception(InvokeScriptRunner.class.getSimpleName() + " failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execute(String[] args) throws Exception {
        String connectstring = args[0];
        String scriptname = args[1];
        try (DatabaseConnection dbconn = new DatabaseConnection(connectstring);){
            URL url;
            ScriptRunner sr = new ScriptRunner();
            sr.setDbconn(dbconn);
            if (scriptProperties != null) {
                Log.info("Using Override Properties");
                sr.setExtendedProperties(scriptProperties);
            }
            if ((url = ScriptHelper.findScript(sr, scriptname)) == null) {
                throw new DatabaseToolException("No Script Found");
            }
            Log.info("Running Script: " + scriptname);
            sr.setScriptUrl(url);
            sr.addListener(new RunScriptListener());
            sr.run();
        }
        Log.info("Script Succeeded");
        return true;
    }

    public static void setProperties(Properties p) {
        Log.info("Setting override properties");
        scriptProperties = p;
    }
}

