/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ProductCodeInfo {
    private static final Map<String, char[]> s_codeMap = ProductCodeInfo.createCodeMap();

    public static char[] codeChar(String codeType) {
        return s_codeMap.get(codeType.toUpperCase());
    }

    private static Map<String, char[]> createCodeMap() {
        HashMap<String, char[]> codeMap = new HashMap<String, char[]>();
        codeMap.put("IT", new char[]{'C', 'E', 'T'});
        codeMap.put("MT", new char[]{'C', 'E', 'T'});
        codeMap.put("EC", new char[]{'C', 'E', 'T', 'O'});
        codeMap.put("PD", new char[]{'C', 'E', 'T'});
        codeMap.put("MK", new char[]{'C', 'E', 'T'});
        return codeMap;
    }

    public static boolean isValid(String string) {
        int i;
        char[] keyHead = new char[2];
        char[] keyBody = new char[3];
        if (string.length() < 5) {
            return false;
        }
        if (string.length() > 6) {
            return false;
        }
        int bodyStartsAt = keyHead.length;
        if (string.length() == 6) {
            if (string.charAt(2) != '-') {
                return false;
            }
            ++bodyStartsAt;
        }
        for (i = 0; i < 2; ++i) {
            keyHead[i] = Character.toUpperCase(string.charAt(i));
            if (Character.isLetter(keyHead[i])) continue;
            return false;
        }
        keyBody[0] = Character.toUpperCase(string.charAt(bodyStartsAt));
        if (!Character.isLetter(keyBody[0])) {
            return false;
        }
        for (i = 1; i < 3; ++i) {
            keyBody[i] = Character.toUpperCase(string.charAt(i + bodyStartsAt));
            if (Character.isDigit(keyBody[i])) continue;
            return false;
        }
        char[] codeChar = ProductCodeInfo.codeChar(new String(keyHead));
        if (codeChar == null) {
            return false;
        }
        Arrays.sort(codeChar);
        return Arrays.binarySearch(codeChar, keyBody[0]) >= 0;
    }
}

