/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools;

import com.primavera.database.common.ServerType;
import com.primavera.database.tools.CSDFRecord;
import com.primavera.database.tools.GCDFRecord;
import com.primavera.database.tools.RetrieveExpCustomFieldInfo;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class InsertExpCustomFieldInfo {
    private static final String TRANSFORM_PARAM_USE_INLINE_SCHEMA = "use_inline_schema";
    private static final String TRANSFORM_PARAM_USE_DISPLAY_COLUMN_NAME = "use_display_column_name";
    private static final String TRANSFORM_PARAM_USE_DISPLAY_NAME = "use_display_name";
    private static final String TRANSFORM_PARAM_INCLUDE_STORAGE = "include_storage";
    private static final String TRANSFORM_PARAM_SPREFIX = "sprefix";
    private static final String SCHEMA_TAG_NAME = "schema";
    private static final String CSDF_ADDITION_TABLE = "CSMT_TABLE";
    private static final String CSDF_ADDITION_TYPE = "string";
    private static final Map<String, String> EXP_GCDF_COLUMN_TYPE_MAP = InsertExpCustomFieldInfo.createExpGcdfColumnTypeMap();
    private RetrieveExpCustomFieldInfo<?> m_retriever;

    public RetrieveExpCustomFieldInfo<?> getRetriever() {
        return this.m_retriever;
    }

    private static Map<String, String> createExpGcdfColumnTypeMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("CHAR", "character");
        map.put("LONG VARCHAR", "clob");
        map.put("BOOLEAN", "smallint");
        map.put("CURRENCY", "number");
        map.put("DATE", "date");
        map.put("UPPER", CSDF_ADDITION_TYPE);
        map.put("QUANTITY", "number");
        return map;
    }

    public void setRetriever(RetrieveExpCustomFieldInfo<?> retriever) {
        this.m_retriever = retriever;
    }

    public static Document getGCDefWorklistDocument(Collection<GCDFRecord> records) throws Exception {
        if (records.isEmpty()) {
            return null;
        }
        Document doc = InsertExpCustomFieldInfo.createWorklistDocument();
        Element rootElem = doc.createElement("worklist");
        doc.appendChild(rootElem);
        HashSet<String> typeSet = new HashSet<String>();
        for (GCDFRecord record : records) {
            InsertExpCustomFieldInfo.addGCDFWorklistRecord(rootElem, record);
            typeSet.add(record.getCdiType());
        }
        return doc;
    }

    public static Document getCSDefWorklistDocument(Collection<CSDFRecord> records) throws Exception {
        if (records.isEmpty()) {
            return null;
        }
        Document doc = InsertExpCustomFieldInfo.createWorklistDocument();
        Element rootElem = doc.createElement("worklist");
        doc.appendChild(rootElem);
        for (CSDFRecord record : records) {
            InsertExpCustomFieldInfo.addCSDFWorklistRecord(rootElem, record);
        }
        return doc;
    }

    private static Document createWorklistDocument() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        doc.setXmlVersion("1.0");
        return doc;
    }

    public static String createScriptFileFromWorklist(Document doc, ServerType dbType, Transformer trans) throws TransformerException {
        trans.setParameter(TRANSFORM_PARAM_SPREFIX, dbType.getShortName().toUpperCase());
        trans.setParameter(TRANSFORM_PARAM_INCLUDE_STORAGE, "N");
        trans.setParameter(TRANSFORM_PARAM_USE_DISPLAY_NAME, "Y");
        trans.setParameter(TRANSFORM_PARAM_USE_DISPLAY_COLUMN_NAME, "Y");
        trans.setParameter(TRANSFORM_PARAM_USE_INLINE_SCHEMA, "true");
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(bytes);
        trans.transform(new DOMSource(doc), result);
        return new String(bytes.toByteArray());
    }

    private static void addGCDFWorklistRecord(Element rootElem, GCDFRecord record) {
        Element itemElem = rootElem.getOwnerDocument().createElement("item");
        Element objTypeElem = rootElem.getOwnerDocument().createElement("objtype");
        Text objTypeText = rootElem.getOwnerDocument().createTextNode("FIELD");
        objTypeElem.appendChild(objTypeText);
        itemElem.appendChild(objTypeElem);
        Element tabNameElem = rootElem.getOwnerDocument().createElement("tabname");
        Text tabNameText = rootElem.getOwnerDocument().createTextNode(record.getCdiTable());
        tabNameElem.appendChild(tabNameText);
        itemElem.appendChild(tabNameElem);
        Element objNameElem = rootElem.getOwnerDocument().createElement("objname");
        Text objNameText = rootElem.getOwnerDocument().createTextNode(record.getCdiName());
        objNameElem.appendChild(objNameText);
        itemElem.appendChild(objNameElem);
        Element chgTypeElem = rootElem.getOwnerDocument().createElement("chgtype");
        Text chgTypeText = rootElem.getOwnerDocument().createTextNode("CREATE");
        chgTypeElem.appendChild(chgTypeText);
        itemElem.appendChild(chgTypeElem);
        Element targetElem = rootElem.getOwnerDocument().createElement("target");
        itemElem.appendChild(targetElem);
        Element sortOrderElem = rootElem.getOwnerDocument().createElement("sortorder");
        Text sortOrderText = rootElem.getOwnerDocument().createTextNode("BAB");
        sortOrderElem.appendChild(sortOrderText);
        itemElem.appendChild(sortOrderElem);
        Element schemaInfoElem = rootElem.getOwnerDocument().createElement(SCHEMA_TAG_NAME);
        itemElem.appendChild(schemaInfoElem);
        InsertExpCustomFieldInfo.addSchemaGCDFInfoToWorklistElem(schemaInfoElem, record);
        rootElem.appendChild(itemElem);
    }

    private static void addSchemaGCDFInfoToWorklistElem(Element schemaInfoElem, GCDFRecord record) {
        schemaInfoElem.setAttribute("TABLE", record.getCdiTable());
        schemaInfoElem.setAttribute("NAME", record.getCdiName());
        schemaInfoElem.setAttribute("DATATYPE", InsertExpCustomFieldInfo.convertDatetype(record.getCdiType()));
        schemaInfoElem.setAttribute("CHARLENGTH", Integer.toString(record.getCdiLength()));
        schemaInfoElem.setAttribute("NOTNULL", "N");
        schemaInfoElem.setAttribute("IDCOLUMN", "N");
        schemaInfoElem.setAttribute("DESC", record.getDescription());
    }

    private static String convertDatetype(String cdiType) {
        String convertedType = EXP_GCDF_COLUMN_TYPE_MAP.get(cdiType);
        if (convertedType != null) {
            return convertedType;
        }
        return cdiType;
    }

    private static void addCSDFWorklistRecord(Element rootElem, CSDFRecord record) {
        Element itemElem = rootElem.getOwnerDocument().createElement("item");
        Element objTypeElem = rootElem.getOwnerDocument().createElement("objtype");
        Text objTypeText = rootElem.getOwnerDocument().createTextNode("FIELD");
        objTypeElem.appendChild(objTypeText);
        itemElem.appendChild(objTypeElem);
        Element tabNameElem = rootElem.getOwnerDocument().createElement("tabname");
        Text tabNameText = rootElem.getOwnerDocument().createTextNode(CSDF_ADDITION_TABLE);
        tabNameElem.appendChild(tabNameText);
        itemElem.appendChild(tabNameElem);
        Element objNameElem = rootElem.getOwnerDocument().createElement("objname");
        Text objNameText = rootElem.getOwnerDocument().createTextNode(record.getDefinitionName());
        objNameElem.appendChild(objNameText);
        itemElem.appendChild(objNameElem);
        Element chgTypeElem = rootElem.getOwnerDocument().createElement("chgtype");
        Text chgTypeText = rootElem.getOwnerDocument().createTextNode("CREATE");
        chgTypeElem.appendChild(chgTypeText);
        itemElem.appendChild(chgTypeElem);
        Element targetElem = rootElem.getOwnerDocument().createElement("target");
        itemElem.appendChild(targetElem);
        Element sortOrderElem = rootElem.getOwnerDocument().createElement("sortorder");
        Text sortOrderText = rootElem.getOwnerDocument().createTextNode("BAB");
        sortOrderElem.appendChild(sortOrderText);
        itemElem.appendChild(sortOrderElem);
        Element schemaInfoElem = rootElem.getOwnerDocument().createElement(SCHEMA_TAG_NAME);
        InsertExpCustomFieldInfo.addSchemaCSDFInfoToWorklistElem(schemaInfoElem, record);
        itemElem.appendChild(schemaInfoElem);
        rootElem.appendChild(itemElem);
    }

    private static void addSchemaCSDFInfoToWorklistElem(Element schemaInfoElem, CSDFRecord record) {
        schemaInfoElem.setAttribute("TABLE", CSDF_ADDITION_TABLE);
        schemaInfoElem.setAttribute("NAME", record.getDefinitionName());
        schemaInfoElem.setAttribute("DATATYPE", CSDF_ADDITION_TYPE);
        schemaInfoElem.setAttribute("CHARLENGTH", Integer.toString(record.getWidth()));
        schemaInfoElem.setAttribute("NOTNULL", "N");
        schemaInfoElem.setAttribute("DEFAULT", "");
        schemaInfoElem.setAttribute("IDCOLUMN", "N");
        schemaInfoElem.setAttribute("DESC", record.getDescription());
    }

    private static void writeElement(XMLStreamWriter writer, Element documentElement) throws Exception {
        int i;
        NodeList subNodes = documentElement.getChildNodes();
        if (subNodes.getLength() == 0) {
            writer.writeEmptyElement(documentElement.getTagName());
        } else {
            writer.writeStartElement(documentElement.getTagName());
        }
        NamedNodeMap attrs = documentElement.getAttributes();
        for (i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            writer.writeAttribute(attr.getName(), attr.getValue());
        }
        for (i = 0; i < subNodes.getLength(); ++i) {
            Node node = subNodes.item(i);
            if (node instanceof Attr) {
                Attr attr = (Attr)node;
                writer.writeAttribute(attr.getName(), attr.getValue());
                continue;
            }
            if (node instanceof Element) {
                Element elem = (Element)node;
                InsertExpCustomFieldInfo.writeElement(writer, elem);
                continue;
            }
            if (node instanceof Text) {
                Text text = (Text)node;
                writer.writeCharacters(text.getTextContent());
                continue;
            }
            System.err.println("Unknown Node Type: " + node.getClass().getName());
        }
        if (subNodes.getLength() > 0) {
            writer.writeEndElement();
        }
    }

    public static void writeDocument(Document doc, OutputStream out) throws Exception {
        if (out == null) {
            return;
        }
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = factory.createXMLStreamWriter(out);
        writer.writeStartDocument(doc.getXmlVersion());
        InsertExpCustomFieldInfo.writeElement(writer, doc.getDocumentElement());
        writer.writeEndDocument();
        writer.flush();
        out.write("\n".getBytes());
    }
}

