/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.Dataloader;

import com.primavera.database.common.TableManipulatorAdapter;
import com.primavera.database.common.TableManipulatorInterface;
import com.primavera.database.common.connection.DSType;
import com.primavera.database.common.container.SQLRowInserter;
import com.primavera.database.common.container.XMLRowGenerator;
import com.primavera.database.tools.DatabaseToolException;
import com.primavera.database.tools.Dataloader.DataLoaderXmlHandler;
import com.primavera.database.tools.Dataloader.Dataloader;
import com.primavera.database.tools.Dataloader.DataloaderInputDS;
import com.primavera.database.tools.Dataloader.input.ZipInputEntry;
import com.primavera.database.tools.Dataloader.input.ZipInputter;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class ZipDataloaderInputDS
implements DataloaderInputDS {
    private ZipInputter m_zipIn;
    private String m_currentTable;
    private XMLRowGenerator m_xmlRowGen = new XMLRowGenerator();
    private final DSType m_dsType;
    private TableManipulatorInterface m_tableManipulator = new TableManipulatorAdapter();

    public ZipDataloaderInputDS(String fileName, DSType type) throws DatabaseToolException {
        this(new ZipInputter(fileName), type);
    }

    public ZipDataloaderInputDS(URL url, DSType type) throws DatabaseToolException {
        this(new ZipInputter(url), type);
    }

    public ZipDataloaderInputDS(ZipInputter zipInput, DSType type) throws DatabaseToolException {
        this.m_dsType = type;
        this.m_zipIn = zipInput;
        this.m_zipIn.open();
    }

    public TableManipulatorInterface getTableManipulator() {
        return this.m_tableManipulator;
    }

    public void setTableManipulator(TableManipulatorInterface tableManipulator) {
        this.m_tableManipulator = tableManipulator;
    }

    @Override
    public DSType getDSType() {
        return this.m_dsType;
    }

    @Override
    public void init(String tableName, SQLRowInserter inserter, Dataloader loader) throws DatabaseToolException {
        String entryName = tableName + ".xml";
        ZipInputEntry zipentry = this.m_zipIn.getEntry(entryName);
        Reader br = null;
        TableManipulatorInterface tm = this.getTableManipulator();
        try {
            br = tm.encodeXmlTable(zipentry.getReader(), tableName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_xmlRowGen.setReader(br);
        DataLoaderXmlHandler rowhandler = new DataLoaderXmlHandler();
        this.setCurrentTable(tableName);
        rowhandler.inserter = inserter;
        rowhandler.dataloader = loader;
        this.m_xmlRowGen.setRowhandler(rowhandler);
    }

    @Override
    public List<String> getTableList() {
        ArrayList<String> tempList = this.m_zipIn.getTableList();
        ArrayList<Object> excludedTables = new ArrayList();
        excludedTables = this.m_tableManipulator.getExcludedTables();
        for (int i = 0; i < excludedTables.size(); ++i) {
            if (!tempList.contains(excludedTables.get(i))) continue;
            tempList.remove(excludedTables.get(i));
        }
        return tempList;
    }

    protected final String getCurrentTable() {
        return this.m_currentTable;
    }

    protected final void setCurrentTable(String currentTable) {
        this.m_currentTable = currentTable;
    }

    protected final XMLRowGenerator getXmlRowGen() {
        return this.m_xmlRowGen;
    }

    @Override
    public void init(SQLRowInserter inserter, Dataloader loader) throws DatabaseToolException {
    }
}

