/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.Dataloader;

import com.primavera.database.common.logging.Log;
import com.primavera.database.tools.DatabaseToolException;
import com.primavera.database.tools.Dataloader.DataLoaderProgress;
import com.primavera.database.tools.Dataloader.Dataloader;
import java.io.Console;
import java.io.File;

public class RunDataloader {
    public static final String LOG_FILE_NAME = "PrimaveraDataLoader.log";

    public static void main(String[] args) {
        boolean overwritePassword = false;
        String userHome = System.getProperty("user.home");
        Log.setLogFileName(userHome + File.separatorChar + LOG_FILE_NAME);
        if (args.length < 2) {
            Log.info("Usage: java -classpath dbtools.jar " + RunDataloader.class.getName() + " {Source String} {Target String} [tables:Table List] [commit:n]");
            System.exit(-1);
        }
        String sourceString = args[0];
        String targetString = args[1];
        Dataloader dataloader = new Dataloader();
        dataloader.addListener(new DataLoaderProgress());
        try {
            dataloader.setSourceConnectString(sourceString);
        }
        catch (DatabaseToolException e) {
            Log.error("Failure to set source: " + sourceString);
            System.exit(-2);
        }
        try {
            dataloader.setTargetConnectString(RunDataloader.ensurePassword(targetString));
        }
        catch (DatabaseToolException e) {
            Log.error("Failure to set target: " + targetString);
            System.exit(-2);
        }
        if (args.length > 2) {
            for (int i = 2; i < args.length; ++i) {
                String[] vals = args[i].split(":");
                if (vals.length == 2) {
                    String[] tabs;
                    if (vals[0].toLowerCase().startsWith("com")) {
                        Log.info("Parameter COMMIT COUNT: " + vals[1].toLowerCase());
                        dataloader.setCommitPoint(Integer.parseInt(vals[1]));
                        continue;
                    }
                    if (!vals[0].toLowerCase().startsWith("tab")) continue;
                    Log.info("Parameter TABLES: " + vals[1].toLowerCase());
                    for (String tab : tabs = vals[1].toUpperCase().split(",")) {
                        dataloader.addTable(tab);
                    }
                    continue;
                }
                if (!args[i].equals("passwordPrompt")) continue;
                overwritePassword = true;
            }
        }
        try {
            dataloader.run();
            if (overwritePassword) {
                String password = "";
                String confirmPassword = "";
                System.out.println("Please select a password for the P6 'admin' SuperUser account");
                do {
                    if (password.equals(confirmPassword)) continue;
                    System.err.println("Passwords do not match.");
                } while (!(password = String.valueOf(System.console().readPassword("Password: ", new Object[0]))).equals(confirmPassword = String.valueOf(System.console().readPassword("Confirm Password: ", new Object[0]))));
                dataloader.overwritePasswords(password);
            }
        }
        catch (DatabaseToolException e) {
            Log.error("Dataloader Failure");
            System.exit(-3);
        }
        Log.info("Dataloader Complete");
    }

    private static String ensurePassword(String target) {
        Console c;
        int at = target.indexOf("@");
        String username = at < 0 ? "" : target.substring(0, at);
        String password = "";
        String tail = target.substring(at);
        if (!username.contains("/") && target.contains("@") && !(password = String.valueOf((c = System.console()).readPassword("Password for " + username + ": ", new Object[0]))).isEmpty()) {
            return username + "/" + password + tail;
        }
        return target;
    }
}

