/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.Dataloader;

import com.primavera.database.common.container.RowContainer;
import com.primavera.database.common.container.RowElement;
import com.primavera.database.common.container.SQLRowInserter;
import com.primavera.database.common.container.XMLRowHandler;
import com.primavera.database.common.logging.Log;
import com.primavera.database.tools.Dataloader.Dataloader;
import java.sql.SQLException;
import java.util.Iterator;

class DataLoaderXmlHandler
implements XMLRowHandler {
    public SQLRowInserter inserter;
    public boolean failMetadata = false;
    public String lastMessage = null;
    public boolean failLoad = false;
    public int failedRows = 0;
    public Dataloader dataloader;

    @Override
    public void processMetaData(RowContainer rc) {
        try {
            this.inserter.initializeMetaData(this.dataloader.getCurrentTable(), rc);
        }
        catch (SQLException e) {
            this.failMetadata = true;
            this.lastMessage = e.getMessage();
        }
    }

    @Override
    public void processRow(RowContainer rc, int row) {
        try {
            this.dataloader.sendRowBegin();
            this.inserter.insert(rc);
            this.dataloader.sendRowComplete();
        }
        catch (SQLException e) {
            this.logError(rc, row, e.getMessage(), e);
            e.printStackTrace();
            this.dataloader.sendDataLoadError(e);
        }
    }

    private void logError(RowContainer rc, int row, String message, Throwable e) {
        this.failMetadata = true;
        this.lastMessage = message;
        Log.error("Error: table=" + this.dataloader.getCurrentTable() + ":" + message);
        Iterator<RowElement> i = rc.iterator();
        for (int j = 1; i.hasNext() && j <= 2; ++j) {
            RowElement re = i.next();
            Log.error("Failed column " + String.valueOf(j) + " name " + re.getName() + " value: " + re.getValue());
        }
    }

    public void close() {
    }

    @Override
    public void finishedProcessingRows() {
        try {
            this.inserter.executeBatch();
        }
        catch (SQLException e) {
            Log.error("Failed to execute batch statement", e);
        }
    }

    @Override
    public void processLeftOutRows() {
    }
}

