/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.Dataloader;

import com.primavera.database.common.DataDictionary;
import com.primavera.database.common.GenericDataTypes;
import com.primavera.database.common.container.SQLRowContainer;
import com.primavera.database.common.container.SQLRowInserter;
import com.primavera.database.common.container.XMLRowHandler;
import com.primavera.database.common.logging.Log;
import com.primavera.database.tools.Dataloader.Dataloader;
import com.primavera.database.tools.Dataloader.TableScrubber;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;

public class DBRowGenerator {
    private String m_sql = "";
    private String m_table = "";
    private TableScrubber m_scrubber = DBRowGenerator.createTableScrubber();
    private XMLRowHandler rowhandler = null;
    public SQLRowInserter inserter;
    public Dataloader dataldr;

    private static TableScrubber createTableScrubber() {
        TableScrubber scrubber = new TableScrubber();
        scrubber.addAllowEmptyString("VERSION_FSENTRY", "FSENTRY_NAME");
        scrubber.addAllowEmptyString("PRIMAREPFSENTRY", "FSENTRY_NAME");
        scrubber.addAllowEmptyString("PRIMACRFSENTRY", "FSENTRY_NAME");
        scrubber.addAllowEmptyString("LOCATION", "GEO_LOCATION");
        return scrubber;
    }

    public void setRowhandler(XMLRowHandler rowhandler) {
        this.rowhandler = rowhandler;
    }

    public XMLRowHandler getRowhandler() {
        return this.rowhandler;
    }

    public void setScrubber(TableScrubber scrubber) {
        this.m_scrubber = scrubber;
    }

    public void run(Connection sourceConn, Connection targetConn, String table) throws Exception {
        block9: {
            int row = 0;
            SQLRowInserter.batchRowCounter = 0;
            try {
                DataDictionary dd = new DataDictionary(sourceConn);
                if (!dd.tableExists(table)) {
                    // empty if block
                }
                if (this.m_sql.length() == 0 || !this.m_table.equalsIgnoreCase(table)) {
                    this.m_sql = "";
                    ArrayList<String> columns = dd.getColumns(table);
                    Iterator i = columns.iterator();
                    while (i.hasNext()) {
                        if (this.m_sql.length() == 0) {
                            this.m_sql = "SELECT " + (String)i.next();
                            continue;
                        }
                        this.m_sql = this.m_sql + "," + (String)i.next();
                    }
                    this.m_sql = this.m_sql + " FROM " + table;
                    this.m_table = table;
                }
                if (!this.m_scrubber.isExcluded(table)) {
                    Statement stmt = sourceConn.createStatement();
                    ResultSet rs = stmt.executeQuery(this.m_sql);
                    SQLRowContainer src = new SQLRowContainer(sourceConn, rs, table, this.m_scrubber);
                    this.rowhandler.processMetaData(src);
                    while (src.Next()) {
                        this.rowhandler.processRow(src, ++row);
                    }
                    if (SQLRowInserter.batchRowCounter > 0) {
                        this.rowhandler.processLeftOutRows();
                    }
                    rs.close();
                    stmt.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                Log.error(ex.getMessage(), ex);
                if (!ex.getMessage().contains("ORA-01000")) break block9;
                throw new RuntimeException(ex.getLocalizedMessage());
            }
        }
    }

    public static GenericDataTypes GenericDataTypeFromFieldType(String field_type, String sub_type) {
        if (field_type.compareToIgnoreCase("r8") == 0) {
            return GenericDataTypes.NUMBER;
        }
        if (field_type.compareToIgnoreCase("SQLdateTime") == 0) {
            return GenericDataTypes.DATE;
        }
        if (field_type.compareToIgnoreCase("i4") == 0) {
            return GenericDataTypes.INTEGER;
        }
        if (field_type.compareToIgnoreCase("bin.hex") == 0 && sub_type.compareToIgnoreCase("Text") == 0) {
            return GenericDataTypes.CLOB;
        }
        if (field_type.compareToIgnoreCase("bin.hex") == 0 && sub_type.compareToIgnoreCase("Binary") == 0) {
            return GenericDataTypes.BLOB;
        }
        return GenericDataTypes.STRING;
    }
}

