/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.DAFImporter;

import com.primavera.database.common.connection.ConnectStringParse;
import com.primavera.database.tools.DAFImporter.CommonMethods;
import com.primavera.database.tools.DAFImporter.DBOperationsInterface;
import com.primavera.database.tools.DatabaseToolException;
import java.sql.SQLException;
import java.util.Properties;

public class CreateOROperations
implements DBOperationsInterface {
    private static ConnectStringParse s_connectDBAsSystem = null;
    private static ConnectStringParse s_connectDBAsAdmuser = null;
    private static String s_connectFileLoad = null;
    private static String s_pmVersion = null;
    private static Properties s_properties = null;

    @Override
    public void doPreLoadOperations(String DAF_pmVersion) {
        try {
            CommonMethods.clearDB(s_connectDBAsSystem.getConnectstring(), "oracle", s_properties);
            if (s_pmVersion.startsWith("PPM")) {
                String sqlScript = "install/" + s_pmVersion + "/" + "orppm_init_db.sql";
                CommonMethods.runDB_Script(s_connectDBAsSystem.getConnectstring(), sqlScript, s_properties);
                sqlScript = "install/" + s_pmVersion + "/" + "orppm_create_users.sql";
                CommonMethods.runDB_Script(s_connectDBAsSystem.getConnectstring(), sqlScript, s_properties);
                sqlScript = DAF_pmVersion + "/" + "orpm_tables.sql";
                CommonMethods.runDB_Script(s_connectDBAsAdmuser.getConnectstring(), sqlScript, s_properties);
            } else {
                String sqlScript = "install/" + s_pmVersion + "/" + "orpm_init_db.sql";
                CommonMethods.runDB_Script(s_connectDBAsSystem.getConnectstring(), sqlScript, s_properties);
                sqlScript = "install/" + s_pmVersion + "/" + "orpm_create_users.sql";
                CommonMethods.runDB_Script(s_connectDBAsSystem.getConnectstring(), sqlScript, s_properties);
                sqlScript = DAF_pmVersion + "/" + "orpm_tables.sql";
                CommonMethods.runDB_Script(s_connectDBAsAdmuser.getConnectstring(), sqlScript, s_properties);
            }
        }
        catch (DatabaseToolException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void doPostLoadOperations(String DAF_pmVersion) {
        try {
            if (s_pmVersion.startsWith("PPM")) {
                String sqlScript = "or_set_currency.sql";
                CommonMethods.runDB_Script(s_connectDBAsAdmuser.getConnectstring(), sqlScript, s_properties);
                sqlScript = DAF_pmVersion + "/" + "orpm_ins_aux.sql";
                CommonMethods.runDB_Script(s_connectDBAsAdmuser.getConnectstring(), sqlScript, s_properties);
                sqlScript = "orpm_src.sql";
                CommonMethods.runDB_Script(s_connectDBAsAdmuser.getConnectstring(), sqlScript, s_properties);
                sqlScript = "install/" + s_pmVersion + "/" + "orppm_create_private_user.sql";
                CommonMethods.runDB_Script(s_connectDBAsAdmuser.getConnectstring(), sqlScript, s_properties);
            } else {
                String sqlScript = "or_set_currency.sql";
                CommonMethods.runDB_Script(s_connectDBAsAdmuser.getConnectstring(), sqlScript, s_properties);
                sqlScript = DAF_pmVersion + "/" + "orpm_ins_aux.sql";
                CommonMethods.runDB_Script(s_connectDBAsAdmuser.getConnectstring(), sqlScript, s_properties);
                sqlScript = "orpm_src.sql";
                CommonMethods.runDB_Script(s_connectDBAsAdmuser.getConnectstring(), sqlScript, s_properties);
                sqlScript = "install/" + s_pmVersion + "/" + "orpm_create_private_user.sql";
                CommonMethods.runDB_Script(s_connectDBAsAdmuser.getConnectstring(), sqlScript, s_properties);
                sqlScript = "install/" + s_pmVersion + "/" + "orpm_create_plus_users.sql";
                CommonMethods.runDB_Script(s_connectDBAsAdmuser.getConnectstring(), sqlScript, s_properties);
            }
        }
        catch (DatabaseToolException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public ConnectStringParse getAdminConnection() {
        return s_connectDBAsAdmuser;
    }

    @Override
    public String getDBName() {
        return "Not Applicable for Oracle.";
    }

    @Override
    public String getLoadFile() {
        return s_connectFileLoad;
    }

    @Override
    public ConnectStringParse getSystemConnection() {
        return s_connectDBAsSystem;
    }

    @Override
    public void setAdminConnection(String connectString) {
        s_connectDBAsAdmuser = new ConnectStringParse(connectString);
    }

    @Override
    public void setSystemConnection(String connectString, String sysUser, String sysPass) {
        s_connectDBAsSystem = new ConnectStringParse(CommonMethods.connectAsUser(connectString, sysUser, sysPass));
    }

    @Override
    public void setUp(String connectString, String connectFileString, String sysUsername, String sysPassword, String pmVersion) {
        this.setSystemConnection(connectString, sysUsername, sysPassword);
        this.setAdminConnection(connectString);
        s_pmVersion = pmVersion;
        s_connectFileLoad = connectFileString;
    }

    @Override
    public void setUpProperties(Properties extendedProperties) throws SQLException {
        s_properties = extendedProperties;
    }
}

