/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.common.connection;

import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import com.primavera.database.common.ServerType;
import com.primavera.database.common.connection.ConnectStringParse;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import oracle.jdbc.OracleDriver;

public class DatabaseConnection {
    public static final String ORACLE_ENCRYPTION_NAME = "oracle.net.ssl_cipher_suites";
    public static final String ORACLE_ENCRYPTION_VALUE = "(SSL_RSA_WITH_RC4_128_MD5, SSL_DH_anon_WITH_3DES_EDE_CBC_SHA, SSL_DH_anon_WITH_RC4_128_MD5, SSL_DH_anon_WITH_DES_CBC_SHA)";
    public static final String DB_DRV_USER = "user";
    public static final String DB_DRV_PASSWORD = "password";
    public static final String DB_TNS_ADMIN = "oracle.net.tns_admin";
    private Connection m_connection;
    private ServerType m_serverType;
    private String m_connectionString;
    private String m_url;
    private String m_username;
    private String m_password;
    private String m_server;
    private String m_database;
    private boolean m_useSSL = false;

    public DatabaseConnection() {
    }

    public DatabaseConnection(String connectstring) throws SQLException {
        this.setConnectionString(connectstring);
    }

    public void close() throws SQLException {
        if (this.m_connection != null && !this.m_connection.isClosed()) {
            this.m_connection.close();
        }
    }

    public Connection getConnection() {
        return this.m_connection;
    }

    public String getDatabase() {
        return this.m_database;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public String getServer() {
        return this.m_server;
    }

    public ServerType getServerType() {
        return this.m_serverType;
    }

    public String getUrl() {
        return this.m_url;
    }

    public String getUsername() {
        return this.m_username;
    }

    public void setUsername(String username) {
        this.m_username = username;
    }

    public String getConnectionString() {
        return this.m_connectionString;
    }

    public void setConnectionString(String connectionString) throws SQLException {
        Connection tempConn = null;
        this.m_connectionString = connectionString;
        ConnectStringParse parsedConnectionString = new ConnectStringParse(connectionString);
        String ssl = System.getenv("PRM_SSL_CONNECTION");
        if (ssl != null) {
            if ((ssl = ssl.toUpperCase()).startsWith("Y") || ssl.startsWith("T")) {
                this.m_useSSL = true;
                this.m_url = parsedConnectionString.getSSLDatabaseUrl();
            } else {
                this.m_url = parsedConnectionString.getDatabaseUrl();
            }
        } else {
            this.m_url = parsedConnectionString.getDatabaseUrl();
        }
        Properties connectionProps = new Properties();
        this.m_username = parsedConnectionString.getUsername();
        this.m_password = parsedConnectionString.getPassword();
        this.m_server = parsedConnectionString.getServer();
        this.m_database = parsedConnectionString.getDatabase();
        if (parsedConnectionString.getDbtype() == ServerType.ORACLE) {
            DriverManager.registerDriver((Driver)new OracleDriver());
            this.m_serverType = ServerType.ORACLE;
        } else if (parsedConnectionString.getDbtype() == ServerType.ORACLEATP) {
            DriverManager.registerDriver((Driver)new OracleDriver());
            this.m_serverType = ServerType.ORACLEATP;
        } else if (parsedConnectionString.getDbtype() == ServerType.SQLSERVER) {
            DriverManager.registerDriver((Driver)new SQLServerDriver());
            connectionProps.put("responseBuffering", "adaptive");
            this.m_serverType = ServerType.SQLSERVER;
        }
        this.close();
        connectionProps.put(DB_DRV_USER, this.m_username);
        connectionProps.put(DB_DRV_PASSWORD, this.m_password);
        if (this.m_useSSL && this.m_serverType != ServerType.ORACLEATP) {
            connectionProps.put(ORACLE_ENCRYPTION_NAME, ORACLE_ENCRYPTION_VALUE);
            tempConn = DriverManager.getConnection(this.m_url, connectionProps);
        } else {
            if (this.m_serverType == ServerType.ORACLEATP) {
                connectionProps.put(DB_TNS_ADMIN, this.getConfigFile(this.m_connectionString));
            }
            tempConn = DriverManager.getConnection(this.m_url, connectionProps);
        }
        this.m_connection = tempConn;
        this.postConnection();
    }

    public void setConnection(Connection conn, ServerType type) {
        this.m_connection = conn;
        this.m_serverType = type;
    }

    private void postConnection() throws SQLException {
        if (this.m_serverType == ServerType.SQLSERVER) {
            Statement stmt = this.m_connection.createStatement();
            stmt.execute("set language english");
        }
    }

    public boolean isUseSSL() {
        return this.m_useSSL;
    }

    public void setUseSSL(boolean m_usessl) {
        this.m_useSSL = m_usessl;
    }

    public String getConfigFile(String connectionString) {
        String configFile = "";
        try {
            int startIndex = connectionString.indexOf("oracle_atp:");
            int endIndex = connectionString.lastIndexOf(":");
            configFile = connectionString.substring(startIndex + "oracle_atp:".length(), endIndex);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while retriving config file name");
        }
        return configFile;
    }
}

