/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.common.connection;

import com.primavera.database.common.ServerType;
import com.primavera.database.common.connection.DSType;
import java.util.StringTokenizer;

public class ConnectStringParse {
    private String m_connectstring;
    private String m_username;
    private String m_password;
    private String m_server;
    private String m_port;
    private String m_database;
    private ServerType m_servertype;
    private String m_filename;
    private DSType m_connectionType;
    private String m_sampleString;
    private String m_databaseURL = "";
    private String m_databaseWalletLocation = "";
    private boolean m_bIsOracleServiceName = false;
    private boolean m_isSysDBA = false;

    public ConnectStringParse(String connectionString) {
        this.setConnectstring(connectionString);
    }

    public String getConnectstring() {
        return this.m_connectstring;
    }

    public void clear() {
        this.m_connectstring = "";
        this.m_username = "";
        this.m_password = "";
        this.m_server = "";
        this.m_port = "";
        this.m_database = "";
        this.m_servertype = null;
        this.m_filename = "";
        this.m_connectionType = null;
        this.m_databaseURL = "";
    }

    public static String extractProductVersion(String name) {
        int pos = name.indexOf("_");
        if (pos == -1) {
            pos = name.indexOf(".");
        }
        if (pos < 0) {
            return "";
        }
        String ver = name.substring(0, pos).toUpperCase();
        if ("PMDB".equalsIgnoreCase(ver)) {
            ver = "PM";
        } else if ("MMDB".equalsIgnoreCase(ver)) {
            ver = "MM";
        } else if ("PPMDB".equalsIgnoreCase(ver)) {
            ver = "PPM";
        }
        return ver;
    }

    public void setConnectstring(String connectstring) {
        this.clear();
        this.m_connectstring = connectstring;
        if (connectstring.toLowerCase().startsWith("file:")) {
            this.m_filename = connectstring.substring(5);
            this.m_connectionType = DSType.FILE;
            return;
        }
        if (connectstring.toLowerCase().startsWith("sample:")) {
            this.m_sampleString = connectstring.substring(connectstring.indexOf(":") + 1, connectstring.length());
            this.m_connectionType = DSType.SAMPLE;
            return;
        }
        this.m_connectionType = DSType.DATABASE;
        int slash = connectstring.indexOf(47);
        int at = connectstring.lastIndexOf(64);
        this.m_username = slash > 0 ? connectstring.substring(0, slash) : (at > 0 ? connectstring.substring(0, at) : "");
        String[] fullUserName = this.m_username.split(":");
        if (fullUserName.length == 2 && fullUserName[1].toUpperCase().equals("SYSDBA")) {
            this.m_username = fullUserName[0];
            this.m_isSysDBA = true;
        }
        this.m_password = slash > 0 ? (at > 0 ? connectstring.substring(slash + 1, at) : connectstring.substring(slash + 1)) : "";
        if (at > 0) {
            String dbinfo = connectstring.substring(at + 1);
            StringTokenizer st = new StringTokenizer(dbinfo, ":/");
            this.m_servertype = st.hasMoreTokens() ? ConnectStringParse.translateDatabaseType(st.nextToken()) : null;
            if (st.hasMoreTokens()) {
                String next = st.nextToken();
                if ("URL".equalsIgnoreCase(next)) {
                    String token = "";
                    while (st.hasMoreTokens()) {
                        this.m_databaseURL = this.m_databaseURL + token + st.nextToken();
                        token = ":";
                    }
                } else if (this.m_servertype.equals((Object)ServerType.ORACLEATP)) {
                    this.m_server = "";
                    this.m_database = connectstring.substring(connectstring.lastIndexOf(":") + 1, connectstring.length());
                    this.m_databaseWalletLocation = connectstring.substring(connectstring.indexOf("oracle_atp:") + "oracle_atp:".length(), connectstring.lastIndexOf(":"));
                } else {
                    this.m_server = next;
                }
            } else {
                this.m_server = "";
            }
            if (st.hasMoreTokens()) {
                String third = st.nextToken();
                if (this.m_servertype.equals((Object)ServerType.ORACLEATP)) {
                    this.m_port = "";
                } else if (st.hasMoreElements()) {
                    this.m_port = third;
                    this.m_database = st.nextToken();
                } else {
                    this.m_database = third;
                    this.m_port = this.m_servertype == null ? "9999" : Integer.toString(this.m_servertype.getDefaultPortNumber());
                }
                if (this.m_servertype == ServerType.ORACLE && this.m_database.length() > 0 && dbinfo.charAt(dbinfo.length() - this.m_database.length() - 1) == '/') {
                    this.m_bIsOracleServiceName = true;
                }
            }
        }
    }

    private static ServerType translateDatabaseType(String dbtype) {
        if (dbtype.compareToIgnoreCase("SQLSERVER") == 0 || dbtype.compareToIgnoreCase("SS") == 0) {
            return ServerType.SQLSERVER;
        }
        if (dbtype.compareToIgnoreCase("ORACLE") == 0 || dbtype.compareToIgnoreCase("OR") == 0) {
            return ServerType.ORACLE;
        }
        if (dbtype.compareToIgnoreCase("ORACLE_ATP") == 0 || dbtype.compareToIgnoreCase("OR_ATP") == 0) {
            return ServerType.ORACLEATP;
        }
        return null;
    }

    public String getDatabase() {
        return this.m_database;
    }

    public String getDatabaseWalletLocation() {
        return this.m_databaseWalletLocation;
    }

    public String getPassword() {
        return this.m_password;
    }

    public String getPort() {
        return this.m_port;
    }

    public String getServer() {
        return this.m_server;
    }

    public String getUsername() {
        if (this.m_isSysDBA) {
            return this.m_username + " as sysdba";
        }
        return this.m_username;
    }

    public ServerType getDbtype() {
        return this.m_servertype;
    }

    public String getDatabaseUrl() {
        if (this.m_databaseURL != "") {
            return this.m_databaseURL;
        }
        if (this.m_connectionType == DSType.DATABASE) {
            if (this.m_servertype == ServerType.ORACLE) {
                return "jdbc:oracle:thin:@" + this.m_server + ":" + this.m_port + (this.m_bIsOracleServiceName ? "/" : ":") + this.m_database;
            }
            if (this.m_servertype == ServerType.SQLSERVER) {
                return "jdbc:sqlserver://" + this.m_server + ":" + this.m_port + ";database=" + this.m_database;
            }
            if (this.m_servertype == ServerType.ORACLEATP) {
                return "jdbc:oracle:thin:@" + this.m_database;
            }
            return "";
        }
        return "";
    }

    public String getSSLDatabaseUrl() {
        if (this.m_databaseURL != "") {
            return this.m_databaseURL;
        }
        if (this.m_connectionType == DSType.DATABASE) {
            if (this.m_servertype == ServerType.ORACLE) {
                return String.format("jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=tcps)(HOST=%s)(PORT=%s))(CONNECT_DATA=(%s=%s)))", this.m_server, this.m_port, this.m_bIsOracleServiceName ? "SERVICE_NAME" : "SID", this.m_database);
            }
            return "";
        }
        return "";
    }

    public DSType getConnectionType() {
        return this.m_connectionType;
    }

    public String getFilename() {
        return this.m_filename;
    }

    public String getSampleString() {
        return this.m_sampleString;
    }

    public String getConnectstringForDisplay() {
        String displayString = "";
        if (this.getConnectionType() == DSType.FILE || this.getConnectionType() == DSType.SAMPLE) {
            displayString = this.getConnectstring();
        }
        if (this.getConnectionType() == DSType.DATABASE) {
            displayString = this.getUsername() + "/" + "*********" + this.getConnectstring().substring(this.getConnectstring().lastIndexOf("@"));
        }
        return displayString;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("{");
        sbuf.append("USERNAME:" + this.m_username);
        sbuf.append(" ");
        sbuf.append("PASSWORD:" + this.m_password);
        sbuf.append(" ");
        sbuf.append("HOSTNAME:" + this.m_server);
        sbuf.append(" ");
        sbuf.append("SERVERTYPE:" + (Object)((Object)this.m_servertype));
        sbuf.append(" ");
        sbuf.append("PORT:" + this.m_port);
        sbuf.append(" ");
        sbuf.append("DATABSE:" + this.m_database);
        sbuf.append("}");
        return sbuf.toString();
    }

    public boolean isOracleService() {
        return this.m_bIsOracleServiceName;
    }

    public boolean isSysDBA() {
        return this.m_isSysDBA;
    }
}

