/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PropertiesFileManager {
    private PropertiesFileManager() {
    }

    public static Properties getProperties(String propertiesPath) throws IOException {
        return PropertiesFileManager.getProperties(propertiesPath, ClassLoader.getSystemClassLoader());
    }

    public static Properties getUserProperties(String propertiesPath) throws IOException {
        File userHome = new File(System.getProperty("user.home"));
        File userPdbmsDir = new File(userHome.getCanonicalPath() + File.separator + ".dbmt");
        if (!userPdbmsDir.exists()) {
            userPdbmsDir.mkdir();
        }
        File propertyFile = new File(userPdbmsDir.getCanonicalPath() + File.separator + propertiesPath.replace('/', File.separatorChar));
        Properties prop = new Properties();
        if (propertyFile.exists()) {
            prop.load(new FileInputStream(propertyFile));
        }
        return prop;
    }

    public static Properties getProperties(String propertiesPath, ClassLoader clsLoader) throws IOException {
        Properties prop = new Properties();
        InputStream propertyStream = ClassLoader.getSystemResourceAsStream(propertiesPath);
        if (propertyStream == null) {
            System.err.println("Unable to find the property file " + propertiesPath);
            return prop;
        }
        prop.load(propertyStream);
        return prop;
    }

    public static interface PropRetriever {
        public Properties loadProperties(String var1) throws IOException;
    }

    public static enum Retriever implements PropRetriever
    {
        DEFAULT_RETRIEVER{

            @Override
            public Properties loadProperties(String propertiesPath) throws IOException {
                return PropertiesFileManager.getProperties(propertiesPath);
            }
        }
        ,
        SYSTEM_RETRIEVER{

            @Override
            public Properties loadProperties(String propertiesPath) throws IOException {
                return new Properties();
            }
        }
        ,
        USER_RETRIEVER{

            @Override
            public Properties loadProperties(String propertiesPath) throws IOException {
                return PropertiesFileManager.getUserProperties(propertiesPath);
            }
        };

    }
}

