/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.common;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.StringTokenizer;

public class ProductVersion
implements Comparable<ProductVersion> {
    private static final NumberFormat VERSION_FORMATTER = new DecimalFormat("00");
    private int m_major;
    private int m_minor;
    private int m_release;

    public int hashCode() {
        long hash = 0L;
        hash += (long)this.m_major;
        hash += (long)(100 + this.m_minor);
        return (int)((hash += (long)(10000 + this.m_release)) % Integer.MAX_VALUE);
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof ProductVersion) {
            ProductVersion ver = (ProductVersion)arg0;
            if (this.m_major != ver.m_major) {
                return false;
            }
            if (this.m_minor != ver.m_minor) {
                return false;
            }
            return this.m_release == ver.m_release;
        }
        return false;
    }

    public ProductVersion(int major, int minor, int release) {
        this.m_major = major;
        this.m_minor = minor;
        this.m_release = release;
    }

    public final int getMajor() {
        return this.m_major;
    }

    public final void setMajor(int major) {
        this.m_major = major;
    }

    public final int getMinor() {
        return this.m_minor;
    }

    public final void setMinor(int minor) {
        this.m_minor = minor;
    }

    public final int getRelease() {
        return this.m_release;
    }

    public final void setRelease(int release) {
        this.m_release = release;
    }

    @Override
    public int compareTo(ProductVersion version) {
        if (this.m_major != version.m_major) {
            return this.m_major - version.m_major;
        }
        if (this.m_minor != version.m_minor) {
            return this.m_minor - version.m_minor;
        }
        if (this.m_release != version.m_release) {
            return this.m_release - version.m_release;
        }
        return 0;
    }

    public static String format(int number) {
        return VERSION_FORMATTER.format(number);
    }

    public String toString() {
        return ProductVersion.format(this.m_major) + "_" + ProductVersion.format(this.m_minor) + "_" + ProductVersion.format(this.m_release);
    }

    public static ProductVersion fromString(String versionString) {
        StringTokenizer stok = new StringTokenizer(versionString, ".");
        String maj = stok.nextToken();
        String min = stok.nextToken();
        String rel = stok.nextToken();
        return new ProductVersion(Integer.parseInt(maj), Integer.parseInt(min), Integer.parseInt(rel));
    }
}

