/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestingXMLHelper {
    private static Document xmldoc;
    public static boolean debug;

    public static Element createFieldElement(String field_name, String field_type, String width, String sub_type) {
        Element e = xmldoc.createElement("FIELD");
        e.setAttribute("attrname", field_name);
        e.setAttribute("fieldtype", field_type);
        if (width != null) {
            e.setAttribute("WIDTH", width);
        }
        if (sub_type != null) {
            e.setAttribute("SUBTYPE", sub_type);
        }
        return e;
    }

    public static Document getTestTableSmall() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        xmldoc = db.newDocument();
        Element root = xmldoc.createElement("DATAPACKET");
        root.setAttribute("Version", "2.0");
        Element metadata = xmldoc.createElement("METADATA");
        Element fields = xmldoc.createElement("FIELDS");
        fields.appendChild(TestingXMLHelper.createFieldElement("INTCOL", "i4", null, null));
        fields.appendChild(TestingXMLHelper.createFieldElement("VARCOL", "string", "40", null));
        fields.appendChild(TestingXMLHelper.createFieldElement("DATECOL", "SQLdateTime", null, "Formatted"));
        fields.appendChild(TestingXMLHelper.createFieldElement("NUMCOL", "r8", null, null));
        fields.appendChild(TestingXMLHelper.createFieldElement("MEMOCOL", "bin.hex", "1", "Binary"));
        metadata.appendChild(fields);
        root.appendChild(metadata);
        Element rowdata = xmldoc.createElement("ROWDATA");
        Element row = xmldoc.createElement("ROW");
        row.setAttribute("INTCOL", "101");
        row.setAttribute("VARCOL", "FOO STRING DATA");
        rowdata.appendChild(row);
        row = xmldoc.createElement("ROW");
        row.setAttribute("INTCOL", "201");
        row.setAttribute("VARCOL", "Another string data row");
        rowdata.appendChild(row);
        root.appendChild(rowdata);
        xmldoc.appendChild(root);
        if (debug) {
            OutputFormat of = new OutputFormat("XML", "ISO-8859-1", true);
            of.setIndent(1);
            of.setIndenting(true);
            XMLSerializer serializer = new XMLSerializer((OutputStream)System.out, of);
            try {
                serializer.asDOMSerializer();
                serializer.serialize(xmldoc.getDocumentElement());
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
        return xmldoc;
    }

    public static void saveXMLToFile(Document xmldoc, String filename) throws Exception {
        OutputFormat of = new OutputFormat("XML", "ISO-8859-1", true);
        of.setIndent(1);
        of.setIndenting(true);
        FileOutputStream fos = new FileOutputStream(filename);
        XMLSerializer serializer = new XMLSerializer((OutputStream)fos, of);
        serializer.asDOMSerializer();
        serializer.serialize(xmldoc.getDocumentElement());
        fos.close();
    }

    static {
        debug = true;
    }
}

