/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database;

import com.primavera.database.common.DatabaseSyntaxHelper;
import com.primavera.database.common.GenericDataTypes;
import com.primavera.database.common.ServerType;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.sql.BLOB;

public class TestingDataHelper {
    private static String repeat(String s, int r) {
        String newstr = new String();
        for (int i = 0; i < r; ++i) {
            newstr = newstr + s;
        }
        return newstr;
    }

    private static String getTestTable(ServerType servertype, String name) {
        return new String("create table " + name + "(intcol " + DatabaseSyntaxHelper.getPhysicalDataType(GenericDataTypes.INTEGER, servertype) + " null" + ", varcol " + DatabaseSyntaxHelper.getPhysicalDataType(GenericDataTypes.STRING, servertype) + "(100)" + " null" + ", datecol " + DatabaseSyntaxHelper.getPhysicalDataType(GenericDataTypes.DATE, servertype) + " null" + ", numcol " + DatabaseSyntaxHelper.getPhysicalDataType(GenericDataTypes.NUMBER, servertype) + "(17,6)" + " null" + ", memocol " + DatabaseSyntaxHelper.getPhysicalDataType(GenericDataTypes.MEMO, servertype) + " null" + ")");
    }

    public static void dropTestingTable(Connection conn, String name) {
        try {
            Statement stmt = conn.createStatement();
            stmt.execute("drop table " + name);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void createTestingTable(Connection conn, ServerType servertype, String name) throws SQLException {
        TestingDataHelper.dropTestingTable(conn, name);
        Statement stmt = conn.createStatement();
        String sql = TestingDataHelper.getTestTable(servertype, name);
        stmt.execute(sql);
    }

    public static void createTestingTableWithData(Connection conn, ServerType servertype, String name) throws SQLException {
        TestingDataHelper.createTestingTable(conn, servertype, name);
        TestingDataHelper.createTestingBaseData(conn, servertype, name);
    }

    public static void createTestingBaseData(Connection conn, ServerType servertype, String name) throws SQLException {
        String sql = "insert into " + name + "(intcol,varcol,datecol,numcol,memocol) values ";
        if (servertype == ServerType.ORACLE) {
            sql = sql + "(?,?,to_date(?,'yyyy-MM-dd HH24:mi:ss'),?,empty_blob()) ";
        } else if (servertype == ServerType.SQLSERVER || servertype == ServerType.SYBASE) {
            sql = sql + "(?,?,convert(datetime,?,20),?,?) ";
        }
        PreparedStatement ps = conn.prepareStatement(sql);
        ps.setInt(1, 100);
        ps.setString(2, "Variable String One <first>");
        ps.setString(3, "2001-01-22 22:22:22");
        ps.setDouble(4, 5212.21);
        String memo = "<HTML>" + TestingDataHelper.repeat("Prima", 1000).substring(1, 4988) + "</HTML>";
        if (servertype != ServerType.ORACLE) {
            ps.setString(5, memo);
        }
        ps.executeUpdate();
        if (servertype == ServerType.ORACLE) {
            TestingDataHelper.writeBlobToOracle(conn, "select memocol from " + name + " where intcol = 100", memo);
        }
        ps.setInt(1, 101);
        ps.setString(2, "Variable String Two <first>");
        ps.setString(3, "2002-5-22 22:22:22");
        ps.setDouble(4, 0.2121);
        memo = "<HTML>" + TestingDataHelper.repeat("Prima", 2000).substring(1, 9988) + "</HTML>";
        if (servertype != ServerType.ORACLE) {
            ps.setString(5, memo);
        }
        ps.executeUpdate();
        if (servertype == ServerType.ORACLE) {
            TestingDataHelper.writeBlobToOracle(conn, "select memocol from " + name + " where intcol = 101", memo);
        }
    }

    private static void writeBlobToOracle(Connection conn, String sql, String sBlob) throws SQLException {
        Statement stmt;
        ResultSet rs;
        if (!sql.contains("for update")) {
            sql = sql + " for update";
        }
        if ((rs = (stmt = conn.createStatement()).executeQuery(sql)).next()) {
            BLOB blob = (BLOB)rs.getBlob(1);
            int chunk = blob.getChunkSize();
            byte[] buffer = new byte[chunk];
            BufferedOutputStream os = null;
            ByteArrayInputStream is = null;
            try {
                int length;
                os = new BufferedOutputStream(blob.getBinaryOutputStream());
                is = new ByteArrayInputStream(sBlob.getBytes());
                while ((length = is.read(buffer)) != -1) {
                    ((OutputStream)os).write(buffer, 0, length);
                }
                ((OutputStream)os).flush();
                ((OutputStream)os).close();
                ((InputStream)is).close();
            }
            catch (IOException ex) {
                throw new SQLException(ex.getMessage());
            }
            finally {
                rs.close();
                stmt.close();
                if (!conn.getAutoCommit()) {
                    conn.commit();
                }
            }
        }
    }
}

