/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.common.filterparser.tree;

import com.primavera.common.bo.DBType;
import com.primavera.common.filterparser.tree.FunctionStatement;
import java.util.Iterator;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class IsUnderSQLGenerator {
    private IsUnderSQLGenerator() {
    }

    public static String generateSQL(DBType dBType, FunctionStatement functionStatement) {
        FieldInfo fieldInfo = IsUnderSQLGenerator.getFieldInfo(functionStatement);
        switch (dBType) {
            case Oracle: {
                return IsUnderSQLGenerator.a(fieldInfo, functionStatement);
            }
            case SqlServer: {
                return IsUnderSQLGenerator.if(fieldInfo, functionStatement);
            }
        }
        return null;
    }

    private static String a(FieldInfo fieldInfo, FunctionStatement functionStatement) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select * from TABLE(GET_HIERARCHY_CHILDREN('").append(fieldInfo.logicalFilterFieldName).append("','").append(fieldInfo.childFieldName).append("','");
        stringBuilder.append(fieldInfo.parentFieldName).append("','").append(fieldInfo.tableName).append("',").append(fieldInfo.filterValue).append("))");
        return stringBuilder.toString();
    }

    public static String getInClauseField(FieldInfo fieldInfo) {
        String string = fieldInfo.logicalFilterFieldName;
        if ((string = string.replace('\'', ' ').trim()).matches("((ActivityCodeType)|(EPSActivityCodeType)|(ProjectActivityCodeType))(Id)?[_:][0-9]+") || string.matches("(ProjectCode)(Id)?[_:][0-9]+") || string.matches("(ResourceCodeType)(Id)?[_:][0-9]+") || string.equalsIgnoreCase("ParentWbsId")) {
            return string;
        }
        return fieldInfo.childFieldName;
    }

    public static FieldInfo getFieldInfo(FunctionStatement functionStatement) {
        FieldInfo fieldInfo = new FieldInfo();
        List<String> list = functionStatement.getParameters();
        Iterator<String> iterator = list.iterator();
        if (iterator.hasNext()) {
            fieldInfo.logicalFilterFieldName = iterator.next();
        }
        if (iterator.hasNext()) {
            fieldInfo.parentFieldName = iterator.next();
        }
        if (iterator.hasNext()) {
            fieldInfo.childFieldName = iterator.next();
        }
        if (iterator.hasNext()) {
            fieldInfo.tableName = iterator.next();
        }
        if (iterator.hasNext()) {
            fieldInfo.filterValue = iterator.next();
        }
        return fieldInfo;
    }

    private static String if(FieldInfo fieldInfo, FunctionStatement functionStatement) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select * from GET_HIERARCHY_CHILDREN('" + fieldInfo.tableName + "'," + fieldInfo.filterValue + ")");
        return stringBuilder.toString();
    }

    public static class FieldInfo {
        public String logicalFilterFieldName;
        public String childFieldName;
        public String parentFieldName;
        public String tableName;
        public String filterValue;
    }
}

