/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.xml.util.workflow.nodes;

import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.actions.ParameterizedJobFactory;
import com.primavera.database.tools.dbmt.workflow.StepData;
import com.primavera.database.tools.dbmt.xml.util.NodeHandler;
import com.primavera.database.tools.dbmt.xml.util.workflow.AbstractStepContainerNode;
import com.primavera.database.tools.dbmt.xml.util.workflow.WorkflowSchemaSubNode;
import com.primavera.database.tools.dbmt.xml.util.workflow.nodes.CallNode;
import com.primavera.database.tools.dbmt.xml.util.workflow.nodes.ConnectionNode;
import com.primavera.database.tools.dbmt.xml.util.workflow.nodes.CustomColumnsNode;
import com.primavera.database.tools.dbmt.xml.util.workflow.nodes.DatapumpNode;
import com.primavera.database.tools.dbmt.xml.util.workflow.nodes.DescriptionNode;
import com.primavera.database.tools.dbmt.xml.util.workflow.nodes.ParameterNode;
import com.primavera.database.tools.dbmt.xml.util.workflow.nodes.ScriptNode;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class StepNode
extends WorkflowSchemaSubNode<AbstractStepContainerNode<?>> {
    private final String m_name;
    private final String m_condition;
    private final String m_maxVersion;
    private String m_connectionType = ConnectionClass.ADMINISTRATIVE.toString();
    private final List<ParameterizedJobFactory<?>> m_jobs = new ArrayList();

    public StepNode(AbstractStepContainerNode<?> parent, Attributes attr) {
        super(parent, "step", attr);
        this.m_name = attr.getValue("name");
        this.m_condition = attr.getValue("condition");
        this.m_maxVersion = attr.getValue("maxversion");
    }

    @Override
    public NodeHandler nextNode(String elemName, Attributes attr) {
        if ("description".equals(elemName)) {
            return new DescriptionNode(this, attr);
        }
        if ("connection".equals(elemName)) {
            return new ConnectionNode(this, attr);
        }
        if ("parameter".equals(elemName)) {
            return new ParameterNode(this, attr);
        }
        if ("script".equals(elemName)) {
            return new ScriptNode(this, attr);
        }
        if ("call".equals(elemName)) {
            return new CallNode(this, attr);
        }
        if ("datapump".equals(elemName)) {
            return new DatapumpNode(this, attr);
        }
        if ("customcolumns".equals(elemName)) {
            return new CustomColumnsNode(this, attr);
        }
        return super.nextNode(elemName, attr);
    }

    @Override
    public String getPropertyIdPath() {
        return super.getPropertyIdPath() + "." + this.m_name;
    }

    @Override
    public void onEnd() throws SAXException {
        StepData data = new StepData(this.m_connectionType, this.getPropertyIdPath() + ".desc");
        data.setConditionKey(this.m_condition);
        data.setMaxVersion(this.m_maxVersion);
        for (ParameterizedJobFactory<?> job : this.m_jobs) {
            data.addJob(job);
        }
        ((AbstractStepContainerNode)this.getParent()).addStepData(data);
    }

    public final void addJobFactory(ParameterizedJobFactory<?> job) {
        this.m_jobs.add(job);
    }

    public final void setConnectionType(String loginType) {
        this.m_connectionType = loginType;
    }

    public final ConnectionClass getConnectionType() {
        return ConnectionClass.fromString(this.m_connectionType);
    }
}

