/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.xml.util.propgen.workflow;

import com.primavera.database.tools.dbmt.xml.util.NodeHandler;
import com.primavera.database.tools.dbmt.xml.util.PropNode;
import com.primavera.database.tools.dbmt.xml.util.PropertyRoot;
import com.primavera.database.tools.dbmt.xml.util.RecursiveNoOpNode;
import com.primavera.database.tools.dbmt.xml.util.SubNodeAdapter;
import com.primavera.database.tools.dbmt.xml.util.propgen.workflow.DatabaseCreationNode;
import com.primavera.database.tools.dbmt.xml.util.propgen.workflow.DatabaseOperationNode;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SchemaNode
extends SubNodeAdapter
implements PropertyRoot,
PropNode {
    private final String m_name;
    private final String m_version;
    private final PrintStream m_out;
    private final Map<String, String> m_propertyMap = new HashMap<String, String>();

    public SchemaNode(Attributes attr, PrintStream out) {
        super("schema", attr);
        this.m_name = attr.getValue("name");
        this.m_version = attr.getValue("version");
        this.m_out = out;
    }

    @Override
    public NodeHandler nextNode(String elemName, Attributes attr) {
        if ("install".equals(elemName) || "upgrade".equals(elemName) || "pre-migrate".equals(elemName) || "post-migrate".equals(elemName) || "schema-migrate".equals(elemName) || "keystore".equals(elemName)) {
            return new DatabaseOperationNode(this, elemName, attr);
        }
        if ("create".equals(elemName)) {
            return new DatabaseCreationNode(this, attr);
        }
        return new RecursiveNoOpNode(this, elemName, attr);
    }

    @Override
    public String getPropertyRoot() {
        return "schema." + this.m_name + "." + this.m_version;
    }

    public PrintStream getOut() {
        return this.m_out;
    }

    @Override
    public String path() {
        return "/schema";
    }

    @Override
    public void addProperty(String key, String value) {
        this.m_propertyMap.put(key, value);
    }

    @Override
    public void onEnd() throws SAXException {
        for (Map.Entry<String, String> entry : this.m_propertyMap.entrySet()) {
            this.m_out.println(entry.getKey() + "=" + entry.getValue());
        }
    }
}

