/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.xml.util.propgen.actions;

import com.primavera.database.tools.dbmt.xml.util.NodeHandler;
import com.primavera.database.tools.dbmt.xml.util.propgen.FieldContainer;
import com.primavera.database.tools.dbmt.xml.util.propgen.PropSubNode;
import com.primavera.database.tools.dbmt.xml.util.propgen.actions.TextSubstitutionNode;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TextNode
extends PropSubNode<FieldContainer> {
    private final List<String> m_textPieces = new ArrayList<String>();
    private int m_nextPlaceholderIndex = 0;
    private final String m_id;

    public TextNode(FieldContainer parent, Attributes attr) {
        super(parent, "text", attr);
        this.m_id = attr.getValue("id");
    }

    @Override
    public NodeHandler nextNode(String elemName, Attributes attr) {
        if ("subst".equals(elemName)) {
            return new TextSubstitutionNode(this, attr);
        }
        return super.nextNode(elemName, attr);
    }

    public void addPlaceholder() {
        this.m_textPieces.add("{" + this.m_nextPlaceholderIndex + "}");
        ++this.m_nextPlaceholderIndex;
    }

    @Override
    public void onContent(char[] ch, int start, int length) {
        String contentString = new String(ch).substring(start, start + length);
        this.m_textPieces.add(contentString);
    }

    @Override
    public void onEnd() throws SAXException {
        String compositedString = TextNode.createCompositedString(this.m_textPieces);
        this.addProperty(((FieldContainer)this.getParent()).getPropertyPrefix() + ".txt." + this.m_id, compositedString);
    }

    private static String createCompositedString(List<String> textPieces) {
        StringBuffer sbuf = new StringBuffer();
        for (String part : textPieces) {
            sbuf.append(part);
        }
        return sbuf.toString();
    }
}

