/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.xml.util.menu.nodes;

import com.primavera.database.tools.dbmt.gui.MenuDefinition;
import com.primavera.database.tools.dbmt.xml.util.NodeHandler;
import com.primavera.database.tools.dbmt.xml.util.SubNode;
import com.primavera.database.tools.dbmt.xml.util.menu.MenuContainer;
import com.primavera.database.tools.dbmt.xml.util.menu.nodes.ItemNode;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SubMenuNode
extends SubNode<MenuContainer>
implements MenuContainer {
    private final List<MenuDefinition.MenuItemFactory> m_items = new ArrayList<MenuDefinition.MenuItemFactory>();
    private final String m_id;

    public SubMenuNode(MenuContainer parent, Attributes attr) {
        super(parent, "subnode", attr);
        this.m_id = attr.getValue("id");
    }

    @Override
    public void addItem(MenuDefinition.MenuItemFactory itemFactory) {
        this.m_items.add(itemFactory);
    }

    @Override
    public NodeHandler nextNode(String elemName, Attributes attr) {
        if ("submenu".equals(elemName)) {
            return new SubMenuNode(this, attr);
        }
        if ("item".equals(elemName)) {
            return new ItemNode(this, attr);
        }
        return super.nextNode(elemName, attr);
    }

    @Override
    public void onEnd() throws SAXException {
        MenuDefinition.SubMenuItemFactory factory = new MenuDefinition.SubMenuItemFactory(this.getNameKey(), this.getDescKey());
        for (MenuDefinition.MenuItemFactory itemFactory : this.m_items) {
            factory.addChild(itemFactory);
        }
        ((MenuContainer)this.getParent()).addItem(factory);
    }

    private String getNameKey() {
        return this.getPropertyRoot() + ".name";
    }

    private String getDescKey() {
        return this.getPropertyRoot() + ".desc";
    }

    @Override
    public String getPropertyRoot() {
        return ((MenuContainer)this.getParent()).getPropertyRoot() + "." + this.m_id;
    }
}

