/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.xml.util.actions.nodes;

import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.actions.FieldTester;
import com.primavera.database.tools.dbmt.actions.InteractorData;
import com.primavera.database.tools.dbmt.actions.InvalidDialogField;
import com.primavera.database.tools.dbmt.actions.tests.TestOp;
import com.primavera.database.tools.dbmt.xml.util.NodeHandler;
import com.primavera.database.tools.dbmt.xml.util.SubNode;
import com.primavera.database.tools.dbmt.xml.util.actions.TestContainerInterface;
import com.primavera.database.tools.dbmt.xml.util.actions.nodes.FieldNode;
import com.primavera.database.tools.dbmt.xml.util.actions.nodes.ParamNode;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;

public class TestNode
extends SubNode<TestContainerInterface> {
    private final String m_testClass;
    private final List<String> m_fields = new ArrayList<String>();
    private final List<String> m_params = new ArrayList<String>();

    public TestNode(TestContainerInterface parent, Attributes attr) {
        super(parent, "test", attr);
        this.m_testClass = attr.getValue("class");
    }

    public void addField(String fieldName) {
        this.m_fields.add(fieldName);
    }

    public void addParam(String paramName) {
        this.m_params.add(paramName);
    }

    @Override
    public NodeHandler nextNode(String elemName, Attributes attr) {
        if ("field".equals(elemName)) {
            return new FieldNode(this, attr);
        }
        if ("param".equals(elemName)) {
            return new ParamNode(this, attr);
        }
        return super.nextNode(elemName, attr);
    }

    @Override
    public void onEnd() {
        ((TestContainerInterface)this.getParent()).addTest(new FieldTester(this.getTestOp(), this.m_fields, this.m_params, null));
    }

    private TestOp getTestOp() {
        try {
            Class<?> testClass = Class.forName(this.m_testClass);
            Object testObj = testClass.newInstance();
            if (testObj instanceof TestOp) {
                return (TestOp)testObj;
            }
            DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.action.testfactory.notsubclass", new String[]{this.m_testClass, TestOp.class.getName()}));
        }
        catch (ClassNotFoundException e) {
            DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.action.testfactory.classnotfound", new String[]{this.m_testClass}));
        }
        catch (InstantiationException e) {
            DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.action.testfactory.cantinstantiate", new String[]{this.m_testClass}));
        }
        catch (IllegalAccessException e) {
            DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.action.testfactory.illegalaccess", new String[]{this.m_testClass}));
        }
        return new TestOp(){

            @Override
            public boolean validate(Object context, InteractorData data, List<String> fieldIds, List<String> params) {
                return true;
            }

            @Override
            public String[] reasonParams(InteractorData data, List<String> fieldIds, List<String> params) throws InvalidDialogField {
                return new String[0];
            }
        };
    }
}

