/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.workflow;

import com.primavera.database.common.job.Job;
import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.tools.dbmt.DBMTPropertySets;
import com.primavera.database.tools.dbmt.JobPropertyNotFound;
import com.primavera.database.tools.dbmt.WorkflowStepJob;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.ParameterizedJobFactory;
import com.primavera.database.tools.dbmt.actions.SetUpgradeVersionFileString;
import com.primavera.database.tools.dbmt.workflow.StepData;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class WorkflowStepJobFactory
implements ParameterizedJobFactory<WorkflowStepJob> {
    private final StepData m_stepData;

    public WorkflowStepJobFactory(StepData step) {
        this.m_stepData = step;
    }

    @Override
    public WorkflowStepJob createJob(JobProperties props) throws ValueNotFound, ConnectionNotFoundException {
        block6: {
            try {
                if (this.m_stepData.getConditionKey() != null && !((String)props.getJobProperty(this.m_stepData.getConditionKey())).equalsIgnoreCase(Boolean.TRUE.toString())) break block6;
                ArrayList<Job> jobs = new ArrayList<Job>();
                for (ParameterizedJobFactory factory : this.m_stepData.getJobs()) {
                    Object job = factory.createJob(props);
                    String jobDesc = job.toString();
                    if (jobDesc.toLowerCase().contains("keystore".toLowerCase()) || jobDesc.toLowerCase().contains("encryption for privuser".toLowerCase())) {
                        jobs.add((Job)job);
                        continue;
                    }
                    if (SetUpgradeVersionFileString.isCurrentVersionSameAsInstalledVersion()) {
                        String upgradeScripts = DBMTPropertySets.APPLICATION.get("dbmt.upgradeScripts");
                        StringTokenizer script = new StringTokenizer(upgradeScripts, ",");
                        while (script.hasMoreElements()) {
                            if (!jobDesc.toLowerCase().contains(script.nextToken().toLowerCase())) continue;
                            jobs.add((Job)job);
                        }
                        continue;
                    }
                    jobs.add((Job)job);
                }
                return new WorkflowStepJob(this.m_stepData.getName(), this.m_stepData.getMaxVersion(), jobs);
            }
            catch (JobPropertyNotFound jobPropertyNotFound) {
                // empty catch block
            }
        }
        return null;
    }
}

