/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.workflow;

import com.primavera.database.common.SchemaInfo;
import com.primavera.database.common.SchemaJarUtil;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.job.JobListener;
import com.primavera.database.common.job.JobWatcher;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.ScriptRunner.ScriptEvent;
import com.primavera.database.tools.ScriptRunner.ScriptFile;
import com.primavera.database.tools.ScriptRunner.ScriptListener;
import com.primavera.database.tools.ScriptRunner.ScriptRunner;
import com.primavera.database.tools.dbmt.AbstractJob;
import com.primavera.database.tools.dbmt.ActionClass;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class SqlScriptJob
extends AbstractJob {
    private final ActionClass m_actionClass;
    private final SchemaInfo m_schema;
    private final String m_connectString;
    private final Properties m_scriptProperies;
    private final String m_resource;
    private final String m_scriptName;

    public SqlScriptJob(ActionClass actionClass, SchemaInfo schema, String file, String dir, String connectString, Properties scriptProperties) {
        this.m_scriptName = file;
        this.m_actionClass = actionClass;
        this.m_schema = schema;
        this.m_connectString = connectString;
        this.m_scriptProperies = scriptProperties;
        DBMTLogger.info(Channel.DEV, "Create script job with connect string = " + this.m_connectString + ", script = " + file);
        String scriptDir = dir;
        if (scriptDir == null) {
            scriptDir = this.m_actionClass.getActionType().getResourcePath();
        }
        this.m_resource = SchemaJarUtil.getResource(this.m_schema, scriptDir, this.m_scriptName);
    }

    @Override
    public boolean isIndeterminateProgress() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doJob(JobListener listener, JobWatcher watcher) throws Exception {
        ScriptRunner runner = new ScriptRunner();
        runner.setContinueOnError(false);
        DatabaseConnection connection = new DatabaseConnection(this.m_connectString);
        runner.setDbconn(connection);
        runner.setScriptInputStreamFactory(new ResourceInputStreamFactory(this.m_resource));
        runner.setExtendedProperties(this.m_scriptProperies);
        runner.addListener(this.getScriptListener(listener));
        try {
            if (!watcher.isContinue()) {
                boolean bl = false;
                return bl;
            }
            runner.run();
        }
        finally {
            connection.close();
            connection = null;
        }
        return true;
    }

    private ScriptListener getScriptListener(final JobListener listener) {
        return new ScriptListener(){

            @Override
            public void scriptBegin(ScriptEvent event) {
                listener.jobProgressed(0, event.getTotalStatements());
            }

            @Override
            public void scriptComplete(ScriptEvent event) {
                listener.jobProgressed(event.getTotalStatements(), event.getTotalStatements());
            }

            @Override
            public void scriptError(ScriptEvent event) {
            }

            @Override
            public void scriptEvent(ScriptEvent event) {
            }

            @Override
            public void statementBegin(ScriptEvent event) {
                listener.jobProgressed(event.getProcessedStatements(), event.getTotalStatements());
                String sql = event.getScriptStatement().getLastSQL().toUpperCase();
                String logSQL = sql.replaceAll("IDENTIFIED BY [^\\s]+", "IDENTIFIED BY ---");
                logSQL = logSQL.replaceAll("WITH PASSWORD.*?= *[^ ]+?[,\\s]", "WITH PASSWORD ---");
                DBMTLogger.info(logSQL);
            }

            @Override
            public void statementComplete(ScriptEvent event) {
            }
        };
    }

    public final ActionClass getActionClass() {
        return this.m_actionClass;
    }

    public final SchemaInfo getSchema() {
        return this.m_schema;
    }

    public String toString() {
        return StringLocalizer.get("dbmt.sql.job.scriptname", new String[]{this.m_scriptName});
    }

    private class ResourceInputStreamFactory
    implements ScriptFile.InputStreamFactory {
        private final String m_resource;

        public ResourceInputStreamFactory(String resource) {
            this.m_resource = resource;
        }

        @Override
        public InputStream createInputStream() throws IOException {
            return ClassLoader.getSystemResourceAsStream(this.m_resource);
        }

        @Override
        public String getLocation() {
            return this.m_resource;
        }
    }
}

