/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.util;

import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.logging.DBMTLogger;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.jdbc.OracleDriver;

public class DBMTUtil {
    public static void grantDBAToAdmUser(String connectString, String adminUser) {
        try {
            DriverManager.registerDriver(new OracleDriver());
            DatabaseConnection c = new DatabaseConnection(connectString);
            String sqlStatement = "GRANT DBA TO " + adminUser;
            Statement stmt = c.getConnection().createStatement();
            stmt.execute(sqlStatement);
            stmt.close();
            c.close();
        }
        catch (SQLException e) {
            DBMTLogger.warn(e.getMessage());
            return;
        }
    }

    public static void revokeDBAFromAdmUser(String connectString, String adminUser) {
        try {
            DriverManager.registerDriver(new OracleDriver());
            DatabaseConnection c = new DatabaseConnection(connectString);
            String sqlStatement = "REVOKE DBA FROM " + adminUser;
            Statement stmt = c.getConnection().createStatement();
            stmt.execute(sqlStatement);
            stmt.close();
            c.close();
        }
        catch (SQLException e) {
            DBMTLogger.warn(e.getMessage());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void grantUnlimitedTbs(String connectString, String adminUser, String pmdat, String pmlob, String pmndx) throws SQLException {
        DatabaseConnection c = new DatabaseConnection(connectString);
        Statement stmt = c.getConnection().createStatement();
        try {
            DriverManager.registerDriver(new OracleDriver());
            String sqlStatement = "alter user " + adminUser + " quota unlimited on " + pmdat;
            stmt.execute(sqlStatement);
            sqlStatement = "alter user " + adminUser + " quota unlimited on " + pmndx;
            stmt.execute(sqlStatement);
            sqlStatement = "alter user " + adminUser + " quota unlimited on " + pmlob;
            stmt.execute(sqlStatement);
            sqlStatement = "alter user " + adminUser + " quota unlimited on PMDB_PX_DAT1";
            stmt.execute(sqlStatement);
        }
        catch (SQLException e) {
            DBMTLogger.warn(e.getMessage());
            return;
        }
        finally {
            stmt.close();
            c.close();
        }
    }

    public static void createPxrptUser(String connectString, String pxTbsName, String pxPath, String adminUser, String pxrptUser, String pxrptPass, String checkPxTbsName) {
        try {
            String sqlStatement;
            DriverManager.registerDriver(new OracleDriver());
            DatabaseConnection c = new DatabaseConnection(connectString);
            Statement stmt = c.getConnection().createStatement();
            if (checkPxTbsName == "false") {
                sqlStatement = "CREATE TABLESPACE " + pxTbsName + " DATAFILE '" + pxPath + "' SIZE 419430400 AUTOEXTEND ON NEXT 10485760 MAXSIZE 32767M LOGGING ONLINE PERMANENT BLOCKSIZE 8192 EXTENT MANAGEMENT LOCAL AUTOALLOCATE DEFAULT NOCOMPRESS SEGMENT SPACE MANAGEMENT AUTO";
                stmt.execute(sqlStatement);
            }
            sqlStatement = "CREATE USER " + pxrptUser + " IDENTIFIED BY \"" + pxrptPass + "\" DEFAULT TABLESPACE " + pxTbsName + " TEMPORARY TABLESPACE \"TEMP\"";
            stmt.execute(sqlStatement);
            sqlStatement = "grant create session, create view, create synonym to " + pxrptUser;
            stmt.execute(sqlStatement);
            sqlStatement = "CREATE OR REPLACE CONTEXT P6_RPT_" + adminUser + " USING " + adminUser + ".secpac";
            stmt.execute(sqlStatement);
            sqlStatement = "BEGIN FOR R IN (SELECT owner, table_name FROM dba_tables WHERE owner=upper('" + adminUser + "')) LOOP EXECUTE IMMEDIATE 'grant select on '||R.owner||'.'||R.table_name||' to " + pxrptUser + "'; END LOOP; END;";
            stmt.execute(sqlStatement);
            sqlStatement = "alter user " + adminUser + " quota unlimited on " + pxTbsName;
            stmt.execute(sqlStatement);
            stmt.close();
            c.close();
        }
        catch (SQLException e) {
            DBMTLogger.warn(e.getMessage());
            return;
        }
    }

    public static void removePxrptUser(String connectString, String pxrptUser, String pxrptTablespace) {
        try {
            DriverManager.registerDriver(new OracleDriver());
            DatabaseConnection c = new DatabaseConnection(connectString);
            String sqlStatement = "drop user " + pxrptUser + " cascade";
            Statement stmt = c.getConnection().createStatement();
            stmt.execute(sqlStatement);
            sqlStatement = "drop tablespace " + pxrptTablespace + " including contents and datafiles cascade constraints";
            stmt = c.getConnection().createStatement();
            stmt.execute(sqlStatement);
            stmt.close();
            c.close();
        }
        catch (SQLException e) {
            DBMTLogger.warn(e.getMessage());
            return;
        }
    }

    public static void privPxrptUser(String connectString, String adminUser, String privUser, String pxrptUser) {
        try {
            DriverManager.registerDriver(new OracleDriver());
            DatabaseConnection c = new DatabaseConnection(connectString);
            String sqlStatement = "BEGIN FOR R IN (SELECT owner, table_name FROM dba_tables WHERE owner=upper('" + adminUser + "')) LOOP EXECUTE IMMEDIATE 'grant select on '||R.owner||'.'||R.table_name||' to " + pxrptUser + "'; EXECUTE IMMEDIATE 'grant insert,update,delete,select on '||R.owner||'.'||R.table_name||' to " + privUser + "'; END LOOP; END;";
            Statement stmt = c.getConnection().createStatement();
            stmt.execute(sqlStatement);
            stmt.close();
            c.close();
        }
        catch (SQLException e) {
            DBMTLogger.warn(e.getMessage());
            return;
        }
    }

    public static void ssPrivPxrptUser(String connectString, String privUser, String pxrptUser) {
        try {
            DatabaseConnection c = new DatabaseConnection(connectString);
            String sqlStatement = "declare @sql NVARCHAR(4000) = N''; declare @v_cur_tab VARCHAR(30); declare @cur_tab cursor; SET @cur_tab = CURSOR FAST_FORWARD for SELECT name FROM SYS.OBJECTS WHERE SCHEMA_NAME(schema_id)='dbo' and TYPE ='U'; open @cur_tab; FETCH NEXT FROM @cur_tab INTO @v_cur_tab; WHILE @@FETCH_STATUS = 0 begin set @sql = N'GRANT INSERT, UPDATE, DELETE, SELECT ON dbo.' + @v_cur_tab + N' to " + privUser + ";'; EXEC sp_executesql @sql; set @sql = N'GRANT SELECT ON dbo.' + @v_cur_tab + N' to " + pxrptUser + ";'; EXEC sp_executesql @sql; FETCH NEXT FROM @cur_tab INTO @v_cur_tab; end; CLOSE @cur_tab; DEALLOCATE @cur_tab;";
            Statement stmt = c.getConnection().createStatement();
            stmt.execute(sqlStatement);
            stmt.close();
            c.close();
        }
        catch (SQLException e) {
            DBMTLogger.warn(e.getMessage());
            return;
        }
    }

    public static void ssRemovePxrptUser(String connectString, String pxrptUser) {
        try {
            DatabaseConnection c = new DatabaseConnection(connectString);
            String sqlStatement = "declare @sql NVARCHAR(4000) = N''; declare @v_type VARCHAR(30); declare @v_name VARCHAR(30); declare @cur_tab cursor; SET @cur_tab = CURSOR FAST_FORWARD for SELECT type_desc,name FROM SYS.OBJECTS WHERE schema_id=SCHEMA_ID('" + pxrptUser + "'); open @cur_tab; FETCH NEXT FROM @cur_tab INTO @v_type,@v_name; WHILE @@FETCH_STATUS = 0 begin set @sql = N'drop ' + @v_type + N' " + pxrptUser + ".' + @v_name + N';'; EXEC sp_executesql @sql; FETCH NEXT FROM @cur_tab INTO @v_type,@v_name; end; CLOSE @cur_tab; DEALLOCATE @cur_tab; DROP SCHEMA " + pxrptUser + "; DROP USER " + pxrptUser + "; drop login " + pxrptUser + ";";
            Statement stmt = c.getConnection().createStatement();
            stmt.execute(sqlStatement);
            stmt.close();
            c.close();
        }
        catch (SQLException e) {
            DBMTLogger.warn(e.getMessage());
            return;
        }
    }

    public static void grantPriv(String connectString, String adminUser, String privUser) {
        try {
            DriverManager.registerDriver(new OracleDriver());
            DatabaseConnection c = new DatabaseConnection(connectString);
            String sqlStatement = "BEGIN FOR R IN (SELECT owner, table_name FROM dba_tables WHERE owner=upper('" + adminUser + "')) LOOP EXECUTE IMMEDIATE 'grant insert,update,delete,select on '||R.owner||'.'||R.table_name||' to " + privUser + "'; END LOOP; END;";
            Statement stmt = c.getConnection().createStatement();
            stmt.execute(sqlStatement);
            sqlStatement = "BEGIN FOR R IN (select owner,object_name,object_type from dba_objects where owner=upper('" + privUser + "')) loop if (R.object_type='VIEW') then EXECUTE IMMEDIATE 'create or replace view '||R.owner||'.'||R.object_name||' as select * from " + adminUser + ".'||R.object_name||' where delete_session_id is null'; end if; end loop; end;";
            stmt = c.getConnection().createStatement();
            stmt.execute(sqlStatement);
            stmt.close();
            c.close();
        }
        catch (SQLException e) {
            DBMTLogger.warn(e.getMessage());
            return;
        }
    }

    public static void grantDBAExtents(String connectString, String adminUser, String privUser) {
        try {
            DriverManager.registerDriver(new OracleDriver());
            DatabaseConnection c = new DatabaseConnection(connectString);
            String sqlStatement = "GRANT SELECT ON sys.DBA_EXTENTS TO " + adminUser + "," + privUser;
            Statement stmt = c.getConnection().createStatement();
            stmt.execute(sqlStatement);
            stmt.close();
            c.close();
        }
        catch (SQLException e) {
            DBMTLogger.warn(e.getMessage());
            return;
        }
    }

    public static String oraTbsPath(String connectString) {
        try {
            ResultSet rs = null;
            String p6PxTbsPath = null;
            DriverManager.registerDriver(new OracleDriver());
            DatabaseConnection c = new DatabaseConnection(connectString);
            String sqlStatement = "select file_name from dba_data_files where substr(tablespace_name,1,8) = 'PMDB_DAT' and rownum < 2";
            Statement stmt = c.getConnection().createStatement();
            stmt.execute(sqlStatement);
            rs = stmt.getResultSet();
            if (rs.next()) {
                p6PxTbsPath = rs.getString("file_name").trim();
            }
            stmt.close();
            c.close();
            return p6PxTbsPath;
        }
        catch (SQLException e) {
            DBMTLogger.warn(e.getMessage());
            return "";
        }
    }
}

