/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.updatelogins.ui;

import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.updatelogins.PrivateDatabaseLoginsTableModel;
import com.primavera.database.tools.dbmt.updatelogins.UpdatePrivateDabaseLoginsModel;
import com.primavera.database.tools.dbmt.updatelogins.UpdatePrivateDatabaseLogins;
import com.primavera.database.tools.dbmt.updatelogins.ui.ComponentPanel;
import com.primavera.database.tools.dbmt.updatelogins.ui.DatabaseConnectionPanel;
import com.primavera.database.tools.dbmt.updatelogins.ui.LoginTablePanel;
import com.primavera.database.tools.dbmt.updatelogins.ui.NavigationOperation;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;

public class UpdatePrivateDatabaseLoginsUI
implements PrivateDatabaseLoginsTableModel.PrivateDatabaseLoginsTableModelListener {
    private static final String DK_SHADOW_COLOR_NAME = "controlDkShadow";
    private static final String LT_HILITE_COLOR_NAME = "controlLtHighlight";
    private static Color SHADOW_COLOR = UIManager.getColor("controlDkShadow");
    private static Color HILIGHT_COLOR = UIManager.getColor("controlLtHighlight");
    private final UpdatePrivateDabaseLoginsModel m_model;
    private final NavigationButton m_btnNext = new NavigationButton(NavigationOperation.NEXT);
    private final NavigationButton m_btnPrevious = new NavigationButton(NavigationOperation.PREV);
    private final NavigationButton m_btnSave = new NavigationButton(NavigationOperation.SAVE);
    private final NavigationButton m_btnCancel = new NavigationButton(NavigationOperation.CANCEL);
    private final NavigationButton m_btnOK = new NavigationButton(NavigationOperation.OK);
    private final NavigationButton m_btnUndo = new NavigationButton(NavigationOperation.UNDO);
    private final NavigationButton[] m_navigationButtons = new NavigationButton[]{this.m_btnNext, this.m_btnPrevious, this.m_btnSave, this.m_btnUndo, this.m_btnCancel, this.m_btnOK};
    private final JLabel m_lblTitle = new JLabel(StringLocalizer.get("dbmt.update.private.database.header." + UpdatePrivateDabaseLoginsModel.INITIAL_PAGE + ".title"));
    private final JLabel m_lblDescription = new JLabel(StringLocalizer.get("dbmt.update.private.database.header." + UpdatePrivateDabaseLoginsModel.INITIAL_PAGE + ".desc"));
    public JFrame m_root = new JFrame();
    private final DatabaseConnectionPanel m_connectionPanel;
    private final LoginTablePanel m_loginsPanel;
    private final JPanel m_contentPanel = new JPanel();
    private final CardLayout m_pageCardLayoutManager = new CardLayout();

    public void setNavButtonEnabled(NavigationOperation op, boolean enabled) {
        NavigationButton btn = null;
        if (op == NavigationOperation.NEXT) {
            btn = this.m_btnNext;
        }
        if (op == NavigationOperation.PREV) {
            btn = this.m_btnPrevious;
        }
        if (op == NavigationOperation.SAVE) {
            btn = this.m_btnSave;
        }
        if (op == NavigationOperation.CANCEL) {
            btn = this.m_btnCancel;
        }
        if (op == NavigationOperation.OK) {
            btn = this.m_btnOK;
        }
        if (op == NavigationOperation.UNDO) {
            btn = this.m_btnUndo;
        }
        btn.setEnabled(enabled);
    }

    public UpdatePrivateDatabaseLoginsUI(UpdatePrivateDabaseLoginsModel model) {
        this.m_model = model;
        this.m_connectionPanel = new DatabaseConnectionPanel(model, this);
        this.m_loginsPanel = new LoginTablePanel(model, this);
        model.getTableModel().addListener(this);
    }

    @Override
    public void dataUpdated() {
        boolean isSavable = this.m_model.getTableModel().isInSavableState();
        this.m_btnSave.setEnabled(isSavable);
    }

    public UpdatePrivateDatabaseLoginsUI initialize() {
        this.initializeUI();
        return this;
    }

    private void initializeUI() {
        this.layoutRootPane(this.m_root.getRootPane().getContentPane());
        this.m_btnNext.addActionListener(new NextButtonActionListener());
        this.m_btnPrevious.addActionListener(new PrevButtonActionlistener());
        this.m_btnCancel.addActionListener(new CancelButtonActionlistener());
        this.m_btnSave.addActionListener(new SaveButtonActionlistener());
        this.m_btnUndo.addActionListener(new UndoButtonActionlistener());
        this.m_btnOK.addActionListener(new OKButtonActionlistener());
        this.m_connectionPanel.initialize();
        this.m_loginsPanel.initialize();
        this.resetButtons();
    }

    private void layoutRootPane(Container container) {
        container.setLayout(new BorderLayout());
        this.m_contentPanel.setLayout(this.m_pageCardLayoutManager);
        this.layoutContent(this.m_contentPanel, this);
        JPanel navPanel = new JPanel();
        UpdatePrivateDatabaseLoginsUI.layoutNavPanel(navPanel, this.m_navigationButtons);
        JPanel headerPanel = new JPanel();
        UpdatePrivateDatabaseLoginsUI.layoutHeaderPanel(headerPanel, this.m_lblTitle, this.m_lblDescription);
        container.add((Component)navPanel, "South");
        container.add((Component)headerPanel, "North");
        container.add((Component)this.m_contentPanel, "Center");
    }

    private void layoutContent(JPanel contentPanel, UpdatePrivateDatabaseLoginsUI ui) {
        this.addContentPanel(contentPanel, ui.m_connectionPanel);
        this.addContentPanel(contentPanel, ui.m_loginsPanel);
    }

    private void addContentPanel(JPanel contentPanel, ComponentPanel componentPanel) {
        contentPanel.add((Component)componentPanel.root, componentPanel.getPanelIdentifier());
        this.m_model.addPanel(componentPanel);
    }

    private static void layoutHeaderPanel(JPanel hdrPanel, JLabel lblTitle, JLabel lblDescription) {
        Font lblTitleFont = lblTitle.getFont();
        lblTitle.setForeground(UIManager.getColor("TextArea.foreground"));
        lblTitle.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        lblTitleFont = lblTitleFont.deriveFont(18.0f).deriveFont(1);
        lblTitle.setFont(lblTitleFont);
        lblDescription.setForeground(UIManager.getColor("TextArea.foreground"));
        hdrPanel.setBackground(UIManager.getColor("TextArea.background"));
        hdrPanel.setLayout(new BorderLayout());
        hdrPanel.add((Component)lblTitle, "North");
        hdrPanel.add((Component)lblDescription, "Center");
        MatteBorder shadowBorder = BorderFactory.createMatteBorder(0, 0, 1, 0, SHADOW_COLOR);
        MatteBorder hilightBorder = BorderFactory.createMatteBorder(0, 0, 1, 0, HILIGHT_COLOR);
        CompoundBorder bevelBorder = BorderFactory.createCompoundBorder(hilightBorder, shadowBorder);
        Border spacingBorder = BorderFactory.createEmptyBorder(10, 20, 6, 0);
        hdrPanel.setBorder(BorderFactory.createCompoundBorder(bevelBorder, spacingBorder));
    }

    private static void layoutNavPanel(JPanel navPanel, NavigationButton[] btns) {
        MatteBorder shadowBorder = BorderFactory.createMatteBorder(1, 0, 0, 0, SHADOW_COLOR);
        MatteBorder hilightBorder = BorderFactory.createMatteBorder(1, 0, 0, 0, HILIGHT_COLOR);
        CompoundBorder bevelBorder = BorderFactory.createCompoundBorder(shadowBorder, hilightBorder);
        Border spacingBorder = BorderFactory.createEmptyBorder(10, 20, 6, 0);
        navPanel.setBorder(BorderFactory.createCompoundBorder(bevelBorder, spacingBorder));
        navPanel.setLayout(new FlowLayout(2));
        for (NavigationButton b : btns) {
            b.setBorder((Border)UIManager.getDefaults().get("WizardButton.border"));
            b.setMnemonic(StringLocalizer.get("dbmt.update.private.database.navigation." + b.op.id() + ".mnemonic").charAt(0));
            navPanel.add(b);
        }
    }

    private void advance(String nextPage) {
        this.m_pageCardLayoutManager.show(this.m_contentPanel, nextPage);
        this.m_model.advance(nextPage);
    }

    private void resetButtons() {
        ComponentPanel panel = this.m_model.m_panelMap.get(this.m_model.topPage());
        for (NavigationButton b : this.m_navigationButtons) {
            b.setVisible(panel.showButton(b.op));
        }
        this.setSaveUndoButtonState();
    }

    public void setSaveUndoButtonState() {
        boolean editsPending = this.m_model.areEditsPending();
        boolean isSavable = this.m_model.getTableModel().isInSavableState();
        this.m_btnSave.setEnabled(editsPending && isSavable);
        this.m_btnUndo.setEnabled(editsPending);
    }

    private final class UndoButtonActionlistener
    implements ActionListener {
        private UndoButtonActionlistener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UpdatePrivateDatabaseLoginsUI.this.m_model.undoLastChange();
            UpdatePrivateDatabaseLoginsUI.this.setSaveUndoButtonState();
        }
    }

    private final class SaveButtonActionlistener
    implements ActionListener {
        private SaveButtonActionlistener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UpdatePrivateDatabaseLoginsUI.this.m_model.saveStateToDatabase();
            UpdatePrivateDatabaseLoginsUI.this.setSaveUndoButtonState();
        }
    }

    private final class PrevButtonActionlistener
    implements ActionListener {
        private PrevButtonActionlistener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UpdatePrivateDatabaseLoginsUI.this.m_model.revert();
            String newPage = UpdatePrivateDatabaseLoginsUI.this.m_model.topPage();
            ComponentPanel newPanel = ((UpdatePrivateDatabaseLoginsUI)UpdatePrivateDatabaseLoginsUI.this).m_model.m_panelMap.get(newPage);
            newPanel.onUndo(UpdatePrivateDatabaseLoginsUI.this.m_model);
            UpdatePrivateDatabaseLoginsUI.this.m_pageCardLayoutManager.show(UpdatePrivateDatabaseLoginsUI.this.m_contentPanel, newPage);
            UpdatePrivateDatabaseLoginsUI.this.resetButtons();
            UpdatePrivateDatabaseLoginsUI.this.m_lblTitle.setText(StringLocalizer.get("dbmt.update.private.database.header." + newPage + ".title"));
            UpdatePrivateDatabaseLoginsUI.this.m_lblDescription.setText(StringLocalizer.get("dbmt.update.private.database.header." + newPage + ".desc"));
        }
    }

    private final class OKButtonActionlistener
    implements ActionListener {
        private OKButtonActionlistener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UpdatePrivateDatabaseLoginsUI.this.m_model.saveStateToDatabase();
            UpdatePrivateDatabaseLoginsUI.this.m_root.dispose();
            UpdatePrivateDatabaseLogins.exit();
        }
    }

    private final class NextButtonActionListener
    implements ActionListener {
        private NextButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String thisPage = UpdatePrivateDatabaseLoginsUI.this.m_model.topPage();
            String nextPage = UpdatePrivateDatabaseLoginsUI.this.m_model.nextPage(thisPage);
            try {
                ((UpdatePrivateDatabaseLoginsUI)UpdatePrivateDatabaseLoginsUI.this).m_model.m_panelMap.get(thisPage).onExit(UpdatePrivateDatabaseLoginsUI.this.m_model);
                ((UpdatePrivateDatabaseLoginsUI)UpdatePrivateDatabaseLoginsUI.this).m_model.m_panelMap.get(nextPage).onEnter(UpdatePrivateDatabaseLoginsUI.this.m_model);
            }
            catch (DBMTException e) {
                String msg = e.getLocalizedMessage();
                JOptionPane.showMessageDialog(UpdatePrivateDatabaseLoginsUI.this.m_contentPanel, msg);
                return;
            }
            UpdatePrivateDatabaseLoginsUI.this.advance(nextPage);
            UpdatePrivateDatabaseLoginsUI.this.resetButtons();
            UpdatePrivateDatabaseLoginsUI.this.m_lblTitle.setText(StringLocalizer.get("dbmt.update.private.database.header." + nextPage + ".title"));
            UpdatePrivateDatabaseLoginsUI.this.m_lblDescription.setText(StringLocalizer.get("dbmt.update.private.database.header." + nextPage + ".desc"));
        }
    }

    private final class NavigationButton
    extends JButton {
        private static final long serialVersionUID = -5808643922820705538L;
        public final NavigationOperation op;

        private NavigationButton(NavigationOperation op) {
            super(StringLocalizer.get("dbmt.update.private.database.navigation." + op.id() + ".title"));
            this.op = op;
        }
    }

    private final class CancelButtonActionlistener
    implements ActionListener {
        private CancelButtonActionlistener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UpdatePrivateDatabaseLoginsUI.this.m_root.dispose();
            UpdatePrivateDatabaseLogins.exit();
        }
    }
}

