/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.schemaval;

import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.connection.DatabaseMetaData;
import com.primavera.database.common.job.JobListener;
import com.primavera.database.common.job.JobWatcher;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.SchemaValidation.SchemaBuilderEvent;
import com.primavera.database.tools.SchemaValidation.SchemaBuilderListener;
import com.primavera.database.tools.dbmt.AbstractJob;
import com.primavera.database.tools.dbmt.schemaval.RunSchemaVal;

public class SchemaBuilderJob
extends AbstractJob {
    private final String m_connectString;

    public SchemaBuilderJob(String connectstring) {
        this.m_connectString = connectstring;
    }

    @Override
    public boolean isIndeterminateProgress() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doJob(JobListener listener, JobWatcher watcher) throws Exception {
        DatabaseConnection connection = new DatabaseConnection(this.m_connectString);
        DatabaseMetaData meta = new DatabaseMetaData();
        meta.setDatabaseConnection(connection);
        RunSchemaVal rsv = RunSchemaVal.getRunSchemaVal();
        rsv.setConnection(connection);
        rsv.setBuildListener(this.getSchemaBuilderListener(listener));
        try {
            if (!watcher.isContinue()) {
                boolean bl = false;
                return bl;
            }
            rsv.buildSchemaDocument();
        }
        finally {
            connection.close();
            connection = null;
        }
        return true;
    }

    private SchemaBuilderListener getSchemaBuilderListener(final JobListener listener) {
        return new SchemaBuilderListener(){

            @Override
            public void schemaBuilderBegin(SchemaBuilderEvent event) {
                DBMTLogger.info(Channel.DEV, "Schema Builder Start");
                listener.jobProgressed(0, event.getTotalTables());
            }

            @Override
            public void schemaBuilderComplete(SchemaBuilderEvent event) {
                DBMTLogger.info(Channel.DEV, "Schema Builder Complete");
                listener.jobProgressed(event.getProcessedTables(), event.getTotalTables());
            }

            @Override
            public void schemaBuilderError(SchemaBuilderEvent event) {
                DBMTLogger.error(Channel.DEV, event.getException().getMessage());
            }

            @Override
            public void tableBegin(SchemaBuilderEvent event) {
                DBMTLogger.info(Channel.DEV, "SchemaBuilder: Begin table " + event.getTableName());
            }

            @Override
            public void tableComplete(SchemaBuilderEvent event) {
                DBMTLogger.info(Channel.DEV, "SchemaBuilder: Completed table " + event.getTableName());
                listener.jobProgressed(event.getProcessedTables(), event.getTotalTables());
            }
        };
    }

    public String toString() {
        return StringLocalizer.get("dbmt.schemavalidation.jobs.buildschema.name");
    }
}

