/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui.util;

import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.actions.InteractorData;
import com.primavera.database.tools.dbmt.actions.StringTypeDef;
import com.primavera.database.tools.dbmt.actions.TypeDef;
import com.primavera.database.tools.dbmt.gui.util.ComponentBinding;
import com.primavera.database.tools.dbmt.gui.util.SelectAllTextFocusListener;
import com.primavera.database.tools.dbmt.gui.util.ValueChangedListener;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;

public class TextComponentBinding
extends ComponentBinding {
    private final JFormattedTextField m_text = new JFormattedTextField();

    public TextComponentBinding(InteractorData data, String fieldId) {
        super(data, fieldId);
        this.m_text.setFocusLostBehavior(3);
        String mask = null;
        TypeDef typeDef = data.getDef().getTypeDef(fieldId);
        if (typeDef instanceof StringTypeDef) {
            StringTypeDef stringTypeDef = (StringTypeDef)typeDef;
            mask = stringTypeDef.getMask();
        }
        try {
            if (mask != null) {
                MaskFormatter formatter = new MaskFormatter(mask);
                this.m_text.setFormatterFactory(new DefaultFormatterFactory(formatter));
            }
        }
        catch (ParseException e) {
            DBMTLogger.info(Channel.USER, "Parse exception in Formatted Text Field for field " + fieldId + ": " + e.toString());
        }
        this.m_text.addFocusListener(new SelectAllTextFocusListener(this.m_text));
        this.m_text.setToolTipText(data.getDesc(fieldId));
    }

    @Override
    public void addChangeListener(final ValueChangedListener listener) {
        this.m_text.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                listener.onValueChanged(TextComponentBinding.this.getFieldId());
            }
        });
    }

    @Override
    public JComponent[] getComponents() {
        return new JComponent[]{this.m_text};
    }

    @Override
    public void setComponentData(String dataString) {
        this.m_text.setText(dataString);
    }

    @Override
    public String getComponentData() {
        return this.m_text.getText();
    }
}

