/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui.util;

import com.primavera.database.tools.dbmt.actions.InteractorData;
import com.primavera.database.tools.dbmt.actions.JobTreeTypeDef;
import com.primavera.database.tools.dbmt.actions.TypeDef;
import com.primavera.database.tools.dbmt.gui.util.ComponentBinding;
import com.primavera.database.tools.dbmt.gui.util.JobTreeModel;
import com.primavera.database.tools.dbmt.gui.util.ValueChangedListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;

public class JobTreeComponentBinding
extends ComponentBinding {
    private final JTree m_tree = new JTree();
    private final JScrollPane m_scrollPane = new JScrollPane(this.m_tree);
    private final String m_fieldId;
    private final JobTreeModel m_model;

    public JobTreeComponentBinding(InteractorData data, String fieldId) {
        super(data, fieldId);
        this.m_tree.setBackground(this.m_scrollPane.getBackground());
        this.m_tree.setRootVisible(false);
        this.m_tree.setRowHeight((int)((double)this.m_tree.getFontMetrics(this.m_tree.getFont()).getHeight() * 1.5));
        this.m_tree.setExpandsSelectedPaths(true);
        TypeDef typedef = data.getDef().getTypeDef(fieldId);
        if (typedef instanceof JobTreeTypeDef) {
            JobTreeTypeDef jobTreeDef = (JobTreeTypeDef)typedef;
            this.m_model = new JobTreeModel(jobTreeDef);
            this.m_tree.setModel(this.m_model);
            jobTreeDef.addListener(this.m_model);
        } else {
            this.m_model = null;
        }
        this.m_tree.setCellRenderer(this.m_model.getRenderer());
        this.m_fieldId = fieldId;
    }

    @Override
    public void addChangeListener(final ValueChangedListener listener) {
        this.m_tree.getModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent arg0) {
                listener.onValueChanged(JobTreeComponentBinding.this.m_fieldId);
            }

            @Override
            public void treeNodesInserted(TreeModelEvent arg0) {
                listener.onValueChanged(JobTreeComponentBinding.this.m_fieldId);
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent arg0) {
                listener.onValueChanged(JobTreeComponentBinding.this.m_fieldId);
            }

            @Override
            public void treeStructureChanged(TreeModelEvent arg0) {
                listener.onValueChanged(JobTreeComponentBinding.this.m_fieldId);
            }
        });
    }

    @Override
    public String getComponentData() {
        return null;
    }

    @Override
    public JComponent[] getComponents() {
        return new JComponent[]{this.m_scrollPane};
    }

    @Override
    public void setComponentData(String dataString) {
    }

    public final JobTreeModel getModel() {
        return this.m_model;
    }
}

