/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui.model;

import com.primavera.database.tools.dbmt.ActionContext;
import com.primavera.database.tools.dbmt.ApplicationHelper;
import com.primavera.database.tools.dbmt.DatabaseInfo;
import com.primavera.database.tools.dbmt.ServerInfo;
import com.primavera.database.tools.dbmt.gui.model.ContextMenuUtil;
import com.primavera.database.tools.dbmt.xml.MenuActionMap;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;

public class ConnectionTreeSelectionModel
extends DefaultTreeSelectionModel {
    private static final long serialVersionUID = 1362244225960880305L;
    private static final Class<?>[] SELECTION_TYPES_ALLOWED = new Class[]{ServerInfo.class, DatabaseInfo.class};
    private Class<?> m_currentSelectionType = null;
    private final JPopupMenu m_menu = new JPopupMenu();

    public ConnectionTreeSelectionModel() {
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                MenuActionMap.inst().onContextChanged(this.createContextFromPaths());
            }

            private ActionContext createContextFromPaths() {
                ActionContext context = new ActionContext(ApplicationHelper.app());
                TreePath[] paths = ConnectionTreeSelectionModel.this.getSelectionPaths();
                if (paths != null) {
                    for (TreePath path : ConnectionTreeSelectionModel.this.getSelectionPaths()) {
                        if (!(path.getLastPathComponent() instanceof ServerInfo)) continue;
                        ServerInfo server = (ServerInfo)path.getLastPathComponent();
                        context.getServers().add(server);
                    }
                }
                return context;
            }
        });
    }

    public JPopupMenu getPopupMenu() {
        return this.m_menu;
    }

    private boolean isValidSelection(TreePath path) {
        Class<?> selectableClass = this.findSelectableTypeForClass(path.getLastPathComponent().getClass());
        if (selectableClass == null) {
            return false;
        }
        if (this.m_currentSelectionType == null) {
            return true;
        }
        return this.m_currentSelectionType == selectableClass;
    }

    private boolean isClassSelectable(Class<?> cls) {
        for (int i = 0; i < SELECTION_TYPES_ALLOWED.length; ++i) {
            if (cls != SELECTION_TYPES_ALLOWED[i]) continue;
            return true;
        }
        return false;
    }

    private Class<?> findSelectableTypeForClass(Class<?> cls) {
        for (Class<?> nextClass = cls; nextClass != null; nextClass = nextClass.getSuperclass()) {
            if (this.isClassSelectable(nextClass)) {
                return nextClass;
            }
            for (Class<?> inter : nextClass.getInterfaces()) {
                if (!this.isClassSelectable(inter)) continue;
                return inter;
            }
        }
        return null;
    }

    @Override
    public void addSelectionPath(TreePath path) {
        if (!this.isValidSelection(path)) {
            return;
        }
        super.addSelectionPath(path);
        Class<?> cls = this.findSelectableTypeForClass(path.getLastPathComponent().getClass());
        if (cls != null) {
            this.m_currentSelectionType = cls;
        }
        this.resetPopupMenu();
    }

    @Override
    public void addSelectionPaths(TreePath[] paths) {
        ArrayList<TreePath> validPaths = new ArrayList<TreePath>();
        ArrayList pathClasses = new ArrayList();
        for (TreePath selected : paths) {
            if (!this.isValidSelection(selected)) continue;
            validPaths.add(selected);
            pathClasses.add(this.findSelectableTypeForClass(selected.getLastPathComponent().getClass()));
        }
        if (pathClasses.size() == 0) {
            return;
        }
        Class cls = (Class)pathClasses.get(0);
        for (int i = 1; i < pathClasses.size(); ++i) {
            if (cls == pathClasses.get(i)) continue;
            return;
        }
        super.addSelectionPaths(validPaths.toArray(new TreePath[0]));
        this.resetPopupMenu();
    }

    @Override
    public void setSelectionPath(TreePath path) {
        Class<?> selectedClass = this.findSelectableTypeForClass(path.getLastPathComponent().getClass());
        if (selectedClass == null) {
            return;
        }
        super.setSelectionPaths(new TreePath[]{path});
        this.m_currentSelectionType = selectedClass;
        this.resetPopupMenu();
    }

    @Override
    public void setSelectionPaths(TreePath[] paths) {
        ArrayList<TreePath> validPaths = new ArrayList<TreePath>();
        ArrayList pathClasses = new ArrayList();
        for (TreePath selected : paths) {
            if (!this.isValidSelection(selected)) continue;
            validPaths.add(selected);
            pathClasses.add(this.findSelectableTypeForClass(selected.getLastPathComponent().getClass()));
        }
        if (pathClasses.size() == 0) {
            return;
        }
        Class cls = (Class)pathClasses.get(0);
        for (int i = 1; i < pathClasses.size(); ++i) {
            if (cls == pathClasses.get(i)) continue;
            return;
        }
        super.setSelectionPaths(validPaths.toArray(new TreePath[0]));
        this.resetPopupMenu();
    }

    private void resetPopupMenu() {
        this.m_menu.removeAll();
        if (this.m_currentSelectionType == ServerInfo.class) {
            this.m_menu.add(new JMenuItem("SVRINFO"));
            if (this.getSelectionCount() > 1) {
                TreePath[] paths = this.getSelectionPaths();
                ServerInfo[] servers = new ServerInfo[paths.length];
                for (int i = 0; i < paths.length; ++i) {
                    servers[i] = (ServerInfo)paths[i].getLastPathComponent();
                }
                ContextMenuUtil.createMultiMenuSelectionSVRInfo(this.m_menu, servers);
            } else {
                Object obj = this.getSelectionPath().getLastPathComponent();
                if (obj instanceof ServerInfo) {
                    ServerInfo server = (ServerInfo)obj;
                    ContextMenuUtil.createSingleMenuSelectionSVRInfo(this.m_menu);
                }
            }
            return;
        }
        if (this.m_currentSelectionType == DatabaseInfo.class) {
            this.m_menu.add(new JMenuItem("DBINFO"));
            if (this.getSelectionCount() > 1) {
                TreePath[] paths = this.getSelectionPaths();
                DatabaseInfo[] databases = new DatabaseInfo[paths.length];
                for (int i = 0; i < paths.length; ++i) {
                    databases[i] = (DatabaseInfo)paths[i].getLastPathComponent();
                }
                ContextMenuUtil.createMultiMenuSelectionDBInfo(this.m_menu, databases);
            } else {
                DatabaseInfo database = (DatabaseInfo)this.getSelectionPath().getLastPathComponent();
                ContextMenuUtil.createSingleMenuSelectionDBInfo(this.m_menu, database);
            }
            return;
        }
    }
}

