/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui.dialogs;

import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.actions.InteractorData;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.gui.InteractorPage;
import com.primavera.database.tools.dbmt.gui.PageLayoutLogic;
import com.primavera.database.tools.dbmt.gui.util.ComponentBinding;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public final class LayoutContext {
    private final Map<String, String> m_nameMap;
    private final InteractorPage m_page;
    private final InteractorData m_data;
    private final Map<String, JTextArea> m_deadLetterTextAreas = new HashMap<String, JTextArea>();

    public LayoutContext(Map<String, String> nameMap, InteractorPage page, PageLayoutLogic logic, InteractorData data) {
        this.m_nameMap = nameMap;
        this.m_page = page;
        this.m_data = data;
        for (String fieldId : data.getFieldIds()) {
            ComponentBinding binding = logic.createBinding(data, fieldId, page);
            page.getBindingMap().put(fieldId, binding);
        }
        for (String textId : data.getTextIds()) {
            page.getTextBindingMap().put(textId, this.createTextField(data, textId));
        }
    }

    private JTextArea createTextField(InteractorData data, String textId) {
        JTextArea textArea = new JTextArea();
        LayoutContext.initializeTextArea(textArea);
        textArea.setText(data.getText(textId));
        return textArea;
    }

    public static void initializeTextArea(JTextArea textArea) {
        textArea.setBackground(UIManager.getColor("Panel.background"));
        textArea.setEditable(false);
        textArea.setRows(2);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setFont(UIManager.getFont("Label.font"));
    }

    public final boolean doesFieldExist(String fieldId) {
        String actualFieldName = this.getMappedId(fieldId);
        return this.m_data.getDef().doesFieldExit(actualFieldName);
    }

    public final Object getValue(String fieldId) throws InteractorDataError {
        return this.m_data.getValue(this.getMappedId(fieldId));
    }

    public final String getName(String fieldId) {
        return this.m_data.getTitle(this.getMappedId(fieldId));
    }

    public final String getDesc(String fieldId) {
        return this.m_data.getDesc(this.getMappedId(fieldId));
    }

    public final ComponentBinding getBinding(String fieldId) {
        return this.m_page.getBinding(this.getMappedId(fieldId));
    }

    public final JTextArea getTextArea(String textId) {
        JTextArea textArea = this.m_page.getTextBindingMap().get(textId);
        if (textArea != null) {
            return textArea;
        }
        textArea = this.m_deadLetterTextAreas.get(textId);
        if (textArea == null) {
            DBMTLogger.error(Channel.DEV, "Text are not set: " + textId);
            textArea = new JTextArea();
            LayoutContext.initializeTextArea(textArea);
            this.m_deadLetterTextAreas.put(textId, textArea);
        }
        DBMTLogger.warn(Channel.DEV, "Using dead letter text area: " + textId);
        return textArea;
    }

    public final JPanel getContentPane() {
        return this.m_page.getContentPanel();
    }

    public final int getFieldCount() {
        return this.m_data.getFieldCount();
    }

    protected final String getMappedId(String virtualId, Map<String, String> map) {
        String id = map.get(virtualId);
        if (id == null) {
            return virtualId;
        }
        return id;
    }

    protected final String getMappedId(String virtualId) {
        return this.getMappedId(virtualId, this.m_nameMap);
    }

    public final Iterable<String> getAllFieldIds() {
        ArrayList<String> mappedKeys = new ArrayList<String>();
        HashMap<String, String> reverseLookupMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.m_nameMap.entrySet()) {
            reverseLookupMap.put(entry.getValue(), entry.getKey());
        }
        for (String rawName : this.m_data.getDef().getKeys()) {
            mappedKeys.add(this.getMappedId(rawName, reverseLookupMap));
        }
        return mappedKeys;
    }

    public char getMnemonic(String fieldId) {
        return this.m_data.getMnemonic(this.getMappedId(fieldId, this.m_nameMap));
    }

    public Action getNextAction() {
        return this.m_page.getNextAction();
    }
}

