/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui.dialogs;

import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.MissingRequiredAttributeException;
import com.primavera.database.tools.dbmt.gui.GuiWizardRunner;
import com.primavera.database.tools.dbmt.gui.PageLayoutLogic;
import com.primavera.database.tools.dbmt.gui.dialogs.GUILayoutSpec;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GUIInteractorXMLParserHandler
extends DefaultHandler {
    private final Map<String, Map<String, GUILayoutSpec>> m_wizMap;
    private final Map<String, GUILayoutSpec> m_dlgMap;
    private Map<String, GUILayoutSpec> m_activePageMap;
    private String m_activeAction;
    private String m_activeClassName;
    private String m_activePageId;
    private String m_size;
    private Map<String, String> m_activeNameMap;

    public GUIInteractorXMLParserHandler(Map<String, Map<String, GUILayoutSpec>> wizMap, Map<String, GUILayoutSpec> dlgMap) {
        this.m_wizMap = wizMap;
        this.m_dlgMap = dlgMap;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attr) throws SAXException {
        try {
            if (Elem.WIZARD.equals(qName)) {
                this.m_activePageMap = new HashMap<String, GUILayoutSpec>();
                this.m_activeAction = Attr.ACTION.value(attr);
                this.m_size = Attr.SIZE.value(attr, null);
            } else if (Elem.DIALOG.equals(qName)) {
                this.m_activeAction = Attr.ACTION.value(attr);
                this.m_activeClassName = Attr.CLASS.value(attr);
                this.m_activeNameMap = new HashMap<String, String>();
                this.m_size = Attr.SIZE.value(attr, null);
            } else if (Elem.PAGE.equals(qName)) {
                this.m_activePageId = Attr.ID.value(attr);
                this.m_activeClassName = Attr.CLASS.value(attr);
                this.m_activeNameMap = new HashMap<String, String>();
            } else if (Elem.MAP.equals(qName)) {
                this.m_activeNameMap.put(Attr.FROM.value(attr), Attr.TO.value(attr));
            }
        }
        catch (MissingRequiredAttributeException e) {
            DBMTLogger.error(Channel.DEV, "Required attribute " + e.getAttribute() + " missing on element " + qName);
            throw new SAXException("Required attribute " + e.getAttribute() + " missing on element " + qName);
        }
        super.startElement(uri, localName, qName, attr);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        if (Elem.WIZARD.equals(qName)) {
            this.m_wizMap.put(this.m_activeAction, this.m_activePageMap);
            this.m_activeAction = null;
            this.m_size = null;
        } else if (Elem.DIALOG.equals(qName)) {
            HashMap<String, String> nameMap = new HashMap<String, String>();
            nameMap.putAll(this.m_activeNameMap);
            GUILayoutSpec spec = new GUILayoutSpec(this.createLayoutClass(this.m_activeClassName, this.m_activeAction), nameMap);
            spec.setSize(this.parseDimension(this.m_size));
            this.m_dlgMap.put(this.m_activeAction, spec);
            this.m_activeAction = null;
            this.m_activeNameMap = null;
            this.m_size = null;
        } else if (Elem.PAGE.equals(qName)) {
            HashMap<String, String> nameMap = new HashMap<String, String>();
            nameMap.putAll(this.m_activeNameMap);
            GUILayoutSpec spec = new GUILayoutSpec(this.createLayoutClass(this.m_activeClassName, this.m_activeAction), nameMap);
            spec.setSize(this.parseDimension(this.m_size));
            this.m_activePageMap.put(this.m_activePageId, spec);
            this.m_activePageId = null;
            this.m_activeNameMap = null;
        }
    }

    private Dimension parseDimension(String sizeString) {
        if (sizeString == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(sizeString, "x");
        try {
            String width = tokenizer.nextToken();
            String height = tokenizer.nextToken();
            return new Dimension(Integer.parseInt(width), Integer.parseInt(height));
        }
        catch (Throwable e) {
            DBMTLogger.error(Channel.DEV, "Unable to parser size string " + sizeString);
            return null;
        }
    }

    private PageLayoutLogic createLayoutClass(String className, String actionName) {
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.layout.error.classnotfound", new String[]{className, actionName}));
            return GuiWizardRunner.DEFAULT_LAYOUT;
        }
        Object obj = null;
        try {
            obj = cls.newInstance();
        }
        catch (InstantiationException e) {
            DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.layout.error.cantinstantiate", new String[]{className, actionName}));
            return GuiWizardRunner.DEFAULT_LAYOUT;
        }
        catch (IllegalAccessException e) {
            DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.layout.error.illegalaccess", new String[]{className, actionName}));
            return GuiWizardRunner.DEFAULT_LAYOUT;
        }
        if (obj instanceof PageLayoutLogic) {
            return obj;
        }
        DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.layout.error.notasubclass", new String[]{className, PageLayoutLogic.class.getSimpleName(), actionName}));
        return GuiWizardRunner.DEFAULT_LAYOUT;
    }

    private static enum Attr {
        ACTION("action"),
        ID("id"),
        CLASS("class"),
        FROM("from"),
        TO("to"),
        SIZE("size");

        private final String m_string;

        private Attr(String string2) {
            this.m_string = string2;
        }

        public String value(Attributes attr) throws MissingRequiredAttributeException {
            String val = attr.getValue(this.m_string);
            if (val == null) {
                throw new MissingRequiredAttributeException(this.m_string);
            }
            return val;
        }

        public String value(Attributes attr, String defVal) {
            String val = attr.getValue(this.m_string);
            if (val == null) {
                return defVal;
            }
            return val;
        }
    }

    private static enum Elem {
        LAYOUT("layout"),
        WIZARD("wizard"),
        PAGE("page"),
        DIALOG("dialog"),
        MAP("map");

        private final String m_string;

        private Elem(String string2) {
            this.m_string = string2;
        }

        public boolean equals(String elemName) {
            return this.m_string.equals(elemName);
        }
    }
}

