/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui.dialogs;

import com.primavera.database.tools.dbmt.InteractorInitData;
import com.primavera.database.tools.dbmt.SimpleInteractor;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;

public abstract class DialogInteractor<T>
implements SimpleInteractor<T> {
    private static final String DISMISS_DIALOG_ACTION = "DismissDialog";
    private boolean m_accept = false;
    private Map<JComponent, Set<JComponent>> m_validationDepMap = new HashMap<JComponent, Set<JComponent>>();
    private Map<JComponent, Set<Validator>> m_validationMap = new HashMap<JComponent, Set<Validator>>();
    private final JDialog m_dialog = new JDialog();
    protected Action m_dismissAction = new AbstractAction(){
        private static final long serialVersionUID = 2964077771787864532L;

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogInteractor.this.m_dialog.dispose();
        }
    };

    public DialogInteractor() {
        this.m_dialog.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), DISMISS_DIALOG_ACTION);
        this.m_dialog.getRootPane().getActionMap().put(DISMISS_DIALOG_ACTION, this.m_dismissAction);
    }

    public JDialog getDialog() {
        return this.m_dialog;
    }

    @Override
    public final void initialize(InteractorInitData<T> data) {
        this.reset();
        this.m_dialog.setTitle(data.getLabel());
        this.initializeDialogData(data.getData());
        this.m_dialog.setLocation(400, 400);
        this.m_dialog.pack();
    }

    public abstract void initializeDialogData(T var1);

    public void addValidationForComponent(JComponent component, Validator validator) {
        if (!this.m_validationMap.containsKey(component)) {
            this.m_validationMap.put(component, new HashSet());
        }
        this.m_validationMap.get(component).add(validator);
    }

    public void addComponentDependency(JComponent dependantComponent, JComponent[] drivingComponents) {
        if (drivingComponents.length == 0) {
            return;
        }
        if (!this.m_validationDepMap.containsKey(dependantComponent)) {
            this.m_validationDepMap.put(dependantComponent, new HashSet());
        }
        ArrayList<JComponent> collection = new ArrayList<JComponent>();
        for (JComponent c : drivingComponents) {
            this.addValidationListener(c, dependantComponent);
            collection.add(c);
        }
        this.m_validationDepMap.get(dependantComponent).addAll(collection);
    }

    private void addValidationListener(JComponent changedComponent, JComponent componentToValidate) {
        if (changedComponent instanceof JTextComponent) {
            JTextComponent textComponent = (JTextComponent)changedComponent;
            final JComponent finalComponentToValidate = componentToValidate;
            textComponent.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent e) {
                    DialogInteractor.this.validateAndEnableComponent(finalComponentToValidate);
                }
            });
        }
    }

    private void validateAndEnableComponent(JComponent component) {
        component.setEnabled(this.isComponentValid(component));
    }

    private Iterable<Validator> getValidtionForComponent(JComponent component) {
        Collection validators = this.m_validationMap.get(component);
        if (validators != null) {
            return validators;
        }
        return new ArrayList<Validator>();
    }

    private boolean isComponentValid(JComponent component) {
        for (Validator validator : this.getValidtionForComponent(component)) {
            if (validator.isValid()) continue;
            return false;
        }
        return true;
    }

    protected void reset() {
        this.m_accept = false;
    }

    protected boolean isAccept() {
        return this.m_accept;
    }

    protected void setAccept(boolean value) {
        this.m_accept = value;
    }

    public static interface Validator {
        public boolean isValid();

        public String reason();
    }
}

