/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui;

import com.primavera.database.common.locale.StringLocalizer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ServiceNameFetcher {
    public static final int BUFFER = 20480;
    public static final String ZIP = ".zip";

    static Set<String> getService(File zipFileName) {
        String filePath = zipFileName.getAbsolutePath();
        String fileName = zipFileName.getName();
        int endIndex = fileName.indexOf(ZIP);
        Path walletPath = Paths.get(filePath.substring(0, filePath.indexOf(fileName) - 1), new String[0]);
        Path targetDirectory = endIndex != -1 ? walletPath.resolve(Paths.get(fileName.substring(0, endIndex), new String[0])) : Paths.get(filePath, new String[0]);
        String tnsName = ServiceNameFetcher.unzipFiles(filePath, targetDirectory);
        Path tnsNamesPath = targetDirectory.resolve(Paths.get(tnsName, new String[0]));
        return ServiceNameFetcher.getServiceList(tnsNamesPath.toString());
    }

    static String unzipFiles(String zipFileName, Path tempDir) {
        String tnsName = "tnsnames.ora";
        File dir = new File(tempDir.toString());
        if (dir.isDirectory()) {
            File[] aFiles = dir.listFiles();
            for (File file : aFiles) {
                file.delete();
            }
        }
        dir.mkdir();
        try {
            ZipFile zipfile = new ZipFile(zipFileName);
            Object object = null;
            try {
                Enumeration<? extends ZipEntry> entries = zipfile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    BufferedInputStream inStream = new BufferedInputStream(zipfile.getInputStream(entry));
                    Throwable throwable = null;
                    try {
                        byte[] data = new byte[20480];
                        FileOutputStream fos = new FileOutputStream(tempDir.toString() + "/" + entry.getName());
                        Throwable throwable2 = null;
                        try {
                            BufferedOutputStream outStream = new BufferedOutputStream(fos, 20480);
                            Throwable throwable3 = null;
                            try {
                                int size;
                                while ((size = inStream.read(data, 0, 20480)) != -1) {
                                    outStream.write(data, 0, size);
                                }
                            }
                            catch (Throwable throwable4) {
                                throwable3 = throwable4;
                                throw throwable4;
                            }
                            finally {
                                if (outStream == null) continue;
                                if (throwable3 != null) {
                                    try {
                                        outStream.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable3.addSuppressed(throwable5);
                                    }
                                    continue;
                                }
                                outStream.close();
                            }
                        }
                        catch (Throwable throwable6) {
                            throwable2 = throwable6;
                            throw throwable6;
                        }
                        finally {
                            if (fos == null) continue;
                            if (throwable2 != null) {
                                try {
                                    fos.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable2.addSuppressed(throwable7);
                                }
                                continue;
                            }
                            fos.close();
                        }
                    }
                    catch (Throwable throwable8) {
                        throwable = throwable8;
                        throw throwable8;
                    }
                    finally {
                        if (inStream == null) continue;
                        if (throwable != null) {
                            try {
                                inStream.close();
                            }
                            catch (Throwable throwable9) {
                                throwable.addSuppressed(throwable9);
                            }
                            continue;
                        }
                        inStream.close();
                    }
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (zipfile != null) {
                    if (object != null) {
                        try {
                            zipfile.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        zipfile.close();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tnsName;
    }

    private static Set<String> getServiceList(String file) {
        HashSet<String> serviceNames = new HashSet<String>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            while (line != null) {
                if (line.toLowerCase().contains("description") && line.toLowerCase().contains("service_name")) {
                    int endIndex = line.indexOf("=");
                    String tempService = line.substring(0, endIndex - 1);
                    serviceNames.add(tempService);
                    line = reader.readLine();
                    continue;
                }
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (String serviceName : serviceNames) {
            StringLocalizer.setAsOwnTranslation(serviceName);
        }
        return serviceNames;
    }
}

