/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui;

import com.primavera.database.common.ApplicationProperties;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.gui.CommitPageLayoutLogic;
import com.primavera.database.tools.dbmt.gui.GuiWizardRunner;
import com.primavera.database.tools.dbmt.gui.StandardWizardLayoutLogic;
import com.primavera.database.tools.dbmt.gui.dialogs.GUIInteractorXMLParserHandler;
import com.primavera.database.tools.dbmt.gui.dialogs.GUILayoutSpec;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class LayoutManager {
    private static final LayoutManager s_instance = new LayoutManager();
    private static final Map<String, GUILayoutSpec> s_emptyMap = new HashMap<String, GUILayoutSpec>();
    private final Map<String, Map<String, GUILayoutSpec>> m_wizMap = new HashMap<String, Map<String, GUILayoutSpec>>();
    private final Map<String, GUILayoutSpec> m_dlgMap = new HashMap<String, GUILayoutSpec>();

    public static LayoutManager inst() {
        return s_instance;
    }

    private void addInteractorLayoutsFromProperty(String property) {
        String resourceName = ApplicationProperties.getProps().getProperty(property);
        if (resourceName == null) {
            DBMTLogger.error(Channel.DEV, "Unabel to find value for property " + property);
            return;
        }
        this.addInteractorLayoutsFromResource(resourceName);
    }

    private void addInteractorLayoutsFromResource(String resourceName) {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            InputStream input = ClassLoader.getSystemClassLoader().getResourceAsStream(resourceName);
            if (input == null) {
                DBMTLogger.error(Channel.DEV, "Unable to find the resource (" + resourceName + ")");
                return;
            }
            parser.parse(input, (DefaultHandler)new GUIInteractorXMLParserHandler(this.m_wizMap, this.m_dlgMap));
            return;
        }
        catch (Throwable e) {
            DBMTLogger.error(Channel.USER, "Unable to load interactor layouts from " + resourceName + ": " + e);
            e.printStackTrace();
            return;
        }
    }

    public static final void addFromProperty(String propertyName) {
        LayoutManager.inst().addInteractorLayoutsFromProperty(propertyName);
    }

    public static final void addFromResource(String resourceName) {
        LayoutManager.inst().addInteractorLayoutsFromResource(resourceName);
    }

    public static WizardLayoutMap getWizardLayouts(String actionPath, WizardInteractorData data) {
        Map<String, GUILayoutSpec> map = LayoutManager.inst().m_wizMap.get(actionPath);
        if (map == null) {
            return new WizardLayoutMap(s_emptyMap, data);
        }
        return new WizardLayoutMap(map, data);
    }

    public static GUILayoutSpec getDialogLayout(String actionPath) {
        GUILayoutSpec layout = LayoutManager.inst().m_dlgMap.get(actionPath);
        if (layout == null) {
            return new GUILayoutSpec(new StandardWizardLayoutLogic(), new HashMap<String, String>());
        }
        return layout;
    }

    public static class WizardLayoutMap {
        private final Map<String, GUILayoutSpec> m_map = new HashMap<String, GUILayoutSpec>();
        private final WizardInteractorData m_data;

        public WizardLayoutMap(Map<String, GUILayoutSpec> map, WizardInteractorData data) {
            this.m_map.putAll(map);
            this.m_data = data;
        }

        public final GUILayoutSpec get(String pageId, GuiWizardRunner runner) {
            if (this.m_data.isCommit(pageId)) {
                return new GUILayoutSpec(new CommitPageLayoutLogic(), new HashMap<String, String>());
            }
            return this.m_map.get(pageId);
        }
    }
}

