/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui;

import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.ActionContext;
import com.primavera.database.tools.dbmt.ActionLogicManager;
import com.primavera.database.tools.dbmt.ActionLogicManagerImpl;
import com.primavera.database.tools.dbmt.ActionLogicTreeNode;
import com.primavera.database.tools.dbmt.ActionOperation;
import com.primavera.database.tools.dbmt.Application;
import com.primavera.database.tools.dbmt.ExtentionLoadedListener;
import com.primavera.database.tools.dbmt.ExtentionManager;
import com.primavera.database.tools.dbmt.MenuLoader;
import com.primavera.database.tools.dbmt.gui.ApplicationEventMultiplexer;
import com.primavera.database.tools.dbmt.gui.ApplicationUIListener;
import com.primavera.database.tools.dbmt.gui.ApplicationUIState;
import com.primavera.database.tools.dbmt.gui.ApplicationUIStateFactory;
import com.primavera.database.tools.dbmt.gui.LayoutManager;
import com.primavera.database.tools.dbmt.gui.MenuDefinition;
import com.primavera.database.tools.dbmt.gui.Workspace;
import com.primavera.database.tools.dbmt.gui.model.ContextMenuUtil;
import com.primavera.database.tools.dbmt.gui.renderers.DefaultTreeRenderer;
import com.primavera.database.tools.dbmt.gui.util.ExitOnWindowClose;
import com.primavera.database.tools.dbmt.xml.BaseActionMap;
import com.primavera.database.tools.dbmt.xml.MenuActionMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;

public class ApplicationUI
extends ApplicationEventMultiplexer
implements ApplicationUIListener,
ExtentionLoadedListener {
    private static final ApplicationUI s_ui = new ApplicationUI();
    private final JSplitPane m_splitter = new JSplitPane(1);
    private Application m_app;
    private final JFrame m_mainFrame = new JFrame(StringLocalizer.get("dbmt.mainframe.title"));
    private final JTree m_connectionTree = new JTree();
    private final JPanel m_workspacePanel = new JPanel();
    private final JMenuBar m_mainMenuBar = new JMenuBar();
    private final MenuLoader m_menuLoader = new MenuLoader();
    ApplicationUIState m_uiState = ApplicationUIStateFactory.createUIState();

    private ApplicationUI() {
        ExtentionManager.inst().addListener(this);
    }

    public static ApplicationUI inst() {
        return s_ui;
    }

    public void initializeMainMenu(JMenuBar mainMenuBar, ApplicationUIState uiState, Application app) {
        ApplicationUI.initializeActionLogicActions(this.m_app);
        ExtentionManager extentions = ExtentionManager.inst();
        for (String res : extentions.getExtentionResources("menus")) {
            MenuDefinition menuDef = this.getApplicationMenuLoader().loadFromResource(res);
            if (menuDef.isMain()) {
                menuDef.addToMenuBar(mainMenuBar);
                continue;
            }
            ContextMenuUtil.mergeMenuDef(menuDef.getContext(), menuDef);
        }
        for (String res : extentions.getExtentionResources("layouts")) {
            LayoutManager.addFromResource(res);
        }
    }

    private final void setConnectionTree(JComponent comp) {
        this.m_splitter.setLeftComponent(comp);
    }

    public final void setWorkspace(Workspace wkspc) {
        this.m_workspacePanel.add((Component)wkspc.getRoot(), "Center");
    }

    private final JComponent initializeWorkspacePanel(JPanel workspace) {
        workspace.setPreferredSize(new Dimension(200, 200));
        workspace.setLayout(new BorderLayout());
        return workspace;
    }

    private static final void initializeMainFrame(JFrame frame) {
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)ApplicationUI.inst().m_splitter, "Center");
        frame.addWindowListener(new ExitOnWindowClose());
        Point location = ApplicationUI.defaultWindowPosition();
        frame.setLocation(location);
        ApplicationUI.setIcon(frame);
    }

    public static void setIcon(Window window) {
        try {
            BufferedImage appIcon = ImageIO.read(ClassLoader.getSystemResource("com/primavera/database/tools/dbmt/gui/oracle32x32.gif"));
            if (appIcon != null) {
                window.setIconImage(appIcon);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Point defaultWindowPosition() {
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        return new Point(gd.getDisplayMode().getWidth() / 4, gd.getDisplayMode().getHeight() / 4);
    }

    public static JComponent initializeConnectionTree(JTree tree, ApplicationUIState state, Application app) {
        JScrollPane treeScrollPane = new JScrollPane(tree);
        tree.setSelectionModel(state.getConnectionTreeSelectionModel());
        tree.setModel(state.getConnectionTreeModel());
        state.getConnectionTreeModel().setApplication(app);
        tree.setCellRenderer(new DefaultTreeRenderer());
        tree.setComponentPopupMenu(state.getConnectionTreeSelectionModel().getPopupMenu());
        tree.setRootVisible(true);
        tree.setPreferredSize(new Dimension(200, 100));
        return treeScrollPane;
    }

    public synchronized void setApplication(Application app) {
        if (this.m_app != null) {
            this.disconnect(this.m_app);
        }
        this.m_app = app;
        if (app != null) {
            this.connect(app);
        }
    }

    @Override
    public void workspaceChanged(Workspace newWorkspace) {
        Workspace wkspc = this.m_uiState.getWorkspace();
        this.m_listeners.remove(newWorkspace);
        wkspc.disconnect(this.m_uiState);
        this.m_uiState.setWorkspace(newWorkspace);
        if (newWorkspace == null) {
            return;
        }
        newWorkspace.connect(this.m_uiState);
        this.m_listeners.add(newWorkspace);
    }

    public void show() {
        ApplicationUI.initializeMainFrame(this.m_mainFrame);
        this.setConnectionTree(ApplicationUI.initializeConnectionTree(this.m_connectionTree, this.m_uiState, this.m_app));
        this.m_splitter.setRightComponent(this.initializeWorkspacePanel(this.m_workspacePanel));
        this.initializeMainMenu(this.m_mainMenuBar, this.m_uiState, this.m_app);
        this.m_mainFrame.setJMenuBar(this.m_mainMenuBar);
        DBMTLogger.debug(Channel.DEV, "The MainMenu's Parent is MainFrame? " + (this.m_mainMenuBar.getParent() == this.m_mainFrame.getRootPane()));
        DBMTLogger.debug(Channel.DEV, "The Menu Bar is " + this.m_mainFrame.getJMenuBar());
        DBMTLogger.debug(Channel.DEV, "The Menu Count  is " + this.m_mainFrame.getJMenuBar().getMenuCount());
        this.m_mainFrame.pack();
        this.m_mainFrame.setVisible(true);
        DBMTLogger.debug(Channel.DEV, "The MainMenu's Parent is " + this.m_mainMenuBar.getParent());
        DBMTLogger.debug(Channel.DEV, "The MainMenu's Parent is MainFrame? " + (this.m_mainMenuBar.getParent() == this.m_mainFrame.getRootPane()));
    }

    public static void initializeActionLogicActions(Application app) {
        MenuActionMap aoMgr = MenuActionMap.inst();
        ActionLogicManager alMgr = ActionLogicManagerImpl.inst();
        ActionLogicTreeNode root = alMgr.getRoot();
        ApplicationUI.walkAndAddActions(root, aoMgr);
        aoMgr.onContextChanged(new ActionContext(app));
    }

    private static void walkAndAddActions(ActionLogicTreeNode node, BaseActionMap aoMgr) {
        for (ActionOperation aOp : node.getActionMap().values()) {
            if (aOp == null) continue;
            aoMgr.addAction(aOp.getActionPath(), aOp);
        }
        for (ActionLogicTreeNode subNode : node.getActionSetMap().values()) {
            ApplicationUI.walkAndAddActions(subNode, aoMgr);
        }
    }

    @Override
    public void onExtentionLoaded(ExtentionManager extentions) {
        for (String res : extentions.getExtentionResources("menus")) {
            MenuDefinition menuDef = this.getApplicationMenuLoader().loadFromResource(res);
            if (menuDef.isMain()) {
                menuDef.addToMenuBar(this.m_mainMenuBar);
                continue;
            }
            ContextMenuUtil.mergeMenuDef(menuDef.getContext(), menuDef);
        }
        for (String res : extentions.getExtentionResources("layouts")) {
            LayoutManager.addFromResource(res);
        }
    }

    public MenuLoader getApplicationMenuLoader() {
        return this.m_menuLoader;
    }

    public final JFrame getMainFrame() {
        return this.m_mainFrame;
    }
}

